#!/bin/bash

rootfs_tgz=$1
CROSS_DIR=v3t_build_env_mini_with_kernel

LIB_SET="libdemo"
APP_SET="appdemo"
PRJ_NAME=prj_mifi

RSYNC_OPT="rsync -aq --delete --exclude=.svn --exclude=.git"


function  copy_files()
{
  SRC_DIR=$1
  DEST_DIR=$2
  mkdir -p $DEST_DIR
  $RSYNC_OPT  $SRC_DIR $DEST_DIR
}

rm -fr $CROSS_DIR
rm -fv $CROSS_DIR.tar.gz
mkdir -p $CROSS_DIR

#
copy_files  ./build/  $CROSS_DIR/build/

#ap/libc
if [ -d ./ap2/libc ]; then
  copy_files  ./ap2/libc/  $CROSS_DIR/ap/libc/
fi

#ap/build
copy_files  ./ap2/build/   $CROSS_DIR/ap/build/

#prj
copy_files  ./ap2/project/zx297520v3/$PRJ_NAME/ $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/
cp -v ./ap2/project/pubconf.mk   $CROSS_DIR/ap/project/
echo "export CONFIG_SDK_KERNEL ?= yes" >> $CROSS_DIR/ap/project/pubconf.mk
cp -v ./ap2/project/zx297520v3/chip_pubconf.mk  $CROSS_DIR/ap/project/zx297520v3/
rm -fr $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/recovery
if [ x"$rootfs_tgz" = x"" ]; then
  echo "skip rootfs_tgz merge"
else
  rm -fr ./rootfs/
  tar xf $rootfs_tgz
  rm -rf  ./rootfs/lib/cpko
  copy_files  ./rootfs/ $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/fs/normal/rootfs/
  echo "rootfs_tgz merge ok"
fi

cp -v ./ap2/Makefile   $CROSS_DIR/ap/

#demo lib
mkdir -p $CROSS_DIR/ap/lib/
for item in $LIB_SET;do
  copy_files  ./ap2/lib/$item/ $CROSS_DIR/ap/lib/$item/
done
echo "zte_lib:=$LIB_SET" > $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/config_lib.mk
copy_files  ./ap2/lib/libps/ $CROSS_DIR/ap/lib/libps/
cp -v ./ap2/lib/Makefile $CROSS_DIR/ap/lib/

#demo app
mkdir -p $CROSS_DIR/ap/app/
for item in $APP_SET;do
  copy_files  ./ap2/app/$item/ $CROSS_DIR/ap/app/$item/
done
copy_files  ./ap2/app/test_tools/ $CROSS_DIR/ap/app/test_tools/
echo "zte_app:=$APP_SET" > $CROSS_DIR/ap/project/zx297520v3/$PRJ_NAME/config/normal/config_app.mk
cp -v ./ap2/app/Makefile $CROSS_DIR/ap/app/

#linux kernel
echo "sync linux kernel"
copy_files  ./ap2/os/   $CROSS_DIR/ap/os/

#pub for kernel
copy_files  ./pub/   $CROSS_DIR/pub/
copy_files  ./cp/   $CROSS_DIR/cp/
copy_files  ./tools/   $CROSS_DIR/tools/

#fix and clean
mkdir -p $CROSS_DIR/ap/app/busybox/src/configs


echo "compress files to ${CROSS_DIR}.tar.gz"
tar -czf  ${CROSS_DIR}.tar.gz  $CROSS_DIR/
echo "all done"
