#ifndef __ZTE_VSIM_API_H_
#define __ZTE_VSIM_API_H_
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <sys/socket.h>
//********2023-01-13***********//

#define SIM_IMSI_LEN_MAX          16  /**  Maximum length of IMSI data. */
#define SIM_ICCID_LEN_MAX         21  /**  Maximum length of ICCID data. */
#define DATA_MAX_APN_LEN          57  /**  Maximum length of the APN. */
#define DATA_MAX_USERNAME_LEN     127 /**  Maximum length of the profile user name. */
#define DATA_MAX_PASSWORD_LEN     127 /**  Maximum length of the profile password. */
#define DATA_INTERFACE_NAME_LEN   16  /**  Interface name length. */
#define DATA_MAX_ADDR_COUNT       2   /**  Maximum number of IP addresses. */

//**************GHT VSIM Struct*********************//

typedef enum {
    E_SIM_TYPE_USIM, //ʵ忨
    E_SIM_TYPE_VSIM, //ƿ
    E_SIM_TYPE_SSIM, //Soft SIM
}SimTypeInSlot_t;


typedef enum {
    E_NW_RADIO_IF_NO_SRV = 0,
    E_NW_RADIO_IF_GSM = 1,
    E_NW_RADIO_IF_WCDMA = 2,
    E_NW_RADIO_IF_LTE = 3,
    E_NW_RADIO_IF_TDSCDMA = 4,
    E_NW_RADIO_IF_CDMA = 5,
    E_NW_RADIO_IF_CDMA2000 = 6,
}e_nw_rat_type_t;  //RAT value


typedef enum {
    E_NW_STATUS_SRV_NONE = 0,
    E_NW_STATUS_SRV_LIMITED = 1,
    E_NW_STATUS_SRV_AVAILABLE = 2,
}e_nw_srv_status_t;


typedef struct
{
	uint32_t tac;
	uint32_t cell_id;
	uint32_t roamingFlag; ///< 1:roaming,0:non roaming
}lte_scell_info_t;

typedef struct
{
	uint32_t lac;
	uint32_t cell_id;
}gsm_w_scell_info_t;



typedef struct
{
    e_nw_rat_type_t    curr_rat;
	e_nw_srv_status_t  nStatus;
	lte_scell_info_t   lte_scell_info;   //ֵѡûratָʾȡֵ
	gsm_w_scell_info_t gsm_w_scell_info; //ֵѡûratָʾȡֵ
}RegInfo_t;

typedef struct{
    uint16_t mcc;
    uint16_t mnc;
	uint32_t tac;
	uint32_t cell_id;
    uint16_t bandwidth;
    uint16_t pcid;//int16_t  rxlev;
    uint32_t arfcn;
}base_cell_info_t;//Hex format


typedef struct
{
    uint16_t  roamingFlag; ///< 1:roaming,0:non roaming
    int16_t  rsrp;
    int16_t  rsrq;
    uint16_t SINR;
    uint16_t netMode;  //0--tdd  1--fdd
    uint16_t band;
    base_cell_info_t base_Scell_info;
} lte_Scell_t;

typedef struct
{
    int16_t rsrp;
    int16_t rsrq;
    uint16_t netMode;  //0--tdd  1--fdd
    base_cell_info_t base_Ncell_info;
}lte_Ncell_t;

typedef struct
{
    uint16_t bsic; //only in GSM
    uint16_t band;
    uint16_t rscp; //only in W
    base_cell_info_t base_Ncell_info;
}gsm_W_Scell_t;


typedef struct
{
    uint16_t bsic; //only GSM
    uint16_t band;
    uint16_t rscp; //only in W
    base_cell_info_t base_Ncell_info;
}gsm_W_Ncell_t;

typedef struct
{
    lte_Scell_t     lteScell;
    uint16_t      lteNcellNum;
    lte_Ncell_t   lteNcell[6];
}lte_cellinfo_t;

typedef struct{
	gsm_W_Scell_t   scell_info;
    uint16_t   gsm_W_NcellNum;
    gsm_W_Ncell_t gsm_W_ncell[6];
}gsm_W_cellifo_t;

typedef struct{
	e_nw_rat_type_t    curr_rat;
    e_nw_srv_status_t  service_status; //0x00: in service; 0x01: not in
	lte_cellinfo_t   lte_cellinfo;
	gsm_W_cellifo_t  gsm_cellinfo;
}CellInfo_t;


typedef struct{
  uint32_t lwip_ul;
  uint32_t lwip_dl;
  uint32_t ppp_ul;
  uint32_t ppp_dl;
  uint32_t rndis_ul;
  uint32_t rndis_dl;
}NetInfo_t;  /**< λ: bit*/

typedef enum
{
    E_DATA_IP_FAMILY_UNKNOWN         = 0x00,    /**<  unknown  */
    E_DATA_IP_FAMILY_IPV4            = 0x04,    /**<  IPv4  */
    E_DATA_IP_FAMILY_IPV6            = 0x06,    /**<  IPv6  */
    E_DATA_IP_FAMILY_IPV4V6          = 0x0A    /**<  IPv4|IPv6  */
}e_data_ip_family_t;

typedef enum
{
    E_DATA_TECH_PREF_UNKNOWN         = 0x00,    /**<  unknown  */
    E_DATA_TECH_PREF_UMTS            = 0x01,    /**<  UMTS  */
    E_DATA_TECH_PREF_CDMA            = 0x02,    /**<  CDMA  */
    E_DATA_TECH_PREF_LTE             = 0x03,    /**<  LTE  */
    E_DATA_TECH_PREF_AUTO            = 0x04     /**<  AUTO  */
}e_data_tech_pref_t;

typedef enum
{
    E_AUTH_PREF_PAP_CHAP_NOT_ALLOWED  = 0x00,
    E_AUTH_PREF_PAP_ONLY_ALLOWED      = 0x01,
    E_AUTH_PREF_CHAP_ONLY_ALLOWED     = 0x02,
    E_AUTH_PREF_PAP_CHAP_BOTH_ALLOWED = 0x03
}e_data_auth_pref_t;


typedef struct
{
    uint8_t            profile_valid;                        /**< Must be set to TRUE if umts_profile is being passed. */
    uint8_t            profile_id;                           /**< profile ID. as well as called cid*/
    uint8_t            ip_family_valid;                      /**< Must be set to TRUE if ip_family is being passed. */
    e_data_ip_family_t ip_family;                            /**< Data IP Family */
    uint8_t            apn_name_valid;                       /**< Must be set to TRUE if apn_name is being passed. */
    char               apn_name[DATA_MAX_APN_LEN+1];         /**< Data APN Name. A character string that identifies a PDN*/
    uint8_t            user_name_valid;                      /**< Must be set to TRUE if user_name is being passed. */
    char               user_name[DATA_MAX_USERNAME_LEN+1];   /**< Username for the APN. */
    uint8_t            password_valid;                       /**< Must be set to TRUE if password is being passed. */
    char               password[DATA_MAX_PASSWORD_LEN+1];    /**< Password for the APN. */
    uint8_t            auth_pref_valid;                      /**< Must be set to TRUE if tech_pref is being passed. */
    e_data_auth_pref_t auth_pref;                            /**< Data auth Preference */
    uint8_t            tech_pref_valid;                      /**< Must be set to TRUE if tech_pref is being passed. */
    e_data_tech_pref_t tech_pref;                            /**< Data Tech Preference */
}Data_call_config_info_t;


typedef struct
{
    char   addr_valid;                       /**< Indicates whether a valid address is available. */
    struct sockaddr_storage addr;            /**< Stores the IP address. defined in kernel socket.h*/
}data_call_addr_t;

typedef struct
{
    data_call_addr_t      iface_addr_s;      /**< Network interface address. */
    uint32_t              iface_mask;        /**< Subnet mask.             */
    data_call_addr_t      gtwy_addr_s;       /**< Gateway server address.  */
    uint32_t              gtwy_mask;         /**< Gateway mask.            */
    data_call_addr_t      dnsp_addr_s;       /**< Primary DNS server address.   */
    data_call_addr_t      dnss_addr_s;       /**< Secondary DNS server address. */
}data_call_addr_info_t;

typedef struct
{
    char                  iface_name[DATA_INTERFACE_NAME_LEN + 1]; /**< Network interface name. */
    uint8_t               addr_info_len;                           /**< Must be set to the number of elements in addr_info. */
    data_call_addr_info_t addr_info[DATA_MAX_ADDR_COUNT];          /**< Data device address list. */
}Data_call_addr_info_list_t;

typedef enum{
  E_RF_RESOURCE_CALLBACK_EVENT = 0x00,   /**< ƵԴл. */
  E_NW_ATTACH_COMMPLETE_EVENT  = 0x32,   /**< ע. */
  E_DATA_PDN_ACT_SUCC_EVENT = 0x64,      /**< PDN ,ind_dataЯZGIPDNS:ַϢ  */
  E_GET_CELLINFO_BY_SIMID_EVENT  = 0x65,	 /**< ɨ. */
}E_MODEM_EVENT_ID;

typedef enum
{
    E_SIM_STAT_NOT_INSERTED = 0x00,
    E_SIM_STAT_READY        = 0x01,
    E_SIM_STAT_PIN          = 0x02,
    E_SIM_STAT_PUK          = 0x03,
    E_SIM_STAT_BUSY         = 0x04,
    E_SIM_STAT_UNKNOWN      = 0x05,
}E_SIM_STATUS;


/*********************************************************************
** ƣ VSIM_COMMAND
**  ModemVSIMAPDUͨŽӿںĽṹ壻
**       ͶĺҪͨzte_atVsimInitӿע
** 
*********************************************************************/

typedef int (*VSIM_COMMAND)(uint8_t *apdu_req, uint16_t apdu_req_len,uint8_t *apdu_rsp, uint16_t *apdu_rsp_len, uint8_t slot);
typedef int (*SoftSim_COMMAND)(uint8_t *apdu_req, uint16_t apdu_req_len,uint8_t *apdu_rsp, uint16_t *apdu_rsp_len, uint8_t slot);
/*********************************************************************
** ƣ zte_mdm_event_ind_callback
**  Ϣ¼֪ͨĽṹ
** ind_dataƽ̨Զ
** RFԴԭ1. For SIM1 TAU; 2. For SIM1 Regist Network;3. NULL;
** 
*********************************************************************/

typedef int32_t (*zte_mdm_event_ind_callback)(E_MODEM_EVENT_ID event_id, void *ind_data, uint32_t  ind_data_len);

/*********************************************************************
** ƣ zte_mdm_event_regist
**  
**  Ϣ¼֪ͨעڣṩͻעϢ;
**   modem¼ind_cb֪ͨͻ
*********************************************************************/
extern int32_t zte_mdm_event_regist(zte_mdm_event_ind_callback ind_cb);


/*********************ZTE VSIM API***************************/

extern int32_t zte_atVsimInit(VSIM_COMMAND vsim_apdu_process_fn, uint8_t nSimID);

extern int32_t zte_atVsimClose(VSIM_COMMAND vsim_apdu_process_fn, uint8_t nSimID);

extern int32_t zte_atVsimReset(void);

//extern int16_t zte_SetSimWorkMode(SimTypeInSlot_t SimType, uint8_t nSoltID);

//extern int16_t zte_GetSimWorkMode(SimTypeInSlot_t *SimType, uint8_t nSoltID);

extern int32_t zte_SetGTDUALSIM(uint8_t nSimID);

extern int32_t zte_GetGTDUALSIM(uint8_t *nSimID);

extern int32_t zte_SetGTDATASIM(uint8_t nSimID);

extern int32_t zte_GetGTDATASIM(uint8_t *nSimID);

extern int32_t zte_SetCfunMode(uint8_t mode);

extern int32_t zte_GetCfunMode(uint8_t *mode);

extern int32_t zte_SetIMEIbySimId(uint8_t *imei, uint8_t imei_len, uint8_t nSimID);

extern int32_t zte_GetIMEIbySimId(uint8_t *imei, uint8_t imei_len, uint8_t nSimID);

extern int32_t zte_GetCCIDbySimId(uint8_t *ccid, uint8_t ccid_len, uint8_t nSimID);

extern int32_t zte_GetMCCMNCbySimId(char *mcc, char *mnc, uint8_t nSimID);

extern int32_t zte_SwitchSimHandle(uint8_t mode);

extern int32_t zte_GetCSQbySimId(int32_t *rssi, int32_t *ber, uint8_t nSimID);

extern int32_t zte_GetRegInfobySimid(RegInfo_t *reg_info, uint8_t nSimID);

extern int32_t zte_GetCellInfobySimId(uint8_t nSimID);

extern int32_t zte_GetNetInfobySimId(NetInfo_t *pNetInfo, uint8_t nSimID);

extern int32_t zte_SetAPNbySimID(Data_call_config_info_t *data_call, uint8_t nSimID);

extern int32_t zte_StartDataCallbySimId(Data_call_config_info_t *data_call, uint8_t nSimID);

extern int32_t zte_StopDataCallbySimId(uint8_t profile_id, uint8_t nSimID);

extern int32_t zte_GetDataAddrbySimID(uint8_t profile_id, Data_call_addr_info_list_t *addr_list, uint8_t nSimID);

extern int32_t zte_GetSimStatusbySimId(E_SIM_STATUS *sim_status, uint8_t nSimID);

extern int32_t zte_SendATbySimId(char *req_at, char *info_fmt, void **pval, uint8_t nSimID);
/********************ZTE VSIM API END****************************/


#endif //#ifndef __ZTE_VSIM_API_H_

