#include <linux/module.h>   
#include <linux/kernel.h>   
#include <linux/fs.h>   
#include <linux/init.h>   
#include <linux/delay.h>   
#include <linux/irq.h>   
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/if_bridge.h>
#include <asm/uaccess.h>   
#include <asm/irq.h>   
#include <asm/io.h>   
#include <linux/device.h>   
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/jhash.h>
#include <linux/netdevice.h>
#include <net/SI/netioctl.h>
#ifdef NETLINK_UC 
#include "../../../../drivers/net/fast6/fast6.h"
#include "../../../../drivers/net/fastnat/fastnat.h"
#else
#include <net/SI/fastnat.h>
#include <net/SI/fast6.h>
#endif



static int netioctl_ioctl(struct file *filp, unsigned int cmd, unsigned long arg)  
{
    int ret = -1;

    if(_IOC_TYPE(cmd) != NIOCTL_MAGIC)
        return -EINVAL;
    
    if(_IOC_NR(cmd) > NIOCTL_MAX_NR)
        return -EINVAL;

    switch(cmd){
		/*ӡָУskbͷʱdump stackϢ */
		case NIOCGSKBDUMP:
			ret = set_skb_dump(arg); break;
       
        /* ӡ豸շϢ豸״̬Ϣ */
        case NIOCGSTATS:
            ret = get_dev_info(arg); break;

		/* ӡskbϢ */
		case NIOCGSKBNUM:
            ret = get_skb_using(arg); break;
        /* ں˲ͨýӿڣfastnatfastbrleakȲ*/
        case NIOCSKPARAM:
            ret = set_kernelparam(arg); break;
		/* ӡָں˲ǰֵ */
        case NIOCGKPARAM:
            ret = get_kernelparam(arg); break;
		/* ץ */
        case NIOCSTCPDUMP:
            ret = set_tcpdump_opt(arg); break;
        case NIOCGPCINFO:
            ret = network_get_pcmac(arg); break;
		/* slab Ϣ*/
        case NIOCGSLAB:
            ret = get_slab_info(arg); break;
        /*ȡinit_net豸Ϣ*/
        case NIOCGDEVLIST:
            ret = get_devlist_info(arg); break;
        case NIOCGSKBFAST:
            ret = get_skb_fast(arg); break;
        case NIOCGMAXMSG:
            ret = get_max_msg(arg); break;
        case NIOCGPTYPE:
            ret = get_ptype(arg); break;
		case NIOCGPSINFO:
			ret = get_process_info(arg); break;
        case NIOCGHASH:
            ret = get_hash_info(arg); break;
        case NIOCGPKTLOST:
            ret = get_pkt_lost_info(arg); break;
        case NIOCGTCPSOCKSTATS:
            ret = get_tcp_stat_info(arg); break;
        default:
            return -EINVAL;
    }  

    return ret;
}  

static int netioctl_open(struct inode *inode, struct file *file)
{
    printk(" network ioctl device is open!\n");
    return 0;
}

static struct file_operations netioctl_fops = {
    .owner          =   THIS_MODULE,
    .open           =   netioctl_open,
    .unlocked_ioctl =   netioctl_ioctl,
};

static int __init netioctl_init(void)
{
    int err;

    err = register_chrdev(NETIOCTL_MAJOR, "netioctl_init", &netioctl_fops);
    if (err < 0) {
        printk("[comlee]:unable to register  network ioctl device\n");
        return -1;
    }

    return 0;
}

static void __exit netioctl_exit(void)
{
    unregister_chrdev(NETIOCTL_MAJOR, "netioctl");
    printk(" network ioctl has been unregistered!\n");
}

module_init(netioctl_init);
module_exit(netioctl_exit);
MODULE_LICENSE("GPL");
MODULE_AUTHOR("Com.Lee");

