/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-3-4
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include <linux/types.h>
#include <usb/common.h>
#include <command.h>
#include <common.h>
#include <net.h>
#include <usb/usb_config.h>
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
/****************************************************************************
*							Local Types
****************************************************************************/

/****************************************************************************
*							Global Variables
****************************************************************************/
int  dl_serial_initial = 0;
/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
extern int tsp_usb_init(void);
extern WORD32 usb_read(WORD32 dwLen, BYTE *pchBuf);


extern WORD32 usb_write(WORD32 dwLen, BYTE *pchBuf);

extern int UART_Read(char *pchBuf, int dwLen);
extern int UART_Write(char *pchBuf, int dwLen);
/****************************************************************************
*							Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function:downloader_serial_init
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void downloader_serial_init(void)
{
#if CONFIG_USB_DL
     usb_boot(SYS_USB_BASE); 	/*usb*/
#endif
	 dl_serial_initial =1;	
}
/*******************************************************************************
 * Function:downloader_serial_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 unsigned int g_testLen = 0;
unsigned int g_testAddr = 0;
unsigned int g_testFlag1 = 0;
int downloader_serial_read(char * buffer,unsigned int len)
{
	int ret = 0;

	if(!dl_serial_initial)
		return 0;
 	g_testAddr = (unsigned int)&len;
#if CONFIG_USB_DL
	ret = usb_read(len,buffer);
#else
	ret = UART_Read(buffer,len);
#endif
    g_testLen = len;
    g_testFlag1 = 1;
 	if(!ret)
		{
			return 0; /*error return 0*/
		}
	else
		{
            
			return ret;/*actual length*/
		}
}
/*******************************************************************************
 * Function:downloader_serial_read_actuallen
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int downloader_serial_read_actuallen(char * buffer,unsigned int len)
{
	char* pBuffer = buffer;
	uint  readLength = 0;
	uint  length = 0;
	//printf("start to rececive len = %d \n",len);
#if CONFIG_USB_DL
	while(readLength < len)
		{
			length = downloader_serial_read(pBuffer,512);
            //printf(" receiving len = %d \n",length);
			if(length)
				{
					readLength += length;
                    //printf(" readLength = %d \n",readLength);
					pBuffer += length;
				}
			else
				{
					continue;
				}
		}
    //printf("finish receiving len = %d \n",len);
#else

    length = downloader_serial_read(pBuffer,len);
#endif
	return 0;
}

/*******************************************************************************
 * Function:downloader_serial_write
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int downloader_serial_write(const char * buffer,unsigned int len)
{
	if(!dl_serial_initial)
		return 0;
	
#if CONFIG_USB_DL
	return usb_write(len,(char *)buffer);
#else
	return UART_Write((char *)buffer,len);
#endif
}
/*******************************************************************************
 * Function:downloader_serial_write_actuallen
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int downloader_serial_write_actuallen(const char * buffer,unsigned int len)
{
	const char* pBuffer = buffer;
	uint  writeLength = 0;
	uint  length = 0;
    
	/*need modify*/
	while(writeLength < len)
		{
            
            length = MIN(len-writeLength,136192);
            //printf("prepare to write len=%d\n",length);
			downloader_serial_write(pBuffer,length);
            //printf("this time usb write len=%d\n",length);
			writeLength += length;
			//printf("usb have writen len=%d\n",writeLength);
			
			pBuffer += length;
		}
	return 0;
}

