/*******************************************************************************
 * Copyright (C) 2008, ZTE Corporation.
 *
 * File Name: dma_cfg.h
 * File Mark:
 * Description:define dma ram config

 * Others:
 * Version:       v0.1
 * Author:        wangxia
 * Date:          2016-02-18
 * History 1:
 *     Date:       2016-03-23
 *     Version:
 *     Author:    wangxia
 *     Modification:  add IRAM0 config
 *                    
 * History 2:
  ********************************************************************************/

#ifndef _DMA_CFG_H
#define _DMA_CFG_H
/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "ram_config.h"
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

//#define DMA_RAM_BASE_ADDR  DDR_BASE_ADDR_DRV 
#define DMA_RAM_SIZE  DDR_BASE_LEN_DRV    /*6.5M*/

/*for EDCP, 64k*/
#define DMA_RAM_FOR_EDCP_ADDR_BASE (DMA_RAM_BASE_ADDR)
#define DMA_RAM_FOR_EDCP_SIZE 0x10000

/*for UART, 64k*/
#define DMA_RAM_FOR_UART_ADDR_BASE (DMA_RAM_FOR_EDCP_ADDR_BASE + DMA_RAM_FOR_EDCP_SIZE)
#define DMA_RAM_FOR_UART_SIZE 0x10000

/* SD */
#define DMA_RAM_FOR_SD_ADDR_BASE (DMA_RAM_FOR_UART_ADDR_BASE + DMA_RAM_FOR_UART_SIZE)
#define DMA_RAM_FOR_SD_SIZE  0x30000//0x10000



/*for USB, 2M  */
#define DMA_RAM_FOR_USB_ADDR_BASE (DMA_RAM_BASE_ADDR + 0x80000)
#define DMA_RAM_FOR_USB_SIZE 0x80000



#if 0
/*for I2S,120k*/
#define DMA_RAM_FOR_I2S_ADDR_BASE (DMA_RAM_FOR_USB_ADDR_BASE+DMA_RAM_FOR_USB_SIZE)
#define DMA_RAM_FOR_I2S_SIZE 0x1E000

/*for F8,5k*/
#define DMA_RAM_FOR_F8_ADDR_BASE (DMA_RAM_FOR_I2S_ADDR_BASE + DMA_RAM_FOR_I2S_SIZE)
#define DMA_RAM_FOR_F8_SIZE 0x1400

/*for F9,5k*/
#define DMA_RAM_FOR_F9_ADDR_BASE (DMA_RAM_FOR_F8_ADDR_BASE + DMA_RAM_FOR_F8_SIZE)
#define DMA_RAM_FOR_F9_SIZE 0x1400

/*for UART, 64k*/
#define DMA_RAM_FOR_UART_ADDR_BASE (DMA_RAM_FOR_F9_ADDR_BASE + DMA_RAM_FOR_F9_SIZE)
#define DMA_RAM_FOR_UART_SIZE 0x10000

/*for NAND, 64k*/
#define DMA_RAM_FOR_NAND_ADDR_BASE (DMA_RAM_FOR_UART_ADDR_BASE + DMA_RAM_FOR_UART_SIZE)
#define DMA_RAM_FOR_NAND_SIZE 0x10000

/*for EDCP, 64k*/
#define DMA_RAM_FOR_EDCP_ADDR_BASE (DMA_RAM_FOR_NAND_ADDR_BASE + DMA_RAM_FOR_NAND_SIZE)
#define DMA_RAM_FOR_EDCP_SIZE 0x10000

/*for DMA LLI 32K*/
#define DMA_RAM_FOR_DMA_LLI_ADDR_BASE (DMA_RAM_FOR_EDCP_ADDR_BASE+DMA_RAM_FOR_EDCP_SIZE)
#define DMA_RAM_FOR_DMA_LLI_SIZE  0x8000

/*for SSP 256K*/
#define DMA_RAM_FOR_SSP_ADDR_BASE (DMA_RAM_FOR_DMA_LLI_ADDR_BASE+DMA_RAM_FOR_DMA_LLI_SIZE)
#define DMA_RAM_FOR_SSP_SIZE   0x10000

/*for WIFI  512KAPʹ*/
#define DMA_RAM_FOR_WIFI_ADDR_BASE (DMA_RAM_FOR_SSP_ADDR_BASE+DMA_RAM_FOR_SSP_SIZE)
#define DMA_RAM_FOR_WIFI_SIZE     0x80000

/*for GMAC  512KAPʹ*/
#define DMA_RAM_FOR_GMAC_ADDR_BASE (DMA_RAM_FOR_WIFI_ADDR_BASE+DMA_RAM_FOR_WIFI_SIZE)
#define DMA_RAM_FOR_GMAC_SIZE     0x80000

/*for CAM	616K*/
#define DMA_RAM_FOR_CAM_ADDR_BASE (DMA_RAM_FOR_GMAC_ADDR_BASE+DMA_RAM_FOR_GMAC_SIZE)
#define DMA_RAM_FOR_CAM_SIZE     0x9a000

/* SD */
#define DMA_RAM_FOR_SD_ADDR_BASE (DMA_RAM_FOR_CAM_ADDR_BASE + DMA_RAM_FOR_CAM_SIZE)
#define DMA_RAM_FOR_SD_SIZE  0x30000//0x10000
#endif


//#define DMA_RAM_CONFIG_END (DMA_RAM_FOR_SD_ADDR_BASE+DMA_RAM_FOR_SD_SIZE)

//#if DMA_RAM_CONFIG_END > (DMA_RAM_BASE_ADDR+DMA_RAM_SIZE)
//#error error dma_cfg !!!!!!!!!!!!!!!
//#endif

/*---------------------------DMA ADDR For PSM-----------------------------------*/
#define DMA_RAM_FOR_PSM_ADDR_BASE  DDR_BASE_ADDR_PSM 
#define DMA_PSM_RAM_SIZE      (0x00050000UL>>CPU_SHIFT)/*320k*/

/*for M0 64K*/
#define DMA_PSM_RAM_FOR_M0  DMA_RAM_FOR_PSM_ADDR_BASE
#define DMA_PSM_RAM_FOR_M0_SIZE     (0x00010000UL>>CPU_SHIFT)

/*for ZSP 256K*/
#define DMA_PSM_RAM_FOR_ZSP  (DMA_PSM_RAM_FOR_M0+DMA_PSM_RAM_FOR_M0_SIZE)
#define DMA_PSM_RAM_FOR_ZSP_SIZE     (0x00040000UL>>CPU_SHIFT)

/*for PS  128K*/
//#define DMA_PSM_RAM_FOR_R7 (DMA_PSM_RAM_FOR_ZSP+DMA_PSM_RAM_FOR_ZSP_SIZE)
//#define DMA_PSM_RAM_FOR_R7_SIZE     (0x00020000UL>>CPU_SHIFT)

/*for AP  256K*/
//#define DMA_PSM_RAM_FOR_A9 (DMA_PSM_RAM_FOR_R7+DMA_PSM_RAM_FOR_R7_SIZE)
//#define DMA_PSM_RAM_FOR_A9_SIZE     0x40000

#define DMA_PSM_RAM_CONFIG_END (DMA_PSM_RAM_FOR_ZSP+DMA_PSM_RAM_FOR_ZSP_SIZE)

//#if DMA_PSM_RAM_CONFIG_END > (DMA_RAM_FOR_PSM_ADDR_BASE+DMA_PSM_RAM_SIZE)
//#error error psm_dma_cfg !!!!!!!!!!!!!!!
//#endif

/*------------------------------IRAM0 config-------------------------------------------------------------------*/

/* IRAM0еַָ洢 */
#define ICP_MSG_DRV_BASE_ADDR   (IRAM_BASE_ADDR_DRV)
#define ICP_MSG_SIZE            ((0x25C0UL)>>CPU_SHIFT)

/*SPILOCK  256byte*/
#define SOFTLOCK_BASE     		(IRAM_BASE_ADDR_DRV + ICP_MSG_SIZE)
#define SOFTLOCK_SIZE           (0x100UL>>CPU_SHIFT)

/*AP<->CP DMA LOCK  256byte*/
#define DMA_SHARED_IRAM_BASE    (SOFTLOCK_BASE + SOFTLOCK_SIZE)	/*spinlock 0x100ַDMAʹ*/
#define DMA_SHARED_IRAM_SIZE    (0x100UL>>CPU_SHIFT)

/*power on type  4byte*/
#define POWERON_TYPE_ADDR	    (DMA_SHARED_IRAM_BASE + DMA_SHARED_IRAM_SIZE)
#define POWERON_TYPE_SIZE       (0x4UL>>CPU_SHIFT)

/*boot mode 4byte*/
#define CFG_BOOT_MODE_SAVE_ADDR_FOR_UBOOT   (POWERON_TYPE_ADDR + POWERON_TYPE_SIZE)
#define CFG_BOOT_MODE_SAVE_ADDR_FOR_UBOOT_SIZE  (0x4UL>>CPU_SHIFT)

/*boot start mode 4byte*/
#define CFG_BOOT_MODE_START_MODE_FOR_UBOOT  (CFG_BOOT_MODE_SAVE_ADDR_FOR_UBOOT + CFG_BOOT_MODE_SAVE_ADDR_FOR_UBOOT_SIZE)
#define CFG_BOOT_MODE_START_MODE_FOR_UBOOT_SIZE  (0x4UL>>CPU_SHIFT)

/*secure puk 256byte*/
#define CFG_SECURE_PUK_ADDR     (CFG_BOOT_MODE_START_MODE_FOR_UBOOT + CFG_BOOT_MODE_START_MODE_FOR_UBOOT_SIZE)
#define CFG_SECURE_PUK_SIZE     (0x100UL>>CPU_SHIFT)

/*wdt iram flag 36byte*/
#define WDT_NV_ADDR				(CFG_SECURE_PUK_ADDR + CFG_SECURE_PUK_SIZE)
#define WDT_NV_SIZE				(0x4UL>>CPU_SHIFT)

#define WDT_GLOBAL_COUNT_ADDR	(WDT_NV_ADDR + WDT_NV_SIZE)
#define WDT_GLOBAL_COUNT_SIZE	(0x4UL>>CPU_SHIFT)

#define WDT_PS_TIMEOUT_ADDR		(WDT_GLOBAL_COUNT_ADDR + WDT_GLOBAL_COUNT_SIZE)
#define WDT_PS_TIMEOUT_SIZE		(0x4UL>>CPU_SHIFT)

#define WDT_AP_TIMEOUT_ADDR		(WDT_PS_TIMEOUT_ADDR + WDT_PS_TIMEOUT_SIZE)
#define WDT_AP_TIMEOUT_SIZE		(0x4UL>>CPU_SHIFT)

#define WDT_PHY_TIMEOUT_ADDR	(WDT_AP_TIMEOUT_ADDR + WDT_AP_TIMEOUT_SIZE)
#define WDT_PHY_TIMEOUT_SIZE	(0x4UL>>CPU_SHIFT)

#define WDT_M0_SWITCH_ADDR		(WDT_PHY_TIMEOUT_ADDR + WDT_PHY_TIMEOUT_SIZE)
#define WDT_M0_SWITCH_SIZE		(0x4UL>>CPU_SHIFT)

#define WDT_PS_SWITCH_ADDR		(WDT_M0_SWITCH_ADDR + WDT_M0_SWITCH_SIZE)
#define WDT_PS_SWITCH_SIZE		(0x4UL>>CPU_SHIFT)

#define WDT_AP_SWITCH_ADDR		(WDT_PS_SWITCH_ADDR + WDT_PS_SWITCH_SIZE)
#define WDT_AP_SWITCH_SIZE		(0x4UL>>CPU_SHIFT)

#define WDT_PHY_SWITCH_ADDR		(WDT_AP_SWITCH_ADDR + WDT_AP_SWITCH_SIZE)
#define WDT_PHY_SWITCH_SIZE		(0x4UL>>CPU_SHIFT)

#define FB_REGSTER_FLAG_ADDR		(WDT_PHY_SWITCH_ADDR + WDT_PHY_SWITCH_SIZE)
#define FB_REGSTER_FLAG_SIZE		(0x4UL)

#define M0_IMAGE_READY_FLAG_ADDR		(FB_REGSTER_FLAG_ADDR + FB_REGSTER_FLAG_SIZE)
#define M0_IMAGE_READY_FLAG_SIZE		(0x4UL)

#define BOOT_FLAG_ADDR         (M0_IMAGE_READY_FLAG_ADDR + M0_IMAGE_READY_FLAG_SIZE)
#define BOOT_FLAG_SIZE         (0x4UL)

#define EXCEPT_FLAG_ADDR         (BOOT_FLAG_ADDR + BOOT_FLAG_SIZE)
#define EXCEPT_FLAG_SIZE         (0x4UL)

//youchen@2024-06-20 add for lynq nv config begin
#define LYNQ_NV_CFG_SUPPORT 1

#ifndef LYNQ_NV_CFG_SUPPORT

#define MMC_FLAG_ADDR         (EXCEPT_FLAG_ADDR + EXCEPT_FLAG_SIZE)
#define MMC_FLAG_SIZE         (0x4UL)/*bit 0: mmc0 exit,bit1 mmc1 exit*/
#define RAM_CONFIG_END (MMC_FLAG_ADDR+MMC_FLAG_SIZE)

#else

#define MMC_LYNQ_NV_CFG_ADDR         (EXCEPT_FLAG_ADDR + EXCEPT_FLAG_SIZE)
#define MMC_LYNQ_NV_CFG_SIZE         (0x100UL)
#define RAM_CONFIG_END (MMC_LYNQ_NV_CFG_ADDR+MMC_LYNQ_NV_CFG_SIZE)

#endif 
//youchen@2024-06-20 add for lynq nv config end

//#if RAM_CONFIG_END > (IRAM_BASE_ADDR_DRV+IRAM_BASE_LEN_DRV)
//#error error drv_ram_cfg !!!!!!!!!!!!!!!
//#endif

#endif


