/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    Drvs_volte.h
 * File Mark:
 * Description:  Provide the interface of using volte 
 * Others:
 * Version:       V0.5
 * Author:        lvwenhua
 * Date:          2014-08-4
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_VOLTE_H
#define _DRVS_VOLTE_H

#include <linux/volte_drv.h>

typedef enum
{
    VOLTE_IDLE = 0,
    VOLTE_OPEN,
    VOLTE_INUSE,
    VOLTE_MAX
} T_Volte_Status;
#if 0
typedef enum
{
    VOICE_GSM_MODE = 0,
    VOICE_TD_MODE ,
    VOICE_WCDMA_MODE,
    VOICE_LTE_MODE,
    VOICE_GSM_TD_MODE,//GSM TD share
    VOICE_GSM_WCDMA_MODE,    //GSM WCDMA share 
    MAX_VOICE_MODE
} T_ZDrvVoice_MODE;
typedef struct
{
    UINT32 clock_rate;
    UINT32 channel_count;
    UINT32 samples_per_frame;
    UINT32 bits_per_sample;
	UINT32 mode;
} T_ZDrvVp_Cfg;

#define T_ZDrvVoice_Cfg  T_ZDrvVp_Cfg
#endif

typedef T_ZDrvVoice_Cfg  T_ZDrvVp_Cfg;

typedef struct 
{
    
    SINT32 (*drv_voice_3G_Open)(VOID);            
    SINT32 (*drv_voice_3G_Close)(VOID);            

} T_DrvVoice_3G_Opt;

#ifdef ECALL_SUPPORT
 typedef struct 
 {
	 
	 SINT32 (*drv_Get_Ecall_State)(VOID); 		   
	 SINT32 (*drv_Ecall_Read)(UINT8 *pBuf,UINT32 *inSize);			
	 SINT32 (*drv_Ecall_Write)(UINT8 *pBuf,UINT32 inSize);		
 
 } T_DrvEcall_Opt;
#endif

 typedef struct 
 {
     void (*drv_dtmfrx_report_cb)(char *dtmf_string, unsigned char string_len);
     void (*drv_dtmftx_report_cb)(char *dtmf_string, unsigned char string_len);
 } T_DrvDtmf_Detect_Opt;

 SINT32 zDrvVoice_Open(T_ZDrvVoice_Cfg *cfgParam);
 SINT32 zDrvVoice_Close(VOID);
 SINT32 zDrvVoice_ReadStart(VOID);
 SINT32 zDrvVoice_ReadStop(VOID);
 SINT32 zDrvVoice_WriteStart(VOID);
 SINT32 zDrvVoice_WriteStop(VOID);
 SINT32 zDrvVoice_ReadOneFrame(UINT8 *pBuf);
 SINT32 zDrvVoice_WriteOneFrame(UINT8 *pBuf);
VOID zDrvVoice_3G_RegCallbacks(T_DrvVoice_3G_Opt voiceObj);

SINT32 zDrvVolte_AmrEncoderInit(VOID);
SINT32 zDrvVolte_AmrDecoderInit(VOID);
SINT32 zDrvVolte_AmrEncoder(UINT8 *pInputBuf,UINT32 inSize,UINT8 *pOutputBuf,UINT32* pOutSize);
SINT32 zDrvVolte_AmrDecoder(UINT8 *pInputBuf,UINT32 inSize,UINT8 *pOutputBuf,UINT32* pPutSize);
VOID zDrvVolte_AmrEncoderDeinit(VOID);
VOID zDrvVolte_AmrDecoderDeinit(VOID);
#ifdef ECALL_SUPPORT
VOID zDrvEcall_SetCallbacks(T_DrvEcall_Opt ecallObj);
#endif
#endif

