/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   :  frģ
*    :  zmmp_fr_test.c
* ļ : 
* ʵֹ :  frԴ
*      :  
*      : 
*  :  20140627
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "zmmp_fr_test.h"
#include "mmp_fr_api.h"
#include "zmmp_fr_fnc.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#if defined (_OS_TOS)
#define ZMMP_LOCK(old_intr)         cyg_scheduler_lock();      
#define ZMMP_UNLOCK(old_intr)       cyg_scheduler_unlock(); 
#elif defined (_OS_OSE)
//#include "Osa_itrapi.h"
#define ZMMP_LOCK(old_intr)         ZOSS_SAVE_IRQ(old_intr);
#define ZMMP_UNLOCK(old_intr)       ZOSS_RESTORE_IRQ(old_intr);
#endif

#define ZFR_MAX_CMD_PARAM_LENGTH   (15) 
#define ZFR_STACK_SIZE             (1024 * 20)
#define ZFR_MAX_FILE_NAME_LENGTH   (50)
#define ZFR_ARG_FRAME_SIZE         (76 * 2)    /*ÿ֡76ÿռ2ֽ */
#define ZFR_WAV49_TWO_FRAME_SIZE   (65)        /*֡32ֽ + 33ֽ  */
#define ZFR_WAV49_EVEN_FRAME_SIZE  (32)        /*żֽ֡֡Ŵ0ʼ*/
#define ZFR_PCM_FRAME_SIZE         (320)       /*λֽ                   */
#define ZFR_WAV49_HEADER_SIZE      (60)
#define ZFR_PCM_SAMPLE_RATE        (8000)
#define ZFR_PCM_SAMPLE_BIT         (16)
#define ZFR_MAX_THREAD_COUNT       (20)
#define ZFR_READ_MODE              "rb"
#define ZFR_WRITE_MODE             "wb"


/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID (*fr_TestFunc)(VOID); /* frԺָ */

/*ṹ*/
typedef struct 
{
	CHAR            *pCmd;  /*          */
	fr_TestFunc     func;   /*ú      */
	CHAR            *pDesc; /*  */
} T_zFr_TestCmd;  

/*wave49ļͷṹ,һ60ֽ*/
typedef struct 
{
    CHAR         riffId[4];     /*̶ַ3   */
    UINT32       fileLength;    /*ļܳ -8   */
    CHAR         waveFmt[8];    /*WAVEfmt   */
    UINT32       chunkSize;     /*chunckȣΪ0x14fomatTag,channels, samplePerSec,avgBytesPerSec, fixedStr1ֳ */
    UINT16       fomatTag;      /*0x31          */
    UINT16       channels;      /*        */
    UINT32       samplePerSec;  /*        */
    UINT32       avgBytesPerSec;/*ÿ벥ֽ*/
    CHAR         fixedStr1[8];  /*̶ַ1   */
    CHAR         fixedStr2[8];  /*̶ַ2   */
    CHAR         fixedStr3[4];  /*̶ַ3   */
    CHAR         waveData[4];   /*data      */
    UINT32       sampleDataSize;/*ֽ*/
} T_zFr_GsmHeader; 


/**************************************************************************
* ֲԭ
**************************************************************************/
static UINT8  fr_EncReadDate(FILE *pPcmHandle, SINT16 pcmSrc[]);
static UINT8  fr_EncodeFrame(VOID *pGsmState, VOID *pPcmHandle, FILE *pGsmHandle, T_zFr_OprElem *pOprElem);
static VOID   fr_EncTest(char *pInFilePath, char *pOutFilePath, int dtxEnable);
static VOID   fr_EncThreadEntry(SINT32 arg);
static UINT8  fr_DecReadDate(FILE *pInFileHandle, UINT16 inputBuf[]);
static UINT8  fr_DecodeFrame(VOID *pGsmState, FILE *pGsmHandle, VOID *pPcmHandle, T_zFr_OprElem *pOprElem);
static VOID   fr_DecTest(char *pInFilePath, char *pOutFilePath);
static VOID   fr_DecThreadEntry(SINT32 arg);
static VOID   fr_CodecThreadEntry(SINT32 arg);
static VOID   fr_PrintCmds(VOID);
static SINT32 fr_FindCmds(const CHAR *pMmpCmd);
static VOID   fr_ExcuteCmds(SINT32 iCmdIndex);
static VOID   fr_TestEntry(SINT32 arg);
static BOOL   fr_IsFileEqual(const char *strFileName1, const char *strFileName2);
static BOOL   fr_IsFileContentEqual(FILE *pFile1Handler, FILE *pFile2Handler);


static VOID   fr_TestEnc1(VOID); 
static VOID   fr_TestEnc2(VOID); 
static VOID   fr_TestEnc3(VOID); 
static VOID   fr_TestEnc4(VOID);
static VOID   fr_TestEnc5(VOID); 
static VOID   fr_TestEnc6(VOID); 
static VOID   fr_TestEnc7(VOID); 
static VOID   fr_TestEnc8(VOID); 
static VOID   fr_TestEnc9(VOID); 
static VOID   fr_TestEnc10(VOID); 
static VOID   fr_TestEnc11(VOID); 
static VOID   fr_TestEnc12(VOID); 
static VOID   fr_TestEnc13(VOID); 
static VOID   fr_TestEnc14(VOID);
static VOID   fr_TestEnc15(VOID); 
static VOID   fr_TestEnc16(VOID); 
static VOID   fr_TestEnc17(VOID); 
static VOID   fr_TestEnc18(VOID); 
static VOID   fr_TestEnc19(VOID); 
static VOID   fr_TestEnc20(VOID); 
static VOID   fr_TestEnc21(VOID); 
static VOID   fr_TestEnc22(VOID); 
static VOID   fr_TestEnc23(VOID); 
static VOID   fr_TestEnc24(VOID);
static VOID   fr_TestEnc25(VOID); 
static VOID   fr_TestEnc26(VOID); 


static VOID   fr_TestDec1(VOID); 
static VOID   fr_TestDec2(VOID); 
static VOID   fr_TestDec3(VOID); 
static VOID   fr_TestDec4(VOID); 
static VOID   fr_TestDec5(VOID); 
static VOID   fr_TestDec6(VOID); 
static VOID   fr_TestDec7(VOID); 
static VOID   fr_TestDec8(VOID); 
static VOID   fr_TestDec9(VOID); 
static VOID   fr_TestDec10(VOID); 
static VOID   fr_TestDec11(VOID); 
static VOID   fr_TestDec12(VOID); 
static VOID   fr_TestDec13(VOID); 
static VOID   fr_TestDec14(VOID); 
static VOID   fr_TestDec15(VOID); 
static VOID   fr_TestDec16(VOID); 
static VOID   fr_TestDec17(VOID); 
static VOID   fr_TestDec18(VOID); 
static VOID   fr_TestDec19(VOID); 
static VOID   fr_TestDec20(VOID); 
static VOID   fr_TestDec21(VOID); 
static VOID   fr_TestDec22(VOID); 
static VOID   fr_TestDec23(VOID); 
static VOID   fr_TestDec24(VOID); 
static VOID   fr_TestDec25(VOID); 
static VOID   fr_TestDec26(VOID); 
static VOID   fr_TestCodec(VOID); 

static VOID   fr_TestAuto(VOID); 
static VOID   fr_APIEnc(VOID);
static VOID   fr_APIDec(VOID);

extern VOID* mmp_FrEncOpen (BOOL isDtxEnable);
extern VOID* mmp_FrDecOpen (VOID);
/**************************************************************************
* ȫֳ/
**************************************************************************/

CHAR                *g_zFr_Cmd                              = NULL;
ZOSS_SEMAPHORE_ID   g_zFr_shellSemaphoreID                  = ZOSS_NULL;
ZOSS_SEMAPHORE_ID   g_zFr_testSemaphoreID                   = ZOSS_NULL;
ZOSS_SEMAPHORE_ID   g_zFr_ThreadSemaphoreID                 = ZOSS_NULL;
UINT8               g_zFr_IsEvenFrame[ZFR_MAX_THREAD_COUNT] = {0};     /*ǰ֡ǲż֡֡Ŵ0ʼ*/

/* ý */
static T_zFr_TestCmd g_zFr_TestCmds[] = 
{             
    {"FrEnc1",    (fr_TestFunc)fr_TestEnc1,     "Э1"},
    {"FrEnc2",    (fr_TestFunc)fr_TestEnc2,     "Э2"},
    {"FrEnc3",    (fr_TestFunc)fr_TestEnc3,     "Э3"},
    {"FrEnc4",    (fr_TestFunc)fr_TestEnc4,     "Э4"}, 
    {"FrEnc5",    (fr_TestFunc)fr_TestEnc5,     "Э5"}, 
    {"FrEnc6",    (fr_TestFunc)fr_TestEnc6,     "Э6"}, 
    {"FrEnc7",    (fr_TestFunc)fr_TestEnc7,     "Э7"}, 
    {"FrEnc8",    (fr_TestFunc)fr_TestEnc8,     "Э8"},
    {"FrEnc9",    (fr_TestFunc)fr_TestEnc9,     "Э9"}, 
    {"FrEnc10",    (fr_TestFunc)fr_TestEnc10,     "Э10"},
    {"FrEnc11",    (fr_TestFunc)fr_TestEnc11,     "Э11"},
    {"FrEnc12",    (fr_TestFunc)fr_TestEnc12,     "Э12"},
    {"FrEnc13",    (fr_TestFunc)fr_TestEnc13,     "Э13"},
    {"FrEnc14",    (fr_TestFunc)fr_TestEnc14,     "Э14"}, 
    {"FrEnc15",    (fr_TestFunc)fr_TestEnc15,     "Э15"}, 
    {"FrEnc16",    (fr_TestFunc)fr_TestEnc16,     "Э16"}, 
    {"FrEnc17",    (fr_TestFunc)fr_TestEnc17,     "Э17"}, 
    {"FrEnc18",    (fr_TestFunc)fr_TestEnc18,     "Э18"},
    {"FrEnc19",    (fr_TestFunc)fr_TestEnc19,     "Э19"}, 
    {"FrEnc20",    (fr_TestFunc)fr_TestEnc20,     "Э20"},
    {"FrEnc21",    (fr_TestFunc)fr_TestEnc21,     "Э21"},
    {"FrEnc22",    (fr_TestFunc)fr_TestEnc22,     "Э22"},
    {"FrEnc23",    (fr_TestFunc)fr_TestEnc23,     "Э23"},
    {"FrEnc24",    (fr_TestFunc)fr_TestEnc24,     "Э24"}, 
    {"FrEnc25",    (fr_TestFunc)fr_TestEnc25,     "Э25"}, 
    {"FrEnc26",    (fr_TestFunc)fr_TestEnc26,     "Э26"}, 

    {"FrDec1",    (fr_TestFunc)fr_TestDec1,     "Э1"},
    {"FrDec2",    (fr_TestFunc)fr_TestDec2,     "Э2"},
    {"FrDec3",    (fr_TestFunc)fr_TestDec3,     "Э3"},
    {"FrDec4",    (fr_TestFunc)fr_TestDec4,     "Э4"},
    {"FrDec5",    (fr_TestFunc)fr_TestDec5,     "Э5"},
    {"FrDec6",    (fr_TestFunc)fr_TestDec6,     "Э6"},
    {"FrDec7",    (fr_TestFunc)fr_TestDec7,     "Э7"},
    {"FrDec8",    (fr_TestFunc)fr_TestDec8,     "Э8"},
    {"FrDec9",    (fr_TestFunc)fr_TestDec9,     "Э9"},
    {"FrDec10",   (fr_TestFunc)fr_TestDec10,    "Э10"},
    {"FrDec11",    (fr_TestFunc)fr_TestDec11,     "Э11"},
    {"FrDec12",    (fr_TestFunc)fr_TestDec12,     "Э12"},
    {"FrDec13",    (fr_TestFunc)fr_TestDec13,     "Э13"},
    {"FrDec14",    (fr_TestFunc)fr_TestDec14,     "Э14"},
    {"FrDec15",    (fr_TestFunc)fr_TestDec15,     "Э15"},
    {"FrDec16",    (fr_TestFunc)fr_TestDec16,     "Э16"},
    {"FrDec17",    (fr_TestFunc)fr_TestDec17,     "Э17"},
    {"FrDec18",    (fr_TestFunc)fr_TestDec18,     "Э18"},
    {"FrDec19",    (fr_TestFunc)fr_TestDec19,     "Э19"},
    {"FrDec20",    (fr_TestFunc)fr_TestDec20,     "Э20"},
    {"FrDec21",    (fr_TestFunc)fr_TestDec21,     "Э21"},
    {"FrDec22",    (fr_TestFunc)fr_TestDec22,     "Э22"},
    {"FrDec23",    (fr_TestFunc)fr_TestDec23,     "Э23"},
    {"FrDec24",    (fr_TestFunc)fr_TestDec24,     "Э24"},
    {"FrDec25",    (fr_TestFunc)fr_TestDec25,     "Э25"},
    {"FrDec26",    (fr_TestFunc)fr_TestDec26,     "Э26"},

    //{"FrCodeToETSI",   (fr_TestFunc)fr_TestCodeToETSI,    "Ĳ(ÿ֡76short)תΪETSIʽ"},
    //{"FrCodeToWAVE49", (fr_TestFunc)fr_TestCodeToWAVE49,  "Ĳ(ÿ֡76short)תΪWAV49ʽ"}, 
    {"FrCodec", (fr_TestFunc)fr_TestCodec,  "ʵб룬һ룬һ"},

    {"FrTestAuto",    (fr_TestFunc)fr_TestAuto,       "Զ"},
    {"FrAPIEnc",    (fr_TestFunc)fr_APIEnc,           "ӿڣ"},
    {"FrAPIDec",    (fr_TestFunc)fr_APIDec,           "ӿڣ"}

};

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* : Э1ʽETSI, ڲԱеƴ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc1(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc1 start");   
    fr_EncTest("C:/Seq01.inp", "C:/Seq01.gsm", 0);
    zOss_Printf(1, 1, "fr_TestEnc1 end");
}

/**************************************************************************
* : Э2ʽETSI, ڲԱеLPC㷨
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc2(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc2 start");   
    fr_EncTest("C:/Seq02.inp", "C:/Seq02.gsm", 0);
    zOss_Printf(1, 1, "fr_TestEnc2 end");
}

/**************************************************************************
* : Э3ʽETSI, ڲԱеLTP㷨
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc3(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc3 start");   
    fr_EncTest("C:/Seq03.inp", "C:/Seq03.gsm", 0);
    zOss_Printf(1, 1, "fr_TestEnc3 end");
}

/**************************************************************************
* : Э4ʽETSI, ڲԱеҪ㷨Ǳڴ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc4(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc4 start");   
    fr_EncTest("C:/Seq04.inp", "C:/Seq04.gsm", 0);
    zOss_Printf(1, 1, "fr_TestEnc4 end");
}

/**************************************************************************
* : Э5ʽETSI, ڲԱеҪ㷨Ǳڴ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc5(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc5 start");   
    fr_EncTest("C:/Seq01h.inp", "C:/Seq01h.gsm", 0);
    zOss_Printf(1, 1, "fr_TestEnc5 end");
}
/**************************************************************************
* : Э6ʽETSI, ڲԱеҪ㷨Ǳڴ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc6(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc6 start");   
    fr_EncTest("C:/Seq02h.inp", "C:/Seq02h.gsm", 0);
    zOss_Printf(1, 1, "fr_TestEnc6 end");
}

/**************************************************************************
* : Э7ʽETSI, ڲԱеLTP㷨
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc7(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc7 start");   
    fr_EncTest("C:/ADAPT_M1.INP", "C:/ADAPT_M1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc7 end");
}
/**************************************************************************
* : Э8ʽETSI, ڲԱеҪ㷨Ǳڴ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc8(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc8 start");   
    fr_EncTest("C:/ADAPT_M2.INP", "C:/ADAPT_M2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc8 end");
}
/**************************************************************************
* : Э9
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc9(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc9 start");   
    fr_EncTest("C:/BAD_SP.INP", "C:/BAD_SP.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc9 end");
}

/**************************************************************************
* : Э10
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc10(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc10 start");   
    fr_EncTest("C:/FREQ_SW.INP", "C:/FREQ_SW.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc10 end");
}
/**************************************************************************
* : Э11
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc11(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc11 start");   
    fr_EncTest("C:/GOOD_SP.INP", "C:/GOOD_SP.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc11 end");
}
/**************************************************************************
* : Э12
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc12(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc12 start");   
    fr_EncTest("C:/PITCH1.INP", "C:/PITCH1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc12 end");
}

/**************************************************************************
* : Э13
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc13(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc13 start");   
    fr_EncTest("C:/PITCH2.INP", "C:/PITCH2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc13 end");
}

/**************************************************************************
* : Э14
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc14(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc14 start");   
    fr_EncTest("C:/POLE1.INP", "C:/POLE1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc14 end");
}
/**************************************************************************
* : Э15
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc15(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc15 start");   
    fr_EncTest("C:/POLE2.INP", "C:/POLE2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc15 end");
}
/**************************************************************************
* : Э16
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc16(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc16 start");   
    fr_EncTest("C:/PRED1.INP", "C:/PRED1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc16 end");
}
/**************************************************************************
* : Э17
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc17(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc17 start");   
    fr_EncTest("C:/PRED2.INP", "C:/PRED2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc17 end");
}
/**************************************************************************
* : Э18
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc18(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc18 start");   
    fr_EncTest("C:/SAFETY.INP", "C:/SAFETY.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc18 end");
}
/**************************************************************************
* : Э19ʽWAV49, ڲԱеƴ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc19(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc19 start");   
    fr_EncTest("C:/ADAPT_I1.INP", "C:/ADAPT_I1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc19 end");
}

/**************************************************************************
* : Э20
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc20(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc20 start");   
    fr_EncTest("C:/SPEC_A1.INP", "C:/SPEC_A1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc20 end");
}
/**************************************************************************
* : Э21
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc21(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc21 start");   
    fr_EncTest("C:/SPEC_A2.INP", "C:/SPEC_A2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc21 end");
}
/**************************************************************************
* : Э22
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc22(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc22 start");   
    fr_EncTest("C:/SPEC_C1.INP", "C:/SPEC_C1.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc22 end");
}
/**************************************************************************
* : Э23
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc23(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc23 start");   
    fr_EncTest("C:/SPEC_C2.INP", "C:/SPEC_C2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc23 end");
}
/**************************************************************************
* : Э24
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc24(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc24 start");   
    fr_EncTest("C:/SPEC_C3.INP", "C:/SPEC_C3.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc24 end");
}
/**************************************************************************
* : Э25
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc25(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc25 start");   
    fr_EncTest("C:/SPEC_C4.INP", "C:/SPEC_C4.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc25 end");
}
/**************************************************************************
* : Э26
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestEnc26(VOID) 
{
    zOss_Printf(1, 1, "fr_TestEnc26 start");   
    fr_EncTest("C:/ADAPT_I2.INP", "C:/ADAPT_I2.gsm", 1);
    zOss_Printf(1, 1, "fr_TestEnc26 end");
}

/**************************************************************************
* : Э1ļʽΪETSIļΪfr_TestProtoEnc1ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec1(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec1 start");   
    fr_DecTest("C:/Seq01.cod", "C:/Seq01.out");
    zOss_Printf(1, 1, "fr_TestDec1 end");
}

/**************************************************************************
* : Э2ļʽΪETSIļΪfr_TestProtoEnc2ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec2(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec2 start");   
    fr_DecTest("C:/Seq02.cod", "C:/Seq02.out");
    zOss_Printf(1, 1, "fr_TestDec2 end");
}
/**************************************************************************
* : Э3ļʽΪETSIļΪfr_TestProtoEnc3ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec3(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec3 start");   
    fr_DecTest("C:/Seq03.cod", "C:/Seq03.out");
    zOss_Printf(1, 1, "fr_TestDec3 end");
}

/**************************************************************************
* : Э4ļʽΪETSIļΪfr_TestProtoEnc4ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec4(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec4 start");   
    fr_DecTest("C:/Seq04.cod", "C:/Seq04.out");
    zOss_Printf(1, 1, "fr_TestDec4 end");
}

/**************************************************************************
* : Э5ļʽΪETSIļΪϳݣǱݣòļбܵıֵ߽ڲԽ봦ĺ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec5(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec5 start");   
    fr_DecTest("C:/Seq01h.cod", "C:/Seq01h.out");
    zOss_Printf(1, 1, "fr_TestDec5 end");
}

/**************************************************************************
* : Э6ļʽΪWAV49ļΪfr_TestProtoEnc5ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec6(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec6 start");   
    fr_DecTest("C:/Seq02h.cod", "C:/Seq02h.out");
    zOss_Printf(1, 1, "fr_TestDec6 end");
}
/**************************************************************************
* : Э7ļʽΪWAV49ļΪfr_TestProtoEnc6ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec7(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec7 start");   
    fr_DecTest("C:/ADAPT_I1.cod", "C:/ADAPT_I1.out");
    zOss_Printf(1, 1, "fr_TestDec7 end");
}
/**************************************************************************
* : Э8ļʽΪWAV49ļΪfr_TestProtoEnc7ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec8(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec8 start");   
    fr_DecTest("C:/ADAPT_I2.cod", "C:/ADAPT_I2.out");
    zOss_Printf(1, 1, "fr_TestDec8 end");
}
/**************************************************************************
* : Э9ļʽΪWAV49ļΪfr_TestProtoEnc8ļ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec9(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec9 start");   
    fr_DecTest("C:/ADAPT_M1.cod", "C:/ADAPT_M1.out");
    zOss_Printf(1, 1, "fr_TestDec9 end");
}
/**************************************************************************
* : Э10ļʽΪWAV49ļΪϳݣǱݣòļбܵıֵ߽ڲԽ봦ĺ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec10(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec10 start");   
    fr_DecTest("C:/ADAPT_M2.cod", "C:/ADAPT_M2.out");
    zOss_Printf(1, 1, "fr_TestDec10 end");
}
/**************************************************************************
* : Э11
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec11(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec11 start");   
    fr_DecTest("C:/BAD_SP.cod", "C:/BAD_SP.out");
    zOss_Printf(1, 1, "fr_TestDec11 end");
}
/**************************************************************************
* : Э12
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec12(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec12 start");   
    fr_DecTest("C:/FREQ_SW.cod", "C:/FREQ_SW.out");
    zOss_Printf(1, 1, "fr_TestDec12 end");
}
/**************************************************************************
* : Э13
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec13(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec13 start");   
    fr_DecTest("C:/GOOD_SP.cod", "C:/GOOD_SP.out");
    zOss_Printf(1, 1, "fr_TestDec13 end");
}
/**************************************************************************
* : Э14
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec14(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec14 start");   
    fr_DecTest("C:/PITCH1.cod", "C:/PITCH1.out");
    zOss_Printf(1, 1, "fr_TestDec14 end");
}
/**************************************************************************
* : Э15
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec15(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec15 start");   
    fr_DecTest("C:/PITCH2.cod", "C:/PITCH2.out");
    zOss_Printf(1, 1, "fr_TestDec15 end");
}
/**************************************************************************
* : Э16
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec16(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec16 start");   
    fr_DecTest("C:/POLE1.cod", "C:/POLE1.out");
    zOss_Printf(1, 1, "fr_TestDec16 end");
}
/**************************************************************************
* : Э17
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec17(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec17 start");   
    fr_DecTest("C:/POLE2.cod", "C:/POLE2.out");
    zOss_Printf(1, 1, "fr_TestDec17 end");
}
/**************************************************************************
* : Э18
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec18(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec18 start");   
    fr_DecTest("C:/PRED1.cod", "C:/PRED1.out");
    zOss_Printf(1, 1, "fr_TestDec18 end");
}
/**************************************************************************
* : Э19
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec19(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec19 start");   
    fr_DecTest("C:/PRED2.cod", "C:/PRED2.out");
    zOss_Printf(1, 1, "fr_TestDec19 end");
}
/**************************************************************************
* : Э20
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec20(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec20 start");
    fr_DecTest("C:/SAFETY.cod", "C:/SAFETY.out");
    zOss_Printf(1, 1, "fr_TestDec20 end");
}
/**************************************************************************
* : Э21
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec21(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec21 start"); 
    fr_DecTest("C:/SPEC_A1.cod", "C:/SPEC_A1.out");
    zOss_Printf(1, 1, "fr_TestDec21 end");
}
/**************************************************************************
* : Э22
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec22(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec22 start");  
    fr_DecTest("C:/SPEC_A2.cod", "C:/SPEC_A2.out");    
    zOss_Printf(1, 1, "fr_TestDec22 end");
}
/**************************************************************************
* : Э23
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec23(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec23 start"); 
    fr_DecTest("C:/SPEC_C1.cod", "C:/SPEC_C1.out");    
    zOss_Printf(1, 1, "fr_TestDec23 end");
}
/**************************************************************************
* : Э24
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec24(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec24 start");  
    fr_DecTest("C:/SPEC_C2.cod", "C:/SPEC_C2.out");    
    zOss_Printf(1, 1, "fr_TestDec24 end");
}
/**************************************************************************
* : Э25
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec25(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec25 start");
    fr_DecTest("C:/SPEC_C3.cod", "C:/SPEC_C3.out");    
    zOss_Printf(1, 1, "fr_TestDec25 end");
}
/**************************************************************************
* : Э26
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestDec26(VOID) 
{
    zOss_Printf(1, 1, "fr_TestDec26 start"); 
    fr_DecTest("C:/SPEC_C4.cod", "C:/SPEC_C4.out");    
    zOss_Printf(1, 1, "fr_TestDec26 end");
}

/**************************************************************************
* :     ʵб
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/

static VOID fr_TestCodec(VOID) 
{
    ZOSS_THREAD_ID     mutiThreadID    = ZOSS_NULL;
    zOss_Printf(1, 1, "zfr_TestCodec start");  
    mutiThreadID = zOss_CreateThread("codecThread",
                                     fr_CodecThreadEntry,
                                     0,
                                     ZFR_STACK_SIZE,
                                     18,
                                     1,
                                     1);

    if(mutiThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "fr_TestCodec:zOss_CreateThread failed");
    }
    zOss_Printf(1, 1, "zfr_TestCodec end");    
}

/**************************************************************************
* :     йܲ
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_TestAuto(VOID) 
{
    zOss_Printf(1, 1, "fr_TestAuto start");
    fr_TestEnc1();
    fr_TestEnc2();
    fr_TestEnc3();
    fr_TestEnc4();
    fr_TestEnc5();
    fr_TestEnc6();
    fr_TestEnc7();
    fr_TestEnc8();
    fr_TestEnc9();
    fr_TestEnc10();
    fr_TestEnc11();
    fr_TestEnc12();
    fr_TestEnc13();
    fr_TestEnc14();
    fr_TestEnc15();
    fr_TestEnc16();
    fr_TestEnc17();
    fr_TestEnc18();
    fr_TestEnc19();
    fr_TestEnc20();
    fr_TestEnc21();
    fr_TestEnc22();
    fr_TestEnc23();
    fr_TestEnc24();
    fr_TestEnc25();
    fr_TestEnc26();



    fr_TestDec1();
    fr_TestDec2();
    fr_TestDec3();
    fr_TestDec4();
    fr_TestDec5();
    fr_TestDec6();
    fr_TestDec7();
    fr_TestDec8();
    fr_TestDec9();
    fr_TestDec10();
    fr_TestDec11();
    fr_TestDec12();
    fr_TestDec13();
    fr_TestDec14();
    fr_TestDec15();
    fr_TestDec16();
    fr_TestDec17();
    fr_TestDec18();
    fr_TestDec19();
    fr_TestDec20();
    fr_TestDec21();
    fr_TestDec22();
    fr_TestDec23();
    fr_TestDec24();
    fr_TestDec25();
    fr_TestDec26();
   
    zOss_Printf(1, 1, "fr_TestAuto end");    
}
/**************************************************************************
* :     ȡpcm
* ˵:     
*   ()  pPcmHandle:  wavļ
*   ()  pcmSrc:      ȡpcmݴ洢buffer
*   ֵ:     ɹ1ʧܷ0
* ˵:    
**************************************************************************/
static UINT8 fr_EncReadDate(FILE *pPcmHandle, SINT16 pcmSrc[])
{
    
    UINT16 readSize     = 0;
    
    readSize = zOss_FRead(pcmSrc, 1, ZFR_PCM_FRAME_SIZE, pPcmHandle);  
    if(readSize != ZFR_PCM_FRAME_SIZE)
    {
        if(zOss_FEof(pPcmHandle) == 0)
        {
            zOss_Printf(1, 1, "fr_EncReadDate: readfile error , error code: %d", readSize);
        }
        return 0;
    }
    return 1;    
}

/**************************************************************************
* :     һ֡
* ˵:     
*   ()  pGsmState:  
*   ()  pPcmHandle: pcmļ
*   ()  pGsmHandle: gsmļ
*   ()  pOprElem:   ͳƲ
*   ()  threadIndex:̱߳
*   ()  
*   ֵ:     ɹ1,ʧܷ0
* ˵:     
**************************************************************************/ 
static UINT8 fr_EncodeFrame(VOID *pGsmState, VOID *pPcmHandle, FILE *pGsmHandle, T_zFr_OprElem *pOprElem)
{
    SINT16          pcmSrc[160]     = {0};
    UINT16	        gsmDst[76]      = {0};
    SINT32          readSize        = 0;
    UINT32          beginTicks      = 0;
    UINT32          endTicks        = 0;
    UINT32          frameSize       = 0;
    UINT32          old_intr;
    zOss_ASSERT(pGsmState != NULL && pPcmHandle != NULL && pGsmHandle != NULL && pOprElem != NULL);

    if (!fr_EncReadDate(pPcmHandle, pcmSrc))
    {
        return 0;
    }
    
    ZMMP_LOCK(old_intr);
    beginTicks = zFr_GetTick();
    mmp_FrEncode(pGsmState, pcmSrc, gsmDst);
    endTicks   = zFr_GetTick();
    ZMMP_UNLOCK(old_intr);
    zFr_AddTicks(pOprElem, endTicks - beginTicks);

    if(zOss_FWrite(gsmDst, 1, 76 * 2, pGsmHandle) !=  76 * 2)
    {
        zOss_Printf(1, 1,  "fr_EncodeFrame: writefile error");
        return 0;
    }
    return 1;
}

/**************************************************************************
* :     
* ˵:     
*   () 
*   () 
*   () 
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_EncTest(char *pInFilePath, char *pOutFilePath, int dtxEnable)
{
    FILE            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    VOID*           pEncHandle                      = NULL;
    UINT32          totalFrameSize                  = 0;
    UINT16	        gsmDst[76]                      = {0};
    T_zFr_OprElem   oprElem                         = {0};
    char  pRefFilePath[ZFR_MAX_FILE_NAME_LENGTH]   = {0};

    if (!(pEncHandle = mmp_FrEncOpen(dtxEnable))) 
    {           
        zOss_Printf(1, 1, "fr_EncTest: gsm_create failed");
        return;
    }
    pPcmHandle = zOss_FOpen(pInFilePath, ZFR_READ_MODE);
    
    pGsmHandle = zOss_FOpen(pOutFilePath, ZFR_WRITE_MODE);

    zFr_ResetOprElem(&oprElem);  
    while(fr_EncodeFrame(pEncHandle, pPcmHandle, pGsmHandle, &oprElem));
    zFr_PutoutOprElem(&oprElem);
        
    mmp_FrEncClose(pEncHandle);
    zOss_FClose(pPcmHandle); 
    zOss_FClose(pGsmHandle);

    strcpy(pRefFilePath, pOutFilePath);
    strcpy(strchr(pRefFilePath, '.'), ".cod");
    zOss_Printf(1, 1, "begin compare output encoded file with reference emcoded file!");  

    if(fr_IsFileEqual(pRefFilePath, pOutFilePath))
    {
        zOss_Printf(1, 1, "encode success!!");  
    }
    else
    {
        zOss_Printf(1, 1, "encode fail!!");  

    }
    zOss_Printf(1, 1, "end compare output encoded file with reference emcoded file!");  

    return;
}
/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  threadIndex: ̱߳
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/
static VOID fr_EncThreadEntry(SINT32 arg)
{
    zOss_Printf(1, 1, "fr_EncThreadEntry start");
    fr_EncTest("C:/SPEC_C4.INP", "C:/SPEC_C4_mutithread.gsm", 1);
    zOss_Printf(1, 1, "fr_EncThreadEntry end");
}


/**************************************************************************
* :     ȡgsm
* ˵:     
*   ()  pInFileHandle:  gsmļ
*   ()  inputBuf:       ȡgsmݴ洢buffer
*   ֵ:     ɹ1ʧܷ0
* ˵:    
**************************************************************************/
static UINT8 fr_DecReadDate(FILE *pInFileHandle, UINT16 inputBuf[])
{
    UINT16 readSize       = 0;
    
    readSize  = zOss_FRead(inputBuf, 1, 76 * 2, pInFileHandle);
    if (readSize != 76 * 2) /*ļȡʧ*/ 
    {   
        return 0;
    }
    return 1; 
    
}

/**************************************************************************
* :     һ֡
* ˵:     
*   ()  pGsmState:  
*   ()  pPcmHandle: pcmļ
*   ()  pGsmHandle: gsmļ
*   ()  pOprElem:   ͳƲ
*   ()  threadIndex:̱߳
*   ()  
*   ֵ:     ɹ1,ʧܷ0
* ˵:     
**************************************************************************/ 
static UINT8 fr_DecodeFrame(VOID *pGsmState, FILE *pGsmHandle, VOID *pPcmHandle, T_zFr_OprElem *pOprElem)
{
    SINT16          pcmDst[160]     = {0};
    UINT8           gsmSrc[76]      = {0};
    UINT32          beginTicks      = 0;
    UINT32          endTicks        = 0;
    UINT32          old_intr;
    
    zOss_ASSERT(pGsmState != NULL && pPcmHandle != NULL && pGsmHandle != NULL && pOprElem != NULL);
    
    if (!fr_DecReadDate(pGsmHandle, (UINT16 *)gsmSrc))
    {
        return 0;
    }
    
    ZMMP_LOCK(old_intr);
    beginTicks = zFr_GetTick();
    mmp_FrDecode(pGsmState, gsmSrc, pcmDst);
    endTicks   = zFr_GetTick();
    ZMMP_UNLOCK(old_intr);
    zFr_AddTicks(pOprElem, endTicks - beginTicks);
    if(zOss_FWrite(pcmDst, 1, 160 * 2, pPcmHandle) !=  160 * 2)
    {
        zOss_Printf(1, 1,  "fr_EncodeFrame: writefile error");
        return 0;
    }

    return 1;
}

/**************************************************************************
* :     
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_DecTest(char *pInFilePath, char *pOutFilePath)
{
    FILE            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zFr_OprElem   oprElem                         = {0};
    VOID*           pGsmState                       = NULL;
    char  pRefFilePath[ZFR_MAX_FILE_NAME_LENGTH]   = {0};
   
    if (!(pGsmState = mmp_FrDecOpen())) 
    {           
        zOss_Printf(1, 1, "fr_decTest: gsm_create failed");
        return;
    }
    pPcmHandle = zOss_FOpen(pOutFilePath, ZFR_WRITE_MODE);
    pGsmHandle = zOss_FOpen(pInFilePath, ZFR_READ_MODE);
   
    zFr_ResetOprElem(&oprElem);  
    while(fr_DecodeFrame(pGsmState, pGsmHandle, pPcmHandle, &oprElem));
    zFr_PutoutOprElem(&oprElem);
    
    mmp_FrDecClose(pGsmState);
    zOss_FClose(pPcmHandle); 
    zOss_FClose(pGsmHandle);
    strcpy(pRefFilePath, pOutFilePath);
    strcpy(strchr(pRefFilePath, '.'), ".ref");

    zOss_Printf(1, 1, "begin compare output encoded file with reference emcoded file!");  

    if(fr_IsFileEqual(pRefFilePath, pOutFilePath))
    {
        zOss_Printf(1, 1, "decode success!!");  
    }
    else
    {
        zOss_Printf(1, 1, "decode fail!!");  
    }
    zOss_Printf(1, 1, "end compare output encoded file with reference emcoded file!");  

    return;
}

/**************************************************************************
* :    ߳ں
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:    
**************************************************************************/
static VOID fr_DecThreadEntry(SINT32 arg)
{
    zOss_Printf(1, 1, "fr_DecThreadEntry start");
    fr_DecTest("C:/Seq02.cod", "C:/Seq02_mutithread.out");
    zOss_Printf(1, 1, "fr_DecThreadEntry end");
}


/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  arg: ںδʹ
*   ()  
*   ֵ:     
* ˵:    
**************************************************************************/
static VOID fr_CodecThreadEntry(SINT32 arg)
{
    
    ZOSS_THREAD_ID decThreadID    = ZOSS_NULL;
    ZOSS_THREAD_ID encThreadID    = ZOSS_NULL;
    
    zOss_Printf(1, 1, "fr_CodecThreadEntry start");  
    encThreadID = zOss_CreateThread("encThread3",
                                    fr_EncThreadEntry,
                                    0,
                                    ZFR_STACK_SIZE,
                                    18,
                                    1,
                                    1);
    if(encThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "create encThread failed");
        return;   
    }
    decThreadID = zOss_CreateThread("decThread4",
                                    fr_DecThreadEntry,
                                    0,
                                    ZFR_STACK_SIZE,
                                    18,
                                    1,
                                    1);
    if(decThreadID == ZOSS_NULL)
    {
        zOss_Printf(1, 1, "create decThread failed");
        return;   
    }
    zOss_Printf(1, 1, "fr_CodecThreadEntry end");   
}
/**************************************************************************
* :     ӿڣ
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_APIEnc(VOID)
{
    CHAR            *pcmPath                        = "C:/fr_enc.inp";
    CHAR            *gsmPath                        = "C:/fr_enc.cod";
    FILE            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    VOID*           pEncHandle                      = NULL;
    UINT32          totalFrameSize                  = 0;
    //UINT16	        gsmDst[76]                      = {0};
    T_zFr_OprElem   oprElem                         = {0};

    if (!(pEncHandle = zMmp_FrEncOpen(TRUE))) 
    {           
        zOss_Printf(1, 1, "fr_EncTest: gsm_create failed");
        return;
    }
    pPcmHandle = zOss_FOpen(pcmPath, ZFR_READ_MODE);
    
    pGsmHandle = zOss_FOpen(gsmPath, ZFR_WRITE_MODE);

    zFr_ResetOprElem(&oprElem);  
    while(1)
    {
        SINT16          pcmSrc[160]     = {0};
        UINT16	        gsmDst[100]      = {0};
        SINT32          readSize        = 0;
        UINT32          beginTicks      = 0;
        UINT32          endTicks        = 0;
        UINT32          frameSize       = 0;
        UINT32          old_intr;
        
        if (!fr_EncReadDate(pPcmHandle, pcmSrc))
        {
            break;
        }
        
        ZMMP_LOCK(old_intr);
        beginTicks = zFr_GetTick();
        zMmp_FrEncode(pEncHandle, pcmSrc, gsmDst);
        endTicks   = zFr_GetTick();
        ZMMP_UNLOCK(old_intr);
        zFr_AddTicks(&oprElem, endTicks - beginTicks);

        if(zOss_FWrite(gsmDst, 1, 78 * 2, pGsmHandle) !=  78 * 2)
        {
            zOss_Printf(1, 1,  "fr_EncodeFrame: writefile error");
            break;
        }

    }
    zFr_PutoutOprElem(&oprElem);
        
    zMmp_FrEncClose(pEncHandle);
    zOss_FClose(pPcmHandle); 
    zOss_FClose(pGsmHandle);

    return;
}
/**************************************************************************
* :    ӿڣ
* ˵:     
*   ()  
*   ()  
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_APIDec(VOID)
{
    CHAR            *pcmPath                        = "C:/fr_dec.out";
    CHAR            *gsmPath                        = "C:/fr_enc.cod";
    FILE            *pPcmHandle                     = NULL;
    FILE            *pGsmHandle                     = NULL;
    T_zFr_OprElem   oprElem                         = {0};
    VOID*           pGsmState                       = NULL;
   
    if (!(pGsmState = zMmp_FrDecOpen())) 
    {           
        zOss_Printf(1, 1, "fr_decTest: gsm_create failed");
        return;
    }
    pPcmHandle = zOss_FOpen(pcmPath, ZFR_WRITE_MODE);
    pGsmHandle = zOss_FOpen(gsmPath, ZFR_READ_MODE);
   
    zFr_ResetOprElem(&oprElem);  
    while(1)
    {
        SINT16          pcmDst[160]     = {0};
        UINT16          gsmSrc[100]     = {0};
        UINT32          beginTicks      = 0;
        UINT32          endTicks        = 0;
        UINT16          readSize        = 0;
        UINT32          old_intr;
        
        readSize  = zOss_FRead(gsmSrc, 1, 78 * 2, pGsmHandle);
        if (readSize != 78 * 2) /*ļȡʧ*/ 
        {   
            break;
        }
        
        ZMMP_LOCK(old_intr);
        beginTicks = zFr_GetTick();
        zMmp_FrDecode(pGsmState, gsmSrc, pcmDst);
        endTicks   = zFr_GetTick();
        ZMMP_UNLOCK(old_intr);
        zFr_AddTicks(&oprElem, endTicks - beginTicks);
        if(zOss_FWrite(pcmDst, 1, 160 * 2, pPcmHandle) !=  160 * 2)
        {
            zOss_Printf(1, 1,  "fr_EncodeFrame: writefile error");
            return;
        }
    }
    zFr_PutoutOprElem(&oprElem);
    
    zMmp_FrDecClose(pGsmState);
    zOss_FClose(pPcmHandle); 
    zOss_FClose(pGsmHandle);

    return;
}

static BOOL fr_IsFileEqual(const char *strFileName1, const char *strFileName2)
{
    FILE *pFile1Handler = zOss_FOpen(strFileName1, ZFR_READ_MODE);
    FILE *pFile2Handler = zOss_FOpen(strFileName2, ZFR_READ_MODE);
    BOOL isFileEqual    = FALSE;
    
    if(pFile1Handler == NULL)
    {
        zOss_Printf(1, 1, "ļ%sʧ!\r\n", strFileName1);
    }
    if(pFile2Handler == NULL)
    {
        zOss_Printf(1, 1, "ļ%sʧ!\r\n", strFileName2);
    }
    if(pFile1Handler != NULL && pFile2Handler != NULL)
    {
        isFileEqual = fr_IsFileContentEqual(pFile1Handler, pFile2Handler);
    }
    if(pFile1Handler != NULL)
    {
        zOss_FClose(pFile1Handler);
        pFile1Handler = NULL;
    }
    if(pFile2Handler != NULL)
    {
        zOss_FClose(pFile2Handler);
        pFile2Handler = NULL;
    }
    return isFileEqual;
}

static BOOL fr_IsFileContentEqual(FILE *pFile1Handler, FILE *pFile2Handler)
{
    UINT8  file1ReadBuf[100] = { 0 };
    UINT8  file2ReadBuf[100] = { 0 };
    UINT32 readFiel1Len                     = 0;
    UINT32 readFiel2Len                     = 0;
    
    zOss_ASSERT(pFile1Handler != NULL && pFile2Handler != NULL);
    while(1)
    {
        zOss_Memset(file1ReadBuf, 0, sizeof(file1ReadBuf));
        zOss_Memset(file2ReadBuf, 0, sizeof(file2ReadBuf));
        readFiel1Len = zOss_FRead(file1ReadBuf, 1, sizeof(file1ReadBuf), pFile1Handler);
        readFiel2Len = zOss_FRead(file2ReadBuf, 1, sizeof(file2ReadBuf), pFile2Handler);
        if(readFiel1Len != readFiel2Len)
        {
            zOss_Printf(1, 1, "readFiel1Len != readFiel2Len\r\n");
            return FALSE;
        }
        if(readFiel1Len == 0)
        {
            break;
        }
        if(zOss_Memcmp(file1ReadBuf, file2ReadBuf, readFiel1Len) != 0)
        {
            //zOss_Printf(1, 1, "zOss_Memcmp != 0\r\n");
            return FALSE;
        }
    }
    return (zOss_FEof(pFile1Handler) != 0 && zOss_FEof(pFile2Handler) != 0);  
}

/**************************************************************************
* :     ӡ˵
* ˵:     
*   ()  
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_PrintCmds()
{
    SINT32  iCmdsIndex = 0;
    SINT32  iCmdsCount = sizeof(g_zFr_TestCmds)/sizeof(g_zFr_TestCmds[0]);
    
    for(iCmdsIndex = 0; iCmdsIndex < iCmdsCount; iCmdsIndex++)
    {
        zOss_Printf(1, 1, "frtest \t%-20s \t%s",g_zFr_TestCmds[iCmdsIndex].pCmd,
                    g_zFr_TestCmds[iCmdsIndex].pDesc);
    }
}
/**************************************************************************
* :     вѯĳе±
* ˵:     
*   ()  pMmpCmd:
*   ()  
*   ֵ:     е±꣬δҵ-1
* ˵:     
**************************************************************************/ 
static SINT32 fr_FindCmds(const CHAR *pMmpCmd)
{
    SINT32  iCmdsIndex = 0;
    SINT32  iCmdsCount = sizeof(g_zFr_TestCmds)/sizeof(g_zFr_TestCmds[0]);
    
    for(iCmdsIndex = 0; iCmdsIndex < iCmdsCount; iCmdsIndex++)
    {
        if(0 == strcmp((const CHAR *)g_zFr_Cmd,
                        (const CHAR *)g_zFr_TestCmds[iCmdsIndex].pCmd))
        {
            return iCmdsIndex;
        }
    }   
    return -1;
}
/**************************************************************************
* :     ִв 
* ˵:     
*   ()  iCmdIndex:е±
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_ExcuteCmds(SINT32 iCmdIndex)
{
    SINT32  iCmdsCount = sizeof(g_zFr_TestCmds)/sizeof(g_zFr_TestCmds[0]);
    
    if(0 <= iCmdIndex && iCmdIndex <= iCmdsCount)
    {
        g_zFr_TestCmds[iCmdIndex].func();
    }
    else
    {
        zOss_Printf(1, 1, "\n");
        fr_PrintCmds();
    }
}

/**************************************************************************
* :     ߳ں
* ˵:     
*   ()  arg:Ϊ˺̵߳ںָƥ䣬òʱδʹ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static VOID fr_TestEntry(SINT32 arg)
{
    SINT32 iRet;
    UINT32 cpuCost = 2;
    while(1)
    {  
        zOss_GetSemaphore(g_zFr_testSemaphoreID, ZOSS_WAIT_FOREVER);
        iRet = fr_FindCmds(g_zFr_Cmd);
        fr_ExcuteCmds(iRet);
        //cpuCost = Osa_GetProcessCPU(g_zFr_testSemaphoreID);
        //zOss_Printf(1, 1, "%d", cpuCost);
        zOss_PutSemaphore(g_zFr_shellSemaphoreID);
    }    
}
/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* :     shell Ϣպ
* ˵:     
*   ()  pCmdMsg:shellϢ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
VOID zMmp_FrTest( T_Shell_CommandMessage *pCmdMsg )
{
    static ZOSS_THREAD_ID threadID = ZOSS_NULL;
    if(g_zFr_shellSemaphoreID == ZOSS_NULL)
    {
        //pow_GetArmCoreFreq(&freq);
        //zOss_Printf(1, 1, "%d", freq);
        g_zFr_shellSemaphoreID = zOss_CreateSemaphore("zFr_ShellSemaphore", 1); 
        g_zFr_testSemaphoreID  = zOss_CreateSemaphore("zFr_testSemaphore", 0); 
        g_zFr_Cmd = (CHAR *)zOss_Malloc(sizeof(CHAR) * ZFR_MAX_CMD_PARAM_LENGTH);
    }
    zOss_GetSemaphore(g_zFr_shellSemaphoreID, ZOSS_WAIT_FOREVER);
    
    if(1 > pCmdMsg->paraCount)
    {
        zOss_Printf(1, 1, ",: frtest help\n");
        zOss_PutSemaphore(g_zFr_shellSemaphoreID);
        return;
    } 
    strcpy(g_zFr_Cmd, (CHAR *)pCmdMsg->para[0]);
    
    if(threadID == ZOSS_NULL)
    {
        threadID  = zOss_CreateThread("zFr_Test", fr_TestEntry, 0, ZFR_STACK_SIZE, 19, 1, 1);    
    }
    zOss_PutSemaphore(g_zFr_testSemaphoreID);	
}

#ifdef __cplusplus
}
#endif
