/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name:    drvs_vousbvoice.h
* File Mark:  	
* Description:  vousbvoice interface declaration.
* Others:  	
* Version:  v1.0
* Author:   zhou zhongyao
* Date:      2009-12-28
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  

* History 2: 
**********************************************************************/
#ifndef _HAL_VOUSBVOICE_H
#define _HAL_VOUSBVOICE_H


/*************************************************************************
  *                                  Include files                                                                         *
  *************************************************************************/
#include "drv_pub.h"
#include "drvs_io_audio.h"

/*************************************************************************
  *                                  Macro                                                                                  *
  *************************************************************************/


/**************************************************************************
 *                                  Types                                                                                   *
 **************************************************************************/


/**************************************************************************
 *                           Global  Variable                                                                             *
 **************************************************************************/


/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
/*******************************************************************************
 * Function: zDrvVoice_Open
 * Description: This function is used to open iis and teak source.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns:
 *      DRV_ERROR: open source fail
 *      DRV_SUCCESS : open source success
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_Open(VOID);
/*******************************************************************************
 * Function: zDrvVoice_Close
 * Description: This function is used to close iis and teak source.
 * Parameters:
 *    Input:None
 *    Output:None
 *
 * Returns:
 *      DRV_ERROR: close source fail
 *      DRV_SUCCESS : close source success
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_Close(VOID);


/*******************************************************************************
 * Function: zDrvVoice_Enable
 * Description: This function is used to enable the voice of Teak and start iis trans and receive.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns:
 *      DRV_ERROR: operation error
 *      DRV_SUCCESS : operation success
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_Enable(VOID);

/*******************************************************************************
 * Function: zDrvVoice_Disable
 * Description: This function is used to disable the voice of Teak and stop iis .
 * Parameters:
 *   Input:None
 *
 *   Output:None
 *
 * Returns:
 *      DRV_ERROR: operation error
 *      DRV_SUCCESS : operation success
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_Disable(VOID);

/*******************************************************************************
 * Function: zDrvVoice_Config
 * Description: This function is used to config teak volume and uplink/downlink path , give the iis config .
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns:
 *      DRV_ERROR: operation error
 *      DRV_SUCCESS : operation success
 *      DRV_ERR_INVALID_PARAM : error param
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_Config(T_ZDrvI2S_Cfg * i2sCfg , UINT32 bufLength);

/*******************************************************************************
 * Function: zDrvVoice_ReceiveData
 * Description: This function is used to get downlink data from i2s.
 * Parameters:
 *   Input:
 *          pBuf : buf point
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *              DRV_ERR_INVALID_PARAM:param error
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_ReceiveData(T_ZDrvAudio_BufInfo * pBuf);

/*******************************************************************************
 * Function: zDrvVoice_FreeDownlinkBuf
 * Description: This function is used to free downlink buf.
 * Parameters:
 *   Input:
 *          pBuf : buf address point
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *              DRV_ERR_INVALID_PARAM:param error
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_FreeDownlinkBuf(VOID * pBuf);

/*******************************************************************************
 * Function: zDrvVoice_SendData
 * Description: This function is used to uplink buf.
 * Parameters:
 *   Input:
 *          pDatabuff: buffer point
 *          buffLength: buffer length
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *              DRV_ERROR:operate fail
 *              DRV_ERR_INVALID_PARAM:param error
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVoice_SendData(UINT32 * pDatabuff, UINT32 buffLength);

/*******************************************************************************
 * Function: zDrvVoice_GetUplinkBuf
 * Description: This function is used to get the null uplink buf.
 * Parameters:
 *   Input:
 *          pBuf: buffer info
 *   Output:None
 *
 * Returns: DRV_SUCCESS: operate success
 *          DRV_ERROR:operate fail
 *          DRV_ERR_INVALID_PARAM:param error
 *
 * Others:
 ********************************************************************************/
SINT32  zDrvVoice_GetUplinkBuf(T_ZDrvAudio_BufInfo * pBuf);

#endif    /* _HAL_I2S_H */
