/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98D_DHCP
*    : dhcp_api.h
* ļ : 
* ʵֹ : dhcpģӿڷװ
*      : LiuZhengXuan
*      : V1.0
*  : 2012-08-14
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _DHCP_API_H    
#define _DHCP_API_H

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"

#ifdef __cplusplus
extern "C"            
{
#endif

/**************************************************************************
* 
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    UINT32 addr;
}T_zDhcp_IPv4Addr;

typedef struct
{
    UINT32 addr[4];
}T_zDhcp_IPv6Addr;

typedef union
{
    T_zDhcp_IPv4Addr v4Addr;
    T_zDhcp_IPv6Addr v6Addr;
}T_zDhcp_IPAddr;
typedef struct 
{
    UINT8            pdpType;       /* IPv4-0x21 IPv6-0x57 IPv4v6-0x8d            */
    T_zDhcp_IPv4Addr ipv4Addr;      /* ϱipv4ַ                         */
    T_zDhcp_IPv4Addr routerIp;      /* ipַ                                 */
    T_zDhcp_IPv4Addr snMask;        /*                                    */
    T_zDhcp_IPv4Addr v4Dns1;        /* IPv4 DNS server addresses 1                */
    T_zDhcp_IPv4Addr v4Dns2;        /* IPv4 DNS server addresses 2                */
    T_zDhcp_IPv6Addr ipv6Addr;      /* ϱipv6ַ,ǰֻϱ8ֽڵID   */     
    T_zDhcp_IPv6Addr v6Dns1;        /* IPv6 DNS server addresses 1                */ 
    T_zDhcp_IPv6Addr v6Dns2;        /* IPv6 DNS server addresses 2                */  
}T_zDhcp_PdpCfgInf;                 /* PDPȡϢṹ                */

typedef enum
{
    DHCP_FRAMETYPE_IP_V4_TRANS = 0, /* IPv4   */
    DHCP_FRAMETYPE_IP_V6_TRANS,     /* IPv6   */
    DHCP_FRAMETYPE_IP_V4_DHCP_RSP,  /* IPv4DHCPӦ   */
    DHCP_FRAMETYPE_IP_V6_DHCP_RSP,  /* IPv6DHCPӦ   */
    DHCP_FRAMETYPE_ARP_RSP,         /* ARPӦ          */
    DHCP_FRAMETYPE_NDP_RSP,         /* NDPӦ          */
    DHCP_FRAMETYPE_INVALID          /* Ч             */
}T_zDhcp_FrameType;                 /* ȡ֡   */

/**************************************************************************
* 
**************************************************************************/
VOID zDhcp_Init(VOID);
UINT32 zDhcp_OpenSvr(const T_zDhcp_PdpCfgInf *pPdpCfgInf);
T_zDhcp_FrameType zDhcp_ParseEtherFrame(UINT32 handle, const UINT8 *pEtherFrame, UINT16 etherFrameSize, BOOL *pIsRecvRs);
UINT16 zDhcp_GetRspEtherFrame(UINT32    handle, 
                              UINT8     *pReqEtherFrame, 
                              UINT16    reqEtherFrameSize, 
                              UINT8     *pRspEtherFrameBuf, 
                              UINT16    rspEtherFrameBufSize, 
                              BOOL      *pIsDhcpOver);
UINT16 zDhcp_GetRspArpFrame(UINT32 handle, UINT8 *pReqEtherFrame, UINT16 reqSize, UINT8 *pRspEtherFrame, UINT16 rspSize, UINT32 addr);
UINT32 zDhcp_GetCfgInfV4addr(UINT32 handle);
BOOL zDhcp_FillEtherFrame(UINT32 handle, UINT8 *pEtherFrame, UINT16 etherFrameSize, BOOL *pIsRecvRa);
VOID zDhcp_CloseSvr(UINT32 handle);
VOID zDhcp_UnInit(VOID);

BOOL zDhcp_StartUfi(VOID);
BOOL zDhcp_RecycleUfiIp(T_zDhcp_IPv4Addr *pIpv4AddrRemoved, T_zDhcp_IPv6Addr *pIpv6AddrRemoved, BOOL isIpv4Addr);
BOOL zDhcp_StaticSetUfiIpv4(UINT8 *pMacAddr, T_zDhcp_IPv4Addr *pSetIpv4Addr);
VOID zDhcp_StopUfi(VOID);

UINT32 zDhcp_GetSrcIpPortType(UINT8 *pPacket, T_zDhcp_IPAddr *pIpAddr, UINT16 *pPort, UINT16 *pPdpType);
UINT32 zDhcp_GetDestIpPortType(UINT8 *pPacket, T_zDhcp_IPAddr *pIpAddr, UINT16 *pPort, UINT16 *pPdpType);
UINT32 zDhcp_UpdatePacketSrcIpv4(UINT8 *pPacket, T_zDhcp_IPv4Addr *pIpAddr);
UINT32 zDhcp_UpdatePacketDestIpv4(UINT8 *pPacket, T_zDhcp_IPv4Addr *pIpAddr);
BOOL zDhcp_IsDnsPacket(UINT8 *pPacket);
/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif
 
#endif  /* _DHCP_API_H */

