/*******************************************************************************
* Ȩ (C)2008,ͨѶɷ޹˾
* ϵͳ	: MediaFileHandlerModule
* ļ	: ZMF_OutDef.h
* ժҪ	: ӿݽṹ
* ǰ汾	: 
*     	: ｡
* 	: 200894
* ޸ļ¼	: 
*     		    		޸ 		޸ժҪ
*******************************************************************************/
/**************************** ѡͷļ ****************************/
#ifndef __ZMF_OUTDEF_H__  
#define __ZMF_OUTDEF_H__  

#include "ZMTypeDef.h"
#include "ZMMediaType.h"

/********************************** ͺ **********************************/
#define ZMF_MP3_TAG_MAX_NUM	6
#define ZMF_MAX_PATH_LEN		256

#define ZMF_MAX_SPS_LEN		256
#define ZMF_MAX_PPS_LEN		256


#ifdef __FILEHANDLE__FILE__
	#define MFILEHANDLE FILE *
	#define OPENMODETYPE  const char *
	#define OPENMODEREAD    "rb"
	#define OPENMODEWRITE   "wb"
	#define FILERETURN NULL
#else
	#define MFILEHANDLE SInt32
	#define OPENMODETYPE  const SInt32
	#if defined(__linux__)
		#define OPENMODEREAD    (O_RDONLY | O_BINARY | O_LARGEFILE)
		#define OPENMODEWRITE	(O_CREAT | O_WRONLY | O_BINARY | O_LARGEFILE)
	#else
		#define OPENMODEREAD    (O_RDONLY | O_BINARY)
		#define OPENMODEWRITE	(O_CREAT | O_WRONLY | O_BINARY)
	#endif
	#define FILERETURN -1
#endif



#ifndef NULL
	#define  NULL 0
#endif

#ifdef WIN32PACK
#pragma pack(4)
#endif

// ض
typedef unsigned long		SSize_T;
//typedef void*				ZOSS_MUTEX_ID;
// 
typedef enum 
{
	ZMF_RS_ERROR			= -1,		// ݴ
	ZMF_RS_OK				= 1,		// ɹ
	ZMF_RS_ErNoChannel,					// ͨ
	ZMF_RS_UNEXPECTED,					// δ֪
	ZMF_RS_NOT_IMPL,					// δʵ
	ZMF_RS_INVALID_ARG,					// Ч
	ZMF_RS_OPEN_FILE_FAIL,				// ļ򿪴
	ZMF_RS_READ_FILE_FAIL,				// ļȡ
	ZMF_RS_Write_FILE_FAIL,				// ļд
	ZMF_RS_DATA_ERROR,					// ݸʽ
	ZMF_RS_ChannelLimit,				// ﵽͨ
	ZMF_RS_MEMMALLOC_ERR,				// ڴ
	ZMF_RS_MEMFREE_ERR,					// ڴͷŴ
	ZMF_RS_DATA_READ_OVER,              // ļѶ
	ZMF_RS_SEEK_UNSUPPORTED,			// ֧Seek
	ZMF_RS_AUDIO_TRACK_OVER,			// Ƶݶȡ
	ZMF_RS_VIDEO_TRACK_OVER,			// Ƶݶȡ
	ZMF_RS_MODULE_INIT_FAIL,			// صδʼ
}EZMFResultCode;						

// ļģʽ
typedef enum
{
	ZMF_FILE_UNKNOWN		= -1,		// δ֪ģʽ
	ZMF_FILE_PARSE			= 1,		// ļʶ
	ZMF_FILE_READ,						// ȡļ
	ZMF_FILE_WRITE,						// ļ
}EZMFOpenFlag;							

//ûṹ
typedef struct T_ZMFUserConfigInfo
{
	Bool16 bInputFrameTypeFlg;             //д3GPļʱǷûؼ֡ǣTRUE--ûؼ֡ʶ

}T_ZMFUserConfigInfo;

// AMRʽ֡
typedef struct T_ZMFAMRFrameUnit
{
	UInt8	u8FrameType;				// ֡ͣӦ
	char   cFrameQuality;				// ֡ʶ 1Ϊ֡룻0Ϊ֡ܽ
}T_ZMFAMRFrameUnit;						// AMR ֡ԪϢ

// AACʽ֡
typedef struct T_ZMFAACFrameUnit
{
	UInt32 u32Profile_ObjectType;		// profile
	UInt32 u32SampleRate;				// 
}T_ZMFAACFrameUnit;						// AAC ֡ԪϢ

// ADIFϢ
typedef enum
{
	ZMF_MP3_MPEG1	= 1,			
	ZMF_MP3_MPEG2,					
	ZMF_MP3_MPEG2Dot5,				
}EMP3MPEGType;

typedef enum
{
	ZMF_MP3_LAYER1	= 1,			
	ZMF_MP3_LAYER2,				
	ZMF_MP3_LAYER3,			
}EMP3LayerType;

typedef enum
{
	ZMF_MP3_STERO	= 1,		// 
	ZMF_MP3_JOINTSTEREO,		// 
	ZMF_MP3_SINGLESTEREO,		// 
	ZMF_MP3_DUALSTEREO,			// ˫
}EMP3ChannelMode;

// MP3 ֡ԪϢ
typedef struct T_ZMFMP3FrameUnit
{
	EMP3MPEGType	eMpegVersion;		// Mpeg1Mpeg2Mpeg2.5
	EMP3LayerType	eLayer;				// Layer1Layer2Layer3
	EMP3ChannelMode	eChannel;			// 
	UInt8			u8Padding;			// Ƿλ
	UInt32			u32BitRate;         // 
	Float64			f64SampleRate;		// 
}T_ZMFMP3FrameUnit;						

//PCMʽ֡
typedef struct T_ZMFPCMFrameUnit
{
	UInt32			u32BytesPerSample;	// ÿֽ
}T_ZMFPCMFrameUnit;	

typedef struct T_ZMFFrameInfo
{
	Bool8   bIsKeyFrame;                // ؼ֡ TRUE---ؼ֡

}T_ZMFFrameInfo;
// ý֡Ԫ
typedef struct T_ZMFOutPutUnit
{
	UInt32 u32TrackID;					// عIDMP4/3GPAVIȶļЧFileInfoеֶζӦ
    enum ZM_CodecID eCodeID;			// 
	UInt32  u32Len;						// 洢ݵڴĴС
	UInt8*	pPacket;					// 洢ݵڴĵַ
	UInt32  u32DecodeTime;				// ݵĽʱ
    T_ZMFFrameInfo t_FrameInfo;
    union
	{
		T_ZMFAMRFrameUnit t_AMRFrameUnit;      // AMR ֡ʽϢ
		T_ZMFAACFrameUnit t_AACFrameUnit;      // AAC ֡ʽϢ 
		T_ZMFMP3FrameUnit t_MP3FrameUnit;	   // MP3 ֡ʽϢ 
		T_ZMFPCMFrameUnit t_PCMFrameUnit;      // PCM ֡ʽϢ
	}uFrameUnit;						// ݵĸʽϢ
}T_ZMFOutPutUnit;


// ADIFϢ
typedef enum
{
	ZMF_ADIF_UNKNOWN	= -1,
	ZMF_ADIF_CBR		= 1,			// ̶
	ZMF_ADIF_VBR						// ɱ
}EADIFBitStreamType;

// ADTS ProfileϢ
typedef enum
{
	ZMF_ADTS_Profile_UNKNOWN				= -1,
	ZMF_ADTS_Profile_Main					= 1,
	ZMF_ADTS_Profile_LowComplexity,
	ZMF_ADTS_Profile_ScalableSamplngRate
}EADTSProfile;							// profile

// AACļϢ
typedef struct TZMFAACInfo
{
	enum ZM_FileID eFileID;             // ļID
	union
	{
		EADIFBitStreamType eADIFInfo;   // ADIF Ϣ
		EADTSProfile       eADTSInfo;   // ADTS Ϣ
	}tAACInfo;
}TZMFAACInfo;							// AAC ļϢ

// AMRļϢ
typedef struct TZMFAMRInfo
{
	enum ZM_FileID 	eFileID;            // ļID
	UInt8   		u8ChannelNum;		// 
}TZMFAMRInfo;							// AMR ļϢ

// MP3 VBR Ϣ
typedef struct TZMFVBRInfo
{
	UInt32           u32LameLen;		// VBRLameϢĳ
	UInt8*           pLameInfo;			// VBRеLameϢ
	T_ZMFMP3FrameUnit t_MP3FrameUnit;	// VBR֡Ϣ
}TZMFVBRInfo;

// MP3 Tag ö
typedef enum
{
    ZMF_MP3_UNKNOW      = 0,
	ZMF_MP3_ID3V1		= 1,	// ID3V1ǩ
	ZMF_MP3_ID3V23		= 2,	// ID3V2.3ǩ
	ZMF_MP3_ID3V24,				// ID3V2.4ǩ	
	ZMF_MP3_APETAG,				// APETAGǩ
    ZMF_MP3_LYRICS,				// LYRICSǩ
}EZMFMP3TAGTYPE;

// MP3 Tag Ϣ
typedef struct TZMFTAGInfo
{
	EZMFMP3TAGTYPE  eTagType;		// TAG
	UInt32			u32TagLen;		// TAGĳ
	UInt8*          pTagInfo;		// TAG
}TZMFTAGInfo;

// MP3ļϢ
typedef struct TZMFMP3Info
{
	 enum ZM_FileID		eFileID;
	 Bool16         bVBR;						// ǷΪVBRʶ1: ΪVBR; 0: ΪCBR;
	 TZMFVBRInfo    tVBRInfo;					// VBR֡Ϣ
	 UInt32         u32FrameNum;				// ֡
	 UInt32         u32FileLength;				// ļ
     TZMFTAGInfo*   aTag[ZMF_MP3_TAG_MAX_NUM];	// ǩ
}TZMFMP3Info;


// MIDIļϢ
typedef struct TZMFMIDIInfo
{
	enum ZM_FileID	eFileID;            // ļID
	char			aFileTag[4];		// midi ļͷʶ "MThd"
	UInt32			u32FileTagSize;		// ļͷChunk̶ֽΪ6
	UInt16			u16FileFormat;      // Midiĸʽ0죬1ͬ죬2ͬ
	UInt16			u16TrackNum;		// 
	UInt16			u16TickDivision;	// һķticktickMIDIСʱ䵥Ԫ
}TZMFMIDIInfo;


// ISO Brand ö
typedef enum
{
	ZMF_Brand_UNKNOWN	= -1,
	ZMF_Brand_isom		= 1,
	ZMF_Brand_iso2,
	ZMF_Brand_mp41,
	ZMF_Brand_mp42,
	ZMF_Brand_avc1,
	ZMF_Brand_3gp4,
	ZMF_Brand_3gp5,
	ZMF_Brand_3gp6, 
	ZMF_Brand_3gr6,
	ZMF_Brand_3gs6,
	ZMF_Brand_3ge6,
	ZMF_Brand_3gg6,
}TZMFISOBrand;							// ISO ļͱʶ

typedef enum ZM_CodecID EMediaAudioType;

typedef enum ZM_CodecID EMediaVideoType;

typedef enum ZM_CodecType EMediaType;

// ӶpPrivateParaĽ
// aac
typedef struct _tag_ZMF_AAC_ConfigInfo
{
	UInt8 u8ObjectType;									// Ƶ 
	UInt32 u32SamplingRate;								
	UInt8 u8ChannelConfig;								// <1, 7>֮, ɲμ14496-3 table1.17
}TZMFAACConfigInfo;

// h263
typedef struct _tag_ZMF_H263_DecSpecStruc
{
	char u32Vendor[4];									// ˵ʹõı
	UInt8  u32DecoderVersion;							// Ҫİ汾
	UInt8  u8H263Level;		   
	UInt8  u8H263Profile;
}TZMFH263DecSpecStruc;

// h264
typedef struct _tag_ZMF_H264_ConfigParm 
{
	UInt16 u16SpsLenth;
	UInt8 aSps[ZMF_MAX_SPS_LEN];
	UInt16 u16PpsLenth;
	UInt8 aPps[ZMF_MAX_PPS_LEN];
}TZMFH264ConfigInfo;

// mp4v
typedef struct _tag_ZMF_Mp4v_Esds_Vosh 
{
	UInt8 u8ProfileLevel;								// ֵϸϢμ14496-2 table G-1
}TZMFMp4vEsdsVosh;

typedef struct _tag_ZMF_Mp4v_Esds_Vo
{
	UInt8 u8ObjectId;									// ֵμ14496-2 table 6-6
}TZMFMp4vEsdsVo;

typedef struct _tag_ZMF_Mp4v_Esds_Vol
{
	UInt8  u8TimeBits;								
	UInt16 u16TimeTicks;							 
	UInt16 u16FrameDuration;							// ֡
	UInt16 u16FrameWidth;								// ֡
	UInt16 u16FrameHeight;								// ֡
	UInt8  u8AspectRatioDefine;							// ˵AspectRatioWidthAspectRatioHeigthǷֵ
	UInt8  u8AspectRatioWidth;							
	UInt8  u8AspectRatioHeight;							
}TZMFMp4vEsdsVol;

typedef struct _tag_ZMF_MP4V_Config_Info
{
	TZMFMp4vEsdsVosh tVosh;
	TZMFMp4vEsdsVo   tVo;
	TZMFMp4vEsdsVol  tVol;
}TZMFMP4VConfigInfo;

typedef union _tag_ZMF_Stsd_Config
{
	TZMFH263DecSpecStruc tH263Config;
	TZMFH264ConfigInfo	 tH264Config;	
	TZMFMP4VConfigInfo   tMp4vConfg;
	TZMFAACConfigInfo    tAACConfig;
}UZMFStsdConfig;


// ƵϢ
typedef struct ZMF_TMFAudioParam
{
	EMediaAudioType	eAudioType;			// Ƶʽ
	SInt32	s32SampleRate;				// 
	UInt8	u8Channel;					// 
	UInt8	uRev[3];					// Ϣδʹ
	SInt32	s32Bitrate;					// 
	UInt16  u16PacketMode;				// ģʽ
	UInt32	u32PrivateParaLen;			// Ϣ
	UInt8	*pPrivatePara;				// ϢֻԸΪMP4AЧ
	Bool8  b8UseStruct;				// ǷʹýṹϢ: ĬṹϢtrue; 
										//			           дΪtrueͨtStsdConfigϢfalseͨpPrivateParaϢ
	UZMFStsdConfig uStsdConfig;

}ZMF_TMFAudioParam;

// ƵϢ
typedef struct ZMF_TMFVideoParam
{
	EMediaVideoType	eVideoType ;		// Ƶʽ
	UInt32	u32Width;					// ͼ
	UInt32	u32Height;					// ͼ߶
	UInt32	u32FPS;						// ֡
	SInt32	s32Bitrate;					// , λkbps
	UInt32	u32PrivateParaLen;			// Ϣ
	UInt8	*pPrivatePara;				// Ϣ
	Bool8  b8UseStruct;				// ǷʹýṹϢ: ĬṹϢtrue; 
										//			           дΪtrueͨtStsdConfigϢfalseͨpPrivateParaϢ
	UZMFStsdConfig uStsdConfig;
}ZMF_TMFVideoParam;

// ýϢ
typedef struct ZMF_TTrackInfo
{
	EMediaType		eMediaType;			// ر
	UInt32          u32TrackID;			// 
	Bool16          bIsHintTrack;		// Ƿ
	Bool16			bIsActive;			// Ƿ񱻼
	Float64			f64TimeScale;		// ʱ
	UInt32			u32Duration;		// ʱ
	union
	{
		ZMF_TMFAudioParam tAudioParam;		// ƵϢ
		ZMF_TMFVideoParam tVideoParam;		// ƵϢ
	}tTrackInfo;
}ZMF_TTrackInfo;

// ISO ļϢ
typedef struct  TZMFISOInfo
{
	enum ZM_FileID		eFileID;			// ļ
	TZMFISOBrand		eBrand;             // ISOBrand
	UInt32				u32TrackNum;		// 
	ZMF_TTrackInfo*	    pTrackArray;		// Ϣ
}TZMFISOInfo;

typedef struct T_WAVEFormatInfo
{
	EMediaAudioType		eAudioType;			// Ƶľ
	UInt16				u16Channels;		// Ƶ
	UInt32				u32SamplesPerSec;	// ÿĲ
	UInt32				u32AvgBytesPerSec;	// ƽÿֽ
	UInt32				u32BlockAlign;		// ĴС
	UInt16				u16BytesPerSample;	// ÿֽ
}T_WAVEFormatInfo;

typedef struct T_BITMapInfo
{
	EMediaVideoType		eVideoType ;		// Ƶʽ
	UInt32				u32Width;			// ͼ
	UInt32				u32Height;			// ͼ߶
	UInt32				u32biPlanes;		// Ŀ豸λƽΪ1
	UInt32				u32biBitCount;		// ָʾɫʱҪõλ
	UInt32				u32biCompression;	// ͼѹʽʶĸ
}T_BITMapInfo;

// WAVļϢ
typedef struct TZMFWAVInfo
{
	enum ZM_FileID		eFileID;        // ļID
    T_WAVEFormatInfo    tWaveInfo;		// ƵϢ
}TZMFWAVInfo;

// ýϢ
typedef struct ZMF_TStreamInfo
{
	EMediaType		eMediaType;			// ر
	UInt32          u32StreamID;		// 
	Bool16          b16ErrFlag;			// ǷǴģǴģ򲻻ȡ
	Bool16			bIsActive;			// Ƿ񱻼
	UInt32			u32SampleDuration;  // ÿʱλΪms
	UInt64			u64Duration;        // ùʱλms
	UInt32			u32SampleSize;		// ùĴСвСһôСֵһֵΪ0
	Bool16			b16IsHasSuperIndex; // ʶǷг
	union
	{
		T_WAVEFormatInfo tWaveFmtInfo;		// ƵϢ
		T_BITMapInfo	 tBitMapInfo;		// ƵϢ
	}tStreamInfo;
}ZMF_TStreamInfo;

// AVIļϢ
typedef struct TZMFAVIInfo
{
	enum ZM_FileID		eFileID;			// ļID
	UInt32				u32StreamNum;		// Ƶĸ
    ZMF_TStreamInfo*    pStreamInfo;		// ƵϢ
}TZMFAVIInfo;

// ýļϢ
typedef struct T_ZMFFileInfo
{
	 enum ZM_FileID eFileType;			// ļ
	 union	 
	 {
		 TZMFAACInfo t_aacInfo;         // AAC ļϢ
		 TZMFAMRInfo t_amrInfo;         // AMR ļϢ
		 TZMFMP3Info t_mp3Info;         // MP3 ļϢ
		 TZMFISOInfo t_isoInfo;         // ISO ļϢ
		 TZMFWAVInfo t_wavInfo;         // WAV ļϢ
		 TZMFAVIInfo t_aviInfo;         // WAV ļϢ
		 TZMFMIDIInfo t_midiInfo;       // MIDI ļϢ
	 }tFileInfo; 
	 UInt32         u32Duration;        // ʱλms
}T_ZMFFileInfo;

/**********************************  **********************************/

/*********************************** ඨ ***********************************/
#ifdef WIN32PACK
#pragma pack()
#endif

#endif 
