/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_spi.h
 * File Mark:
 * Description:  Provide spi hal function prototype declaration and type declaration.
 * Others:
 * Version:       V0.5
 * Author:        zhenghong
 * Date:          2008-03-19
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _USB_DETECT_H
#define _USB_DETECT_H

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
* 	                               Include files
****************************************************************************/
#include "drvs_gpio.h"
/****************************************************************************
* 	                                Macros
****************************************************************************/
#define USB_ENUM_DEBUG_EN 1
/**
 * Messages sent from the Phy to the OTG driver.
 *
*/
typedef enum _T_UsbHal_ConnectMessage
{
    CONNECTED_TO_HOST = 0x10,  /**< Host connect detected */
    DISCONNECTED_FROM_HOST,   /**< Host disconnect detected */
    CONNECTED_TO_DEVICE,  /**< Function connect detected */
    DISCONNECTED_FROM_DEVICE,  /**< Function disconnect detected */
    CHECK_CONNECT_MODE,
    CHECK_CONNECT_QUICK_POWER_ON,
    RECONNECT_TO_HOST
}T_UsbHal_ConnectMessage;

typedef enum _T_UsbHal_ConnectionState {
    USB_DEVICE_UNPLUGGED=0,
    USB_DEVICE_PLUGGED
} T_UsbHal_ConnectionState;

typedef enum _T_plug_in
{
	NOTHING,
	COMPUTER,
	CHARGER
}plug_in;
/****************************************************************************
* 	                                Types
****************************************************************************/
typedef SINT32 (*T_ZDrvUSBRef_ChargerDetect_CallBack)(UINT32);
/****************************************************************************
* 	                                Constants
****************************************************************************/

/****************************************************************************
* 	                                Global  Variables
****************************************************************************/
extern T_ZDrvUSBRef_ChargerDetect_CallBack g_USBRef_ChargerDetect;
/****************************************************************************
* 	                                Function Prototypes
****************************************************************************/
SINT32 zDrvUsbRef_Detect_Initiate(VOID);

#ifdef __cplusplus
}
#endif

#endif /*_HAL_SPI_H*/
