/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   Ƶģ
* ļƣzte_audio.c
* ļʶ 
* ժҪ    
*
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/4/23    1.0                      Է                           
* 2012/07/18    P98CV3.2.3B01      P98C-CXX-0001         EC:617001630060ƵbufferƵŹر
************************************************************************/

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
 #include "zMsp_Com.h"
 #include "zte_audioEx.h"
 #include "ZMF_API.h"
 #include "drv_api.h"
 #include "zMsp_FileFunc.h"
 
//ʹļȡ
#define  USE_MEIDA_MEM_POOL
 
 /**************************************************************************
 *                                                                    *
 **************************************************************************/
 /* ƵģڲʹϢ */
enum
{
    EV_AUDIO_START_PLAY_SYN = 1,   /* ʼ               */
    EV_AUDIO_STOP_PLAY_SYN,        /* ֹͣ               */
    EV_AUDIO_PAUSE_PLAY_SYN,       /* ͣ               */
    EV_AUDIO_RESUME_PLAY_SYN,      /* ָ               */
    EV_AUDIO_SEEK_PLAY_SYN,        /* ضλ             */
    EV_AUDIO_CLOSE_PLAY_SYN,       /* رղ               */

    EV_AUDIO_OUT,                  /* ߳   */
    EV_AUDIO_DATA_DECODE,          /* ߳ݽ   */

    EV_AUDIO_OUT_PAUSE,            /* ߳ͣ   */
    EV_AUDIO_OUT_RESUME,           /* ָ̻߳   */
    EV_AUDIO_OUT_SEEK,             /* ߳ضλ     */
    EV_AUDIO_OUT_STOP,             /* ֹ߳ͣ   */ 
    EV_AUDIO_OUT_CLOSE,            /* ̹߳ر   */ 
    EV_AUDIO_OUT_OVER,             /* ߳ */
    EV_AUDIO_EX,                   /* Ƶģ쳣 */

    #ifdef USE_MEIDA_MEM_POOL
    EV_AUDIO_FILE_READ,
    EV_AUDIO_FILE_SEEK,
    EV_AUDIO_FILE_STOP,
    EV_AUDIO_FILE_READ_INIT,
    EV_AUDIO_FILE_SEEK_INIT,
    EV_AUDIO_FILE_SEEK_START,
    #endif
    
};

/* ƵģڲʹõĴ */
enum
{
    AUDIO_OP_SUCCESS = 0,          /* Ƶݴ   */
    AUDIO_OP_ERROR   = -1,         /* Ƶݴ   */
    AUDIO_OP_DATAEND = -2,         /* Ƶݶȡ   */
    AUDIO_OP_DEVICE_ERR = -3,      /* ײ豸쳣       */

};

/* Audioģ쳣־ */
enum
{
    AUDIO_NO_EXP                = 0,       /* 쳣           */
    AUDIO_OP_EXP                = 1 << 0,  /* 쳣         */        
    AUDIO_PCM_EXP               = 1 << 1,  /* ײPCM豸쳣  */ 
    AUDIO_BUF_EXP               = 1 << 2,  /* ײӲBuf쳣  */  
    AUDIO_FILE_EXP              = 1 << 3,  /* ļ쳣       */
    AUDIO_FILE_OVER_EXP         = 1 << 4,  /* Ƶ     */
};

/* Tone쳣־ */
enum
{
    TONE_NO_EXP                = 0,       /* 쳣           */
    TONE_OP_EXP                = 1 << 0,  /* 쳣         */        
    TONE_DEV_EXP               = 1 << 1,  /* ײ豸쳣     */ 
    TONE_OVER_EXP              = 1 << 2,  /* Tone     */
};
/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define  AUDIO_MAX_PATH_LEN     1024
#define  AUDIO_CODEC_NAMELEN    64
#define  MAX_CODEC_NUM          10

/****************߳Ϣ*********************/
/* ߳ȼ */
#define AUDIO_CON_PRI     19                        /* Ƶ߳ȼ */
#define AUDIO_OUT_PRI     19                        /* Ƶ߳ȼ     */

/* ߳ջС */
#define AUDIO_CON_STACK   (60 * 1024)               /* Ƶ߳ջ     */
#define AUDIO_OUT_STACK   (4 * 1024)                /* Ƶ߳ջ         */

/* ߳ */
#define AUDIO_CON_THREAD  "audio_control_thread"    /* Ƶ߳     */
#define AUDIO_OUT_THREAD  "audio_output_thread"     /* Ƶ߳         */


/****************߳Ϣ*********************/
#define AUDIO_CONTROL_SEM "audio_control_sem"       /* Ƶſͬź */
#define AUDIO_OUTPUT_SEM  "audio_output_sem"        /* Ƶͬź     */

#define AUDIO_BUF_AMR_FILE "c:\\audio_buf_file.amr"  /* Buffer(amr)Ӧļ */
#define AUDIO_BUF_MP3_FILE "c:\\audio_buf_file.mp3"  /* Buffer(mp3)Ӧļ */
#define AUDIO_BUF_AAC_FILE "c:\\audio_buf_file.aac"  /* Buffer(aac)Ӧļ */
#define AUDIO_BUF_MIDI_FILE "c:\\audio_buf_file.midi" /* Buffer(midi)Ӧļ */

/* ̨ض */
#ifdef TEST_CREATE_INDEX

#define AUDIO_INDEX_THREAD   "audio_create_index_thread" /* ̨߳ */
#define AUDIO_INDEX_SEM      "audio_create_index_sem"    /* ߳ź */
#define AUDIO_INDEX_STACK    (10 * 1024)                 /* ߳ջռ */
#define AUDIO_INDEX_PRI      20                          /* ߳ȼ */

/* дʱ˳Ļص */
EZMFResultCode zmfCreateIndexOut(SInt32 o_s32ParsedSecond, Bool8* o_b8QuitFlag);
static VOID IndexCreatingThreadEntry(SINT32 arg);
static AUDIO_RESULT_E ReleaseIndexCreatingThread();
static AUDIO_RESULT_E InitIndexCreatingThread();

static BOOL                  g_bIsFinishedIndex     = FALSE;   /* ߳Ƿ */
static BOOL                  g_bIsQuitIndexCreating = FALSE;   /* ;˳ */
static ZOSS_THREAD_ID        g_IndexThreadID        = NULL;
static ZOSS_SEMAPHORE_ID     g_IndexSemID           = NULL;
static VOID *                g_ptExIndex             = NULL;    /* ݽṹ */
    
#endif

#ifdef USE_MEIDA_MEM_POOL

#define AUDIO_FILEREAD_THREAD   "audio_fileread_thread" /* ļȡ߳ */
#define AUDIO_FILEREAD_SEM      "audio_fileread_sem"    /* ļȡź */
#define AUDIO_FILECTRL_SEM      "audio_filectrl_sem"    /* ļź */
#define AUDIO_DATALIST_LOCK     "audio_datalist_lock"   /*  */
#define AUDIO_FILEREAD_STACK    (10 * 1024)             /* ļȡ߳ջ */
#define AUDIO_FILEREAD_PRI      20                      /* ļȡ߳ȼ */
#define AUDIO_POOL_SIZE         20                      /* 󻺳֡Ŀ */

struct _T_MEDIADATALIST_NODE
{
    T_ZOss_Node       tNode;
    T_ZMFOutPutUnit  *pOutUnit;
};

typedef struct _T_MEDIADATALIST_NODE T_MEDIA_AUDIODATA_NODE;

static T_ZOss_List              *g_pAudioDataList        = NULL; //Ƶ
static ZOSS_THREAD_ID            g_FileThreadID          = NULL;
static ZOSS_SEMAPHORE_ID         g_FileReadSemID         = NULL;
static ZOSS_SEMAPHORE_ID         g_FileCtrlSemID         = NULL;
static ZOSS_MUTEX_ID             g_DataListLock          = NULL;

static VOID Audio_FileReadThreadEntry(SINT32 arg);
static EZMFResultCode Audio_Seek_Msg(UINT32 uiOffset);
static EZMFResultCode Audio_Seek_Adapt(UINT8 uiSeekFlag);
static EZMFResultCode Audio_GetNextAudioFrame(T_MEDIA_AUDIODATA_NODE **pData,BOOL bInit);
static VOID Audio_ReadData(BOOL bInit);
static VOID Audio_ReleseDataList(VOID);
    
#endif


/**************************************************************************
 *                                                                 *
 **************************************************************************/
/* Ƶ״̬ */
typedef enum
{
    AUDIO_BUF_INVALID = 0,                /* ƵЧ       */
    AUDIO_BUF_UNUSED,                     /* ƵЧδʹ */
    AUDIO_BUF_USED,                       /* ƵЧʹ */
}EAudioBufState;

/* Ƶ */
typedef struct _T_AudioBuffer
{
    VOID                *pPhyBuffer;      /* ַ          */
    UINT32               uiBufLen;        /* ԭʼ          */
    UINT32               uiUsedLen;       /* ʹó          */
    UINT32               uiStartTime;     /* PCMݿʼʱ */
    UINT32               uiEndTime;       /* PCMݽʱ */
    EAudioBufState       eBufState;       /* Ƶ״̬          */
}T_AudioBuffer;

typedef enum
{
    AUDIO_PLAY_STATE_IDLE,
    AUDIO_PLAY_STATE_OPEN,
    AUDIO_PLAY_STATE_READY,
    AUDIO_PLAY_STATE_PLAY,
    AUDIO_PLAY_STATE_PAUSE,
}AUDIO_PLAY_STATE;

/* ƵϢ */
typedef struct
{       
    CHAR                       filepath[AUDIO_MAX_PATH_LEN+1];  /*ƵԴ·*/
    VOID                      *pMidiBuf;
    UINT32                     iStartOffset;
    UINT32                     iSeekOffset;
    UINT32                     playtimes;
    UINT32                     iMidisize;  
    AUDIO_PLAY_STATE           curstate;
    T_MSP_CHANNEL_OUTPUT       outputchannel;
    T_MSP_OUTPUT_VOLUME_LEVEL  volume;
}AUDIO_PLAY_PARAM_T;

/* ƵſϢ */
typedef struct _T_Audio_ControlParam
{
    BOOL                       bBufPlay;           /* Buffer͵Ƶ */
    SINT32                     iAudioExp;          /* Audioģ쳣־    */
    UINT32                     uiFdAudio;          /* Audio豸            */
    UINT32                     uiFdMidi;           /* Midi豸             */
    T_MediaAudioDecHandle     *pAudioHandle;       /* Ƶ       */
    T_AudioBuffer              tAudioBuffer;       /* Ƶݻ   */
    ZOSS_THREAD_ID             pControlThread;     /* Ƶſ߳     */
    ZOSS_THREAD_ID             pAudioOutThread;    /* Ƶ߳         */
    ZOSS_SEMAPHORE_ID          pControlSem;        /* ûͬź */
    ZOSS_SEMAPHORE_ID          pOutputSem;         /* ͬź */
}T_Audio_ControlParam;

/* ToneϢ */
typedef struct _T_Tone_ControlParam
{       
    SINT32             iToneExp;           /* Toneģ쳣־     */
    UINT32             uiFdTone;           /* Tone豸            */
}T_Tone_ControlParam;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static VOID Audio_DrvNotifyCB(T_ZDrvAudio_Info tStatus);
static SINT32 Audio_ControlProcInitParam(VOID);
static SINT32 Audio_GetNewBuffer(VOID);
static SINT32 Audio_ControlProcDataProc(VOID);
static VOID Audio_ControlProcStartMsg(VOID);
static SINT32 Audio_ControlProcCycleStart(VOID);
static VOID Audio_ControlProcStopMsg(VOID);
static VOID Audio_ControlProcPauseMsg(VOID);
static VOID Audio_ControlProcResumeMsg(VOID);
static VOID Audio_ControlProcSeekMsg(VOID);
static VOID Audio_ControlProcAudioDecodeMsg(VOID);
static VOID Audio_ControlProcCloseMsg(VOID);
static VOID Audio_ControlThreadLoop(VOID);
static VOID Audio_OutputProcOutMsg(VOID);
static VOID Audio_OutputProcPauseMsg(VOID);
static VOID Audio_OutputProcStopMsg(VOID);
static VOID Audio_OutputProcResumeMsg(VOID);
static VOID Audio_OutputProcCloseMsg(VOID);
static VOID Audio_outputThreadLoop(VOID);
static VOID Audio_OutputThreadEntry(SINT32 arg);
SINT32 Audio_SetAudioFd(SINT32 fd);
static VOID MidiPlayEndCallBack(T_ZDrvMidi_Info midiStatus);
static VOID Audio_ControlProcHardCodec(VOID);
static VOID Audio_ControlProcSoftCodec(VOID);
static VOID Audio_ControlThreadEntry(SINT32 arg);
SINT32 Audio_GetCurTime_HardCodec(SINT32* curtime);
SINT32 Audio_GetTotalTime_HardCodec(SINT32* curtime);
 
/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static AUDIO_PLAY_STATE         g_Curstate = AUDIO_PLAY_STATE_IDLE;  /* Audioģ״̬     */
static AUDIO_PLAY_PARAM_T       g_AudioPlayParam;                    /* ƵŲ      */
static T_FileInfoParam          g_AudioFileParam;                    /* ƵļýϢ  */
static T_Audio_ControlParam     g_AudioControlParam;                 /* AudioҵϢ */
static T_Tone_ControlParam      g_ToneControlParam;                  /* ToneŲ */
static AUDIO_RESULT_E           g_ErrorCode = AUDIO_NO_ERROR;        /* Audioģ״̬ */
/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
* ƣ Msp_SetErrorCallback 
*  öý쳣ϱ
* ˵ (IN) ErrorCallbackFunc: ϱָ
*   ֵ ɹ0ʧܷ-1
* ˵ 
*/
SINT32 Msp_SetErrorCallback(MSP_NOTIFY_ERROR ErrorCallbackFunc)
{
    if(ErrorCallbackFunc == NULL)
    {
        return -1;
    }
    
    if(zMsp_Notify_Error == NULL)
    {
        zMsp_Notify_Error = ErrorCallbackFunc;
    }
    
    return 0;
}

/**
* ƣ Msp_SetEndCallback 
*  öýϱ
* ˵ (IN) EndCallbackFunc: ϱָ
*   ֵ ɹ0ʧܷ-1
* ˵ 
*/
SINT32 Msp_SetEndCallback(MSP_NOTIFY_END EndCallbackFunc)
{
    if(EndCallbackFunc == NULL)
    {
        return -1;
    }
    
    if(zMsp_Notify_End == NULL)
    {
        zMsp_Notify_End = EndCallbackFunc;
    }
    
    return 0;
}


/**
 * ƣ Audio_Init 
 *  Ƶųʼ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
 AUDIO_RESULT_E Audio_Init(void)
 {
    if(g_Curstate != AUDIO_PLAY_STATE_IDLE)
    {
        return AUDIO_ERROR;
    }  

    g_Curstate  = AUDIO_PLAY_STATE_OPEN;
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Release 
 *  Ƶͷ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Release(void)
{
    AUDIO_RESULT_E eRet = AUDIO_NO_ERROR;
    
    /* ״̬openreadyplaypauseʱ */
    if(AUDIO_PLAY_STATE_IDLE == g_Curstate)       
    {
        return AUDIO_ERROR;
    }

    if(g_Curstate >= AUDIO_PLAY_STATE_READY)
    {
        eRet = Audio_Close_EX((FILE_HANDLE)&g_AudioPlayParam);
    }

    /* Ǩ״̬IDLE̬ܹرǷɹ״̬ǿǨ */
    g_Curstate  = AUDIO_PLAY_STATE_IDLE;  
    g_ErrorCode = AUDIO_NO_ERROR; 

    if (eRet != AUDIO_NO_ERROR)
    {
        return AUDIO_ERROR;
    }

    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Open_File 
 *  Ƶģ(ļ)
 * ˵ (IN)filename Ƶļȫ·
 *   ֵ ɹƵļʧܷЧ
 * ˵ 
 */
FILE_HANDLE Audio_Open_File(UINT8 *filename)
{
    AUDIO_RESULT_E eRet = AUDIO_ERROR;

    zOss_Printf(SUBMDL_TEST,PRINT_LEVEL_NORMAL, "ƵŽ򿪺");
    
    /* жϵǰ״̬ǷΪready */
    if(g_Curstate != AUDIO_PLAY_STATE_OPEN)
    {
        zMspCom_Print();
        return NULL;
    } 
    /* жϵǰļǷΪգжļֳǷ񳬹ܳ */
    if (NULL == filename
    || strlen((const char*)filename) > AUDIO_MAX_PATH_LEN)
    {
        zMspCom_Print();
        return NULL;
    }
    
    
    /* ȫֱʼ */
    zOss_Memset(&g_AudioPlayParam,      0, sizeof(AUDIO_PLAY_PARAM_T));
    zOss_Memset(&g_AudioFileParam,      0, sizeof(T_FileInfoParam));
    zOss_Memset(&g_AudioControlParam,   0, sizeof(T_Audio_ControlParam));
    g_ErrorCode = AUDIO_NO_ERROR;    

    /* ǷΪBufferƵ */
    g_AudioControlParam.bBufPlay = FALSE;
        
    /* Ƶļȫ·浽ƵŲ */
    zOss_Memcpy(g_AudioPlayParam.filepath, filename, strlen((const char*)filename));

    /* ͬõź */
    g_AudioControlParam.pControlSem = zOss_CreateSemaphore(AUDIO_CONTROL_SEM, 0);
    if(ZOSS_NULL == g_AudioControlParam.pControlSem)
    {
        zMspCom_Print();
        return NULL;        
    }
    g_AudioControlParam.pOutputSem = zOss_CreateSemaphore(AUDIO_OUTPUT_SEM, 0);
    if(ZOSS_NULL == g_AudioControlParam.pOutputSem)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        return NULL;        
    }
    
    #ifdef USE_MEIDA_MEM_POOL
    g_FileCtrlSemID = zOss_CreateSemaphore(AUDIO_FILECTRL_SEM, 0);
    if(ZOSS_NULL == g_FileCtrlSemID)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        return NULL;        
    }

    g_FileReadSemID = zOss_CreateSemaphore(AUDIO_FILEREAD_SEM, 0);
    if(ZOSS_NULL == g_FileCtrlSemID)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        return NULL;        
    }

    g_DataListLock = zOss_CreateMutex(AUDIO_DATALIST_LOCK, ZOSS_NO_INHERIT);
    if(ZOSS_NULL == g_DataListLock)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_FileReadSemID);
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        return NULL;        
    }
    #endif
    
    /* Ƶ߳ */
    g_AudioControlParam.pControlThread = zOss_CreateThread(AUDIO_CON_THREAD,
                                                           Audio_ControlThreadEntry,
                                                           0,
                                                           AUDIO_CON_STACK,
                                                           AUDIO_CON_PRI,
                                                           1,
                                                           1);
    if(ZOSS_INVALID_THREAD_ID == g_AudioControlParam.pControlThread)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        
        #ifdef USE_MEIDA_MEM_POOL
        zOss_DeleteMutex(g_DataListLock);
        zOss_DeleteSemaphore(g_FileReadSemID);
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        #endif
        
        return NULL;        
    }

    /* ȴ̵߳ĳʼȲ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ̵߳ĲǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);

        #ifdef USE_MEIDA_MEM_POOL
        zOss_DeleteMutex(g_DataListLock);
        zOss_DeleteSemaphore(g_FileReadSemID);
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        #endif

        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
                
        return NULL;        
    }

#ifdef TEST_CREATE_INDEX
    /* ĿǰֻMP3ȡ̨ķʽ */
    if(/*ZM_FileID_MP3 == g_AudioFileParam.pFileInfo->eFileType
        || */ZM_FileID_AAC == g_AudioFileParam.pFileInfo->eFileType)
    {
        eRet = InitIndexCreatingThread();
        if(AUDIO_NO_ERROR != eRet)
        {
            zOss_ASSERT(0);
        }
    }
#endif

    g_Curstate = AUDIO_PLAY_STATE_READY;

    zOss_Printf(1, 1, "ƵŴļɹ");

    
    return (FILE_HANDLE)&g_AudioPlayParam;
}

/**
 * ƣ Audio_Open_Buffer 
 *  Ƶģ(Buffer)
 * ˵ (IN)buffer_ptr ƵݴŻָ
                  buffer_size: ݴС
                  data_type:   Ƶݸʽ
 *   ֵ ɹƵļʧܷЧ
 * ˵ 
 */
FILE_HANDLE Audio_Open_Buffer(UINT8* buffer_ptr,UINT32 buffer_size, DD_AUDIO_FILE_TYPE_E data_type)
{
    FILE       *pFile     = NULL;
    SSIZE_T     uiCount   = 0;
    const CHAR *pfilename = NULL;
    
    if(g_Curstate != AUDIO_PLAY_STATE_OPEN)
    {
        return NULL;
    }

    if(NULL == buffer_ptr)
    {
        return NULL;
    }

    /* Ŀǰ֧amrmp3aacmidiʽƵ */
    switch(data_type)
    {
        case DD_AUDIO_FILE_TYPE_AMR:
        {
            pfilename = (const CHAR *)AUDIO_BUF_AMR_FILE;            
            break;
        }
        case DD_AUDIO_FILE_TYPE_MP3:
        {
            pfilename = (const CHAR *)AUDIO_BUF_MP3_FILE;            
            break;
        }
        case DD_AUDIO_FILE_TYPE_AAC:
        {
            pfilename = (const CHAR *)AUDIO_BUF_AAC_FILE;            
            break;
        }
        case DD_AUDIO_FILE_TYPE_MIDI:
        {
            pfilename = (const CHAR *)AUDIO_BUF_MIDI_FILE;            
            break;
        }
        default:
        {
            break;
        }
    }

    if(NULL == pfilename)
    {
        return NULL;    
    }
 
    /* ȫֱʼ */
    zOss_Memset(&g_AudioPlayParam,      0, sizeof(AUDIO_PLAY_PARAM_T));
    zOss_Memset(&g_AudioFileParam,      0, sizeof(T_FileInfoParam));
    zOss_Memset(&g_AudioControlParam,   0, sizeof(T_Audio_ControlParam));
    g_ErrorCode = AUDIO_NO_ERROR;    

    /* ƵݱΪʱļ"wb"ʽ򿪣
     * ļԭȫҪÿɾļ
     */
    pFile = zOss_FOpen(pfilename, "wb");
    if(NULL == pFile)
    {
        return NULL;
    }
        
    uiCount = zOss_FWrite((const VOID *)buffer_ptr, buffer_size, 1, pFile);
    if(uiCount != 1)
    {
        zOss_FClose(pFile);
        zOss_FDelete(pfilename);
        
        return NULL;
    }

    /* رʱļ */
    zOss_FFlush(pFile);
    zOss_FClose(pFile);

    /* ǷBufferƵ */
    g_AudioControlParam.bBufPlay = TRUE;

    /* ƵϢ */
    strcpy((char *)g_AudioPlayParam.filepath, (const char *)pfilename);
    
    /* ͬõź */
    g_AudioControlParam.pControlSem = zOss_CreateSemaphore(AUDIO_CONTROL_SEM, 0);
    if(ZOSS_NULL == g_AudioControlParam.pControlSem)
    {   
        zOss_FDelete(pfilename);
        
        return NULL;        
    }
    g_AudioControlParam.pOutputSem = zOss_CreateSemaphore(AUDIO_OUTPUT_SEM, 0);
    if(ZOSS_NULL == g_AudioControlParam.pOutputSem)
    {
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_FDelete(pfilename);
        
        return NULL;        
    }
    
    /* P98C-CXX-0001 2012-7-18EC:617001630060Ƶbuffer BEGIN */
    #ifdef USE_MEIDA_MEM_POOL
    g_FileCtrlSemID = zOss_CreateSemaphore(AUDIO_FILECTRL_SEM, 0);
    if(ZOSS_NULL == g_FileCtrlSemID)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        return NULL;        
    }

    g_FileReadSemID = zOss_CreateSemaphore(AUDIO_FILEREAD_SEM, 0);
    if(ZOSS_NULL == g_FileCtrlSemID)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        return NULL;        
    }

    g_DataListLock = zOss_CreateMutex(AUDIO_DATALIST_LOCK, ZOSS_NO_INHERIT);
    if(ZOSS_NULL == g_DataListLock)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_FileReadSemID);
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        return NULL;        
    }
    #endif
    /* P98C-CXX-0001 2012-7-18EC:617001630060Ƶbuffer END */
	
    /* Ƶ߳ */
    g_AudioControlParam.pControlThread = zOss_CreateThread(AUDIO_CON_THREAD,
                                                           Audio_ControlThreadEntry,
                                                           0,
                                                           AUDIO_CON_STACK,
                                                           AUDIO_CON_PRI,
                                                           1,
                                                           1);
    if(ZOSS_INVALID_THREAD_ID == g_AudioControlParam.pControlThread)
    {
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        zOss_FDelete(pfilename);
	/* P98C-CXX-0001 2012-7-18EC:617001630060Ƶbuffer BEGIN */ 
	#ifdef USE_MEIDA_MEM_POOL
        zOss_DeleteMutex(g_DataListLock);
        zOss_DeleteSemaphore(g_FileReadSemID);
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        #endif
        /* P98C-CXX-0001 2012-7-18EC:617001630060Ƶbuffer END */ 
        
        return NULL;        
    }

    /* ȴ̵߳ĳʼȲ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);

    /* ̵߳ĲǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        zOss_FDelete(pfilename);

	/* P98C-CXX-0001 2012-7-18EC:617001630060Ƶbuffer BEGIN */ 
	#ifdef USE_MEIDA_MEM_POOL
        zOss_DeleteMutex(g_DataListLock);
        zOss_DeleteSemaphore(g_FileReadSemID);
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        #endif
        /* P98C-CXX-0001 2012-7-18EC:617001630060Ƶbuffer END*/  
      
        /* λ־ */
        g_ErrorCode  = AUDIO_NO_ERROR;
        
        return NULL;        
    }
    
    g_Curstate = AUDIO_PLAY_STATE_READY;    
    return (FILE_HANDLE)&g_AudioPlayParam;    
}

/**
 * ƣ Audio_Close_EX 
 *  رƵģ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E  Audio_Close_EX(FILE_HANDLE handle)
{
    SINT32 iRet = -1;

    zOss_Printf(1, 1, "ƵŽرպ");

    /* ״̬readyplaypauseʱ */
    if(g_Curstate < AUDIO_PLAY_STATE_READY)       
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

#ifdef TEST_CREATE_INDEX
    /* Ϊʱ g_AudioFileParam ѾգûжļǷΪ
       MP3,ֱͷԴͷŹл
     */
    ReleaseIndexCreatingThread();

#endif
    
    /* ̷߳closeϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_CLOSE_PLAY_SYN);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    /* ȴ̴߳ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    
    if(g_AudioControlParam.pControlSem != NULL)
    {
        zOss_DeleteSemaphore(g_AudioControlParam.pControlSem);
        g_AudioControlParam.pControlSem = NULL;
    }
    if(g_AudioControlParam.pOutputSem != NULL)
    {
        zOss_DeleteSemaphore(g_AudioControlParam.pOutputSem);
        g_AudioControlParam.pOutputSem = NULL;
    }

    #ifdef USE_MEIDA_MEM_POOL
    if(g_FileCtrlSemID != NULL)
    {
        zOss_DeleteSemaphore(g_FileCtrlSemID);
        g_FileCtrlSemID = NULL;
    }

    if(g_FileReadSemID != NULL)
    {
        zOss_DeleteSemaphore(g_FileReadSemID);
        g_FileReadSemID = NULL;
    }
    
    if(g_DataListLock != NULL)
    {
        zOss_DeleteMutex(g_DataListLock);
    }
    #endif

    if(g_AudioControlParam.bBufPlay)
    {
        zOss_FDelete((const CHAR *)g_AudioPlayParam.filepath);
    }
    
    /* P98C-CXX-0001 2012-7-18EC:617001630060ƵŹر  BEGIN */ 
    /* ƵĹرգϢǷ
     * ״̬ǨƣAudio_Release޷
    */
    g_Curstate = AUDIO_PLAY_STATE_OPEN;
    /* P98C-CXX-0001 2012-7-18EC:617001630060ƵŹر  END */ 
	
    /* ϢǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
        
        return AUDIO_ERROR;
    }

    zOss_Printf(1, 1, "ƵŹرճɹ");

    return AUDIO_NO_ERROR;
}

/**
 * ƣ PLAYER_AUDIO_StartPlay 
 *  ʼƵ
 * ˵ (IN)handle    Ƶž
                  offset:     ʼλ, λΪ
                  play_times: Ŵ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E PLAYER_AUDIO_StartPlay(FILE_HANDLE handle, UINT32 offset, UINT16 play_times)
{
    SINT32 iRet = -1;
    
    if (g_Curstate != AUDIO_PLAY_STATE_READY)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    zOss_Printf(1, 1, "Ƶļʼ");

    /* 鶨λλܳǷС0Ƿ񳬹ܳ */
    if (offset < 0
    || offset > g_AudioFileParam.uiFileTotalTime)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    /* ƵŲ */
    g_AudioPlayParam.iStartOffset = offset / 1000;
    g_AudioPlayParam.playtimes = play_times;

    /* Ƶ̷߳ͿʼƵϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_START_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ϢǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
        
        return AUDIO_ERROR;
    }

    g_Curstate = AUDIO_PLAY_STATE_PLAY; 
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_StopPlay 
 *  ֹͣƵ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_StopPlay(FILE_HANDLE handle)
{
    SINT32 iRet = -1;

    zOss_Printf(1, 1, "ƵŽֹͣ"); 

    if (g_Curstate != AUDIO_PLAY_STATE_PLAY
       && g_Curstate != AUDIO_PLAY_STATE_PAUSE)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    
    /* Ƶ̷ֹ߳ͣƵϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_STOP_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ϢǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
        
        return AUDIO_ERROR;
    }

    g_Curstate = AUDIO_PLAY_STATE_READY; 

    zOss_Printf(1, 1, "Ƶֹͣɹ"); 
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_PausePlay 
 *  ͣƵ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_PausePlay(FILE_HANDLE handle)
{
    SINT32 iRet = -1;

    zOss_Printf(1, 1, "ƵŽͣ");

    if (g_Curstate != AUDIO_PLAY_STATE_PLAY)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    /* Ƶ̷߳ͣƵϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_PAUSE_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ϢǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
        
        return AUDIO_ERROR;
    }

    g_Curstate = AUDIO_PLAY_STATE_PAUSE; 

    zOss_Printf(1, 1, "Ƶͣɹ");
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_ResumePlay 
 *  ָƵ
 * ˵ (IN)handle Ƶž
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_ResumePlay(FILE_HANDLE handle)
{
    SINT32 iRet = -1;

    zOss_Printf(1, 1, "ƵŽָ");

    if (g_Curstate != AUDIO_PLAY_STATE_PAUSE)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    /* Ƶ̷߳ͻָƵϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_RESUME_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ϢǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
        
        return AUDIO_ERROR;
    }

    g_Curstate = AUDIO_PLAY_STATE_PLAY; 

    zOss_Printf(1, 1, "ƵŻָɹ");
   
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_GetCurTime 
 *  ȡƵǰʱ
 * ˵ (IN)handle  Ƶž
              (OUT)curtime: 浱ǰʱ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetCurTime(FILE_HANDLE handle ,SINT32* curtime)
{ 
    SINT32 iRet = -1;
    
    if (AUDIO_PLAY_STATE_IDLE == g_Curstate)
    {
        return AUDIO_ERROR;
    }

    if (NULL == curtime)
    {
        return AUDIO_ERROR;
    }

    if (ZM_FileID_MIDI_10 == g_AudioFileParam.pFileInfo->eFileType
        || ZM_FileID_IMY == g_AudioFileParam.pFileInfo->eFileType)
    {
        iRet = Audio_GetCurTime_HardCodec(curtime);
        if (iRet != AUDIO_OP_SUCCESS)
        {
            return AUDIO_ERROR;
        }
    }
    else
    {
       *curtime = g_AudioControlParam.tAudioBuffer.uiStartTime;
    }
        
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_GetTotalTime 
 *  ȡƵʱ
 * ˵ (IN)handle     Ƶž
              (OUT)total_time: 沥ʱ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetTotalTime(FILE_HANDLE handle, SINT32* total_time)
{
    if (AUDIO_PLAY_STATE_IDLE == g_Curstate)
    {
        return AUDIO_ERROR;
    }

    if (NULL == total_time)
    {
        return AUDIO_ERROR;
    }

    /* ýļʱ */
    *total_time = g_AudioFileParam.uiFileTotalTime;
        
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Seek 
 *  Ƶļضλ(ӵǰλôλ)
 * ˵ (IN)handle Ƶž
                  offset:  ¶λλ,λΪ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ ӵǰλôλ
 */
AUDIO_RESULT_E Audio_Seek(FILE_HANDLE handle, SINT32 offset)
{
    SINT32         iRet    = -1;
    SINT32         curtime = 0;
    AUDIO_RESULT_E tResult = AUDIO_ERROR;
    
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "ƵŽSEEK");


    if (g_Curstate != AUDIO_PLAY_STATE_READY
        && g_Curstate != AUDIO_PLAY_STATE_PLAY
        && g_Curstate != AUDIO_PLAY_STATE_PAUSE)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    /* ȡƵǰʱ䣬λΪ */
    tResult = Audio_GetCurTime(handle, &curtime);
    if (tResult != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }   
    
    /* 鵱ǰŲʱ϶λλܳǷС0Ƿ񳬹ܳ */
    if ((curtime + offset) < 0
    || (UINT32)(curtime + offset) > g_AudioFileParam.uiFileTotalTime)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }

#ifdef TEST_CREATE_INDEX
    /* ߳Ѿ²żִضλ */
    if(
        (!g_bIsFinishedIndex || g_bIsQuitIndexCreating)
        && (/*ZM_FileID_MP3 == g_AudioFileParam.pFileInfo->eFileType
            || */ZM_FileID_AAC == g_AudioFileParam.pFileInfo->eFileType)
      )
    {
        return AUDIO_NO_ERROR;
    }

#endif

    /* ضλļԤһ룬ΪݴԿ */
    if (((UINT32)(curtime + offset) / 1000 == g_AudioFileParam.uiFileTotalTime / 1000)
        && (curtime + offset > 1000) )
    {
        /* AmrMp3ʽoffsetλΪ */
        offset = offset - 1000 ;
    }

    /* ضλλü¼ƵϢ,ضλλӦü¼ɴļͷʼλ */
    /* SeekӿڵλòΪs */
    g_AudioPlayParam.iSeekOffset = (curtime + offset) / 1000;
    
    /* Ƶ̷߳ضλƵϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_SEEK_PLAY_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }

    /* ͬȴ̲߳ */
    zOss_GetSemaphore(g_AudioControlParam.pControlSem, ZOSS_WAIT_FOREVER);
    /* ϢǷ */
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        zMspCom_Print();
        /* λ־ */
        g_ErrorCode = AUDIO_NO_ERROR;
        
        return AUDIO_ERROR;
    }

    zOss_Printf(1, 1, "ƵSEEKɹ");
   
    return AUDIO_NO_ERROR; 
}

/**
 * ƣ Audio_GetFileInfo 
 *  ȡƵļϢ
 * ˵ (IN)handle Ƶž
              (OUT)info:   ļϢ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetFileInfo(FILE_HANDLE handle, AUDIO_FILEINFO_T *info)
{
    if (AUDIO_PLAY_STATE_IDLE == g_Curstate)
    {
        return AUDIO_ERROR;
    }

    if (NULL == info)
    {
        return AUDIO_ERROR;
    }
        
    info->audio_total_time = g_AudioFileParam.uiFileTotalTime;
    info->uiSampleRate = g_AudioFileParam.eSample;

    return AUDIO_NO_ERROR;    
}

/**
 * ƣ Audio_GetAuthorInfo 
 *  ȡƵļϢ
 * ˵ (IN)handle Ƶž
              (OUT)info:   Ϣ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_GetAuthorInfo(FILE_HANDLE handle, MP3_ID3_TAG_T *info)
{
    if (AUDIO_PLAY_STATE_IDLE == g_Curstate)
    {
        return AUDIO_ERROR;
    }

    if (NULL == info)
    {
        return AUDIO_ERROR;
    }
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Mute 
 *  ƵǷ
 * ˵ (IN)handle     Ƶž
                  enable_mute: Ƿ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E  Audio_Mute(FILE_HANDLE handle, BOOL  enable_mute)
{
    SINT32 iRet;    

    iRet = zMspCom_SetMute(enable_mute);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Volume_Get 
 *  ȡƵ
 * ˵ (IN)handle       Ƶž
              (OUT)volumn_level: ŵǰƵ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E  Audio_Volume_Get(FILE_HANDLE handle, VOLUME_DD_level  *Volume_level)
{
    SINT32                    iRet;
    T_MSP_OUTPUT_VOLUME_LEVEL volumeLevel;

    if (NULL == Volume_level)
    {
        return AUDIO_ERROR;
    }

    iRet = zMspCom_GetOutputVol(&volumeLevel);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
    return AUDIO_ERROR;
    }

    *Volume_level = (VOLUME_DD_level)volumeLevel;

    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Volume_Set 
 *  Ƶ
 * ˵ (IN)handle      Ƶž
 *                volumn_level: Ƶ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Volume_Set(FILE_HANDLE handle, VOLUME_DD_level volume_level)
{
    SINT32                    iRet;
    T_MSP_OUTPUT_VOLUME_LEVEL volumeLevel = MSP_OUTPUT_VOLUME_LEVEL_3;

    volumeLevel = (T_MSP_OUTPUT_VOLUME_LEVEL)volume_level;
    iRet = zMspCom_SetOutputVol(volumeLevel);
    #if 1 /*U560 jianghaiyang_sw ʱ0Ϊ*/
    if(dd_volume_lev_0 == volume_level)
    {
        Audio_Mute(NULL,TRUE);
    }
    else
    {
        Audio_Mute(NULL,FALSE);
    }
    #endif
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_ChannelOut_Get 
 *  ȡƵͨ
 * ˵ (IN)handle   Ƶž
              (OUT)pchannel: ŵǰƵͨ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_ChannelOut_Get(FILE_HANDLE handle,UINT8 *pchannel)
{
    SINT32               iRet;
    T_MSP_CHANNEL_OUTPUT outchannel;
    
    if (NULL == pchannel)
    {
        return AUDIO_ERROR;
    }   
      
    iRet = zMspCom_GetOutputChannel(&outchannel);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }
    
    *pchannel = outchannel;
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_ChannelOut_Set 
 *  Ƶͨ
 * ˵ (IN)handle Ƶž
 *                channel: Ƶͨ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_ChannelOut_Set(FILE_HANDLE handle, DD_CODEC_PATHOUT channel)
{
    SINT32               iRet;
    T_MSP_CHANNEL_OUTPUT pathOut;

    pathOut = (T_MSP_CHANNEL_OUTPUT)channel;
    iRet = zMspCom_SetOutputChannel(pathOut);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Effect3D_Set 
 *  3DЧ
 * ˵ (IN)handle Ƶž
 *                enable:  Ƿ3DЧ
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Effect3D_Set(FILE_HANDLE handle,UINT8 *enable)
{
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_EQmode_Set 
 *  3DЧ
 * ˵ (IN)handle      Ƶž
 *                audioEqMode:  Ч
 *   ֵ ɹAUDIO_NO_ERRORʧܷAUDIO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_EQmode_Set(FILE_HANDLE handle,AUDIO_EQMODE_E audioEqMode)
{
    return AUDIO_NO_ERROR;    
}

/**
 * ƣ Audio_Open_Tone 
 *  Tone豸
 * ˵ (IN)
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Open_Tone(VOID)
{
    SINT32 iFdTone = -1;

    zOss_Printf(1, 1, "Tone豸򿪺");
#if 1
    /* Audio豸ʱTone2010-2-4cyxΪ̶̨޸ */
    if(zMspCom_GetAudioFd() > 0)
    {
        return AUDIO_NO_ERROR;
    }
#endif    
#if 1       
    iFdTone = zMspCom_ToneOpen();
    if (iFdTone <= 0)
    {   
        zMspCom_Print();
        return AUDIO_ERROR;
    }
#endif

    return AUDIO_NO_ERROR;
}

/**
 * ƣ Tone_DrvNotifyCB 
 *  עĵײ㲥֪ͨص
 * ˵ (IN) iStatus  ״̬
 *   ֵ 
 * ˵ 
 */
void Tone_DrvNotifyCB(T_ZDrvTone_Info tStatus)
{
    switch(tStatus)
    {
        /* ײ㲥쳣 */
        case TONE_INFO_PLAY_ERR:
        {
            g_ToneControlParam.iToneExp |= TONE_DEV_EXP;
            /* zMmfSink_Tone_CallBack(tStatus); */
            break;
        }

        /* ײ㲥Ž */
        case TONE_INFO_PLAY_END:
        {                       
            UINT32        uiFdTone  = 0;
            SINT32        iRet = -1;
        
            uiFdTone = zMspCom_GetToneFd();
            if(uiFdTone > 0)
            {
                iRet = zDrv_Ioctl(uiFdTone, IOCTL_TONE_STOP, NULL);
                zMspCom_ToneClose();
            }
            g_ToneControlParam.iToneExp |= TONE_OVER_EXP;                   
            break;
        }

        default:
        {
            break;
        }
    }
        
    return;
}

static UINT32 toneFreq[128] =
{
0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 
,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 
,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 
,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 
,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 
,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 ,0x000000C3 
,0x000000C3 ,0x000000CA ,0x000000D6 ,0x000000E3 ,0x000000F0 ,0x000000FE ,0x0000010D ,0x0000011D ,0x0000012E 
,0x00000140 ,0x00000153 ,0x00000167 ,0x0000017C ,0x00000193 ,0x000001AA ,0x000001C4 ,0x000001DE ,0x000001FB 
,0x00000218 ,0x00000238 ,0x0000025A ,0x0000027D ,0x000002A3 ,0x000002CB ,0x000002F5 ,0x00000322 ,0x00000351 
,0x00000383 ,0x000003B8 ,0x000003F0 ,0x0000042C ,0x0000046B ,0x000004AE ,0x000004F4 ,0x0000053F ,0x0000058E 
,0x000005E2 ,0x0000063B ,0x00000699 ,0x000006FD ,0x00000767 ,0x000007D7 ,0x0000084D ,0x000008CA ,0x0000094F 
,0x000009DC ,0x00000A71 ,0x00000B0E ,0x00000BB5 ,0x00000C66 ,0x00000D22 ,0x00000DE8 ,0x00000EBA ,0x00000F99 
,0x00001084 ,0x0000117E ,0x00001286 ,0x0000139E ,0x000014C6 ,0x00001600 ,0x0000174C ,0x000018AC ,0x00001A21 
,0x00001BAB ,0x00001D4D ,0x00001F08 ,0x000020DD ,0x000022CD ,0x000024DB ,0x00002707 ,0x00002955 ,0x00002BC5 
,0x00002E5A ,0x00003116 
};
 
/**
 * ƣ Audio_Play_Tone 
 *  Tone
 * ˵ (IN)AUDIO_TONE_PARAM ToneŲ
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Play_Tone(AUDIO_TONE_PARAM *ptoneParam)
{
    SINT32                    iRet = -1;
    UINT32                    iFreq;
    T_ZDrvTone_PlayConfig     tonePlayConfig;
    T_ZDrv_CodecOutputPath    toneOutputPath;
    T_ZDrvTone_OutputVolLevel toneVollevel;
    UINT32                    uiFdTone  = 0;

    uiFdTone = zMspCom_GetToneFd();

    zOss_Printf(1, 1, "Tone豸ź");
    
#if 1
    /* Audio豸ʱTone2010-2-4cyxΪ̶̨޸ */
    if(zMspCom_GetAudioFd() > 0)
    {
        return AUDIO_NO_ERROR;
    }

    if (uiFdTone == 0)
    {
        zMspCom_Print();
        return AUDIO_ERROR;
    }
    
    /* ̶̨StopӿڣֹͣTone豸жϷֵ */
    iRet = zDrv_Ioctl(uiFdTone, IOCTL_TONE_STOP, NULL);
    
    /* ͨ */
    if (DD_RECEIVER == ptoneParam->channel)
    {
        toneOutputPath = CODEC_OUTPUT_RECEIVER;
    }
    else if (DD_SPEAKER == ptoneParam->channel)
    {
        toneOutputPath = CODEC_OUTPUT_SPEAKER;
    }
    else if (DD_HEADPHONE == ptoneParam->channel)
    {
        toneOutputPath = CODEC_OUTPUT_HEADSET;
    }
    else if (DD_SPEAKER_AND_HEADPHONE == ptoneParam->channel)
    {
        toneOutputPath = CODEC_OUTPUT_HSANDSPK;
    }
    else if (DD_BLUETOOTH_PHONE == ptoneParam->channel)
    {
        toneOutputPath = CODEC_OUTPUT_BLUETOOTH;
    }
    else
    {
        toneOutputPath = CODEC_OUTPUT_SPEAKER;
    }

    iRet = zDrv_Ioctl(uiFdTone, IOCTL_TONE_SET_PATH, &toneOutputPath);
    if (iRet < 0)
    {   
        zMspCom_Print();
        return AUDIO_ERROR;
    }

    /*  */
    toneVollevel = (T_ZDrvTone_OutputVolLevel)ptoneParam->volume;
    if (toneVollevel > TONE_OUTPUT_VOL_LEVEL_5)
    {
        toneVollevel = TONE_OUTPUT_VOL_LEVEL_5;
    }
    iRet = zDrv_Ioctl(uiFdTone, IOCTL_TONE_SET_VOL, &toneVollevel);
    if (iRet < 0)
    {    
        zMspCom_Print();
        return AUDIO_ERROR;
    }   

    /* ƵʣҪƵ0-4000֮(0) */
    iFreq = toneFreq[ptoneParam->iFreq % 128];
    if (iFreq > 3650)
    {
        iFreq = 3650;
    }
    if (iFreq < 500)
    {
        iFreq = 500;
    }

    tonePlayConfig.tone_data.freq1 = iFreq;
    tonePlayConfig.type = TONE_SINGLE_FREQ;
    tonePlayConfig.tone_data.amp1 = 0x4000;
    tonePlayConfig.tone_data.duration = ptoneParam->duration;
    tonePlayConfig.callback = Tone_DrvNotifyCB;

    iRet = zDrv_Ioctl(uiFdTone, IOCTL_TONE_PLAY, &tonePlayConfig);
    if (iRet < 0)
    {
        zMspCom_Print();
        g_ErrorCode = AUDIO_ERROR;
        return AUDIO_ERROR;
    }
#endif
    
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Stop_Tone 
 *  ֹͣTone
 * ˵ (IN)
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Stop_Tone(VOID)
{
    SINT32 iRet = -1;
    UINT32 uiFdTone  = 0;

    zOss_Printf(1, 1, "Tone豸ֹͣ");
    
    uiFdTone = zMspCom_GetToneFd();

#if 1
    if (0 == uiFdTone)
    {
        /* ڲToneʱAudio󣬻Tone
         * ֹͣص˴˴Ȼسɹ 
         20100204 cyx Ϊ̶̨Ķ
         */
        return AUDIO_NO_ERROR;
    }
    
    /* 豸ֹͣ */
    iRet = zDrv_Ioctl(uiFdTone, IOCTL_TONE_STOP, NULL);
    if (iRet < 0)
    {  
        zMspCom_Print();
        return AUDIO_ERROR;
    }
#endif
        
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_Close_Tone 
 *  رTone
 * ˵ (IN)
 *   ֵ ɹAUDIO_NO_ERROR
 * ˵ 
 */
AUDIO_RESULT_E Audio_Close_Tone(VOID)
{
    UINT32 uiFdTone  = 0;

    uiFdTone = zMspCom_GetToneFd();

    zOss_Printf(1, 1, "Tone豸رպ");
    
#if 1
    if (0 == uiFdTone)
    {               
        /* ڲToneʱAudio󣬻Tone
         * ֹͣص˴˴Ȼسɹ 
         20100204 cyx Ϊ̶̨Ķ
         */
        return AUDIO_NO_ERROR;
    }

    /* رTone豸 */
    zMspCom_ToneClose();
#endif

    return AUDIO_NO_ERROR;
}

/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/**
 * ƣ Audio_NotifyUser 
 *  Ƶģ֪ͨû
 * ˵ (IN) iStatus  ״̬
 *   ֵ 
 * ˵ 
 */
void Audio_NotifyUser(SINT32 iStatus)
{    
    SINT32 iRet = -1;
    
    switch(iStatus)
    {
        /* ƵļŽ */
        case AUDIO_OP_DATAEND:
        {
            g_AudioPlayParam.playtimes--;            
            if (g_AudioPlayParam.playtimes > 0)
            {
                g_AudioControlParam.tAudioBuffer.uiStartTime = g_AudioPlayParam.iStartOffset;
                /* Ƶϱ־ */
                g_AudioControlParam.iAudioExp &= ~AUDIO_FILE_OVER_EXP; 

                if (AUDIO_PLAY_STATE_PLAY == g_Curstate
                    && AUDIO_NO_EXP == g_AudioControlParam.iAudioExp)
                {
                    /* ѭʼ */
                    iRet = Audio_ControlProcCycleStart();
                    if (iRet != AUDIO_OP_SUCCESS)
                    {
                        g_AudioControlParam.iAudioExp |= AUDIO_OP_EXP;

                        /* ֪ͨϲûƵģ鴦쳣 */
                        Audio_NotifyUser(AUDIO_OP_EXP); 
                        break;
                    }
                } 
                else if(g_AudioControlParam.iAudioExp != AUDIO_NO_EXP)
                {
                    zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_ERR);                   
                    break;
                }
            }
            else
            {
                zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_END);            
            }

            break;
        }

        case AUDIO_OP_ERROR:
        {
            zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_ERR);
            break;
        }
        
        /* 뻺ļȡ쳣ײ豸ŵ쳣 */
        case AUDIO_PCM_EXP:
        {
            zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_ERR);
            break;
        }
        
        default:
        {
            zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_ERR);
            break;
        }
    }
        
    return;
}

/**
 * ƣ Audio_DrvNotifyCB 
 *  עĵײ㲥֪ͨص
 * ˵ (IN) iStatus  ״̬
 *   ֵ 
 * ˵ 
 */
static VOID Audio_DrvNotifyCB(T_ZDrvAudio_Info tStatus)
{
    switch(tStatus)
    {
        /* ײPCM쳣 */
        case AUDIO_INFO_PLAY_ERR:
        {
            g_AudioControlParam.iAudioExp |= AUDIO_PCM_EXP;
            break;
        }

        /* ײPCMŽ */
        case AUDIO_INFO_PLAY_END:
        {
            if (g_AudioControlParam.iAudioExp & AUDIO_FILE_OVER_EXP)
            {
                /* ֪ͨ߳ */
                zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_OUT_OVER);                         
            }
            
            break;
        }

        default:
        {
            break;
        }
    }
    return;
}

/**
 * ƣ Audio_ControlProcInitParam 
 *  ƵʼҪͨ
 *            ʡʼȲ
 * ˵ 
 *   ֵ ɹAUDIO_OP_SUCCESS
 * ˵ 
 */
static SINT32 Audio_ControlProcInitParam(VOID)
{
    UINT8                      iPathOut;
    SINT32                     iRet         = -1;    
    AUDIO_RESULT_E             eRet         = AUDIO_ERROR;
    VOLUME_DD_level            volumeLevel;     
    T_MSP_CHANNEL_OUTPUT       outputpath;
    T_ZDrvAudio_PlayParam      playParam;
    T_ZDrvAudio_SampleRate     sampleRate   = AUDIO_RATE_8_KHZ;
    T_MSP_OUTPUT_VOLUME_LEVEL  outputVol;
    BOOL                       bMute;

    eRet = Audio_Volume_Get((FILE_HANDLE)&g_AudioPlayParam, &volumeLevel);
    if(eRet != AUDIO_NO_ERROR)
    {
    return AUDIO_OP_ERROR;
    }
    outputVol = (T_MSP_OUTPUT_VOLUME_LEVEL)volumeLevel;

    eRet = Audio_ChannelOut_Get((FILE_HANDLE)&g_AudioPlayParam, &iPathOut);
    if(eRet != AUDIO_NO_ERROR)
    {
        return AUDIO_OP_ERROR;
    }
    outputpath = (T_MSP_CHANNEL_OUTPUT)iPathOut;

    iRet = zMspCom_GetMute(&bMute);
    if(iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }

    /* AMRʽʹ̶Ϊ8K, MP3ڴMP3ʱ */
    sampleRate = g_AudioFileParam.eSample; 

    /* ֵƵʽйأ3֡AMRPCMݳΪ960ֽڡ */
    playParam.channel = g_AudioFileParam.eChannel;
    playParam.buffersize = g_AudioFileParam.uiAudioBufsize;

    /* ͨ */
    iRet = zMspCom_SetOutputChannel(outputpath);
    if (iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }
    
    /*  */
    iRet = zMspCom_SetOutputVol(outputVol);
    if (iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }
    
    /* þ */
    iRet = zMspCom_SetMute(bMute);
    if (iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }
    
    /* ò */
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_SET_SAMPLE, (VOID *)&sampleRate);
    if (iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }
    
    /* ֪ͨص */
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_SET_CALLBACK, (VOID *)Audio_DrvNotifyCB);
    if (iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }
    
    /* ʼ */
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_START, (VOID *)&playParam);
    if (iRet < 0)
    {
        return AUDIO_OP_ERROR;
    }    

    return AUDIO_OP_SUCCESS;
}

/**
 * ƣ Audio_GetNewBuffer 
 *  ƵȫֱϢ
 * ˵ 
 *   ֵ ɹAUDIO_OP_SUCCESS
 * ˵ ˽ӿ̵߳Ŀʼлʹ(ʼšָ
 *            šضλŶʹõʼ);Ƶ߳
 *            ϢҲʹõ
 */
static SINT32 Audio_GetNewBuffer(VOID)
{
    SINT32 iRet = -1;
    T_ZDrvAudio_BufInfo audioBufInfo;

    /* ͣ״̬´ָϢʱпܻԭĻδʹϵ
     * Ϊͣ״̬£ƵϢᱻʱbuffer
     * ԭĻһֱûбõĻջΪ벻*/
    if(AUDIO_BUF_UNUSED == g_AudioControlParam.tAudioBuffer.eBufState)
    {
        return AUDIO_OP_SUCCESS; 
    }
    
    /* Ƶ */
    audioBufInfo.buf = NULL;
    audioBufInfo.buffersize = 0;
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_GET_BUFFER, (VOID*)&audioBufInfo);
    if ((iRet < 0) || (NULL == audioBufInfo.buf))
    {
        return AUDIO_OP_ERROR;
    }

    /* ҪƵַʹС¼ȫֱȥ */
    g_AudioControlParam.tAudioBuffer.pPhyBuffer = audioBufInfo.buf;
    g_AudioControlParam.tAudioBuffer.uiBufLen = audioBufInfo.buffersize;
    g_AudioControlParam.tAudioBuffer.uiUsedLen = 0;
    g_AudioControlParam.tAudioBuffer.eBufState = AUDIO_BUF_UNUSED;

    return AUDIO_OP_SUCCESS;
}

/**
 * ƣ Audio_ControlProcDataProc 
 *  ̴߳ƵݵĶȡ롢д뻺
 * ˵ 
 *   ֵ ɹAUDIO_OP_SUCCESS
 * ˵ 
 */
static FILE * s_pcm_handle = NULL;
static SINT32 Audio_ControlProcDataProc(VOID)
{
    T_ZMFOutPutUnit     *pOutUnit       = NULL; 
    EZMFResultCode       eResult        = ZMF_RS_ERROR;
    T_Audio_DecodeParam  tAudioDecParam = {0,};
    SINT32               iRet           = -1;
    VOID                *pPhyBuf        = NULL;
    UINT32               uiBufLen       = 0;
    UINT32               uiMaxFrameData;
    UINT32               uiReadCount    = 0;   /* ѽ֡ */
    UINT32               uiUsedLen      = 0;     /* Ƶһ֡С */
    UINT32               uiTotalLen     = 0;    /* ⼸֡ܳ */

    /* ȫֱм¼õַͳȸֵ */
    pPhyBuf = g_AudioControlParam.tAudioBuffer.pPhyBuffer;
    uiBufLen = g_AudioControlParam.tAudioBuffer.uiBufLen;

    /* һ֡ƵΪPCMռ */
    uiMaxFrameData = g_AudioFileParam.uiMaxFramePcmLen;
        
    /* ĻȽ֡ */
    do
    {
        /* һ֡ */
        #ifdef USE_MEIDA_MEM_POOL
        {        
            T_MEDIA_AUDIODATA_NODE  *pData = NULL;
            
            eResult = Audio_GetNextAudioFrame(&pData, FALSE);
            if (eResult == ZMF_RS_OK && pData != NULL)
            {
                pOutUnit = pData->pOutUnit;
                zOss_Free(pData);
            }
        }
        #else
        eResult = GetNextFrame(g_AudioFileParam.u32FileID, /*g_AudioFileParam.u32AudioTrack,*/ &pOutUnit);
        #endif
        /* ݶȡ */
        if (ZMF_RS_DATA_READ_OVER == eResult)
        {
            /* ¼쳣־Ƶݶȡ */
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_OVER_EXP;

            /* ݶȡϵĻҪͷеĻͨûصϱϢ
               ˴һˣûʹãڻݣ
               ͷbuffer֪ͨ */
            /* ֡Ϊ0ûн䵽 */
            if(uiReadCount == 0)
            {
                /* Ϊ320ֽ(AMRʽƵpcmΪ320ֽ) */
                uiBufLen = uiBufLen <= 320 ? uiBufLen : 320;
                /* Ҫŵ0 */
                zOss_Memset(pPhyBuf, 0, uiBufLen);                                      
                g_AudioControlParam.tAudioBuffer.eBufState = AUDIO_BUF_USED;
                zOss_Printf(SUBMDL_TEST,PRINT_LEVEL_NORMAL, "zDrv_Write pPhyBuf: %d, LINE: %d",pPhyBuf,__LINE__);
                iRet = zDrv_Write(g_AudioControlParam.uiFdAudio, (const VOID *)pPhyBuf, uiBufLen);
                if(iRet < 0)
                {
                    return AUDIO_OP_EXP;
                }
                
                return AUDIO_OP_DATAEND;
            }
            else /* н */
            {
                return AUDIO_OP_SUCCESS;
            }        
        }
        /* ݶȡ */
        else if (eResult != ZMF_RS_OK)
        {
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_EXP;
                    
            zMspCom_Print();
                    
            return AUDIO_FILE_EXP;
        }

        /* ļΪPCMʽ룬ֱӿַ */
        if(ZM_CODEC_ID_PCM_S16LE == g_AudioFileParam.eMediaAType)
        {
            #if 0
            if(s_pcm_handle == NULL)
            {
                s_pcm_handle = zOss_FOpen("T:\\pcmdata.pcm", "wb");
            }
            zOss_FWrite(pOutUnit->pPacket, pOutUnit->u32Len, 1, s_pcm_handle);
            zOss_FFlush(s_pcm_handle);
            #endif
            if(pOutUnit->u32Len > uiBufLen)
            {
                g_AudioControlParam.iAudioExp |= AUDIO_FILE_EXP;

                /* ͷƵ뵥ԪԴ */
                ReleaseUnitData(g_AudioFileParam.u32FileID, pOutUnit); 
                return AUDIO_FILE_EXP;
            }
            uiUsedLen = pOutUnit->u32Len;
            zOss_Memcpy(pPhyBuf, pOutUnit->pPacket, pOutUnit->u32Len);
        }
        else
        {
            tAudioDecParam.pHandle     = g_AudioControlParam.pAudioHandle;
            tAudioDecParam.pOutUnit    = pOutUnit;
            tAudioDecParam.uiLen       = uiBufLen;
            tAudioDecParam.pPhyBuf     = pPhyBuf;
            /* һ֡Ƶݽ,Ƶ */
            uiUsedLen = zMspCom_AudioDecode(&tAudioDecParam);
        }

        /* µַʣʹóԼܳ */
        pPhyBuf = (VOID *)((CHAR *)pPhyBuf + uiUsedLen);
        uiBufLen = uiBufLen - uiUsedLen;
        uiTotalLen = uiTotalLen + uiUsedLen;
                    
        /* ƵϢԼһ֡ʼʱ */
        g_AudioControlParam.tAudioBuffer.uiUsedLen = uiTotalLen;
        /* һ֡ */
        if (uiReadCount == 0)
        {                       
            g_AudioControlParam.tAudioBuffer.uiStartTime = pOutUnit->u32DecodeTime;
            g_AudioControlParam.tAudioBuffer.uiEndTime = pOutUnit->u32DecodeTime;
            g_AudioControlParam.tAudioBuffer.eBufState = AUDIO_BUF_USED;
        }
        else
        {
            g_AudioControlParam.tAudioBuffer.uiEndTime = pOutUnit->u32DecodeTime;
        }

        /* ͷƵ뵥ԪԴ */
        ReleaseUnitData(g_AudioFileParam.u32FileID, pOutUnit); 
        /* ½֡ */
        uiReadCount++;
    }while(uiBufLen >= uiMaxFrameData);
    
    return AUDIO_OP_SUCCESS;
}

/**
 * ƣ Audio_ControlProcStartMsg 
 *  ʼϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcStartMsg(VOID)
{
    SINT32 iRet = -1;

    /* ͨʣÿʼ */
    iRet = Audio_ControlProcInitParam();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    /* Ƶ */
    iRet = Audio_GetNewBuffer();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    /* Ƶݽвݣ룬仺 */
    iRet = Audio_ControlProcDataProc();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        /* ݳҪͷŵƵ(Чδʹ)
        ֤뻺ʱ뵽*/
        zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);
        /* stopӿںҪȫƵеϢ */
        zOss_Memset(&(g_AudioControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));

        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* Ƶ̷߳ƵϢ*/
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        /* ƵϢҪͷŵƵ(Чδʹ)
        ֤뻺ʱ뵽*/
        zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);
        /* stopӿںҪȫƵеϢ */
        zOss_Memset(&(g_AudioControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));

        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* Ƶģ״̬ */
    g_Curstate = AUDIO_PLAY_STATE_PLAY;
    return;
}

/**
 * ƣ Audio_ControlProcCycleStartHard 
 *  Ӳѭſʼ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_OP_SUCCESS
 * ˵ 
 */
static SINT32 Audio_ControlProcCycleStartHard(VOID)
{
    SINT32               iRet = -1;
    UINT32               iStartOffset = 0;
    T_ZDrvMidi_PlayParam playParam; 

    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_PLAY_STOP, NULL);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return AUDIO_OP_ERROR;
    }

    /* ļλҪʼλ */
    /* midiضλҪΪ */
    iStartOffset = g_AudioPlayParam.iStartOffset * 1000;
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_SEEK, &iStartOffset);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return AUDIO_OP_ERROR;
    }
    
    playParam.pData_buf = g_AudioPlayParam.pMidiBuf;
    playParam.datasize = g_AudioPlayParam.iMidisize;
    playParam.repeat_times = 1;
    playParam.callback = MidiPlayEndCallBack;
    
    if(ZM_FileID_MIDI_10 == g_AudioFileParam.pFileInfo->eFileType)
    {
        playParam.format = MIDI_aud_format_midi;
    }
    else if(ZM_FileID_IMY == g_AudioFileParam.pFileInfo->eFileType)
    {
        playParam.format = MIDI_aud_format_imelody;
    }
    else
    {
        g_ErrorCode = AUDIO_ERROR;
        return AUDIO_OP_ERROR;
    }
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_PLAY_START, &playParam);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return AUDIO_OP_ERROR;
    }

    /* Ƶģ״̬ */
    g_Curstate = AUDIO_PLAY_STATE_PLAY;
    
    return AUDIO_OP_SUCCESS;
}

/**
 * ƣ Audio_ControlProcCycleStartSoft 
 *  ѭſʼ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_OP_SUCCESS
 * ˵ 
 */
static SINT32 Audio_ControlProcCycleStartSoft(VOID)
{
    SINT32           iRet     = -1;
    EZMFResultCode   eResult  = ZMF_RS_ERROR;    

    /* Ƶ̷߳ƵֹͣϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_OP_ERROR;
    }

    /* ȴƵ̴߳ */
    zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    /* Ƶֹ߳ͣ */
    if (g_ErrorCode != AUDIO_NO_ERROR)
    {
        return AUDIO_OP_ERROR;
    }

    /* ļλҪʼλãseekλΪ */
    #ifdef USE_MEIDA_MEM_POOL
    eResult = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK_START);
    #else
    eResult = Seek(g_AudioFileParam.u32FileID, g_AudioPlayParam.iStartOffset);
    #endif
    if (eResult != ZMF_RS_OK)
    {
        return AUDIO_OP_ERROR;
    }

    /* ͨʣÿʼ */
    iRet = Audio_ControlProcInitParam();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        return AUDIO_OP_ERROR;
    }
    
    /* Ƶ */
    iRet = Audio_GetNewBuffer();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        return AUDIO_OP_ERROR;
    }
    
    /* Ƶݽвݣ룬仺 */
    iRet = Audio_ControlProcDataProc();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        /* ݳҪͷŵƵ(Чδʹ)
        ֤뻺ʱ뵽*/
        zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);
        /* stopӿںҪȫƵеϢ */
        zOss_Memset(&(g_AudioControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));

        return AUDIO_OP_ERROR;
    }

    /* Ƶ̷߳ƵϢ*/
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        /* ƵϢҪͷŵƵ(Чδʹ)
        ֤뻺ʱ뵽*/
        zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);
        /* stopӿںҪȫƵеϢ */
        zOss_Memset(&(g_AudioControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));

        return AUDIO_OP_ERROR;
    }

    /* Ƶģ״̬ */
    g_Curstate = AUDIO_PLAY_STATE_PLAY;
    
    return AUDIO_OP_SUCCESS;
}


/**
 * ƣ Audio_ControlProcCycleStart 
 *  ѭſʼ
 * ˵ (IN) 
 *   ֵ ɹAUDIO_OP_SUCCESS
 * ˵ 
 */
static SINT32 Audio_ControlProcCycleStart(VOID)
{
    SINT32 iRet = -1;

    if (ZM_FileID_MIDI_10 == g_AudioFileParam.pFileInfo->eFileType
        || ZM_FileID_IMY == g_AudioFileParam.pFileInfo->eFileType)
    {
        iRet = Audio_ControlProcCycleStartHard();
        if (iRet != AUDIO_OP_SUCCESS)
        {
            return AUDIO_OP_ERROR;
        }
    }
    else
    {
        iRet = Audio_ControlProcCycleStartSoft();
        if (iRet != AUDIO_OP_SUCCESS)
        {
            return AUDIO_OP_ERROR;
        }
    } 
    
    return AUDIO_OP_SUCCESS;
}

/**
 * ƣ Audio_ControlProcStopMsg 
 *  ֹͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcStopMsg(VOID)
{
    SINT32         iRet = -1;
    EZMFResultCode rtCode = ZMF_RS_ERROR;
    
    /* Ƶ̷߳ƵֹͣϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* ȴƵ̴߳ */
    zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    /* Ƶֱֹ߳ͣӷ */
    if (g_ErrorCode != AUDIO_NO_ERROR)
    {
        return; 
    }

    /* ضλļļͷλ */
    #ifdef USE_MEIDA_MEM_POOL
    rtCode = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK_INIT);
    #else
    rtCode = Seek(g_AudioFileParam.u32FileID, 0);
    #endif
    if (rtCode != ZMF_RS_OK)
    {
        g_ErrorCode = AUDIO_ERROR;
        return; 
    }

#if 0
    if(s_pcm_handle != NULL)
    {
        zOss_FClose(s_pcm_handle);
        s_pcm_handle = NULL;
    }
#endif

    g_AudioControlParam.tAudioBuffer.uiStartTime = 0;
    /* Ƶϱ־ */
    g_AudioControlParam.iAudioExp &= ~AUDIO_FILE_OVER_EXP;    
    /* Ƶģ״̬(ڲи£ΪϢģ״̬) */
    g_Curstate = AUDIO_PLAY_STATE_READY;
        
    return;
}

/**
 * ƣ Audio_ControlProcPauseMsg 
 *  ͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcPauseMsg(VOID)
{
    SINT32         iRet = -1;
    
    /* Ƶ̷߳ͣϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_PAUSE);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* ȴƵ̴߳ */
    zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    /* Ƶֱ߳ͣӷ */
    if (g_ErrorCode != AUDIO_NO_ERROR)
    {
        return; 
    }

    /* Ƶģ״̬ */
    g_Curstate = AUDIO_PLAY_STATE_PAUSE;
    
    return;
}

/**
 * ƣ Audio_ControlProcResumeMsg 
 *  ָϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcResumeMsg(VOID)
{    
    BOOL   bAudioData = TRUE;  /* Ƶݴ */
    SINT32 iRet       = -1;
    
    /* Ƶ̷߳ͻָϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_RESUME);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* ȴƵ̴߳ */
    zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    /* Ƶֱָ̻߳ӷ */
    if (g_ErrorCode != AUDIO_NO_ERROR)
    {
        return; 
    }    

    /* ļǷѾȡϣȡϣֱӷ */
    if (g_AudioControlParam.iAudioExp & AUDIO_FILE_OVER_EXP
        && zOss_ListCount(g_pAudioDataList) == 0)
    {
        if(g_AudioControlParam.tAudioBuffer.eBufState == AUDIO_BUF_UNUSED)
        {
            VOID     *pPhyBuf     = g_AudioControlParam.tAudioBuffer.pPhyBuffer;
            UINT32    uiBufLen    = g_AudioControlParam.tAudioBuffer.uiBufLen;
            uiBufLen = uiBufLen <= 320 ? uiBufLen : 320;
            /* Ҫŵ0 */
            zOss_Memset(pPhyBuf, 0, uiBufLen);  
            g_AudioControlParam.tAudioBuffer.eBufState = AUDIO_BUF_USED;
            zOss_Printf(SUBMDL_TEST,PRINT_LEVEL_NORMAL, "zDrv_Write pPhyBuf: %d, LINE: %d",pPhyBuf,__LINE__);
            iRet = zDrv_Write(g_AudioControlParam.uiFdAudio, (const VOID *)pPhyBuf, uiBufLen);
        }
        /* Ƶģ״̬ */
        g_Curstate = AUDIO_PLAY_STATE_PLAY;
        
        return;
    }

    /* ½뿪ʼ */
    /* Ƶ */
    iRet = Audio_GetNewBuffer();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    /* ļ벢仺 */
    iRet = Audio_ControlProcDataProc();
    /* ݶȡ */
    if (AUDIO_OP_DATAEND == iRet)
    {
        /* ̷߳ƵݶȡϢ */
        /* zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_OUT_OVER); */
        /* Ƶݴ */
        bAudioData = FALSE;  
    }
    else if (AUDIO_OP_ERROR == iRet)
    {
        /* ݳҪͷŵƵ(Чδʹ)
        ֤뻺ʱ뵽*/
        zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);
        /* stopӿںҪȫƵеϢ */
        zOss_Memset(&(g_AudioControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));
            
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* Ƶ߳ */
    if(bAudioData)
    {
        iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT);
        if (iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }
    }  

    /* Ƶģ״̬ */
    g_Curstate = AUDIO_PLAY_STATE_PLAY;
        
    return;
}

/**
 * ƣ Audio_ControlProcSeekMsg 
 *  ضλϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcSeekMsg(VOID)
{
    SINT32 iRet = -1;
    EZMFResultCode eResult = ZMF_RS_ERROR;
        
    /* ģ鴦ڲͬ״̬ҪвͬĴ */
    /* play״̬ */
    if (g_Curstate == AUDIO_PLAY_STATE_PLAY)
    {
        /* Ƶ̷߳ƵֹͣϢ */
        iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
        if (iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
        /* Ƶֹ߳ͣ */
        if (g_ErrorCode != AUDIO_NO_ERROR)
        {
            return;
        }
        
        /* ضλļָλ */
        #ifdef USE_MEIDA_MEM_POOL
        eResult = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK);
        #else
        eResult = Seek(g_AudioFileParam.u32FileID, g_AudioPlayParam.iSeekOffset);
        #endif
        if (eResult != ZMF_RS_OK)
        {
		    /* ضλʧܺûпܼţʱָ豸״̬ͻ */
		    Audio_ControlProcStartMsg();
			
            g_ErrorCode = AUDIO_ERROR;
            return;
        }
                
        /* ƵӦƵʼʱ */
        g_AudioControlParam.tAudioBuffer.uiStartTime = g_AudioPlayParam.iSeekOffset;
                
        /* ¿ʼ̣︴˿ʼϢĴ롣
        * עֹͣܵЧƵϢĶѻ
        * ƵϢʱԻ״̬жϣЩЧĽϢ
        */
        Audio_ControlProcStartMsg();
        if(g_ErrorCode == AUDIO_ERROR)
        {
            /* ֪ͨ߳ */
            zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_OUT_OVER);                         
            g_ErrorCode = AUDIO_NO_ERROR;
        }
    }
    /* pause״̬ */
    else if (g_Curstate == AUDIO_PLAY_STATE_PAUSE)
    {
        /* Ƶ̷ֹ߳ͣϢ */
        iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_STOP);
        if (iRet != MSP_COM_OP_SUCCESS)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }    

        /* ȴƵ̴߳ */
        zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
        /* Ƶֹ߳ͣ */
        if (AUDIO_ERROR == g_ErrorCode)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }

        /* ضλļָλ */
        #ifdef USE_MEIDA_MEM_POOL
        eResult = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK);
        #else
        eResult = Seek(g_AudioFileParam.u32FileID, g_AudioPlayParam.iSeekOffset);
        #endif
        if (eResult != ZMF_RS_OK)
        {
		    /* ضλʧܺûпܼţʱָ豸״̬ͻ */
            iRet = Audio_ControlProcInitParam();
            iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_PAUSE, NULL);
            g_ErrorCode = AUDIO_ERROR;
            return;
        }
                
        /* ƵӦƵʼʱ */
        g_AudioControlParam.tAudioBuffer.uiStartTime = g_AudioPlayParam.iSeekOffset;

        /* ֹͣƵѾֹͣҪȽstart */
        iRet = Audio_ControlProcInitParam();
        if (iRet != AUDIO_OP_SUCCESS)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }
                
        /* Ϊ˱ԭpause̬Ҫٽpause */
        iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_PAUSE, NULL);
        if (iRet < 0)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }
    }
        /* ready״̬ */
    else if(g_Curstate == AUDIO_PLAY_STATE_READY)
    {           
        /* ضλļָλ */
        #ifdef USE_MEIDA_MEM_POOL
        eResult = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK);
        #else
        eResult = Seek(g_AudioFileParam.u32FileID, g_AudioPlayParam.iSeekOffset);
        #endif
        if (eResult != ZMF_RS_OK)
        {
            g_ErrorCode = AUDIO_ERROR;
            return;
        }
                
        /* ƵӦƵʼʱ */
        g_AudioControlParam.tAudioBuffer.uiStartTime = g_AudioPlayParam.iSeekOffset;
        /* Ƶϱ־ */
        //g_AudioControlParam.iAudioExp &= ~AUDIO_FILE_OVER_EXP;
    }
    else
    {

        g_ErrorCode = AUDIO_ERROR;
        return;
    }
        
    return;
}

/**
 * ƣ Audio_ControlProcAudioDecodeMsg 
 *  ƵϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcAudioDecodeMsg(VOID)
{
    SINT32 iRet = -1;

    /* ЧδʹõƵĳͣȲ
     * ̻߳ѹ˶ƵϢϢӦ 
    */
    if(g_AudioControlParam.tAudioBuffer.eBufState != AUDIO_BUF_UNUSED)
    {
        return;
    } 
    
    zOss_Printf(1, 1, "Ƶ");
    
    /* ļ벢仺 */
    iRet = Audio_ControlProcDataProc();
    /* Ƶݶȡϣͨص֪ͨϲû */
    if (AUDIO_OP_DATAEND == iRet)
    {
        return;    
    }
    if (iRet != AUDIO_OP_SUCCESS)
    {
        g_AudioControlParam.iAudioExp |= AUDIO_OP_EXP;

        /* ֪ͨϲûƵģ쳣 */
        Audio_NotifyUser(iRet);        
        g_ErrorCode = AUDIO_ERROR;
        
        return;
    }

    /* ֪ͨƵ߳ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT);
    if (iRet != AUDIO_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        
        return;
    }
    
    return;
}

/**
 * ƣ Audio_ControlProcCloseMsg 
 *  ƵرϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcCloseMsg(VOID)
{
    SINT32 iRet = -1;
    /* ̷߳͹رϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pAudioOutThread, EV_AUDIO_OUT_CLOSE);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* ȴƵ߳Ƶ */
    zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    
    return;
}

/**
 * ƣ Audio_ControlThreadLoop 
 *  Ƶ߳̽Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlThreadLoop(VOID)
{
    BOOL             bQuit    = FALSE;
    UINT32           uMsgId   = 0;
    SINT32           iRet     = -1;
    EZMFResultCode   eResult  = ZMF_RS_ERROR;

    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uMsgId, ZOSS_WAIT_FOREVER); 
        /* ϢϢ */
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            /* ϢϢID0 */
            uMsgId = 0;
            continue;
        }

        /* ready״ֻ̬startseekcloseϢ */
        if (AUDIO_PLAY_STATE_READY == g_Curstate)
        {
            if (uMsgId != EV_AUDIO_START_PLAY_SYN
            && uMsgId != EV_AUDIO_SEEK_PLAY_SYN
            && uMsgId != EV_AUDIO_CLOSE_PLAY_SYN)
            {
                /* ϢϢID0ֹϢٴαϢ */
                uMsgId = 0;
                continue;
            }
        }

        /* pause״ֻ̬resumestopcloseseekoverϢ */
        /* ˴ж״̬Ϊ˱ͣ״̬»ѹƵϢ */
        if (AUDIO_PLAY_STATE_PAUSE == g_Curstate)
        {
            if (uMsgId != EV_AUDIO_RESUME_PLAY_SYN
            &&  uMsgId != EV_AUDIO_STOP_PLAY_SYN
            &&  uMsgId != EV_AUDIO_SEEK_PLAY_SYN
            &&  uMsgId != EV_AUDIO_CLOSE_PLAY_SYN
            &&  uMsgId != EV_AUDIO_OUT_OVER)
            {
                /* ϢϢID0ֹϢٴαϢ */
                uMsgId = 0;
                continue;
            }
        }

        /* 쳣ģʽֻضϢ */
        if (g_AudioControlParam.iAudioExp & AUDIO_OP_EXP)
        {
            /* 쳣ϱƵ */
            if (EV_AUDIO_EX == uMsgId
             || EV_AUDIO_DATA_DECODE == uMsgId)
            {
                /* ͷϢԴ */
                uMsgId = 0;
                continue;
            }

            /* šָͣضλͬϢ */
            if (EV_AUDIO_START_PLAY_SYN == uMsgId
             || EV_AUDIO_PAUSE_PLAY_SYN == uMsgId
             || EV_AUDIO_RESUME_PLAY_SYN == uMsgId
             || EV_AUDIO_SEEK_PLAY_SYN == uMsgId)
            {
                /* ͷͬź֪ͨûռ߳Ϣ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);
                /* ͷϢԴ */
                uMsgId = 0;
                continue;
            }
        }
                 
        /* ܵͬϢвͬĴ */
        switch(uMsgId)
        {
            case EV_AUDIO_START_PLAY_SYN:
            {
                #ifdef TEST_CREATE_INDEX
                /* MP3,AAC֣ҲǴͷʼţȴ */
                if((/*ZM_FileID_MP3 == g_AudioFileParam.pFileInfo->eFileType
                    || */ZM_FileID_AAC == g_AudioFileParam.pFileInfo->eFileType)
                    && 0 < g_AudioPlayParam.iStartOffset)
                {
                    zOss_GetSemaphore(g_IndexSemID, ZOSS_WAIT_FOREVER);
                    
                    zOss_PutSemaphore(g_IndexSemID);
                }
                #endif
                
                /* ļλҪʼλ */
                #ifdef USE_MEIDA_MEM_POOL
                eResult = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK_START);
                #else
                eResult = Seek(g_AudioFileParam.u32FileID, g_AudioPlayParam.iStartOffset);
                #endif
                if (eResult != ZMF_RS_OK)
                {
                    g_ErrorCode = AUDIO_ERROR;
                    zOss_PutSemaphore(g_AudioControlParam.pControlSem);
                    
                    break;
                }

                /* ʼϢ */
                Audio_ControlProcStartMsg();
                /* ͷͬź,֪ͨû߳̿ʼϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_STOP_PLAY_SYN:
            {
                /* ֹͣϢ */
                Audio_ControlProcStopMsg();
                /* ͷͬź֪ͨûֹ߳ͣϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_PAUSE_PLAY_SYN:
            {
                /* ͣϢ */
                Audio_ControlProcPauseMsg();
                /* ͷͬź֪ͨû߳ͣϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_RESUME_PLAY_SYN:
            {
                /* ָϢ */
                Audio_ControlProcResumeMsg();
                /* ͷͬź֪ͨûָ̻߳Ϣ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_SEEK_PLAY_SYN:
            {
                /* ضλϢ */
                Audio_ControlProcSeekMsg();
                /* ͷͬź֪ͨû߳ضλϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_CLOSE_PLAY_SYN:
            {
                /* رղϢ */
                Audio_ControlProcCloseMsg();
                /* ˴ͷͬźͬźͷ߳ںʱͷ */

                bQuit = TRUE;
                break;        
            }

            case EV_AUDIO_DATA_DECODE:
            {
                /* ײ㲥쳣 */
                if (g_AudioControlParam.iAudioExp & AUDIO_PCM_EXP)
                {
                    /* ֪ͨû */
                    g_AudioControlParam.iAudioExp |= AUDIO_OP_EXP;
                    Audio_NotifyUser(AUDIO_OP_DEVICE_ERR);
                }
                else
                {
                    /* ƵϢ */
                    Audio_ControlProcAudioDecodeMsg();
                    /* Ƶδ */
                }  
                
                break;        
            }

            /* ƵŽϢ */
            case EV_AUDIO_OUT_OVER:
            {
                /* ֪ͨϲûƵ */
                Audio_NotifyUser(AUDIO_OP_DATAEND);
                break;
            }

            /* Ƶģ쳣Ϣ */
            case EV_AUDIO_EX:
            {
                g_AudioControlParam.iAudioExp |= AUDIO_OP_EXP;

                /* ֪ͨϲûƵģ쳣 */
                Audio_NotifyUser(AUDIO_OP_ERROR);
                break;
            }
                        
            default:
            {
                break;
            }            
        }
        
        /* ϢID0ֹϢٴα */
        uMsgId = 0;

        /* ˳whileѭ */
        if(bQuit)
        {
           break; 
        }
    }

   return;    
}

/**
 * ƣ Audio_OutputProcOutMsg 
 *  Ƶ̴߳Ϣ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcOutMsg()
{       
    SINT32 iWriteLen = -1;
    SINT32 iRet = -1;
    
    /* PCM豸 */
//    zOss_Memset(g_AudioControlParam.tAudioBuffer.pPhyBuffer, 0, g_AudioControlParam.tAudioBuffer.uiUsedLen);
    if(g_AudioControlParam.tAudioBuffer.uiUsedLen == 0)
    {
        g_AudioControlParam.tAudioBuffer.uiUsedLen = g_AudioControlParam.tAudioBuffer.uiBufLen;
    }
    
    iWriteLen = zDrv_Write(g_AudioControlParam.uiFdAudio, g_AudioControlParam.tAudioBuffer.pPhyBuffer, g_AudioControlParam.tAudioBuffer.uiUsedLen);
    if (iWriteLen < 0)
    {
        /* ֪̳ͨ߳쳣 */
        iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_EX);
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* Ƶ */
    iRet = Audio_GetNewBuffer();
    if (iRet != AUDIO_OP_SUCCESS)
    {
        /* ֪̳ͨ߳쳣 */
        iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_EX);
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* ̷߳ƵϢ */
    iRet = zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_DATA_DECODE);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
        
    return;
}

/**
 * ƣ Audio_OutputProcPauseMsg 
 *  Ƶ̴߳ƵͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcPauseMsg(VOID)
{
    SINT32 iRet = -1;

    /* Ƶ֪߳ͨײͣ */
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_PAUSE, NULL);
    if (iRet < 0)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;        
    }
    
    return;
}

/**
 * ƣ Audio_OutputProcStopMsg 
 *  Ƶ̴߳ƵֹͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcStopMsg(VOID)
{
    SINT32 iRet = -1;

    /* Ƶ֪߳ͨײֹͣ */
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_STOP, NULL);
    if (iRet < 0)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;        
    }

    /* StopҪȫֱм¼ƵϢ */
    zOss_Memset(&(g_AudioControlParam.tAudioBuffer), 0, sizeof(T_AudioBuffer));
    
    return;
}

/**
 * ƣ Audio_OutputProcResumeMsg 
 *  Ƶ̴߳ƵŻָϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcResumeMsg(VOID)
{
    SINT32 iRet = -1;

    /* Ƶ֪߳ͨײָ */
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdAudio, IOCTL_AUDIO_PLAY_RESUME, NULL);
    if (iRet < 0)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;        
    }
    
    return;
}

/**
 * ƣ Audio_OutputProcCloseMsg 
 *  Ƶ̴߳ƵŹرϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputProcCloseMsg(VOID)
{

    /* ˴ҪرPCMãPCM߳д򿪵ģҲӦ߳йر
       Ƶģ״̬Ready״̬£ֱӷأƵģ״̬PausePlay״̬
       Ҳֱӹرգ״̬ҪȽstopΪͷƵе
       Լȫֱеļ¼ƵϢ */
    if (g_Curstate == AUDIO_PLAY_STATE_PLAY
      || g_Curstate == AUDIO_PLAY_STATE_PAUSE)
    {
        Audio_OutputProcStopMsg();
    }
       
    return;
}

/**
 * ƣ Audio_outputThreadLoop 
 *  Ƶ߳Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
 
static VOID Audio_outputThreadLoop(VOID)
{
    UINT32 uiMsgId = 0;
    SINT32 iRet = -1;
    BOOL bQuit = FALSE;
    
    while (1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsgId, ZOSS_WAIT_FOREVER);
        if (iRet != MSP_COM_OP_SUCCESS)
        {
            /* ϢϢ */
            uiMsgId = 0;
            continue;
        }

        switch(uiMsgId)
        {
            /* PCM */
            case EV_AUDIO_OUT:
            {
                Audio_OutputProcOutMsg();
                break;
            }

            case EV_AUDIO_OUT_PAUSE:
            {
                Audio_OutputProcPauseMsg();
                /* ֪ͨ߳ͣ豸 */
                zOss_PutSemaphore(g_AudioControlParam.pOutputSem);
                
                break;                
            }

            case EV_AUDIO_OUT_RESUME:
            {
                Audio_OutputProcResumeMsg();                
                /* ָ֪̻ͨ߳豸 */
                zOss_PutSemaphore(g_AudioControlParam.pOutputSem);
                
                break;
            }

            case EV_AUDIO_OUT_STOP:
            {
                Audio_OutputProcStopMsg();
                /* ֹ֪ͨ߳ͣ豸 */
                zOss_PutSemaphore(g_AudioControlParam.pOutputSem);
                
                break;
            }            

            case EV_AUDIO_OUT_CLOSE:
            {
                Audio_OutputProcCloseMsg();  

                /* ֪ͨ߳Ƶ */
                zOss_PutSemaphore(g_AudioControlParam.pOutputSem);
                
                bQuit = TRUE;
                
                break;
            }

            default:
            {
                break;
            }
        }

        /* ͷϢID */
        uiMsgId = 0;
        if (bQuit)
        {
            break;
        }
    }
    
    return;
}

/**
 * ƣ Audio_OutputThreadEntry 
 *  Ƶ߳ں
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Audio_OutputThreadEntry(SINT32 arg)
{    
    UINT32 uiMsg = 0;
    /* Ϣѭ */
    Audio_outputThreadLoop();

    /* ͷͬź̴֪ͨ߳߳ */
    zOss_PutSemaphore(g_AudioControlParam.pOutputSem);
    //ȡϢеʣϢTOS߳˳ʱʣϢ
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_NO_WAIT))
    {
        uiMsg = 0;
    }
    return; 
}

#if 0
/**
 * ƣ Audio_GetAudioFd 
 *  ȡƵaudio豸
 * ˵ (IN)handle Ƶž
 *   ֵ ɹزžʧܷOPER_ERROR
 * ˵ 
 */
SINT32 Audio_SetAudioFd(SINT32 fd)
{
    if (fd <= 0)
    {
        return AUDIO_OP_ERROR;
    }
    
    g_AudioFd = fd;
    return g_AudioFd;
}
#endif

/**
 * ƣ Audio_MountDecodeLib 
 *  ⡢ƵزʺϢ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS
 * ˵ 
 */
static AUDIO_RESULT_E Audio_MountDecodeLib(VOID)
{
    SINT32                 iRet;
    EZMFResultCode         eResult = ZMF_RS_ERROR;
    T_ZMFOutPutUnit        *pOutUnit  = NULL;
    T_Audio_AacParam       tAacParam;
    T_ZDrvAudio_Channel    channelMode;
    T_ZDrvAudio_SampleRate sampleRate;

    /* ƵPCMʽ */
    if(ZM_CODEC_ID_PCM_S16LE == g_AudioFileParam.eMediaAType
        && ZM_FileID_WAV == g_AudioFileParam.pFileInfo->eFileType)
    {
        /* ¼pcmͲϢ */
        if(1 == g_AudioFileParam.pFileInfo->tFileInfo.t_wavInfo.tWaveInfo.u16Channels)
        {
            g_AudioFileParam.eChannel = AUDIO_MONO_CHANNEL;
        }
        else if(2 == g_AudioFileParam.pFileInfo->tFileInfo.t_wavInfo.tWaveInfo.u16Channels)
        {
            g_AudioFileParam.eChannel = AUDIO_DUAL_CHANNEL;
        }
        
        zMspCom_GetSampleRate(g_AudioFileParam.pFileInfo->tFileInfo.t_wavInfo.tWaveInfo.u32SamplesPerSec, 
                         &(g_AudioFileParam.eSample));
        
        return AUDIO_NO_ERROR;

    }

    /* Ƶ */
    iRet = zMspCom_LoadAudioDecodeLib(g_AudioFileParam.eMediaAType);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return AUDIO_ERROR;
    }
    
    /* һЩƵʽҪȽһܻ֡ȡʺϢ */
    /* Ƚһ֡ */
    #ifdef USE_MEIDA_MEM_POOL
    {        
        T_MEDIA_AUDIODATA_NODE  *pData = NULL;
        
        eResult = Audio_GetNextAudioFrame(&pData, TRUE);
        if (eResult == ZMF_RS_OK && pData != NULL)
        {
            pOutUnit = pData->pOutUnit;
            zOss_Free(pData);
        }
    }
    #else
    eResult = GetNextFrame(g_AudioFileParam.u32FileID, /*g_AudioFileParam.u32AudioTrack,*/ &pOutUnit);
    #endif
    if (eResult != ZMF_RS_OK)
    {
        zMspCom_UnLoadAudioDecodeLib(g_AudioFileParam.eMediaAType);
        return AUDIO_ERROR;
    }

    /* ļضλʼĲŵ,֤ԺĲ̲ */
    #ifdef USE_MEIDA_MEM_POOL
    eResult = Audio_Seek_Adapt((UINT8)EV_AUDIO_FILE_SEEK_INIT);
    #else
    eResult = Seek(g_AudioFileParam.u32FileID, 0);
    #endif
    if (eResult != ZMF_RS_OK)
    {
        ReleaseUnitData(g_AudioFileParam.u32FileID, pOutUnit);
        zMspCom_UnLoadAudioDecodeLib(g_AudioFileParam.eMediaAType);
        
        return AUDIO_ERROR;
    }

    tAacParam.pDecConfig = NULL;
    tAacParam.iConfigLen = 0;
    tAacParam.u32SampleRate = pOutUnit->uFrameUnit.t_AACFrameUnit.u32SampleRate;
    tAacParam.u32Profile_ObjectType = pOutUnit->uFrameUnit.t_AACFrameUnit.u32Profile_ObjectType + 1;
    
    /* Ƶ */
    g_AudioControlParam.pAudioHandle = zMspCom_OpenAudioDecoder(g_AudioFileParam.eMediaAType, 
                                                                pOutUnit->pPacket, 
                                                                pOutUnit->u32Len, 
                                                                &tAacParam,
                                                                &channelMode, 
                                                                &sampleRate);
    if (NULL == g_AudioControlParam.pAudioHandle)
    {
        g_ErrorCode = AUDIO_ERROR; 
        ReleaseUnitData(g_AudioFileParam.u32FileID, pOutUnit);             
        zMspCom_UnLoadAudioDecodeLib(g_AudioFileParam.eMediaAType);
       
        return AUDIO_ERROR;
    } 

    /* ͷƵ뵥ԪԴ */
    ReleaseUnitData(g_AudioFileParam.u32FileID, pOutUnit);

    /* ¼pcmͲϢ */
    g_AudioFileParam.eChannel = channelMode;
    g_AudioFileParam.eSample = sampleRate;
        
    return AUDIO_NO_ERROR;
}

/**
 * ƣ Audio_UnMountDecodeLib 
 *  رƵж
 * ˵ 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_UnMountDecodeLib(VOID)
{
    EMediaAudioType      eMediaAType;

    eMediaAType = g_AudioFileParam.eMediaAType;
    
    /* رƵ */
    zMspCom_CloseAudioDecoder(g_AudioControlParam.pAudioHandle);
    g_AudioControlParam.pAudioHandle = NULL;
    
    /* жƵ */
    zMspCom_UnLoadAudioDecodeLib(eMediaAType);

    return;
}

/**
 * ƣ Audio_ControlProcSoftCodec 
 *  Ƶ̴߳
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcSoftCodec(VOID)
{

    SINT32          iFdAudio = -1;  
    AUDIO_RESULT_E  tResult = AUDIO_ERROR;
    
    /* PCM豸 */
    iFdAudio = zMspCom_AudioOpen(); 
    if (iFdAudio <= 0)
    {
        g_ErrorCode = AUDIO_ERROR;

        return;
    }
    /* PCM豸¼ȫֱ */
    g_AudioControlParam.uiFdAudio = (UINT32)iFdAudio;

    /* زʼ⡢ӦĽȡʺϢ */
    tResult = Audio_MountDecodeLib();
    if (tResult != AUDIO_NO_ERROR)
    {
        g_ErrorCode = AUDIO_ERROR;

        /* رPCM豸 */
        zMspCom_AudioClose();
        
        return;
    }

    /* Ƶ߳ */
    g_AudioControlParam.pAudioOutThread = zOss_CreateThread(AUDIO_OUT_THREAD,
                                                       Audio_OutputThreadEntry,
                                                       0,
                                                       AUDIO_OUT_STACK,
                                                       AUDIO_OUT_PRI,
                                                       1,
                                                       1);    
    if (ZOSS_INVALID_THREAD_ID == g_AudioControlParam.pAudioOutThread)
    {
        g_ErrorCode = AUDIO_ERROR; 
        Audio_UnMountDecodeLib();
        zMspCom_AudioClose();

        return;
    }

    g_ErrorCode = AUDIO_NO_ERROR;

    /* ͷͬź֪ͨụ̂߳߳׼ */
    zOss_PutSemaphore(g_AudioControlParam.pControlSem);

    /* Ϣѭ */
    Audio_ControlThreadLoop();
    /* ȴ߳̽ */
    zOss_GetSemaphore(g_AudioControlParam.pOutputSem, ZOSS_WAIT_FOREVER);
    
    /* رƵж */
    Audio_UnMountDecodeLib();
    /* رPCM豸 */
    zMspCom_AudioClose();

    /* ߳˳ */
    return;
}

static VOID MidiPlayEndCallBack(T_ZDrvMidi_Info midiStatus)
{
    switch(midiStatus)
    {
        /* midiļЧ */
        case MIDI_INFO_FILE_INVALID:
        {
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_EXP;
            /* ֪̳ͨ߳ */
            zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_EX);
            break;
        }

        /* ײ㲥Ž */
        case MIDI_INFO_PLAY_END:
        {                       
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_OVER_EXP;                   
            /* ֪ͨ߳ */
            zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_OUT_OVER);
            break;
        }

        /* midiļŴ */
        case MIDI_INFO_PLAY_ERR:
        {                       
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_EXP;                   
            /* ֪̳ͨ߳ */
            zMspCom_PostMsg(g_AudioControlParam.pControlThread, EV_AUDIO_EX);
            break;
        }

        default:
        {
            break;
        }
    }
    
    return;
}


/**
 * ƣ Audio_ControlProcStartMsg_HardCodec 
 *  Ӳ뿪ʼϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcStartMsg_HardCodec(VOID)
{     
    UINT8                     iPathOut;
    SINT32                    iRet         = -1;
    UINT32                    iStartOffset = 0;
    AUDIO_RESULT_E            eRet         = AUDIO_ERROR;
    VOLUME_DD_level           volumeLevel;
    T_ZDrvMidi_PlayParam      playParam;
    T_MSP_CHANNEL_OUTPUT      outputPath;
    T_MSP_OUTPUT_VOLUME_LEVEL outputVol;

    /* ȡ */
    eRet = Audio_Volume_Get((FILE_HANDLE)&g_AudioPlayParam, &volumeLevel);
    if(eRet != AUDIO_NO_ERROR)
    {
        return;
    }
    outputVol = (T_MSP_OUTPUT_VOLUME_LEVEL)volumeLevel;

    /* ȡͨ */
    eRet = Audio_ChannelOut_Get((FILE_HANDLE)&g_AudioPlayParam, &iPathOut);
    if(eRet != AUDIO_NO_ERROR)
    {
        return;
    }
    outputPath = (T_MSP_CHANNEL_OUTPUT)iPathOut;

    /*  */
    iRet = zMspCom_SetOutputVol(outputVol); 
    if (iRet < 0)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    /* ͨ */
    iRet = zMspCom_SetOutputChannel(outputPath); 
    if (iRet < 0)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
  
    /* ļλҪʼλ */
    /* midiضλҪΪ */
    iStartOffset = g_AudioPlayParam.iStartOffset * 1000;
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_SEEK, &iStartOffset);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
  
    playParam.pData_buf = g_AudioPlayParam.pMidiBuf;
    playParam.datasize = g_AudioPlayParam.iMidisize;
    playParam.repeat_times = 1;
    
    if(ZM_FileID_MIDI_10 == g_AudioFileParam.pFileInfo->eFileType)
    {
        playParam.format = MIDI_aud_format_midi;
    }
    else if(ZM_FileID_IMY == g_AudioFileParam.pFileInfo->eFileType)
    {
        playParam.format = MIDI_aud_format_imelody;
    }
    else
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    playParam.callback = MidiPlayEndCallBack;
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_PLAY_START, &playParam);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }

    /* Ƶģ״̬ */
    g_Curstate = AUDIO_PLAY_STATE_PLAY;
    
    return;
}

/**
 * ƣ Audio_ControlProcStopMsg_HardCodec 
 *  ӲֹͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcStopMsg_HardCodec(VOID)
{
    SINT32 iRet = -1;
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_PLAY_STOP, NULL);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    return;
}

/**
 * ƣ Audio_ControlProcPauseMsg_HardCodec 
 *  ӲͣϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcPauseMsg_HardCodec(VOID)
{
    SINT32 iRet = -1;
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_PLAY_PAUSE, NULL);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    return;
}

/**
 * ƣ Audio_ControlProcResumeMsg_HardCodec 
 *  ӲָϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcResumeMsg_HardCodec(VOID)
{
    SINT32 iRet = -1;
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_PLAY_RESUME, NULL);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    return;
}

/**
 * ƣ Audio_ControlProcSeekMsg_HardCodec 
 *  ӲضλϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcSeekMsg_HardCodec(VOID)
{    
    SINT32 iRet = -1;
    UINT32 iSeekOffset = 0;
    
    /* midiضλҪΪ */
    iSeekOffset = g_AudioPlayParam.iSeekOffset * 1000;
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_SEEK, &iSeekOffset);
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return;
    }
    
    return;
}

/**
 * ƣ Audio_ControlProcCloseMsg_HardCodec 
 *  ӲرղϢ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcCloseMsg_HardCodec()
{
    //SINT32 iRet = -1;

    #if 0
    iRet = zDrv_Close(g_AudioControlParam.uiFdMidi);    
    if (iRet != DRV_SUCCESS)
    {
        g_ErrorCode = AUDIO_ERROR;
        return; 
    }
    #endif
    
    //zMspCom_MidiClose();
    
    return;
}

/**
 * ƣ Audio_GetCurTime_HardCodec 
 *  Ӳȡǰʱ
 * ˵ (OUT)curtime: 浱ǰʱ
 *   ֵ 
 * ˵ 
 */
SINT32 Audio_GetCurTime_HardCodec(SINT32* curtime)
{
    SINT32 iRet = -1;
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_GET_PLAY_POSITON, curtime);
    if (iRet != DRV_SUCCESS)
    {
        return AUDIO_OP_ERROR;
    }
    
    return AUDIO_OP_SUCCESS;
}

#if 0
/**
 * ƣ Audio_GetTotalTime_HardCodec 
 *  Ӳȡǰܳ
 * ˵ (OUT)curtime: 浱ǰʱ
 *   ֵ 
 * ˵ 
 */
SINT32 Audio_GetTotalTime_HardCodec(SINT32* curtime)
{
    SINT32               iRet = -1;
    T_ZDrvMidi_PlayInfo  playInfo;

    
    playInfo.pData_buf = g_AudioPlayParam.pMidiBuf;
    playInfo.datasize = g_AudioPlayParam.iMidisize;
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_GET_PLAY_TOTALTIME, &playInfo);
    if (iRet != DRV_SUCCESS)
    {
        return AUDIO_ERROR;
    }

    *curtime = playInfo.totalTime;
    
    return AUDIO_OP_SUCCESS;
}
#endif

/**
 * ƣ Audio_ControlThreadLoop_HardCodec 
 *  Ƶ(Ӳ)߳̽Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlThreadLoop_HardCodec(VOID)
{
    UINT32 uMsgId = 0;
    SINT32 iRet = -1;
    BOOL   bQuit = FALSE;

    while(1)
    {
        zOss_Printf(1, 1, "ӲϢ");
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uMsgId, ZOSS_WAIT_FOREVER); 
        /* ϢϢ */
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            /* ϢϢID0 */
            uMsgId = 0;
            continue;
        }

        /* ready״ֻ̬startseekcloseϢ */
        if (AUDIO_PLAY_STATE_READY == g_Curstate)
        {
            if (uMsgId != EV_AUDIO_START_PLAY_SYN
            && uMsgId != EV_AUDIO_SEEK_PLAY_SYN
            && uMsgId != EV_AUDIO_CLOSE_PLAY_SYN)
            {
                /* ϢϢID0ֹϢٴαϢ */
                uMsgId = 0;
                continue;
            }
        }

        /* pause״ֻ̬resumestopcloseseekoverϢ */
        if (AUDIO_PLAY_STATE_PAUSE == g_Curstate)
        {
            if (uMsgId != EV_AUDIO_RESUME_PLAY_SYN
            &&  uMsgId != EV_AUDIO_STOP_PLAY_SYN
            &&  uMsgId != EV_AUDIO_SEEK_PLAY_SYN
            &&  uMsgId != EV_AUDIO_CLOSE_PLAY_SYN
            &&  uMsgId != EV_AUDIO_OUT_OVER)
            {
                /* ϢϢID0ֹϢٴαϢ */
                uMsgId = 0;
                continue;
            }
        }

        /* 쳣ģʽֻضϢ */
        if (g_AudioControlParam.iAudioExp & AUDIO_OP_EXP)
        {
            /* 쳣ϱ */
            if (EV_AUDIO_EX == uMsgId)
            {
                /* ͷϢԴ */
                uMsgId = 0;
                continue;
            }

            /* šָͣضλͬϢ */
            if (EV_AUDIO_START_PLAY_SYN == uMsgId
             || EV_AUDIO_PAUSE_PLAY_SYN == uMsgId
             || EV_AUDIO_RESUME_PLAY_SYN == uMsgId
             || EV_AUDIO_SEEK_PLAY_SYN == uMsgId)
            {
                /* ͷͬź֪ͨûռ߳Ϣ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);
                /* ͷϢԴ */
                uMsgId = 0;
                continue;
            }
        }
                 
        /* ܵͬϢвͬĴ */
        switch(uMsgId)
        {
            case EV_AUDIO_START_PLAY_SYN:
            {
                /* ʼϢ */
                Audio_ControlProcStartMsg_HardCodec();
                /* ͷͬź,֪ͨû߳̿ʼϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_STOP_PLAY_SYN:
            {
                /* ֹͣϢ */
                Audio_ControlProcStopMsg_HardCodec();
                /* ͷͬź֪ͨûֹ߳ͣϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_PAUSE_PLAY_SYN:
            {
                /* ͣϢ */
                Audio_ControlProcPauseMsg_HardCodec();
                /* ͷͬź֪ͨû߳ͣϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_RESUME_PLAY_SYN:
            {
                /* ָϢ */
                Audio_ControlProcResumeMsg_HardCodec();
                /* ͷͬź֪ͨûָ̻߳Ϣ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_SEEK_PLAY_SYN:
            {
                /* ضλϢ */
                Audio_ControlProcSeekMsg_HardCodec();
                /* ͷͬź֪ͨû߳ضλϢ */
                zOss_PutSemaphore(g_AudioControlParam.pControlSem);

                break;        
            }

            case EV_AUDIO_CLOSE_PLAY_SYN:
            {
                /* رղϢ */
                Audio_ControlProcCloseMsg_HardCodec();
                /* ˴ͷͬźͬźͷ߳ںʱͷ */

                bQuit = TRUE;
                break;        
            }

            /* ƵŽϢ */
            case EV_AUDIO_OUT_OVER:
            {
                /* ֪ͨϲûƵ */
                Audio_NotifyUser(AUDIO_OP_DATAEND);
                break;
            }

            /* Ƶģ쳣Ϣ */
            case EV_AUDIO_EX:
            {
                g_AudioControlParam.iAudioExp |= AUDIO_OP_EXP;

                /* ֪ͨϲûƵģ쳣 */
                Audio_NotifyUser(AUDIO_OP_ERROR);
                break;
            }
                        
            default:
            {
                break;
            }            
        }
        
        /* ϢID0ֹϢٴα */
        uMsgId = 0;

        /* ˳whileѭ */
        if(bQuit)
        {
           break; 
        }
    }

   return; 
}


/**
 * ƣ Audio_ControlProcHardCodec 
 *  Ƶ̴߳Ӳ
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlProcHardCodec(VOID)
{
    SINT32               iFdMidi = -1;
    FILE*                pFile = NULL;
    UINT32               iLength = 0;
    UINT32               iCount = 0;
    VOID                *pBuffer;
    SINT32               iRet = -1;
    T_ZDrvMidi_PlayInfo  playInfo;    
    
    /* MIDI豸*/
    iFdMidi = zMspCom_MidiOpen();
    if (iFdMidi <= 0)
    {
        zMspCom_Print();
        g_ErrorCode = AUDIO_ERROR;
        
        return;
    }

    /* MIDI豸¼ȫֱ */
    g_AudioControlParam.uiFdMidi = (UINT32)iFdMidi;

    /* ļ */
    pFile = zMsp_FOpen((const CHAR*)g_AudioPlayParam.filepath, "r+b");
    if(NULL == pFile)
    {
        zMspCom_Print();
        zMspCom_MidiClose();
        g_ErrorCode = AUDIO_ERROR;
        
        return;
    }
    
    iLength = zMsp_FLength(pFile);
    if(0 == iLength
       || ZOSS_ERROR == iLength)
    {
        zMsp_FClose(pFile);
        zMspCom_MidiClose();
        g_ErrorCode = AUDIO_ERROR;

        return;
    }

    /* ̬뻺ռ */
    pBuffer = zOss_Malloc(iLength);
    if (NULL == pBuffer)
    {
        zMspCom_Print();
        zMsp_FClose(pFile);
        zMspCom_MidiClose();
        g_ErrorCode = AUDIO_ERROR;

        return;
    }
    zOss_Memset(pBuffer, 0, iLength);
    
    /* midiļһԶ뻺 */
    iCount = zMsp_FRead(pBuffer, 1, iLength, pFile);
    if (iCount != iLength) 
    {
        zMspCom_Print();
        zOss_Free(g_AudioPlayParam.pMidiBuf);
        zMsp_FClose(pFile);
        zMspCom_MidiClose();        
        g_ErrorCode = AUDIO_ERROR;
        
        return;
    }

    /* رļ */
    zMsp_FClose(pFile);

    /* ¼MIDIСMIDIָ */
    g_AudioPlayParam.iMidisize = iLength;
    g_AudioPlayParam.pMidiBuf = pBuffer;

    /* ȡMIDIʱ */
    playInfo.datasize = iLength;
    playInfo.pData_buf = pBuffer;    
    if(ZM_FileID_MIDI_10 == g_AudioFileParam.pFileInfo->eFileType)
    {
        playInfo.format = MIDI_aud_format_midi;
    }
    else if(ZM_FileID_IMY == g_AudioFileParam.pFileInfo->eFileType)
    {
        playInfo.format = MIDI_aud_format_imelody;
    }
    else
    {
        zMspCom_Print();
        zOss_Free(g_AudioPlayParam.pMidiBuf);
        zMspCom_MidiClose();
        g_ErrorCode = AUDIO_ERROR;

        return;
    }
    
    iRet = zDrv_Ioctl(g_AudioControlParam.uiFdMidi, IOCTL_MIDI_GET_PLAY_TOTALTIME, &playInfo);
    if (iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        zOss_Free(g_AudioPlayParam.pMidiBuf);
        zMspCom_MidiClose();
        g_ErrorCode = AUDIO_ERROR;

        return;
    }
    /* ¼MIDIļܳ */
    g_AudioFileParam.uiFileTotalTime = playInfo.totalTime;
    
    /* ͷͬź֪ͨụ̂߳߳׼ */
    zOss_PutSemaphore(g_AudioControlParam.pControlSem);

    /* Ϣѭ */
    Audio_ControlThreadLoop_HardCodec();
    
    /* ͷMIDIļ뻺 */
    if (g_AudioPlayParam.pMidiBuf != NULL)
    {
        zOss_Free(g_AudioPlayParam.pMidiBuf);
    }
    /* رMIDI豸 */
    zMspCom_MidiClose();

    /* ߳˳ */    
    return;
}


/**
 * ƣ Audio_ControlThreadEntry 
 *  Ƶ߳ں
 * ˵ (IN) arg ߳ں
 *   ֵ 
 * ˵ 
 */
static VOID Audio_ControlThreadEntry(SINT32 arg)
{
    SINT32          iResult = -1;   
    UINT32          uiMsg   = 0;
    
    #ifdef USE_MEIDA_MEM_POOL
    g_FileThreadID = zOss_CreateThread(AUDIO_FILEREAD_THREAD,
                                       Audio_FileReadThreadEntry, 
                                       0, 
                                       AUDIO_FILEREAD_STACK, 
                                       AUDIO_FILEREAD_PRI, 
                                       1, 
                                       1);
    if(g_FileThreadID == NULL)
    {
        g_ErrorCode = AUDIO_ERROR;
        /* ͷͬź */
        zOss_PutSemaphore(g_AudioControlParam.pControlSem);
        return;
    }

    zOss_GetSemaphore(g_FileCtrlSemID, ZOSS_WAIT_FOREVER);
    if(g_ErrorCode == AUDIO_ERROR)
    {
        g_ErrorCode = AUDIO_ERROR;
        /* ͷͬź */
        zOss_PutSemaphore(g_AudioControlParam.pControlSem);
        return;
    }
    
    #else
    /* ȽƵʼ */    
    /* ƵԤ */
    iResult = zMspCom_DecPreProcess(MSP_MODULE_AUDIO, (const char*)g_AudioPlayParam.filepath, &g_AudioFileParam);
    if (iResult != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        g_ErrorCode = AUDIO_ERROR;
        /* ͷͬź */
        zOss_PutSemaphore(g_AudioControlParam.pControlSem);
        return;
    }
    #endif

    /* жӲ뻹 */
    if (ZM_FileID_MIDI_10 == g_AudioFileParam.pFileInfo->eFileType
        ||ZM_FileID_IMY == g_AudioFileParam.pFileInfo->eFileType)
    {
        Audio_ControlProcHardCodec();
    }
    else
    {
        Audio_ControlProcSoftCodec(); 
    }
    
#ifdef TEST_CREATE_INDEX
    /* ɾļ */
    if(g_bIsFinishedIndex && g_ptExIndex != NULL
        && (/*ZM_FileID_MP3 == g_AudioFileParam.pFileInfo->eFileType
            ||*/ ZM_FileID_AAC == g_AudioFileParam.pFileInfo->eFileType)
      )
    {
        DeleteExIndex(g_AudioFileParam.u32FileID, g_ptExIndex);
        g_ptExIndex = NULL;
    }

#endif
    
    #ifdef USE_MEIDA_MEM_POOL
    zMspCom_PostMsg(g_FileThreadID, EV_AUDIO_FILE_STOP);
    zOss_GetSemaphore(g_FileCtrlSemID, ZOSS_WAIT_FOREVER);
    
    #else
    /* رýļ */
    zMspCom_DecPostProcess(g_AudioFileParam.u32FileID);
    #endif
    
    //ȡϢеʣϢTOS߳˳ʱʣϢ
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_NO_WAIT))
    {
        uiMsg = 0;
    }
    /* ͷͬź */
    zOss_PutSemaphore(g_AudioControlParam.pControlSem);

    return;
}

#ifdef TEST_CREATE_INDEX
/**
 * ƣ InitIndexCreatingThread 
 *  ʼԴ߳
 * ˵ 
 *   ֵ 
 * ˵ 
 */
static AUDIO_RESULT_E InitIndexCreatingThread()
{
    g_bIsFinishedIndex      = FALSE;
    g_bIsQuitIndexCreating  = FALSE;
    
    /* ߳ͬź */
    g_IndexSemID = zOss_CreateSemaphore(AUDIO_INDEX_SEM, 0);
    if(NULL == g_IndexSemID)
    {
        zOss_ASSERT(0);
        
        return AUDIO_ERROR;
    }

    /* ̨߳ */
    g_IndexThreadID = zOss_CreateThread(AUDIO_INDEX_THREAD, 
                                IndexCreatingThreadEntry, 
                                0, 
                                AUDIO_INDEX_STACK, 
                                AUDIO_INDEX_PRI, 
                                1, 
                                1);
    if(NULL == g_IndexThreadID)
    {
        zOss_DeleteSemaphore(g_IndexSemID);
        zOss_ASSERT(0);
        
        return AUDIO_ERROR;
    }
    
    return AUDIO_NO_ERROR;

}

/**
 * ƣ ReleaseIndexCreatingThread 
 *  ͷԴ
 * ˵ 
 *   ֵ 
 * ˵ 
 */
static AUDIO_RESULT_E ReleaseIndexCreatingThread()
{
    /* ж˳־ */
    g_bIsQuitIndexCreating  = TRUE;

    /* δȴж˳ */
    if(NULL != g_IndexSemID)
    {
        zOss_GetSemaphore(g_IndexSemID, ZOSS_WAIT_FOREVER);
        zOss_DeleteSemaphore(g_IndexSemID);
        g_IndexSemID = NULL;
    }

    return AUDIO_NO_ERROR;
}

/**
 * ƣ IndexCreatingThreadEntry 
 *  ߳ں
 * ˵ IN: arg
 *   ֵ 
 * ˵ 
 */
static VOID IndexCreatingThreadEntry(SINT32 arg)
{
    UINT32         u32IndexFileID         = 0;
    EZMFResultCode rtCode		          = ZMF_RS_ERROR;
    UInt32         u32IndexItem           = 1000;
    char*          pFilePath              = g_AudioPlayParam.filepath;

    /* Ҫ´һļ */
    rtCode = OpenMediaFileHandler(pFilePath, ZMF_FILE_READ, &u32IndexFileID);
    if(ZMF_RS_OK != rtCode)
    {
        zOss_ASSERT(0);
        zOss_PutSemaphore(g_IndexSemID);
    }

    /*  */
    rtCode = CreateExIndex(u32IndexFileID, u32IndexItem, &g_ptExIndex, zmfCreateIndexOut);

    /* ļģ飬Ա֧ضλ */
    rtCode = SetExIndex(g_AudioFileParam.u32FileID, g_ptExIndex);

    /* ߳̽־ */
    g_bIsFinishedIndex      = TRUE;
    
    /* رļ */
    CloseMediaFileHandler(u32IndexFileID);
    
    zOss_PutSemaphore(g_IndexSemID);
    
}

/**
 * ƣ zmfCreateIndexOut 
 *  ļģ鴴ʱĻص
 * ˵ IN: o_s32ParsedSecond: ǰ
                  o_b8QuitFlag     : ˳־
 *   ֵ 
 * ˵ ʽȷ
 */
EZMFResultCode zmfCreateIndexOut(SInt32 o_s32ParsedSecond, Bool8* o_b8QuitFlag)
{	
	zOss_Printf(1, 1, "ѽ: %d\n",o_s32ParsedSecond);
    //˳
	if(g_bIsQuitIndexCreating)
	{
        *o_b8QuitFlag = TRUE;
		zOss_Printf( 1, 1, "ж˳\n");
	}

	return ZMF_RS_OK;
}
#endif

#ifdef USE_MEIDA_MEM_POOL

static VOID Audio_ReadData(BOOL bInit)
{
    UINT32                  uiListCount = 0;    
    T_MEDIA_AUDIODATA_NODE  *pAudioDataNode = NULL;
    T_ZMFOutPutUnit         *ptempOutUnit   = NULL;
    EZMFResultCode           iRet           = ZMF_RS_OK;

    if((g_AudioControlParam.iAudioExp & AUDIO_FILE_OVER_EXP)
        || (g_AudioControlParam.iAudioExp & AUDIO_FILE_EXP))
    {
        return;
    }

    uiListCount = zOss_ListCount(g_pAudioDataList);
    if(bInit)
    {
        //ǳʼֻȡһ֡
        uiListCount = AUDIO_POOL_SIZE - 1;
    }
    
    while(uiListCount < AUDIO_POOL_SIZE)
    {
        iRet = GetNextFrame(g_AudioFileParam.u32FileID, &ptempOutUnit);
        if (ZMF_RS_DATA_READ_OVER == iRet)
        {           
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_OVER_EXP;

            //ʱΪգڵȴź粻ͷţ
            if(zOss_ListCount(g_pAudioDataList) == 0)
            {
                zOss_PutSemaphore(g_FileReadSemID);
            }
            break;
        }
        else if(ZMF_RS_OK != iRet)
        {           
            g_AudioControlParam.iAudioExp |= AUDIO_FILE_EXP;

            //ʱΪգڵȴź粻ͷţ
            if(zOss_ListCount(g_pAudioDataList) == 0)
            {
                zOss_PutSemaphore(g_FileReadSemID);
            }
            break;
        }
        /* 汾еһ֡Ƶ֡Ϊ㣬ԭ */
        if(ptempOutUnit->u32Len == 0 && ptempOutUnit->eCodeID != ZM_CODEC_ID_AMR_NB)
        {
            ReleaseUnitData(g_AudioFileParam.u32FileID, ptempOutUnit);
            continue;
        }
        
        pAudioDataNode = zOss_Malloc(sizeof(T_MEDIA_AUDIODATA_NODE));
        if(NULL == pAudioDataNode)
        {
            ReleaseUnitData(g_AudioFileParam.u32FileID, ptempOutUnit);
            //ʱΪգڵȴź粻ͷţ
            if(zOss_ListCount(g_pAudioDataList) == 0)
            {
                zOss_PutSemaphore(g_FileReadSemID);
            }
            return;
        }
        
        pAudioDataNode->pOutUnit = ptempOutUnit;
        
        zOss_GetMutex(g_DataListLock, ZOSS_WAIT_FOREVER);
        zOss_ListAdd(g_pAudioDataList, (T_ZOss_Node *) pAudioDataNode);
        zOss_PutMutex(g_DataListLock);
        uiListCount++;
        zOss_PutSemaphore(g_FileReadSemID);
    }

    return;
    
}

/**
 * ƣ Audio_Seek_Msg 
 *  ӻضλʵ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 *            
 */
static EZMFResultCode Audio_Seek_Msg(UINT32 uiOffset)
{
    EZMFResultCode rtCode = ZMF_RS_ERROR;

    /* ضλʱͷŻе */
    Audio_ReleseDataList();
    rtCode = Seek(g_AudioFileParam.u32FileID, uiOffset);

    return rtCode;
}

/**
 * ƣ Audio_Seek_Adapt 
 *  ӻضλʵ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 *            
 */
static EZMFResultCode Audio_Seek_Adapt(UINT8 uiSeekFlag)
{
    zMspCom_PostMsg(g_FileThreadID, uiSeekFlag);
    
    zOss_GetSemaphore(g_FileCtrlSemID, ZOSS_WAIT_FOREVER);
    if(g_ErrorCode != AUDIO_NO_ERROR)
    {
        g_ErrorCode = AUDIO_NO_ERROR;
        return ZMF_RS_ERROR;
    }

    return ZMF_RS_OK;
}


/**
 * ƣ Audio_GetNextAudioFrame 
 *  Ƶģȡһ֡Ƶ
 * ˵ (IN) pOutUnit ýļָ
 *   ֵ EZMFResultCode
 * ˵ 
 *            
 */
static EZMFResultCode Audio_GetNextAudioFrame(T_MEDIA_AUDIODATA_NODE **pData, BOOL bInit)
{
    T_MEDIA_AUDIODATA_NODE  *pAudioDataNode = NULL;
    T_ZMFOutPutUnit         *ptempOutUnit   = NULL;
    EZMFResultCode           iRet           = ZMF_RS_OK;

    if((g_AudioControlParam.iAudioExp & AUDIO_FILE_OVER_EXP)
        && zOss_ListCount(g_pAudioDataList) == 0)
    {
        return ZMF_RS_DATA_READ_OVER;
    }

    if((g_AudioControlParam.iAudioExp & AUDIO_FILE_EXP)
        && zOss_ListCount(g_pAudioDataList) == 0)
    {
        return ZMF_RS_DATA_READ_OVER;
    }

    if(bInit)
    {
        zMspCom_PostMsg(g_FileThreadID, EV_AUDIO_FILE_READ_INIT);
    }
    else
    {
        zMspCom_PostMsg(g_FileThreadID, EV_AUDIO_FILE_READ);
    }
    
    zOss_GetSemaphore(g_FileReadSemID, ZOSS_WAIT_FOREVER);
    /* Ƶݣȡһ */
    if(zOss_ListCount(g_pAudioDataList) > 0)
    {
        zOss_GetMutex(g_DataListLock, ZOSS_WAIT_FOREVER);
        pAudioDataNode = (T_MEDIA_AUDIODATA_NODE  *)zOss_ListFirst(g_pAudioDataList);
        zOss_ListDelete(g_pAudioDataList, (T_ZOss_Node *)pAudioDataNode);
        zOss_PutMutex(g_DataListLock);
        
        (*pData) = pAudioDataNode;

        return ZMF_RS_OK;
    } 
    else
    {
        return ZMF_RS_DATA_READ_OVER;
    }
}


/**
 * ƣ Audio_ReleseDataList 
 *  ͷƵĿռ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 *            
 */
static VOID Audio_ReleseDataList()
{
    T_MEDIA_AUDIODATA_NODE  *pAudioDataNode = NULL;

    zOss_GetMutex(g_DataListLock, ZOSS_WAIT_FOREVER);
    while(1)
    {
        if(zOss_ListCount(g_pAudioDataList) > 0)
        {
            zOss_GetSemaphore(g_FileReadSemID, ZOSS_WAIT_FOREVER);
            pAudioDataNode = (T_MEDIA_AUDIODATA_NODE  *)zOss_ListFirst(g_pAudioDataList);
            zOss_ListDelete(g_pAudioDataList, (T_ZOss_Node *)pAudioDataNode);
            ReleaseUnitData(g_AudioFileParam.u32FileID, pAudioDataNode->pOutUnit);
            zOss_Free(pAudioDataNode);
        }
        else
        {
            break;
        }
    }
    zOss_PutMutex(g_DataListLock);
    
    return;
}

/**
 * ƣ Audio_FileReadThreadLoop 
 *  ļȡ߳Ϣѭ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static VOID Audio_FileReadThreadLoop(VOID)
{
    UINT32 uiMsgId = 0;
    SINT32 iRet = -1;
    BOOL bQuit = FALSE;
    SINT32 iResult = 0;
    while (1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsgId, ZOSS_WAIT_FOREVER);
        if (iRet != MSP_COM_OP_SUCCESS)
        {
            /* ϢϢ */
            uiMsgId = 0;
            continue;
        }

        switch(uiMsgId)
        {
            case EV_AUDIO_FILE_READ:
            {
                Audio_ReadData(FALSE);
                break;
            }
            
            case EV_AUDIO_FILE_READ_INIT:
            {
                Audio_ReadData(TRUE);
                break;
            }
            
            case EV_AUDIO_FILE_SEEK:
            {
                iResult = Audio_Seek_Msg(g_AudioPlayParam.iSeekOffset);
                if(iResult != ZMF_RS_OK)
                {
                    g_ErrorCode = AUDIO_ERROR;
                }
                zOss_PutSemaphore(g_FileCtrlSemID);
                break;
            }
            case EV_AUDIO_FILE_SEEK_INIT:
            {
                iResult = Audio_Seek_Msg(0);
                if(iResult != ZMF_RS_OK)
                {
                    g_ErrorCode = AUDIO_ERROR;
                }
                zOss_PutSemaphore(g_FileCtrlSemID);
                break;
            }
            case EV_AUDIO_FILE_SEEK_START:
            {
                iResult = Audio_Seek_Msg(g_AudioPlayParam.iStartOffset);
                if(iResult != ZMF_RS_OK)
                {
                    g_ErrorCode = AUDIO_ERROR;
                }
                zOss_PutSemaphore(g_FileCtrlSemID);
                break;
            }
            case EV_AUDIO_FILE_STOP:
            {
                Audio_ReleseDataList();
                bQuit = TRUE;
                break;
            }
            
            default:
            {
                break;
            }
        }

        /* ͷϢID */
        uiMsgId = 0;
        if (bQuit)
        {
            break;
        }
    }
}

/**
 * ƣ Audio_FileReadThreadEntry 
 *  ߳ں
 * ˵ IN: arg
 *   ֵ 
 * ˵ 
 */
static VOID Audio_FileReadThreadEntry(SINT32 arg)
{
    SINT32 iResult = 0;
    UINT32 uiMsg   = 0;

    /* ȽƵʼ */    
    /* ƵԤ */
    iResult = zMspCom_DecPreProcess(MSP_MODULE_AUDIO, (const char*)g_AudioPlayParam.filepath, &g_AudioFileParam);
    if (iResult != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        g_ErrorCode = AUDIO_ERROR;
        zOss_PutSemaphore(g_FileCtrlSemID);
        return;
    }
    
    g_pAudioDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if(g_pAudioDataList == NULL)
    {
        zMspCom_Print();
        /* رýļ */
        zMspCom_DecPostProcess(g_AudioFileParam.u32FileID);
        g_ErrorCode = AUDIO_ERROR;
        zOss_PutSemaphore(g_FileCtrlSemID);
        return;
    }
    
    zOss_ListInit(g_pAudioDataList);
    
    zOss_PutSemaphore(g_FileCtrlSemID);
    
    Audio_FileReadThreadLoop();

    if(g_pAudioDataList != NULL)
    {
        zOss_Free(g_pAudioDataList);
    }
    
    /* رýļ */
    zMspCom_DecPostProcess(g_AudioFileParam.u32FileID);
    //ȡϢеʣϢTOS߳˳ʱʣϢ
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsg, ZOSS_NO_WAIT))
    {
        uiMsg = 0;
    }
    zOss_PutSemaphore(g_FileCtrlSemID);
    return;
}

#endif


