/**************************************************************************************************
*
*                       Copyright(c) 2012 ZTE Corporation 
*
***************************************************************************************************
* 汾: ͨѶɷ޹˾ ֻҵ 
* ģ  : OSٹUE
*   :
* ļʶ:
* ļ:
* ʵֹ:
*     :
*     :
* :
* ˵:
***************************************************************************************************/

/**************************************************************************************************
* ޸ļ¼:
*     :
*   :
*   :
*     :
***************************************************************************************************/
#ifdef _USE_MONITOR

/**************************************************************************************************
* include
***************************************************************************************************/
#include "sup_agent_uemessage.h"
#include "sup_agent.h"
#include "sup_agent_osinfopack.h"
#include "sup_agent_status.h"
#include "sup_agent_toolkit.h"
#ifdef _USE_WINCOMM_SERVER
#include "commgt_api.h"
#endif

/**************************************************************************************************
* 
***************************************************************************************************/
#define HEADER_LEN (1)

/**************************************************************************************************
* ݽṹ
***************************************************************************************************/
typedef VOID (*UeMessageCallBack)(PBYTE buf, UINT32 len);

typedef struct
{
    UINT32 length;
    UINT8* buffer;
}T_BufferInfo;

typedef VOID(*ConstructWindow)(VOID);

typedef struct 
{
    T_BufferInfo heap;
    T_BufferInfo pool;
    T_BufferInfo cpuLoad;
    T_BufferInfo cpuFrequency;
    T_BufferInfo version;
    UeMessageCallBack send;

}T_UeMessage;

/**************************************************************************************************
* static
***************************************************************************************************/
static T_UeMessage s_ueMessage;

static VOID ConstructTwoMessageWindow(int windowId, T_BufferInfo* info1, T_BufferInfo* info2);
static VOID ConstructThreeMessageWindow(int windowId, T_BufferInfo* info1, T_BufferInfo* info2, T_BufferInfo* info3);

static VOID SendReplyMessage(UINT32 msgId, ConstructWindow func);

static T_BufferInfo* GetHeap(VOID);
static T_BufferInfo* GetPool(VOID);
static T_BufferInfo* GetCpuLoad(VOID);
static T_BufferInfo* GetCpuFrequency(VOID);
static T_BufferInfo* GetUeVersion(VOID);

static VOID ConstructMemWindowInfo(VOID);
static VOID ConstructCpuWindowInfo(VOID);


//thread window
static OsAgt_Status ReceiveThreadInfo(UINT32 msgId, T_ZOss_Mon_Thread* message);

//event window
static OsAgt_Status ReceiveEventInfo(UINT32 msgId, T_ZOss_Mon_Event* message);

//timer window
static OsAgt_Status ReceiveTimerInfo(UINT32 msgId, T_ZOss_Mon_Timer* message);

//task window
static OsAgt_Status ReceiveTaskInfo(UINT32 msgId, T_ZOss_Mon_Task* message);

//Ram log window
static OsAgt_Status ReceiveRamLog(UINT32 msgId, T_ZOss_Mon_Ramlog* message);

//pool alloc window
static OsAgt_Status ReceivePoolAllocInfo(UINT32 msgId, T_ZOss_Mon_Pool_Alloc* message);

//mmu window
static OsAgt_Status ReceiveMmuInfo(UINT32 msgId, T_ZOss_Mon_Mmu* message);

//message window 
static OsAgt_Status ReceiveMsgInfo(UINT32 msgId, T_ZOss_Mon_Msg* message);

//Pool Leak window
static OsAgt_Status ReceivePoolLeakInfo(UINT32 msgId, T_ZOss_Mon_Pool_Leak* message);

//Variable window
static OsAgt_Status ReceiveVariable(UINT32 msgId, T_ZOss_Mon_Get_Var_Ack* message);

//Mem window 
static OsAgt_Status ReceiveHeap(T_ZOss_Mon_Heap* message);
static OsAgt_Status ReceivePool(T_ZOss_Mon_Pool* message);
static VOID SendMemWindowInfo(UINT32 msgId);

//cpu window
static OsAgt_Status ReceiveVersion(UINT32 msgId, T_ZOss_Mon_Version* message);
static OsAgt_Status ReceiveCpuLoad(T_ZOss_Mon_Cpu_Load* message);
static OsAgt_Status ReceiveCpuFrequency(T_ZOss_Mon_Cpu_Frequency* message);
static VOID SendCpuWindowInfo(UINT32 msgId);


/**************************************************************************************************
* ʵ
***************************************************************************************************/
static T_BufferInfo* GetHeap(VOID)
{
    return &(s_ueMessage.heap);
}

static T_BufferInfo* GetPool(VOID)
{
    return &(s_ueMessage.pool);
}

static T_BufferInfo* GetCpuLoad(VOID)
{
    return &(s_ueMessage.cpuLoad);
}

static T_BufferInfo* GetCpuFrequency(VOID)
{
    return &(s_ueMessage.cpuFrequency);
}

static T_BufferInfo* GetUeVersion(VOID)
{
    return  &(s_ueMessage.version);
}

static VOID ConstructTwoMessageWindow(int windowId, T_BufferInfo* info1, T_BufferInfo* info2)
{
    UINT8* temp = NULL;
    T_BufferInfo window = {0};
    window.length =info1->length + info2->length + HEADER_LEN;
    #ifdef _USE_WINCOMM_SERVER
    window.buffer = zOss_Malloc(window.length);
    #else
    window.buffer = zOss_Malloc(window.length);
    #endif
    if(window.buffer != NULL)
    {
        temp = window.buffer;
        *temp = (UINT8)windowId; 

        temp += HEADER_LEN; 
        zOss_Memcpy(temp, info1->buffer, info1->length);

        temp += info1->length; 
        zOss_Memcpy(temp, info2->buffer, info2->length);
    }

    s_ueMessage.send((BYTE*)window.buffer, (WORD)window.length);

    zOss_Free(info1->buffer);
    zOss_Free(info2->buffer);
    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(window.buffer);
    #endif
}

static VOID ConstructThreeMessageWindow(int windowId, T_BufferInfo* info1, T_BufferInfo* info2, T_BufferInfo* info3)
{
    UINT8* temp = NULL;
    T_BufferInfo window = {0};
    window.length =info1->length + info2->length + info3->length + HEADER_LEN;
    #ifdef _USE_WINCOMM_SERVER
    window.buffer = zOss_Malloc(window.length);
    #else
    window.buffer = zOss_Malloc(window.length);
    #endif
    if(window.buffer != NULL)
    {
        temp = window.buffer;
        *temp = (UINT8)windowId; 

        temp += HEADER_LEN; 
        zOss_Memcpy(temp, info1->buffer, info1->length);

        temp += info1->length; 
        zOss_Memcpy(temp, info2->buffer, info2->length);

        temp += info2->length;
        zOss_Memcpy(temp, info3->buffer, info3->length);
    }

    s_ueMessage.send((BYTE*)window.buffer, (WORD)window.length);

    zOss_Free(info1->buffer);
    zOss_Free(info2->buffer);
    zOss_Free(info3->buffer);
    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(window.buffer);
    #endif
}

static VOID SendReplyMessage(UINT32 msgId, ConstructWindow func)
{
    if(zOss_MonitorAgt_CheckReplyMessage(msgId) == OsAgt_Status_Ok)
    {
        func();
    }
}

static VOID ConstructMemWindowInfo(VOID)
{
    ConstructTwoMessageWindow(AGT_PC_WINDOW_INFO_MEM, GetHeap(), GetPool());
}

static VOID ConstructCpuWindowInfo(VOID)
{
    ConstructThreeMessageWindow(AGT_PC_WINDOW_INFO_CPU, GetCpuLoad(), GetCpuFrequency(), GetUeVersion());
}

//version
static OsAgt_Status ReceiveVersion(UINT32 msgId, T_ZOss_Mon_Version* message)
{
    T_BufferInfo* bufferInfo = &(s_ueMessage.version);

    if(message == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo->length = sizeof(T_Version);
    bufferInfo->buffer = zOss_Malloc(bufferInfo->length);

    if(bufferInfo->buffer != NULL)
    {
        zOss_MonitorAgt_PackVersion(bufferInfo->buffer, message);
    }

    return OsAgt_Status_Ok;
}


//thread
static OsAgt_Status ReceiveThreadInfo(UINT32 msgId, T_ZOss_Mon_Thread* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Thread_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_THREAD;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackThreadEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//event
static OsAgt_Status ReceiveEventInfo(UINT32 msgId, T_ZOss_Mon_Event* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Event_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_EVENT;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackEventEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//timer
static OsAgt_Status ReceiveTimerInfo(UINT32 msgId, T_ZOss_Mon_Timer* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Timer_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_TIMER;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackTimerEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER    
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//task
static OsAgt_Status ReceiveTaskInfo(UINT32 msgId, T_ZOss_Mon_Task* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Task_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_TASK;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackTaskEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}


//Ram log
static OsAgt_Status ReceiveRamLog(UINT32 msgId, T_ZOss_Mon_Ramlog* message)
{
    T_BufferInfo bufferInfo = {0};

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->ramlog == NULL || message->size == 0)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(message->size + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_RAMLOG;
        zOss_Memcpy(bufferInfo.buffer + HEADER_LEN, message->ramlog, message->size);
    }
        
    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//pool alloc
static OsAgt_Status ReceivePoolAllocInfo(UINT32 msgId, T_ZOss_Mon_Pool_Alloc* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Pool_Alloc_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_POOL;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackPoolAllocEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//mmu
static OsAgt_Status ReceiveMmuInfo(UINT32 msgId, T_ZOss_Mon_Mmu* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Mmu_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_MMU;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackMmuEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//message 
static OsAgt_Status ReceiveMsgInfo(UINT32 msgId, T_ZOss_Mon_Msg* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Msg_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_MSG;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackMsgEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}

//Pool Leak
static OsAgt_Status ReceivePoolLeakInfo(UINT32 msgId, T_ZOss_Mon_Pool_Leak* message)
{
    T_BufferInfo bufferInfo = {0};
    UINT8* temp = NULL;
    UINT32 index = 0;
    UINT32 length = sizeof(T_Pool_Leak_Ele); 

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(length * message->num + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_POOLLEAK;
        temp = bufferInfo.buffer + HEADER_LEN; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackPoolLeakEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}


//Variable
static OsAgt_Status ReceiveVariable(UINT32 msgId, T_ZOss_Mon_Get_Var_Ack* message)
{
    T_BufferInfo bufferInfo = {0};

    if (zOss_MonitorAgt_CheckReplyMessage(msgId) != OsAgt_Status_Ok)
    {
        return OsAgt_Status_Error;
    }

    if(message == NULL || message->value == NULL || message->size == 0)
    {
        return OsAgt_Status_Error;
    }

    bufferInfo.length = (UINT32)(message->size + HEADER_LEN);
    #ifdef _USE_WINCOMM_SERVER
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #else
    bufferInfo.buffer = zOss_Malloc(bufferInfo.length);
    #endif

    if(bufferInfo.buffer != NULL)
    {
        *(bufferInfo.buffer) = AGT_PC_WINDOW_INFO_VARIABLE;
        zOss_Memcpy(bufferInfo.buffer + HEADER_LEN, message->value, message->size);
    }

    s_ueMessage.send(bufferInfo.buffer, bufferInfo.length);

    #ifndef _USE_WINCOMM_SERVER
    zOss_Free(bufferInfo.buffer);
    #endif

    return OsAgt_Status_Ok;
}


//Mem 
static OsAgt_Status ReceiveHeap(T_ZOss_Mon_Heap* message)
{
    T_BufferInfo* heap = &(s_ueMessage.heap);

    if(message == NULL)
    {
        return OsAgt_Status_Error;
    }

    heap->length = sizeof(T_Heap);
    heap->buffer = zOss_Malloc(heap->length);
    if(heap->buffer != NULL)
    {
        zOss_MonitorAgt_PackHeap(heap->buffer, message);
    }

    return OsAgt_Status_Ok;
}

static OsAgt_Status ReceivePool(T_ZOss_Mon_Pool* message)
{
    BYTE* temp = NULL;
    unsigned int index = 0;
    UINT32 length = sizeof(T_Pool_Ele); 
    T_BufferInfo* pool = &(s_ueMessage.pool);
    
    if(message == NULL || message->num == 0 || message->ele == NULL)
    {
        return OsAgt_Status_Error;
    }

    pool->length = (UINT32)(message->num*length); 
    pool->buffer = zOss_Malloc(pool->length); 
    if(pool->buffer != NULL)
    {
        temp = pool->buffer; 
        for(index = 0; index < message->num; index++)
        {
            zOss_MonitorAgt_PackPoolEle(temp, &(message->ele[index]));
            temp += length;
        }
    }

    return OsAgt_Status_Ok;
}



static VOID SendMemWindowInfo(UINT32 msgId)
{
    SendReplyMessage(msgId, ConstructMemWindowInfo);
}

//cpu
static OsAgt_Status ReceiveCpuLoad(T_ZOss_Mon_Cpu_Load* message)
{
    T_BufferInfo* cpuLoad = &(s_ueMessage.cpuLoad);

    if(message == NULL)
    {
        return OsAgt_Status_Error;
    }

    cpuLoad->length = sizeof(T_CpuLoad);
    cpuLoad->buffer = zOss_Malloc(cpuLoad->length);
    if(cpuLoad->buffer != NULL)
    {
        zOss_MonitorAgt_PackCpuLoad(cpuLoad->buffer, message);
    }

    return OsAgt_Status_Ok;
}

static OsAgt_Status ReceiveCpuFrequency(T_ZOss_Mon_Cpu_Frequency* message)
{
    T_BufferInfo* cpuFrequency = &(s_ueMessage.cpuFrequency);

    if(message == NULL)
    {
        return OsAgt_Status_Error;
    }

    cpuFrequency->length = sizeof(T_Frequency);
    cpuFrequency->buffer = zOss_Malloc(cpuFrequency->length);
    if(cpuFrequency->buffer != NULL)
    {
        zOss_MonitorAgt_PackFrequency(cpuFrequency->buffer, message);
    }

    return OsAgt_Status_Ok;
}


static VOID SendCpuWindowInfo(UINT32 msgId)
{
    SendReplyMessage(msgId, ConstructCpuWindowInfo);
}


VOID zOss_MonitorAgt_InitUeMessage()
{
    zOss_Memset(&s_ueMessage, 0, sizeof(s_ueMessage));
    s_ueMessage.send = zOss_MonitorAgt_SendDataToPcTool;
}


VOID zOss_MonitorAgt_UeMessageHandler(UINT32 msgId, UINT8 *buf)
{
    OsAgt_Status status = OsAgt_Status_Ok;

    switch(msgId)
    {
        case OSS_MON_VERSION:
            if((status = ReceiveVersion(msgId, (T_ZOss_Mon_Version*)buf)) == OsAgt_Status_Ok)
            {
                SendCpuWindowInfo(msgId);
            }
            break;

        case OSS_MON_THREAD:
            ReceiveThreadInfo(msgId, (T_ZOss_Mon_Thread*)buf);
            break;

        case OSS_MON_EVENT:
            ReceiveEventInfo(msgId, (T_ZOss_Mon_Event*)buf);
            break;

        case OSS_MON_TIMER:
            ReceiveTimerInfo(msgId, (T_ZOss_Mon_Timer*)buf);
            break;

        case OSS_MON_TASK:
            ReceiveTaskInfo(msgId, (T_ZOss_Mon_Task*)buf);
            break;

        case OSS_MON_RAMLOG:
            ReceiveRamLog(msgId, (T_ZOss_Mon_Ramlog*)buf);
            break;

        case OSS_MON_POOL_ALLOC:
            ReceivePoolAllocInfo(msgId, (T_ZOss_Mon_Pool_Alloc*)buf);
            break;

        case OSS_MON_MMU:
            ReceiveMmuInfo(msgId, (T_ZOss_Mon_Mmu*)buf);
            break;

        case OSS_MON_MSG:
            ReceiveMsgInfo(msgId, (T_ZOss_Mon_Msg*)buf);
            break;

        case OSS_MON_POOL_LEAK:
            ReceivePoolLeakInfo(msgId, (T_ZOss_Mon_Pool_Leak*)buf);
            break;

        case OSS_MON_GET_VAR_ACK:
            ReceiveVariable(msgId, (T_ZOss_Mon_Get_Var_Ack*)buf);
            break;

        case OSS_MON_HEAP:
            {
                if((status = ReceiveHeap((T_ZOss_Mon_Heap*)buf)) == OsAgt_Status_Ok)
                {
                    SendMemWindowInfo(msgId);
                }
            }
            break;

        case OSS_MON_POOL:
            {
                if((status = ReceivePool((T_ZOss_Mon_Pool*)buf)) == OsAgt_Status_Ok)
                {
                    SendMemWindowInfo(msgId);
                }
            }
            break;

        case OSS_MON_CPU_LOAD:
            {
                if((status = ReceiveCpuLoad((T_ZOss_Mon_Cpu_Load*)buf)) == OsAgt_Status_Ok)
                {
                    SendCpuWindowInfo(msgId);
                }
            }
            break;

        case OSS_MON_CPU_FREQUENCY:
            {
                if((status = ReceiveCpuFrequency((T_ZOss_Mon_Cpu_Frequency*)buf)) == OsAgt_Status_Ok)
                {
                    SendCpuWindowInfo(msgId);
                }
            }
            break;

        default:
            break;
    }

    if(status == OsAgt_Status_Error)
    {
        zOss_MonitorAgt_CheckReplyMessage(msgId);
    }

    return;
}

#endif


