/*******************************************************************************
* Ȩ (C)2008,ͨѶɷ޹˾
* ϵͳ	: MediaFileHandlerModule
* ļ	: ZMF_API.h
* ժҪ	: APIӿ
* ǰ汾	: 
*     	: ｡
* 	: 200894
* ޸ļ¼	: 
*     		    		޸ 		޸ժҪ
*******************************************************************************/
/**************************** ѡͷļ ****************************/
#ifndef __ZMF_API_H__ 
#define __ZMF_API_H__ 

#include "ZMF_OutDef.h"
#include <stdio.h>

/********************************** ͺ **********************************/
#ifdef __cplusplus
extern "C" {
#endif

#if defined (WIN32) || defined(_WIN32_WCE)
	#ifdef ZMF_EXPORTS
		#define ZMF_API __declspec(dllexport)
	#else
		#define ZMF_API __declspec(dllimport)
	#endif
#else
	#define ZMF_API
#endif

/**********************************  **********************************/

// صӿں  οP96Aƽ̨֧ӿ˵.doc

// ڴص
typedef ZMF_API void* (*ZMF_Callback_Malloc)( UInt32 size);
typedef ZMF_API void  (*ZMF_Callback_Free)( void *mem_ptr);
typedef ZMF_API void  (*ZMF_Callback_Memcpy)( void *dest_ptr, const void *src_ptr, UInt32 size);
typedef ZMF_API void  (*ZMF_Callback_Memset)( void *dest_ptr, SInt32 value, UInt32 size);

// ڴزص
typedef ZMF_API void*  (*ZMF_Callback_GetUB)( UInt32 size);
typedef ZMF_API UInt32 (*ZMF_Callback_RetUB)( void * msg_ptr);

// ļص
typedef ZMF_API UInt32	(*ZMF_Callback_FCreate) (const char *filename);
typedef ZMF_API FILE*	(*ZMF_Callback_FOpen) (const char * filename, const char * mode);
typedef ZMF_API UInt32	(*ZMF_Callback_FSeek) (FILE *stream, SInt32 offset, SInt32 whence);
typedef ZMF_API SSize_T (*ZMF_Callback_FRead) (void *data, SSize_T size, SSize_T count, FILE *stream);
typedef ZMF_API SSize_T (*ZMF_Callback_FWrite) (const void *data, SSize_T size, SSize_T count, FILE *stream);
typedef ZMF_API UInt32	(*ZMF_Callback_FEof) (FILE *stream);
typedef ZMF_API UInt32	(*ZMF_Callback_FTell) (FILE *stream);
typedef ZMF_API UInt32	(*ZMF_Callback_FClose) (FILE *stream);
typedef ZMF_API UInt32  (*ZMF_Callback_FRename) (const char *old_filename, const char *new_filename);
typedef ZMF_API UInt32  (*ZMF_Callback_FDelete) (const char * filename);
typedef ZMF_API UInt32  (*ZMF_Callback_FLength) (FILE *stream);
typedef ZMF_API Bool16	(*ZMF_Callback_FExist) (const char *filename);

typedef ZMF_API UInt32  (*ZMF_Callback_FModTime)(const char *inPath);			// ļ޸ʱ
typedef ZMF_API UInt32  (*ZMF_Callback_FMod)(const char *inPath);               	// ļģʽ
// ص
typedef ZMF_API ZOSS_MUTEX_ID (*ZMF_Callback_CreateMutex)(const char *name_ptr,UInt32 priority_inherit);
typedef ZMF_API UInt32 (*ZMF_Callback_GetMutex)(ZOSS_MUTEX_ID mutex_id,UInt32 wait_option);
typedef ZMF_API UInt32 (*ZMF_Callback_PutMutex)(ZOSS_MUTEX_ID mutex_id);
typedef ZMF_API UInt32 (*ZMF_Callback_DeleteMutex)(ZOSS_MUTEX_ID mutex_id);

// صṹ壬ɵ߳ʼ
typedef struct 
{
	ZMF_Callback_Malloc pMalloc;
	ZMF_Callback_Free	pFree;
	ZMF_Callback_Memcpy pMemcpy;
	ZMF_Callback_Memset pMemset;

	ZMF_Callback_GetUB	pGetUB;
	ZMF_Callback_RetUB	pRetUB; 

	ZMF_Callback_FCreate pFCreate;
	ZMF_Callback_FOpen	pFOpen;
	ZMF_Callback_FSeek	pFSeek;
	ZMF_Callback_FRead	pFRead;
	ZMF_Callback_FWrite	pFWrite;
	ZMF_Callback_FEof	pFEof;
	ZMF_Callback_FTell	pFTell;
	ZMF_Callback_FClose	pFClose;
	ZMF_Callback_FRename pFRename;	
	ZMF_Callback_FDelete pFDelete;	
	ZMF_Callback_FLength pFLength;
	ZMF_Callback_FExist	 pFExist;	

	ZMF_Callback_FModTime  pFModTime;
	ZMF_Callback_FMod	pFMod;

	ZMF_Callback_CreateMutex	pCreateMutex;
	ZMF_Callback_GetMutex		pGetMutex;
	ZMF_Callback_PutMutex		pPutMutex;
	ZMF_Callback_DeleteMutex	pDeleteMutex;
    
    LogOutCallBackFunc	pLogOut;

}T_ZMF_Callbacks, *T_ZMF_CallbacksPtr;


/*******************************************************************************
* 	: CreateIndexCallBackFunc
* 	: ̻߳صӦⲿжϺ
* Ρ	: SInt32 o_s32ParsedSecond	ɴýݵʱλs
* Ρ	: Bool8* o_b8QuitFlag		ӦóãǷҪ˳
*   ֵ	: typedefEZMFResultCode 
* 	:  
* 	: 20091110
* ޸		   ޸		  ޸
*******************************************************************************/
typedef EZMFResultCode (*CreateIndexCallBackFunc)(SInt32 o_s32ParsedSecond, Bool8* o_b8QuitFlag);

/**********************************  **********************************/


// ؽӿں	
/*******************************************************************************
* 	: InitModule
* 	: ʼģ飬ûصȣǱģ鱻õĵһ
* Ρ	: Bool16 i_bUseCallback		Ƿûصְ汾Ϊ true
* Ρ	: T_ZMF_CallbacksPtr i_pCallbacks صṹ
*   ֵ	: ZMF_APIvoid 
* 	: ｡
* 	: 20081112
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode InitModule(Bool16 i_bUseCallback, T_ZMF_CallbacksPtr i_pCallbacks);


/*******************************************************************************
* 	: GetModuleVer
* 	: ȡģ汾Ϣ
*   ֵ	: SInt8* 
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API const char* MFileGetVersionInfo();

/*******************************************************************************
* 	: OpenMediaFileHandler 
* 	: һýļشIDΪԺļID
* Ρ	: const char * i_pFilePath        ļ·
* Ρ	: EZMFOpenFlag i_eOpenFlag		  ģʽ
* Ρ	: UInt32 *o_pFileID               صļID
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode OpenMediaFileHandler(const char* i_pFilePath , EZMFOpenFlag i_eOpenFlag,  UInt32* o_pFileID);


/*******************************************************************************
* 	: CloseMediaFileHandler
* 	: رһͷļصԴ
* Ρ	: UInt32 i_u32FileID
*   ֵ	: EZMFResultCode 
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode CloseMediaFileHandler(UInt32 i_u32FileID);


/*******************************************************************************
* 	: ResetMediaFileHandler
* 	: һرԭļļǱļID
* Ρ	: UInt32 i_u32FileID
* Ρ	: const char * i_pFilePath	´ļľ·
* Ρ	: EZMFOpenFlag i_eOpenFlag	´ļĲģʽ
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode ResetMediaFileHandler(UInt32 i_u32FileID, const char * i_pFilePath, EZMFOpenFlag i_eOpenFlag);


// ļʶӿں
/*******************************************************************************
* 	: ParseFileType
* 	: ʶļͣļϢ
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFFileInfo *o_pFileInfo	صļϢ
*   ֵ	: ZMF_APIEZMFResultCode 
* 	: ｡
* 	: 200898
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode ParseFileType(UInt32 i_u32FileID, T_ZMFFileInfo **o_pFileInfo);


/*******************************************************************************
* 	: GetFileInfo
* 	: ļϢ
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFFileInfo *o_pFileInfo	صļϢ
*   ֵ	: EZMFResultCode 
* 	: ｡
* 	: 2008912
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode GetFileInfo(UInt32 i_u32FileID, T_ZMFFileInfo **o_pFileInfo);


// ļȡӿں
/*******************************************************************************
* 	: Initialize
* 	: ʼļļϢ
* Ρ	: UInt32 i_u32FileID
* Ρ	: Bool16 i_bCreateInnerIndex	ǷʼʱڻȡAACAMRMP3Ƶļ
			  ȫϢ粥ʱʵֶλšѡʼʱʼʱ
			  ϳѡʼʱfalse޷ȡȫϢͶλţҪͨ
*   ֵ	: EZMFResultCode 
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode Initialize(UInt32 i_u32FileID, Bool16 i_bCreateInnerIndex);


/*******************************************************************************
* 	: CreateExIndex
* 	: ɵͨⲿ
* Ρ	: UInt32 i_u32FileID
* Ρ	: UInt32 i_u32IndexItem ûҪ
* Ρ	: void** o_pIndex bufferĵַָ
			  CreateIndexCallBackFunc i_pCallBack УӦⲿϢĻصָ
												  粻Ҫÿ
*   ֵ	: EZMFResultCode 
* 	:  
* 	: 2009119
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode CreateExIndex(UInt32 i_u32FileID, UInt32 i_u32IndexItem, void** o_pIndex, CreateIndexCallBackFunc i_pCallBack);


/*******************************************************************************
* 	: SetExIndex
* 	: ͨɵйرͨļ
* Ρ	: UInt32 i_u32FileID
* Ρ	: void* o_pIndex   bufferָ
*   ֵ	: ZMF_APIEZMFResultCode 
* 	:  
* 	: 2009119
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode SetExIndex(UInt32 i_u32FileID, void* i_pIndex);

/*******************************************************************************
* 	: DeleteExIndex
* 	: Ƚ
* 	: 2009127
* 	: 
* Ρ	: UInt32 i_u32FileID
* Ρ	: void* i_pIndex  bufferָ
*   ֵ	: ZMF_API void 
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode DeleteExIndex(UInt32 i_u32FileID, void* i_pIndex);


/*******************************************************************************
* 	: SetTrackActive
* 	: Ĳ״̬(ļAVIMP43GPãļɲ)
* Ρ	: UInt32 i_u32FileID
* Ρ	: UInt32 i_u32TrackID	ָID
* Ρ	: Bool16 i_bActive		TRUEָFLASEָ
*   ֵ	: ZMF_APIEZMFResultCode 
* 	:  
* 	: 2010127
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode SetTrackActive(UInt32 i_u32FileID, UInt32 i_u32TrackID, Bool16 i_bActive);


/*******************************************************************************
* 	: Seek 
* 	: ʱ䶨λļĲλ
* Ρ	: UInt32 i_u32FileID	
* Ρ	: UInt32 i_u32Time		λΪ S
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode Seek(UInt32 i_u32FileID, UInt32 i_u32Time);


/*******************************************************************************
* 	: GetNextFrame
* 	: ʱ˳ȡһ(뵥Ԫ)
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFOutPutUnit** io_pOUtUnit صݽṹ
*   ֵ	: EZMFResultCode 
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode GetNextFrame(UInt32 i_u32FileID, T_ZMFOutPutUnit** o_pOUtUnit);


/*******************************************************************************
* 	: GetNextKeyFrame 
* 	: ȡƵһؼ
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFOutPutUnit** io_pOUtUnit
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode GetNextKeyFrame(UInt32 i_u32FileID, T_ZMFOutPutUnit** o_pOUtUnit);


/*******************************************************************************
* 	: GetPreKeyFrame 
* 	: ȡƵһؼ
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFOutPutUnit** io_pOUtUnit
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode GetPreKeyFrame(UInt32 i_u32FileID, T_ZMFOutPutUnit** o_pOUtUnit);


// ļɽӿں

/*******************************************************************************
* 	: Create 
* 	: ļ
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFFileInfo *i_tFileInfo    //ļĲϢ
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode Create(UInt32 i_u32FileID, T_ZMFFileInfo *i_tFileInfo);


/*******************************************************************************
* 	: WriteNextFrame 
* 	: ˳дһ
* Ρ	: UInt32 i_u32FileID
* Ρ	: UInt32 i_u32TrackID
* Ρ	: T_ZMFOutPutUnit* i_pINTUnit
*   ֵ	: EZMFResultCode
* 	: ｡
* 	: 200894
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode WriteNextFrame(UInt32 i_u32FileID,T_ZMFOutPutUnit* i_pInUnit);


/*******************************************************************************
* 	: GetCurFileLen
* 	: ȡļǰȣصǰļbit
* Ρ	: UInt32 i_u32FileID
* Ρ	: UInt32* o_pFileLen
*   ֵ	: ZMF_APIEZMFResultCode 
* 	:  ѩ
* 	: 2009413
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode GetCurFileLen(UInt32 i_u32FileID, UInt32* o_pFileLen);


/*******************************************************************************
* 	: WriteOver
* 	: дļ̽ļر
* Ρ	: UInt32 i_u32FileID
*   ֵ	: ZMF_APIEZMFResultCode 
* 	: 
* 	: 20081229
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode WriteOver(UInt32 i_u32FileID);


/*******************************************************************************
* 	: ReleaseUnitData
* 	: ͷŽ뵥ԪԴ
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFOutPutUnit* i_pOUtUnit
*   ֵ	: ZMF_APIvoid 
* 	: ｡
* 	: 2008917
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API void ReleaseUnitData(UInt32 i_u32FileID, T_ZMFOutPutUnit* i_pOUtUnit);


/*******************************************************************************
* 	: SetFileBlockSize
* 	: ÿζȡļĿС
* Ρ	: UInt32 i_u32BlockSizeÿζȡļĿС, λkЧֵΧ1-1024
*   ֵ	: ZMF_APIEZMFResultCode 
* 	: 
* 	: 2009119
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode SetFileBlockSize(UInt32 i_u32BlockSize);


/*******************************************************************************
* 	: SetWriteBufSize
* 	: дС
* Ρ	: UInt32 i_u32WriteBufSize, дС, λֽ, ЧΧ1 ~ 10 * 1024 * 1024
*   ֵ	: ZMF_APIEZMFResultCode 
* 	: 
* 	: 2011215
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode SetWriteBufSize(UInt32 i_u32WriteBufSize);


/*******************************************************************************
* 	: SetUserConfigInfo
* 	: Ƚ
* 	: 20091217
* 	: û
* Ρ	: UInt32 i_u32FileID
* Ρ	: T_ZMFUserConfigInfo* i_pConfigInfo ûĽṹָ
*   ֵ	: ZMF_API EZMFResultCode 
* ޸		   ޸		  ޸
*******************************************************************************/
ZMF_API EZMFResultCode SetUserConfigInfo(UInt32 i_u32FileID, T_ZMFUserConfigInfo* i_pConfigInfo);


#ifdef __cplusplus
}
#endif



#endif 
