/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_kernel.c
* ļ : 
* ʵֹ : TOSϵͳṩĽӿڽзװṩͳһĲϵͳӿ
*      : 
*      : V1.0
*  : 2011/02/15
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : 
*    : V1.1
* ޸ : 2012/03/02
* ޸ : ̴߳ɾ롢г֧Ų㹳Ӻ
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "sup.h"
#include "tos_typedef.h"

#ifdef _USE_PSM
#include "drvs_pow.h"
#include "drvs_pwr.h"
#endif
#include "drvs_l2cache.h"
#include "tos_link_info.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* ⲿ                                  
**************************************************************************/

/**************************************************************************
* ⲿ                                  
**************************************************************************/
extern VOID Osa_SysErrHndInit(VOID);
extern void tos_cache_clean_all(void);

#ifdef _USE_PSM
extern SINT32  Hal_GetArmCoreFreq(UINT32*feq);
#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifdef _USE_THREAD
#ifdef CYGIMP_HAL_COMMON_INTERRUPTS_USE_INTERRUPT_STACK
# define TOS_THREAD_STACK_IRQ_MIN_SIZE (512)
#else
# define TOS_THREAD_STACK_IRQ_MIN_SIZE  (2048)
#endif
#define TOS_THREAD_STACK_MIN_SIZE       (CYGNUM_HAL_STACK_SIZE_MINIMUM + TOS_THREAD_STACK_IRQ_MIN_SIZE)
#endif

#ifdef _USE_MESSAGE
# define THREAD_MSG_HEAD_SIZE           (sizeof(T_THREAD_MSG_HEAD))
# define THREAD_MSG_HEAD(buf)           ((T_THREAD_MSG_HEAD *)((UINT8 *)(buf) - THREAD_MSG_HEAD_SIZE))
# define THREAD_MSG_BUF(head)           ((VOID *)((UINT8 *)(head) + THREAD_MSG_HEAD_SIZE))
# define THREAD_MSG_SIZE(size)          ((size) + THREAD_MSG_HEAD_SIZE)
# define THREAD_MSG_MAGIC               0x3A3A3A3A
# define THREAD_MSG_HOOK_TYPE_MAX       ZOSS_SETHOOKFLAG_INTER
# define THREAD_MSG_HOOK_DIRE_MAX       ZOSS_MSGDIRE_INOUT
#endif
/**************************************************************************
* ݽṹ
**************************************************************************/
/* Thread state values */
enum {                          
    OSA_THREAD_RUNNING      = 0,    /* Thread is runnable or running                */
    OSA_THREAD_SLEEPING     = 1,    /* Thread is waiting for something to happen    */
    OSA_THREAD_COUNTSLEEP   = 2,    /* Sleep in counted manner                      */
    OSA_THREAD_SUSPENDED    = 4,    /* Suspend count is non-zero                    */
    OSA_THREAD_CREATING     = 8,    /* Thread is being created                      */
    OSA_THREAD_EXITED       = 16,   /* Thread has exited                            */
    /* This is the set of bits that must be cleared by a generic wake() or release(). */
    OSA_THREAD_SLEEPSET     = (OSA_THREAD_SLEEPING | OSA_THREAD_COUNTSLEEP)
};                                  

#ifdef _USE_MESSAGE 
typedef struct {
    SIGSELECT   sig_no; /* Աڽṹеλòܸı */
    UINT32      id;
    UINT32      buf_size;
    UINT32      magic;
} T_THREAD_MSG_HEAD;

typedef struct {
    T_ZOss_Node     Node;                           /* λòܸı             */
    ZOSS_THREAD_ID  thread_id;
    UINT8           dire[THREAD_MSG_HOOK_TYPE_MAX]; /* 0: ZOSS_SETHOOKFLAG_MONI=1   */
    THREAD_MSG_HOOK func[THREAD_MSG_HOOK_TYPE_MAX]; /* 0: ZOSS_SETHOOKFLAG_MONI=1   */
} THREAD_MSG_HOOK_CONTENT;
#endif
/**************************************************************************
* ֲԭ
**************************************************************************/
UINT32 Osa_HwTimeRead(VOID);
UINT32 Osa_DisplayThreadsExecInfo(UINT32 type);

#ifdef TOS_STATISTIC_TIMESLICE
static ZOSS_TIMER_ID zOss_GetStatisticTimesliceTimer(void);
static void zOss_SetStatisticTimesliceTimer(ZOSS_TIMER_ID timer_id);
static void zOss_StatisticTimesliceEnd(SINT32 param);
#endif

/**************************************************************************
* ȫֳ/
**************************************************************************/
static BOOL         gOsa_SwapFlag           = FALSE;    /* ߳hook־         */
static UINT32       gOsa_SwapLastTime       = 0;        /* һͳ߳лʱ */
static UINT32       gOsa_CpuStartTime       = 0;        /* ʼͳִ߳ʱ     */
static ZOSS_TASK_ID *gOsa_AllTaskIdArray    = NULL;     /* ͳ             */
#ifdef _USE_MESSAGE
static T_ZOss_List  s_thread_msg_hook_list  = {0};      /* ̹߳Ϣ         */
#endif

#ifdef _USE_MONITOR
static T_ZOss_Mon_Msg gOsa_MsgInfo = {0};
#endif

#ifdef TOS_STATISTIC_TIMESLICE
static ZOSS_TIMER_ID tos_statistic_timeslice_timer = NULL;
#endif

UINT32  gOsa_SysCpuFreq     = 0;        /* ӲƵ               */
BOOL    gOsa_SwapTimeFlag   = FALSE;    /* ߳л¼cpuʱ־      */

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* :     ֤߳ǷЧ
* ˵:     
*   ()  thread_id:֤߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     void
**************************************************************************/
static UINT32 zOss_IdVerify(ZOSS_THREAD_ID thread_id)
{
    zOss_AssertEx(thread_id != NULL, ZOSS_ERROR);
    
#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD_VALID
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == true)
    {
        return ZOSS_SUCCESS;
    }
#endif
    return ZOSS_ERROR;
}


/**************************************************************************
* :     ʼ̵߳ûռ
* ˵:     
*   ()  thread:     ʼûݿռ߳
                user_area:  ߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void zOss_InitThreadUserArea(cyg_handle_t thread, T_ZOsa_ThreadUserArea *user_area)
{
    zOss_AssertExN(thread != 0x00 && user_area != NULL);
    
    strcpy((char *)user_area->threadname, cyg_thread_get_name(thread));
    user_area->stacksize    = (UINT32)cyg_thread_get_stack_size_real(thread);
    user_area->topstack     = (UINT32)cyg_thread_get_stack_base_real(thread);
    user_area->topstack     += user_area->stacksize;
    user_area->heapsize     = 0xFFFFFFFF;
    user_area->threadid     = (ZOSS_THREAD_ID)thread;
    user_area->ubsize       = 0;
    user_area->ptrf         = 0;
    user_area->runcount     = 0;
    user_area->curtaskid    = 0;
    user_area->cpupercent   = 0;
    user_area->runtime      = 0;
    user_area->cputime      = 0;
    user_area->RunTimeInMs  = 0;
    user_area->sleepsem     = NULL;    
}


/**************************************************************************
* :     ߳ջռʹ
* ˵:     
*   ()  thread_id:  ̵߳id
*   ()  void
*   ֵ:     ߳ջռʹ
* ˵:     void
**************************************************************************/
static UINT8 zOss_GetThreadStackUsed( ZOSS_THREAD_ID thread_id)
{
    cyg_handle_t    thread_handle   = 0x00;
    cyg_uint32      stack_used      = 0x00;
    cyg_uint32      stack_size      = 0x00;

    zOss_ASSERT(thread_id != NULL);

    thread_handle   = (cyg_handle_t)thread_id;
#ifdef CYGFUN_KERNEL_THREADS_STACK_MEASUREMENT
    stack_used  = cyg_thread_measure_stack_usage(thread_handle);
#else
    stack_used  = 0x00;
#endif
    stack_size  = cyg_thread_get_stack_size_real(thread_handle);

    return (UINT8)((stack_used * 100) / stack_size);
}

/**************************************************************************
* :     ϵͳ̵߳CPUռ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void Osa_UpdateThreadCpu(void)
{
    cyg_handle_t            thread_handle   = 0x00;
    cyg_uint16              thread_id       = 0x00;
    T_ZOsa_ThreadUserArea   *user_area      = NULL;
    UINT32                  totaltime       = 0;

    /* ʱˢµִ߳,ʱĻȡĺ,λ΢,Ƚϸ */
    totaltime = Osa_HwTimeRead() - gOsa_CpuStartTime;
    
    while (cyg_thread_get_next(&thread_handle, &thread_id)) 
    {
        zOss_AssertExN(thread_handle != 0x00 && thread_id != 0x00);
        
        user_area = (T_ZOsa_ThreadUserArea *)cyg_thread_get_user_area(thread_handle);
        zOss_AssertExN(user_area != NULL);
        
        user_area->cpupercent = (FLOAT)(user_area->cputime) * 100 / totaltime;
        user_area->cputime = 0;
    }
}

/**************************************************************************
* :     ϵͳCPUռ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void Osa_UpdateTaskCpu(void)
{
    UINT32      cnt         = 0;
    UINT32      tcb_no      = 0;
    T_ZOss_TCB  *tcb        = NULL;
    UINT32      totaltime   = 0;

    totaltime = Osa_HwTimeRead() - gOsa_CpuStartTime;
    
    zOss_AssertExN(gOsa_AllTaskIdArray != NULL);

    tcb_no = zOss_GetAllTaskID(gOsa_AllTaskIdArray);
    for (cnt = 0x00; cnt < tcb_no; cnt++)
    {
        tcb = (T_ZOss_TCB *)gOsa_AllTaskIdArray[cnt];
        if (tcb->task_id != tcb)
        {    
            continue;
        }
        tcb->cpupercent = (FLOAT)(tcb->cputime) * 100 / totaltime;
        tcb->cputime = 0;
    }
}

#ifdef TOS_STATISTIC_TIMESLICE
/**************************************************************************
* :     ȡʱƬͳƶʱ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ʱƬͳƶʱ
* ˵:     void
**************************************************************************/
static ZOSS_TIMER_ID zOss_GetStatisticTimesliceTimer(void)
{
    return tos_statistic_timeslice_timer;
}

/**************************************************************************
* :     ʱƬͳƶʱ
* ˵:     
*   ()  timer_id:   ʱƬͳƶʱid
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void zOss_SetStatisticTimesliceTimer(ZOSS_TIMER_ID timer_id)
{
    ZOSS_INTR old_intr = 0;

    ZOSS_SAVE_IRQ(old_intr);
    tos_statistic_timeslice_timer = timer_id;
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* :     ʼͳָʱڵʱƬ
* ˵:     
*   ()  time_len:   ʱʱ䣬λ: ms
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void zOss_StatisticTimesliceStart(UINT32 time_len, UINT32 type)
{
    ZOSS_TIMER_ID timer_id = NULL;

    timer_id = zOss_GetStatisticTimesliceTimer();
    if(timer_id != NULL)
    {
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_ABNORMAL, "ͳִ߳Ժ");
        return;
    }
    
#ifdef CYGOPT_KERNEL_EXTEND_CLOCK_STATISTIC_TIMESLICE
    cyg_zero_statistic_counter_value();
#endif

#ifdef CYGOPT_KERNEL_EXTEND_THREAD_STATISTIC_TIMESLICE
    cyg_thread_zero_all_statistic_timeslice();
#endif

    timer_id = zOss_CreateTimer("tos_statistic_timeslice_timer",    /* name     */
                                zOss_StatisticTimesliceEnd,         /* callback */
                                (SINT32)type,                       /* param    */
                                FALSE);                             /* period   */
    zOss_SetStatisticTimesliceTimer(timer_id);
    zOss_StartTimer(timer_id, time_len, zOss_StatisticTimesliceEnd, (SINT32)type);
}

/**************************************************************************
* :     ͳָʱڵʱƬ
* ˵:     
*   ()  param:  ʱ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void zOss_StatisticTimesliceEnd(SINT32 param)
{
    ZOSS_TIMER_ID timer_id = NULL;

    timer_id = zOss_GetStatisticTimesliceTimer();
    zOss_KillTimer(timer_id);
    zOss_SetStatisticTimesliceTimer(NULL);

    Osa_DisplayThreadsExecInfo((UINT32)param);
}
#endif

/**************************************************************************
* :     ߳id߳ϢвƥĽڵ
* ˵:     
*   ()  thread_id:  ߳id
*   ()  void
*   ֵ:     ҳɹƥĽڵ㣬򷵻NULL
* ˵:     void
**************************************************************************/
#ifdef _USE_MESSAGE
static THREAD_MSG_HOOK_CONTENT* find_thread_content(ZOSS_THREAD_ID thread_id)
{
    THREAD_MSG_HOOK_CONTENT *msg_hook = (THREAD_MSG_HOOK_CONTENT *)zOss_ListFirst(&s_thread_msg_hook_list);

    while (msg_hook) 
    {
        if (msg_hook->thread_id == thread_id)
        {
            break;
        }
        
        msg_hook = (THREAD_MSG_HOOK_CONTENT *)zOss_ListNext((T_ZOss_Node *)msg_hook);
    }

    return msg_hook;
}
#endif

/**************************************************************************
* :     ȡϢӿڷϢ
* ˵:     
*   ()  msg_head:  ϢϢŵַ
*               thread_id: Ŀ̵߳߳id
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
#ifdef _USE_MESSAGE
static inline void zOss_GetSendMsgInfo(thread_msg_t *msg_head, ZOSS_THREAD_ID thread_id)
{
#if defined (OSS_TRACE_THREAD) && defined(_USE_MONITOR)
    if (gOsa_MonitorFlag)
    {
        ZOSS_INTR   old_intr    = 0;
        UINT32      cnt         = 0;
        
        ZOSS_SAVE_IRQ(old_intr);
        cnt = gOsa_MsgInfo.num;
        gOsa_MsgInfo.ele[cnt].msgId     = 0x00;
        gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)msg_head->msg_ptr;
        gOsa_MsgInfo.ele[cnt].size      = msg_head->msg_size;
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName(thread_id, NULL);
        gOsa_MsgInfo.ele[cnt].sender    = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
        gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
        if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
        {
            cnt = 0;
        }
        gOsa_MsgInfo.num = cnt;
        ZOSS_RESTORE_IRQ(old_intr);
    }
#endif 
}

/**************************************************************************
* :     ȡϢӿڽϢ
* ˵:     
*   ()  msg_head:  ϢϢŵַ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static inline void zOss_GetRecvMsgInfo(thread_msg_t *msg_head)
{
#ifdef _USE_MONITOR
    if (gOsa_MonitorFlag)
    {
        ZOSS_INTR   old_intr    = 0;
        UINT32      cnt         = 0;

        ZOSS_SAVE_IRQ(old_intr);
        cnt = gOsa_MsgInfo.num;
        gOsa_MsgInfo.ele[cnt].msgId     = 0x00;
        gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)msg_head->msg_ptr;
        gOsa_MsgInfo.ele[cnt].size      = msg_head->msg_size;
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
        gOsa_MsgInfo.ele[cnt].sender    = "unknown";
        gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
        if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
        {
            cnt = 0;
        }
        gOsa_MsgInfo.num = cnt;
        ZOSS_RESTORE_IRQ(old_intr);
    }
#endif
}

/**************************************************************************
* :     ȡ߳ϢӿڷϢ
* ˵:     
*   ()  msg_id:           Ϣid
*               thread_msg_head:  ϢϢŵַ
*               thread_id:        Ŀ̵߳߳id
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static inline void zOss_GetThreadSendMsgInfo(
                            UINT32 msg_id, 
                            T_THREAD_MSG_HEAD *thread_msg_head,
                            ZOSS_THREAD_ID thread_id)
{
#ifdef _USE_MONITOR
        if (gOsa_MonitorFlag)
        {
            ZOSS_INTR   old_intr    = 0;
            UINT32      cnt         = 0;

            ZOSS_SAVE_IRQ(old_intr);
            cnt = gOsa_MsgInfo.num;
            gOsa_MsgInfo.ele[cnt].msgId     = msg_id;
            gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)thread_msg_head;
            gOsa_MsgInfo.ele[cnt].size      = thread_msg_head->buf_size;
            gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName(thread_id, NULL);
            gOsa_MsgInfo.ele[cnt].sender    = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
            gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
            if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
            {
                cnt = 0;
            }
            gOsa_MsgInfo.num = cnt;
            ZOSS_RESTORE_IRQ(old_intr);
        }
#endif
}

/**************************************************************************
* :     ȡ߳ϢӿڽϢ
* ˵:     
*   ()  thread_msg_head:  ϢϢŵַ               
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static inline void zOss_GetThreadRecvMsgInfo(T_THREAD_MSG_HEAD *thread_msg_head)                       
{
#ifdef _USE_MONITOR
    if (gOsa_MonitorFlag)
    {
        ZOSS_INTR   old_intr    = 0;
        UINT32      cnt         = 0;

        ZOSS_SAVE_IRQ(old_intr);
        cnt = gOsa_MsgInfo.num; 
        gOsa_MsgInfo.ele[cnt].msgId     = thread_msg_head->id;
        gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)thread_msg_head;
        gOsa_MsgInfo.ele[cnt].size      = thread_msg_head->buf_size;
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
        gOsa_MsgInfo.ele[cnt].sender    = "unknown";
        gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
        if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
        {
            cnt = 0;
        }
        gOsa_MsgInfo.num = cnt;
        ZOSS_RESTORE_IRQ(old_intr);
    }
#endif
}
#endif

/**************************************************************************
* :     Osa_AddrInText
* ˵:     
*   ()  addr: ָĵַ
*   ()  void
*   ֵ:     void
* ˵:     жָĵַΧǷڴ
**************************************************************************/
static BOOL Osa_AddrInText(UINT32 addr)
{
    if((addr <= tos_text_vma_end() && addr >= tos_text_vma_start())
       || (addr < tos_itcm_vma_end() && addr>= tos_itcm_vma_start())) 
    {
        return TRUE;
    }
    return FALSE;
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/
#ifdef _USE_THREAD
/**************************************************************************
* :     ϵͳ̴߳
* ˵:     
*   ()  б
*   ()  б
*   ֵ:     Ѵ߳̾(߳̿ƿָ)
* ˵:     ̴߳ʧܣϵͳ
**************************************************************************/
ZOSS_THREAD_ID zOss_CreateThread(
                    const CHAR *thread_name,    /* name                 */
                    VOID (*entry)(SINT32),      /* entry                */
                    SINT32 arg,                 /* arguments pointer    */
                    UINT32 stack_size,          /* stack size           */
                    UINT32 priority,            /* priority             */
                    UINT32 preempt,             /* useless              */
                    UINT32 auto_start)          /* auto start           */
{
    cyg_handle_t thread_handle = 0x00;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  thread_name != NULL, 
                  NULL);
    zOss_AssertEx(strlen((char *)thread_name) <= CYGOPT_KERNEL_EXTEND_THREAD_NAME, NULL);
    zOss_AssertEx(entry != NULL && priority <= OSA_LOWESTPRIORITY, NULL);

    stack_size += TOS_THREAD_STACK_IRQ_MIN_SIZE;
    cyg_thread_create(priority,                       /* scheduling info (eg pri) */
                      (cyg_thread_entry_t  *)entry,   /* entry point function     */
                      (cyg_addrword_t)arg,            /* entry data               */
                      (char*)thread_name,             /* optional thread name     */
                      NULL,                           /* stack base, NULL = alloc */
                      stack_size,                     /* stack size, 0 = default  */
                      &thread_handle,                 /* returned thread handle   */
                      NULL);                          /* put thread here          */
    preempt = preempt;

    if (auto_start)
    {
        cyg_thread_resume(thread_handle);
    }

    return (ZOSS_THREAD_ID)thread_handle;
}

/**************************************************************************
* :     ϵͳ߳˳
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID zOss_ExitThread(VOID)
{
    zOss_AssertExN(tos_get_isr_nesting_level() == 0x00 && tos_get_dsr_nesting_level() == 0x00);
    cyg_thread_exit();
}

/**************************************************************************
* :     ϵͳ̹߳
* ˵:     
*   ()  thread_id:  豻߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ̵߳ҹ
**************************************************************************/
UINT32 zOss_SuspendThread(ZOSS_THREAD_ID thread_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  thread_id != NULL, 
                  ZOSS_ERROR);

#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif

    cyg_thread_suspend((cyg_handle_t)thread_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ϵͳָ̻߳
* ˵:     
*   ()  thread_id:  豻ָ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ֻʹ̬߳̽иȼִ߳лھ̬
                ߳ȴ.
**************************************************************************/
UINT32 zOss_ResumeThread(ZOSS_THREAD_ID thread_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  thread_id != NULL, 
                  ZOSS_ERROR);

#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif

    cyg_thread_resume((cyg_handle_t)thread_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ϵͳ߳˯ߺ
* ˵:     
*   ()  time_in_ms:     ߳̽Ҫ˯ߵʱ䣬λ: ms
*   ()  void
*   ֵ:     void
* ˵:     ϵͳʱӵƵδ֤ӳʱ䲻׼ȷ
**************************************************************************/
VOID zOss_Sleep(UINT32 time_in_ms)
{
    zOss_AssertExN(tos_get_isr_nesting_level() == 0x00 && tos_get_dsr_nesting_level() == 0x00);
    cyg_thread_delay((cyg_tick_count_t)time_in_ms);
}

/**************************************************************************
* :     ϵͳ߳ɾ
* ˵:     
*   ()  thread_id:  ɾ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     zOss_CreateThread߳ջռ߳̿ƿṹռ
                Cyg_Thread::exitͷţΪcyg_thread_deleteִ
                дű̵߳Чˡ
**************************************************************************/
UINT32 zOss_DeleteThread(ZOSS_THREAD_ID thread_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  thread_id != NULL, 
                  ZOSS_ERROR);

#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif

    cyg_thread_delete((cyg_handle_t)thread_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ϵͳĻȡǰ߳idĺ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰ̵ִ߳߳id
* ˵:     void
**************************************************************************/
ZOSS_THREAD_ID zOss_GetCurThreadID(VOID)
{
    return (ZOSS_THREAD_ID)cyg_thread_self();
}

/**************************************************************************
* :     ݲṩ߳ƣҸ̵߳߳id
* ˵:     
*   ()  thread_name:    ߳
*   ()  void
*   ֵ:     ҳɹ̵߳Ч߳idϵͳ
* ˵:     void
**************************************************************************/
ZOSS_THREAD_ID zOss_GetThreadIDByName (const CHAR *thread_name)
{
    zOss_AssertEx(thread_name != NULL, NULL);

    return (ZOSS_THREAD_ID)cyg_thread_find_by_name(thread_name);
}

/**************************************************************************
* :     ݲṩ߳idȡ̵߳߳
* ˵:     
*   ()  thread_id:      ȡ߳Ƶ߳id
*   ()  thread_name:    ߳ƴŵַ
*   ֵ:     ɹָ߳룻ϵͳԻ򷵻ؿָ
* ˵:     thread_nameǿգʾҪϵͳṩ߳ƿ
                ڴַ追ֻ践ָ߳
**************************************************************************/
CHAR *zOss_GetThreadName(ZOSS_THREAD_ID thread_id, CHAR *thread_name)
{
    char *name = NULL;

    zOss_AssertEx(thread_id != NULL, NULL);

#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return NULL;
    }
#endif

    name = cyg_thread_get_name((cyg_handle_t)thread_id);
    if (thread_name)
    {
        strcpy((char *)thread_name, name);
    }

    return (CHAR *)name;
}

/**************************************************************************
* :     ݲṩ߳idȡ̵߳߳Ϣ
* ˵:     
*   ()  thread_id:  ȡ߳Ϣ߳id
*   ()  б
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_GetThreadInfo(ZOSS_THREAD_ID thread_id,   /* id       */
                          CHAR *thread_name,          /*      */
                          UINT32 *stat,               /* ״̬     */
                          UINT32 *priority,           /* ȼ   */
                          UINT32 *preempt)            /* ռ   */
{
    cyg_thread_info info;
    cyg_handle_t    thread_handle   = 0x00;
    cyg_uint16      id              = 0x00;
    cyg_bool        ret             = false;

    zOss_AssertEx(thread_id != NULL, ZOSS_ERROR);

#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif

    thread_handle   = (cyg_handle_t)thread_id;
    id              = cyg_thread_get_id(thread_handle);
    ret             = cyg_thread_get_info( thread_handle, id, &info);
    
    zOss_AssertEx(ret == (cyg_bool)true, ZOSS_ERROR);

    if (thread_name)
    {
        strcpy(thread_name, info.name);
    }
    
    if (stat)
    {   
        *stat = info.state;
    }
    
    if (priority)
    {
        *priority = info.cur_pri;
    }
    
    if (preempt)
    {
        *preempt = 1;
    }
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ȡǰ̵߳Ϣ(ģ)
* ˵:     
*   ()  void              
*   ()  pMonThreadInfo: ߳Ϣŵַ
*   ֵ:     void
* ˵:     ˺ڴռ䣬ʹͷţڴй¶
**************************************************************************/
VOID z0ss_GetAllThreadInfo(T_ZOss_Mon_Thread *pMonThreadInfo)
{
#ifdef _USE_MONITOR
    T_ZOss_Mon_Thread    threadInfo     = {0};
    ZOSS_THREAD_ID      *thread_array   = NULL;
    UINT32              cnt             = 0;

    if (pMonThreadInfo == NULL)
    {
        return;
    }

    threadInfo.num = Osa_GetAllThreadId(&thread_array);
    if (threadInfo.num == 0 || threadInfo.num == ZOSS_ERROR || thread_array == NULL)
    {
        return;
    }

    threadInfo.ele = (T_ZOss_Mon_Thread_Ele *)zOss_GetUB(threadInfo.num * sizeof(T_ZOss_Mon_Thread_Ele));
    zOss_AssertExN(threadInfo.ele != NULL);
    for (cnt = 0; cnt < threadInfo.num; cnt++)
    {
        T_ZOsa_ThreadUserArea   *user_area      = NULL;
        cyg_handle_t            threadId        = 0;
        cyg_uint32              stackSize       = 0;
        cyg_addrword_t          stackBase       = 0;
        cyg_addrword_t          stackPtr        = 0;
#ifdef CYGFUN_KERNEL_THREADS_STACK_MEASUREMENT
        cyg_uint32              stackMaxUsed    = 0;
#endif

        user_area = Osa_GetThreadUserArea(thread_array[cnt], TRUE);
        if (user_area == NULL)
        {        
            continue;
        }

        threadId                        = (cyg_handle_t)user_area->threadid;
        threadInfo.ele[cnt].name        = user_area->threadname;
        threadInfo.ele[cnt].handle      = (UINT32)threadId;
        threadInfo.ele[cnt].msg_num     = user_area->msgnum;
        threadInfo.ele[cnt].status      = user_area->runstatus;
        threadInfo.ele[cnt].priority    = user_area->priority;
        
        stackSize   = cyg_thread_get_stack_size_real(threadId);
        stackBase   = cyg_thread_get_stack_base_real(threadId);
        stackPtr    = cyg_thread_get_stack_ptr(threadId);
        
        threadInfo.ele[cnt].stack_used      = (unsigned short)(((stackBase + stackSize - stackPtr) * 
                                              OSS_MON_PERCENT_RADIO / stackSize) * OSS_MON_PERCENT_RADIO);      
#ifdef CYGFUN_KERNEL_THREADS_STACK_MEASUREMENT
        stackMaxUsed                        = cyg_thread_measure_stack_usage(threadId);   
        threadInfo.ele[cnt].stack_max_used  = (unsigned short)((stackMaxUsed * OSS_MON_PERCENT_RADIO /
                                              stackSize) * OSS_MON_PERCENT_RADIO);
#else
        threadInfo.ele[cnt].stack_max_used  = 0;
#endif
        threadInfo.ele[cnt].cpu_load        = (unsigned short)(Osa_GetProcessCPU((ZOSS_THREAD_ID)threadId) * 
                                              OSS_MON_PERCENT_RADIO);
    }

    zOss_Free(thread_array);
    thread_array        = NULL;

    pMonThreadInfo->num = threadInfo.num;
    pMonThreadInfo->ele = threadInfo.ele;
#endif   
}

/**************************************************************************
* :     ݲṩ߳idø̵߳߳ȼ
* ˵:     
*   ()  thread_id:  ȼ߳id
                priority:   ߳̽õȼ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_SetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 priority)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  thread_id != NULL && 
                  priority <= OSA_LOWESTPRIORITY, 
                  ZOSS_ERROR);
    
#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif

    cyg_thread_set_priority((cyg_handle_t)thread_id, (cyg_priority_t)priority);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ݲṩ߳idȡ̵߳߳ȼ
* ˵:     
*   ()  thread_id:  ȡȼ߳id
*   ()  priority:   ȡ߳ȼŵַ
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_GetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 *priority)
{
    zOss_AssertEx(thread_id != NULL && priority != NULL, ZOSS_ERROR);

#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif

    *priority = (UINT32)cyg_thread_get_priority((cyg_handle_t)thread_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ȡ߳ûݿռָ
* ˵:     
*   ()  thread_id:  ȡûݿռָ߳id
*   ()  void
*   ֵ:     ̵߳ûݿռָ
* ˵:     void
**************************************************************************/
T_ZOsa_ThreadUserArea *zOss_GetThreadUserArea(ZOSS_THREAD_ID thread_id)
{
    cyg_handle_t            thread_handle   = 0x00;
    T_ZOsa_ThreadUserArea   *user_area      = NULL;

    zOss_AssertEx(thread_id != NULL, NULL);
    thread_handle   = (cyg_handle_t)thread_id;
    user_area       = (T_ZOsa_ThreadUserArea *)cyg_thread_get_user_area(thread_handle);
    zOss_AssertEx(user_area != NULL, NULL);

    return user_area;
}

/**************************************************************************
* :     ֤һ߳ǷЧ
* ˵:     
*   ()  thread_id:  ֤߳id
*   ()  void
*   ֵ:     ߳ЧZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    return zOss_IdVerify(threadID);
}

#endif

#ifdef _USE_MESSAGE
/**************************************************************************
* :     ̷ָ߳Ϣ
* ˵:     
*   ()  thread_id:  Ŀ̵߳߳id
                msg_ptr:    Ϣݵָ
                size:       ϢĴСЧ
                time_out:   Ϣĳʱʱ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
**************************************************************************/
UINT32 zOss_SendMsg(ZOSS_THREAD_ID thread_id, VOID *msg_ptr, UINT32 size, UINT32 timeout)
{
    cyg_handle_t    mbox        = 0x00;
    cyg_bool        ret         = false;
    thread_msg_t    *threadMsg  = NULL;
    
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00, ZOSS_ERROR);

    if (thread_id == NULL || msg_ptr == NULL)
    {
        return ZOSS_ERROR;
    }
    
#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
    
#endif

    threadMsg = (thread_msg_t *)palloc(sizeof(thread_msg_t));
    if (threadMsg == NULL)
    {
        return ZOSS_ERROR;
    }
    threadMsg->msg_ptr     = msg_ptr;
    threadMsg->msg_size    = size;
    mbox = cyg_thread_get_mbox((cyg_handle_t)thread_id);
    zOss_AssertEx(mbox != 0x00, ZOSS_ERROR);

    if (timeout == ZOSS_WAIT_FOREVER)
    {
        ret = cyg_mbox_put(mbox, (void *)threadMsg);
    }
    else if (timeout == ZOSS_NO_WAIT) 
    {
        ret = cyg_mbox_tryput(mbox, (void *)threadMsg);
    }
    else 
    {
        cyg_tick_count_t abs_timeout;
        
        abs_timeout = (cyg_tick_count_t)timeout;
        abs_timeout += cyg_current_time();
        ret         = cyg_mbox_timed_put(mbox, (void *)threadMsg, abs_timeout);
    }

    if (ret)
    {
        zOss_GetSendMsgInfo(threadMsg, thread_id);
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* :     Ϣ
* ˵:     
*   ()  time_out:   Ϣĳʱʱ
*   ()  msg_ptr:    ϢָĴŵַ
                size:       ϢݴСĴŵַЧ
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
**************************************************************************/
UINT32 zOss_RecvMsg(VOID **msg_ptr, UINT32 *size, UINT32  timeout)
{
    cyg_handle_t mbox           = 0x00;
    thread_msg_t *threadMsg    = NULL;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  msg_ptr != NULL, 
                  ZOSS_ERROR);

    mbox = cyg_thread_get_mbox(cyg_thread_self());
    zOss_AssertEx(mbox != 0x00, ZOSS_ERROR);

    if (timeout == ZOSS_WAIT_FOREVER)
    {
        threadMsg = (thread_msg_t *)cyg_mbox_get(mbox);
    }
    else if (timeout == ZOSS_NO_WAIT) 
    {
        threadMsg = (thread_msg_t *)cyg_mbox_tryget(mbox);
    } 
    else 
    {
        cyg_tick_count_t abs_timeout;
        
        abs_timeout = (cyg_tick_count_t)timeout;
        abs_timeout += cyg_current_time();
        threadMsg  = (thread_msg_t *)cyg_mbox_timed_get(mbox, abs_timeout);
    }

    if (threadMsg == NULL)
    {  
        return ZOSS_ERROR;
    }
    
    zOss_GetRecvMsgInfo(threadMsg);

    *msg_ptr    = threadMsg->msg_ptr;
    *size       = threadMsg->msg_size;
    pfree((void *)threadMsg);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ȡϢշϢ(ģ)
* ˵:     
*   ()  void              
*   ()  pMonMsgInfo: ȡϢϢĴŵַ
*   ֵ:     void
* ˵:     
**************************************************************************/
VOID z0ss_GetMsgInfo(T_ZOss_Mon_Msg *pMonMsgInfo)
{
#ifdef _USE_MONITOR
    if (pMonMsgInfo)
    {
        *pMonMsgInfo = gOsa_MsgInfo;
    }
#endif
}

/**************************************************************************
* :     ڴϢͷ+ػָ
* ˵:     
*   ()  size:   С
*   ()  void
*   ֵ:     ָ
* ˵:     zOss_ThreadRetMsgBufʵ
**************************************************************************/
VOID* zOss_ThreadGetMsgBuf(UINT32 size)
{
    T_THREAD_MSG_HEAD *msg_head = NULL;

    zOss_AssertEx(size != 0, NULL);
    
    msg_head = (T_THREAD_MSG_HEAD *)palloc(THREAD_MSG_SIZE(size));
    
    zOss_AssertEx(msg_head != NULL, NULL);

    msg_head->sig_no    = SIGNAL_MSG_NUMBER;
    msg_head->magic     = THREAD_MSG_MAGIC;

    return THREAD_MSG_BUF(msg_head);
}

/**************************************************************************
* :     ڴطϢͷ+
* ˵:     
*   ()  p_buf:  ָ
*   ()  void
*   ֵ:     void
* ˵:     zOss_ThreadGetMsgBufʵ
**************************************************************************/
VOID zOss_ThreadRetMsgBuf(VOID *p_buf)
{
    zOss_AssertExN(p_buf != NULL);

    pfree(THREAD_MSG_HEAD(p_buf));
}

/**************************************************************************
* :     thread_id̷߳Ϣ
* ˵:     
*   ()  msg_id:     Ϣid
                p_buf:      ָ
                buf_size:   С
                thread_id:  Ŀ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     zOss_ThreadRecvMsgʵ
**************************************************************************/
UINT32 zOss_ThreadSendMsg(UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id)
{
    cyg_bool            ret         = false;
    cyg_handle_t        mbox        = 0x00;
    T_THREAD_MSG_HEAD   *msg_head   = NULL;
    
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00, ZOSS_ERROR);

    if ((p_buf == NULL && buf_size != 0x00) || (p_buf != NULL && buf_size == 0x00)) 
    {
        return ZOSS_ERROR;
    }
    zOss_AssertEx(thread_id != NULL, ZOSS_ERROR);
    
#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif
    
    if (p_buf == NULL) 
    {
        msg_head = (T_THREAD_MSG_HEAD *)palloc(THREAD_MSG_SIZE(0));
        zOss_AssertEx(msg_head != NULL, ZOSS_ERROR);
        
        msg_head->sig_no = SIGNAL_MSG_NUMBER;
        msg_head->magic = THREAD_MSG_MAGIC;
    } 
    else 
    {
        msg_head = THREAD_MSG_HEAD(p_buf);
        zOss_AssertEx(msg_head->magic == THREAD_MSG_MAGIC, ZOSS_ERROR);
    }
    msg_head->id = msg_id;
    msg_head->buf_size = buf_size;
    
    mbox = cyg_thread_get_mbox((cyg_handle_t)thread_id);
    zOss_AssertEx(mbox != 0x00, ZOSS_ERROR);
    
    ret = cyg_mbox_put(mbox, (void *)msg_head);
    if (ret)
    {
        zOss_GetThreadSendMsgInfo(msg_id, msg_head, thread_id);
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;    
    }
}

/**************************************************************************
* :     ߳̽Ϣ
* ˵:     
*   ()  timeout:    Ϣĳʱʱ
*   ()  p_msg_id:   ϢidĴŵַ
                p_buf:      ϢָĴŵַ
                p_buf_size: ϢСĴŵַ
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     zOss_ThreadSendMsgʵ
**************************************************************************/
UINT32 zOss_ThreadRecvMsg(UINT32 *p_msg_id, VOID **p_buf, UINT32 *p_buf_size, UINT32 timeout)
{
    cyg_handle_t        mbox        = 0x00;
    T_THREAD_MSG_HEAD   *msg_head   = NULL;
    
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 &&
                  tos_get_dsr_nesting_level() == 0x00, 
                  ZOSS_ERROR);
    
    zOss_AssertEx(p_msg_id != NULL && p_buf != NULL && p_buf_size != NULL, ZOSS_ERROR);
    
    mbox = cyg_thread_get_mbox(cyg_thread_self());
    zOss_AssertEx(mbox != 0x00, ZOSS_ERROR);
    
    if (timeout == ZOSS_WAIT_FOREVER)
    {
        msg_head = (T_THREAD_MSG_HEAD *)cyg_mbox_get(mbox);
    }
    else if (timeout == ZOSS_NO_WAIT) 
    {
        msg_head = (T_THREAD_MSG_HEAD *)cyg_mbox_tryget(mbox);
    } 
    else 
    {
        cyg_tick_count_t abs_timeout;
        
        abs_timeout = (cyg_tick_count_t)timeout;
        abs_timeout += cyg_current_time();
        msg_head = (T_THREAD_MSG_HEAD *)cyg_mbox_timed_get(mbox, abs_timeout);
    }
    
    if (msg_head == NULL)
    {
        return ZOSS_ERROR;
    }
    
    zOss_AssertEx(msg_head->magic == THREAD_MSG_MAGIC, ZOSS_ERROR);

    zOss_GetThreadRecvMsgInfo(msg_head);                    

    *p_msg_id = msg_head->id;
    *p_buf_size = msg_head->buf_size;
    if (msg_head->buf_size == 0x00) 
    {
        pfree(msg_head);
        *p_buf = NULL;
    } 
    else
    {
        *p_buf = THREAD_MSG_BUF(msg_head);
    }
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ע߳ϢӺ
* ˵:     
*   ()  thread_id:  ߳id
                type:       Ӻ
                dire:       Ӻ
                func:       Ӻָ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     void
**************************************************************************/
UINT32 zOss_RegThreadMsgHook(ZOSS_THREAD_ID thread_id, UINT8 type, UINT8 dire, THREAD_MSG_HOOK func)
{
    THREAD_MSG_HOOK_CONTENT *msg_hook = NULL;

    zOss_AssertEx(type <= THREAD_MSG_HOOK_TYPE_MAX && dire <= THREAD_MSG_HOOK_DIRE_MAX && func != NULL, ZOSS_ERROR);
    
#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
    if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
    {
        return ZOSS_ERROR;
    }
#endif
    
    msg_hook = find_thread_content(thread_id);
    if (msg_hook == NULL)
    {
        msg_hook = (THREAD_MSG_HOOK_CONTENT *)zOss_Malloc(sizeof(THREAD_MSG_HOOK_CONTENT));
        zOss_AssertEx(msg_hook != NULL, ZOSS_ERROR);
        
        zOss_Memset(msg_hook, 0x00, sizeof(THREAD_MSG_HOOK_CONTENT));
        msg_hook->thread_id = thread_id;
        zOss_ListAdd(&s_thread_msg_hook_list, &msg_hook->Node);
    }
    msg_hook->dire[type - 1] = dire;
    msg_hook->func[type - 1] = func;
    
    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_SEMAPHORE
/**************************************************************************
* :     ź
* ˵:     
*   ()  name_ptr:       źƣЧ
                initial_count:  źĳʼֵ
*   ()  void
*   ֵ:     ɹźľϵͳ
* ˵:     void
**************************************************************************/
ZOSS_SEMAPHORE_ID zOss_CreateSemaphore(const CHAR *name_ptr, UINT32 initial_count)
{
    cyg_sem_t *sem = NULL;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 &&
                  tos_get_dsr_nesting_level() == 0x00, 
                  NULL);

    if (name_ptr)
    {  
        name_ptr = name_ptr;
    }

    sem = (cyg_sem_t *)zOss_Malloc(sizeof(cyg_sem_t));
    zOss_AssertEx(sem != NULL, NULL);

    cyg_semaphore_init(sem, (cyg_count32)initial_count);

    return (ZOSS_SEMAPHORE_ID)sem;
}

/**************************************************************************
* :     ȡź
* ˵:     
*   ()  sem_id:     ڻȡźid
                timeout:    ʱ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
**************************************************************************/
UINT32 zOss_GetSemaphore(ZOSS_SEMAPHORE_ID sem_id, UINT32 timeout)
{
    cyg_sem_t   *sem    = NULL;
    cyg_bool    ret     = false;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  sem_id != NULL, 
                  ZOSS_ERROR);

    sem = (cyg_sem_t *)sem_id;
    if (timeout == ZOSS_WAIT_FOREVER)
    {
        ret = cyg_semaphore_wait(sem);
    }
    else if (timeout == ZOSS_NO_WAIT)
    {
        ret = cyg_semaphore_trywait(sem);
    }
    else
    {
        ret = cyg_semaphore_timed_wait(sem, (cyg_tick_count_t )timeout + cyg_current_time());
    }

    if (ret)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* :     ͷź
* ˵:     
*   ()  sem_id:     ͷŵźid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_PutSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && sem_id != NULL, ZOSS_ERROR);

    cyg_semaphore_post((cyg_sem_t *)sem_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ȡźĵǰֵ
* ˵:     
*   ()  sem_id:     ڱȡֵźid
*   ()  void
*   ֵ:     źĵǰֵ
* ˵:     void
**************************************************************************/
UINT32 zOss_GetSemaphoreCount(ZOSS_SEMAPHORE_ID sem_id)
{
    cyg_count32 cnt     = 0x00;

    zOss_AssertEx(sem_id != NULL, ZOSS_ERROR);

    cyg_semaphore_peek((cyg_sem_t *)sem_id, &cnt);

    return (UINT32)cnt;
}

/**************************************************************************
* :     ɾź
* ˵:     
*   ()  sem_id:     ɾźid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ҪͷzOss_CreateSemaphoreڴռ䣬ᵼ
                й¶
**************************************************************************/
UINT32 zOss_DeleteSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  sem_id != NULL, 
                  ZOSS_ERROR);

    cyg_semaphore_destroy((cyg_sem_t *)sem_id);
    zOss_Free((void *)sem_id);

    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_MUTEX
/**************************************************************************
* :     
* ˵:     
*   ()  name_ptr:   
                priority_inherit:   ԣZOSS_INHERIT֮߳䰴
                ȼ˳ȡ壻ZOSS_NO_INHERIT򰴵ȴ˳ȡ
                
*   ()  void
*   ֵ:     ɹشĻϵͳ
* ˵:     void
**************************************************************************/
ZOSS_MUTEX_ID zOss_CreateMutex(const CHAR *name_ptr, UINT32 priority_inherit)
{
    cyg_mutex_t *mutex = NULL;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 &&
                  tos_get_dsr_nesting_level() == 0x00, 
                  NULL);

    if (name_ptr)
    {
        name_ptr = name_ptr;
    }

    mutex = (cyg_mutex_t *)zOss_Malloc(sizeof(cyg_mutex_t));
    zOss_AssertEx(mutex != NULL, NULL);

    cyg_mutex_init(mutex);
    if (priority_inherit == ZOSS_INHERIT)
    {
        cyg_mutex_set_protocol(mutex, (enum cyg_mutex_protocol)CYG_MUTEX_PROTOCOL_INHERIT);
    }
    else
    {
        cyg_mutex_set_protocol(mutex, (enum cyg_mutex_protocol)CYG_MUTEX_PROTOCOL_NONE);
    }

    return (ZOSS_MUTEX_ID)mutex;
}

/**************************************************************************
* :     ȡ
* ˵:     
*   ()  mutex_id:   ȡĻid
                timeout:    ȡĳʱʱ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     void
**************************************************************************/
UINT32 zOss_GetMutex( ZOSS_MUTEX_ID mutex_id,  UINT32 timeout)
{
    cyg_mutex_t *mutex  = NULL;
    cyg_bool    ret     = false;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  mutex_id != NULL, 
                  ZOSS_ERROR);

    mutex = (cyg_mutex_t *)mutex_id;
    if (timeout == ZOSS_WAIT_FOREVER)
    {
        ret = cyg_mutex_lock(mutex);
    }
    else if (timeout == ZOSS_NO_WAIT)
    { 
        ret = cyg_mutex_trylock(mutex);
    }
    else 
    {
        ret = cyg_mutex_timed_lock(mutex, cyg_current_time() + (cyg_tick_count_t )timeout);
    }

    if (ret)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* :     ͷŻ
* ˵:     
*   ()  mutex_id:   ͷŵĻid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_PutMutex(ZOSS_MUTEX_ID mutex_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  mutex_id != NULL, 
                  ZOSS_ERROR);

    cyg_mutex_unlock((cyg_mutex_t *)mutex_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ٻ
* ˵:     
*   ()  mutex_id:   ٵĻid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ҪͷzOss_CreateMutexڴռ䣬ᵼڴ
                й¶
**************************************************************************/
UINT32 zOss_DeleteMutex(ZOSS_MUTEX_ID mutex_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  mutex_id != NULL, 
                  ZOSS_ERROR);

    cyg_mutex_destroy((cyg_mutex_t *)mutex_id);
    zOss_Free((void *)mutex_id);

    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_EVENT
/**************************************************************************
* :      ¼־
* ˵:     
*   ()  name:   ¼־ƣЧ               
*   ()  void
*   ֵ:     ɹش ¼־ϵͳ
* ˵:     void
**************************************************************************/
ZOSS_EVENT_ID zOss_CreateEvent(const CHAR *name_ptr)
{
    cyg_flag_t *event = NULL;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 &&
                  tos_get_dsr_nesting_level() == 0x00, 
                  NULL);

    zOss_AssertEx(ZOSS_EVENTS_OR == CYG_FLAG_WAITMODE_OR && 
                  ZOSS_EVENTS_AND == CYG_FLAG_WAITMODE_AND &&
                  ZOSS_EVENTS_OR_CLEAR == CYG_FLAG_WAITMODE_CLR, 
                  NULL);

    if (name_ptr)
    {
        name_ptr = name_ptr;
    }
    event = (cyg_flag_t *)zOss_Malloc(sizeof(cyg_flag_t));
    zOss_AssertEx(event != NULL, NULL);

    cyg_flag_init(event);

    return (ZOSS_EVENT_ID)event;
}

/**************************************************************************
* : zOss_GetEvent
* : ȡ¼
* ˵: (IN)
                event_id:¼id
                events:32λ¼
                get_options:λȡ¼
                    ZOSS_EVENTS_AND:ʾeventsָ¼ǶҪ
                    ZOSS_EVENTS_OR:ʾeventsָ¼ֻҪκһ
                                   ϼ
                    ZOSS_EVENTS_AND_CLEAR:ʾZOSS_EVENTS_ANDʽȡ,
                                          ¼Ϊ0
                    ZOSS_EVENTS_OR_CLEAR:ʾZOSS_EVENTS_ORʽȡ,
                                         ¼Ϊ0
                pEventsReceived:Żȡ¼־ָ,Ϊ
                timeout:ʱ.ZOSS_WAIT_FOREVER, ZOSS_NO_WAIT,ʱ
                        λ
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_GetEvent(ZOSS_EVENT_ID event_id, UINT32  events, UINT32 getOptions,
                     UINT32 *pEventsReceived, UINT32 timeout)
{
    cyg_flag_t *event = NULL;
    UINT32     result = 0;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && tos_get_dsr_nesting_level() == 0x00, ZOSS_ERROR);
    zOss_AssertEx(event_id != NULL && pEventsReceived != NULL && events != 0, ZOSS_ERROR);

    event = (cyg_flag_t *)event_id;
    if (timeout == ZOSS_WAIT_FOREVER)
    {
        result = cyg_flag_wait(event,events,getOptions);
    }
    else if (timeout == ZOSS_NO_WAIT)
    {
        result = cyg_flag_poll(event,events,getOptions);
    }
    else
    {
        cyg_tick_count_t abs_timeout;
        
        abs_timeout = (cyg_tick_count_t )timeout + cyg_current_time();
        result      = cyg_flag_timed_wait(event,events,getOptions, abs_timeout);
    }

    if(result)
    {
        *pEventsReceived = result;
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
       
}

/**************************************************************************
* : zOss_SetEvent
* : ¼¼־λ뵱ǰ¼λ
* ˵: (IN)
                 eventId:¼id
                 events:32-bit unsigned variable that represents the 
                        requested event flags.
                 setOptions:ø¼
                            ZOSS_EVENTS_AND: eventsʹã32λ
                                             㹦ܡʱeventsΪ0
                            ZOSS_EVENTS_OR eventsͬǰֵл㡣
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_SetEvent(ZOSS_EVENT_ID event_id, UINT32  events, UINT32 setOptions)
{
    cyg_flag_t *event = NULL;

    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && event_id != NULL, ZOSS_ERROR);

    event = (cyg_flag_t *)event_id;
  
    if(setOptions == ZOSS_EVENTS_AND)
    {
        if(events == 0)
        {
            cyg_flag_maskbits(event,events);
            return ZOSS_SUCCESS;
        }
        else
        {
            return ZOSS_ERROR;
        }
    }

    cyg_flag_setbits(event,events);

    return ZOSS_SUCCESS; 
}

/**************************************************************************
* : zOss_DeleteEvent
* : ɾ¼
* ˵: (IN)
                event_id:¼id
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_DeleteEvent(ZOSS_EVENT_ID event_id)
{
    zOss_AssertEx(tos_get_isr_nesting_level() == 0x00 && 
                  tos_get_dsr_nesting_level() == 0x00 &&
                  event_id != NULL, 
                  ZOSS_ERROR);

    cyg_flag_destroy((cyg_flag_t *)event_id);
    zOss_Free((void *)event_id);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_QueryEvent
* :ѯ¼鵱ǰ־ֵ
* ˵: (IN)	
                event_id:¼id
*   ֵ: ¼鵱ǰ־ֵ
* ˵:  
**************************************************************************/ 
UINT32 zOss_QueryEvent(ZOSS_EVENT_ID event_id)
{
    zOss_AssertEx(event_id != NULL, ZOSS_ERROR); 
    
    return cyg_flag_peek((cyg_flag_t *)event_id);
}

/**************************************************************************
* : zOss_WaitingEvent
* :ѯǷ̵߳ȴ¼
* ˵: (IN)
                event_id:¼id
*   ֵ: ̵߳ȴ:True ;̵߳ȴ:False
* ˵:  
**************************************************************************/ 
BOOL zOss_WaitingEvent(ZOSS_EVENT_ID event_id)
{
    zOss_ASSERT(event_id != NULL);

    return cyg_flag_waiting((cyg_flag_t *)event_id);
}
#endif

/**************************************************************************
* :     ȡϵͳĵǰδ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ϵͳĵǰδ
* ˵:     void
**************************************************************************/
UINT32 zOss_GetTickCount(VOID)
{
#ifdef _USE_PSM
# ifdef _USE_PSM_NEW_FRAMEWORK
    return (UINT32)(cyg_current_time_lo());
# else
    return (UINT32)(cyg_current_time_lo() + zOss_GetSleepTimeForTicks());
# endif
#else
    return (UINT32) cyg_current_time_lo();
#endif
}

/**************************************************************************
* :     OSEϵͳе̴߳TOSֻڴжϷ
* ˵:     
*   ()  беע
*   ()  void
*   ֵ:     жϴ̵ľ
* ˵:     Ŀǰģʹô˽ӿڣҪ˺OSEϵͳ
                ֲ
                1) ˺ֻڴжϷ̣
                2) ˺жеã
                3) ʧܣϵͳԣ
                4) Ƽģеô˺ӿڣ
**************************************************************************/
PROCESS create_process(enum PROCESS_TYPE        proc_type,      /* ֻ߳ͣΪOS_INT_PROC  */
                       const char               *name,          /* Դ˲                   */
                       OSENTRYPOINT             *entrypoint,    /* ߳ڵ                   */
                       OSADDRESS                stack_size,     /* Դ˲                   */
                       OSPRIORITY               priority,       /* Դ˲                   */
                       OSTIME                   timeslice,      /* Դ˲                   */
                       PROCESS                  block,          /* Դ˲                   */
                       struct OS_redir_entry    *router_table,  /* Դ˲                   */
                       OSVECTOR                 vec,            /* ж                   */
                       OSUSER                   user)           /* Ϊ0                      */
{
    cyg_handle_t interrupt_handle = 0x00;
    
    zOss_ASSERT(tos_get_isr_nesting_level() == 0x00 && 
                tos_get_dsr_nesting_level() == 0x00 &&
                proc_type == OS_INT_PROC
                && entrypoint != NULL
                && user == 0x00);
    ZOSS_UNUSED_PTR(name);
    ZOSS_UNUSED_PARAM(stack_size);
    ZOSS_UNUSED_PARAM(priority);
    ZOSS_UNUSED_PARAM(timeslice);
    ZOSS_UNUSED_PARAM(block);
    ZOSS_UNUSED_PTR(router_table);
    
    switch (proc_type) 
    {
    case OS_INT_PROC:
        {
#ifdef CYGOPT_KERNEL_EXTEND_CALLING_DSR
            interrupt_handle = tos_create_irq(vec, priority, 0x00, tos_default_isr, (tos_dsr_t *)entrypoint);
#else
            interrupt_handle = tos_create_isr(vec, priority, 0x00, (tos_isr_t *)entrypoint);
#endif
            break;
        }
    default:
        {
            zOss_ASSERT(0);
            break;
        }
    }
    
    return (PROCESS)interrupt_handle;
}

/**************************************************************************
* :     OSEϵͳе߳ɾ
* ˵:     
*   ()  id:     ɾ̵߳߳id
*   ()  void
*   ֵ:     void
* ˵:     1) ̴߳ʧܣϵͳԣ
                2) Ƽģеô˺ӿڣ
**************************************************************************/
void kill_proc(PROCESS id)
{
    zOss_AssertExN(tos_get_isr_nesting_level() == 0x00 && 
                   tos_get_dsr_nesting_level() == 0x00 &&
                   id != 0x00);
    tos_delete_irq((cyg_handle_t)id);
}

/**************************************************************************
* :     OSAģʼ,TOSϵͳʱ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ظʼϵͳ
**************************************************************************/
UINT32 OSA_Init(VOID)
{
    static BOOL init_flag       = FALSE;
    cyg_uint32      ret         = 0x00;
    
    zOss_AssertEx(init_flag == FALSE, ZOSS_ERROR);
    
    zOss_AssertEx((cyg_bool)(CYGOPT_KERNEL_EXTEND_THREAD_USER_AREA == ALIGN_TO(sizeof(T_ZOsa_ThreadUserArea), sizeof(int))), ZOSS_ERROR);

    pool_init();
    
    ret = MEM_Init();
    zOss_AssertEx(ret == ZOSS_SUCCESS, ZOSS_ERROR);
    
    FS_Init();

    Osa_SysErrHndInit();
    
#ifdef _USE_MONITOR
    gOsa_MsgInfo.num = 0;
    gOsa_MsgInfo.ele = (T_ZOss_Mon_Msg_Ele *)zOss_GetUB(OSS_MON_INFO_MAX_NUMBER * sizeof(T_ZOss_Mon_Msg_Ele));
    zOss_AssertEx(gOsa_MsgInfo.ele != NULL, ZOSS_ERROR);
#endif 

    ret = TIMER_Init();
    zOss_AssertEx(ret == ZOSS_SUCCESS, ZOSS_ERROR);

    init_flag = TRUE;
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ֤һ߳ǷЧ
* ˵:     
*   ()  thread_id:  ֤߳id
*   ()  void
*   ֵ:     ߳ЧZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 OSA_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    zOss_AssertEx(threadID != NULL, ZOSS_ERROR);
    return zOss_IdVerify(threadID);
}

/**************************************************************************
* :     ȡ̵߳CPUռ
* ˵:     
*   ()  thread_id:  ߳id
*   ()  void
*   ֵ:     ̵߳CPUռ
* ˵:     void
**************************************************************************/
FLOAT Osa_GetProcessCPU(ZOSS_THREAD_ID thread_id)
{
    T_ZOsa_ThreadUserArea *user_area = NULL;
    
    if (gOsa_SwapTimeFlag)
    {
        if (thread_id == NULL)
        {
            return 0;
        }
        
#ifdef CYGOPT_KERNEL_EXTEND_CHECK_THREAD
        if (cyg_thread_check_valid((cyg_handle_t)thread_id) == false)
        {
            return 0;
        }
#endif
        user_area = (T_ZOsa_ThreadUserArea *)cyg_thread_get_user_area((cyg_handle_t)thread_id);
        zOss_AssertEx(user_area != NULL, 0);

        return user_area->cpupercent;
    }
    
    return 0;
}

/**************************************************************************
* :     ȡ߳ûݿռָ
* ˵:     
*   ()  thread_id:  ȡûݿռָ߳id
                bupdate:    Ϊ棬ûݿռ䣻򷵻ûݿռָ
*   ()  void
*   ֵ:     ̵߳ûݿռָ
* ˵:     void
**************************************************************************/
T_ZOsa_ThreadUserArea *Osa_GetThreadUserArea(ZOSS_THREAD_ID thread_id, BOOL bupdate)
{
    T_ZOsa_ThreadUserArea   *user_area      = NULL;
    cyg_handle_t            thread_handle   = 0x00;
    cyg_uint32              state           = 0x00;

    zOss_AssertEx(thread_id != NULL, NULL);
        
    thread_handle = (cyg_handle_t)thread_id;
    user_area = (T_ZOsa_ThreadUserArea *)cyg_thread_get_user_area(thread_handle);
    zOss_AssertEx(user_area != NULL, NULL);
    
    if (bupdate == FALSE)
    {
        return user_area;
    }
    
    user_area->topstack = cyg_thread_get_stack_ptr(thread_handle);
    user_area->maxstack = zOss_GetThreadStackUsed(thread_id);
    user_area->priority = (UINT8)cyg_thread_get_priority(thread_handle);
    user_area->msgnum   = (UINT32)cyg_mbox_peek(cyg_thread_get_mbox(thread_handle));
    if (user_area->runtime > 0)
    {
        user_area->RunTimeInMs = (UINT32)((FLOAT)user_area->runtime / 1000);
    }
    state = cyg_thread_get_state(thread_handle);
    switch (state) 
    {
    case OSA_THREAD_RUNNING:
        {
            if (thread_handle == cyg_thread_self())
            {
                user_area->runstatus = ZOSS_OS_RUN;
            }
            else
            {
                user_area->runstatus = ZOSS_OS_READY;
            }
            break;
        }
        
    default:
        {
            user_area->runstatus = ZOSS_OS_BLOCK;
            break;
        }
    }
    
    return user_area;
}

/**************************************************************************
* :     ȡ̵߳߳id
* ˵:     
*   ()  void
*   ()  threadarray:    ߳idݵָ
*   ֵ:     ̵߳
* ˵:     ˺ڴռ䣬ʹͷţڴй¶
**************************************************************************/
UINT32 Osa_GetAllThreadId(ZOSS_THREAD_ID *threadarray[])
{
    cyg_uint32      total                   = 0x00;
    cyg_handle_t    *thread_handle_saved    = NULL;

    zOss_AssertEx(threadarray != NULL, ZOSS_ERROR);
    
    total = cyg_thread_count_all_thread();
    zOss_AssertEx(total != 0x00, ZOSS_ERROR);
    
    thread_handle_saved = (cyg_handle_t*)zOss_Malloc(total*sizeof(cyg_handle_t));
    zOss_AssertEx(thread_handle_saved != NULL, ZOSS_ERROR);

    cyg_thread_get_all_thread(thread_handle_saved);
    *threadarray = (ZOSS_THREAD_ID *)thread_handle_saved;

    return total;
}

/**************************************************************************
* :     ӡ߳ʱϢ
* ˵:     
*   ()  pid:    ӡϢ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSʧܣZOSS_ERROR
* ˵:     void
**************************************************************************/
UINT32 Osa_DisplayThreadExecInfo(PROCESS pid)
{
    T_ZOsa_ThreadUserArea *user_area = NULL;
    
    user_area = Osa_GetThreadUserArea((ZOSS_THREAD_ID)pid, TRUE);
    if (user_area == NULL)
    {
        return ZOSS_ERROR;
    }
        
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s  %-16s  %16s  %16s  %16s  %16s",
                "ThreadName", "ThreadID", "RunTimeInMs", "CpuPercent", "MsgNum", "RunCount");
    if (user_area->threadid) 
    {
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s  0x%08x  %16u  %16f  %16u  %16u",
                    user_area->threadname,
                    user_area->threadid,
                    user_area->RunTimeInMs,
                    user_area->cpupercent,
                    user_area->msgnum,
                    user_area->runcount);
    }
    else 
    {
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_ABNORMAL, "ûҵ߳0x%08x", (UINT32)pid);
        return ZOSS_ERROR;
    }
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ӡ̵߳ʱϢ
* ˵:     
*   ()  type:   
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSʧܣZOSS_ERROR
* ˵:     void
**************************************************************************/
UINT32 Osa_DisplayThreadsExecInfo(UINT32 type)
{
    UINT32                  cnt             = 0;
    UINT32                  thread_num      = 0;
    FLOAT                   cpu_percent     = 0;
    UINT32                  run_time        = 0;
    ZOSS_THREAD_ID          *thread_array   = NULL;
    cyg_tick_count_t        total_time      = 0;
    T_ZOsa_ThreadUserArea   *user_area      = NULL;
    
    thread_num = Osa_GetAllThreadId(&thread_array);
    if (thread_num == 0 || thread_array == NULL)
    {
        return ZOSS_ERROR;
    }
    
#ifdef _USE_PSM
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "\t**********************Current CPU Frequency is %u**********************",  zDrvPow_GetPsCoreFreq());
#endif
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s %-16s %16s %16s %16s %16s",
                "ThreadName", "ThreadID", "RunTimeInMs", "CpuPercent", "MsgNum", "RunCount");
    for (cnt = 0; cnt < thread_num; cnt++)
    {
        user_area = Osa_GetThreadUserArea(thread_array[cnt], TRUE);
        if (user_area == NULL)
        {        
            continue;
        }

        if (type & SUP_THREAD_STATISTIC_INFO_BIT)   /* ͳָʱڵִ߳,ʱĻȡʹϵͳʱtick,λ,Ƚϵ */
        {
#ifdef CYGOPT_KERNEL_EXTEND_THREAD_STATISTIC_TIMESLICE
            run_time    = (UINT32)cyg_thread_get_statistic_timeslice((cyg_handle_t)thread_array[cnt]);
            total_time  = cyg_current_statistic_time();
            cpu_percent = (FLOAT)run_time * 100 / total_time;
            run_time    = (UINT32)((FLOAT)run_time * (gOsa_SysCpuFreq / 1000));
#endif
        }
        else    /* ʱˢµִ߳,ʱĻȡĺ,λ΢,Ƚϸ */
        {
            run_time = user_area->RunTimeInMs;
            cpu_percent = user_area->cpupercent;
        }
        
        if ((type & SUP_THREAD_LIVE_BIT) && run_time == 0)
        {
            continue;   /* ûл߳ */
        }
        else if ((type & SUP_THREAD_LAZY_BIT) && run_time != 0)
        {
            continue;   /* ߳ */
        }
        
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s  0x%08x  %16u  %16f  %16u  %16u",
                    user_area->threadname,
                    user_area->threadid,
                    run_time,
                    cpu_percent,
                    user_area->msgnum,
                    user_area->runcount);
    }
    
    zOss_Free(thread_array);
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ߳л¼
* ˵:     
*   ()  enableRunTime:  Ƿ¼ʱϢ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID Osa_SwapCtl(BOOL enableRunTime)
{    
    if ((enableRunTime == gOsa_SwapTimeFlag))
    {
        return;
    }
    
    if ((enableRunTime == TRUE) && (gOsa_SwapTimeFlag == FALSE)) 
    {
        if (gOsa_AllTaskIdArray == NULL)
        {
            T_OSS_PARAM *pPlatCfg;
            
            pPlatCfg = zOss_GetOssCfg();
            gOsa_AllTaskIdArray = (ZOSS_TASK_ID *)zOss_Malloc(sizeof(ZOSS_TASK_ID) * pPlatCfg->TaskCfg.max_task_num);
            zOss_AssertExN(gOsa_AllTaskIdArray != NULL);
        }
        
        gOsa_CpuStartTime = Osa_HwTimeRead();
        gOsa_SwapLastTime = gOsa_CpuStartTime;
    }
    
    gOsa_SwapTimeFlag   = enableRunTime;
}

/**************************************************************************
* :     ϵͳ̺߳CPUռ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID Osa_UpdateCpu(VOID)
{
    if (gOsa_SwapTimeFlag) 
    {
        cyg_scheduler_lock();
        
        Osa_UpdateThreadCpu();        
        Osa_UpdateTaskCpu();
        
        gOsa_CpuStartTime = Osa_HwTimeRead();
        gOsa_SwapLastTime = gOsa_CpuStartTime;

        cyg_scheduler_unlock();
    }
}

/**************************************************************************
* :     ̴߳ʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void Osa_create_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);
        
    if (gOsa_SysCpuFreq == 0x00) 
    {
        gOsa_SwapFlag       = TRUE;
        gOsa_SwapLastTime   = Osa_HwTimeRead();
#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
        zOss_RecordPsmLastSwapTime();
#endif
        gOsa_SysCpuFreq     = CYGNUM_HAL_RTC_PERIOD;
    }
    
    zOss_InitThreadUserArea((cyg_handle_t)thread, (T_ZOsa_ThreadUserArea *)user_area);
}

/**************************************************************************
* :     ߳ɾʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void Osa_kill_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);
}

/**************************************************************************
* :     ߳ʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void Osa_swapin_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);
    
#ifdef OSS_TRACE_THREAD    
    oss_trace_thread_swapin(thread);
    oss_trace_func_swapin(thread);
#endif

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    zOss_ThreadSwapInPsmHook((T_ZOsa_ThreadUserArea *)user_area);
#endif
    
    if (gOsa_SwapTimeFlag) 
    {
        UINT32 past_time;
        UINT32 current_time;
        T_ZOsa_ThreadUserArea *ua = (T_ZOsa_ThreadUserArea *)user_area;

        current_time        = Osa_HwTimeRead();
        past_time           = current_time - gOsa_SwapLastTime;
        gOsa_SwapLastTime   = current_time;
        ua->runcount++;
        ua->cputime += past_time;
        ua->runtime += past_time;
        
        if (ua->curtaskid != NULL) 
        {
            T_ZOss_TCB *tcb = (T_ZOss_TCB *)(ua->curtaskid);
            
            tcb->cputime    += past_time;
            tcb->runtime    += past_time;
            tcb->task_time  = current_time;
        }
    }
}

/**************************************************************************
* :     ߳гʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void Osa_swapout_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);
    
#ifdef OSS_TRACE_THREAD   
    oss_trace_thread_swapout(thread);  
    oss_trace_func_swapout(thread);
#endif    

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    zOss_ThreadSwapOutPsmHook((T_ZOsa_ThreadUserArea *)user_area);
#endif
    
    if (gOsa_SwapTimeFlag)
    {
        UINT32 past_time;
        UINT32 current_time;
        T_ZOsa_ThreadUserArea *ua = (T_ZOsa_ThreadUserArea *)user_area;

        current_time        = Osa_HwTimeRead();
        past_time           = current_time - gOsa_SwapLastTime;
        gOsa_SwapLastTime   = current_time;
        ua->cputime += past_time;
        ua->runtime += past_time;
        
        if (ua->curtaskid != NULL)
        {
            T_ZOss_TCB *tcb = (T_ZOss_TCB *)(ua->curtaskid);

            past_time       = current_time - tcb->task_time;
            tcb->cputime    += past_time;
            tcb->runtime    += past_time;
        }
    }
}

/**************************************************************************
* :     zOss_CleanCacheT32
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     T32űʹ
**************************************************************************/
VOID zOss_CleanCacheT32(VOID)
{
    tos_cache_clean_all();
    for ( ; ; ) 
        ;
}

#define HAL_DCACHE_CLEAN_RANGE(start, end)                                  \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        "mov    r4, %0;"                                                    \
        "mov    r5, %1;"                                                    \
        "bic    r4, r4, #31;"                                               \
    "1:"                                                                    \
        "mcr    p15, 0, r4, c7, c10, 1;"/* Clean d-cache line */            \
        "add    r4, r4, #32;"                                               \
        "cmp    r4, r5;"                                                    \
        "bls    1b;"                                                        \
        :                                                                   \
        : "r"(start),"r"(end)                                               \
        : "r4", "r5"  /* Clobber list */                                    \
    );                                                                      \
CYG_MACRO_END


#define HAL_DCACHE_INV_RANGE(start, end)                                    \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        "mov    r4, %0;"                                                    \
        "mov    r5, %1;"                                                    \
        "bic    r4, r4, #31;"                                               \
    "1:"                                                                    \
        "mcr    p15, 0, r4, c7, c6, 1;"/* Invalidate d-cache line */        \
        "add    r4, r4, #32;"                                               \
        "cmp    r4, r5;"                                                    \
        "bls    1b;"                                                        \
        :                                                                   \
        : "r"(start),"r"(end)                                               \
        : "r4", "r5"  /* Clobber list */                                    \
    );                                                                      \
CYG_MACRO_END

/* cache ַ line */
#define CACHE_LINESIZE                           (UINT32)(32)
#define CACHE_ALIGN_TO_LINESIZE(ADDR, LEN)       ((LEN) = (((LEN) + ((ADDR) - ((ADDR) & (~(CACHE_LINESIZE - 1u)))) + \
		                                  CACHE_LINESIZE - 1u) & (~(CACHE_LINESIZE - 1u)))); \
		                                  ((ADDR) = ((ADDR) & (~(CACHE_LINESIZE - 1u))))

VOID zOss_CacheCleanRange(UINT32 base, UINT32 size)
{
#ifdef _USE_CACHE_TEST
    cyg_uint32 old_intr;

    CACHE_ALIGN_TO_LINESIZE(base, size);
    HAL_DISABLE_INTERRUPTS(old_intr);
    HAL_DCACHE_CLEAN_RANGE(base, base + size - 1);
    asm volatile("dsb;");
    zDrvL2x0_Clean_Range(base, size);
    HAL_RESTORE_INTERRUPTS(old_intr);
#endif
}

VOID zOss_CacheInvalidateRange(UINT32 base, UINT32 size)
{
#ifdef _USE_CACHE_TEST
    cyg_uint32 old_intr;
    
    CACHE_ALIGN_TO_LINESIZE(base, size);
    HAL_DISABLE_INTERRUPTS(old_intr);
    HAL_DCACHE_INV_RANGE(base, base + size - 1);
    asm volatile("dsb;");
    zDrvL2x0_Inv_Range(base, size);
    HAL_RESTORE_INTERRUPTS(old_intr);
#endif
}

/**************************************************************************
* :     zOss_DumpStack
* ˵:     
*   ()  to:   źùϵĿռ
*   ()  size: ռĴСֽڣ
*   ()  void
*   ֵ:     void
* ˵:     ֧GCC32λ
**************************************************************************/
VOID zOss_DumpStack(VOID *to, UINT32 size)
{
#ifdef __GNUC__
    UINT32         *current_sp;
    UINT32         *stack_top;
    UINT32         *space;
    UINT32          addr;
    cyg_handle_t    thread;

    if(to == NULL || size < sizeof(VOID *) || (UINT32)to % sizeof(VOID *) != 0)
    {
        return;
    }

    asm volatile ("mov %0, sp" : "=r"(current_sp));

    thread     = cyg_thread_self();
    space      = (UINT32 *)to;
    stack_top  = (UINT32 *)(cyg_thread_get_stack_base_real(thread) + cyg_thread_get_stack_size_real(thread));

    while(1)
    {
        addr = *current_sp++;
        if(Osa_AddrInText(addr))
        {
            *space++ = addr;
            size -= sizeof(VOID *);
        }
        
        if(size <= 0 || (UINT32)current_sp >= (UINT32)stack_top)
        {
            return;
        }
    }
#endif
}

#ifdef __cplusplus
}
#endif

