#ifndef _COMMON_H_INCLUDED
#define _COMMON_H_INCLUDED

#ifdef WITH_SSL
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif

#define FTP_DEFAULT_PORT	21
#define FTP_DEFAULT_PROXY_PORT	21

#define HTTP_DEFAULT_PORT	80
#define HTTP_DEFAULT_PROXY_PORT	3128


/* Structure used for error message lists */
struct fetcherr {
	const int	 num;
	const int	 cat;
	const char	*string;
};

/* Connection */
typedef struct fetchconn conn_t;
struct fetchconn {
	int		 sd;		/* socket descriptor */
	char		*buf;		/* buffer */
	size_t		 bufsize;	/* buffer size */
	size_t		 buflen;	/* length of buffer contents */
	int		 err;		/* last protocol reply code */
#ifdef WITH_SSL
	SSL		*ssl;		/* SSL handle */
	SSL_CTX		*ssl_ctx;	/* SSL context */
	X509		*ssl_cert;	/* server certificate */
	SSL_METHOD	*ssl_meth;	/* SSL method */
#endif
	int		 ref;		/* reference count */
};

/* for _fetch_writev */
struct iovec;

#endif
