/************************************************************************
* Ȩ (C)2010, ͨѶɷ޹˾
*
* ļƣ zte_web_pbm.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ zyt
* ڣ 2010-11-06
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/

#include "zte_web_interface.h"
//#include "../../phonebook/phonebook.h"
#include "zte_web_get_fw_para.h"
#include "zte_web_pbm.h"

static void zte_web_pbm_feed_back_empty(webs_t wp);

#define IFSTREQUAL(str1, str2) (strcmp((str1), (str2))?0:1)

int zte_web_pbm_check_can_process()
{
	char flag[20] = {0};

	(void)zte_web_read(ZTE_PBM_NV, flag);
	if (0 == strcmp(flag, PBM_OPRATING)) {
		slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_check_can_process flag=%s, not can process.\n", flag);
		return 0;
	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_check_can_process flag=%s, can process.\n", flag);
		return -1;
	}
}

static data_safe_result_type_t zte_Safe_noSpecialChar_ucs2(char *str)
{
	int i = 0;
	int len = 0;
	if (NULL == str || strlen(str) < 4) {
		return 0;
	}
	len = strlen(str);
	for (i = 0; i < len; i=i+4) {
		if (str[i] == '0' && str[i+1] == '0') {
			if(str[i+2] == '2') {//"'/
				if(str[i+3] == '2' || str[i+3] == '7' || str[i+3] == 'f' || str[i+3] == 'F')
					return 0;
			} else if(str[i+2] == '3') {//<>
				if(str[i+3] == 'c' || str[i+3] == 'C' || str[i+3] == 'e' || str[i+3] == 'E')
					return 0;
			} else if(str[i+2] == '5') {//\
				if(str[i+3] == 'c' || str[i+3] == 'C')
					return 0;
			}
		}
	}
	return 1;

}

/**********************************************************************
* Function:         zte_web_pbm_contact_saveto_sim
* Description:
* Input:            wp:web para;sim_contact_location:save location
* Output:
* Return:           void
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120926    V1.0        liuyingnan        first version
**********************************************************************/
static void zte_web_pbm_contact_saveto_sim(webs_t wp, int sim_contact_location)
{
	/*contact added type*/
	zte_pbm_create_ext_record_s_type sim_contact_add;
	int ret_code = 0;
	//add by liuyingnan for server safe start
	char* pbm_name = NULL;
	char* pbm_mobilephone_num = NULL;
	//add by liuyingnan for server safe end

	/*LOG*/
	slog(MISC_PRINT, SLOG_DEBUG, "web_pbm->web_pbm_contact_saveto_sim()."); /*lint !e26*/

	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->goform_pbm_contact_add_process(): invalid input.."); /*lint !e26*/
		return;
	}

	//add by liuyingnan for server safe for xss attack start
	pbm_name = websGetVar(wp, T("name"), T(""));
	pbm_mobilephone_num = websGetVar(wp, T("mobilephone_num"), T(""));

	if (PBM_MAX_TEXT_LENGTH < strlen(pbm_name) || PBM_MAX_NUM_LENGTH < strlen(pbm_mobilephone_num)
		||DATA_NO_SAFE == zte_Safe_noSpecialChar_ucs2(pbm_name)
		|| DATA_NO_SAFE == zte_Safe_noSpecialChar(pbm_mobilephone_num)
		) {
		slog(MISC_PRINT, SLOG_ERR, "Get Data is no Safe:pbm_name:%s\n", pbm_name); /*lint !e26*/
		sc_cfg_set("data_safe", "failed");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//add by liuyingnan for server safe for xss attack end

	/*init contact_add*/
	memset(&sim_contact_add, 0, sizeof(sim_contact_add));
	/*set struct value*/
	sim_contact_add.zte_pbm_del_id = atoi(websGetVar(wp, T("delId"), T("-1")));
	sim_contact_add.zte_pbm_location = sim_contact_location;
	sim_contact_add.zte_pbm_id = atoi(websGetVar(wp, T("edit_index"), T("")));

	memcpy(sim_contact_add.zte_pbm_name, websGetVar(wp, T("name"), T("")),
	       sizeof(sim_contact_add.zte_pbm_name));
	memcpy(sim_contact_add.zte_pbm_number, websGetVar(wp, T("mobilephone_num"), T("")),
	       sizeof(sim_contact_add.zte_pbm_number));
	memcpy(sim_contact_add.zte_pbm_anr, websGetVar(wp, T("homephone_num"), T("")),
	       sizeof(sim_contact_add.zte_pbm_anr));
	memcpy(sim_contact_add.zte_pbm_anr1, websGetVar(wp, T("officephone_num"), T("")),
	       sizeof(sim_contact_add.zte_pbm_anr1));
	memcpy(sim_contact_add.zte_pbm_email, websGetVar(wp, T("email"), T("")),
	       sizeof(sim_contact_add.zte_pbm_email));
	memcpy(sim_contact_add.zte_pbm_sne, websGetVar(wp, T("nick_name"), T("")),
	       sizeof(sim_contact_add.zte_pbm_sne));
	if (sim_contact_add.zte_pbm_number[ZTE_WEB_PBM_NUMBER_TYPE_START] ==
	    ZTE_WEB_PBM_NUMBER_TYPE_SPLIT) {
		sim_contact_add.zte_pbm_type = ZTE_WEB_PBM_NUMBER_TYPE_1;
	} else {
		sim_contact_add.zte_pbm_type = ZTE_WEB_PBM_NUMBER_TYPE_2;
	}
	slog(MISC_PRINT, SLOG_DEBUG, "web_pbm_contact_saveto_sim:send messsage to mc start"); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.pbm_id:%d", sim_contact_add.zte_pbm_id); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.name:%s", sim_contact_add.zte_pbm_name); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.mobilephone_num:%s", sim_contact_add.zte_pbm_number); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.pbm_type:%d", sim_contact_add.zte_pbm_type); /*lint !e26*/

	/*send msg to mc*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,ZTE_PBM_WRITE_REC_MSG, sizeof(sim_contact_add), (char*)&sim_contact_add);
	(void)zte_web_write(ZTE_PBM_NV, PBM_OPRATING);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_WRITE_PB, sizeof(sim_contact_add), (char*)&sim_contact_add, 0);
	if (ret_code != 0) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send create modify record  fail"); /*lint !e26*/
		(void)zte_web_write(ZTE_PBM_NV, "14");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	slog(MISC_PRINT, SLOG_NORMAL, "web_pbm_contact_saveto_sim:send messsage to mc end"); /*lint !e26*/
	/*goto web page*/
	zte_write_result_to_web(wp, "success");
	return;
}
/**********************************************************************
* Function:         zte_web_pbm_contact_saveto_pc
* Description:       wp:web para;pc_contact_location:save location
* Input:            null
* Output:           null
* Return:           void
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120926    V1.0        liuyingnan        first version
**********************************************************************/
static void zte_web_pbm_contact_saveto_pc(webs_t wp, int pc_contact_location)
{
	/*contact added type*/
	zte_pbm_create_ext_record_s_type pc_contact_add;
	int ret_code = 0;
	//add by liuyingnan for server safe start
	char* pbm_name = NULL;
	char* pbm_mobilephone_num = NULL;
	//add by liuyingnan for server safe end
	/*LOG*/
	slog(MISC_PRINT, SLOG_DEBUG, "web_pbm->web_pbm_contact_saveto_pc()."); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_contact_saveto_pc entry\n");
	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_saveto_pc(): invalid input.."); /*lint !e26*/
		return;
	}
	//add by liuyingnan for server safe for xss attack start
	pbm_name = websGetVar(wp, T("name"), T(""));
	pbm_mobilephone_num = websGetVar(wp, T("mobilephone_num"), T(""));
	slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_contact_saveto_pc entry1\n");
	if (PBM_MAX_TEXT_LENGTH < strlen(pbm_name) || PBM_MAX_NUM_LENGTH < strlen(pbm_mobilephone_num)
		||DATA_NO_SAFE == zte_Safe_noSpecialChar_ucs2(pbm_name)
		|| DATA_NO_SAFE == zte_Safe_noSpecialChar(pbm_mobilephone_num)
		) {
		slog(MISC_PRINT, SLOG_ERR, "Get Data is no Safe:pbm_name:%s\n", pbm_name); /*lint !e26*/
		sc_cfg_set("data_safe", "failed");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//add by liuyingnan for server safe for xss attack end
	slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_contact_saveto_pc entry2\n");
	/*init contact_add*/
	memset(&pc_contact_add, 0, sizeof(pc_contact_add));
	/*set struct value*/
	pc_contact_add.zte_pbm_del_id = atoi(websGetVar(wp, T("delId"), T("-1")));
	pc_contact_add.zte_pbm_location = pc_contact_location;
	pc_contact_add.zte_pbm_id = atoi(websGetVar(wp, T("add_index_pc"), T("")));
	memcpy(pc_contact_add.zte_pbm_name, websGetVar(wp, T("name"), T("")),
	       sizeof(pc_contact_add.zte_pbm_name));
	memcpy(pc_contact_add.zte_pbm_number, websGetVar(wp, T("mobilephone_num"), T("")),
	       sizeof(pc_contact_add.zte_pbm_number));
	memcpy(pc_contact_add.zte_pbm_anr, websGetVar(wp, T("homephone_num"), T("")),
	       sizeof(pc_contact_add.zte_pbm_anr));
	memcpy(pc_contact_add.zte_pbm_anr1, websGetVar(wp, T("officephone_num"), T("")),
	       sizeof(pc_contact_add.zte_pbm_anr1));
	memcpy(pc_contact_add.zte_pbm_email, websGetVar(wp, T("email"), T("")),
	       sizeof(pc_contact_add.zte_pbm_email));
	memcpy(pc_contact_add.zte_pbm_sne, websGetVar(wp, T("nick_name"), T("")),
	       sizeof(pc_contact_add.zte_pbm_sne));
	memcpy(pc_contact_add.zte_pbm_group, websGetVar(wp, T("groupchoose"), T("")),
	       sizeof(pc_contact_add.zte_pbm_group));

	if (pc_contact_add.zte_pbm_number[ZTE_WEB_PBM_NUMBER_TYPE_START] ==
	    ZTE_WEB_PBM_NUMBER_TYPE_SPLIT) {
		pc_contact_add.zte_pbm_type = ZTE_WEB_PBM_NUMBER_TYPE_1;
	} else {
		pc_contact_add.zte_pbm_type = ZTE_WEB_PBM_NUMBER_TYPE_2;
	}
	slog(MISC_PRINT, SLOG_DEBUG, "web_pbm_contact_saveto_pc:send messsage to mc start"); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.pbm_id:%d", pc_contact_add.zte_pbm_id); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.name:%s", pc_contact_add.zte_pbm_name); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.mobilephone_num:%s", pc_contact_add.zte_pbm_number); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sim_contact_add.pbm_type:%d", pc_contact_add.zte_pbm_type); /*lint !e26*/
	printf("[PB] web_pbm_contact_saveto_pc entry3\n");
	/*send msg to mc*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,ZTE_PBM_WRITE_REC_MSG, sizeof(pc_contact_add), (char*)&pc_contact_add);
	(void)zte_web_write(ZTE_PBM_NV, PBM_OPRATING);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_WRITE_PB, sizeof(pc_contact_add), (char*)&pc_contact_add, 0);
	if (ret_code != 0) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send create modify record  fail"); /*lint !e26*/
		(void)zte_web_write(ZTE_PBM_NV, "14");
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	printf("web_pbm_contact_saveto_pc:%d,%d,%d,%d\n", ret_code, MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_WRITE_PB);
	slog(MISC_PRINT, SLOG_NORMAL, "web_pbm_contact_saveto_pc:send messsage to mc end"); /*lint !e26*/
	/*goto web page*/
	zte_write_result_to_web(wp, "success");
}

/**********************************************************************
* Function:         zte_web_pbm_utils_parseStr
* Description:
* Input:
* Output:
* Return:           void
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120409    V1.0        chenyi        first version
**********************************************************************/
static  int zte_web_pbm_utils_parseStr
(
    char *input,  char *output, int srcLen, int destLen, char separator
)
{
	/*index*/
	int input_ind = 0;
	int dest_ind = 0;
	int all_ind = 0;

	/*check input*/
	if (NULL == input || NULL == output || srcLen == 0 || destLen == 0) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_utils_parseStr():invalid input."); /*lint !e26*/
		return 0;
	}

	/*handler*/
	for (input_ind = 0; input_ind < srcLen; input_ind++) {
		//kw
		if (all_ind > destLen) {
			slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_utils_parseStr():invalid param."); /*lint !e26*/
			return 0;
		}
		
		if ('\0' == input[input_ind]) {
			*(output + destLen * dest_ind + all_ind) = '\0';
			return dest_ind + 1;
		}

		if (separator == input[input_ind]) {
			*(output + destLen * dest_ind + all_ind)  = '\0';
			if ('\0' != input[input_ind + 1]) {
				all_ind = 0;
				dest_ind++;
			}
		} else {
			*(output + destLen * dest_ind + all_ind)  = input[input_ind];
			all_ind++;
		}
	}

	/*return value*/
	return dest_ind;
}


/**********************************************************************
* Function:         zte_web_pbm_contact_del_part
* Description:
* Input:            web para
* Output:
* Return:           void
*                   Others: reason of error.
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120409    V1.0        chenyi        first version
**********************************************************************/
static void zte_web_pbm_contact_del_part(webs_t wp)
{
	int ret_code = 0;
	/*deleted index get from page*/
	char del_index[PBM_WEB_MAX_CHAR_LEN] = {0};
	/*split deleted index*/
	char split_index[ZTE_PB_INDEX_MAX][ZTE_WEB_PBM_REC_LEN+1];
	/*flag of contact number*/
	/*index for for circle*/
	int num_ind = 0;
	/*data struct */
	zte_pbm_del_multi_records_s_type sendto_data;

	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_del_part(): invalid input.."); /*lint !e26*/
		return;
	}

	/*init*/
	memset(del_index, 0, sizeof(del_index));
	memset(&sendto_data, 0, sizeof(sendto_data));
	memset(split_index, 0, sizeof(split_index));

	/*set data struct*/
	//sendto_data.zte_del_pbm_location = atoi(websGetVar(wp,T("savelocation1"), T("")));
	memcpy(del_index, websGetVar(wp, T("delete_id"), T("")), sizeof(del_index));
	sendto_data.zte_del_pbm_total = zte_web_pbm_utils_parseStr(del_index, (char *)split_index,
	                                (int)ZTE_PB_INDEX_MAX, (int)ZTE_WEB_PBM_REC_LEN, (char)ZTE_WEB_PBM_INDEX_SPLIT_FLAG);
	slog(MISC_PRINT, SLOG_DEBUG,"liuyingnan sendto_data.del_pbm_total:%d", sendto_data.zte_del_pbm_total); /*lint !e26*/

	/*del one contact*/
	if (ZTE_WEB_PBM_DEL_MULT_OR_ONE_FLAG == sendto_data.zte_del_pbm_total) {
		sendto_data.zte_del_pbm_id[ZTE_WEB_PBM_DEL_ONE_IND] = atoi(split_index[ZTE_WEB_PBM_DEL_ONE_IND]);

#if 0
		if (-1 == zte_mc_relay_pbm_del_one_record(&sendto_data)) {
			slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_del_part():delete one contact failed."); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
#endif
		slog(MISC_PRINT, SLOG_NORMAL, "web_pbm_contact_del_part:send messsage start"); /*lint !e26*/
		//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,ZTE_PBM_DEL_A_REC_MSG, sizeof(sendto_data), (char*)&sendto_data);
		ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_DEL_A_PB, sizeof(sendto_data), (char*)&sendto_data, 0);
		slog(MISC_PRINT, SLOG_DEBUG, "web_pbm_contact_del_part:send messsage end"); /*lint !e26*/
		if (ret_code != 0) {
			slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send DEL A record  fail"); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
	} else {
		/*handler*/
		for (num_ind = 0; num_ind < sendto_data.zte_del_pbm_total; num_ind ++) {
			sendto_data.zte_del_pbm_id[num_ind] = atoi(split_index[num_ind]);
			printf("web_pbm->web_pbm_contact_del_part():split_index=[%d]", sendto_data.zte_del_pbm_id[num_ind]); /*lint !e26*/
		}

		/*handler*/
#if 0
		if (-1 == zte_mc_relay_pbm_del_multi_record(&sendto_data)) {
			slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_del_part():delete mult contact failed."); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
#endif
		//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,ZTE_PBM_DEL_MUTI_REC_MSG, sizeof(sendto_data), (char*)&sendto_data);
		ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_DEL_MUTI_PB, sizeof(sendto_data), (char*)&sendto_data, 0);
		if (ret_code != 0) {
			slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send DEL MUTI record  fail"); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
	}
	/*goto differ page*/
	(void)zte_web_write(ZTE_PBM_NV, PBM_OPRATING);
	zte_write_result_to_web(wp, "success");
	//zte_web_pbm_goto_diff_page(wp,sendto_data.zte_del_pbm_location);
}
/**********************************************************************
* Function:         zte_web_pbm_contact_del_all
* Description:
* Input:            web para
* Output:           null
* Return:           void
*                   Others: reason of error.
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120409    V1.0        chenyi        first version
**********************************************************************/
static void zte_web_pbm_contact_del_all(webs_t wp)
{
	int ret_code = 0;
	/*data struct*/
	zte_pbm_del_multi_records_s_type sendto_data;

	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_del_all(): invalid input.."); /*lint !e26*/
		return;
	}

	/*init*/
	memset(&sendto_data, 0, sizeof(sendto_data));

	/*set data struct*/
	sendto_data.zte_del_pbm_location = atoi(websGetVar(wp, T("del_all_location"), T("")));
	slog(MISC_PRINT, SLOG_DEBUG, "liuyingnan sendto_data.del_pbm_location:%d", sendto_data.zte_del_pbm_location); /*lint !e26*/

	/*handler del all*/
	//(void)zte_mc_relay_pbm_del_all_record(&sendto_data);
	slog(MISC_PRINT, SLOG_NORMAL, "web_pbm_contact_del_all:send messsage start"); /*lint !e26*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,ZTE_PBM_DEL_ALL_REC_MSG, sizeof(sendto_data), (char*)&sendto_data);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_DEL_ALL_PB, sizeof(sendto_data), (char*)&sendto_data, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "web_pbm_contact_del_all:send messsage end"); /*lint !e26*/
	if (ret_code != 0) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send DEL ALL record  fail"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	/*goto differ page*/
	(void)zte_web_write(ZTE_PBM_NV, PBM_OPRATING);
	zte_write_result_to_web(wp, "success");
	//zte_web_pbm_goto_diff_page(wp,sendto_data.zte_del_pbm_location);
}
/**********************************************************************
* Function:         zte_web_pbm_contact_del_by_group
* Description:
* Input:            web para
* Output:
* Return:           void
*                   Others: reason of error.
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120711    V1.0        chenyi        first version
**********************************************************************/
static void zte_web_pbm_contact_del_by_group(webs_t wp)
{
	int ret_code = 0;
	zte_pbm_del_multi_records_s_type sendto_data;
	char *group = NULL;

	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_del_by_group(): invalid input.."); /*lint !e26*/
		return;
	}

	/*init*/
	memset(&sendto_data, 0, sizeof(zte_pbm_del_multi_records_s_type));

	group = websGetVar(wp, T("del_group"), T(""));
	slog(MISC_PRINT, SLOG_DEBUG, "liuyingnan group:%s", group); /*lint !e26*/
	if (0 == strcmp(group, "")) {
		slog(MISC_PRINT, SLOG_ERR, "pbm:group is empty.\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	/*set data struct*/
	sendto_data.zte_del_pbm_location = atoi(websGetVar(wp, T("del_all_location"), T("0")));
	slog(MISC_PRINT, SLOG_DEBUG, "liuyingnan sendto_data.del_pbm_location:%d", sendto_data.zte_del_pbm_location); /*lint !e26*/

	if (ZTE_NVIO_DONE != zte_web_write("pbm_group", group)) {
		slog(MISC_PRINT, SLOG_ERR, "write the nv [pbm_group] failure.\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	(void)zte_web_write(ZTE_PBM_NV, PBM_OPRATING);

#if 0
	if (ZTE_MC_OK_S != zte_mc_relay_pbm_del_all_record(&sendto_data)) {
		slog(MISC_PRINT, SLOG_ERR, "call mc_relay_pbm_del_all_record fail.\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	} else {
		zte_write_result_to_web(wp, SUCCESS);
	}
#endif
	slog(MISC_PRINT, SLOG_NORMAL, "web_pbm_contact_del_by_group:send messsage start"); /*lint !e26*/
	//ret_code = zte_send_message(ZUFI_MODULE_ID_AT_LOCAL,ZTE_PBM_DEL_ALL_REC_MSG, sizeof(sendto_data), (char*)&sendto_data);
	ret_code = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PB, MSG_CMD_DEL_ALL_PB, sizeof(sendto_data), (char*)&sendto_data, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "web_pbm_contact_del_by_group:send messsage end"); /*lint !e26*/
	if (ret_code != 0) {
		slog(MISC_PRINT, SLOG_ERR, "mc lib relay pbm  send DEL record by group  fail"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	zte_write_result_to_web(wp, "success");
}


/**********************************************************************
* Function:         zte_goform_pbm_contact_add_process
* Description:
* Input:            null
* Output:           null
* Return:           void
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 20120926    V1.0        liuyingnan        first version
**********************************************************************/
void zte_goform_pbm_contact_add_process(webs_t wp)
{
	/*contact location*/
	int contact_location = 0;

	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->goform_pbm_contact_add_process(): invalid input.."); /*lint !e26*/
		return;
	}

	if (0 == zte_web_pbm_check_can_process()) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	/*get the saved mem*/
	contact_location = atoi(websGetVar(wp, T("location"), T("")));
	slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_check_can_process contact_location=%d, can process.\n", contact_location);
	/*goto different mem handler*/
	switch (contact_location) {
	case ZTE_WEB_PBM_CONTACT_SIM: { /*goto sim mem handler*/
		slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_check_can_process sim=%d, can process.\n", ZTE_WEB_PBM_CONTACT_SIM);
		zte_web_pbm_contact_saveto_sim(wp, ZTE_WEB_PBM_CONTACT_SIM);
		break;
	}
	case ZTE_WEB_PBM_CONTACT_PC: { /*goto pc mem handler*/
		slog(MISC_PRINT, SLOG_DEBUG,"[PB] web_pbm_check_can_process pc=%d, can process.\n", ZTE_WEB_PBM_CONTACT_PC);
		zte_web_pbm_contact_saveto_pc(wp, ZTE_WEB_PBM_CONTACT_PC);
		break;
	}

	default: { /*unknown mem*/
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->goform_pbm_contact_add_process():unknown pbm mem."); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}
	}
}

void zte_goform_pbm_contact_del_process(webs_t wp)
{
	/*check input*/
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->web_pbm_contact_del_all(): invalid input.."); /*lint !e26*/
		return;
	}

	if (0 == zte_web_pbm_check_can_process()) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	/*del the given index contact in specified mem*/
	if (0 == strcmp(websGetVar(wp, T("del_option"), T("")), ZTE_WEB_PBM_PAGE_DEL_PART)) {
		zte_web_pbm_contact_del_part(wp);
	}

	/*del all the contact in specified mem*/
	else if (0 == strcmp(websGetVar(wp, T("del_option"), T("")), ZTE_WEB_PBM_PAGE_DEL_ALL)) {
		zte_web_pbm_contact_del_all(wp);
	}
	//delete the pbm data by group
	else if (0 == strcmp(websGetVar(wp, T("del_option"), T("")), ZTE_WEB_PBM_DEL_BY_GROUP)) {
		zte_web_pbm_contact_del_by_group(wp);
	}

	else {
		slog(MISC_PRINT, SLOG_ERR, "web_pbm->goform_pbm_contact_del_process():unknown pbm del."); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}

}


/**********************************************************************
* Function:         zte_get_pbm_data
* Description:      to get the pbm data info
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/04/10    V1.0        chenyi       first version
**********************************************************************/
void zte_get_pbm_data(webs_t wp)
{
	zte_pbm_query_req_s_type pbm_query_req;
	zte_pbm_query_resp_s_type *p_pbm_query_result = NULL;
	int result = 0;
	int i = 0;
	char_t *page = NULL;
	char_t *data_per_page = NULL;
	char_t *mem_store = NULL;

	memset(&pbm_query_req, 0, sizeof(zte_pbm_query_req_s_type));

	page = websGetVar(wp, "page", T(""));
	data_per_page = websGetVar(wp, "data_per_page", T(""));
	mem_store = websGetVar(wp, "mem_store", T(""));

	if (('\0' == *page) || ('\0' == *data_per_page) || ('\0' == *mem_store)) {
		slog(MISC_PRINT, SLOG_ERR, "get_pbm_data: invalid web para.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return ;
	}
	int tmp_page = atoi(page);
	int tmp_num_per_page = atoi(data_per_page);
	int location = atoi(mem_store);
	if((tmp_page < 0 || tmp_page > 255)
		||(tmp_num_per_page < 0 || tmp_num_per_page > 255)
		||(location < PBM_LOCATION_SIM || location > PBM_LOCATION_MAX)){
		slog(MISC_PRINT, SLOG_ERR, "get_pbm_data:err[%d,%d,%d]\n", tmp_page,tmp_num_per_page,location); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return ;
	}
	pbm_query_req.page = (uint8)tmp_page;
	pbm_query_req.num_per_page = (uint8)tmp_num_per_page;
	pbm_query_req.location = (zte_pbm_location_e_type)location; //0:sim;1:device

	slog(MISC_PRINT, SLOG_DEBUG, "pbm_query_req:[%u,%u,%d].\n", pbm_query_req.page, pbm_query_req.num_per_page, pbm_query_req.location); /*lint !e26*/

	p_pbm_query_result = (zte_pbm_query_resp_s_type*)malloc(4 + sizeof(zte_pbm_create_ext_record_s_type) * (pbm_query_req.num_per_page));
	if (NULL == p_pbm_query_result) {
		slog(MISC_PRINT, SLOG_ERR, "malloc pbm result mem fail.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return ;/*lint !e429*/
	}

	memset(p_pbm_query_result, 0, (4 + sizeof(zte_pbm_create_ext_record_s_type) * (pbm_query_req.num_per_page)));	/*lint !e668*/

	slog(MISC_PRINT, SLOG_DEBUG, "GET PBM DATA FROM DB START.\n"); /*lint !e26*/
	result = zte_libpbm_get_rec_data(&pbm_query_req, p_pbm_query_result);
	slog(MISC_PRINT, SLOG_DEBUG, "GET PBM DATA FROM DB END.\n"); /*lint !e26*/

	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call libpbm_get_rec_data fail.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		//free
//		if (NULL != p_pbm_query_result) {  // kw 3
			free(p_pbm_query_result);
			p_pbm_query_result = NULL;
//		}
		return ;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "total query count [%u].\n", (*p_pbm_query_result).count); /*lint !e26*/

	if (0 == (*p_pbm_query_result).count) {
		zte_web_pbm_feed_back_empty(wp);
		//free
//		if (NULL != p_pbm_query_result) {  kw 3
			free(p_pbm_query_result);
			p_pbm_query_result = NULL;
//		}
		return ;
	}

	//write the pbm data to web
	for (i = 0; i < (*p_pbm_query_result).count; i++) {
		if (0 == i) {
			web_feedback_header(wp);
			zte_rest_get_pbm_data_head(wp);
			if (0 == pbm_query_req.location) {
				zte_rest_get_pbm_data_sim(wp, p_pbm_query_result, i, 0);
			} else {
				zte_rest_get_pbm_data_other(wp, p_pbm_query_result, i, 0);
			}
		} else {
			if (0 == pbm_query_req.location) {
				zte_rest_get_pbm_data_sim(wp, p_pbm_query_result, i, 1);
			} else {
				zte_rest_get_pbm_data_other(wp, p_pbm_query_result, i, 1);
			}
		}
	}
	zte_rest_get_pbm_data_foot(wp);
	//(void)websWrite(wp, T("]}"));

	//free
//	if (NULL != p_pbm_query_result) { // kw 3
		free(p_pbm_query_result);
		p_pbm_query_result = NULL;
//	}
}

/**********************************************************************
* Function:         zte_get_pbm_data_total
* Description:      to get the total pbm data
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/04/10    V1.0        chenyi       first version
**********************************************************************/
void zte_get_pbm_data_total(webs_t wp)
{
	zte_pbm_query_req_s_type pbm_query_req;
	zte_pbm_query_resp_s_type *p_pbm_query_result = NULL;
	int result = 0;
	int i = 0;
	char_t *page = NULL;
	char_t *data_per_page = NULL;
	char_t *mem_store = NULL;
	char *pbm_group = NULL;

	int total_pages = 0;
	int leave_nums = 0;
	int curr_page = 0;
	int total_pbm = 0;

	int idata_per_page = 0;

	memset(&pbm_query_req, 0, sizeof(zte_pbm_query_req_s_type));

	page = websGetVar(wp, "page", T(""));
	data_per_page = websGetVar(wp, "data_per_page", T(""));
	mem_store = websGetVar(wp, "mem_store", T(""));
	pbm_group = websGetVar(wp, "pbm_group", T("")); //not to check whether is empty

	if (('\0' == *page) || ('\0' == *data_per_page) || ('\0' == *mem_store)) {
		slog(MISC_PRINT, SLOG_ERR, "get_pbm_data: invalid web para.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return ;
	}


#if 0
    //calculate the total pages
    total_pages = (atoi(data_per_page)) / PBM_PAGE_RECORD_MAX_NUM;
    leave_nums = (atoi(data_per_page)) % PBM_PAGE_RECORD_MAX_NUM;
    
    if (0 != leave_nums) {
    	total_pages++;
    }

#else
	idata_per_page = atoi(data_per_page);
	if(idata_per_page < 0 || idata_per_page >  INT_MAX-1)
	{
	    total_pages = 1;
		leave_nums = 0;
	}
	else
	{
    	//calculate the total pages
    	total_pages = idata_per_page / PBM_PAGE_RECORD_MAX_NUM;
    	leave_nums = idata_per_page % PBM_PAGE_RECORD_MAX_NUM;
    
    	if (0 != leave_nums) {
    		total_pages++;
    	}
	}
#endif

	slog(MISC_PRINT, SLOG_DEBUG, "pbm:total_pages,leave_nums:[%d][%d]", total_pages, leave_nums); /*lint !e26*/

	p_pbm_query_result = (zte_pbm_query_resp_s_type*)malloc(4 + sizeof(zte_pbm_create_ext_record_s_type) * PBM_PAGE_RECORD_MAX_NUM);
	if (NULL == p_pbm_query_result) {
		slog(MISC_PRINT, SLOG_ERR, "malloc pbm result mem fail.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return ;/*lint !e429*/
	}

	(void)zte_web_write("pbm_group", pbm_group); //only wrtite one time

	for (curr_page = 0; curr_page < total_pages; curr_page++) {

		//reset
		memset(&pbm_query_req, 0, sizeof(zte_pbm_query_req_s_type));

		pbm_query_req.page = curr_page;
		pbm_query_req.num_per_page = PBM_PAGE_RECORD_MAX_NUM;
		/*lint -e64*/
		pbm_query_req.location = atoi(mem_store); //0:sim;1:device

		slog(MISC_PRINT, SLOG_DEBUG, "pbm_query_req:[%u,%u,%d].\n", pbm_query_req.page, pbm_query_req.num_per_page, pbm_query_req.location); /*lint !e26*/

		//reset
		memset(p_pbm_query_result, 0, 4 + sizeof(zte_pbm_create_ext_record_s_type)*PBM_PAGE_RECORD_MAX_NUM); /*lint !e668*/

		slog(MISC_PRINT, SLOG_NORMAL, "GET PBM DATA FROM DB START.\n"); /*lint !e26*/
		result = zte_libpbm_get_rec_data(&pbm_query_req, p_pbm_query_result);
		slog(MISC_PRINT, SLOG_DEBUG, "GET PBM DATA FROM DB END.\n"); /*lint !e26*/

		if (-1 == result) {
			slog(MISC_PRINT, SLOG_DEBUG, "read pbm page [%d] fail.\n", curr_page); /*lint !e26*/
			//free
//			if (NULL != p_pbm_query_result) {  // kw 3
				free(p_pbm_query_result);
				p_pbm_query_result = NULL;
//			}

			if (0 == curr_page) {
				zte_web_pbm_feed_back_empty(wp);
				return ;
			} else {
				break;
			}
		}

		slog(MISC_PRINT, SLOG_DEBUG, "pbm:total query count [%u].\n", (*p_pbm_query_result).count); /*lint !e26*/

		if (0 == (*p_pbm_query_result).count) {
			//free
//			if (NULL != p_pbm_query_result) {  // kw 3
				free(p_pbm_query_result);
				p_pbm_query_result = NULL;
//			}

			if (0 == curr_page) {
				zte_web_pbm_feed_back_empty(wp);
				return ;
			} else {
				break;
			}
		}

		//write the pbm data to web
		for (i = 0; (i < (*p_pbm_query_result).count) && (total_pbm < atoi(data_per_page)); i++, total_pbm++) {
			if ((0 == i) && (0 == curr_page)) {
				web_feedback_header(wp);
				zte_rest_get_pbm_data_head(wp);
				if (0 == pbm_query_req.location) {
					zte_rest_get_pbm_data_sim(wp, p_pbm_query_result, i, 0);
				} else {
					zte_rest_get_pbm_data_other(wp, p_pbm_query_result, i, 0);
				}
			} else {
				if (0 == pbm_query_req.location) {
					zte_rest_get_pbm_data_sim(wp, p_pbm_query_result, i, 1);
				} else {
					zte_rest_get_pbm_data_other(wp, p_pbm_query_result, i, 1);
				}
			}
		}

	}


	zte_rest_get_pbm_data_foot(wp);
	//free
//	if (NULL != p_pbm_query_result) {  // kw 3
		free(p_pbm_query_result);
		p_pbm_query_result = NULL;
//	}
}

/**********************************************************************
* Function:         zte_get_pbm_parameter_info
* Description:      to get the pbm parameter info
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/04/10    V1.0        chenyi       first version
**********************************************************************/
void zte_get_pbm_parameter_info(webs_t wp)
{
	zte_pbm_query_req_s_type pbm_para_query_info;
	zte_pbm_sim_capability_s_type pbm_sim_capability_s;
	zte_pbm_device_capability_s_type pbm_device_capability_s;
	char *pbm_location = NULL;
	int result = 0;

	//initialize
	memset(&pbm_para_query_info, 0, sizeof(zte_pbm_query_req_s_type));
	memset(&pbm_sim_capability_s, 0, sizeof(zte_pbm_sim_capability_s_type));
	memset(&pbm_device_capability_s, 0, sizeof(zte_pbm_device_capability_s_type));

	pbm_location = websGetVar(wp, "pbm_location", T(""));

	if (0 == strcmp(pbm_location, "")) {
		slog(MISC_PRINT, SLOG_ERR, "pbm_location is empty.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "pbm_location is [%s].\n", pbm_location); /*lint !e26*/

	if (0 == strcmp(pbm_location, PBM_NATIVE)) {
		pbm_para_query_info.location = PBM_LOCATION_DEVICE;
	} else if (0 == strcmp(pbm_location, PBM_SIM)) {
		pbm_para_query_info.location = PBM_LOCATION_SIM;
	} else {
		slog(MISC_PRINT, SLOG_ERR, "invalid pbm_location[%s].\n", pbm_location); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return;
	}
	slog(MISC_PRINT, SLOG_NORMAL, "GET PBM DATA FROM DB START.\n"); /*lint !e26*/
	result = zte_libpbm_get_capability(&pbm_para_query_info, &pbm_sim_capability_s, &pbm_device_capability_s);
	slog(MISC_PRINT, SLOG_DEBUG, "GET PBM DATA FROM DB END.\n"); /*lint !e26*/
	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call libpbm_get_capability fail.\n"); /*lint !e26*/
		zte_web_pbm_feed_back_empty(wp);
		return ;
	}

	web_feedback_header(wp);
	if (0 == strcmp(pbm_location, PBM_NATIVE)) {
		zte_rest_cmd_write_head(wp);
		zte_rest_cmd_write_int(wp, PBM_DEV_MAX_RECORD_NUM, pbm_device_capability_s.max_record_number, 1);
		zte_rest_cmd_write_int(wp, PBM_DEV_USED_RECORD_NUM, pbm_device_capability_s.used_record_number, 0);
		zte_rest_cmd_write_foot(wp);
	} else {
		zte_rest_cmd_write_head(wp);
		zte_rest_cmd_write_int(wp, PBM_SIM_SIM_TYPE, pbm_sim_capability_s.sim_type, 1);
		zte_rest_cmd_write_int(wp, PBM_SIM_MAX_RECORD_NUM, pbm_sim_capability_s.max_record_number, 1);
		zte_rest_cmd_write_int(wp, PBM_SIM_USED_RECORD_NUM, pbm_sim_capability_s.used_record_number, 1);
		zte_rest_cmd_write_int(wp, PBM_SIM_MAX_NAME_LEN, pbm_sim_capability_s.max_name_len, 1);
		zte_rest_cmd_write_int(wp, PBM_SIM_MAX_NUMBER_LEN, pbm_sim_capability_s.max_number_len, 0);
		zte_rest_cmd_write_foot(wp);
	}
}

/**********************************************************************
* Function:         zte_web_pbm_feed_back_empty
* Description:      to write empty info to web
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/04/10    V1.0        chenyi       first version
**********************************************************************/

static void zte_web_pbm_feed_back_empty(webs_t wp)
{
	if (NULL == wp) {
		return;
	}

	web_feedback_header(wp);
	if (wp->flags & WEBS_XML_CLIENT_REQUEST) {
		websWrite(wp, T("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"));
		websWrite(wp, T("<%s>empty</%s>\n"), PBM_DATA, PBM_DATA);
	} else {
		(void)websWrite(wp, T("{\"%s\":[]}"), PBM_DATA);
	}
	//(void)websWrite(wp, T("{\"%s\":[]}"),PBM_DATA);
}
//added by chenyi for handle the http request end 20111118

