/**
 * @file at_com.h 
 * @brief at_ctlڲӿںݽṹ
 *        ATӿڡʱزӿڡ˼ϢͨŵĽӿڡ
 *        atͨϢӿڵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
#ifndef __AT_COM_H__
#define __AT_COM_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>
#include <errno.h>
#include <signal.h>
#include <assert.h>
#include "os_api.h"
#include "softap_api.h"
#include "cfg_nv_def.h"
#include "at_reg.h"
#include "at_netdog.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define AT_CMD_PREFIX 64

#define ZAT_INVALID_LEN -1
#define SEND_DATA_BUF_MAX_LEN   2048 /*·AT󳤶*/
#define REPLY_DATA_BUF_MAX_LEN  8192 /*ϱAT󳤶*/

#ifndef TRUE
#define	TRUE	1
#endif
#ifndef FALSE
#define	FALSE	0
#endif

#ifndef NULL
#define NULL 0
#endif


#if (APP_OS_TYPE == APP_OS_LINUX)
#define at_open open
#define at_read read
//#define at_write write
#define at_close close
#define at_select select
#endif 

#define AT_CMD_MODE				0	//͸ģʽatģʽ
#define WRITE_DATA_MODE			1	//͸ģʽwriteе͸ģʽ
#define TRANSPARENT_CMD_MODE	2	//͸ģʽģʽ
#define TRANSPARENT_DATA_MODE	3	//͸ģʽģʽ
#define FTP_DATA_MODE			4	//FTP PUT/GETе͸ģʽ

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/**
 * @brief at_ctlڲϢ
 */
enum inner_at_msg
{
	/* atͨϢatͨatϢ߳*/
	ATCTL_RCV_AT_STR_MSG = MSG_CMD_ATCTL_INNER_BASE + 1,
	/* ͨϢ벻ͨʱϢ̣߳ͨ*/
    ATCTL_INNER_FWD_RESEND_MSG,
    /* ʱѯϢat_ctlڲʱʱ͸Ϣat_ctl,ڴat_ctlѯĳЩ״̬Ϣźǿ*/
    ATCTL_INNER_PERIO_QUERY_MSG,
    /* ʱϢϢжʱʱϢ߳̽յID¿ʼϢ*/
    ATCTL_DELAY_TIMEOUT_MSG,
    /* ϢӡϢ*/
    ATCTL_DEBUG_PRINT_MSG,
    /* յصչATϢat_ctl*/
   // ATCTL_INNER_MODEM_EXTAT_MSG,
	/* ʼϢ*/
	ATCTL_INNER_ZURDY_IND_MSG,
	/* modemʼϢ*/
	ATCTL_INNER_ZMSRI_MSG,
	/* simȲϢ*/
	ATCTL_INNER_ZUSLOT_MSG,
	/* pdpϢ*/
	ATCTL_INNER_PDP_REACT_MSG,
	/* رVOLTEϢ*/
	ATCTL_INNER_CVMOD_MSG,
	/* رЭջͨϱ*/
	ATCTL_INNER_ZCHNELSET_MSG,
	/* ȴⲿMCUʱϢ */
	ATCTL_INNER_WAITCOMPLETE_MSG,	
	/* ȴⲿMCUӦϢʱ */
	ATCTL_INNER_WAIT_OUTSIDE_RSP_MSG,

	ATCTL_INNER_SMSPBINIT_MSG,
	
	ATCTL_INNER_AT_PORT_OPEN,//USB֪߳ͨ߳ATڴ򿪳ɹ
};
/**
 * @brief ATö
 */
enum AT_TYPE{
    AT_TYPE_REQUEST = 0, /* */
    AT_TYPE_INFORM,      /* ֪ͨ*/
    AT_TYPE_RESPONSE,    /* Ӧ*/
    AT_TYPE_PDU,         /* PDU*/
};

/**
 * @brief atĸʽ
 * @note  :
 *        ڿͻװatʱtypeװӦʽat;
 *        contextʱݿͻ˻תεatʽȡӦĸʽͣ
 *        浽contextreq_typeУյokerrмϱʱǰ͵at
 */
struct at_msg_data
{
    char *at_str;
    int at_len;
    int at_fd;
};
//socket proxyͨĿƿ飬atͨյsocket proxyat
//socket proxyatͨ
struct sock_channel_cb
{
	int at_fd;			      //socket proxy̹atͨ
	int unix_sockfd;	      //socket proxyͨŵunix socket 
	int module_id;		      //socket proxy̵ģIDMODULE_ID_SOCKET_PROXYʼ

	int transportmode;	      //ͨģʽ
	int msg_cmd;		      //͸socket proxyӦʱЯϢid
	int len;			      //͸ݵܳ
	int rcv_len;              //͸ģʽѾյݳ
	char *rcv_buf;            //͸ģʽѾյݣΪЧʣһռͷţ0rcv_len0
	int viewmode;			  //͸ݵĸʽhexassic	
    int priv;		          //˽ݣsocketӦΪsocket id
    int transparent_socketid; //͸ģʽsocket idֹе̬ʱ͸ socket id
    int data_suspend;         //¼ǰǷ͸ģʽsocket
	void *addition; 	      //
	long long int last_data_tick;	//atͨϴյݵʱ㣬λ:΢
};

/**
 * @brief ö
 */
typedef enum
{
    AT_PARSE_SUCCESS,
    AT_PARSE_NO_PARAM,
    AT_PARSE_ERR_ATEND,
    AT_PARSE_ERR_FORMAT,
    AT_PARSE_ERR_TOOLONG,
    AT_PARSE_ERR_INPUT
}E_AT_PARSE;


//extern int  is_xinke_msg;
extern int g_customer_type;
extern int g_ap_lock;

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
 * @brief ַѰƥӴ˫ڵݳ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
char *find_sub_str(const char *pStr, const char *pSubStr,const int strLen);
/**
 * @brief ӵǰַлȡATӦӴ
 * @param 
 * @return Ӵ
 * @note   
 * @warning 
 */
int get_sub_at_Str(const char *pCurAtStr, char *pSubAtStr, int iDataLen, char *atRecvBuf);
/**
 * @brief жǷATĽβַβ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int is_at_cmd_end(const char * pstrAtCmd);
/**
 * @brief ַĿո񣬷ȥͷпոַ
 * @param 
 * @return 
 * @note   ATϱðźиո
 * @warning 
 */
const char * skip_at_cmd_head_blanks(const char * pstrAtCmd);
/**
 * @brief Ƶһ
 * @param 
 * @return 
 * @note   Ƿ񵽽ûнŲԵǰĿո
 * @warning 
 */
E_AT_PARSE move_to_next_param(const char * pstrAtCmd, const char ** ppstrNextParam);
/**
 * @brief ȡintͲ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
E_AT_PARSE get_at_cmd_param_int(const char * pstrAtCmd, int * piParam, const char ** ppstrNext);
/**
 * @brief ȡַͲ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
E_AT_PARSE get_at_cmd_param_str(const char * pstrAtCmd, char * pstrParam, int iPramLen, const char ** ppstrNext);

/**
 * @brief ATǰ׺Ϣʶǰ׺ݼAT
 * @param 
 * @return 
 * @return 
 * @note   
 * @note  ҪԸⳡ̷ֱ:
			?ָat
			=ָat
			:ָat
			/rָat

			ڲĸ뵥:
				ERROR:ǰ׺+
				ERROR:ǰ׺
				OK:ǰ׺
				ZMRSI:ǰ׺
				"> "ǷҲǰ׺
				PDUϢ:вûǰ׺
 *
 * @warning 
 */
int parase_at_cmd(char *at_str, void **at_cmd_prefix, int* prefix_len, void ** at_cmd_paras, int * paras_len);


/**
 * @brief ָfdͨд
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_write(int fd,char *buf,int len);
/**
 * @brief ʮƺʮƵַתʮ
 * @param sStr ַ
 * @param DorH  TRUE ʮ  FALSE ʮ
 * @param pValue תʮ
 * @return TRUE ɹ  
 * @return FALSE ʧ
 * @note   
 * @warning 
 */
BOOL trans_Str2Value(CHAR *sStr , BOOL DorH, UINT32 * pValue);


//Config_linux.c/Tos_linux.c
/**
 * @brief עat¼
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void register_at_event_init(void);

/* passthrough.c*/
/**
 * @brief ͸Ϣ
 * @param 
 * @return 
 * @note  Ŀǰֻ֧һ·ͨ͸
 * @warning 
 */
#if (APP_OS_TYPE == APP_OS_LINUX)
//extern int data_suspend;
int set_passthough_bycmd(MSG_BUF *msg);
/**
 * @brief socket͸
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int handle_socket_data(int at_fd);
void proc_socket_timeout();
void get_socket_timeout(struct timeval *time);
void urcok_proc(int src_id);
void get_customer_type();
void start_goudian_baseapp(void);

/**
 * @brief socket͸ӦϢ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int  at_socket_data_proc(MSG_BUF *msg_buf);
#endif
extern int set_passthough_info(int at_fd, int len, int transportmode, int viewmode, int priv, int mod_id, int msg_cmd);
extern int unix_send_proc(int sockfd, int dst_id, unsigned short Msg_cmd, unsigned short us_DataLen, unsigned char *pData, int msgflag);
extern int get_unix_sockfd(int module_id);
extern int get_default_sockfd(void);
extern int get_dst_moduleid(int at_fd);
extern int send_cgev_deact_info(int c_id);
extern struct sock_channel_cb * get_sock_channel_cb(int at_fd, int module_id);
/* at_timeout.c*/
/**
 * @brief Ϣʱѯ
 * @param 
 * @return 
 * @note  at_ctlеãڲatquerytimenvֵȷǷʱ:
		  atquerytimeΪ0ʱʾҪʱ
		  atquerytime0ʱʱҶʱһֱЧ
		  öʱΪڴat_ctlѯĳЩ״̬źǿȣѯ浽ӦnvУԹ
		  webuimmiѯȡ
		  ʱʱʱʱ״̬ѯеСѯʱ䡣
 * @warning 
 */
void at_timeout_start_perio_query(void);
/**
 * @brief PDPʱ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_timeout_start_pdpreconn_timer(void);
/**
 * @brief ϢʱȴУʱȴ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int add_one_delayed_msg(MSG_BUF *msg);
/**
 * @brief ʱǰȴϢ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void delayed_msg_proc(void);
/**
 * @brief λPDPʱʱ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_timeout_reset_pdpreconn_time(void);



/* at_portmng.c*/
/**
 * @brief ͻAPPͨ״̬á
 * @param name ģ
 * @param state Ҫõ״̬
 * @return 
 * @note  ǰδ򿪣Ϊ״̬ʱ
 * @note  ǰΪ򿪣Ϊرʱֻµǰ״̬
 * @warning 
 */
int at_portmng_set_state_proc(const char * name, int is_open, int fd);

#ifdef USE_CAP_SUPPORT
int at_cap_set_state_proc(const char * name, int state, int fd);
#endif

/**
 * @brief  ͻAPPȡATͨȡһеfarpsͨĬ
 * @param  name ģ
 * @return 0 
 * @note   ÿͻAPPõģIDΪfarpsͨfdĬͨΪ1
 * @warning 
 */
int at_portmng_get_free_atchn(const char * name);
/**
 * @brief ͨfdȡͻAPPͨ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_portmng_get_type_by_fd(int fd);
/**
 * @brief ͨfdȡͻAPPͨ״̬
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_portmng_get_state_by_fd(int fd);
/**
 * @brief ͨfdȡͻAPPͨ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
char *at_portmng_get_name_by_fd(int fd);

/**
 * @brief ָtty豸
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_portmng_open_ttydev(const char *tty);


/* at_socmsg.c*/
/**
 * @brief ˼Ϣʵֽӿ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_socmsg_write(int at_fd,int src_id,int targetId, unsigned short msg_id, unsigned short len, unsigned char *msg);
/**
 * @brief ˼ӦϢͽӿ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_socmsg_write_msg(int at_fd,int src_id,int targetId, unsigned short msg_id, unsigned short len, unsigned char* msg);
/**
 * @brief תɺ˼Ϣд͸Ӧ
 * @param 
 * @return 1ʾɹ
 * @return 0ʾʧ
 * @note   
 * @warning 
 */
int at_socmsg_trans_and_write(void * at_paras, int paras_len);



/* at_rcvmsg.c*/
/**
 * @brief ATͨϢʵ
 * @param msg Ϣ
 * @return 0ʾ
 * @note   
 * @warning 
 */
int at_rcvmsg_handle(int at_fd, char *at_str, int at_len);

/**
 * @brief "at_recv_thread"̴߳ATͨϢݽյatַ
 *        װat
 * @param at_fd 
 * @param at_str
 * @param at_len
 * @return 
 * @note  ͨFD_NEAR_PSͨFD_FAR_PSͨԼptyͨ?
 * @warning 
 */
int rcv_at_str_proc(int at_fd, char *at_str, int at_len);



/* at_ctl.c*/
/**
 * @brief ϲӦÿͻϢҪעᵽg_appclt_listеϢ
 * @param msg_buf Ϣ
 * @return 
 * @note  Ӧò㷢͵ĴҪMODULE_IDΧϷԼ
 * @warning 
 */
int rcv_clt_req_msg_proc(MSG_BUF *msg_buf);


/**
 * @brief at_ctl߳ϢMODULE_ID_AT_CTLϢϢat_ctlڲϢƽ̨ⲿϢ
 * @param msg_buf Ϣ
 * @return 0ʾ
 * @note   
 * @warning 
 */
int rcv_msg_proc(MSG_BUF *msg_buf);

int at_portmng_get_fd_by_name(char *name);


int trim_atstr(char *str, int str_size);
int is_req_at(char *str);
int is_rsp_ok(char *str);
int is_rsp_err(char *str, int *err_no);
int is_result_at(char *str);
int is_report_at(char *str);
int is_correct_atcmd(char *str);
char *find_print_char(char *str);
char *at_strnstr2(char *source, char *substr, int dst_len);
char *at_strstr2(const char * source, const char * substr);
char *get_param_str(const char * source, const char * prefix);

int atctl_aes_init(void);

#endif

