/**
 * @file recv_thread.c
 * @brief at_ctḷ߳ҪǴӺ˼ͨšpsͨtty豸Ȼװ
		Ϣat_ctl̴߳
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_com.h"
#include "recv_thread.h"
#include "at_msg.h"
#include "at_context.h"
#include "softap_api.h"
#include "ppp_dial.h"

#if (APP_OS_TYPE == APP_OS_TOS)
#include "atchan_api.h"
#include "drvs_comm.h"
#endif

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define LF_CHAR         '\n'
#define CR_CHAR         '\r'
#define NULL_CHAR       0
#define BACKSPACE_CHAR  8
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static int parse_back_cmd_str(char *atBuff, int buffLen);
static int read_at_channel(int at_fd);
static int get_max(void);
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/* ATڶȡһǷﵽֵı־ */
static int g_endmax = 0;
/* FAR_PSָͨ*/
//static char *strFarpsAtCmdUnion[FAR_PS_FD_MAX+VOLTE_PTY_MAX+BL_PTY_MAX] = {NULL};
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/* PSͨ*/
int FD_NEAR_PS[NEAR_PS_FD_MAX] = {0};
/* ԶPSͨ*/
int FD_FAR_PS[FAR_PS_FD_MAX] = {0};
/* ϱͨѡһ򿪵atͨڽյϱʱͨյϱڷϱͨԿд*/
int g_auto_fd = -1;
/* ptmӦ豸ļ*/
int g_ppp_ptm = -1;
/* pppӦtty豸*/
int g_ppp_ttyfd = -1;

int g_farps_select_timeout = 5000;//Ĭ5
/* volte pty豸*/
//int volte_mainpty[VOLTE_PTY_MAX] = {-1, -1};
extern int is_zephyr_atcmd(char *data, int len);
extern T_ZDrvSys_PowerOn_Type g_powerOnType;
extern void at_hotplug_proc(void);

/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
/* ַЧԼ顣ȫسͿոΪЧַ*/
#ifdef NO_USE
static int parse_back_cmd_str(char *atBuff, int buffLen)
{
    int i = 0;
    int bValidNum = 0;
    char *abStrATCmd = (char *)malloc(buffLen+1);
    if(abStrATCmd == NULL)
    {
        softap_assert("");
    }
    //at_print(AT_DEBUG,"parse_back_cmd_str atBuff =%s, buffLen =%d\n", atBuff, buffLen);
    for(i = 0; i < buffLen; i++)
    {
        if(*(atBuff + i) == BACKSPACE_CHAR)
        {
            if(bValidNum > 0)
                abStrATCmd[--bValidNum] = NULL_CHAR;
        }
        else if(*(atBuff + i) == '\0')
        {
        }
        else
        {
            abStrATCmd[bValidNum++] = *(atBuff + i);
        }
    }

    memset(atBuff, 0, buffLen);
    memcpy(atBuff, abStrATCmd, bValidNum);
    free(abStrATCmd);
    abStrATCmd = NULL;
    //at_print(AT_DEBUG,"parse_back_cmd_str atBuff =%s, bValidNum =%d\n", atBuff, bValidNum);
    return bValidNum;
}
#endif
/* ָͨжȡϢ͵MODULE_ID_AT_CTLϢУҲat_ctl߳*/
static int read_at_channel(int at_fd)
{
    struct at_msg_data msg = {0};
    int ret = 0;
    int datalen = 0;	
    char buf[AT_CHAN_MAX_BUF_LEN+1] = {0};
	
#ifndef CONFIG_MIN_8M_VERSION
//#ifdef GUODIAN
    if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN)
    {
        //֮ǰõ͸ͨϵsocketݣAT
        if(0 == handle_socket_data(at_fd))
        {
            return 0;
        }
    }
//#endif
#endif

    datalen = at_read(at_fd, buf, sizeof(buf)-1);
    //at_print(AT_NORMAL,"read_at_ch fd%d pppfd%d cmd is: %s\n",at_fd ,g_ppp_ttyfd,  buf);
    at_print(AT_DEBUG,"read_at_ch fd: %d cmd is: %s\n", at_fd, buf);
    if(datalen <= 0 || datalen > sizeof(buf)-1)
    {   
		if(errno == 9 || errno == 5){
			ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, strlen("/dev/ttyGS0")+1, "/dev/ttyGS0", 0);
			ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, strlen("/dev/ttyGS0")+1, "/dev/ttyGS0", 0);
		
			ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, strlen("/dev/ttyGS1")+1, "/dev/ttyGS1", 0);
			ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, strlen("/dev/ttyGS1")+1, "/dev/ttyGS1", 0);
			
			usleep(1);
		}		
		at_print(AT_ERR,"read_at_channel cmd from %d failed, len: %d, errno: %d\n", at_fd,datalen,errno);
        //at_print(AT_ERR,"read_at_channel cmd from %d failed\n", at_fd);
        //softap_assert("");
		usleep(1);
        return -1;
    }
    
#if (APP_OS_TYPE == APP_OS_LINUX)
    if(at_fd == g_ppp_ttyfd)
    {/* pppŵtty豸ֱӵӿڣûpppŵ£g_ppp_ttyfd = -1*/
		buf[AT_CHAN_MAX_BUF_LEN]='\0';
		zppp_check_proc(buf, datalen);
        return 0;
    }
#endif
	//save_monitor_at_buf(at_fd, buf, datalen, AT_RECV_TYPE);
    /* ݴͨжatװϢ͸̣߳߳ͳһatķָ*/
    msg.at_fd = at_fd;
    msg.at_str = malloc(datalen+1);
    if(NULL == msg.at_str)
    {
        softap_assert("malloc failed!!!");
		return -1;
    }
    memset(msg.at_str, 0x00, datalen+1);
    memcpy(msg.at_str, buf, datalen);
    msg.at_len = datalen;

    ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_RCV_AT_STR_MSG, sizeof(struct at_msg_data), (unsigned char *)&msg, 0);
    if(ret != 0)
    {
        softap_assert("send msg to at_ctl failed!!!");
    }
    return ret;
}

/* ȡ豸*/
static int get_max(void)
{
    int max_fd = 0;
    int i = 0;
/*    for(i=0;i<NEAR_PS_FD_MAX;i++)
    {
        if(max_fd < FD_NEAR_PS[i])
            max_fd = FD_NEAR_PS[i];
    }*/

    for(i=0;i<FAR_PS_FD_MAX;i++)
    {
        //int flag = at_portmng_get_state_by_fd(FD_FAR_PS[i]);
        //if(flag == 1 && max_fd < FD_FAR_PS[i])
        if(max_fd < FD_FAR_PS[i])
            max_fd = FD_FAR_PS[i];
    }
	
#if 0
    for(i=0;i<VOLTE_PTY_MAX;i++)
    {
        if(max_fd < volte_mainpty[i])
        {
            max_fd = volte_mainpty[i];
        }
    }
#endif	
    return max_fd;
}

#if 0
int check_is_volte_ptyfd(int fd)
{
	int i = 0;
	for(i=0;i<VOLTE_PTY_MAX;i++)
	{
		if(volte_mainpty[i]>=0 && fd == volte_mainpty[i])
		{
			return 1;
		}
	}
	return 0;
}
#endif
/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
//MSG_CMD_AT_REQϢЯATͻ󣬰ģIDFDʹãҲڰFDΪģIDʹõⳡ
int check_is_fd(int fd)
{
	int i = 0;
	//if(fd == 0)
	//	softap_assert("");
	for(i=0;i<NEAR_PS_FD_MAX;i++)
	{
		if(FD_NEAR_PS[i]>=0 && fd == FD_NEAR_PS[i])
			return 1;
	}

	for(i=0;i<FAR_PS_FD_MAX;i++)
	{
		if(FD_FAR_PS[i] >=0 && fd == FD_FAR_PS[i])
			return 1;
	}

	if((fd >= MODULE_ID_ATCTL_TO_VOLTE && fd < MODULE_ID_ATCTL_TO_VOLTE+VOLTE_PTY1_MAX)
		|| (fd >= MODULE_ID_VOLTE_TO_ATCTL && fd < MODULE_ID_VOLTE_TO_ATCTL+VOLTE_PTY2_MAX))
		return 1;
#if 0
	for(i=0;i<VOLTE_PTY_MAX;i++)
	{
		if(volte_mainpty[i]>=0 &&fd == volte_mainpty[i])
		{
			return 1;
		}
	}
#endif	
	if((fd == g_ppp_ttyfd && g_ppp_ttyfd > 0) || (fd == g_ppp_ptm && g_ppp_ptm > 0)) //pppŵ⴦
		return 1;
	
	return 0;
}

//atǷǿɴӡģ\r\nҪж
int check_is_print(char *at_str, int at_len)
{
	int i = 0;
	for(i=0;i<at_len-1;i++)
	{
		if(at_str[i] != '\r' && at_str[i] != '\n' && isprint(at_str[i]) == 0)
			return 0;
	}
	return 1;
}


/**
 * @brief װat
 * @param 
 * @return 
 * @note  յַ\r\n\0ctrl+ZESCʱַ֮ǰ
          ַװһATһAT\rΪ
          ûַյַһֱȵ´յַ
          װһɵ
 * @warning 
 */
char *is_whole_atcmd(int fd, char *at_str, int len)
{
	struct at_channel_info * ch_info = at_context_find_chn_by_fd(fd);
	int totallen = 0;
	char *whole_store_cmd = NULL;
	char *new_str = NULL;
	int check_ret = CHECKSUM_SUCC;
	char* err_str = NULL;
	
	//ҲfdӦchannel_infoֱӷأݶ
	if(ch_info == NULL)
	{
		NETDOG_AT_STATICS(channel_info_null++);
		return NULL;
	}
	//far_psݲŽɾʱ
	if(check_is_farps(fd))
	{
		#if (APP_OS_TYPE == APP_OS_LINUX)
		if(get_timerID_by_fd(fd)>0)
			sc_timer_delete(get_timerID_by_fd(fd));//ɾʱ
		#endif		
	}
	totallen = strlen(ch_info->store_cmd)+len;
	//ܳȴ8kʱֱӽ
	if(totallen >= AT_CHAN_MAX_BUF_LEN)
	{
		at_print(AT_ERR,"recv data is too long and abandon!!!!\n");
		//atӡشⲿ
		err_str = at_err_build(ATERR_STR_TOO_LONG);
		at_context_write_data(fd, err_str, strlen(err_str));
		free(err_str);
		memset(ch_info->store_cmd, 0, AT_CMD_MAX);
		NETDOG_AT_STATICS(farps_cmd_err++);
		return NULL;
	}
	
	whole_store_cmd = (char *)malloc(totallen+1);
	if(whole_store_cmd == NULL)
	{
		softap_assert("");
		return NULL;
	}
	memset(whole_store_cmd, 0, totallen+1);
	//յݺͻݽƴ
	memcpy(whole_store_cmd, ch_info->store_cmd, strlen(ch_info->store_cmd));
	memcpy(whole_store_cmd+strlen(whole_store_cmd), at_str, len);
	memset(ch_info->store_cmd, 0, AT_CMD_MAX);
	//ЧַĹ
	//parse_back_cmd_str(whole_store_cmd,strlen(whole_store_cmd));
	//FAR_PSҵǰǶ״̬жϣȷatʽжظerror´
	if(check_is_farps(fd) && ch_info->cmd_state == 0 && strchr(whole_store_cmd,'\r') != NULL)
	{
		
		//ȹ\0
		totallen = trim_atstr(whole_store_cmd, totallen);
		if(0 == totallen)
		{
			goto ERROR_PROC;
		}
		//ڵյ\r\r\nֱӶ
		if(at_strcmp(whole_store_cmd,"\r") == 0 || at_strcmp(whole_store_cmd,"\r\n") == 0)
		{
			at_print(AT_ERR,"recv data \r or \r\n and abandon!!!!\n");
			free(whole_store_cmd);
			return NULL;
		}
		else if(is_correct_atcmd(whole_store_cmd) == 0)//ȷatʽж
		{
			//if(at_strncmp(whole_store_cmd,"at",2) && at_strncmp(whole_store_cmd,"\r\n",2))
			goto ERROR_PROC;
		}
		else//ȷat´
		{		
			char checksum_flag[20] = "none";

			if(at_strcmp(checksum_flag, "none") == 0)
			{
				return whole_store_cmd;
			}
#ifdef AT_CHECKSUM
			else
			{			
				new_str = (char *)malloc(totallen+1);
				if(new_str == NULL) softap_assert("");			
				memset(new_str, 0, totallen+1);
				check_ret = rcv_checksum_func(whole_store_cmd, new_str);

				if(check_ret == CHECKSUM_ERROR)
				{
					free(new_str);
					goto ERROR_PROC;
				}
				else if(check_ret == WAIT_CHECKSUM)
				{
					memcpy(ch_info->store_cmd, whole_store_cmd, strlen(whole_store_cmd));
					free(whole_store_cmd);
					free(new_str);
					return NULL;
				}
				else
				{
					free(whole_store_cmd);
					return new_str;
				}
			}
#endif			
		}
			
	}
	else//FAR_PSߵǰǶ״̬ƴӺֱӷزж
		return whole_store_cmd;

ERROR_PROC:
	at_print(AT_ERR,"recv data %s is not AT commond and abandon!!!!\n", whole_store_cmd);
	//Ӧ൫ǲȷatظerror
    //atӡشⲿ
#ifdef AT_CHECKSUM
    if(check_ret == CHECKSUM_ERROR)
		err_str = at_err_build(ATERR_PARAM_CHECKSUM);
	else
#endif		
	if(at_strcmp(whole_store_cmd,"A/\r") == 0 || at_strcmp(whole_store_cmd,"A/\r\n") == 0 || at_strcmp(whole_store_cmd,"A/\n") == 0)
	{
		int lastat_len = strlen(ch_info->last_cmd);
		free(whole_store_cmd);
		if(lastat_len > 0)
		{
			whole_store_cmd = malloc(lastat_len+1);
			assert(whole_store_cmd);
			memcpy(whole_store_cmd,ch_info->last_cmd,lastat_len+1);
		}
		else
		{
			whole_store_cmd = malloc(8);
			assert(whole_store_cmd);
			sprintf(whole_store_cmd,"AT\r\n");
		}
		return whole_store_cmd;
	}
	else
		err_str = at_err_build(ATERR_UNKNOWN_CMD);
	at_context_write_data(fd, err_str, strlen(err_str));
	free(err_str);
	free(whole_store_cmd);
	NETDOG_AT_STATICS(farps_cmd_err++);
	return NULL;
}


//üɶ¼豸
void set_rfd(fd_set *readfds)
{
	int i;

/*	if(g_powerOnType != POWER_ON_CHARGING)
	{
		for(i=0;i<NEAR_PS_FD_MAX;i++)
		{
			if(FD_NEAR_PS[i] >=0)
				FD_SET(FD_NEAR_PS[i], readfds);
		}

	}*/
	for(i=0;i<FAR_PS_FD_MAX;i++)
	{
		if(FD_FAR_PS[i] >= 0)
		{
			FD_SET(FD_FAR_PS[i], readfds);
		}
	}

#if 0
	for(i=0;i<VOLTE_PTY_MAX;i++)
	{
		if(volte_mainpty[i] >= 0)
		{
			FD_SET(volte_mainpty[i], readfds);
		}
	}
#endif
}
//¼
void proc_revent(fd_set * readfds)
{
	int i;
/*	if(g_powerOnType != POWER_ON_CHARGING)
	{
		for(i=0;i<NEAR_PS_FD_MAX;i++)
		{
			if(FD_NEAR_PS[i]>=0 &&FD_ISSET(FD_NEAR_PS[i], readfds))
				read_at_channel(FD_NEAR_PS[i]);

		}
	}*/
	for(i=0;i<FAR_PS_FD_MAX;i++)
	{
		if(FD_FAR_PS[i]>=0 && FD_ISSET(FD_FAR_PS[i], readfds))
		{
			read_at_channel(FD_FAR_PS[i]);
		}
		#ifndef CONFIG_MIN_8M_VERSION
		//selectܱ־ϣÿδҪжǿǷʱ
		else if (g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN) {
			proc_socket_timeout();
		}
		#endif
	}
#if 0	
	for(i=0;i<VOLTE_PTY_MAX;i++)
	{
		if(volte_mainpty[i]>=0 && FD_ISSET(volte_mainpty[i], readfds))
		{
			read_at_channel(volte_mainpty[i]);
		}
	}
#endif
}
/**
 * @brief ոͨATѭselectƴӸat_fdȡ
 * @param 
 * @return 
 * @note  ҪFD_NEAR_PSFD_FAR_PSvolte_mainptyԼg_ppp_ptm豸ļ
 * @warning 
 */
void recv_mainloop(void)
{
	fd_set readfds;
	struct timeval timeout = {5, 0}; //selectȴ5룬5ѯҪ0
	int max_fd = 0, ret = 0, i=0;
	prctl(PR_SET_NAME, "at_rcv_ps", 0, 0, 0);
	while (g_auto_fd >= 0)
	{
		FD_ZERO(&readfds);
		for(i=0;i<NEAR_PS_FD_MAX;i++)
		{
			if(max_fd < FD_NEAR_PS[i])
				max_fd = FD_NEAR_PS[i];
			if(FD_NEAR_PS[i] >=0)
				FD_SET(FD_NEAR_PS[i], &readfds);
		}
        timeout.tv_sec = 5;
        timeout.tv_usec = 0;
		
		ret = at_select(max_fd + 1, &readfds, NULL, NULL, &timeout);
				
		if (0 == ret ||(ret == -1 && errno == EINTR))
		{
			continue;
		}
		else if(-1 == ret && errno != EINTR)
		{
			at_print(AT_ERR,"select rpm faild, errno = %d\n",errno);
			continue;
		}

		for(i=0;i<NEAR_PS_FD_MAX;i++)
		{
			if(FD_NEAR_PS[i]>=0 &&FD_ISSET(FD_NEAR_PS[i], &readfds))
			{
				char buf[AT_CHAN_MAX_BUF_LEN] = {0};
				struct at_msg_data msg = {0};
				int datalen = 0;	
							
				datalen = at_read(FD_NEAR_PS[i], buf, sizeof(buf));
				if(datalen <= 0)
				{	
					at_print(AT_ERR,"read_rpm from %d failed, len: %d, errno: %d\n", FD_NEAR_PS[i],datalen,errno);
					continue;
				}
				
				//save_monitor_at_buf(FD_NEAR_PS[i], buf, datalen, AT_RECV_TYPE);
				msg.at_fd = FD_NEAR_PS[i];
				msg.at_str = malloc(datalen+1);
				if(NULL == msg.at_str)
				{
					softap_assert("malloc failed!!!");
					return;
				}
				memset(msg.at_str, 0x00, datalen+1);
				memcpy(msg.at_str, buf, datalen);
				msg.at_len = datalen;
			
				ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_RCV_AT_STR_MSG, sizeof(struct at_msg_data), (unsigned char *)&msg, 0);
				if(ret != 0)
				{
					softap_assert("send msg to at_ctl failed!!!");
				}
			}
		}
	}

}

void recv_mainloop_ppp(void)
{
	char buf[AT_CHAN_MAX_BUF_LEN];
	int datalen;
	
	prctl(PR_SET_NAME, "at_ppp", 0, 0, 0);
	while (g_auto_fd >= 0)
	{
		if(g_ppp_ptm >= 0){
			datalen = at_read(g_ppp_ptm, buf, sizeof(buf));
			if(datalen <= 0){
				usleep(1);
				at_print(AT_ERR,"read_ppp_ptm from %d failed, len: %d, errno: %d\n", g_ppp_ptm,datalen,errno);
				continue;
			}
			zppp_SendAtCmdToPort(buf, datalen, g_ppp_ttyfd);
		}else
			usleep(1000000);
	}
}

void recv_mainloop_farps(void)
{
    fd_set readfds;
    struct timeval timeout = {5, 0}; //selectȴ5룬5ѯҪ0
    int max_fd = 0, ret = 0, i=0;
	prctl(PR_SET_NAME, "at_rcv_drv", 0, 0, 0);
    while (g_auto_fd >= 0)
    {
		at_hotplug_proc();
        max_fd = get_max();
        FD_ZERO(&readfds);
		set_rfd(&readfds);
		
#if (APP_OS_TYPE == APP_OS_TOS)
        ret = at_select(max_fd + 1, &readfds, NULL, NULL, NULL);
#else
        timeout.tv_sec = 0;
        timeout.tv_usec = g_farps_select_timeout*1000;

		//ǿȡʱʱ䣬оͰǿʱóʱĬ
#ifndef CONFIG_MIN_8M_VERSION		
		if (g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN) {
			//ʵʳEINTRȽ϶࣬ÿȴ³ʱ¼
			proc_socket_timeout();
			get_socket_timeout(&timeout);
		}
#endif		
        ret = at_select(max_fd + 1, &readfds, NULL, NULL, &timeout);
#endif
		
        if (0 == ret ||(ret == -1 && errno == EINTR))
        {
            continue;
		}
		else if(-1 == ret && errno != EINTR)
		{
			if(errno == 9 || errno == 5){
				ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, strlen("/dev/ttyGS0")+1, "/dev/ttyGS0", 0);
				ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, strlen("/dev/ttyGS0")+1, "/dev/ttyGS0", 0);
			
				ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, strlen("/dev/ttyGS1")+1, "/dev/ttyGS1", 0);
				ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, strlen("/dev/ttyGS1")+1, "/dev/ttyGS1", 0);
				
				usleep(1);
			}		
			at_print(AT_ERR,"select op is faild, errno = %d\n",errno);
			continue;
		}

		proc_revent(&readfds);
    }

}


