#include <limits.h>

#include "softap_api.h"

#include "wifi_util.h"

int g_rtc_wake_timer_open = 0;
int g_sleep_rtc_timer;

int g_tsw_sleep_flag = 0;//޴ʱ˯ߵrtc timer
int g_tsw_wake_flag = 0;//޴ʱѵrtc timer

static int  create_rtc_sleep_timer (ULONG ulMin);
static int create_rtc_wakeup_timer (ULONG ulMin);
static int  disable_rtc_wakeup_timer();
int disable_rtc_sleep_timer();

/***
	this is the sleep status machine

*  1.  handle  usb plug
	when usb plug in,  disable sleep rtc timer, and disable wakeup timer, because wifi dont need sleep ,the cpu wont need wakeup
        when usb plug out, need to  check wifi status, sta num, wps status

    2. handle  sta linked or leave
        if  no charging
        when sta linked,  disable sleep rtc timer, and
    3. handle  wps , this process is special

    	when tigger wps, need to disable rtc timer, when wps over, need to check again
    4.


***/

void cancel_all_timer()
{
	disable_rtc_sleep_timer();
	disable_rtc_wakeup_timer();
}

static void create_wlan_sleep_timer()
{
	char sleep_interval[10] = {0};
	int sleep_int = 0;
	
	sc_cfg_get ("Sleep_interval", sleep_interval, sizeof (sleep_interval));
	if (g_sleep_rtc_timer == 1 || strcmp (sleep_interval, "-1") == 0) {
		wf_log ("no need:: sleep_rtc_timer_open=%d, sleep_interval=%s!", g_sleep_rtc_timer, sleep_interval);
		return;
	}
	
	sleep_int = atoi(sleep_interval);
	if(sleep_int < 0 || sleep_int > INT_MAX-1) {//kw 3
		//kw 3, Sleep_interval(min):-1 5 10 20 30 60 120; when -1, g_sleep_rtc_timer == 0; 21600 = 15day
		wf_log("wlan_reset_sleep_timer=%d", sleep_int);
		return;
	}
	
	create_rtc_sleep_timer(sleep_int);
	disable_rtc_wakeup_timer();

	return;
}

static void cancel_sleep_timer()
{
	disable_rtc_sleep_timer ();
	create_rtc_wakeup_timer(5);
	return;
}

 void check_to_presleep (int wifi_status, int charging_status, int sta_num, int wps_status)
{

	if (wifi_status == WLAN_OFF) {
		wf_log ("wifi is sleep, do nothing!!");
		return;
	}

	if (charging_status == 1) { //usb   charging
		cancel_all_timer();
	} else {
		//no charger status
		if (wps_status == 1) {
			//enter wps status, must disable sleep rtc timer, avoid  wifi entering  sleep when wps
			cancel_all_timer();
		} else { //when wps over, need to check again,  wps will be success or fail,   sta_num maybe >0 before
			if (sta_num > 0)
				cancel_sleep_timer();
			else
				create_wlan_sleep_timer();

		}
	}


}


static int create_rtc_sleep_timer (ULONG ulMin)
{
	int results = -1;

	if (g_sleep_rtc_timer == 1) {
		wf_log ("Already exsit");
		return  -1;
	}

	results = rtc_timer_add (ulMin * 60, WIFI_INTERVAL_SLEEP, MODULE_ID_WIFI);

	if (results == 0) {
		g_sleep_rtc_timer = 1;
	} else {
		wf_log ("failed");
	}

	wf_log ("sleep_rtc_timer_open=%d, interval=[%d]min", g_sleep_rtc_timer, ulMin);

	return results;
}

/*
	when  sta linked in ,  need to create  wake cpu timer
	avoid cpu sleepin , but sta go away, but wifi can not sleep
	so need to wake up cpu ,to call the func to check if need to create sleep timer
*/
static int create_rtc_wakeup_timer (ULONG ulMin)
{
	int results = -1;

	if (g_rtc_wake_timer_open) {
		wf_log ("Already exsit");
		return  -1;
	}

	results = rtc_timer_add (ulMin * 60,  WIFI_WAKE_UP_SYSTEM, MODULE_ID_WIFI);

	if (results == 0) {
		g_rtc_wake_timer_open = 1;
	} else {
		wf_log ("failed!");
	}

	wf_log ("interval=[%d]min",  ulMin);

	return results;

}

static int disable_rtc_wakeup_timer()
{
	int ret = -1;

	if (!g_rtc_wake_timer_open) {
		wf_log ("Already disable");
		return  -1;
	}

	ret = rtc_timer_del (WIFI_WAKE_UP_SYSTEM, MODULE_ID_WIFI);
	if (ret == 0) {
		g_rtc_wake_timer_open = 0;
	} else {
		wf_log ("failed!");
	}

	return ret;
}

int disable_rtc_sleep_timer()
{
	int ret = -1;

	if (g_sleep_rtc_timer == 0) {
		wf_log ("Already disable");
		return -1;
	}

	ret = rtc_timer_del (WIFI_INTERVAL_SLEEP, MODULE_ID_WIFI);

	if (ret == 0) {
		g_sleep_rtc_timer = 0;
	} else {
		wf_log (" failed");
	}
	wf_log ("sleep_rtc_timer_open=%d", g_sleep_rtc_timer);

	return ret;
}
#ifdef __REALTEK_8192_CHIP__
extern int wps_rtc_timer_open;
 LONG create_rtc_wps_timer (int ulSec)
{
	int ret = -1;

	if (wps_rtc_timer_open == 1) {
		wf_log ("Already exsit");
		return -1;
	}

	ret = rtc_timer_add (ulSec, WIFI_WPS_RESULT_CHECK, MODULE_ID_WIFI);

	if (ret == 0) {
		wps_rtc_timer_open = 1;
	} else {
		wf_log ("failed");
	}

	return ret;
}

int disable_rtc_wps_timer()
{
	int ret = -1;

	if (wps_rtc_timer_open == 0) {
		wf_log ("Already disable");
		return -1;
	}

	ret = rtc_timer_del (WIFI_WPS_RESULT_CHECK, MODULE_ID_WIFI);
	if (ret == 0) {
		wps_rtc_timer_open = 0;
	} else {
		wf_log ("failed");
	}

	return ret;
}

#endif
//ʱرյtimer
int create_rtc_tsw_close_timer (ULONG ulSec)
{
	int ret = -1;

	if (g_tsw_sleep_flag == 1) {
		wf_log ("Already exsit");
		return -1;
	}

	ret = rtc_timer_add (ulSec, WIFI_TSW_SLEEP, MODULE_ID_WIFI);

	if (ret == 0) {
		g_tsw_sleep_flag = 1;
	} else {
		wf_log (" failed");
	}

	return ret;
}

//ȡʱ˯ߵtimer
int disable_rtc_tsw_close_timer()
{
	int ret = -1;
	if (g_tsw_sleep_flag == 0) {
		wf_log ("Already disable");
		return -1;
	}

	ret = rtc_timer_del (WIFI_TSW_SLEEP, MODULE_ID_WIFI);

	if (ret == 0) {
		g_tsw_sleep_flag = 0;
	} else {
		wf_log ("failed");
	}

	return ret;
}

//ʱѵtimer
 int create_rtc_tsw_open_timer (ULONG ulSec)
{
	int ret = -1;

	if (g_tsw_wake_flag  == 1) {
		wf_log ("Already exist");
		return -1;
	}

	ret = rtc_timer_add (ulSec, WIFI_TSW_WAKEUP, MODULE_ID_WIFI);

	if (ret == 0) {
		g_tsw_wake_flag = 1;
	} else {
		wf_log (" failed");
	}

	return ret;
}

//ȡʱtimer
 int disable_rtc_tsw_open_timer()
{
	int ret = -1;

	if (g_tsw_wake_flag == 0) {
		wf_log ("Already disable");
		return -1;
	}

	ret = rtc_timer_del (WIFI_TSW_WAKEUP, MODULE_ID_WIFI);

	if (ret == 0) {
		g_tsw_wake_flag = 0;
	} else {
		wf_log (" failed");
	}

	return ret;
}

// ʱ߻
static int calculate_tsw_interval2 (char *p_sleep_str,  char *p_wake_str)
{
	int tsw_interval_sleep = 0;
	int tsw_interval_wake  = 0;
	char tsw_interval_sleep_str[12] = {0};
	char tsw_interval_wake_str[12]  = {0};

	char tsw_sleep_time_hour[16] = {0};
	char tsw_sleep_time_min[16]  = {0};
	char tsw_wake_time_hour[16]  = {0};
	char tsw_wake_time_min[16]   = {0};

	time_t timeC;
	time_t timeS;
	time_t timeW;
	struct tm timeCur = {0};
	struct tm timeSleep = {0};
	struct tm timeWake = {0};
	time (&timeC);
	localtime_r (&timeC, &timeCur);
	memset (&timeSleep, 0, sizeof (timeSleep));
	memset (&timeWake, 0, sizeof (timeWake));
	memcpy (&timeSleep, &timeCur, sizeof (timeCur));
	memcpy (&timeWake, &timeCur, sizeof (timeCur));

	sc_cfg_get ("tsw_sleep_time_hour", tsw_sleep_time_hour, sizeof (tsw_sleep_time_hour));
	sc_cfg_get ("tsw_sleep_time_min", tsw_sleep_time_min, sizeof (tsw_sleep_time_min));

	sc_cfg_get ("tsw_wake_time_hour", tsw_wake_time_hour, sizeof (tsw_wake_time_hour));
	sc_cfg_get ("tsw_wake_time_min", tsw_wake_time_min, sizeof (tsw_wake_time_min));
	if (!strcmp (tsw_sleep_time_hour, "") || !strcmp (tsw_sleep_time_min, "") || !strcmp (tsw_wake_time_hour, "")  || !strcmp (tsw_wake_time_min, "")) {
		wf_log (" tsw setting error!");
		return -1;
	}
	wf_log ("timeCur.tm_hour=%d, timeCur.tm_min=%d", timeCur.tm_hour, timeCur.tm_min);
	//begin copy sleep / wake hour & minute into struct timeSleep / timeWake , in order to use func mktime
	timeSleep.tm_hour = atoi (tsw_sleep_time_hour);
	timeSleep.tm_min = atoi (tsw_sleep_time_min);
	timeSleep.tm_sec = 0;//user doesn't consider accuracy as highly as counting into second, here we just make sleep time be 0 second
	timeWake.tm_hour = atoi (tsw_wake_time_hour);
	timeWake.tm_min = atoi (tsw_wake_time_min);
	timeWake.tm_sec = 0;//the principle same as sleep time upstair
	wf_log ("timeSleep.tm_hour=%d, timeSleep.tm_min=%d, timeWake.tm_hour=%d, timeWake.tm_min=%d", timeSleep.tm_hour, timeSleep.tm_min, timeWake.tm_hour, timeWake.tm_min);

	timeC = mktime (&timeCur);
	timeS = mktime (&timeSleep);
	timeW = mktime (&timeWake);

	wf_log ("timeC=%d,timeS=%d,timeW=%d", timeC, timeS, timeW);

	if (timeC == -1 || timeS == -1 || timeW == -1) {
		wf_log (" mktime error");
		return -1;
	}

	if (timeC < timeW) { //cur time < wake time
		tsw_interval_wake = timeW - timeC;
	} else if (timeC == timeW) { //cur time == wake time
		tsw_interval_wake = 1;
	} else if (timeC >  timeW) { //cur time > wake time
		tsw_interval_wake = (timeW - timeC) + 24 * 60 * 60;
	}

	if (timeC < timeS) { //cur time < sleep time
		tsw_interval_sleep = timeS - timeC;
	} else if (timeC == timeS) { //cur time ==  sleep time
		tsw_interval_sleep = 1;
	} else if (timeC > timeS) { //cur time > sleep time
		tsw_interval_sleep = (timeS - timeC) + 24 * 60 * 60;
	}

	itoa (tsw_interval_sleep, tsw_interval_sleep_str, 10);
	itoa (tsw_interval_wake, tsw_interval_wake_str, 10);

	strncpy (p_sleep_str, tsw_interval_sleep_str, 10);
	tsw_interval_sleep_str[9]='\0';
	strncpy (p_wake_str, tsw_interval_wake_str, 10);
	tsw_interval_wake_str[9]='\0';
	sc_cfg_set ("timing_sleep_interval", tsw_interval_sleep_str);
	sc_cfg_set ("timing_wake_interval", tsw_interval_wake_str);

	return 0;
}

//رնʱ߻:
// 1. ʼʱtimerѴڣִд˺ɾtimer
// 2. web ui رնʱ˯߻ѹ
// 3. web uiֶرwifi
void handle_tsw_close()
{
	disable_rtc_tsw_close_timer();
	disable_rtc_tsw_open_timer();
}


//ʱ߻
void handle_tsw_setting()
{
	char openEnable[2] = {0};
	char timing_sleep_interval[12] = {0};
	char timing_wake_interval[12] = {0};
	int iRet = -1;

	sc_cfg_get ("openEnable", openEnable, 2);

	if (strcmp (openEnable, "1") != 0) {
		wf_log ("tsw  is off.");
		return;
	}

	iRet = calculate_tsw_interval2 (timing_sleep_interval, timing_wake_interval);
	if (iRet == -1) {
		wf_log ("calculate_tsw_interval2 is error");
		return;
	}
	handle_tsw_close();//ɾʱ˯߻Ѷʱ

	if (strcmp (timing_sleep_interval, "") == 0 || strcmp (timing_sleep_interval, "0") == 0) {
		wf_log ("timing_sleep_interval is null or 0");
		return;
	}

	if (strcmp (timing_wake_interval, "") == 0 || strcmp (timing_wake_interval, "0") == 0) {
		wf_log ("timing_wake_interval is null or 0");
		return;
	}

	wf_log ("timing_sleep_interval=%s, timing_wake_interval=%s", timing_sleep_interval, timing_wake_interval);
	create_rtc_tsw_close_timer (atoi (timing_sleep_interval));
	create_rtc_tsw_open_timer (atoi (timing_wake_interval));
}

 void wlan_reset_sleep_timer()
{
	char sleep_interval[16] = {0};
	int sleep_int = 0;

	wf_log("sleep_rtc_timer_open=%d", g_sleep_rtc_timer);

	if (g_sleep_rtc_timer) {
		sc_cfg_get("Sleep_interval", sleep_interval, sizeof(sleep_interval));
		disable_rtc_sleep_timer();
		sleep_int = atoi(sleep_interval);
		if(sleep_int < 0 || sleep_int > INT_MAX-1) {//kw 3
			//kw 3, Sleep_interval(min):-1 5 10 20 30 60 120; when -1, g_sleep_rtc_timer == 0; 21600 = 15day
			wf_log("wlan_reset_sleep_timer=%d", sleep_int);
			return;
		}
		create_rtc_sleep_timer(sleep_int);
	}
}
