/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ƶDMģ
* ļƣ mobile_dm.c
* ļʶ
* ժҪ
*
* ޸      汾     ޸ı       ޸       ޸
* ----------------------------------------------------------------------
* 2017           1.0                       chentianming
************************************************************************/

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include <unistd.h>
#include <assert.h>
#include <sched.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include <netdb.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/signal.h>

#include <openssl/aes.h>
#include <openssl/evp.h>
#include <openssl/rsa.h>

#include "include/mobile_dm.h"
#include "softap_api.h"
/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#define SEARCH_STR_RETURN_CODE_HTTPS	 	"200"
#define SEARCH_STR_RESULT_CODE			 	"\"resultCode\":1"
#define HTTP_HEAD_SZIE					  	512
#define DM_PKCS5_SIZE(x)                 	((x)<16? 16:(((x)/16 + 1) * 16))
#define DM_AES_ECB_ENCRYPT_KEY_LENGTH     	128          								/*128 bit Կ md5      */
#define DM_VENDOR_KEY_LENGHT 				16                                          /*̵볤16ֽ    */
#define DM_KEY_FILE_PATH				 	"/etc/file_key"								/*Э̵ļ·         */


#define log(...)            do { printf(__VA_ARGS__); fflush(stdout); } while(0)
#define log_err(...)        do {log("DM-ERR NOW: FILE(%s) , LINE(%d) >>>>: ", __FILE__, __LINE__ );  printf(__VA_ARGS__); fflush(stdout);} while(0)

#define __HTTPS_DEBUG__
#ifdef __HTTPS_DEBUG__
#define log_debug(...)      do {log("dm-debug now : file(%s) ,line(%d) >>>>: ", __FILE__, __LINE__); printf(__VA_ARGS__); fflush(stdout);} while(0)
#else
#define log_debug(...)
#endif

#define CALL(x)         	do { int t_ret = (x); if (t_ret != MOBILE_ERR_SUCCESS) { log_err("Get t_ret(%d)\n", t_ret); return t_ret;} } while(0)
#define CHECK_PARAM(X)  	do {if(X) {log_err("the param is null\n");  return MOBILE_ERR_PARAM_NULL;}                                 } while(0)
#define ASSER_NULL_VOID(X)  do {if(X) {log_err("the param is null\n");  return;               }                                 } while(0)
/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
 *                                                                *
 **************************************************************************/
typedef struct _HTTPS_CONNECTION_INFO_
{
    int socketId;
    int isHttps;
    SSL_METHOD* sslMethod;
    SSL_CTX* sslCtx;
    SSL* ssl;
} HTTPS_CONNECTION_INFO;

typedef enum
{
    HTTP_PROCOT0L  = 1,                 /*HTTP  Э鴫*/
    HTTPS_PROCOT0L = 1 << 1,            /*HTTPS Э鴫*/
    HTTP_UNKNOW_PROCOT0L = 1 << 5
} HTTP_PROCOTL_TYPE;

/*******************ܵݽṹ ********************************/
typedef struct __ENCRYPT_DATA__
{
    char *dataBuffer;
    int dataSize;
} ENCRYPT_DATA;

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/

/**************************************************************************
 *                         ̬                                    *
 **************************************************************************/
static int http_socket_create(HTTPS_CONNECTION_INFO *connectionInfo);
static int https_ssl_init(HTTPS_CONNECTION_INFO *connectionInfo);
static int https_socket_connect(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_URL_INIO *urlInfo);

static int https_socket_send(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_DATA_INFO *sendData);
static int https_socket_recv(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_DATA_INFO *recData);
static void https_protocol_packet_create(DM_MOBILE_HTTPS_URL_INIO *smsUrlInfo, DM_MOBILE_HTTPS_DATA_INFO *sendSrcData, DM_MOBILE_HTTPS_DATA_INFO *httpsPacket);
static void https_socket_close(HTTPS_CONNECTION_INFO *connectionInfo);

static unsigned long dm_get_ip_byhostname(char *hostName);
static char * https_packet_parse(char *srcPackket, char *str);
static int https_request_handle(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_DATA_INFO *httpsPacket, DM_MOBILE_HTTPS_DATA_INFO *recData);

static int dm_aes_ecb_encrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out);
static void dm_hex_print(char *str, int len);
static int dm_aes_ecb_encrypt_panding(const ENCRYPT_DATA *in, const ENCRYPT_DATA  *out);
static int  dm_aes_ecb_pandding(char *in, char *out);
static int dm_aes_ecb_enscrypt(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key);
static int dm_aes_ecb_decrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key);
static void dm_base64_encode(ENCRYPT_DATA *in, ENCRYPT_DATA *out, int withNewLine);
static int dm_aes_get_encrypt_key(unsigned char *useKey);

/**************************************************************************
*                         ̬                                   *
**************************************************************************/
/**
 * ƣ https_packet_parse
 *  ݰַָ
 * ˵
 *   ֵ
 * ˵ ҪŻݽ
 */
static char * https_packet_parse(char *srcPackket, char *str)
{
    if (!srcPackket || !str)
        return NULL;

    return strstr(srcPackket, str);
}

/**
 * ƣ http_socket_create
 *  socketͨ
 * ˵ connectionInfo 洢Ϣṹ
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int http_socket_create(HTTPS_CONNECTION_INFO *connectionInfo)
{
    connectionInfo->socketId = socket(AF_INET, SOCK_STREAM, 0);
    struct timeval  timeOut = {3, 0};
    if (connectionInfo->socketId < 0)
    {
        log_err("can not create socket id \n");
        return  MOBILE_ERR_SOCKET_CREATE_ERROR;
    }

    /*set timeout for reading/writing */
	if(0 != setsockopt(connectionInfo->socketId, SOL_SOCKET, SO_SNDTIMEO, (char*)&timeOut, sizeof(struct timeval)))
    {
		log_err("http_socket_create setsockopt SO_SNDTIMEO err...\n");
	}
    if(0 != setsockopt(connectionInfo->socketId, SOL_SOCKET, SO_RCVTIMEO, (char*)&timeOut, sizeof(struct timeval)))
    {
		log_err("http_socket_create setsockopt SO_RCVTIMEO err...\n");
	}
    return  MOBILE_ERR_SUCCESS;
}

/**
 * ƣ https_ssl_init
 *  sslʼ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int https_ssl_init(HTTPS_CONNECTION_INFO *connectionInfo)
{

    SSL_load_error_strings();
    SSL_library_init();
    connectionInfo->sslMethod = SSLv23_client_method();
    if (!connectionInfo->sslMethod)
    {
        log_err("can not get sslv23_client_method \n");
        return MOBILE_EER_SSL_INIT_ERROR;
    }

    connectionInfo->sslCtx = SSL_CTX_new(connectionInfo->sslMethod);
    if (!connectionInfo->sslCtx)
    {
        log_err("can not new ssl Context, sslCtx is NULL\n");
        return MOBILE_EER_SSL_INIT_ERROR;
    }

    /*tell the client don't verify*/
    SSL_CTX_set_verify(connectionInfo->sslCtx, SSL_VERIFY_NONE, NULL);

    SSL_CTX_set_mode(connectionInfo->sslCtx, SSL_MODE_AUTO_RETRY);
    log_debug("https_ssl_init success \n");

    return MOBILE_ERR_SUCCESS;
}

/**
 * ƣ https_ssl_connect
 *  ssl 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int https_ssl_connect(HTTPS_CONNECTION_INFO* connectionInfo)
{
    int errorCode = 0;
    BIO *sbio = NULL;
    connectionInfo->ssl = SSL_new(connectionInfo->sslCtx);
    if (!connectionInfo->ssl)
    {
        log_err("ssl_new ssl is null\n");
        return MOBILE_ERR_SSL_CONNECT_ERROR;
    }

    sbio = BIO_new_socket(connectionInfo->socketId, BIO_NOCLOSE);
    if (!sbio)
    {
        SSL_free(connectionInfo->ssl);
        SSL_CTX_free(connectionInfo->sslCtx);
        connectionInfo->ssl = NULL;
        connectionInfo->sslCtx = NULL;
        log_err(" BIO_new_socket sbio is null");
        return MOBILE_ERR_SSL_CONNECT_ERROR;
    }

    SSL_set_bio(connectionInfo->ssl, sbio, sbio);
    SSL_set_fd(connectionInfo->ssl, connectionInfo->socketId);

    errorCode = SSL_connect(connectionInfo->ssl);
    if (-1 == errorCode)
    {
        log_err("https_ssl_connect SSL connect fail , errcode(%d)\n", SSL_get_error(connectionInfo->ssl, errorCode));
        if (SSL_get_error(connectionInfo->ssl, errorCode) == 1)
            return MOBILE_ERR_SUCCESS;
        SSL_free(connectionInfo->ssl);
        SSL_CTX_free(connectionInfo->sslCtx);
        connectionInfo->ssl = NULL;
        connectionInfo->sslCtx = NULL;
        return MOBILE_ERR_SSL_CONNECT_ERROR;
    }

    return MOBILE_ERR_SUCCESS;
}

/**
 * ƣ https_socket_connect
 *  https
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int https_socket_connect(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_URL_INIO *urlInfo)
{
    struct sockaddr_in toAddr = {0};
    int ret = 0;
    unsigned long ipAddr = 0;
    static int connectTimes = 0;

    /*first using IP address, sencond using hostName*/
    if (INADDR_NONE == (ipAddr = inet_addr(urlInfo->ipAddr)))
    {
        struct timeval startTime = {0};
        struct timeval endTime = {0};
        //test time now
        gettimeofday(&startTime, NULL);
        ipAddr = dm_get_ip_byhostname(urlInfo->hostName);
        gettimeofday(&endTime, NULL);
        log_debug("https get ip by hostName casting  time (%d) \n", (endTime.tv_sec - startTime.tv_sec) * 1000 + (endTime.tv_usec - startTime.tv_usec) / 1000);
        if (0 == ipAddr)
        {
            log_err("can not find ip addr...\n");
            return MOBILE_ERR_SOCKET_NO_IP;
        }
    }

    toAddr.sin_addr.s_addr = ipAddr;
    toAddr.sin_family	   = AF_INET;
    toAddr.sin_port 	   = htons((unsigned short)urlInfo->portNum);
    bzero(&(toAddr.sin_zero), 8);

    //klockworks issue.
    log_debug("Send IP string (%s), port(%d), IPaddress(%lu), toAddr.sin_addr.s_addr(%d)\n", inet_ntoa(toAddr.sin_addr), urlInfo->portNum, ipAddr, toAddr.sin_addr.s_addr);

    connectTimes = 2;
CONNECT_SOCKET:
    if (-1 == (ret = connect(connectionInfo->socketId, (struct sockaddr *)&toAddr, sizeof(struct sockaddr))))
    {
        while (connectTimes-- > 0)
        {
            close(connectionInfo->socketId);
            connectionInfo->socketId = 0;
            log_debug("http socket connect	connectNum(%d)\n", connectTimes);
            usleep(1000 * 600);
            if (MOBILE_ERR_SUCCESS != (ret = http_socket_create(connectionInfo)))
            {
                log_err("create socket fail \n");
                return MOBILE_ERR_SOCKET_CREATE_ERROR;
            }
            goto CONNECT_SOCKET;

        }

        log_err("https socket connect fail ret(%d), connectNum(%d),  eeror(%d)\n", ret, connectTimes, errno);
        return MOBILE_ERR_SOCKET_CONNECT_ERROR;
    }

    CALL(https_ssl_init(connectionInfo));

    CALL(https_ssl_connect(connectionInfo));
    return MOBILE_ERR_SUCCESS;
}

/**
 * ƣ https_socket_send
 *  https
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static int https_socket_send(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_DATA_INFO *sendData)
{
    int ret = 0;
    int sendLen = sendData->dataLen;
    char *sendBuf = sendData->dataBuffer;
    ret = SSL_write(connectionInfo->ssl, sendBuf, sendLen);
    if (ret <= 0)
    {
        log_err("SSL_write is fail, error code(%d)\n", SSL_get_error(connectionInfo->ssl, ret));
        return MOBILE_ERR_SSL_WRITE_ERROR;
    }

    log_debug("want to send len(%d), realy send len(%d)  \n", sendLen, ret);
    return  MOBILE_ERR_SUCCESS;
}

/**
 * ƣ https_socket_recv
 *  httpsܷ˵ķؽ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static int https_socket_recv(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_DATA_INFO *recData)
{
    int ret = 0;

    CHECK_PARAM(!recData || !recData->dataBuffer);

    char *recvBuf = recData->dataBuffer;
    int recvMaxLen = recData->dataLen;
    memset(recvBuf, 0, recvMaxLen);

    ret = SSL_read(connectionInfo->ssl, recvBuf, recvMaxLen - 1);
    if (ret <= 0)
    {
        log_err("ssl_read is fail,ret(%d),error code (%d) \n ", ret, SSL_get_error(connectionInfo->ssl, ret));
        return MOBILE_ERR_SSL_RECV_ERROR;
    }

    recData->dataLen = ret;
    log_debug("recv msg success , revcbuf-content(%s) ret(%d)\n\n", recvBuf, ret);
    return MOBILE_ERR_SUCCESS;
}


/**
 * ƣ https_socket_close
 *  ssl-socket رղ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static void https_socket_close(HTTPS_CONNECTION_INFO *connectionInfo)
{
    int ret = MOBILE_ERR_SUCCESS;
    if (connectionInfo->ssl != NULL)
    {
        ret = SSL_shutdown(connectionInfo->ssl);
        if (ret != 1)
        {
            log_debug("https have shutdown ret :%d \n", ret);
        }

        SSL_free(connectionInfo->ssl);
        connectionInfo->ssl = NULL;
    }

    if (connectionInfo->sslCtx != NULL)
    {
        SSL_CTX_free(connectionInfo->sslCtx);
        connectionInfo->sslCtx = NULL;
    }

    ERR_free_strings();
    log_debug("SSL close all now  \n");
}

/**
 * ƣ http_request_handle
 *  smsʼ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static int  https_request_handle(HTTPS_CONNECTION_INFO *connectionInfo, DM_MOBILE_HTTPS_DATA_INFO *httpsPacket, DM_MOBILE_HTTPS_DATA_INFO *recData)
{
    /*later should be optimizing */
    char *searchStr = SEARCH_STR_RETURN_CODE_HTTPS;
    char *searchResCode = SEARCH_STR_RESULT_CODE;

    CALL(https_socket_send(connectionInfo, httpsPacket));

    CALL(https_socket_recv(connectionInfo, recData));

    /*recBuffer  200 */
    if (!(https_packet_parse(recData->dataBuffer, searchStr)))
    {
        log_err("can not find the str(%s)\n", searchStr);
        return MOBILE_ERR_SSL_NO_INFO_FIND;
    }

    /*Ѱ "resultCode":2 ַ*/
    if (!https_packet_parse(recData->dataBuffer, searchResCode))
    {
        log_err("can not find the result-code(%s)\n", searchResCode);
        return MOBILE_ERR_SSL_NO_INFO_FIND;
    }

    log_debug("start_request_https success \n");
    return MOBILE_ERR_SUCCESS;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ
 * ˵ 
 */
static void dm_hex_print(char *str, int len)
{
    int i = 0;
    for (i = 0; i < len; i++)
    {
        printf("%s%02x%s", ((i % 16 == 0 ? "|" : "")), *((unsigned char*)str + i), (((i + 1) % 16 == 0) ? "|\n" : " "));
    }
    if (i % 16 != 0)
        printf("|\n");
}

/**
  * ƣ dm_aes_ecb_pandding
  *  pkcs5д
  * ˵
  *   ֵ ɹERR_SUCCESSʧܷӦĴ
  * ˵ 
  */
static int  dm_aes_ecb_pandding(char *in, char *out)
{
    int inSize = 0;
    int i = 0;
    int remainIndex = 0;
    int outSize = 0;

    CHECK_PARAM(!in || !out);

    inSize = strlen(in);
    remainIndex = inSize % 16;
    /* using PKCS5 panding */
    if (inSize < 16)
    {
        char input[16] = {0};
        for (i = 0; i < 16; i++)
        {
            if (i < remainIndex)
            {
                input[i] = in[i];
            }
            else
            {
                input[i] = 16 - inSize; /* */
            }
        }
        outSize = 16;
        if (!strncpy(out, input, 16))
        {
            log_err("aes pandding strncpy erro \n");
            return MOBILE_ERR_PANDDING_ERROR;
        }

    }
    else     /*  16 ֽ 龰*/
    {
        int group = inSize / 16;
        int size = 16 * (group + 1);
        char input[size];
        for (i = 0; i < size; i++)
        {
            if (i < inSize)
            {
                input[i] = in[i];
            }
            else
            {
                if (remainIndex == 0)
                {
                    input[i] = 0x10;

                }
                else
                {
                    int dif = size - inSize;
                    input[i] = dif;
                }
            }
        }

        outSize = size;
        if (!strncpy(out, input, size))
        {
            log_err("aes pandding strncpy erro \n");
            return MOBILE_ERR_PANDDING_ERROR;
        }
    }

    log_debug("aes pad dest data hex output****\n");
    dm_hex_print(out, outSize);

    log_debug("aes pad what hex to data **********\n");
    dm_hex_print(out + outSize - 16, 16);
    return MOBILE_ERR_SUCCESS;
}


/**
 * ƣ dm_aes_ecb_encrypt_panding
 *  ݽpanding 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_encrypt_panding(const ENCRYPT_DATA *in, const ENCRYPT_DATA  *out)
{
    int inSize = 0;
    int ret = 0;

    CHECK_PARAM(!in || !out);

    /* using pkcs5 pandding now
     * first checking the size
     * */
    inSize = out->dataSize;

    memset(out->dataBuffer, 0, inSize);
    if (MOBILE_ERR_SUCCESS != (ret =  dm_aes_ecb_pandding(in->dataBuffer, out->dataBuffer)))
    {
        log_err("dm aes pandding error\n");
        return ret;
    }

    return MOBILE_ERR_SUCCESS;
}


/**
 * ƣ dm_aes_ecb_enscrypt
 *  aes̴ܹ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_enscrypt(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key)
{

    const int enc = AES_ENCRYPT;
    int i = 0;
    char *inDataBuffer = NULL;
    char *outDatabuffer = NULL;
    int inSize = 0;

    CHECK_PARAM(!in || !out || !key);

    inDataBuffer = in->dataBuffer;
    inSize = in->dataSize;
    outDatabuffer = out->dataBuffer;
    /* encrypt now  */
    for (i = 0; i < inSize / 16; i++)
    {
        AES_ecb_encrypt((const unsigned char *)(inDataBuffer + (i * 16)), (unsigned char *)(outDatabuffer + (i * 16)), (const AES_KEY *)key, enc);
    }

    return MOBILE_ERR_SUCCESS;

}

/**
 * ƣ dm_aes_get_encrypt_key
 *  ȡaesܵԿ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_get_encrypt_key(unsigned char *useKey)
{
    FILE *fd = NULL;
    int ret = 0;
    unsigned char md[DM_VENDOR_KEY_LENGHT + 1] = {0};
    CHECK_PARAM(!useKey);

    if ((fd = fopen(DM_KEY_FILE_PATH, "r")) == NULL)
    {
        log_err("open key file error\n");
        return MOBILE_ERR_OPEN_FILE_ERROR;
    }
    if(1 != fread(md, DM_VENDOR_KEY_LENGHT, 1, fd))
    {
		fclose(fd);
    	fd = NULL;
		log_debug("dm_aes_get_encrypt_key fread failed \n");
		return -1;
	}
    
    fclose(fd);
    fd = NULL;
	
    md[DM_VENDOR_KEY_LENGHT] = '\0';
    log_debug("get  key from file(%s)\n", md);

    /*md5-hash */
    if (0 == (ret = EVP_Digest(md, DM_VENDOR_KEY_LENGHT, useKey, NULL, EVP_md5(), NULL)))
    {
        log_err("create md5 fail\n");
        return MOBILE_ERR_CREATE_DM5_KEY_ERRRO;
    }

    log_debug("get key from md5-hash hex-output\n");
    dm_hex_print((char *)useKey, DM_AES_ECB_ENCRYPT_KEY_LENGTH / 8);

    return MOBILE_ERR_SUCCESS;
}

/**
 * ƣ dm_aes_ecb_encrypt_handle
 *  aes̴ܹ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_encrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out)
{
    ENCRYPT_DATA inData = {0};
    AES_KEY key = {0}; //cov h
    int ret = 0;
    unsigned char userKey[DM_AES_ECB_ENCRYPT_KEY_LENGTH / 8 + 1] = {0};
    CHECK_PARAM(!in || !out);

    CALL(dm_aes_get_encrypt_key(userKey));

    if (0 != (ret = AES_set_encrypt_key(userKey, DM_AES_ECB_ENCRYPT_KEY_LENGTH, &key)))
    {
        log_err("create aes encrypt Aes-key fail\n");
        return MOBILE_ERR_CREATE_ENCRYPT_KEY_ERROR;
    }

    inData.dataSize = DM_PKCS5_SIZE((in->dataSize));
    inData.dataBuffer = (char *)malloc(inData.dataSize);
    if (!inData.dataBuffer)
    {
        log_err("encrypt handle malloc error \n");
        return MOBILE_ERR_MEM_ALLOC_ERROR;
    }
    memset(inData.dataBuffer, 0, inData.dataSize);
    if (MOBILE_ERR_SUCCESS != (ret = dm_aes_ecb_encrypt_panding(in, &inData)))
    {
        free(inData.dataBuffer);
        inData.dataBuffer = NULL;
        log_err("dm encrypt fail \n");
        return ret;
    }

    if (MOBILE_ERR_SUCCESS != (ret = dm_aes_ecb_enscrypt(&inData, out, &key)))
    {
        free(inData.dataBuffer);
        inData.dataBuffer = NULL;
        log_err("dm eas ecb encrypt fail \n");
        return ret;
    }

    free(inData.dataBuffer);
    inData.dataBuffer = NULL;
    return MOBILE_ERR_SUCCESS;
}

/**
  * ƣ dm_aes_ecb_decrypt_handle
  *  aes̴
  * ˵
  *   ֵ ɹERR_SUCCESSʧܷӦĴ
  * ˵ 
  */
static int dm_aes_ecb_decrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key)
{
    const int enc = AES_DECRYPT;
    int i = 0;
    char *inDataBuffer = NULL;
    char *outDatabuffer = NULL;
    int inSize = 0;

    CHECK_PARAM(!in || !out || !key);

    inDataBuffer = in->dataBuffer;
    inSize = in->dataSize;
    outDatabuffer = out->dataBuffer;

    for (i = 0; i < inSize / 16; i++)
    {
        AES_ecb_encrypt((const unsigned char *)(inDataBuffer + (i * 16)), (unsigned char *)(outDatabuffer + (i * 16)), (const AES_KEY *) key, enc);
    }

    return MOBILE_ERR_SUCCESS;
}

/**
 * ƣ dm_base64_encode
 *  ܵݽbase64
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static void dm_base64_encode(ENCRYPT_DATA *in, ENCRYPT_DATA *out,	int withNewLine)
{
    BIO * bmem = NULL;
    BIO * b64 = NULL;
    BUF_MEM * bptr = NULL;

    b64 = BIO_new(BIO_f_base64());
    ASSER_NULL_VOID(!b64);

    if (!withNewLine)
    {
        BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
    }
    bmem = BIO_new(BIO_s_mem());
    ASSER_NULL_VOID(!bmem);

    b64 = BIO_push(b64, bmem);
    BIO_write(b64, in->dataBuffer, in->dataSize);
    BIO_flush(b64);
    BIO_get_mem_ptr(b64, &bptr);

    char * buff = (char *)malloc(bptr->length + 1);
    ASSER_NULL_VOID(!buff); //klockworks issue.
    memset(buff, 0, bptr->length + 1);

    memcpy(buff, bptr->data, bptr->length);

    out->dataBuffer = buff;
    out->dataSize = bptr->length;

    BIO_free_all(b64);
    return;
}

/**
 * ƣ dm_https_request_start
 *  dmʼ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static int dm_https_request_start(DM_MOBILE_HTTPS_URL_INIO *urlInfo, DM_MOBILE_HTTPS_DATA_INFO *sendSrcData, DM_MOBILE_HTTPS_DATA_INFO *recData)
{
    HTTPS_CONNECTION_INFO connectionInfo = {0};
    DM_MOBILE_HTTPS_DATA_INFO httpsPacket  = {0};
    ENCRYPT_DATA out = {0};
    ENCRYPT_DATA in = {0};
    ENCRYPT_DATA base64Out = {0};
    int ret = 0;
    char *sendData = NULL;
    CHECK_PARAM(!urlInfo || !recData || !sendSrcData);

    CALL(http_socket_create(&connectionInfo));

    if (MOBILE_ERR_SUCCESS != (ret = https_socket_connect(&connectionInfo, urlInfo)))
    {
        close(connectionInfo.socketId);
        log_err("https_socket_connect is fail, ret-code(%d)\n", ret);
        return ret;
    }

    out.dataSize =  DM_PKCS5_SIZE((sendSrcData->dataLen));
    char outData[out.dataSize];
    out.dataBuffer = outData;
    in.dataBuffer = sendSrcData->dataBuffer;
    in.dataSize = sendSrcData->dataLen;

    ret = dm_aes_ecb_encrypt_handle(&in, &out);
    if(MOBILE_ERR_SUCCESS != ret)
    {
        close(connectionInfo.socketId);
        return ret;
    } //klockworks issue.

#ifdef  DM_FOR_DEBUG_ENCRYPT
    {
        AES_KEY keyTemp;
        ENCRYPT_DATA outTemp = {0};
        unsigned char userKey[DM_AES_ECB_ENCRYPT_KEY_LENGTH / 8 + 1] = {0};

        outTemp.dataSize = out.dataSize;
        char outemData[outTemp.dataSize];
        outTemp.dataBuffer = outemData;

        CALL(dm_aes_get_encrypt_key(userKey));
        /*create the aes decrypt key */
        memset(outTemp.dataBuffer, 0, outTemp.dataSize);

        if (0 != (ret = AES_set_decrypt_key(userKey, DM_AES_ECB_ENCRYPT_KEY_LENGTH, &keyTemp)))
        {
            log_err("create aes encrypt Aes-key fail\n");
            return MOBILE_ERR_CREATE_ENCRYPT_KEY_ERROR;
        }

        /*decrypte the data now */
        CALL(dm_aes_ecb_decrypt_handle(&out, &outTemp, &keyTemp));

        log_debug("get the aes decrypt data *************************\n");
        log_debug("len(%d)\n", outTemp.dataSize);
        dm_hex_print((outTemp.dataBuffer), outTemp.dataSize);

    }
#endif

    dm_base64_encode(&out, &base64Out, 0);

    /*ݷ͵ݰ,httpsЭĳ */
    if (!(sendData = (char *)malloc(DM_HTTPS_HEAD_DATA_LENGTH  + base64Out.dataSize)))
    {
        close(connectionInfo.socketId);//klockworks issue.
        return MOBILE_ERR_PARAM_NULL;
    }
    httpsPacket.dataBuffer = sendData;
    httpsPacket.dataLen = DM_HTTPS_HEAD_DATA_LENGTH + base64Out.dataSize;
    memset(httpsPacket.dataBuffer, 0, httpsPacket.dataLen);

    https_protocol_packet_create(urlInfo, (DM_MOBILE_HTTPS_DATA_INFO *)&base64Out, &httpsPacket);
    ret = https_request_handle(&connectionInfo, &httpsPacket, recData);

    https_socket_close(&connectionInfo);
    close(connectionInfo.socketId);
    free(httpsPacket.dataBuffer);
    httpsPacket.dataBuffer = NULL;
    sendData = NULL;

    /*free base64 buffer */
    free(base64Out.dataBuffer);
    base64Out.dataBuffer = NULL;

    return ret;
}

/**
 * ƣ https_protocol_packet_create
 *  http͵Э,ݵû
 * ˵
 *   ֵ
 * ˵ 
 */
static void https_protocol_packet_create(DM_MOBILE_HTTPS_URL_INIO *dmUrlInfo, DM_MOBILE_HTTPS_DATA_INFO *sendSrcData, DM_MOBILE_HTTPS_DATA_INFO *httpsPacket)
{
    char *url = NULL;
    char *httpsPacketData = NULL;
    char  bufLen[10] = {0};
    ASSER_NULL_VOID(!dmUrlInfo || ! httpsPacket || !sendSrcData); //klockworks issue.

    url  = dmUrlInfo->urlBuffer;
    httpsPacketData = httpsPacket->dataBuffer;

    snprintf(bufLen, sizeof(bufLen) - 1, "%d", sendSrcData->dataLen);

    strcat(httpsPacketData, "POST ");
    strcat(httpsPacketData, url);
    strcat(httpsPacketData, " HTTP/1.1\r\n");

    strcat(httpsPacketData, "Host: ");
    strcat(httpsPacketData, dmUrlInfo->hostName);
    strcat(httpsPacketData, "\r\n");

    strcat(httpsPacketData, "Accept: */*\r\n");
    strcat(httpsPacketData, "Content-Length: ");
    strcat(httpsPacketData, bufLen);
    strcat(httpsPacketData, "\r\n");

    strcat(httpsPacketData, "Content-Type: application/json;charset=utf-8\r\n");
    strcat(httpsPacketData, "\r\n");

    httpsPacket->dataLen = strlen(httpsPacketData);  // the str have no '0' , so can usr strlen's function to calcu the len

    if((sendSrcData->dataBuffer) && (sendSrcData->dataLen != 0))
    {
        memcpy((httpsPacketData + httpsPacket->dataLen), sendSrcData->dataBuffer, sendSrcData->dataLen);
        httpsPacketData[httpsPacket->dataLen + sendSrcData->dataLen] = '\r';
        httpsPacketData[httpsPacket->dataLen + sendSrcData->dataLen + 1] = '\n';
    }

    httpsPacket->dataLen = httpsPacket->dataLen + sendSrcData->dataLen + 2; // strlen("\r\n") = 2;
    log_debug("create http packet now content(%s), len(%d)\n", httpsPacketData, httpsPacket->dataLen);

}

/**
 * ƣ dm_get_ip_byhostname
 * 
 * ˵
 *   ֵ
 * ˵ 
 */
static unsigned long dm_get_ip_byhostname(char *hostName)
{
    struct addrinfo    hints           = { 0 };
    struct addrinfo    *result         = NULL;
    struct addrinfo    *result_pointer = NULL;
    unsigned long ipAddr = 0;
    int ret = 0;
    ret = getaddrinfo(hostName, NULL, &hints, &result);
    if (ret != 0)
    {
        log_debug("can not get ip addr by hostName\n");
        return 0;
    }

    for (result_pointer = result; result_pointer != NULL; result_pointer = result_pointer->ai_next)
    {
        char hostNameTemp[1025] = {0};

        if (result_pointer->ai_family == AF_INET6)
        {
            continue;
        }

        ret = getnameinfo(result_pointer->ai_addr, result_pointer->ai_addrlen, hostNameTemp, sizeof hostNameTemp, NULL, 0, NI_NUMERICHOST);
        if (ret != 0)
        {
            log_debug("error in getnameinfo: %s.\n", gai_strerror(ret));
            continue;
        }

        log_debug("Server ip = %s.\n", hostNameTemp);
        ipAddr = (unsigned long)inet_addr(hostNameTemp);
        freeaddrinfo(result); //klockworks issue.
        return ipAddr;
    }
    freeaddrinfo(result); //klockworks issue.
    return 0;
}

/**************************************************************************
 *                        ȫֺ                                    *
 **************************************************************************/
/**
 * ƣ dm_mobile_https_request
 *  dmύעϢݹ
 * ˵
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷӦĴ
 * ˵ 
 */
int dm_mobile_https_request(DM_MOBILE_HTTPS_URL_INIO *urlInfo, DM_MOBILE_HTTPS_DATA_INFO *sendSrcData)
{
    DM_MOBILE_HTTPS_DATA_INFO recData = {0};
    char recDataBuffer[HTTP_HEAD_SZIE] = {0};

    CHECK_PARAM(!urlInfo || !sendSrcData || !sendSrcData->dataBuffer);

    log_debug("*************debug info**********************************");
    log_debug("url info urlBuffer(%s), portNum(%d), ipAdress(%s), hostName(%s), urlLen(%d)\n",
              urlInfo->urlBuffer, urlInfo->portNum, urlInfo->ipAddr, urlInfo->hostName,  urlInfo->urlLen);
    log_debug("sendSrcdata(%s), sendSrcData->dataLen(%d)\n", sendSrcData->dataBuffer, sendSrcData->dataLen);

    memset(recDataBuffer, 0, HTTP_HEAD_SZIE);
    recData.dataBuffer = recDataBuffer;
    recData.dataLen = HTTP_HEAD_SZIE;

    CALL(dm_https_request_start(urlInfo, sendSrcData, &recData));
    return MOBILE_ERR_SUCCESS;
}

