#include "cfg_api.h"
#include <time.h>

//InternetGatewayDevice.Time

int cpe_get_igd_time_ntpserver0(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char tmp[64+1] = {0};

	sc_cfg_get("sntp_server0", tmp, sizeof(tmp)-1);

	*value = pool_pstrdup(pool, tmp);

    return	FAULT_CODE_OK;

}


int cpe_set_igd_time_ntpserver0(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
	sc_cfg_set("sntp_server0", value);
	sc_cfg_save();
    return FAULT_CODE_OK;
}


int cpe_get_igd_time_ntpserver1(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char tmp[64+1] = {0};

	sc_cfg_get("sntp_server1", tmp, sizeof(tmp)-1);

	*value = pool_pstrdup(pool, tmp);

    return	FAULT_CODE_OK;

}

int cpe_set_igd_time_ntpserver1(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
	sc_cfg_set("sntp_server1", value);
	sc_cfg_save();
    return FAULT_CODE_OK;
}


int cpe_get_igd_time_ntpserver2(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char tmp[64+1] = {0};

	sc_cfg_get("sntp_server2", tmp, sizeof(tmp)-1);

	*value = pool_pstrdup(pool, tmp);

    return	FAULT_CODE_OK;

}



int cpe_set_igd_time_ntpserver2(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
	sc_cfg_set("sntp_server2", value);
	sc_cfg_save();
    return FAULT_CODE_OK;
}



int cpe_get_igd_time_currentlocaltime(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
	char tmp[64+1] = {0};

    struct tm *ptm;
    time_t tn;

    tn = time(NULL);
#ifdef WIN32
    cwmp_log_debug("inform datatime");
    memset(t, 0, sizeof(struct tm));
#else
    ptm = localtime(&tn);
    if(NULL == ptm)
    {
        cwmp_log_error("localtime return NULL");
		*value = pool_pstrdup(pool, "1900-00-00T00:00:00");
		return	FAULT_CODE_OK;
    }
#endif

    TRsnprintf(tmp, sizeof(tmp)-1, "%4d-%02d-%02dT%02d:%02d:%02d",
               ptm->tm_year + 1900,
               ptm->tm_mon,
               ptm->tm_mday,
               ptm->tm_hour,
               ptm->tm_min,
               ptm->tm_sec);	


	*value = pool_pstrdup(pool, tmp);

    return	FAULT_CODE_OK;
}



int cpe_get_igd_time_localtimezone(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char tmp[64+1] = {0};

	sc_cfg_get("sntp_timezone_index", tmp, sizeof(tmp)-1);

	*value = pool_pstrdup(pool, tmp);

    return	FAULT_CODE_OK;

}



int cpe_get_igd_time_localtimezonename(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char tmp[64+1] = {0};

	sc_cfg_get("sntp_timezone", tmp, sizeof(tmp)-1);

	*value = pool_pstrdup(pool, tmp);

    return	FAULT_CODE_OK;

}






