/**
* @file main.c
* @brief fota
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*
*/


/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <dirent.h>
#include <getopt.h>
#include <unistd.h>

//#include "upi_log.h"
#include "zxic_fota_ab_upgrade.h"
//#include "upi_fotaflag_partition.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/

#define POWER_WAKE_LOCK_FILE			("/sys/power/wake_lock")
#define POWER_WAKE_UNLOCK_FILE			("/sys/power/wake_unlock")
#define FOTA_UPGRADE_LOCK				("fota_upgrade_lock")

#define FOTA_UPI_VERIFY					("verify")
#define FOTA_UPI_UPDATE					("update")


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

typedef struct
{
    int	option_value;
    int (*func)(char *);
} option_handle_t;



/*******************************************************************************
 *                       Static function declarations                          *
 ******************************************************************************/


static int excute_command_upgrade(char * option_para);
static int excute_command_get_current_system(char * option_para);
static int excute_command_set_boot_to_system(char * option_para);
static int excute_command_get_boot_to_system(char * option_para);
static int excute_command_get_status(char * option_para);
static int excute_command_get_system_info(char * option_para);
static int excute_command_set_system1_status(char * option_para);
static int excute_command_set_system2_status(char * option_para);
static int excute_command_get_fota_status(char * option_para);
static int excute_command_set_fota_status(char * option_para);
static int excute_command_help(char * option_para);
static int execute_command_version(char * option_para);
static int execute_command_sync(char *option_para);
static int execute_command_get_upgrade_type(char *option_para);
static int execute_command_get_sync_status(char * option_para);
static int execute_command_set_sync_status(char * option_para);
static int execute_command_config_package_path(char * option_para);
static int execute_command_config_log_path(char * option_para);


/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/

/*----------Command parser begin---------------------------------------------------------*/

static char * g_short_string = "u:cgb:sio:t:qr:hvypne:a:l:";

static struct option g_long_options[] =
{
    {"upgrade",				required_argument,	NULL,	'u'},
    {"get-current",			no_argument,		NULL,	'c'},
    {"get-boot",				no_argument,		NULL,	'g'},
    {"set-boot",				required_argument,	NULL,	'b'},
    {"get-upgrade_status",		no_argument,		NULL,	's'},
    {"get-system-info",		no_argument,		NULL,	'i'},
    {"set-system1-status",		required_argument,	NULL,	'o'},
    {"set-system2-status",		required_argument,	NULL,	't'},
    {"get-fota-status",     no_argument,       NULL, 'q'},
    {"set-fota-status",     required_argument, NULL, 'r'},
    {"help",					no_argument,		NULL,	'h'},
    {"version",				no_argument,		NULL,	'v'},
    {"sync",				no_argument,			NULL,	'y'},
    {"get-upgrade-type",	no_argument,			NULL,	'p'},
    {"get-sync-status",		no_argument,			NULL,	'n'},
    {"set-sync-status",		required_argument,		NULL,	'e'},
    {"config-package-path",		required_argument,		NULL,	'a'},
    {"config-log-path",		required_argument,		NULL,	'l'},
    {0, 0, 0, 0}
};

static option_handle_t g_option_handle[] =
{
    {'u',		excute_command_upgrade},
    {'c',		excute_command_get_current_system},
    {'g',		excute_command_get_boot_to_system},
    {'b',		excute_command_set_boot_to_system},
    {'s',		excute_command_get_status},
    {'i',		excute_command_get_system_info},
    {'o',		excute_command_set_system1_status},
    {'t',		excute_command_set_system2_status},
    {'q',		excute_command_get_fota_status},
    {'r',		excute_command_set_fota_status},
    {'h',		excute_command_help},
    {'v',		execute_command_version},
    {'y',		execute_command_sync},
    {'p',		execute_command_get_upgrade_type},
    {'n',		execute_command_get_sync_status},
    {'e',		execute_command_set_sync_status},
    {'a',		execute_command_config_package_path},
    {'l',		execute_command_config_log_path}
};


/*----------Command parser end----------------------------------------------------------*/



/*******************************************************************************
 *                       Static function define                          *
 ******************************************************************************/




static void usage(void)
{
    printf("fota_upi  [-cgsiqhvypn] [-u <target>][-b <boot to system>][-otr <system info>][-e <sync status>]\n "
           "  -u,  --upgrade               verify or update \n"
           "  -c , --get-current           get current system \n"
           "  -g , --get-boot              get boot to system \n"
           "  -b,  --set-boot              set boot to system \n"
           "  -s,  --get-status            get system status \n"
           "  -i,  --get-system-info       get system info \n"
           "  -o,  --set-system1-status    set system1 status info \n"
           "  -t,  --set-system2-status    set system2 status info \n"
           "  -q,  --get-fota-status       get fota status to show if need sync NV when next reboot, 0:no 1:yes \n"
           "  -r,  --set-fota-status       set fota status to show if need sync NV when next reboot, 0:no 1:yes \n"
           "  -h , --help                  show this usage text\n"
           "  -v,  --version               show current version \n"
           "  -y,  --sync               	sync \n"
           "  -p,  --get-upgrade-type      get upgrade type \n"
           "  -n,  --get-sync-status       get sync status \n"
           "  -e,  --set-sync-status       set sync status \n"
           "  -a,  --config-package-path   config package path \n"
           "  -l,  --config-log-path       config log path \n");
}

z_upgrade_status_info_t g_upgrade_status;
void g_flush_upgrade_status(z_upgrade_status_info_t *p_status)
{
    //	LOG_FUNC_BEGIN
    printf("Current status:%d \n", p_status->upgrade_status);

    printf("Total size:%d \n", p_status->total_size);

    printf("Updated size:%d \n", p_status->upgraded_size);
    //	LOG_FUNC_END
}


/*----------Command parser function begin------------------------------------------------*/
static int excute_command_upgrade(char * option_para)
{
    int ret = -1;

    if (NULL == option_para)
    {
        usage();
        printf("Command input invalid! null input upgrade para, please choose verify or recovery or system! \n");
        return -1;
    }


    if (0 == strcmp(FOTA_UPI_VERIFY, option_para))
    {
        printf("Begin to verify upgrade package \n");
        ret = zxic_dual_verify();
    }
    else if (0 == strcmp(FOTA_UPI_UPDATE, option_para))
    {
        //		ret = upi_update();
        z_upgrade_flush_status_t flush_status;
        z_upgrade_status_info_t status ;
        memset(&status, 0, sizeof(z_upgrade_status_info_t));
        flush_status.status = &status;
        flush_status.status_cb = &g_flush_upgrade_status;
        ret = zxic_dual_upgrade(&flush_status);
    }
    else
    {
        printf("Unknow input upgrade para, verify or  update! \n");
        return -1;
    }


    return ret;
}


static int excute_command_get_current_system(char * option_para)
{
    int current = zxic_dual_get_current_system();

    printf("Current system:0x%08X[%d] \n", current, current);

    return current;
}


static int excute_command_get_boot_to_system(char * option_para)
{
    int boot_to = zxic_dual_get_boot_to_system();

    printf("Boot to system:0x%08X[%d]\n", boot_to, boot_to);

    return 0;
}

static int excute_command_set_boot_to_system(char * option_para)
{
    int ret = 0;

    if (NULL == option_para)
    {
        usage();
        printf("Command input invalid value! null option parameters! \n");
        return -1;
    }

    ret = zxic_dual_set_boot_to_system(atoi(option_para), 0);
    if (ret < 0)
    {
        printf("Set boot to [%s] error \n", option_para);
    }

    return ret;
}


static int excute_command_get_status(char *option_para)
{
    z_upgrade_status_info_t status;
    if (zxic_dual_get_upgrade_status(&status) < 0)
    {
        printf("Get upgrade status fail! \n");
        return -1;
    }

    printf("Current upgrade info: \n");
    printf("Current upgrade status:%d \n", status.upgrade_status);
    printf("Current upgrade total size:%d \n", status.total_size);
    printf("Current upgrade updated size:%d \n", status.upgraded_size);

    return 0;
}

static int excute_command_get_system_info(char * option_para)

{
    z_upgrade_system_info_t system_info;
    if (zxic_dual_get_system_status(&system_info) < 0)
    {
        printf("Get upgrade status fail! \n");
        return -1;
    }
    else
    {
        printf("System info: \n");
        printf("Boot to:0x%08X[%d] \n", system_info.boot_to, system_info.boot_to);
        printf("Fota status:%d \n", system_info.fota_status);
        printf("System1 system:0x%08X [%d] \n", system_info.system_1.system, system_info.system_1.system);
        printf("System1 status:%d \n", system_info.system_1.status);
        printf("System1 try_cnt:%d \n", system_info.system_1.try_cnt);
        printf("System2 system:0x%08X [%d] \n", system_info.system_2.system, system_info.system_2.system);
        printf("System2 status:%d \n", system_info.system_2.status);
        printf("System2 try_cnt:%d \n", system_info.system_2.try_cnt);
    }


    return 0;
}


static int excute_command_set_system1_status(char * option_para)
{
    int ret = -1;
    if (NULL == option_para)
    {
        usage();
        printf("Command input invalid value! null option parameters! \n");
        return -1;
    }

    ret = zxic_dual_set_system_status(34650, atoi(option_para));
    if (ret < 0)
    {
        printf("Set system 1 status to [%s] error \n", option_para);
    }

    return ret;
}

static int excute_command_set_system2_status(char * option_para)
{
    int ret = -1;
    if (NULL == option_para)
    {
        usage();
        printf("Command input invalid value! null option parameters! \n");
        return -1;
    }

    ret = zxic_dual_set_system_status(39019, atoi(option_para));
    if (ret < 0)
    {
        printf("Set system 2 status to [%s] error \n", option_para);
    }

    return ret;
}

static int excute_command_get_fota_status(char * option_para)
{
    int status = zxic_dual_get_fota_status_for_nv();

    printf("Fota status:%d \n", status);

    return 0;
}

static int excute_command_set_fota_status(char * option_para)
{
    int ret = 0;

    if (NULL == option_para)
    {
        usage();
        printf("Command input invalid value! null option parameters! \n");
        return -1;
    }

    ret = zxic_dual_set_fota_status_for_nv(atoi(option_para));
    if (ret < 0)
    {
        printf("Set fota_status to [%s] error \n", option_para);
    }

    return ret;
}


static int excute_command_help(char * option_para)
{
    usage();
    return 0;
}





static int execute_command_version(char *option_para)
{
    int version = 0;


    return version;
}





static int execute_command_sync(char *option_para)
{
    int ret = -1;

    ret = zxic_dual_sync_system();

    return ret;
}





static int execute_command_get_upgrade_type(char *option_para)
{
    int upgrade_type = -1;

    upgrade_type = zxic_dual_get_upgrade_type();
    printf("upgrade type is %d\n", upgrade_type);

    return 0;
}


static int execute_command_get_sync_status(char * option_para)
{
    int sync_status = -2;

    zxic_dual_get_sync_status(&sync_status);
    printf("Current sync status is %d\n", sync_status);

    return 0;
}


static int execute_command_set_sync_status(char * option_para)
{
    int ret = -1;

    if (NULL == option_para)
    {
        usage();
        printf("Command input invalid value! null option parameters! \n");

        return ret;
    }

    ret = zxic_dual_set_sync_status(atoi(option_para));
    if (0 != ret)
    {
        printf("set sync status fail\n");

        return ret;
    }

    ret = 0;

    return ret;
}


static int execute_command_config_package_path(char * option_para)
{
    if (NULL == option_para)
    {
        printf("Invalid command input: NULL option parameters \n");
        usage();

        return -1;
    }

    if (-1 == zxic_dual_config_package_path(option_para, strlen(option_para)))
    {
        printf("Configure upgrade package path fail \n");
        return -1;
    }

    printf("Configure upgrade package path success \n");

    return 0;
}


static int execute_command_config_log_path(char * option_para)
{
    if (NULL == option_para)
    {
        printf("Invalid command input: NULL option parameters \n");
        usage();

        return -1;
    }

    if (-1 == zxic_dual_config_log_path(option_para, strlen(option_para)))
    {
        printf("Configure log path fail \n");
        return -1;
    }

    printf("Configure log path success \n");

    return 0;
}


/*----------Command parser function end---------------------------------------------------*/


/**
 * @brief		дļ
 * @param	filepath:	ļ·
 * @param	setbuf:	д
 * @return	NA
 * @retval
 * @note
 */
static void write_lockfile(char *filepath, char *setbuf)
{
    int f, len = 0;

    f = open(filepath, O_RDWR | O_SYNC);
    if (f == -1)
    {
        perror("open lock  failed\n");
        return;
    }

    len = strlen(setbuf);

    if (write(f, setbuf, len) != len)
    {
        perror("write  lock failed\n");
    }

    close(f);
}

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/

int main(int argc, char *argv[])
{
    int i				= 0;
    int option_index	= 0;
    int cmd_num		= 0;

    int ret			= -1;
    int ch			= -1;

    printf("build date: %s %s\n", __DATE__, __TIME__);


    write_lockfile(POWER_WAKE_LOCK_FILE, FOTA_UPGRADE_LOCK);

    while ((ch = getopt_long(argc, argv, g_short_string, g_long_options, &option_index)) != -1)
    {
        for (i = 0; i < sizeof(g_option_handle) / sizeof(option_handle_t); i++)
        {
            if (ch != g_option_handle[i].option_value)
            {
                continue;
            }


            cmd_num++;

            if (NULL == g_option_handle[i].func)
            {
                printf("Command short string is:%c, but option handle func is NULL", ch);
                break;
            }

            ret = g_option_handle[i].func(optarg);

            if (ret < 0)
            {
                ret = -1;
                goto end;
            }
        }
    }

    if (0 == cmd_num)
    {
        printf("Can not find valid command!");
        usage();
        ret = -1;
        goto end;
    }

    ret = 0;

end:

    write_lockfile(POWER_WAKE_UNLOCK_FILE, FOTA_UPGRADE_LOCK);

    return ret ;

}



