/**
 * @file pb_msg.h
 * @brief ƬӦöṩϢṹ壬Ҫʹ߰webservertro69Ӧ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __PB_MSG_H__
#define __PB_MSG_H__

#include "message.h"

#define ZPB_GROUP_SIZE          32
#define ZPB_SNE_SIZE            32

#ifndef ZPB_MAX_DEL_LEN
#define ZPB_MAX_DEL_LEN 50
#endif

#ifndef ZPB_NUM_SIZE
#define ZPB_NUM_SIZE (ZPB_MAX_NUM_LENGTH+2)  /* + and null for string */
#endif

#ifndef ZPB_MAX_NUM_LENGTH
#define ZPB_MAX_NUM_LENGTH   40
#endif

//name length
#ifndef ZPB_MAX_TEXT_LENGTH
#define ZPB_MAX_TEXT_LENGTH 90
#endif

#ifndef ZPB_TEXT_SIZE_CHARS
#define ZPB_TEXT_SIZE_CHARS (ZPB_MAX_TEXT_LENGTH+1)              /* Null terminated string */
#endif

#ifndef ZPB_TEXT_SIZE_BYTES
#define ZPB_TEXT_SIZE_BYTES (ZPB_TEXT_SIZE_CHARS*sizeof(short)) /* size in bytes */
#endif

enum pb_msg_cmd {
	MSG_CMD_WRITE_PB = MSG_CMD_PB_BASE,//һƬУӦṹT_zPb_WebContact
	MSG_CMD_DEL_A_PB,                  //ӦṹT_zPb_DelInfo
	MSG_CMD_DEL_MUTI_PB,               //ӦṹT_zPb_DelInfo
	MSG_CMD_DEL_ALL_PB,                //ӦṹT_zPb_DelInfo
};

typedef struct {
	signed long      pbId;   //the id in the pbm table,unique,ASC
	signed long      pbIndex;
	signed long      pbLocation;
	char        name[ZPB_TEXT_SIZE_BYTES];
	char        mobilNumber[ZPB_NUM_SIZE];
	signed long      pbType;
	char        homeNumber[ZPB_NUM_SIZE];
	char        officeNumber[ZPB_NUM_SIZE];
	char        email[ZPB_TEXT_SIZE_BYTES];
	char        sne[ZPB_SNE_SIZE];
	char        group[ZPB_GROUP_SIZE];
	signed long      del_id;
} T_zPb_WebContact;

typedef struct {
	signed long  delId[ZPB_MAX_DEL_LEN];
	signed long  delTotal;
	signed long  delLocation;
	signed long  delIndex[ZPB_MAX_DEL_LEN];
} T_zPb_DelInfo;

#endif
