/**
 * @file ref_nv_def.h
 * @brief ṩnv궨
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
 
#ifndef __REF_NV_DEF__
#define __REF_NV_DEF__

#include "RWNvConfig.h"
#include "libcpnv.h"

/******************************
  7520 NVRW׵ַ
*******************************/
#define ZPS_REF_MSINFO_REFDESIGN_BASE_ADDR                                (OS_FLASH_REF_DESIGN_RW_OFFSET_FROM_NV)

/******************************
  οû3K
*******************************/
#define NVRW_REF_NV_USER_OFFSET_SIZE                           (3 * 1024)

/******************************
  ο˽8K
  NVRWʼַƫƵַΪ0x100C00
*******************************/
#define NVRW_REF_NV_PRIVATE_OFFSET_ADDRESS                     (ZPS_REF_MSINFO_REFDESIGN_BASE_ADDR + NVRW_REF_NV_USER_OFFSET_SIZE)
#define NVRW_REF_NV_PRIVATE_OFFSET_SIZE                        (8 * 1024)


/******************************
  ο˽NV滮8K
*******************************/
#define ZPS_REF_MSINFO_SOFTVERSION_INT_BASE_ADDR              (NVRW_REF_NV_PRIVATE_OFFSET_ADDRESS)
#define ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN                (unsigned char)100        /*ڲ汾󳤶*/

#define ZPS_REF_MSINFO_SOFTVERSION_EXT_BASE_ADDR              (ZPS_REF_MSINFO_SOFTVERSION_INT_BASE_ADDR + ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN)
#define ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN                (unsigned char)100        /*ⲿ汾󳤶*/

#define ZPS_REF_MSINFO_HARDWAREVERSION_BASE_ADDR              (ZPS_REF_MSINFO_SOFTVERSION_EXT_BASE_ADDR + ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN)
#define ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN                (unsigned char)100        /*Ӳ汾󳤶*/

#define	ZPS_REF_MSINFO_PHONE_INT_BASE_ADDR                    (ZPS_REF_MSINFO_HARDWAREVERSION_BASE_ADDR + ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN)
#define	ZPS_REF_MSINFO_MAX_PHONE_INT_LEN                      (unsigned char)32         /*ڲ󳤶*/

#define	ZPS_REF_MSINFO_PHONE_EXT_BASE_ADDR                    (ZPS_REF_MSINFO_PHONE_INT_BASE_ADDR + ZPS_REF_MSINFO_MAX_PHONE_INT_LEN)
#define	ZPS_REF_MSINFO_MAX_PHONE_EXT_LEN                      (unsigned char)32         /*ⲿ󳤶*/

#define ZPS_REF_MSINFO_SSID_BASE_ADDR                         (ZPS_REF_MSINFO_PHONE_EXT_BASE_ADDR + ZPS_REF_MSINFO_MAX_PHONE_EXT_LEN)
#define ZPS_REF_MSINFO_MAX_SSID_LEN                           (unsigned char)100        /*ZTE_WIRELESS_MACַλ*/

#define ZPS_REF_MSINFO_CGMI_BASE_ADDR                         (ZPS_REF_MSINFO_SSID_BASE_ADDR + ZPS_REF_MSINFO_MAX_SSID_LEN)
#define ZPS_REF_MSINFO_MAX_CGMI_LEN                           (unsigned char)100        /*Ϣ*/

#define ZPS_REF_MSINFO_NEWWIFIKEY_BASE_ADDR                   (ZPS_REF_MSINFO_CGMI_BASE_ADDR + ZPS_REF_MSINFO_MAX_CGMI_LEN)
#define ZPS_REF_MSINFO_MAX_NEWWIFIKEY_LEN                     (unsigned char)65        /*wifikey*/

#define ZPS_REF_MSINFO_UNLOCKTIMES_BASE_ADDR                  (ZPS_REF_MSINFO_NEWWIFIKEY_BASE_ADDR + ZPS_REF_MSINFO_MAX_NEWWIFIKEY_LEN)
#define ZPS_REF_MSINFO_MAX_UNLOCKTIMES_LEN                    (unsigned char)4        /**/

#define ZPS_REF_MSINFO_PLATFORM_END							  (ZPS_REF_MSINFO_UNLOCKTIMES_BASE_ADDR + ZPS_REF_MSINFO_MAX_UNLOCKTIMES_LEN)

///======˴NVΪƽ̨ڲNVģNVڸģڲӶ

#define ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR                  (ZPS_REF_MSINFO_PLATFORM_END)
#define ZPS_REF_MSINFO_MAX_VERSIONMODE_LEN                    (unsigned char)1        /*汾ģʽͣ汾/Ҳ汾*/

#define ZPS_REF_MSINFO_ZISMS_BASE_ADDR                  	  (ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR + ZPS_REF_MSINFO_MAX_VERSIONMODE_LEN)
#define ZPS_REF_MSINFO_MAX_ZISMS_LEN                    	  (unsigned char)1        /*ܶŹܿ*/

#define ZPS_REF_MSINFO_WEBKEY_FLAG_BASE_ADDR                  (ZPS_REF_MSINFO_ZISMS_BASE_ADDR + ZPS_REF_MSINFO_MAX_ZISMS_LEN)
#define ZPS_REF_MSINFO_MAX_WEBKEY_FLAG_LEN                    (unsigned char)1        /*ʹnvhttpsԿ*/

#define ZPS_REF_MSINFO_WEBKEY_DATA_BASE_ADDR                   (ZPS_REF_MSINFO_WEBKEY_FLAG_BASE_ADDR + ZPS_REF_MSINFO_MAX_WEBKEY_FLAG_LEN)
#define ZPS_REF_MSINFO_MAX_WEBKEY_DATA_LEN                     (unsigned char)2048        /*httpsԿ*/

#define REF_REF_NV_END                                        (NVRW_REF_NV_PRIVATE_OFFSET_ADDRESS + NVRW_REF_NV_PRIVATE_OFFSET_SIZE - 1)/*ƹNVַ0x2BFF*/


#endif

