#ifndef DOXYGEN_SHOULD_SKIP_THIS
/*! \mainpage
 *
 * <pre>
 * ZX7520V3ƽ̨APӿڣͷļ
 * softap_api.h ϲӦùͷļϲӦÿļ
 * message.h    ӦùϢkey, Ϣ, ϢID, ϢAPIӿ
 * softap_log.h ϲӦlogؽӿ
 * netapi.h     ģ⹫ӿ
 * cfg_api.h    APӦNVдӿ
 * soft_timer.h ʱӿ
 * rtc_timer.h:   rtcʱӿڣʵʱʱỽϵͳ
 * at_msg.h     at_ctlģϢidϢṹ
 * at_reg.h     at_ctlģͻ˺ͷעӿ
 * at_utils.h   at_ctlģATࡢѯӦӿ
 * user_msg.h   ATͻˡ˿ʾ룬ο
 * </pre>
 */
#endif

/**
 * @file softap_api.h
 * @brief ϲӦùͷļϲӦÿļ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __SOFTAP_API_H__
#define __SOFTAP_API_H__

#include "os_type_def.h"
#include "zxic_list.h"
#include "cfg_api.h"
#include "rtc_timer.h"
#include "soft_timer.h"
#include "wlan_interface.h"
#include "zxic_errno.h"
#include "netapi.h"
#include "netioctl.h"
#include "netotherapi.h"
#include "at_reg.h"
#include "at_utils.h"
#include "at_msg.h"
#include "at_pdp_api.h"
#include "at_other_api.h"
#include "sms_msg.h"
#include "pb_msg.h"
#include "mainctl_msg.h"
#include "mmi_msg.h"
#include "wifi_msg.h"
#include "other_msg.h"
#include "max_macro.h"
#include <syslog.h>
#include "softap_log.h"
#include "audio_res_ctrl.h"
#include "lq_msg.h"
#include <sys/prctl.h>
#include <sys/sysinfo.h>

#define _GNU_SOURCE

/**
* @brief ƽ̨
* 3GPP׼ATĴ뷶Χ0-277, 6000-8000,ԭɲ鿴ZX297520V3ƽ̨ATֲ.doc¼A
* @param AT_PARSE_OK				parse_paramȷ
* @param ATERR_ZXIC_ERR				΢оƬ쳣޷ָҪ
* @param ATERR_PARAM_INVALID		ϸڲԣAT
* @param ATERR_NOT_ALLOWED			ҵ̳ͻ
* @param ATERR_PROC_FAILED			ʧܣsoftapϵͳ쳣Ϣʧܵ
* @param ATERR_DROP_MARK			˫ŶʧһǶɵƫ
* @param ATERR_NO_PRINT				ַݷASCIIģǶɵƫ
* @param ATERR_STR_TOO_LONG			ASCIIַȡĳȳԼĳȣⲿATϷ
* @param ATWARN_DROP_RN				ʵַfmtʽǵֻĲֲúֵ
* @param ATWARN_LACK_PARAM			θʽfmtȱٲڲѡģʹøúֵ
* @param ATERR_MEM_LESS				΢оƬڲڴ治޷յǰAT
* @param ATERR_WAIT_REQ_END_TIMEOUT	ȴⲿREQ\rʱ
* @param ATERR_WAIT_RSP_TIMEOUT		AT󣬵ȴԶRSPӦʱ
* @param ATERR_CHANNEL_BUSY			ǰATͨڴATյһAT󱨴
* @param ATERR_UNKNOWN_CMD			ⲿʶΪǷAT
* @param ATERR_PARAM_CHECKSUM		ڽյATchecksumУʧ
* @param ATERR_PPP_FILE_FAILED		PPPļʧ
* @param ATERR_PPP_NOT_EXISTED		PPPD
* @param ATERR_PPP_WRONG_CHAN		PPPͨ
* @param ATERR_PDP_IPADDR_FAILED	ȡPDPַʧ
* @param USER_EXTAND_ERR_BASE		9000ΪⲿMCUصĶƴ룬ҪⲿMCUûմݴ
*/
enum SAP_ERR {
    AT_PARSE_OK             = 0,      /*parse_paramȷ*/
    ATERR_ZXIC_ERR          = 8000,   /*΢оƬ쳣޷ָҪ*/
    ATERR_PARAM_INVALID     = 8001,   /*ϸڲԣAT*/
    ATERR_NOT_ALLOWED       = 8002,   /*ҵ̳ͻ*/
    ATERR_PROC_FAILED       = 8003,   /*ʧܣsoftapϵͳ쳣Ϣʧܵ*/
    ATERR_DROP_MARK         = 8004,   /*˫ŶʧһǶɵƫ*/
    ATERR_NO_PRINT          = 8005,   /*ַݷASCIIģǶɵƫ*/
    ATERR_STR_TOO_LONG      = 8006,   /*ASCIIַȡĳȳԼĳȣⲿATϷ*/
    ATWARN_DROP_RN          = 8007,   /*ʵַfmtʽǵֻĲֲúֵ*/
    ATWARN_LACK_PARAM       = 8008,   /*θʽfmtȱٲڲѡģʹøúֵ*/
    ATERR_MEM_LESS          = 8009,   /*΢оƬڲڴ治޷յǰAT*/
    ATERR_WAIT_REQ_END_TIMEOUT = 8010, /*ȴⲿREQ\rʱ*/
    ATERR_WAIT_RSP_TIMEOUT  = 8011,   /*AT󣬵ȴԶRSPӦʱ*/
    ATERR_CHANNEL_BUSY      = 8012,   /*ǰATͨڴATյһAT󱨴*/
    ATERR_UNKNOWN_CMD       = 8013,   /*ⲿʶΪǷAT*/
    ATERR_PARAM_CHECKSUM    = 8014,   /*ڽյATchecksumУʧ*/
    ATERR_PPP_FILE_FAILED   = 8100,   /*PPPļʧ*/
    ATERR_PPP_NOT_EXISTED   = 8101,   /*PPPD*/
    ATERR_PPP_WRONG_CHAN    = 8102,   /*PPPͨ*/
    ATERR_PDP_IPADDR_FAILED = 8200,   /*ȡPDPַʧ*/
    USER_EXTAND_ERR_BASE    = 9000,   /*9000ΪⲿMCUصĶƴ룬ҪⲿMCUûմݴ*/
};


/**
 * @brief Ϊ˵յat_parasΪAT׵ַrsp_cmdΪӦַΪδڣһģûڸýӿڵľʵʱ
 * ڲparse_paramӿڽвݷֵвЧԼ飬ԷֹⲿMCUZXICоƬͨ쳣ATݴ
 * ͬӦչAT󣬱ڽӿڲΪrsp_cmdڴռ䣬ֵмϱͽ룬AT_END
 * Ҫ͸ͻӦý̽дģɿͻעắڲ첽AT_CONTINUE,atctlǰATֱͨû̵
 * send_rsp_str_to_farpsӿڽӦ͸atctlatctl͸ⲿMCUͷATͨ
 * @param res_msg		 ͬӦʽʱ*res_msgΪNULLΪӦ룬at_ctl͸ⲿMCUͷATͨ
 						 *res_msgΪNULLat_ctlֱӻظ\r\nOK\r\n͸ⲿMCUͷATͨ
 *						 Ӧý첽ʽʱ*res_msgΪNULLʱ᳤ʱסATֱͨû̵send_rsp_str_to_farpsӿڽATͨ
 * @return intͽ룬AT_ENDʾͬӦʽAT_CONTINUEʾ첽ӦʽҪӦý첽
 * @note
 */
typedef int (*ser_req_func)(char *at_paras, void ** res_msg);

/**
 * @brief ϱatѯмϱat
 *	psصϱͲѯмϱһ轫ϱݷ͸ģӦã˾ʹnvȫֱķʽ
 *	չatмϱһҪѯ͸ģӦã̬ڴ棬contextеapp_para
 * @param at_paras	ATַ
 * @param is_query_report
 * @return intַ
 */

typedef int (*inform_act_func)(char *at_paras, int is_query_report);


/**
* @brief ̼ͨϢͽӿڣϢδʧֵΪ-1
* @param source_id(IN)	:ϢģID
* @param target_id(IN)	:ϢģID
* @param Msg_cmd(IN)  	:Ϣڽģ鴦ϢʱȷϢķʽ
* @param us_DataLen(IN)	:ϢЯݵĳ
* @param pData(IN)		:ϢЯ
* @param msgflag(IN)		:Ϣķͷʽ0ʾͣIPC_NOWAITʾ
* @return ͳɹ0ʧܷط0οlinux׼errno
* @note ʧܣӦжerrno == ENOENT, ʾշһᱻͷɼipc_send_msg2ӿ
*/
int ipc_send_message(int src_id, int dst_id, unsigned short Msg_cmd, unsigned short us_DataLen, unsigned char *pData, int msgflag);

/**
* @brief ̼ͨϢͽӿڣӦһʱͷøýӿڣϢδԶϢ
* @param source_id(IN)	:ϢģID
* @param target_id(IN)	:ϢģID
* @param Msg_cmd(IN)  	:Ϣڽģ鴦ϢʱȷϢķʽ
* @param us_DataLen(IN)	:ϢЯݵĳ
* @param pData(IN)		:ϢЯ
* @param msgflag(IN)		:Ϣķͷʽ0ʾͣIPC_NOWAITʾ
* @return ͳɹ0ʧܷط0οlinux׼errno
* @note ˽ӿϢ׼ʧĳ: ĿӦһϢʱڷϢʱĿӦδ
*       : ʼʱһЩϢȲ¼ϱӦδնδ
*/
int ipc_send_message2(int src_id, int dst_id, unsigned short Msg_cmd, unsigned short us_DataLen, unsigned char *pData, int msgflag);


/**
 * @brief ATӿ
 * @param fmt ATӦĸʽʽ
 * @param buf  ATӦַָ벻ͷͿո
 * @param pval	ʽAT
 * @return 0ʾвЧԼ飬巵ֵοͷļSAP_ERRöAT_PARSE_OKȺֵ
 * @note  
 * 1. AT밴3GPP27007׼Э飬ԶŸַ˫ţ
 * 2. ַʱγȱڿַܽȣԽ
 * 3. ֵοöenum SAP_ERR,вЧԼ
 * 4. fmtָĲͱpvalָһһӦ
 * 5. ʾ
<pre>
	char buf[]="1,2,\"test\"";
	int n1 = 0;
	int n2 = 0;
	char *n3 = malloc(strlen(buf));
	char *p[] = {&n1,&n2,n3};
	ret = parse_param("%d,%d,%s", buf, (void**)p);
	//n1==1 n2==2 n3=="test"	 
	ret = parse_param("%4d,%d,%3s", buf, (void**)p);
	//n1==1 n2==2 n3=="te"	 
</pre>
 * @warning 
 */
int  parse_param(char *fmt, char *buf, void **pval);


/**
 * @brief Ӧ÷ͶѯAT3GPPЭջȴע⣺ýӿֻڲѯúִͨνмڲ
		  мϱʱֻ֧һмϱ
 * @param req_at  ATСдУд
 * @param info_fmt ATӦĸʽʽ
 * @param pval	ʽATӦʹòοparse_paramӿ
 * @return 0ʾسɹֵʾʧܴ
 * @note  
 * 1. ûʹʱɸýӿڲвĸʽԽinfo_fmtֵΪ"%s"pvalֵΪchar **p˫ָ룬Ϊַظ
 * 2. ZMGL,CPBR, COPS=?һжмú
 * 3. ַʱγȱڿַܽȣԽ
 * 4. мϱʱpvalinfo_fmtΪգΪмϱʱΪ
 * 5. pvalinfo_fmtҪôΪNULL,ҪôΪNULLܴһΪNULLһΪNULL
 * 6. ʾ
<pre>
	int ret = 0;
	ret = get_modem_info("AT+CFUN=1\r", NULL,  NULL);
	//ؼʾִгɹ

	char *pstr = malloc(50);
	memset(pstr,0,50);
	ret = get_modem_info("AT+CIMI\r", "%s",  (void**)&pstr);
	//غpstr==111111111111111

	int n1 = 0;
	int n2 = 0;
	int n3 = 0;
	char *p2[] = {&n1,&n2,&n3};
	ret = get_modem_info("AT+CCIOTOPT?\r", "%d,%d,%d",	(void**)p2);
	//+CCIOTOPT: 1,2,3n1==1 n2==2 n3==3
</pre>
 * @warning 
 */
int  get_modem_info(char *req_at,char *info_fmt,void **pval);


/**
 * @brief Ӧ÷ͶѯATⲿMCUȴֻ֧һмϱ
 * ڴͨŴڶݿܣ⵽мϱӦдʱطԣĿǰط3κԣ
 * չATĴ볬9000ط
 * @param req_at  ATСдУд
 * @param len     ATĳ
 * @param info_fmt ATӦĸʽʽ
 * @param pval	ʽATӦʹòοparse_paramӿ
 * @param safe_parm_check	ָʾǷԲһԼ飬0ʾѡԲм;1ʾԲϸ
 * @param timeout timeout==0 ʾõȴ룬ȴʱΪ[timeout]
 * @return 0ʾسɹֵʾʧܴ
 * @note  
 * 1. ûʹʱɸýӿڲвĸʽԽinfo_fmtֵΪ"%s"pvalֵΪchar **p˫ָ룬Ϊַظ
 * 2. ZMGL,CPBR, COPS=?һжмú
 * 3. ַʱγȱڿַܽȣԽ
 * 4. мϱʱpvalinfo_fmtΪգΪмϱʱΪ
 * 5. pvalinfo_fmtҪôΪNULL,ҪôΪNULLܴһΪNULLһΪNULL
 * 6. ʾ
<pre>
	int ret = 0;
	ret = send_reqat_to_farps("AT+CFUN=1\r", NULL,  NULL, 0);
	//ؼʾִгɹ

	char *pstr = malloc(50);
	memset(pstr,0,50);
	ret = send_reqat_to_farps("AT+CIMI\r", "%3s",  (void**)&pstr, 3000);
	//غpstr==111111111111111, pstrַĿΪ2

	int n1 = 0;
	int n2 = 0;
	int n3 = 0;
	char *p2[] = {&n1,&n2,&n3};
	ret = send_reqat_to_farps("AT+CCIOTOPT?\r", "%d,%d,%d",	(void**)p2, 5000);
	//+CCIOTOPT: 1,2,3n1==1 n2==2 n3==3,ʱΪ5000ms
</pre>
 * @warning 
 */
int  send_reqat_to_farps(char *req_at,int len,char *info_fmt,void **pval, int safe_parm_check, int timeout);


/**
 * @brief ڿעеķ˾AT¼ϲ㼰ͻƣ׼PSЭջ
 * @param at_cmd_prefix	 ATǰ׺ָ
 * @param module_id      Դģid
 * @param req_rcv_act    庬μtypedef int (*ser_req_func)(char *at_paras, void ** res_msg)ӿ˵
 * @return intͽ
 * @retval ɹ 0
 * @note עắregister_serv_func2ֻat_cmd_prefixmodule_idreq_rcv_act
 *  at_ctlյAT󣬵עreq_rcv_actat_ctlܷشֱӽ뷢͸ⲿMCU
 յⲿ͵ATͨϢMSG_CMD_SEND_REQ_TO_APP͸Ӧã 
 Ӧôͨúsend_rsp_str_to_farpsat_ctlӦ͵ⲿMCU
 */
int  register_serv_func(char *at_cmd_prefix, int  module_id, ser_req_func req_rcv_act);


/**
 * @brief עϱAT¼ѯмϱϱ
 * @param at_cmd_prefix	 ATǰ׺ָ
 * @param inform_act     յATмϱĴ
 * @return intͽ
 * @retval ɹ 0, ʧ -1
 * @note ͬǰ׺ظעat_ctlյϱмʱÿִкִһ顣
 * мͿܱϱϱӦãӦùЧϱϢ
 */
int  register_inform_func(char *at_cmd_prefix, inform_act_func inform_act);


/**
  * @brief Ӧó򣬷мӦⲿMCU
  * @param module_id	  Ӧģid
  * @param rsp_cmd		  ͵ⲿMCU
  * @param rsp_len		  
  * @return intͽ
  * @retval ɹ 0, ʧ -1
  * @note 
  */
int send_rsp_str_to_farps(int	module_id, char *rsp_cmd,int rsp_len);


/**
 * @brief atӦERROR
 * @param param  ERRORĴ
 * @return atӦERRORַָ
 * @note at_ctlͷڴ
 */
char* at_err_build(int param);

/**
 * @brief ػ
 * @param src_id ģidδ0
 * @return ͽ0ɹ0ʧ
 */
int poweroff_request(int src_id);

/**
 * @brief 
 * @param src_id ģidδ0
 * @return ͽ0ɹ0ʧ
 */
int restart_request(int src_id);

/**
 * @brief ָ
 * @param src_id ģidδ0
 * @return ͽ0ɹ0ʧ
 */
int reset_request(int src_id);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
* @brief ̼ͨϢͽӿ
* @param position(IN)	:Ϣͷ
* @param msg_cmd(IN)	:Ϣڽģ鴦ϢʱȷϢķʽ
* @param len(IN)  	    :ϢӦṹݳ
* @param msg(IN)	 	:ϢӦṹ
* @return ͳɹ0ʧܷط0οlinux׼errno
* @note 漰˼Ϣݣڲʹá
*/
int send_soc_msg(unsigned short position, int dst_id, unsigned short msg_cmd, unsigned short len, void *msg);

/**
* @brief ̼ͨż˼ͨϢͨýӿ
* @param src_id(IN)		:ϢģID
* @param dst_id(IN)		:ϢģID
* @param msg_cmd(IN)	:Ϣڽģ鴦ϢʱȷϢķʽ
* @param datalen(IN)	:ϢӦṹݳ
* @param pData(IN)		:ϢӦṹ
* @return ͳɹ0ʧܷط0οlinux׼errno
* @note 漰˼Ϣݣڲʹá
*/
int platform_send_msg(int src_id, int dst_id, unsigned short msg_cmd, unsigned short datalen, unsigned char *pData);

/**
* @brief   ƽ̨ڴ
* @param   err(IN):
* @return
*/
void zxic_err_track(int err);

/**
* @brief    Ĭ·Ƿóɹ
* @return  óɹ1, ɹ-1
*/
int default_route_check();

extern long long int get_time_us();

extern int soft_system(const char *command);

#endif

/**
*brief 	ȡϵͳʱ
*return ϵͳԿڵʱλΪ
*/
long get_sys_uptime();

#endif
