#include "hotplug.h"
#include "drv_msg.h"

#define NV_NEED_CP_UDISK                 "need_support_cp_udisk"        /*ʶǷ֧CPTл*/

/*--------------------------------------------------*/
/*---------------ȲϢ------------------*/
/*--------------------------------------------------*/
static const char *serial_event_str[] = {
	[SERIAL_EVENT_GSMTTY1]	= "CMUXEVENT=gsmtty1",
	[SERIAL_EVENT_GSMTTY2]	= "CMUXEVENT=gsmtty2",
	[SERIAL_EVENT_GSMTTY3]	= "CMUXEVENT=gsmtty3",
	[SERIAL_EVENT_TTYGS0]	= "ttyGS0",
	[SERIAL_EVENT_TTYGS1]	= "ttyGS1",
};

/*ȡSERIAL¼*/
static int get_serial_event(const char *msg, int msglen)
{
	int i = 0;

	if(msglen <= 0)
		return -1;

	for(i = 0; i < SERIAL_EVENT_MAX; i++)
	{
		if(strstr(msg, serial_event_str[i]))
			return i;
	}

	return -1;
}

/*serialϢ*/
int drv_serial_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
	int event_type = 0;

	if(msglen <= 0)
		return -1;

	char_replace(msg, msglen, '\0', '\n');

	if(strstr(msg, "/cmux/cmuxconfig"))
    {
		event_type = get_serial_event(msg, msglen);
		if(event_type < 0)
			return -1;

		event->type = DEV_TYPE_SERIAL;
		event->u.serial.event_type = event_type;
		sprintf(event->u.serial.dev_name, "/dev/gsmtty%d", event_type+1);

		return 0;
	}

	if(strstr(msg, "ttyGS0") || strstr(msg, "ttyGS1"))
    {
		event_type = get_serial_event(msg, msglen);
		if(event_type < 0)
			return -1;

		event->type = DEV_TYPE_SERIAL;
		event->u.serial.event_type = event_type;
		sprintf(event->u.serial.dev_name, "/dev/ttyGS%d", (event_type - SERIAL_EVENT_TTYGS0));

		return 0;
	}

	return -1;
}

/*豸Ȱβ崦*/
int drv_serial_event_proc(struct hotplug_event *event)
{
	int port_num = event->u.serial.event_type;

	if(event->type != DEV_TYPE_SERIAL)
        return -1;

	slog(DRVCOMMNG_PRINT, SLOG_NORMAL, "[%s][%d]act type = %d, dev_id = %s\n", __func__, __LINE__, event->action, event->u.serial.dev_name);
	
	switch (event->action) {
		case KOBJ_ONLINE:
				ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, 
					sizeof(event->u.serial.dev_name), event->u.serial.dev_name, 0);
				break;
		case KOBJ_OFFLINE:
				ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, 
					sizeof(event->u.serial.dev_name), event->u.serial.dev_name, 0);
				break;
		case KOBJ_ADD:
		case KOBJ_REMOVE:
		default:
			break;
	}

	return 0;
}


/*--------------------------------------------------*/
/*---------------USBȲϢ------------------*/
/*--------------------------------------------------*/
static const char *usb_event_str[] = {
    [USB_EVENT_CHARGE]   = "USBEVENT=usb_charge",
    [USB_EVENT_DEVICE]   = "USBEVENT=usb_device",
    [USB_EVENT_CDROMOBJ] = "USBEVENT=usb_switch",
    [USB_EVENT_USER]     = "USBEVENT=usb_user",
    [USB_EVENT_DEBUG]    = "USBEVENT=usb_debug",
    [USB_EVENT_FACTORY]  = "USBEVENT=usb_factory",
    [USB_EVENT_AMT]      = "USBEVENT=usb_amt",
    [USB_EVENT_EYE_DIAGRAM]      = "USBEVENT=usb_eye_diagram",
    [USB_EVENT_RESET]  = "USBEVENT=usb_except_reset",
};

/*ȡUSB¼*/
int get_usb_event(const char *msg, int msglen)
{
    int i = 0;

    if(msglen <= 0)
        return -1;

    for(i = 0; i < USB_EVENT_MAX; i++)
    {
        if(strstr(msg, usb_event_str[i]))
            return i;
    }

    return -1;
}

/*usbϢ*/
int drv_usb_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
    int event_type = 0;

    if(msglen <= 0)
        return -1;

	char_replace(msg, msglen, '\0', '\n');
    
    if(strstr(msg, "dwc_usb/usbconfig"))
    {
        event_type = get_usb_event(msg, msglen);
        if(event_type < 0)
            return -1;

        event->type = DEV_TYPE_USB;
        event->u.usb.event_type = event_type;
        return 0;
    }

    return -1;
}

/*usbȰβ¼*/
int drv_usb_event_proc(struct hotplug_event *usb_event)
{
	if(usb_event->type != DEV_TYPE_USB)
        return -1;
	
	slog(USBCFGMNG_PRINT, SLOG_NORMAL, "[%s][%d]act type = %d, dev_id = %d\n", __func__, __LINE__, usb_event->action, usb_event->u.usb.event_type);

	switch(usb_event->action)
    {
    	case KOBJ_CHANGE:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_USB_CHANGE, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		case KOBJ_ADD:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_USB_ADD, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		case KOBJ_REMOVE:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_USB_REMOVE, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		default:
        	break;
	}

	return 0;
}

/*--------------------------------------------------*/
/*---------------SDȲϢ------------------*/
/*--------------------------------------------------*/
#define SDCARD_ADD_MESSAGE          "add@/devices/platform/zx29_sd.1"
#define SDCARD_REMOVE_MESSAGE         "remove@/devices/platform/zx29_sd.1"    
#define SDCARD_OFFLINE_MESSAGE         "offline@/devices/platform/zx29_sd.1" 

#define SDCARD_ADD_STR_SUBSYSTEM    "SUBSYSTEM=block"
#define SDCARD_ADD_STR_DEVNAME      "DEVNAME=mmcblk0"
#define SDCARD_ADD_STR_DEVTYPE      "DEVTYPE=disk"
#define SDCARD_REMOVE_STR_SUBSYSTEM   "SUBSYSTEM=mmc"
#define SDCARD_REMOVE_STR_MMCTYPE     "MMC_TYPE=SD"
#define SDCARD_OFFLINE_STR_SUBSYSTEM   "SUBSYSTEM=mmc"
#define SDCARD_OFFLINE_STR_MMCTYPE     "MMC_TYPE=SD"

/*sdcardϢ*/
int drv_sd_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
    if(NULL == msg || msglen <= 0)
        return -1;
    
    if (strncmp(msg,SDCARD_ADD_MESSAGE, strlen(SDCARD_ADD_MESSAGE)) == 0
        && strstr(msg, SDCARD_ADD_STR_SUBSYSTEM)
        && strstr(msg, SDCARD_ADD_STR_DEVNAME)
        && strstr(msg, SDCARD_ADD_STR_DEVTYPE))//T
    {
        event->type = DEV_TYPE_SDCARD;
        return 0;
    }
    else if(strncmp(msg,SDCARD_REMOVE_MESSAGE, strlen(SDCARD_REMOVE_MESSAGE)) == 0
            && strstr(msg, SDCARD_REMOVE_STR_SUBSYSTEM)
            && strstr(msg, SDCARD_REMOVE_STR_MMCTYPE))
    {
        event->type = DEV_TYPE_SDCARD;
        return 0;
    }
    else if(strncmp(msg,SDCARD_OFFLINE_MESSAGE, strlen(SDCARD_OFFLINE_MESSAGE)) == 0
            && strstr(msg, SDCARD_OFFLINE_STR_SUBSYSTEM)
            && strstr(msg, SDCARD_OFFLINE_STR_MMCTYPE))
    {
        event->type = DEV_TYPE_SDCARD;
        return 0;
    }

    return -1;
}

/*sdȰβ¼*/
int drv_sd_event_proc(struct hotplug_event *usb_event)
{
	if(usb_event->type != DEV_TYPE_SDCARD)
        return -1;

	switch(usb_event->action)
    {
    	case KOBJ_OFFLINE:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_SD_OFFLINE, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		case KOBJ_ADD:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_SD_ADD, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		case KOBJ_REMOVE:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_SD_REMOVE, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		default:
        	break;
	}
	return 0;
}

/*--------------------------------------------------*/
/*---------------VSDȲϢ------------------*/
/*--------------------------------------------------*/

/*sdcardϢ*/
int drv_vsd_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
    return -1;
}

/*sdȰβ¼*/
int drv_vsd_event_proc(struct hotplug_event *usb_event)
{
	if(usb_event->type != DEV_TYPE_VIRTUAL_SDCARD)
        return -1;

	switch(usb_event->action)
    {
    	case KOBJ_OFFLINE:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_VSD_OFFLINE, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		case KOBJ_ADD:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_VSD_ADD, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		case KOBJ_REMOVE:
			ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_VSD_REMOVE, 
				sizeof(usb_event->u.usb.event_type), &usb_event->u.usb.event_type, 0);
			break;
		default:
        	break;
	}

	return 0;
}



/*ϵʼ*/
void drv_hotplug_init(void)
{
    char need_cp_udisk[8] = {0};
    
    sc_cfg_get(NV_NEED_CP_UDISK, need_cp_udisk,sizeof(need_cp_udisk));

	/*USBȰβϢʼע*/
    hotplug_parse_register(DEV_TYPE_USB, drv_usb_msg_parse);
    hotplug_proc_register(DEV_TYPE_USB, drv_usb_event_proc);

	if(0 == strncmp(need_cp_udisk, "yes", strlen("yes"))) /*Sys֧֧CPU/Tл*/
    {	
		/*SDȰβϢʼע*/
	    hotplug_parse_register(DEV_TYPE_SDCARD, drv_sd_msg_parse);
    	hotplug_proc_register(DEV_TYPE_SDCARD, drv_sd_event_proc);

		/*SDȰβϢʼע*/
		hotplug_parse_register(DEV_TYPE_VIRTUAL_SDCARD, drv_vsd_msg_parse);
    	hotplug_proc_register(DEV_TYPE_VIRTUAL_SDCARD, drv_vsd_event_proc);
	}

	/*ȰβϢʼע*/
    hotplug_parse_register(DEV_TYPE_SERIAL, drv_serial_msg_parse);
    hotplug_proc_register(DEV_TYPE_SERIAL, drv_serial_event_proc);

}


