/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_wifi.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMI wifiƲ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#include <sys/inotify.h>
#include <limits.h>
#include "mmi_common.h"
#include "mmi_lcd.h"
#include "wlan_interface.h"

/*****************************************************************************
 ȫֱ
******************************************************************************/
static BOOL s_mmi_wifiState = FALSE;//Ӽļлȡwifi״̬
static BOOL s_mmi_wifidata_state = FALSE;//жlanǷݴ
static E_zMmi_WpsAct_Tip s_mmi_wpsState = WPS_ACTIVE_MAX;//Ӽļлȡwps״̬
static BOOL g_wps_switch_ssid_show = TRUE;
static BOOL g_wifi_code_show_flag = FALSE;//wifiάǷ
static SINT32 s_mmi_wifi_connect_num = 0;		//û
static SINT32 s_mmi_wifi_connect_numEx = 0;
static SINT32 s_mmi_Isconnected_user = 0;     //Ƿûwifi  1: 0:û
static BOOL s_mmi_qrcode_exist = FALSE;        //άǷ
static BOOL s_mmi_qrcode_existPre = FALSE;    //λһζάǷ
static BOOL s_mmi_wifiStationConnected = FALSE;//wifistationǷ
static SINT32 s_mmi_wifistation_signal_num = 0;		//wifistationźŸ
static char s_mmi_wifistation_ssid[64] = {0};//wifistationӦssid
extern BOOL g_mmi_key_longpress_flag;

long long s_mmi_wifidata0_lastsend = 0;//wif˿va0һεķ
long long s_mmi_wifidata0_lastrecv = 0;//wif˿va0һεĽ
long long s_mmi_wifidata1_lastsend = 0;//wif˿va0һεķ
long long s_mmi_wifidata1_lastrecv = 0;//wif˿va0һεĽ

struct st_files file_wd[WD_NUM];
extern E_zMmiShowMode g_showMode;
extern UINT32 g_led_standby_mode;
extern UINT32 g_led_sleep_mode;
extern UINT32 g_use_wifi_usernum;
extern int g_customer_type;
SINT32 mmi_get_wifiinfo(UINT32 wifiinfo)
{
	if (wifiinfo != 0) {
		T_zMMIWifiInfo * pWifiInfo = (T_zMMIWifiInfo *)wifiinfo;
		pWifiInfo->wifi_state = s_mmi_wifiState;
		pWifiInfo->wifidata_state = s_mmi_wifidata_state;
		pWifiInfo->wps_state = s_mmi_wpsState;
		pWifiInfo->Isconnected_user = s_mmi_Isconnected_user;
		pWifiInfo->connected_userNum = s_mmi_wifi_connect_num;
	}
	return MMI_SUCCESS;
}

SINT32 mmi_get_wificodeinfo(UINT32 wificodeinfo)
{
	if (wificodeinfo != 0) {
		T_zMMIWifiCodeInfo * pWifiCodeInfo = (T_zMMIWifiCodeInfo *)wificodeinfo;
		pWifiCodeInfo->multi_ssid_switch = mmi_get_multi_ssid_switch_flag();
		pWifiCodeInfo->is_wificode_exist = s_mmi_qrcode_exist;
	}
	return MMI_SUCCESS;
}

/**********************************************************************************
:ȡwifiStation״̬
***********************************************************************************/
BOOL mmi_get_wifiStationConnect_state()
{
	return s_mmi_wifiStationConnected;
}

/**********************************************************************************
:ȡwifiStationӺźǿϢ
***********************************************************************************/
SINT32 mmi_get_wifiStation_signalNum()
{
	return s_mmi_wifistation_signal_num;
}

static VOID mmi_get_wifiStation_ssid_from_nv()
{
	sc_cfg_get(NV_WIFISTA_SSID, s_mmi_wifistation_ssid, sizeof(s_mmi_wifistation_ssid));
}

/**********************************************************************************
:ȡWifiStationϢģ
***********************************************************************************/
SINT32 mmi_get_wifistationinfo(UINT32 wifistationinfo)
{
	if (wifistationinfo != 0) {
		T_zMMIWifiStationInfo * pWifiStationInfo = (T_zMMIWifiStationInfo *)wifistationinfo;
		pWifiStationInfo->wifistation_connect_state = mmi_get_wifiStationConnect_state();
		pWifiStationInfo->signal_num = mmi_get_wifiStation_signalNum();
		pWifiStationInfo->wifista_ssid = s_mmi_wifistation_ssid;
	}
	return MMI_SUCCESS;
}


SINT32 mmi_RegisterWifiTaskInfoItem()
{
	T_zMMITaskInfoItem wifiInfoItem = {0};
	wifiInfoItem.task = MMI_TASK_WIFI;
	wifiInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMIWifiInfo));
	wifiInfoItem.get_taskinfo_fun = mmi_get_wifiinfo;
#ifndef DISABLE_LCD
	wifiInfoItem.get_lcdinfo_fun = mmi_getLcdWifiInfo;
#endif
	wifiInfoItem.get_ledinfo_fun = mmi_getLedWifiInfo;
	wifiInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//wifiAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&wifiInfoItem);
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterWpsTaskInfoItem()
{
	T_zMMITaskInfoItem wifiInfoItem = {0};
	wifiInfoItem.task = MMI_TASK_LED_WPS;
	wifiInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMIWifiInfo));
	wifiInfoItem.get_taskinfo_fun = mmi_get_wifiinfo;
#ifndef DISABLE_LCD
	//wifiInfoItem.get_lcdinfo_fun = mmi_getLcdWifiInfo;
#endif
	wifiInfoItem.get_ledinfo_fun = mmi_getLedWpsInfo;
	wifiInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//wifiAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&wifiInfoItem);
	return MMI_SUCCESS;
}


SINT32 mmi_RegisterWifiCodeTaskInfoItem()
{
	T_zMMITaskInfoItem wifiInfoItem = {0};
	wifiInfoItem.task = MMI_TASK_WIFICODE;
	wifiInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMIWifiInfo));
	wifiInfoItem.get_taskinfo_fun = mmi_get_wificodeinfo;
#ifndef DISABLE_LCD
	wifiInfoItem.get_lcdinfo_fun = mmi_getLcdWifiCodeInfo;
#endif
	wifiInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//wifiAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&wifiInfoItem);
	return MMI_SUCCESS;
}
/**********************************************************************************
:עwifiStationϢģ
***********************************************************************************/
SINT32 mmi_RegisterTipWifiStationConnectTaskInfoItem()
{
	T_zMMITaskInfoItem wifiStationInfoItem = {0};
	wifiStationInfoItem.task = MMI_TASK_TIP_WIFISTATION;
	wifiStationInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMIWifiStationInfo));
	wifiStationInfoItem.get_taskinfo_fun = mmi_get_wifistationinfo;
#ifndef DISABLE_LCD
	wifiStationInfoItem.get_lcdinfo_fun = mmi_getLcdWifiStationInfo;
#endif
	//wifiStationInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&wifiStationInfoItem);
	return MMI_SUCCESS;
}

/**********************************************************************************
:עWPSʾģ
***********************************************************************************/
SINT32 mmi_RegisterTipWpsTaskInfoItem()
{
	T_zMMITaskInfoItem wpsInfoItem = {0};
	wpsInfoItem.task = MMI_TASK_TIP_WPS;
	wpsInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMIWifiInfo));
	wpsInfoItem.get_taskinfo_fun = mmi_get_wifiinfo;
#ifndef DISABLE_LCD
	wpsInfoItem.get_lcdinfo_fun = mmi_getLcdTipWpsInfo;
#endif
	//wpsInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&wpsInfoItem);
	return MMI_SUCCESS;
}

static VOID mmi_set_wifi_update()
{
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		mmi_set_update_flag(MMI_TASK_WIFI);
	}
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode mode = mmi_get_led_mode();
		if (mode != MMI_IDLE_LEDOFF_MODE && mode != MMI_IDLE_CHG_LEDOFF_MODE
		    && mode != MMI_FAKE_POWEROFF_MODE && mode != MMI_FAKE_POWEROFF_CHARGE_MODE && mode != MMI_IDLE_STANDBY_LEDOFF_MODE) {
			mmi_set_update_flag(MMI_TASK_WIFI);
		}
	}
}


/***********************************************************************************
   :Ƿʾwifi ά
***********************************************************************************/
VOID mmi_set_wificode_show_flag(BOOL flag)
{
	g_wifi_code_show_flag = flag;
}

BOOL mmi_get_wificode_show_flag(VOID)
{
	return g_wifi_code_show_flag;
}

/**********************************************************************************
:ȡwifi/wps״̬
***********************************************************************************/
BOOL mmi_get_wifi_state()
{
	return s_mmi_wifiState;
}

E_zMmi_WpsAct_Tip mmi_get_wps_state()
{
	return s_mmi_wpsState;
}

void mmi_ms_sleep(unsigned long mSec)
{

	struct timeval tv;
	tv.tv_sec = mSec / 1000;
	tv.tv_usec = (mSec % 1000) * 1000;
	int err;
	do {
		err = select(0, NULL, NULL, NULL, &tv);
	} while (err < 0 && errno == EINTR);

}

/***********************************************************************************
   :WIFI
***********************************************************************************/
VOID mmi_wifi_operate(char* mode)
{
	char wifi_mode[2] = {0};
	sc_cfg_get(WLAN_NV_CUR_STATE, wifi_mode, 2);
	slog(MMI_PRINT, SLOG_NORMAL, "MMI handle_wifi_opt mode = %s RadioOff=%s\n", mode, wifi_mode);
	if (!strcmp(mode, WIFI_TURN_OFF_FAKE_POWEROFF)) {
		if (g_mmi_key_longpress_flag) {
			g_mmi_key_longpress_flag = FALSE;

			int wait_times = 0;
			char wifi_process_state[11] = {0};
			sc_cfg_get(WLAN_NV_PROCESS_STATE, wifi_process_state, 11);
			//ٿػʱwifi״̬ҵڴ˼ӵȴwifiز
			while (wait_times < 100 && !strcmp(wifi_process_state, "processing")) {
				wait_times++;
				mmi_ms_sleep(30);
				sc_cfg_get(WLAN_NV_PROCESS_STATE, wifi_process_state, 11);
			}
			slog(MMI_PRINT, SLOG_DEBUG, "MMI wait for wifi processing end wait_times = %d\n", wait_times);
		}
		sc_cfg_get(WLAN_NV_CUR_STATE, wifi_mode, 2);
		if (!strcmp(wifi_mode, WIFI_OPENED)) {
			slog(MMI_PRINT, SLOG_NORMAL, "MMI handle_wifi_opt FAKE_POWEROFF\n");
			ipc_send_message(MODULE_ID_MMI, MODULE_ID_WIFI, (USHORT)MSG_CMD_WIFI_CLOSE, NULL, NULL, 0);
		}
	} else {
		if (strcmp(wifi_mode, mode)) {
			if (strcmp(wifi_mode, WIFI_OPENED) == 0) {
				slog(MMI_PRINT, SLOG_NORMAL, "MMI handle_wifi_opt mode close wifi\n");
				ipc_send_message(MODULE_ID_MMI, MODULE_ID_WIFI, (USHORT)MSG_CMD_WIFI_CLOSE, NULL, NULL, 0); //WIFI͹رϢ
			} else if (strcmp(wifi_mode, WIFI_CLOSED) == 0) {
				slog(MMI_PRINT, SLOG_NORMAL, "MMI handle_wifi_opt mode open wifi\n");
				ipc_send_message(MODULE_ID_MMI, MODULE_ID_WIFI, (USHORT)MSG_CMD_WIFI_OPEN, NULL, NULL, 0); //WIFIͻϢ
			}
		}
	}
}

/**********************************************************************************
:wpsȥɹʾ2붨ʱ
***********************************************************************************/
static VOID * mmi_wps_tip_check_timer_cb(VOID *arg)
{
	s_mmi_wpsState = WPS_ACTIVE_MAX;
	mmi_set_update_flag(MMI_TASK_TIP);
	return NULL;
}

static VOID mmi_wps_tip_timer_start(VOID)
{
	int ret = -1;
	ret = sc_timer_create(SET_WPS_TIP_CHECK_TIMER, TIMER_FLAG_ONCE, SET_WPS_TIP_CHECK_TIME, &mmi_wps_tip_check_timer_cb, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_wps_tip_timer_start FAILED\n");
	}
}

static VOID mmi_wps_tip_timer_stop(VOID)
{
	sc_timer_delete(SET_WPS_TIP_CHECK_TIMER);
}

VOID mmi_wps_operate(VOID)
{
	char authmode[16] = {0};
	char hidessid[2] = {0};
	char encrypType[16] = {0};
	char WscModeOption[2] = {0};
	char wps_mode[10] = {0};
	long lRet = -1;
	sc_cfg_get(WLAN_NV_AUTHMODE_NAME, authmode, sizeof(authmode));
	sc_cfg_get(WLAN_NV_AP_HIDESSID_NAME, hidessid, sizeof(hidessid));
	sc_cfg_get(WLAN_NV_ENCRYP_TYPE_NAME, encrypType, sizeof(encrypType));
	sc_cfg_get(WLAN_NV_WSC_MODE_NAME, WscModeOption, sizeof(WscModeOption));
    //unsupported auth type, syn from wifi.js
	if ((!strcmp(hidessid, "1"))
			|| ((!strcmp(authmode, "OPEN")) && (!strcmp(encrypType, "WEP")))
			|| ((!strcmp(authmode, "SHARED")) && (!strcmp(encrypType, "WEP")))
			|| ((!strcmp(authmode, "WPAPSK")) && (!strcmp(encrypType, "TKIP")))
			|| ((!strcmp(authmode, "WPAPSK")) && (!strcmp(encrypType, "AES")))
			|| ((!strcmp(authmode, "WPAPSK")) && (!strcmp(encrypType, "TKIPCCMP")))
			|| ((!strcmp(authmode, "WPA2PSK")) && (!strcmp(encrypType, "TKIP")))
			|| ((!strcmp(authmode, "WPAPSKWPA2PSK")) && (!strcmp(encrypType, "TKIP")))
			|| (!strcmp(authmode, "WPA3Personal"))
			|| (!strcmp(authmode, "WPA2WPA3"))) {
			slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_wps_operate authmode = %s, encryptype = %s, hidessid = %s \n", authmode, encrypType, hidessid);
			s_mmi_wpsState = WPS_FAIL;
			mmi_wps_tip_timer_start();
			mmi_set_wifi_update();
			mmi_set_update_flag(MMI_TASK_TIP_WPS);
			mmi_set_update_flag(MMI_TASK_LED_WPS);
			return;
	}
			
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_wps_operate authmode = %s, encryptype = %s, hidessid = %s \n", authmode, encrypType, hidessid);
	if (mmi_get_wifi_state() && (mmi_get_wps_state() == WPS_ACTIVE_MAX)) { //WPS
		strncpy(wps_mode, "PBC", 9);

		if (!strcmp(WscModeOption, "1")) {
			return;
		}
		sc_cfg_set(WLAN_NV_WSC_MODE_NAME, "1");
		sc_cfg_set(WLAM_NV_WPS_MODE_NAME, wps_mode);
		lRet = ipc_send_message(MODULE_ID_MMI, MODULE_ID_WIFI, (USHORT)MSG_CMD_WIFI_WPS, 0, NULL, 0);
		if (0 == lRet) {
			slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_wps_operate send to wifi ok \n");
			//send_rsp_str_to_farps(MODULE_ID_MMI, "\r\n+TKEYEVENT: wps actived\r\n", strlen("\r\n+TKEYEVENT: wps actived\r\n"));
			ipc_send_message(MODULE_ID_MMI, MODULE_ID_AT_CTL, MSG_CMD_SEND_RSP_TO_OUTSIDE, strlen("\r\n+TKEYEVENT: wps actived\r\n"), "\r\n+TKEYEVENT: wps actived\r\n", 0);
		}
	}
}

/**********************************************************************************
:ͨnvȡSSIDwifiû
***********************************************************************************/
static VOID mmi_get_wifi_stanum(VOID)
{
	char va0_wifi_num[8] = {0};
	char va1_wifi_num[8] = {0};
	SINT32 wifi_num = 0;
	SINT32 m_wifi_num = 0;
	sc_cfg_get(WLAN_NV_VA0_WIIF_NUM, va0_wifi_num, sizeof(va0_wifi_num));
	sc_cfg_get(WLAN_NV_VA1_WIIF_NUM, va1_wifi_num, sizeof(va1_wifi_num));
	wifi_num = atoi(va0_wifi_num);
	m_wifi_num = atoi(va1_wifi_num);
	if ((wifi_num < 0 || wifi_num > INT_MAX-1) ||
		(m_wifi_num < 0 || m_wifi_num > INT_MAX-1)){//kw 3, 0~32?
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_wifi_stanum wifi_num = %d, m_wifi_num = %d\n", wifi_num, m_wifi_num);
		return;
	}
	s_mmi_wifi_connect_num = wifi_num + m_wifi_num;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_wifi_stanum wifi_num = %d,m_wifi_num = %d, s_mmi_wifi_connect_num = %d \n", wifi_num, m_wifi_num, s_mmi_wifi_connect_num);
}

/**********************************************************************************
:ѯwifi ʱص
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Get_Wifi_StaNum(VOID *data)
{
	//#if MMI_USE_WIFI_USERNUM
	if (g_use_wifi_usernum) {
#if 0
		s_mmi_wifi_connect_num = zte_wlan_capture_sta_num();
		if (s_mmi_wifi_connect_num != 0 && s_mmi_wifi_connect_numEx == 0) {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI zMMI_Get_wifi_Stanum_Callback s_mmi_connected_user = 1!!!\n");
			s_mmi_Isconnected_user = 1;
		} else if (s_mmi_wifi_connect_num == 0 && s_mmi_wifi_connect_numEx != 0) {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI zMMI_Get_wifi_Stanum_Callback s_mmi_connected_user = 0!!!\n");
			s_mmi_Isconnected_user = 0;
		}
		s_mmi_wifi_connect_numEx = s_mmi_wifi_connect_num;
		mmi_set_wifi_update();
#else
		SINT32 va_state = -1;
		va_state = *(SINT32*)data;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI zMMI_Handle_Msg_Get_Wifi_StaNum va_state = %d\n", va_state);
		mmi_get_wifi_stanum();
		mmi_set_wifi_update();
#endif
	}
	//#endif
	return 0;
}

static VOID * mmi_wifi_stanum_timer_cb(VOID *arg)
{
	if (s_mmi_wifiState) {
		ipc_send_message(MODULE_ID_MMI, MODULE_ID_MMI, (USHORT)MSG_CMD_MMIGET_WIFI_STANUM, 0, NULL, 0);
	}
	return NULL;
}



/**********************************************************************************
:ѯwifi ʱ 3S
***********************************************************************************/
static VOID mmi_wifi_stanum_timer_create(VOID)
{
	int ret = -1;
	ret = sc_timer_create(SET_WIFI_STANUM_CHECK_TIMER, TIMER_FLAG_RESTART, SET_WIFI_STANUM_CHECK_TIME, &mmi_wifi_stanum_timer_cb, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_wifi_stanum_timer_create FAILED\n");
	}
}

/**********************************************************************************
:ѯwifi ݴ䶨ʱص
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Get_Wifi_Data(VOID *data)
{
	unsigned long long s_mmi_wifidata0_send = 0, s_mmi_wifidata0_recv = 0;
	unsigned long long s_mmi_wifidata1_send = 0, s_mmi_wifidata1_recv = 0;
	getIfStatistic(WIFI_DATA_VA0, WIFI_TXBYTE, &s_mmi_wifidata0_send); //ȡwif˿va0ķ
	getIfStatistic(WIFI_DATA_VA0, WIFI_RXBYTE, &s_mmi_wifidata0_recv); //ȡwif˿va0Ľ
	if(g_customer_type == CUSTOMER_SDK_MIN)
	{
		getIfStatistic("wlan0", WIFI_TXBYTE, &s_mmi_wifidata1_send); //ȡwif˿va1ķ
		getIfStatistic("wlan0", WIFI_RXBYTE, &s_mmi_wifidata1_recv); //ȡwif˿va1Ľ
	}
	else
	{
		getIfStatistic(WIFI_DATA_VA1, WIFI_TXBYTE, &s_mmi_wifidata1_send); //ȡwif˿va1ķ
		getIfStatistic(WIFI_DATA_VA1, WIFI_RXBYTE, &s_mmi_wifidata1_recv); //ȡwif˿va1Ľ
	}
#if 0 //kw 3
	if (s_mmi_wifidata0_send == -1 || s_mmi_wifidata0_recv == -1 || s_mmi_wifidata1_send == -1 || s_mmi_wifidata1_recv == -1) {
		s_mmi_wifidata_state = FALSE;
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_wifi_data_timer_cb invalid wifi data!\n");
		s_mmi_wifidata0_lastsend = 0;
		s_mmi_wifidata0_lastrecv = 0;
		s_mmi_wifidata1_lastsend = 0;
		s_mmi_wifidata1_lastrecv = 0;
		mmi_set_wifi_update();
		return 0;
	} else 
#endif
	if ((s_mmi_wifidata0_send != s_mmi_wifidata0_lastsend) || (s_mmi_wifidata0_recv != s_mmi_wifidata0_lastrecv)
	           || (s_mmi_wifidata1_send != s_mmi_wifidata1_lastsend) || (s_mmi_wifidata1_recv != s_mmi_wifidata1_lastrecv)) {
		s_mmi_wifidata_state = TRUE;      		//ݴ
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_wifi_data_timer_cb having data transfer!\n");
	} else {
		s_mmi_wifidata_state = FALSE;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_wifi_data_timer_cb no data transfer!\n");
	}
	s_mmi_wifidata0_lastsend = s_mmi_wifidata0_send;
	s_mmi_wifidata0_lastrecv = s_mmi_wifidata0_recv;
	s_mmi_wifidata1_lastsend = s_mmi_wifidata1_send;
	s_mmi_wifidata1_lastrecv = s_mmi_wifidata1_recv;
	if(g_customer_type == CUSTOMER_SDK_MIN && s_mmi_wpsState == WPS_ACTIVING) {
		s_mmi_wifidata_state = TRUE; //оwpsʱwlan0
	}
	mmi_set_wifi_update();
	return 0;
}

static VOID * mmi_wifi_data_timer_cb(VOID *arg)
{
	if (s_mmi_wifiState) {
		ipc_send_message(MODULE_ID_MMI, MODULE_ID_MMI, (USHORT)MSG_CMD_MMIGET_WIFI_DATA, 0, NULL, 0);
	}
	return NULL;
}


/**********************************************************************************
:ѯwifi Ƿݴ䶨ʱ 3S
***********************************************************************************/
static VOID mmi_wifi_data_timer_create(VOID)
{
	int ret = -1;
	ret = sc_timer_create(SET_WIFI_DATA_CHECK_TIMER, TIMER_FLAG_RESTART, SET_WIFI_DATA_CHECK_TIME, &mmi_wifi_data_timer_cb, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_wifi_data_timer_create FAILED\n");
	}
}

static VOID mmi_wifi_data_timer_stop(VOID)
{
	sc_timer_delete(SET_WIFI_DATA_CHECK_TIMER);
}

/**********************************************************************************
:άǷ״̬
***********************************************************************************/
SINT32 mmi_set_qrcode_state()
{
	char buf_qrcode[8] = {0};
	FILE* fd_qrcode = NULL;
	int len = 0;


	fd_qrcode = fopen(QRCODE_STATE_PATH, "r");
	if (fd_qrcode == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_set_qrcode_state open qrcode file fail!\n");
		perror(QRCODE_STATE_PATH);
		return 0;
	}
	len = fread(buf_qrcode, 1, 1, fd_qrcode);
	if (len > 0) { //kw 3, have 0x0a
		buf_qrcode[len] = '\0';
		if (strcmp(buf_qrcode, "1") == 0) {
			s_mmi_qrcode_exist = TRUE;
		} else if (strcmp(buf_qrcode, "0") == 0) {
			s_mmi_qrcode_exist = FALSE;
		} else {
			slog(MMI_PRINT, SLOG_ERR, "MMI  qrcode file state error!\n");
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI read qrcode file fail!\n");
	}

	fclose(fd_qrcode);

	if (mmi_get_wificode_show_flag() == TRUE && s_mmi_qrcode_existPre == FALSE && s_mmi_qrcode_exist == TRUE) {
		mmi_set_update_flag(MMI_TASK_WIFICODE);
	}

	s_mmi_qrcode_existPre = s_mmi_qrcode_exist;
	return 0;
}

BOOL mmi_get_qrcode_state()
{
	return s_mmi_qrcode_exist ;
}
/**********************************************************************************
:wifi\ر״̬
***********************************************************************************/
VOID mmi_set_wifi_state(VOID)
{
	char buf_wifi[8] = {0};
	FILE* fd_wifi = NULL;
	int len = 0;

	fd_wifi = fopen(WIFI_STATE_PATH, "r");
	if (fd_wifi == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_set_wifi_state open wifi file fail!\n");
		perror(WIFI_STATE_PATH);
		return;
	}
	len = fread(buf_wifi, 1, 1, fd_wifi);
	if (len > 0) { //kw 3
		buf_wifi[len] = '\0';
		if (strcmp(buf_wifi, "1") == 0) {
			s_mmi_wifiState = TRUE;
			ipc_send_message(MODULE_ID_MMI, MODULE_ID_MMI, (USHORT)MSG_CMD_STA_COUNT_CHANGE, 0, NULL, 0);
		} else if (strcmp(buf_wifi, "0") == 0) {
			s_mmi_wifiState = FALSE;
			s_mmi_wpsState = WPS_ACTIVE_MAX;
			s_mmi_Isconnected_user = 0;
			s_mmi_wifi_connect_num = 0;
			//#if MMI_LED_STANDBY_MODE
			if (g_led_standby_mode && mmi_get_led_mode() == MMI_IDLE_LEDOFF_MODE) {
				mmi_set_led_mode(MMI_IDLE_STANDBY_LEDOFF_MODE);
				mmi_set_update_flag(MMI_TASK_CTRL);
			}
			//#endif
		} else {
			slog(MMI_PRINT, SLOG_ERR, "MMI wifi file state error!\n");
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI read wifi file fail!\n");
	}

	fclose(fd_wifi);
}

/**********************************************************************************
:wps\ر״̬
***********************************************************************************/
static VOID mmi_set_wps_state(VOID)
{
	char buf_wps[8] = {0};
	FILE* fd_wps = NULL;
	int len = 0;


	fd_wps = fopen(WPS_STATE_PATH, "r");
	if (fd_wps == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_set_wifi_state open wps file fail!\n");
		perror(WPS_STATE_PATH);
		return;
	}
	len = fread(buf_wps, 1, 1, fd_wps);
	if (len > 0) { //kw 3
		buf_wps[len] = '\0';
		if (strcmp(buf_wps, "1") == 0) {
			s_mmi_wpsState = WPS_ACTIVING;
		} else if (strcmp(buf_wps, "0") == 0) {
			s_mmi_wpsState = WPS_DEACTIVED;
			mmi_wps_tip_timer_start();
		} else {
			slog(MMI_PRINT, SLOG_ERR, "MMI wps file state error!\n");
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI read wps file fail!\n");
	}

	fclose(fd_wps);
}

static VOID mmi_set_wpsEx_state(VOID)
{
	char buf_wps[8] = {0};
	FILE* fd_wps = NULL;
	int len = 0;

	fd_wps = fopen(WPS_STATEEX_PATH, "r");
	if (fd_wps == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_set_wifi_state open wpsEX file fail!\n");
		perror(WPS_STATEEX_PATH);
		return;
	}
	len = fread(buf_wps, 1, 1, fd_wps);
	if (len > 0) { //kw 3
		buf_wps[len] = '\0';
		if (strcmp(buf_wps, "1") == 0) {
			s_mmi_wpsState = WPS_ACTIVED;
			mmi_wps_tip_timer_start();
		} else if (strcmp(buf_wps, "2") == 0) {
			s_mmi_wpsState = WPS_DEACTIVING;
		} else {
			slog(MMI_PRINT, SLOG_ERR, "MMI  wps file state error!\n");
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI read wps file fail!\n");
	}

	fclose(fd_wps);
}
/**********************************************************************************
:wifiStation\ر״̬
***********************************************************************************/
VOID mmi_set_wifiStation_state(VOID)
{
	char buf_wifiStation[8] = {0};
	FILE* fd_wifiStation = NULL;
	int len = 0;


	fd_wifiStation = fopen(WIFI_STATION_PATH, "r");
	if (fd_wifiStation == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_set_wifiStation_state open wifiStation file fail!\n");
		perror(WIFI_STATION_PATH);
		return;
	}
	len = fread(buf_wifiStation, 1, 1, fd_wifiStation);
	if (len > 0) { //kw 3
		buf_wifiStation[len] = '\0';
		if (strcmp(buf_wifiStation, "F") == 0) {
			s_mmi_wifiStationConnected = FALSE;
		} else {
			s_mmi_wifiStationConnected = TRUE;
			mmi_get_wifiStation_ssid_from_nv();
			if (strcmp(buf_wifiStation, "4") == 0) {
				s_mmi_wifistation_signal_num = 4;
			} else if (strcmp(buf_wifiStation, "3") == 0) {
				s_mmi_wifistation_signal_num = 3;
			} else if (strcmp(buf_wifiStation, "2") == 0) {
				s_mmi_wifistation_signal_num = 2;
			} else if (strcmp(buf_wifiStation, "1") == 0) { //cov m
				s_mmi_wifistation_signal_num = 1;
			} else if (strcmp(buf_wifiStation, "0") == 0) {
				s_mmi_wifistation_signal_num = 0;
			} else {
				slog(MMI_PRINT, SLOG_ERR, "MMI  wifiStation file state error!\n");
			}
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI read wifiStation file fail!\n");
	}
	fclose(fd_wifiStation);
}


/**********************************************************************************
:wifiָʾ߳ں
***********************************************************************************/
static void mmi_wifiwps_file_operate(char *filename)
{
	if (filename == NULL) {
		return;
	}
	if (strcmp(filename, WIFI_STATE_PATH) == 0) {
		mmi_set_wifi_state();
		mmi_set_wifi_update();
		mmi_set_update_flag(MMI_TASK_LED_WPS);
	} else if (strcmp(filename, WPS_STATE_PATH) == 0) {
		mmi_set_wps_state();
		mmi_set_wifi_update();
		mmi_set_update_flag(MMI_TASK_TIP_WPS);
		mmi_set_update_flag(MMI_TASK_LED_WPS);
	} else if (strcmp(filename, WPS_STATEEX_PATH) == 0) {
		mmi_set_wpsEx_state();
		mmi_set_wifi_update();
		mmi_set_update_flag(MMI_TASK_TIP_WPS);
		mmi_set_update_flag(MMI_TASK_LED_WPS);
	} else if (strcmp(filename, QRCODE_STATE_PATH) == 0) {
		mmi_set_qrcode_state();
	} else if (strcmp(filename, WIFI_STATION_PATH) == 0) {
		mmi_set_wifiStation_state();
		mmi_set_update_flag(MMI_TASK_TIP_WIFISTATION);
	}
}

void *mmi_wifi_thread_function(void *arg)
{
	int fd = -1;
	int wd;
	char buffer[1024] = {0};
	char *offset = NULL;
	struct inotify_event *event = NULL;
	int len = 0;
	int tmp_len = 0;
	int offs_len = 0;
	int i = 0;

	fd = inotify_init();
	if (fd < 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI fail to inotify_init\n");
		assert(0);
	}
	prctl(PR_SET_NAME, "mmiwificheck", 0, 0, 0);
	file_wd[0].filename = WIFI_STATE_PATH;
	wd = inotify_add_watch(fd, file_wd[0].filename, IN_CLOSE_WRITE);
	if (wd < 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI can't add watch for %s\n", file_wd[0].filename);
	}
	file_wd[0].wd = wd;

	file_wd[1].filename = WPS_STATE_PATH;
	wd = inotify_add_watch(fd, file_wd[1].filename, IN_CLOSE_WRITE);
	if (wd < 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI can't add watch for %s\n", file_wd[1].filename);
	}
	file_wd[1].wd = wd;

	file_wd[3].filename = WPS_STATEEX_PATH;
	wd = inotify_add_watch(fd, file_wd[3].filename, IN_CLOSE_WRITE);
	if (wd < 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI can't add watch for %s\n", file_wd[3].filename);
	}
	file_wd[3].wd = wd;
	
#ifndef DISABLE_LCD
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		file_wd[2].filename = QRCODE_STATE_PATH;
		wd = inotify_add_watch(fd, file_wd[2].filename, IN_CLOSE_WRITE);
		if (wd < 0) {
			slog(MMI_PRINT, SLOG_ERR, "MMI can't add watch for %s\n", file_wd[2].filename);
		}
		file_wd[2].wd = wd;

		file_wd[4].filename = WIFI_STATION_PATH;
		wd = inotify_add_watch(fd, file_wd[4].filename, IN_CLOSE_WRITE);
		if (wd < 0) {
			slog(MMI_PRINT, SLOG_ERR, "MMI can't add watch for %s\n", file_wd[4].filename);
		}
		file_wd[4].wd = wd;
	}
#endif

	while (1) {
		if ((len = read(fd, buffer, 1024)) > 0) { //kw 3
			offset = buffer;
			offs_len = 0;

			event = (struct inotify_event *)buffer;
			while ((char *)event - buffer < len) {
				int event_len = event->len;
				if (event_len < 0 || event_len > INT_MAX-1) {//kw 3, <len-offs_len
					slog(MMI_PRINT, SLOG_ERR, "MMI mmi_wifi_thread_function %d!!\n", event_len);
					break;
				}
				for (i = 0; i < WD_NUM; i++) {
					if (event->wd != file_wd[i].wd) {
						continue;
					}
					mmi_wifiwps_file_operate(file_wd[i].filename);
					break;
				}
				tmp_len = sizeof(struct inotify_event *) + event_len;
				offs_len += tmp_len;
				if (offs_len > len)//kw
					break;
				event = (struct inotify_event *)(offset + tmp_len);
				offset += tmp_len;
			}
		}
	}

}

/**********************************************************************************
:create ̼߳wifiļ仯
***********************************************************************************/
static VOID mmi_create_wifi_inotify_thread(VOID)
{
	pthread_t mmi_wifi_thread;
	if (pthread_create(&mmi_wifi_thread, NULL, &mmi_wifi_thread_function, NULL) == -1) {
		slog(MMI_PRINT, SLOG_ERR, "MMI create wifi thread error!\n");
		MMI_ASSERT(0);
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI create wifi_thread success!!!\n");
}

/**********************************************************************************
:MMI wifiݴѭⶨʱKILL  ػʱ
***********************************************************************************/
VOID mmi_kill_wifi_data_timer(VOID)
{
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		mmi_wifi_data_timer_stop();
	}
}

/**********************************************************************************
:wifiָʾƳʼ ûص
***********************************************************************************/
VOID mmi_wifi_init(VOID)
{
	mmi_set_wifi_state();
	mmi_set_wifi_update();
	mmi_set_qrcode_state();
	mmi_create_wifi_inotify_thread();
	mmi_wifi_data_timer_create();
	if (g_use_wifi_usernum) {
		mmi_get_wifi_stanum();
	}
}

