#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "softap_api.h"
#include "lpa_api.h"

int main(int argc, char *argv[])
{
	int poll_num = 1;
	int poll_interval = 0;
	
	printf("##lpa start##\n");

	if (-1 == lpa_init()) {
		printf("lpa init fail!\n");
		return -1;
	}

	lpa_exception_process();

	do {
		int next_step = 0;
		char *command = NULL;
//dtest
//char activecode[] = "1$esim.wo.cn$$1.3.6.1.4.1.47814.2.4";
//lpa_download_profile(activecode, NULL);
//lpa_enable_profile("98689091170012145989");
//lpa_memory_reset();
//return 0;
		command = lpa_trigger_event(&next_step);

		switch (next_step) {
			case 1:
				lpa_download_profile(command, NULL);
				break;
			case 2:
				lpa_enable_profile(command);
				break;
			case 3:
				lpa_disable_profile(command);
				break;
			case 4:
				lpa_delete_profile(command);
				break;
			case 5:
				lpa_memory_reset();
				break;

			default:
				break;
		}
		if (command != NULL) 
			free(command);

		sleep(poll_interval);
		poll_num--;
	} while (poll_num > 0);

	lpa_uninit();
	printf("##lpa end##\n");
    return 0;
}

