/*
 * 
 * Copyright (C)  2023
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details
 *
 * FileName : log_usb.h
 * This program Capture module's trace log.
 */

#ifndef __LOG_USB_H__
#define __LOG_USB_H__

#include <fcntl.h>
#include <termios.h>
#include <poll.h>
#include "../zlog_com.h"

#define ZLOG_BUF_SIZE               (512)
#define ZLOG_SHELL_CMD_SIZE         (64)

#define MAX_USBFS_BULK_IN_SIZE      (4 * 1024)
#define MAX_USBFS_BULK_OUT_SIZE     (4 * 1024)
#define USB_TTY_DEV                 "/dev/ttyUSB0"

//common define
#define MIN(X, Y) ((X)<(Y))? (X):(Y)

typedef struct
{
    char *portname;
    int ttyfd;
} usbdev_t;

int zLogAgt_Usb_Write(usbdev_t *udev, char *pbuf, int size);
int zLogAgt_Usb_Read(usbdev_t *udev, char *pbuf, int size);
int zLogAgt_Usb_Close(usbdev_t *udev);

#endif

