#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdint.h>
#include <stdbool.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include <tinyalsa/asoundlib.h>
#include <sound/asound.h>
#include <tinyalsa/audio_mixer_ctrl.h>

#define ARRAY_SIZE(a) (sizeof (a) / sizeof ((a)[0]))

struct audio_para_conf {
	const char *control;
	char *values[2];
};




#if defined _USE_CODEC_ES8374


enum t_output_vol {
    T_OUTPUT_VOL_MINUS_96DB = 0,
    T_OUTPUT_VOL_MINUS_95DB = 2,
    T_OUTPUT_VOL_MINUS_90DB = 12,
    T_OUTPUT_VOL_MINUS_85DB = 22,
    T_OUTPUT_VOL_MINUS_80DB = 32,
    T_OUTPUT_VOL_MINUS_75DB = 42,
    T_OUTPUT_VOL_MINUS_70DB = 52,
    T_OUTPUT_VOL_MINUS_65DB = 62,
    T_OUTPUT_VOL_MINUS_60DB = 72,
    T_OUTPUT_VOL_MINUS_55DB = 82,
    T_OUTPUT_VOL_MINUS_50DB = 92,
    T_OUTPUT_VOL_MINUS_45DB = 102,
    T_OUTPUT_VOL_MINUS_40DB = 112,
    T_OUTPUT_VOL_MINUS_35DB = 122,
    T_OUTPUT_VOL_MINUS_30DB = 132,
    T_OUTPUT_VOL_MINUS_25DB = 142,
    T_OUTPUT_VOL_MINUS_20DB = 152,
    T_OUTPUT_VOL_MINUS_15DB = 162,
    T_OUTPUT_VOL_MINUS_10DB = 172,
    T_OUTPUT_VOL_MINUS_7DB  = 178,
    T_OUTPUT_VOL_MINUS_6DB  = 180,
    T_OUTPUT_VOL_MINUS_5DB  = 182,
    T_OUTPUT_VOL_MINUS_4DB  = 184,
    T_OUTPUT_VOL_MINUS_3DB  = 186,
    T_OUTPUT_VOL_MINUS_2DB  = 188,
    T_OUTPUT_VOL_MINUS_1DB  = 190,
    T_OUTPUT_VOL_0DB        = 192
};

enum t_input_vol {
    T_INPUT_VOL_MINUS_96DB = 0,
    T_INPUT_VOL_MINUS_95DB = 2,
    T_INPUT_VOL_MINUS_90DB = 12,
    T_INPUT_VOL_MINUS_85DB = 22,
    T_INPUT_VOL_MINUS_80DB = 32,
    T_INPUT_VOL_MINUS_75DB = 42,
    T_INPUT_VOL_MINUS_70DB = 52,
    T_INPUT_VOL_MINUS_65DB = 62,
    T_INPUT_VOL_MINUS_60DB = 72,
    T_INPUT_VOL_MINUS_55DB = 82,
    T_INPUT_VOL_MINUS_50DB = 92,
    T_INPUT_VOL_MINUS_45DB = 102,
    T_INPUT_VOL_MINUS_40DB = 112,
    T_INPUT_VOL_MINUS_35DB = 122,
    T_INPUT_VOL_MINUS_30DB = 132,
    T_INPUT_VOL_MINUS_25DB = 142,
    T_INPUT_VOL_MINUS_20DB = 152,
    T_INPUT_VOL_MINUS_15DB = 162,
    T_INPUT_VOL_MINUS_10DB = 172,
    T_INPUT_VOL_MINUS_7DB  = 178,
    T_INPUT_VOL_MINUS_6DB  = 180,
    T_INPUT_VOL_MINUS_5DB  = 182,
    T_INPUT_VOL_MINUS_4DB  = 184,
    T_INPUT_VOL_MINUS_3DB  = 186,
    T_INPUT_VOL_MINUS_2DB  = 188,
    T_INPUT_VOL_MINUS_1DB  = 190,
    T_INPUT_VOL_0DB        = 192
};


static struct audio_para_conf init_default_para[] = {  //ʼ
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ALC MUX", {"0"}},
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},
	{"ADC Capture Volume", {"192"}},
	{"ALC Capture Max PGA", {"15"}},
	{"DAC MUTE", {"0"}},
	{"DAC Playback Volume", {"120"}},
	{"DAC SDP SRC MUX",  {"0"}},
	{"DAC SRC MUX",  {"0"}}
};

//#ifdef  _USE_7520V3_PHONE_TYPE_C31F
#if ( defined _USE_7520V3_PHONE_TYPE_C31F || defined _USE_7520V3_PHONE_TYPE_WTWD )

static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"DAC MUTE", {"0"}},
	//{"DAC Playback Volume", {"120"}},
	{"DAC SDP SRC MUX",  {"0"}},
	{"DAC SRC MUX",  {"0"}}
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},
#if 0
	{"ALC MUX", {"1"}},
	{"ALC Capture Target Volume", {"5"}},
	{"ALC Capture Max PGA", {"11"}},
	{"ALC Capture Min PGA", {"2"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"0"}},
	{"ALC Capture Attack Time", {"0"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},
	{"ADC Capture Volume", {"192"}},
};

#ifdef _USE_7520V3_PHONE_TYPE_WTWD
static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}},
	{"SPEAKER MIXER GAIN", {"41"}},		//1d
	{"SPEAKER OUTPUT Volume", {"0"}},	//1e
	{"DAC Playback Volume", {"192"}}, //38
};
#else
static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"audio path select", {"handset"}},
};

#endif
/*
static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
	{"SPEAKER MIXER GAIN", {"4"}},
	{"SPEAKER OUTPUT Volume", {"4"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}}
};
*/

static struct audio_para_conf  spk_outpath_para_audio[] = {  //ӦSpkͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"11"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"audio path select", {"speak"}},
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦLin1-Rin1ͨ
	{"DIFFERENTIAL MUX", {"1"}},
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦLin2-Rin2ͨ
	{"DIFFERENTIAL MUX", {"2"}},
};

#ifdef _USE_7520V3_PHONE_TYPE_WTWD

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	//{"voice processing path select", {"headset"}},  // handset speak headset bluetooth
	{"voice processing path select", {"handset"}},	// handset speak headset bluetooth
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},
	{"ADC Capture Volume", {"192"}},

	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}},
	{"SPEAKER MIXER GAIN", {"32"}},	//old 41
	{"SPEAKER OUTPUT Volume", {"0"}},	//1
	{"DAC Playback Volume", {"192"}}, //38
};

#else
static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"11"}},
	{"DAC Playback Volume", {"192"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
};
#endif
static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"voice processing select", {"headset"}}, // handset speak headset bluetooth
};
#ifdef _USE_7520V3_PHONE_TYPE_WTWD //class-d -->receiver
static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"186"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
};
#else//momo out -> speaker
static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"6"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"0"}},
	{"DAC Playback Volume", {"186"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
};

#endif



#else
static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"DAC MUTE", {"0"}},
	//{"DAC Playback Volume", {"120"}},
	{"DAC SDP SRC MUX",  {"0"}},
	{"DAC SRC MUX",  {"0"}}
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},
#if 1
	{"ALC MUX", {"1"}},
	{"ALC Capture Target Volume", {"5"}},
	{"ALC Capture Max PGA", {"11"}},
	{"ALC Capture Min PGA", {"2"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"0"}},
	{"ALC Capture Attack Time", {"0"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"3"}},
	{"ADC Capture Volume", {"180"}},
};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}}
};

/*
static struct audio_para_conf  spk_outpath_para_audio[] = { //ӦSpkͨ
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
	{"SPEAKER MIXER GAIN", {"4"}},
	{"SPEAKER OUTPUT Volume", {"4"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"1"}}
};
*/

static struct audio_para_conf  spk_outpath_para_audio[] = {  //ӦSpkͨ
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"3"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}}
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦLin1-Rin1ͨ
	{"DIFFERENTIAL MUX", {"1"}},
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦLin2-Rin2ͨ
	{"DIFFERENTIAL MUX", {"2"}},
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"voice processing select", {"headset"}}, // handset speak headset bluetooth
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"SDP OUT MUX", {"0"}},
	{"ADC Soft Ramp", {"0"}},
	{"ADC HPF COEFFICIENT", {"5"}},

	{"ALC MUX", {"0"}},
#if 0
	{"ALC Capture Target Volume", {"7"}},
	{"ALC Capture Max PGA", {"13"}},
	{"ALC Capture Min PGA", {"8"}},
	{"ALC Capture Hold Time", {"0"}},
	{"ALC Capture Decay Time", {"1"}},
	{"ALC Capture Attack Time", {"2"}},
	{"ALC WIN SIZE", {"6"}},
	{"ALC Capture NG Threshold", {"14"}},
	{"ALC Capture NG Type", {"0"}},
	{"ALC Capture NG Switch", {"0"}},
#endif
	{"D2SE MIC BOOST GAIN", {"1"}},
	{"LIN PGA GAIN", {"7"}},
	{"ADC Capture Volume", {"192"}},
	{"SPEAKER MIXER DAC TO SPEAKER OUT Switch", {"0"}},
	{"MONO OUT GAIN", {"4"}},
	{"DAC Playback Volume", {"190"}},
	{"MONO MIXER DAC TO MONO OUT Switch", {"1"}},
	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
};

#endif

static struct audio_para_conf output_dac_vol = {"DAC Playback Volume", {"120"}};

static struct audio_para_conf input_adc_vol = {"ADC Capture Volume", {"192"}};

static struct audio_para_conf dac_mute = {"DAC MUTE", {"1"}};
static struct audio_para_conf adc_mute = {"ADC MUTE", {"1"}};

static struct audio_para_conf spk_path_onoff[] = {
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
};

static struct audio_para_conf rcv_path_onoff[] = {
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
};

static struct audio_para_conf earp_path_onoff[] = {
	{"MONO MIXER DAC TO MONO OUT Switch", {"0"}},
};


static int output_vol_conversion(int vol)
{
	switch (vol) {
	case T_AUDIO_OUTPUT_VOL_LEVEL_0:
		return T_OUTPUT_VOL_MINUS_96DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_1:
		return T_OUTPUT_VOL_MINUS_45DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_2:
		return T_OUTPUT_VOL_MINUS_40DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_3:
		return T_OUTPUT_VOL_MINUS_35DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_4:
		return T_OUTPUT_VOL_MINUS_30DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_5:
		return T_OUTPUT_VOL_MINUS_25DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_6:
		return T_OUTPUT_VOL_MINUS_20DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_7:
		return T_OUTPUT_VOL_MINUS_15DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_8:
		return T_OUTPUT_VOL_MINUS_10DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_9:
		return T_OUTPUT_VOL_MINUS_6DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_10:
		return T_OUTPUT_VOL_MINUS_3DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_11:
		return T_OUTPUT_VOL_0DB;
	default:
		return T_OUTPUT_VOL_0DB;
	}
}

static int input_vol_conversion(int vol)
{
	switch (vol) {
	case T_AUDIO_INPUT_VOL_LEVEL_0:
		return T_INPUT_VOL_MINUS_96DB;
	case T_AUDIO_INPUT_VOL_LEVEL_1:
		return T_INPUT_VOL_MINUS_30DB;
	case T_AUDIO_INPUT_VOL_LEVEL_2:
		return T_INPUT_VOL_MINUS_25DB;
	case T_AUDIO_INPUT_VOL_LEVEL_3:
		return T_INPUT_VOL_MINUS_20DB;
	case T_AUDIO_INPUT_VOL_LEVEL_4:
		return T_INPUT_VOL_MINUS_15DB;
	case T_AUDIO_INPUT_VOL_LEVEL_5:
		return T_INPUT_VOL_MINUS_10DB;
	case T_AUDIO_INPUT_VOL_LEVEL_6:
		return T_INPUT_VOL_MINUS_7DB;
	case T_AUDIO_INPUT_VOL_LEVEL_7:
		return T_INPUT_VOL_MINUS_4DB;
	case T_AUDIO_INPUT_VOL_LEVEL_8:
		return T_INPUT_VOL_MINUS_3DB;
	case T_AUDIO_INPUT_VOL_LEVEL_9:
		return T_INPUT_VOL_MINUS_2DB;
	case T_AUDIO_INPUT_VOL_LEVEL_10:
		return T_INPUT_VOL_MINUS_1DB;
	case T_AUDIO_INPUT_VOL_LEVEL_11:
		return T_INPUT_VOL_0DB;
	default:
		return T_INPUT_VOL_MINUS_30DB;
	}
}

#elif defined _USE_CODEC_ES8312

enum t_output_vol {
    T_OUTPUT_VOL_MINUS_95_5DB = 0,
    T_OUTPUT_VOL_MINUS_90DB = 11,
    T_OUTPUT_VOL_MINUS_85DB = 21,
    T_OUTPUT_VOL_MINUS_80DB = 31,
    T_OUTPUT_VOL_MINUS_75DB = 41,
    T_OUTPUT_VOL_MINUS_70DB = 51,
    T_OUTPUT_VOL_MINUS_65DB = 61,
    T_OUTPUT_VOL_MINUS_60DB = 71,
    T_OUTPUT_VOL_MINUS_55DB = 81,
    T_OUTPUT_VOL_MINUS_50DB = 91,
    T_OUTPUT_VOL_MINUS_45DB = 101,
    T_OUTPUT_VOL_MINUS_40DB = 111,
    T_OUTPUT_VOL_MINUS_35DB = 121,
    T_OUTPUT_VOL_MINUS_30DB = 131,
    T_OUTPUT_VOL_MINUS_25DB = 141,
    T_OUTPUT_VOL_MINUS_20DB = 151,
    T_OUTPUT_VOL_MINUS_15DB = 161,
    T_OUTPUT_VOL_MINUS_10DB = 171,
    T_OUTPUT_VOL_MINUS_7DB  = 177,
    T_OUTPUT_VOL_MINUS_6DB  = 179,
    T_OUTPUT_VOL_MINUS_5DB  = 181,
    T_OUTPUT_VOL_MINUS_4DB  = 183,
    T_OUTPUT_VOL_MINUS_3DB  = 185,
    T_OUTPUT_VOL_MINUS_2DB  = 187,
    T_OUTPUT_VOL_MINUS_1DB  = 189,
    T_OUTPUT_VOL_0DB        = 191,
    T_OUTPUT_VOL_32DB       = 255
};

enum t_input_vol {
    T_INPUT_VOL_MINUS_95_5DB = 0,
    T_INPUT_VOL_MINUS_90DB = 11,
    T_INPUT_VOL_MINUS_85DB = 21,
    T_INPUT_VOL_MINUS_80DB = 31,
    T_INPUT_VOL_MINUS_75DB = 41,
    T_INPUT_VOL_MINUS_70DB = 51,
    T_INPUT_VOL_MINUS_65DB = 61,
    T_INPUT_VOL_MINUS_60DB = 71,
    T_INPUT_VOL_MINUS_55DB = 81,
    T_INPUT_VOL_MINUS_50DB = 91,
    T_INPUT_VOL_MINUS_45DB = 101,
    T_INPUT_VOL_MINUS_40DB = 111,
    T_INPUT_VOL_MINUS_35DB = 121,
    T_INPUT_VOL_MINUS_30DB = 131,
    T_INPUT_VOL_MINUS_25DB = 141,
    T_INPUT_VOL_MINUS_20DB = 151,
    T_INPUT_VOL_MINUS_15DB = 161,
    T_INPUT_VOL_MINUS_10DB = 171,
    T_INPUT_VOL_MINUS_7DB  = 177,
    T_INPUT_VOL_MINUS_6DB  = 179,
    T_INPUT_VOL_MINUS_5DB  = 181,
    T_INPUT_VOL_MINUS_4DB  = 183,
    T_INPUT_VOL_MINUS_3DB  = 185,
    T_INPUT_VOL_MINUS_2DB  = 187,
    T_INPUT_VOL_MINUS_1DB  = 199,
    T_INPUT_VOL_0DB        = 191,
    T_INPUT_VOL_32DB      = 255
};


static struct audio_para_conf init_default_para[] = {  //ʼ
	{"DMIC MUX", {"0"}},
	{"DAC SDP MUTE", {"0"}},
	{"ADC SDP MUTE", {"0"}},
};

static struct audio_para_conf  common_out_para_audio[] = {  //Ӧ
	{"DAC SDP SRC MUX", {"0"}},
	{"DAC SDP MUTE", {"0"}},
};

static struct audio_para_conf  common_in_para_audio[] = {  //Ӧ
	{"DMIC MUX", {"0"}},
	{"ALC MUX", {"0"}},
	{"SDP OUT MUX", {"1"}},
	{"MIC PGA GAIN", {"10"}},
};

static struct audio_para_conf  hp_outpath_para_audio[] = {  //ӦHpͨ
//	{"DAC SDP SRC MUX", {"0"}},
	{"DRC MUX", {"0"}},
	//{"DRC EQ MUX", {"1"}},
};

static struct audio_para_conf  spk_outpath_para_audio[] = {  //ӦSpkͨ
//	{"DAC SDP SRC MUX", {"0"}},
	{"DRC MUX", {"0"}},
	//{"DRC EQ MUX", {"1"}},
};

static  struct  audio_para_conf  main_mic_inpath_para_audio[] = { //ӦLin1-Rin1ͨ
	{"DIFFERENTIAL MUX", {"1"}},
};

static  struct  audio_para_conf  aux_mic_inpath_para_audio[] = {//ӦLin2-Rin2ͨ
	{"DIFFERENTIAL MUX", {"2"}},
};

static struct audio_para_conf  handset_inoutpath_para_voice[] = {  //ӦHpͨMic1lp_Mic1lmͨ
	{"voice processing path select", {"handset"}},  // handset speak headset bluetooth
	{"DAC SDP SRC MUX", {"0"}},
	{"DRC MUX", {"0"}},
	//{"DRC EQ MUX", {"1"}},
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"ALC MUX", {"0"}},
	{"ALC MAX LEVEL", {"10"}},
	{"ALC MIN LEVEL", {"0"}},
	{"SDP OUT MUX", {"1"}},
	{"MIC PGA GAIN", {"8"}},
	{"ADC VOLUME", {"191"}},
	{"DAC VOLUME", {"190"}},
	{"DAC SDP MUTE", {"0"}},
	{"ADC SDP MUTE", {"0"}},
};

static struct audio_para_conf  headset_inoutpath_para_voice[] = {  //ӦHpͨ Mic1rpͨ
	{"DAC SDP SRC MUX", {"0"}},
	{"DRC MUX", {"0"}},
	//{"DRC EQ MUX", {"1"}},
	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"ALC MUX", {"0"}},
	{"ALC MAX LEVEL", {"10"}},
	{"ALC MIN LEVEL", {"0"}},
	{"SDP OUT MUX", {"1"}},
	{"MIC PGA GAIN", {"8"}},
	{"ADC VOLUME", {"191"}},
	{"DAC VOLUME", {"190"}},
	{"DAC SDP MUTE", {"0"}},
	{"ADC SDP MUTE", {"0"}},
	{"voice processing path select", {"headset"}}, // handset speak headset bluetooth
};

static struct audio_para_conf  spk_inoutpath_para_voice[] = { //ӦSpkͨMic1lp_Mic1lmͨ
	{"DAC SDP SRC MUX", {"0"}},
	{"DRC MUX", {"0"}},
	//{"DRC EQ MUX", {"1"}},
	{"DAC VOLUME", {"190"}},
	{"DAC SDP MUTE", {"0"}},

	{"DIFFERENTIAL MUX", {"1"}},
	{"DMIC MUX", {"0"}},
	{"ALC MUX", {"0"}},
	{"ALC MAX LEVEL", {"10"}},
	{"ALC MIN LEVEL", {"0"}},
	{"SDP OUT MUX", {"1"}},
	{"MIC PGA GAIN", {"8"}},
	{"ADC VOLUME", {"191"}},
	/*
	{"ALC MUX", {"0"}},
	{"SDP OUT MUX", {"1"}},
	{"MIC PGA GAIN", {"10"}},
	{"ADC VOLUME", {"191"}},*/
	{"ADC SDP MUTE", {"0"}},

	{"voice processing path select", {"speak"}}, // handset speak headset bluetooth
};

static struct audio_para_conf output_dac_vol = {"DAC VOLUME", {"190"}};

static struct audio_para_conf input_adc_vol = {"ADC VOLUME", {"191"}};

static struct audio_para_conf dac_mute = {"DAC SDP MUTE", {"0"}};
static struct audio_para_conf adc_mute = {"ADC SDP MUTE", {"0"}};


static struct audio_para_conf spk_path_onoff[] = {
	{"DAC SDP MUTE", {"0"}},
};

static struct audio_para_conf rcv_path_onoff[] = {
	{"DAC SDP MUTE", {"0"}},
};

static struct audio_para_conf earp_path_onoff[] = {
	{"DAC SDP MUTE", {"0"}},
};


static int output_vol_conversion(int vol)
{
	switch (vol) {
	case T_AUDIO_OUTPUT_VOL_LEVEL_0:
		return T_INPUT_VOL_MINUS_95_5DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_1:
		return T_OUTPUT_VOL_MINUS_60DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_2:
		return T_OUTPUT_VOL_MINUS_55DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_3:
		return T_OUTPUT_VOL_MINUS_50DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_4:
		return T_OUTPUT_VOL_MINUS_45DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_5:
		return T_OUTPUT_VOL_MINUS_40DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_6:
		return T_OUTPUT_VOL_MINUS_35DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_7:
		return T_OUTPUT_VOL_MINUS_30DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_8:
		return T_OUTPUT_VOL_MINUS_25DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_9:
		return T_OUTPUT_VOL_MINUS_20DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_10:
		return T_OUTPUT_VOL_MINUS_15DB;
	case T_AUDIO_OUTPUT_VOL_LEVEL_11:
		return T_OUTPUT_VOL_MINUS_10DB;
	default:
		return T_OUTPUT_VOL_MINUS_10DB;
	}
}

static int input_vol_conversion(int vol)
{
	switch (vol) {
	case T_AUDIO_INPUT_VOL_LEVEL_0:
		return T_INPUT_VOL_MINUS_95_5DB;
	case T_AUDIO_INPUT_VOL_LEVEL_1:
		return T_INPUT_VOL_MINUS_50DB;
	case T_AUDIO_INPUT_VOL_LEVEL_2:
		return T_INPUT_VOL_MINUS_45DB;
	case T_AUDIO_INPUT_VOL_LEVEL_3:
		return T_INPUT_VOL_MINUS_40DB;
	case T_AUDIO_INPUT_VOL_LEVEL_4:
		return T_INPUT_VOL_MINUS_35DB;
	case T_AUDIO_INPUT_VOL_LEVEL_5:
		return T_INPUT_VOL_MINUS_30DB;
	case T_AUDIO_INPUT_VOL_LEVEL_6:
		return T_INPUT_VOL_MINUS_25DB;
	case T_AUDIO_INPUT_VOL_LEVEL_7:
		return T_INPUT_VOL_MINUS_20DB;
	case T_AUDIO_INPUT_VOL_LEVEL_8:
		return T_INPUT_VOL_MINUS_15DB;
	case T_AUDIO_INPUT_VOL_LEVEL_9:
		return T_INPUT_VOL_MINUS_10DB;
	case T_AUDIO_INPUT_VOL_LEVEL_10:
		return T_INPUT_VOL_MINUS_7DB;
	case T_AUDIO_INPUT_VOL_LEVEL_11:
		return T_INPUT_VOL_0DB;
	default:
		return T_INPUT_VOL_0DB;
	}
}

#endif

//static struct audio_para_conf nxp_voice_vol = 	{"voice processing path Volume",{"3"}}; //(range 0->5)

static void mix_set_value_wrap(struct mixer *mixer, const char *control, char **values)
{
	struct mixer_ctl *ctl;
	enum mixer_ctl_type type;
	unsigned int num_ctl_values;
	unsigned int i;

	if (isdigit(control[0]))
		ctl = mixer_get_ctl(mixer, atoi(control));
	else
		ctl = mixer_get_ctl_by_name(mixer, control);

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return;
	}

	type = mixer_ctl_get_type(ctl);
	num_ctl_values = mixer_ctl_get_num_values(ctl);

	if (isdigit(values[0][0])) {

		for (i = 0; i < num_ctl_values; i++) {
			if (mixer_ctl_set_value(ctl, i, atoi(values[i]))) {
				fprintf(stderr, "Error: invalid value for index %d\n", i);
				return;
			}
		}

	} else {
		if (type == MIXER_CTL_TYPE_ENUM) {
			/*if (num_values != 1) {
			    fprintf(stderr, "Enclose strings in quotes and try again\n");
			    return;
			}*/
			if (mixer_ctl_set_enum_by_string(ctl, values[0]))
				fprintf(stderr, "Error: invalid enum value\n");
		} else {
			fprintf(stderr, "Error: only enum types can be set with strings\n");
		}
	}
}

#ifdef _CPE_AUDIO_PRJ
int mix_set_output_path(struct mixer *mixer, int path)
{

	return 0;
}

int mix_set_input_path(struct mixer *mixer, int path)
{


	return 0;
}

int mix_set_input_vol(struct mixer *mixer, int volume)
{


	return 0;
}

int mix_set_output_vol(struct mixer *mixer, int volume)
{


	return 0;
}

int mix_set_output_mute(struct mixer *mixer, bool enable)
{


	return 0;
}

int mix_set_input_mute(struct mixer *mixer, bool enable)
{


	return 0;
}

int mix_set_outputpath_onoff(struct mixer *mixer, int path , bool onoff)
{

	return 0;
}


int mix_set_voice_vol(struct mixer *mixer, int volume)
{


	return 0;
}

int mix_set_voice_mute(struct mixer *mixer, bool enable)
{


	return 0;
}

int mix_set_voice_path(struct mixer *mixer, int path)
{
	int i;


	return 0;
}


int mix_set_in_call_tone(struct mixer *mixer, int tontype)
{


	return 0;
}

int mix_set_default_param(struct mixer *mixer)
{

	return 0;
}
#else
int mix_set_output_path(struct mixer *mixer, int path)
{
	int i;
	for (i = 0; i < ARRAY_SIZE(common_out_para_audio); i++) {
		mix_set_value_wrap(mixer, common_out_para_audio[i].control, common_out_para_audio[i].values);
	}
	switch (path) {
	case T_OUTPUT_RECEIVER:
		for (i = 0; i < ARRAY_SIZE(hp_outpath_para_audio); i++) {
			mix_set_value_wrap(mixer, hp_outpath_para_audio[i].control, hp_outpath_para_audio[i].values);
		}
		break;
	case T_OUTPUT_SPEAKER:
		for (i = 0; i < ARRAY_SIZE(spk_outpath_para_audio); i++) {
			mix_set_value_wrap(mixer, spk_outpath_para_audio[i].control, spk_outpath_para_audio[i].values);
		}
		break;
	default:
		break;
	}

	return 0;
}

int mix_set_input_path(struct mixer *mixer, int path)
{
	int i;
	for (i = 0; i < ARRAY_SIZE(common_in_para_audio); i++) {
		mix_set_value_wrap(mixer, common_in_para_audio[i].control, common_in_para_audio[i].values);
	}
	switch (path) {
	case T_INPUT_MICLP:
		for (i = 0; i < ARRAY_SIZE(main_mic_inpath_para_audio); i++) {
			mix_set_value_wrap(mixer, main_mic_inpath_para_audio[i].control, main_mic_inpath_para_audio[i].values);
		}
		break;
	case T_INPUT_MICRP:
		for (i = 0; i < ARRAY_SIZE(aux_mic_inpath_para_audio); i++) {
			mix_set_value_wrap(mixer, aux_mic_inpath_para_audio[i].control, aux_mic_inpath_para_audio[i].values);
		}
		break;
	default:
		break;
	}

	return 0;
}

int mix_set_input_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = input_adc_vol.control;
	int num_values, i;
	int vol = input_vol_conversion(volume);

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

	for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
	}

	return 0;
}

int mix_set_output_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char *name = output_dac_vol.control;
	int num_values, i;

	int vol = output_vol_conversion(volume);

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

	for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, vol);
	}

	return 0;
}

int mix_set_output_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = dac_mute.control;
	int num_values, i;

	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

	for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, i, enable);
	}

	return 0;
}

int mix_set_input_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char *name = adc_mute.control;
	ctl = mixer_get_ctl_by_name(mixer, name);
	int num_values, i;

	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	num_values = mixer_ctl_get_num_values(ctl);

	for (i = 0; i < num_values; i++) {
		mixer_ctl_set_value(ctl, 0, enable);
	}

	return 0;
}

int mix_set_outputpath_onoff(struct mixer *mixer, int path , bool onoff)
{
	struct mixer_ctl *ctl;
	struct audio_para_conf *path_para;
	int i, j, num_values, size;
	switch (path) {
	case T_OUTPUT_RECEIVER:
		size = ARRAY_SIZE(rcv_path_onoff);
		path_para = rcv_path_onoff;
		break;
	case T_OUTPUT_SPEAKER:
		size = ARRAY_SIZE(spk_path_onoff);
		path_para = spk_path_onoff;
		break;
	case T_OUTPUT_HEADSET:
		size = ARRAY_SIZE(earp_path_onoff);
		path_para = earp_path_onoff;
		break;
	default:
		return -1;
	}

	for (i = 0; i < size; i++) {
		ctl = mixer_get_ctl_by_name(mixer, path_para[i].control);
		num_values = mixer_ctl_get_num_values(ctl);

		for (j = 0; j < num_values; j++) {
			mixer_ctl_set_value(ctl, j, onoff);
		}

//		mix_set_value_wrap(mixer, spk_path_onoff[i].control, spk_path_onoff[i].values);
	}

	return 0;
}


int mix_set_voice_vol(struct mixer *mixer, int volume)
{
	struct mixer_ctl *ctl;
	char name[] = "voice processing path Volume";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, volume);

	return 0;
}

int mix_set_voice_mute(struct mixer *mixer, bool enable)
{
	struct mixer_ctl *ctl;
	char name[] = "voice uplink mute";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, enable);

	return 0;
}

int mix_set_voice_path(struct mixer *mixer, int path)
{
	int i;
	/*
		for (i = 0; i < ARRAY_SIZE(common_in_para_audio); i++) {
			tinymix_set_value_test(mixer, common_in_para_audio[i].control, common_in_para_audio[i].values);
		}

		for(i = 0;i<ARRAY_SIZE(common_out_para_audio);i++)
		{
	 	  	tinymix_set_value_test(mixer,common_out_para_audio[i].control,common_out_para_audio[i].values);
		}
	*/
	switch (path) {
	case T_OUTPUT_RECEIVER:
		for (i = 0; i < ARRAY_SIZE(handset_inoutpath_para_voice); i++)	{
			mix_set_value_wrap(mixer, handset_inoutpath_para_voice[i].control, handset_inoutpath_para_voice[i].values);
		}
		break;
	case T_OUTPUT_SPEAKER:
		for (i = 0; i < ARRAY_SIZE(spk_inoutpath_para_voice); i++) {
			mix_set_value_wrap(mixer, spk_inoutpath_para_voice[i].control, spk_inoutpath_para_voice[i].values);
		}
		break;
	case T_OUTPUT_HEADSET:
		for (i = 0; i < ARRAY_SIZE(headset_inoutpath_para_voice); i++) {
			mix_set_value_wrap(mixer, headset_inoutpath_para_voice[i].control, headset_inoutpath_para_voice[i].values);
		}
	default:
		break;
	}

	return 0;
}


int mix_set_in_call_tone(struct mixer *mixer, int tontype)
{
	struct mixer_ctl *ctl;
	char name[] = "voice tone sel";
	ctl = mixer_get_ctl_by_name(mixer, name);
	if (!ctl) {
		fprintf(stderr, "Invalid mixer control\n");
		return -1;
	}

	mixer_ctl_set_value(ctl, 0, tontype);

	return 0;
}

int mix_set_default_param(struct mixer *mixer)
{
	int i;
	for (i = 0; i < ARRAY_SIZE(init_default_para); i++) {
		mix_set_value_wrap(mixer, init_default_para[i].control, init_default_para[i].values);
	}

	return 0;
}
#endif
