/*
 *
 * Based on 7510_dev.c
 *
 */

#include <tinyalsa/audio_mixer_ctrl.h>


struct pcm  *voicePcmOut = NULL;
struct pcm  *voicePcmIn = NULL;

typedef struct
{
    // uint32_t voice_mode;//0, 2/3g;1, volte nb;2 ,volte wb;
    uint32_t clock_rate; //8000, 2/3g;8000, volte nb;16000 ,volte wb;
    uint32_t channel_count;
    uint32_t samples_per_frame;//160, 2/3g;160, volte nb;320 ,volte wb;
    uint32_t bits_per_sample;
} T_voiceCfg;

T_voiceCfg cfgParam = {0,8000,1,160,16};



   
 int voice_PreOpen(T_voiceCfg *cfgParam)
{
	struct mixer *voice_mixer = NULL;
 	struct pcm_config config_voice = {0};

 	/* open mixer dev for codec control */
	voice_mixer = mixer_open(0);
	if(!voice_mixer)
	{
		printf("voice_mixer open failed!");
		goto err_ret;
	}

	/* config mixer dev */
   	mix_set_voice_path(voice_mixer, T_OUTPUT_SPEAKER); 
   	mix_set_voice_vol(voice_mixer, T_VOICE_VOL_3_LEVEL);

    /*close mixer */
    mixer_close(voice_mixer);
    voice_mixer = NULL;

    /* open pcm dev for data tranf*/
    config_voice.channels = cfgParam->channel_count;
    config_voice.rate = cfgParam->clock_rate;
    /* buffer num */
    config_voice.period_count = 3;
    /* buffer size */
    config_voice.period_size = cfgParam->samples_per_frame *  cfgParam->bits_per_sample / 8; 
    /* 16-bit signed */
    config_voice.format = PCM_FORMAT_S16_LE; 
	
	//card 0 dev 1
	//23G card 0 dev 2
	voicePcmOut = pcm_open(0, 1, PCM_OUT, &config_voice);
	if(!voicePcmOut || !pcm_is_ready(voicePcmOut))
	{
		printf( "voicePcmOut open failed!");	
		goto err_ret;
	}
	
	voicePcmIn = pcm_open(0, 1, PCM_IN, &config_voice);
	if(!voicePcmIn || !pcm_is_ready(voicePcmIn))
	{
		printf( "voicePcmIn open failed!");
		goto err_ret;
	}
	
    if(0 != pcm_prepare(voicePcmOut)) 
	{
		printf("voicePcmOut pcm_prepare failed!");
		goto err_ret;
	}
		
    if(0 != pcm_prepare(voicePcmIn)) 
	{
		printf("voicePcmIn pcm_prepare failed!");
		goto err_ret;
	}
	return 0;
err_ret:
	if(voice_mixer)
	{
		mixer_close(voice_mixer);
    	voice_mixer = NULL;
	}

	if(voicePcmOut)
	{
		pcm_close(voicePcmOut);
    	voicePcmOut = NULL;
	}
	if(voicePcmIn)
	{
		pcm_close(voicePcmIn);
    	voicePcmIn = NULL;
	}
	return -1;
	
}


 void voice_PreClose(void)
{
	if(voicePcmOut)
	{
		pcm_close(voicePcmOut);
    	voicePcmOut = NULL;
	}
	if(voicePcmIn)
	{
		pcm_close(voicePcmIn);
    	voicePcmIn = NULL;
	}
}


