#include "ght_vsim_api.h"

//********2023-01-13***********//

//================================================

typedef int32_t (*zte_mdm_event_ind_callback)(E_MODEM_EVENT_ID event_id, void *ind_data, uint32_t  ind_data_len);
/**********************ZTE funcation Declartion here************
*/
extern int32_t zte_mdm_event_regist(zte_mdm_event_ind_callback ind_cb);

extern int32_t zte_atVsimInit(VSIM_COMMAND vsim_apdu_process_fn, uint8_t nSimID);
extern int32_t zte_atSoftSimInit(SoftSim_COMMAND softssim_apdu_process_fn, uint8_t nSimID);

extern int32_t zte_atVsimClose(VSIM_COMMAND vsim_apdu_process_fn, uint8_t nSimID);
extern int32_t zte_atSoftSimClose(SoftSim_COMMAND softssim_apdu_process_fn, uint8_t nSimID);

extern int32_t zte_atVsimReset(void);

//extern int16_t zte_SetSimWorkMode(SimTypeInSlot_t SimType, uint8_t nSoltID);

//extern int16_t zte_GetSimWorkMode(SimTypeInSlot_t *SimType, uint8_t nSoltID);

extern int32_t zte_SetGTDUALSIM(uint8_t nSimID);

extern int32_t zte_GetGTDUALSIM(uint8_t *nSimID);

extern int32_t zte_SetGTDATASIM(uint8_t nSimID);

extern int32_t zte_GetGTDATASIM(uint8_t *nSimID);

extern int32_t zte_SetCfunMode(uint8_t mode);

extern int32_t zte_GetCfunMode(uint8_t *mode);

extern int32_t zte_SetIMEIbySimId(uint8_t *imei, uint8_t imei_len, uint8_t nSimID);

extern int32_t zte_GetIMEIbySimId(uint8_t *imei, uint8_t imei_len, uint8_t nSimID);

extern int32_t zte_GetCCIDbySimId(uint8_t *ccid, uint8_t ccid_len, uint8_t nSimID);

extern int32_t zte_GetMCCMNCbySimId(char *mcc, char *mnc, uint8_t nSimID);

extern int32_t zte_SwitchSimHandle(uint8_t mode);

extern int32_t zte_GetCSQbySimId(int32_t *rssi, int32_t *ber, uint8_t nSimID);

extern int32_t zte_GetRegInfobySimid(RegInfo_t *reg_info, uint8_t nSimID);

extern int32_t zte_GetCellInfobySimId(uint8_t nSimID);

extern int32_t zte_GetNetInfobySimId(NetInfo_t *pNetInfo, uint8_t nSimID);

extern int32_t zte_SetAPNbySimID(Data_call_config_info_t *data_call, uint8_t nSimID);

extern int32_t zte_StartDataCallbySimId(Data_call_config_info_t *data_call, uint8_t nSimID);

extern int32_t zte_StopDataCallbySimId(uint8_t profile_id, uint8_t nSimID);

extern int32_t zte_GetDataAddrbySimID(uint8_t profile_id, Data_call_addr_info_list_t *addr_list, uint8_t nSimID);

extern int32_t zte_GetSimStatusbySimId(E_SIM_STATUS *sim_status, uint8_t nSimID);

extern int32_t zte_SendATbySimId(char *req_at, char *info_fmt, void **pval, uint8_t nSimID);

/*
*************************ZTE API Declartion end*************************/

FIBO_MODEM_EVENT g_ind_cb;

int32_t fibo_mdm_event_ind_cb(E_MODEM_EVENT_ID event_id, void *ind_data, uint32_t  ind_data_len)
{
	if(g_ind_cb)
		g_ind_cb(event_id, ind_data, ind_data_len);
	
	return 0;
}


/***********************The Fibo Public APIs Defination area*********************
*/
int32_t fibo_mdm_event_regist(FIBO_MODEM_EVENT ind_cb)
{
	g_ind_cb = ind_cb;
	return 0;
}

/**********************************************************
** Function Name: fibo_vsim_init
** Description:
**     VSIMʼҪAPDUصΪδ modem;
**
***********************************************************/

void fibo_vsim_init(VSIM_COMMAND vsim_apdu_process, uint8_t nSimID)
{
    printf("[VSIM] fibo_vsim_init,%d", nSimID);
	zte_mdm_event_regist(fibo_mdm_event_ind_cb);
    zte_atVsimInit(vsim_apdu_process, nSimID);
}
void fibo_SoftSim_init(SoftSim_COMMAND softsim_apdu_process, uint8_t nSimID)
{
    printf("[VSIM] fibo_SoftSim_init,%d", nSimID);
	zte_mdm_event_regist(fibo_mdm_event_ind_cb);
    zte_atSoftSimInit(softsim_apdu_process, nSimID);
}

/**********************************************************
** Function Name: fibo_vsim_close
** Description:
**     رVSIM;
**
***********************************************************/

void fibo_vsim_close(VSIM_COMMAND vsim_apdu_process, uint8_t nSimID)
{
    printf("[VSIM] fibo_vsim_close,%d", nSimID);
    zte_atVsimClose(vsim_apdu_process, nSimID);
}
void fibo_SoftSim_close(SoftSim_COMMAND softsim_apdu_process, uint8_t nSimID)
{
    printf("[VSIM] fibo_SoftSim_close,%d", nSimID);
    zte_atSoftSimClose(softsim_apdu_process, nSimID);
}

/**************************************************************
** Function Name: fibo_set_sim_workmode
** Description:
**     ˫ģ飬˫еĿܹͣӦӦó;
**
***************************************************************/

int16_t fibo_set_sim_workmode(SimTypeInSlot_t SimType, uint8_t nSoltID)
{
    return 0;
}

/**************************************************************
** Function Name: fibo_get_sim_workmode
** Description:
**     ˫ģ飬˫еĿܹͣӦӦó;
**
***************************************************************/

int16_t fibo_get_sim_workmode(SimTypeInSlot_t *SimType, uint8_t nSoltID)
{
    return 0;
}

/**************************************************************
** Function Name: fibo_set_dualsim
** Description:
**     ˫лýӿڣSimIDлӦĹSIMATҲ֮л;
**
***************************************************************/

int32_t fibo_set_dualsim(uint8_t nSimID)
{
    return zte_SetGTDUALSIM(nSimID);
}


/**************************************************************
** Function Name: fibo_set_dualsim
** Description:
**     ˫лȡӿڣȡǰSIM ID;
**
***************************************************************/

int32_t fibo_get_dualsim(uint8_t *nSimID)
{
    return zte_GetGTDUALSIM(nSimID);
}

/**************************************************************
** Function Name: fibo_set_dualsim
** Description:
**     ݿΪnSimIDָĿ;
**
***************************************************************/

int32_t fibo_set_datasim(uint8_t nSimID)
{
    return zte_SetGTDATASIM(nSimID);
}

/**************************************************************
** Function Name: fibo_get_datasim
** Description:
**     ȡǰõݿID;
**
***************************************************************/

int32_t fibo_get_datasim(uint8_t *nSimID)
{
    return zte_GetGTDATASIM(nSimID);
}


/**********************************************************
** Function Name: fibo_set_IMEI_by_simid
** Description:
**     VSIMӦIMEI;
**
** Note: 豸IMEI粻棬vsim_init֮;
***********************************************************/

int32_t fibo_set_IMEI_by_simid(uint8_t *imei, uint8_t imei_len, uint8_t nSimID)
{
    printf("[VSIM] fibo_set_imei,%d", nSimID);
    return zte_SetIMEIbySimId(imei, imei_len, nSimID);
}

/**********************************************************
** Function Name: fibo_set_IMEI_by_simid
** Description:
**     ȡVSIMӦIMEI;
**
** Note: 豸IMEI粻棬vsim_init֮;
***********************************************************/

int32_t fibo_get_IMEI_by_simid(uint8_t *imei, uint8_t imei_len, uint8_t nSimID)
{
    printf("[VSIM] fibo_get_imei,%d", nSimID);
    return zte_GetIMEIbySimId(imei, imei_len, nSimID);
}


/**********************************************************
** Function Name: fibo_get_CCID_by_simid
** Description:
**     ȡָSIMICCID;
**
***********************************************************/

int32_t fibo_get_CCID_by_simid(uint8_t *ccid, uint8_t ccid_len, uint8_t nSimID)
{
	printf("[VSIM]fibo_get_CCID_by_simid %d", nSimID);
	return zte_GetCCIDbySimId(ccid, ccid_len, nSimID);
}

/**********************************************************
** Function Name: fibo_xiaoshui_get_mcc_mnc
** Description:
**     ͻӿڣȡMCCMNC;
**
***********************************************************/

int32_t fibo_get_MCC_MNC_by_simid(char *mcc, char *mnc, uint8_t nSimID)
{
	return zte_GetMCCMNCbySimId(mcc, mnc, nSimID);
}

/**********************************************************
** Function Name: fibo_switch_sim_handle
** Description:
**     øýӿڽVSIMлͬʱPDP;
**     mode: 0رVSIM, 1VSIM;
**  Note: ǵfibo_switch_sim_handle(1)֮ڵfibo_set_dualsim(0)
**  ʱfibo_set_dualsim(0)ʱпʵ忨
***********************************************************/

int32_t fibo_switch_sim_handle(uint8_t mode)
{
    return zte_SwitchSimHandle(mode);
}

/**********************************************************
** Function Name: fibo_set_cfun_mode
** Description:
**     CFUN;
**
***********************************************************/

int32_t fibo_set_cfun_mode(uint8_t mode)
{
	return zte_SetCfunMode(mode);
    //ͨͬο
}

/**********************************************************
** Function Name: fibo_get_cfun_mode
** Description:
**     ȡCFUN;
**
***********************************************************/

int32_t fibo_get_cfun_mode(uint8_t *mode)
{
	return zte_GetCfunMode(mode);
    //ͨͬο
}


/**********************************************************
** Function Name: fibo_set_SysReset
** Description:
**     豸;
**
***********************************************************/

int32_t fibo_set_SysReset()
{
	zte_atVsimReset();
    //modem cfun=0ػ+ϵͳùػ
    //ϵͳùػ
    //ͨʵ
    return 0;
}

/**********************************************************
** Function Name: fibo_get_csq_by_simid
** Description:
**     ȡSIM IDصCSQ;
**
***********************************************************/

int32_t fibo_get_CSQ_by_simid(int32_t *rssi, int32_t *ber, uint8_t nSimID)
{
	return zte_GetCSQbySimId(rssi, ber, nSimID);
}

/**********************************************************
** Function Name: fibo_getRegInfo
** Description:
**     ȡSIM IDصRegInfo;
**
***********************************************************/

int32_t fibo_get_RegInfo_by_simid(RegInfo_t *reg_info, uint8_t nSimID)
{
    return zte_GetRegInfobySimid(reg_info, nSimID);
}


/**********************************************************
** Function Name: fibo_getCellInfo
** Description:
**     ȡSIM IDصCellInfo;
**
***********************************************************/

int32_t fibo_get_CellInfo_by_simid(uint8_t nSimID)
{
    return zte_GetCellInfobySimId(nSimID);
}


/**********************************************************
** Function Name: fibo_get_NetInfo_by_simid
** Description:
**     ȡSIM IDص<ȷ>;
**
***********************************************************/

int32_t fibo_get_NetInfo_by_simid(NetInfo_t *pNetInfo, uint8_t nSimID)
{
    return zte_GetNetInfobySimId(pNetInfo, nSimID);;
}

/**********************************************************
** Function Name: fibo_set_APN_by_simid
** Description:
**     PDPprofileϢ;
**
***********************************************************/

int32_t fibo_set_APN_by_simid(Data_call_config_info_t *data_call, uint8_t nSimID)
{
    return zte_SetAPNbySimID(data_call, nSimID);
}

/**********************************************************
** Function Name: fibo_start_Data_Call_by_simid
** Description:
**     ָprofile PDP;
**
***********************************************************/

int32_t fibo_start_Data_Call_by_simid(Data_call_config_info_t *data_call, uint8_t rndis_flag, uint8_t nSimID)
{
    return zte_StartDataCallbySimId(data_call, nSimID);
}

/**********************************************************
** Function Name: fibo_stop_Data_Call_by_simid
** Description:
**     ȥָprofile PDP;
**
***********************************************************/

int32_t fibo_stop_Data_Call_by_simid(uint8_t profile_id, uint8_t rndis_flag, uint8_t nSimID)
{
    return zte_StopDataCallbySimId(profile_id, nSimID);
}

/**********************************************************
** Function Name: fibo_get_Data_Addr_by_simid
** Description:
**     ȡָprofileĵַϢ;
**
***********************************************************/

int32_t fibo_get_Data_Addr_by_simid(uint8_t profile_id, Data_call_addr_info_list_t *addr_list, uint8_t nSimID)
{
    return zte_GetDataAddrbySimID(profile_id, addr_list, nSimID);
}


int32_t fibo_get_SIM_Status_by_simid(E_SIM_STATUS *sim_status, uint8_t nSimID)
{
    return zte_GetSimStatusbySimId(sim_status, nSimID);
}

int32_t fibo_send_AT_by_simid(char *req_at, char *info_fmt, void **pval, uint8_t nSimID)
{
    return zte_SendATbySimId(req_at, info_fmt, pval, nSimID);
}


/*
**********************The Public APIs Defination area end**********************/


