/*
 * ddr.c
 *
 * Copyright(c) 2016 ZXIC Inc.   All rights reserved.
 *
 */
 
#include <common.h>
#include <asm/io.h>
#include <board.h>
#include <ddr.h>
#include <asm/arch/top_clock.h>

#define _DDR_BYPASS_MODE	1	//1//1: 312m; 0:400m
#if !_DDR_BYPASS_MODE
#define _DDR_DS_48om
#endif

#define _DDR32M_BYPASS_MODE	0	//1//1: 312m; 0:400m
#if !_DDR32M_BYPASS_MODE
//#define _DDR32M_DS_48om   //-40du 48ohm has problem,modify to 60ohm
#endif
/*****************************************
 * Routine: nsdelay
 * Description: Configure DDR
 *****************************************/

void nsdelay(volatile int count)
{
    volatile int cnt = 0;

	while(cnt<count)
	{
		cnt++;
	}
	return;
}


/*****************************************
 * Routine: ddr_init
 * Description: Configure DDR
 *****************************************/
#ifdef DDR_FFC
static UINT32 g_PhyReg[DDR_CLKEND][4]={0};//g_PhyReg[N][0]~PHY_PHYREGN[N][3]ֱ洢PHYREGFB~FE

void pow_DdrClkConfig(T_zDrvPow_DDRCLK clock_value)
{
	UINT32  rdata;
	
	if(clock_value>=DDR_CLKEND)
		return;

	rdata = __REG(MOD_CLK_SEL)&0xfffffffc;
    switch (clock_value)
    {
       //DDR top clock select, bit0-1, 0=156, 1=200, 2=104, 3=78
	case DDR_156M:
	{
		__REG(MOD_CLK_SEL) = rdata|3;
		break;
        }
        case DDR_208M:
        {
		__REG(MOD_CLK_SEL) = rdata|2;
		break;
        }
	 case DDR_312M:
        {
		__REG(MOD_CLK_SEL) = rdata|0;
		break;
        }
	 case DDR_400M:
        {
		__REG(MOD_CLK_SEL) = rdata|1;
		break;
        }
        default:
			break;
    }

}

void pow_DdrFreqDivFactorConfig(T_zDrvPow_DDRCLK clock_value)
{
   if(clock_value>=DDR_CLKEND)
	return;

   //pow_DdrPllPowerdown();

   __REG(DDR_PHY_BASE+0x3b0) =0;
   __REG(DDR_PHY_BASE+0x3b4) &= ~0x1;//fbdiv[8]=0
   __REG(DDR_PHY_BASE+0x3b8) =0;

   /******************************************
   	 Fclk4x = Fref  N  M  P
	 0x013043b0:bit7~0--fbdiv[7:0]
	 0x013043b4:bit4--PLL clock out enable,
				bit1--PLL power down enable
				bit0--fbdiv[8]
        0x013043b8:bit7~5--postdiv,
                           bit4~0--prediv 
        N=fbdiv[8:0]
   	 M=prediv[4:0]
   	 P=2^postdiv[2:0];
   	 
         fref                          N         M         P
         10~20m                   64        1         16
         21~50M                    32        1         8
         51~100M                  32        2         4
         101~200M                16         2         2
         201~400M                16         4         1 
     ******************************************/
	switch (clock_value)
	{
		case DDR_156M://Fref=78m
		{
			__REG(DDR_PHY_BASE+0x3b0) =32 ;//N=fbdiv[7:0]=32
			__REG(DDR_PHY_BASE+0x3b8) =(2<<5)|(2<<0) ;//postdiv=2; M=prediv=2	
			break;
		}
		case DDR_208M:////Fref=104m
		{
			__REG(DDR_PHY_BASE+0x3b0) =16 ;//N=fbdiv[7:0]=16
			__REG(DDR_PHY_BASE+0x3b8) =(1<<5)|(2<<0) ;//postdiv=1; M=prediv=2	
			break;
		}
		case DDR_312M://Fref=156m
		{
			__REG(DDR_PHY_BASE+0x3b0) =16 ;//N=fbdiv[7:0]=16
			__REG(DDR_PHY_BASE+0x3b8) =(1<<5)|(2<<0) ;//postdiv=1; M=prediv=2				
			break;
		}
		case DDR_400M://Fref=200m
		{
			__REG(DDR_PHY_BASE+0x3b0) =16 ;//N=fbdiv[7:0]=16
			__REG(DDR_PHY_BASE+0x3b8) =(1<<5)|(2<<0) ;//postdiv=0; M=prediv=4				
			break;
		}
		default:
			break;
	}

	//pow_DdrPllPoweron();

}


void pow_DdrPllDllLock(void)
{

	//ʹ0x00146000+0x4c*4bit7ˢºpllpowerdownlockźû
	//˳ˢºӲԶpll lockֻҪlockź
    //wait phy pll lock
    while((__REG(DDR_PHY_BASE + 0x3e0)&0x1)!=0x1);
    //start  dll init ,½ش
   	__REG(DDR_PHY_BASE + 0x17c)  = 0x2a; 
	__REG(DDR_PHY_BASE + 0x17c)  = 0xa;
	nsdelay(2);
	//wait phy dll lock,phy init done,
	while((__REG(DDR_PHY_BASE + 0x3e0)&0x3)!=0x3);
}

void pow_DdrTraining(T_zDrvPow_DDRCLK clock_value)
{	
	//phy DQS gate training start
	__REG(DDR_PHY_BASE+0x02*4)=0x1;;
	nsdelay(1);
	//ѭtraining over
	while( (__REG(DDR_PHY_BASE+ 0xff*4)&0xf) != 0xf);
	
	g_PhyReg[clock_value][0]=__REG(DDR_PHY_BASE+0xfb*4);
	g_PhyReg[clock_value][1]=__REG(DDR_PHY_BASE+0xfc*4);
	g_PhyReg[clock_value][2]=__REG(DDR_PHY_BASE+0xfd*4);	
	g_PhyReg[clock_value][3]=__REG(DDR_PHY_BASE+0xfe*4);
		
	//phy DQS gate training stop
	__REG(DDR_PHY_BASE+0x02*4)=0x0;
}


/*******************************************************************************
* Function:pow_DdrChangeClk
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
void  pow_DdrChangeClk(T_zDrvPow_DDRCLK clock_value)
{

	/* PWRCTL[5].selfref_sw=1, ʹˢģʽ*/
	__REG(CRTL_PWRCTL) |= (1<<SELFREF_SW);   

	/*ѭֱSTAT[2:0]==3'b011STAT[5:4]==2'b10DDRˢ״̬*/
	while( (__REG(CTRL_STAT) & 0x37 ) !=0x23); 	
	
	//ϵͳCRMʱл
	pow_DdrClkConfig(clock_value);

	//ƵPHY PLLĿƵķƵϵ
	pow_DdrFreqDivFactorConfig(clock_value);

	
	//ֻʱ/Ƶϵ磬ˢ£phy˯ߣpllرգ
	//˳ʱԶڼ䲻öpllп,Ҫpll/dll lock,
	pow_DdrPllDllLock();
	
	//ϵʼƵtrainingѵʱ
	//üĴPHYREG02[0]=1⧷dqs gate training
	//ȻѭȡPHYREGFFֱbit[3:0]Ϊ0xftrainingɣ
	//¼ĴPHYREGFB~FEֵ
	
	/* PWRCTL[5].selfref_sw=0, ʹ˳ˢģʽ*/
    __REG(CRTL_PWRCTL) &= ~(1<<SELFREF_SW); 

	/*  ѭֱSTAT[2:0]==3'b001STAT[5:4]==2'b00DDR˳ˢ£normal״̬*/
    while( (__REG(CTRL_STAT) & 0x37 ) !=0x1); 
	/*traning*/
	pow_DdrTraining(clock_value);
	

}


void save_ddr_training(UINT32 count, T_zDrvPow_DDRCLK clock_value)
{
	__REG(DDR_FFC_ADDR_BASE+0x70*count+0x54) = g_PhyReg[clock_value][0];
	__REG(DDR_FFC_ADDR_BASE+0x70*count+0x58) = g_PhyReg[clock_value][1];
	__REG(DDR_FFC_ADDR_BASE+0x70*count+0x5c) = g_PhyReg[clock_value][2];
	__REG(DDR_FFC_ADDR_BASE+0x70*count+0x60) = g_PhyReg[clock_value][3];

}

void ddr_ffc_init(void)
{
	UINT32 count;
	__REG(STD_CRM_REG_BASE + 0x100) |= (0xf << 24); //release ddr ffc work and apb
	for(count = 0; count <= 3; count++)
	{       
	    pow_DdrChangeClk(count);
		save_ddr_training(count,count);
	}
    pow_DdrChangeClk(DDR_312M);
}
#endif

#define ABSa_b(a,b)    (((a) > (b)) ? (a-b) : (b-a))

int ddr_clk_init(int flag)
{
	//DDR top clock select top clk 156M, bit0-1, 0=156, 1=200, 2=104, 3=78
	// 0: top clk=156M,      ddr use mission mode , dram io clk=312M
	// 1: top clk=200M,     ddr use mission mode , dram io clk=400M
	// 2: top clk=104M,     ddr use mission mode , dram io clk=208M
	// 3: top clk=78M,     ddr use mission mode , dram io clk=156M
	if(flag == CHIP_DDR_IS_32M)
	{
		#if _DDR32M_BYPASS_MODE
		__REG( 0x01306050 ) = 0x00000000  ; //ƵãӦҪ޸
		#else
		__REG( 0x01306050 ) = 0x00000001  ; //ƵãӦҪ޸	
		#endif
	}
	else
	{
		#if _DDR_BYPASS_MODE
		__REG( 0x01306050 ) = 0x00000000  ; //ƵãӦҪ޸
		#else
		__REG( 0x01306050 ) = 0x00000001  ; //ƵãӦҪ޸	
		#endif
	}
	
    return 0;
	
}

int ddr_phy_init(int flag)
{
	if(flag == CHIP_DDR_IS_32M)
	{
		__REG( 0x00154000 ) = 0x0000003f  ; //VALUE_PHYREG00    0x0000003f(16bit ddr)	default: 0x000000ff(32bit ddr)
	}
	
	__REG( 0x00154004 ) = 0x00000007  ; //VALUE_PHYREG01   / Reserved:RW:2:6:=0x1, PHY_MODE:RW:0:2:=0x2(LPDDR2:0x3,LPDDR3:0x2)
	__REG( 0x0015402c ) = 0x00000080  ; //VALUE_PHYREG0B   / RL:RW:4:4:=0x8
	__REG( 0x00154030 ) = 0x00000004  ; //VALUE_PHYREG0C   / WL:RW:0:4:=0x4

	__REG( 0x001543b0 ) = 0x00000010  ; //VALUE_PHYREGEC   / fbdiv[7:0]=0x10
	__REG( 0x001543b4 ) = 0x0000001a  ; //VALUE_PHYREGED   / PLLCLKOUTEN:RW:4:1:=0x1,Reserved:RW:2:2:=0x2, pllpd:RW:1:1:=0x1, fbdiv[8]:RW:0:1:=0x0
	__REG( 0x001543b8 ) = 0x00000022  ; //VALUE_PHYREGEE   / prediv[4:0]:RW:0:5:=0x2,postdiv[2:0]:RW:5:3:=0x1
	
	if(flag == CHIP_DDR_IS_32M)
	{
		#ifndef _DDR32M_DS_48om //60ohm
		__REG( 0x00154044 )= 0x00000008;  //VALUE_PHYREG11   / CMD drive strength: cmd_nrcomp[4:0]:RW:0:5:=0xa
		__REG(0x00154058 )= 0x00000008;  //VALUE_PHYREG16   / CK  drive strength: ck_nrcomp [4:0]:RW:0:5:=0xa
		__REG(0x00154064 )= 0x00000008;  //VALUE_PHYREG19   / CK  pull_up   drive strength(DS):RW:0:5:=0xa
		__REG(0x00154068 )= 0x00000008;  //VALUE_PHYREG1A   / CMD pull_up   drive strength(DS):RW:0:5:=0xa
		__REG(0x00154080 )= 0x00000008;  //VALUE_PHYREG20   / A_DQ0~A_DQ7 pull_down DS :RW:0:5:=0xa
		__REG(0x00154084 )= 0x00000004;  //VALUE_PHYREG21   / A_DQ0~A_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG(0x001540b8 )= 0x00000088;  //VALUE_PHYREG2E   / A_DQ0~A_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x001540bc )= 0x00000084;  //VALUE_PHYREG2F   / A_DQ0~A_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG(0x001540c0 )= 0x00000088;  //VALUE_PHYREG30   / A_DQ8~A_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x001540c4 )= 0x00000084;  //VALUE_PHYREG31   / A_DQ8~A_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG(0x001540f8 )= 0x00000008;  //VALUE_PHYREG3E   / A_DQ8~A_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG(0x001540fc )= 0x00000004;  //VALUE_PHYREG3F   / A_DQ8~A_DQ15 pull_up   ODT:RW:0:5:=0xa

		__REG(0x00154100 )= 0x00000008;  //VALUE_PHYREG40   / B_DQ0~B_DQ7 pull_down DS :RW:0:5:=0xa
		__REG(0x00154104 )= 0x00000004;  //VALUE_PHYREG41   / B_DQ0~B_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG(0x00154138 )= 0x00000088;  //VALUE_PHYREG4E   / B_DQ0~B_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x0015413c )= 0x00000084;  //VALUE_PHYREG4F   / B_DQ0~B_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4

		__REG(0x00154140 )= 0x00000088;  //VALUE_PHYREG50   / B_DQ8~B_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x00154144 )= 0x00000084;  //VALUE_PHYREG51   / B_DQ8~B_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG(0x00154178 )= 0x00000008;  //VALUE_PHYREG5E   / B_DQ8~B_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG(0x0015417c )= 0x00000024;  //VALUE_PHYREG5F   / B_DQ8~B_DQ15 pull_up   ODT:RW:0:5:=0xa  	
		#else //48om                          
		//Drive strength(defualt) ODT Ч48om     
		__REG( 0x00154044 ) = 0x0000000a  ; //VALUE_PHYREG11   / CMD drive strength: cmd_prcomp[3:0]:RW:4:4:=0xa,cmd_nrcomp[3:0]:RW:0:4:=0xa
		__REG( 0x00154058 ) = 0x0000000a  ; //VALUE_PHYREG16   / CK  drive strength: ck_prcomp [3:0]:RW:4:4:=0xa,ck_nrcomp [3:0]:RW:0:4:=0xa
		__REG( 0x00154064 ) = 0x0000000a  ; //VALUE_PHYREG19   / CK  pull_up   drive strength(DS):RW:0:5:=0xa
		__REG( 0x00154068 ) = 0x0000000a  ; //VALUE_PHYREG1A   / CMD pull_up   drive strength(DS):RW:0:5:=0xa
		__REG( 0x00154080 ) = 0x0000000a  ; //VALUE_PHYREG20   / A_DQ0~A_DQ7 pull_down DS :RW:0:5:=0xa
		__REG( 0x00154084 ) = 0x00000005  ; //VALUE_PHYREG21   / A_DQ0~A_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG( 0x001540b8 ) = 0x0000008a  ; //VALUE_PHYREG2E   / A_DQ0~A_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x001540bc ) = 0x00000085  ; //VALUE_PHYREG2F   / A_DQ0~A_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG( 0x001540c0 ) = 0x0000008a  ; //VALUE_PHYREG30   / A_DQ8~A_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x001540c4 ) = 0x00000085  ; //VALUE_PHYREG31   / A_DQ8~A_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG( 0x001540f8 ) = 0x0000000a  ; //VALUE_PHYREG3E   / A_DQ8~A_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG( 0x001540fc ) = 0x00000005  ; //VALUE_PHYREG3F   / A_DQ8~A_DQ15 pull_up   ODT:RW:0:5:=0xa

		__REG( 0x00154100 ) = 0x0000000a  ; //VALUE_PHYREG40   / B_DQ0~B_DQ7 pull_down DS :RW:0:5:=0xa
		__REG( 0x00154104 ) = 0x00000005  ; //VALUE_PHYREG41   / B_DQ0~B_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG( 0x00154138 ) = 0x0000008a  ; //VALUE_PHYREG4E   / B_DQ0~B_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x0015413c ) = 0x00000085  ; //VALUE_PHYREG4F   / B_DQ0~B_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4

		__REG( 0x00154140 ) = 0x0000008a  ; //VALUE_PHYREG50   / B_DQ8~B_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x00154144 ) = 0x00000085  ; //VALUE_PHYREG51   / B_DQ8~B_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG( 0x00154178 ) = 0x0000000a  ; //VALUE_PHYREG5E   / B_DQ8~B_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG( 0x0015417c ) = 0x00000025  ; //VALUE_PHYREG5F   / B_DQ8~B_DQ15 pull_up   ODT:RW:0:5:=0xa  
		#endif
 
	}
	else
	{
		#ifndef _DDR_DS_48om //60ohm
		__REG( 0x00154044 )= 0x00000008;  //VALUE_PHYREG11   / CMD drive strength: cmd_nrcomp[4:0]:RW:0:5:=0xa
		__REG(0x00154058 )= 0x00000008;  //VALUE_PHYREG16   / CK  drive strength: ck_nrcomp [4:0]:RW:0:5:=0xa
		__REG(0x00154064 )= 0x00000008;  //VALUE_PHYREG19   / CK  pull_up   drive strength(DS):RW:0:5:=0xa
		__REG(0x00154068 )= 0x00000008;  //VALUE_PHYREG1A   / CMD pull_up   drive strength(DS):RW:0:5:=0xa
		__REG(0x00154080 )= 0x00000008;  //VALUE_PHYREG20   / A_DQ0~A_DQ7 pull_down DS :RW:0:5:=0xa
		__REG(0x00154084 )= 0x00000004;  //VALUE_PHYREG21   / A_DQ0~A_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG(0x001540b8 )= 0x00000088;  //VALUE_PHYREG2E   / A_DQ0~A_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x001540bc )= 0x00000084;  //VALUE_PHYREG2F   / A_DQ0~A_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG(0x001540c0 )= 0x00000088;  //VALUE_PHYREG30   / A_DQ8~A_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x001540c4 )= 0x00000084;  //VALUE_PHYREG31   / A_DQ8~A_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG(0x001540f8 )= 0x00000008;  //VALUE_PHYREG3E   / A_DQ8~A_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG(0x001540fc )= 0x00000004;  //VALUE_PHYREG3F   / A_DQ8~A_DQ15 pull_up   ODT:RW:0:5:=0xa

		__REG(0x00154100 )= 0x00000008;  //VALUE_PHYREG40   / B_DQ0~B_DQ7 pull_down DS :RW:0:5:=0xa
		__REG(0x00154104 )= 0x00000004;  //VALUE_PHYREG41   / B_DQ0~B_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG(0x00154138 )= 0x00000088;  //VALUE_PHYREG4E   / B_DQ0~B_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x0015413c )= 0x00000084;  //VALUE_PHYREG4F   / B_DQ0~B_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4

		__REG(0x00154140 )= 0x00000088;  //VALUE_PHYREG50   / B_DQ8~B_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG(0x00154144 )= 0x00000084;  //VALUE_PHYREG51   / B_DQ8~B_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG(0x00154178 )= 0x00000008;  //VALUE_PHYREG5E   / B_DQ8~B_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG(0x0015417c )= 0x00000024;  //VALUE_PHYREG5F   / B_DQ8~B_DQ15 pull_up   ODT:RW:0:5:=0xa  	
		#else //48om                          
		//Drive strength(defualt) ODT Ч48om     
		__REG( 0x00154044 ) = 0x0000000a  ; //VALUE_PHYREG11   / CMD drive strength: cmd_prcomp[3:0]:RW:4:4:=0xa,cmd_nrcomp[3:0]:RW:0:4:=0xa
		__REG( 0x00154058 ) = 0x0000000a  ; //VALUE_PHYREG16   / CK  drive strength: ck_prcomp [3:0]:RW:4:4:=0xa,ck_nrcomp [3:0]:RW:0:4:=0xa
		__REG( 0x00154064 ) = 0x0000000a  ; //VALUE_PHYREG19   / CK  pull_up   drive strength(DS):RW:0:5:=0xa
		__REG( 0x00154068 ) = 0x0000000a  ; //VALUE_PHYREG1A   / CMD pull_up   drive strength(DS):RW:0:5:=0xa
		__REG( 0x00154080 ) = 0x0000000a  ; //VALUE_PHYREG20   / A_DQ0~A_DQ7 pull_down DS :RW:0:5:=0xa
		__REG( 0x00154084 ) = 0x00000005  ; //VALUE_PHYREG21   / A_DQ0~A_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG( 0x001540b8 ) = 0x0000008a  ; //VALUE_PHYREG2E   / A_DQ0~A_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x001540bc ) = 0x00000085  ; //VALUE_PHYREG2F   / A_DQ0~A_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG( 0x001540c0 ) = 0x0000008a  ; //VALUE_PHYREG30   / A_DQ8~A_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x001540c4 ) = 0x00000085  ; //VALUE_PHYREG31   / A_DQ8~A_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG( 0x001540f8 ) = 0x0000000a  ; //VALUE_PHYREG3E   / A_DQ8~A_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG( 0x001540fc ) = 0x00000005  ; //VALUE_PHYREG3F   / A_DQ8~A_DQ15 pull_up   ODT:RW:0:5:=0xa

		__REG( 0x00154100 ) = 0x0000000a  ; //VALUE_PHYREG40   / B_DQ0~B_DQ7 pull_down DS :RW:0:5:=0xa
		__REG( 0x00154104 ) = 0x00000005  ; //VALUE_PHYREG41   / B_DQ0~B_DQ7 pull_down ODT:RW:0:5:=0xa
		__REG( 0x00154138 ) = 0x0000008a  ; //VALUE_PHYREG4E   / B_DQ0~B_DQ7 pull_up   DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x0015413c ) = 0x00000085  ; //VALUE_PHYREG4F   / B_DQ0~B_DQ7 pull_up   ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4

		__REG( 0x00154140 ) = 0x0000008a  ; //VALUE_PHYREG50   / B_DQ8~B_DQ15 pull_down DS :RW:0:5:=0xa, falling edge slew rate:RW:5:3:=0x4
		__REG( 0x00154144 ) = 0x00000085  ; //VALUE_PHYREG51   / B_DQ8~B_DQ15 pull_down ODT:RW:0:5:=0xa, rising  edge slew rate:RW:5:3:=0x4
		__REG( 0x00154178 ) = 0x0000000a  ; //VALUE_PHYREG5E   / B_DQ8~B_DQ15 pull_up   DS :RW:0:5:=0xa
		__REG( 0x0015417c ) = 0x00000025  ; //VALUE_PHYREG5F   / B_DQ8~B_DQ15 pull_up   ODT:RW:0:5:=0xa  
		#endif
	}

    return 0;
	
}

int ddr_ctrl_init(int flag)
{
	
	if(flag == CHIP_DDR_IS_32M)
	{
		__REG( 0x00150000 ) = 0x01041004;  // 0x01041004(16bit)   ; //VALUE_MSTR        / device_config:RW:30:2:=0x0 frequency_mode:RW:29:1:=0x0 active_ranks:RW:24:4:=0x3 burst_rdwr:RW:16:4:=0x4 dll_off_mode:RW:15:1:=0x0 data_bus_width:RW:12:2:=0x0 geardown_mode:RW:11:1:=0x0 en_2t_timing_mode:RW:10:1:=0x0 burstchop:RW:9:1:=0x0 burst_mode:RW:8:1:=0x0 lpddr4:RW:5:1:=0x0 ddr4:RW:4:1:=0x0 lpddr3:RW:3:1:=0x0 lpddr2:RW:2:1:=0x1 mobile:RW:1:1:=0x0 ddr3:RW:0:1:=0x0
	}
	else
	{
		__REG( 0x00150000 ) = 0x01040004; // 0x01040004(32bit) 
	}
	
	__REG( 0x00150010 ) = 0x00000030     ; //VALUE_MRCTRL0     / mr_wr:RW:31:1:=0x0 mr_addr:RW:12:4:=0x0 mr_rank:RW:4:4:=0x3 sw_init_int:RW:3:1:=0x0 pda_en:RW:2:1:=0x0 mpr_en:RW:1:1:=0x0 mr_type:RW:0:1:=0x0
	__REG( 0x00150014 ) = 0x00000000     ; //VALUE_MRCTRL1     /mr_data:RW:0:16:=0x0
	__REG( 0x00150020 ) = 0x00000000     ; //VALUE_DERATEEN    /rc_derate_value:RW:8:2:=0x0 derate_byte:RW:4:4:=0x0 derate_value:RW:1:1:=0x0 derate_enable:RW:0:1:=0x0
	__REG( 0x00150024 ) = 0x00800000     ; //VALUE_DERATEINT   /mr4_read_interval:RW:0:32:=0x800000

	__REG( 0x00150030 ) = 0x00000000     ; //VALUE_PWRCTL      / stay_in_selfref:RW:6:1:=0x0 selfref_sw:RW:5:1:=0x0 mpsm_en:RW:4:1:=0x0 en_dfi_dram_clk_disable:RW:3:1:=0x0 deeppowerdown_en:RW:2:1:=0x0 powerdown_en:RW:1:1:=0x1 selfref_en:RW:0:1:=0x1
	__REG( 0x00150034 ) = 0x00052002     ; //VALUE_PWRTMG      / selfref_to_x32:RW:16:8:=0x5 deeppowerdown_to_x1024:RW:8:8:=0x20 powerdown_to_x32:RW:0:5:=0x2
	__REG( 0x00150038 ) = 0x00040003     ; //VALUE_HWLPCTL     / hw_lp_idle_x32:RW:16:12:=0x4 hw_lp_exit_idle_en:RW:1:1:=0x1 hw_lp_en:RW:0:1:=0x1
	__REG( 0x00150050 ) = 0x00210000     ; //VALUE_RFSHCTL0    / refresh_margin:RW:20:4:=0x2 refresh_to_x32:RW:12:5:=0x10 refresh_burst:RW:4:5:=0x0 per_bank_refresh:RW:2:1:=0x0
	__REG( 0x00150054 ) = 0x00000000     ; //VALUE_RFSHCTL1    / refresh_timer1_start_value_x32:RW:16:12:=0x0 refresh_timer0_start_value_x32:RW:0:12:=0x0
	__REG( 0x00150058 ) = 0x00000000     ; //VALUE_RFSHCTL2    / refresh_timer3_start_value_x32:RW:16:12:=0x0 refresh_timer2_start_value_x32:RW:0:12:=0x0
	__REG( 0x00150060 ) = 0x00000000     ; //VALUE_RFSHCTL3    / refresh_mode:RW:4:3:=0x0 refresh_update_level:RW:1:1:=0x0 dis_auto_refresh:RW:0:1:=0x0
	
	if(flag == CHIP_DDR_IS_32M)
	{
		#if _DDR32M_BYPASS_MODE
		__REG( 0x00150064 ) = 0x00260014     ; //VALUE_RFSHTMG     / t_rfc_nom_x32(trefi):RW:16:12:=0x26 lpddr3_trefbw_en:RW:15:1:=0x0 t_rfc_min:RW:0:9:=0x14
		__REG( 0x001500d0 ) = 0x001f0001     ; //VALUE_INIT0       / skip_dram_init:RW:31:2:=0x0 post_cke_x1024:RW:16:10:=0x1f pre_cke_x1024:RW:0:11:=0x1
		__REG( 0x001500d4 ) = 0x00000000     ; //VALUE_INIT1       / dram_rstn_x1024:RW:16:8:=0x0 final_wait_x32:RW:8:7:=0x0 pre_ocd_x32:RW:0:4:=0x0
		__REG( 0x001500d8 ) = 0x00000405     ; //VALUE_INIT2       / idle_after_reset_x32:RW:8:8:=0x4 min_stable_clock_x1:RW:0:4:=0x5
		//MR2=RL/WL1RL3/WL12RL4/WL23RL:5/WL24RL6/WL3:5RL7/WL46RL8/WL4
		__REG( 0x001500dc ) = 0x00630006     ; //VALUE_INIT3       / mr:RW:16:16:=0x63 emr:RW:0:16:=0x6
		//bit16-31LPDDR2 MR3 valueDSĬ40ohm1=34.32=40,3=48,4=60,6=80
		#ifndef _DDR32M_DS_48om //60ohm
		__REG( 0x001500e0 ) = 0x00040000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#else //48ohm
		__REG( 0x001500e0 ) = 0x00030000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#endif
		__REG( 0x001500e4 ) = 0x00050002     ; //VALUE_INIT5       / dev_zqinit_x32:RW:16:8:=0x5 max_auto_init_x1024:RW:0:10:=0x2
		__REG( 0x001500f4 ) = 0x0000066f     ; //VALUE_RANKCTL     / diff_rank_wr_gap:RW:8:4:=0x6 diff_rank_rd_gap:RW:4:4:=0x6 max_rank_rd:RW:0:4:=0xf
		__REG( 0x00150100 ) = 0x06080a07     ; //VALUE_DRAMTMG0    / wr2pre:RW:24:6:=0x6 t_faw:RW:16:6:=0x8 t_ras_max:RW:8:7:=0xa t_ras_min:RW:0:6:=0x7
		__REG( 0x00150104 ) = 0x0002020a     ; //VALUE_DRAMTMG1    / t_xp:RW:16:5:=0x2 rd2pre:RW:8:5:=0x2 t_rc:RW:0:6:=0x9
		//RL=bit16-211RL=22RL=43RL=64R=8WL=bit24-291WL=22WL=4
		//ﵼMR2ã0x012160dcѡֵ?
		__REG( 0x00150108 ) = 0x02040606     ; //VALUE_DRAMTMG2    / write_latency:RW:24:6:=0x2 read_latency:RW:16:6:=0x4 rd2wr:RW:8:6:=0x6 wr2rd:RW:0:6:=0x6
		__REG( 0x0015010c ) = 0x00501000     ; //VALUE_DRAMTMG3    / t_mrw:RW:20:10:=0x5 t_mrd:RW:12:6:=0x1 t_mod:RW:0:10:=0x0
		__REG( 0x00150110 ) = 0x03010204     ; //VALUE_DRAMTMG4    / t_rcd:RW:24:5:=0x3 t_ccd:RW:16:4:=0x1 t_rrd:RW:8:4:=0x2 t_rp:RW:0:5:=0x4
		__REG( 0x00150114 ) = 0x01010303     ; //VALUE_DRAMTMG5    / t_cksrx:RW:24:4:=0x1 t_cksre:RW:16:4:=0x1 t_ckesr:RW:8:6:=0x3 t_cke:RW:0:4:=0x3
		__REG( 0x00150118 ) = 0x02020003     ; //VALUE_DRAMTMG6    / t_ckdpde:RW:24:4:=0x2 t_ckdpdx:RW:16:4:=0x2 t_ckcsx:RW:0:4:=0x3
		__REG( 0x0015011c ) = 0x00000202     ; //VALUE_DRAMTMG7    / t_ckpde:RW:8:4:=0x2 t_ckpdx:RW:0:4:=0x2
		__REG( 0x00150138 ) = 0x00000016     ; //VALUE_DRAMTMG14   / t_xsr:RW:0:12:=0x16
		//bit30=1 Disable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit 7520ʼΪ0Զˢ¹˳ʱʱܴsdioݳ
		__REG( 0x00150180 ) = 0x4039000f     ; //VALUE_ZQCTL0      / dis_auto_zq:RW:31:1:=0x0 dis_srx_zqcl:RW:30:1:=0x1 zq_resistor_shared:RW:29:1:=0x0 dis_mpsmx_zqcl:RW:28:1:=0x0 t_zq_long_nop:RW:16:10:=0x39 t_zq_short_nop:RW:0:10:=0xf
		__REG( 0x00150184 ) = 0x00800100     ; //VALUE_ZQCTL1      / t_zq_reset_nop:RW:20:10:=0x8 t_zq_short_interval_x1024:RW:0:20:=0x100

		#else
		__REG( 0x00150064 ) = 0x0030001a     ; //VALUE_RFSHTMG     / t_rfc_nom_x32(trefi):RW:16:12:=0x26 lpddr3_trefbw_en:RW:15:1:=0x0 t_rfc_min:RW:0:9:=0x14
		__REG( 0x001500d0 ) = 0x00280001     ; //VALUE_INIT0       / skip_dram_init:RW:31:2:=0x0 post_cke_x1024:RW:16:10:=0x1f pre_cke_x1024:RW:0:11:=0x1
		__REG( 0x001500d4 ) = 0x00000000     ; //VALUE_INIT1       / dram_rstn_x1024:RW:16:8:=0x0 final_wait_x32:RW:8:7:=0x0 pre_ocd_x32:RW:0:4:=0x0
		__REG( 0x001500d8 ) = 0x00000605     ; //VALUE_INIT2       / idle_after_reset_x32:RW:8:8:=0x4 min_stable_clock_x1:RW:0:4:=0x5
		//MR2=RL/WL1RL3/WL12RL4/WL23RL:5/WL24RL6/WL3:5RL7/WL46RL8/WL4
		__REG( 0x001500dc ) = 0x00830006     ; //VALUE_INIT3       / mr:RW:16:16:=0x63 emr:RW:0:16:=0x6
		//bit16-31LPDDR2 MR3 valueDSĬ40ohm1=34.32=40,3=48,4=60,6=80
		#ifndef _DDR32M_DS_48om //60ohm
		__REG( 0x001500e0 ) = 0x00040000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#else //48ohm
		__REG( 0x001500e0 ) = 0x00030000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#endif
		__REG( 0x001500e4 ) = 0x00070002     ; //VALUE_INIT5       / dev_zqinit_x32:RW:16:8:=0x5 max_auto_init_x1024:RW:0:10:=0x2
		__REG( 0x001500f4 ) = 0x0000066f     ; //VALUE_RANKCTL     / diff_rank_wr_gap:RW:8:4:=0x6 diff_rank_rd_gap:RW:4:4:=0x6 max_rank_rd:RW:0:4:=0xf
		__REG( 0x00150100 ) = 0x070a0d08     ; //VALUE_DRAMTMG0    / wr2pre:RW:24:6:=0x6 t_faw:RW:16:6:=0x8 t_ras_max:RW:8:7:=0xa t_ras_min:RW:0:6:=0x7
		__REG( 0x00150104 ) = 0x0002020d     ; //VALUE_DRAMTMG1    / t_xp:RW:16:5:=0x2 rd2pre:RW:8:5:=0x2 t_rc:RW:0:6:=0x9
		//RL=bit16-211RL=22RL=43RL=64R=8WL=bit24-291WL=22WL=4
		//ﵼMR2ã0x012160dcѡֵ?
		__REG( 0x00150108 ) = 0x02040607     ; //VALUE_DRAMTMG2    / write_latency:RW:24:6:=0x2 read_latency:RW:16:6:=0x4 rd2wr:RW:8:6:=0x6 wr2rd:RW:0:6:=0x6
		__REG( 0x0015010c ) = 0x00501000     ; //VALUE_DRAMTMG3    / t_mrw:RW:20:10:=0x5 t_mrd:RW:12:6:=0x1 t_mod:RW:0:10:=0x0
		__REG( 0x00150110 ) = 0x04010205     ; //VALUE_DRAMTMG4    / t_rcd:RW:24:5:=0x3 t_ccd:RW:16:4:=0x1 t_rrd:RW:8:4:=0x2 t_rp:RW:0:5:=0x4
		__REG( 0x00150114 ) = 0x01010303     ; //VALUE_DRAMTMG5    / t_cksrx:RW:24:4:=0x1 t_cksre:RW:16:4:=0x1 t_ckesr:RW:8:6:=0x3 t_cke:RW:0:4:=0x3
		__REG( 0x00150118 ) = 0x02020003     ; //VALUE_DRAMTMG6    / t_ckdpde:RW:24:4:=0x2 t_ckdpdx:RW:16:4:=0x2 t_ckcsx:RW:0:4:=0x3
		__REG( 0x0015011c ) = 0x00000202     ; //VALUE_DRAMTMG7    / t_ckpde:RW:8:4:=0x2 t_ckpdx:RW:0:4:=0x2
		__REG( 0x00150138 ) = 0x0000001c     ; //VALUE_DRAMTMG14   / t_xsr:RW:0:12:=0x16
		//bit30=1 Disable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit 7520ʼΪ0Զˢ¹˳ʱʱܴsdioݳ
		__REG( 0x00150180 ) = 0x40480012     ; //VALUE_ZQCTL0      / dis_auto_zq:RW:31:1:=0x0 dis_srx_zqcl:RW:30:1:=0x1 zq_resistor_shared:RW:29:1:=0x0 dis_mpsmx_zqcl:RW:28:1:=0x0 t_zq_long_nop:RW:16:10:=0x39 t_zq_short_nop:RW:0:10:=0xf
		__REG( 0x00150184 ) = 0x00a00100     ; //VALUE_ZQCTL1      / t_zq_reset_nop:RW:20:10:=0x8 t_zq_short_interval_x1024:RW:0:20:=0x100
		#endif
		
	}
	else
	{
		#if _DDR_BYPASS_MODE
		if(flag == CHIP_DDR_IS_256M)
			__REG( 0x00150064 ) = 0x00130014     ; //VALUE_RFSHTMG     / t_rfc_nom_x32(trefi):RW:16:12:=0x13 lpddr3_trefbw_en:RW:15:1:=0x0 t_rfc_min:RW:0:9:=0x0a
		else
			__REG( 0x00150064 ) = 0x00260014     ; //VALUE_RFSHTMG     / t_rfc_nom_x32(trefi):RW:16:12:=0x26 lpddr3_trefbw_en:RW:15:1:=0x0 t_rfc_min:RW:0:9:=0x14
		__REG( 0x001500d0 ) = 0x001f0001     ; //VALUE_INIT0       / skip_dram_init:RW:31:2:=0x0 post_cke_x1024:RW:16:10:=0x1f pre_cke_x1024:RW:0:11:=0x1
		__REG( 0x001500d4 ) = 0x00000000     ; //VALUE_INIT1       / dram_rstn_x1024:RW:16:8:=0x0 final_wait_x32:RW:8:7:=0x0 pre_ocd_x32:RW:0:4:=0x0
		__REG( 0x001500d8 ) = 0x00000405     ; //VALUE_INIT2       / idle_after_reset_x32:RW:8:8:=0x4 min_stable_clock_x1:RW:0:4:=0x5
		//MR2=RL/WL1RL3/WL12RL4/WL23RL:5/WL24RL6/WL3:5RL7/WL46RL8/WL4
		__REG( 0x001500dc ) = 0x00630006     ; //VALUE_INIT3       / mr:RW:16:16:=0x63 emr:RW:0:16:=0x6
		//bit16-31LPDDR2 MR3 valueDSĬ40ohm1=34.32=40,3=48,4=60,6=80
		#ifndef _DDR_DS_48om //60ohm
		__REG( 0x001500e0 ) = 0x00040000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#else //48ohm
		__REG( 0x001500e0 ) = 0x00030000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#endif
		__REG( 0x001500e4 ) = 0x00050002     ; //VALUE_INIT5       / dev_zqinit_x32:RW:16:8:=0x5 max_auto_init_x1024:RW:0:10:=0x2
		__REG( 0x001500f4 ) = 0x0000066f     ; //VALUE_RANKCTL     / diff_rank_wr_gap:RW:8:4:=0x6 diff_rank_rd_gap:RW:4:4:=0x6 max_rank_rd:RW:0:4:=0xf
		__REG( 0x00150100 ) = 0x06080a07     ; //VALUE_DRAMTMG0    / wr2pre:RW:24:6:=0x6 t_faw:RW:16:6:=0x8 t_ras_max:RW:8:7:=0xa t_ras_min:RW:0:6:=0x7
		__REG( 0x00150104 ) = 0x0002020a     ; //VALUE_DRAMTMG1    / t_xp:RW:16:5:=0x2 rd2pre:RW:8:5:=0x2 t_rc:RW:0:6:=0x9
		//RL=bit16-211RL=22RL=43RL=64R=8WL=bit24-291WL=22WL=4
		//ﵼMR2ã0x012160dcѡֵ?
		__REG( 0x00150108 ) = 0x02040606     ; //VALUE_DRAMTMG2    / write_latency:RW:24:6:=0x2 read_latency:RW:16:6:=0x4 rd2wr:RW:8:6:=0x6 wr2rd:RW:0:6:=0x6
		__REG( 0x0015010c ) = 0x00501000     ; //VALUE_DRAMTMG3    / t_mrw:RW:20:10:=0x5 t_mrd:RW:12:6:=0x1 t_mod:RW:0:10:=0x0
		__REG( 0x00150110 ) = 0x03010204     ; //VALUE_DRAMTMG4    / t_rcd:RW:24:5:=0x3 t_ccd:RW:16:4:=0x1 t_rrd:RW:8:4:=0x2 t_rp:RW:0:5:=0x4
		__REG( 0x00150114 ) = 0x01010303     ; //VALUE_DRAMTMG5    / t_cksrx:RW:24:4:=0x1 t_cksre:RW:16:4:=0x1 t_ckesr:RW:8:6:=0x3 t_cke:RW:0:4:=0x3
		__REG( 0x00150118 ) = 0x02020003     ; //VALUE_DRAMTMG6    / t_ckdpde:RW:24:4:=0x2 t_ckdpdx:RW:16:4:=0x2 t_ckcsx:RW:0:4:=0x3
		__REG( 0x0015011c ) = 0x00000202     ; //VALUE_DRAMTMG7    / t_ckpde:RW:8:4:=0x2 t_ckpdx:RW:0:4:=0x2
		__REG( 0x00150138 ) = 0x00000016     ; //VALUE_DRAMTMG14   / t_xsr:RW:0:12:=0x16
		//bit30=1 Disable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit 7520ʼΪ0Զˢ¹˳ʱʱܴsdioݳ
		__REG( 0x00150180 ) = 0x4039000f     ; //VALUE_ZQCTL0      / dis_auto_zq:RW:31:1:=0x0 dis_srx_zqcl:RW:30:1:=0x1 zq_resistor_shared:RW:29:1:=0x0 dis_mpsmx_zqcl:RW:28:1:=0x0 t_zq_long_nop:RW:16:10:=0x39 t_zq_short_nop:RW:0:10:=0xf
		__REG( 0x00150184 ) = 0x00800100     ; //VALUE_ZQCTL1      / t_zq_reset_nop:RW:20:10:=0x8 t_zq_short_interval_x1024:RW:0:20:=0x100

		#else
		if(flag == CHIP_DDR_IS_256M)
			__REG( 0x00150064 ) = 0x0018001a     ; //VALUE_RFSHTMG     / t_rfc_nom_x32(trefi):RW:16:12:=0x18 lpddr3_trefbw_en:RW:15:1:=0x0 t_rfc_min:RW:0:9:=0x0d
		else
			__REG( 0x00150064 ) = 0x0030001a     ; //VALUE_RFSHTMG     / t_rfc_nom_x32(trefi):RW:16:12:=0x26 lpddr3_trefbw_en:RW:15:1:=0x0 t_rfc_min:RW:0:9:=0x14
		__REG( 0x001500d0 ) = 0x00280001     ; //VALUE_INIT0       / skip_dram_init:RW:31:2:=0x0 post_cke_x1024:RW:16:10:=0x1f pre_cke_x1024:RW:0:11:=0x1
		__REG( 0x001500d4 ) = 0x00000000     ; //VALUE_INIT1       / dram_rstn_x1024:RW:16:8:=0x0 final_wait_x32:RW:8:7:=0x0 pre_ocd_x32:RW:0:4:=0x0
		__REG( 0x001500d8 ) = 0x00000605     ; //VALUE_INIT2       / idle_after_reset_x32:RW:8:8:=0x4 min_stable_clock_x1:RW:0:4:=0x5
		//MR2=RL/WL1RL3/WL12RL4/WL23RL:5/WL24RL6/WL3:5RL7/WL46RL8/WL4
		__REG( 0x001500dc ) = 0x00830006     ; //VALUE_INIT3       / mr:RW:16:16:=0x63 emr:RW:0:16:=0x6
		//bit16-31LPDDR2 MR3 valueDSĬ40ohm1=34.32=40,3=48,4=60,6=80
		#ifndef _DDR_DS_48om //60ohm
		__REG( 0x001500e0 ) = 0x00040000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#else //48ohm
		__REG( 0x001500e0 ) = 0x00030000     ; //VALUE_INIT4       / emr2:RW:16:16:=0x2 emr3:RW:0:16:=0x0
		#endif
		__REG( 0x001500e4 ) = 0x00070002     ; //VALUE_INIT5       / dev_zqinit_x32:RW:16:8:=0x5 max_auto_init_x1024:RW:0:10:=0x2
		__REG( 0x001500f4 ) = 0x0000066f     ; //VALUE_RANKCTL     / diff_rank_wr_gap:RW:8:4:=0x6 diff_rank_rd_gap:RW:4:4:=0x6 max_rank_rd:RW:0:4:=0xf
		__REG( 0x00150100 ) = 0x070a0d08     ; //VALUE_DRAMTMG0    / wr2pre:RW:24:6:=0x6 t_faw:RW:16:6:=0x8 t_ras_max:RW:8:7:=0xa t_ras_min:RW:0:6:=0x7
		__REG( 0x00150104 ) = 0x0002020d     ; //VALUE_DRAMTMG1    / t_xp:RW:16:5:=0x2 rd2pre:RW:8:5:=0x2 t_rc:RW:0:6:=0x9
		//RL=bit16-211RL=22RL=43RL=64R=8WL=bit24-291WL=22WL=4
		//ﵼMR2ã0x012160dcѡֵ?
		__REG( 0x00150108 ) = 0x02040607     ; //VALUE_DRAMTMG2    / write_latency:RW:24:6:=0x2 read_latency:RW:16:6:=0x4 rd2wr:RW:8:6:=0x6 wr2rd:RW:0:6:=0x6
		__REG( 0x0015010c ) = 0x00501000     ; //VALUE_DRAMTMG3    / t_mrw:RW:20:10:=0x5 t_mrd:RW:12:6:=0x1 t_mod:RW:0:10:=0x0
		__REG( 0x00150110 ) = 0x04010205     ; //VALUE_DRAMTMG4    / t_rcd:RW:24:5:=0x3 t_ccd:RW:16:4:=0x1 t_rrd:RW:8:4:=0x2 t_rp:RW:0:5:=0x4
		__REG( 0x00150114 ) = 0x01010303     ; //VALUE_DRAMTMG5    / t_cksrx:RW:24:4:=0x1 t_cksre:RW:16:4:=0x1 t_ckesr:RW:8:6:=0x3 t_cke:RW:0:4:=0x3
		__REG( 0x00150118 ) = 0x02020003     ; //VALUE_DRAMTMG6    / t_ckdpde:RW:24:4:=0x2 t_ckdpdx:RW:16:4:=0x2 t_ckcsx:RW:0:4:=0x3
		__REG( 0x0015011c ) = 0x00000202     ; //VALUE_DRAMTMG7    / t_ckpde:RW:8:4:=0x2 t_ckpdx:RW:0:4:=0x2
		__REG( 0x00150138 ) = 0x0000001c     ; //VALUE_DRAMTMG14   / t_xsr:RW:0:12:=0x16
		//bit30=1 Disable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit 7520ʼΪ0Զˢ¹˳ʱʱܴsdioݳ
		__REG( 0x00150180 ) = 0x40480012     ; //VALUE_ZQCTL0      / dis_auto_zq:RW:31:1:=0x0 dis_srx_zqcl:RW:30:1:=0x1 zq_resistor_shared:RW:29:1:=0x0 dis_mpsmx_zqcl:RW:28:1:=0x0 t_zq_long_nop:RW:16:10:=0x39 t_zq_short_nop:RW:0:10:=0xf
		__REG( 0x00150184 ) = 0x00a00100     ; //VALUE_ZQCTL1      / t_zq_reset_nop:RW:20:10:=0x8 t_zq_short_interval_x1024:RW:0:20:=0x100
		#endif
	}	

	__REG( 0x00150188 ) = 0x00000000     ; //VALUE_ZQCTL2      / zq_reset:RW:0:1:=0x0
	//dfi_t_rddata_en=3,֮ǰ75202ᵼ¶mr
	__REG( 0x00150190 ) = 0x04030001     ; //VALUE_DFITMG0     / dfi_t_ctrl_delay:RW:24:5:=0x4 dfi_rddata_use_sdr:RW:23:1:=0x0 dfi_t_rddata_en:RW:16:6:=0x3 dfi_wrdata_use_sdr:RW:15:1:=0x0 dfi_tphy_wrdata:RW:8:6:=0x0 dfi_tphy_wrlat:RW:0:6:=0x1
	__REG( 0x00150194 ) = 0x00020404     ; //VALUE_DFITMG1     / dfi_t_cmd_lat:RW:28:4:=0x0 dfi_t_parin_lat:RW:24:2:=0x0 dfi_t_wrdata_delay:RW:16:5:=0x2 dfi_t_dram_clk_disable:RW:8:4:=0x4 dfi_t_dram_clk_enable:RW:0:4:=0x4
	__REG( 0x00150198 ) = 0x09001111     ; //VALUE_DFILPCFG0   / dfi_tlp_resp:RW:24:4:=0x9 dfi_lp_wakeup_dpd:RW:20:4:=0x0 dfi_lp_en_dpd:RW:16:1:=0x0 dfi_lp_wakeup_sr:RW:12:4:=0x1 dfi_lp_en_sr:RW:8:1:=0x1 dfi_lp_wakeup_pd:RW:4:4:=0x1 dfi_lp_en_pd:RW:0:1:=0x1
	__REG( 0x001501a0 ) = 0x80400003     ; //VALUE_DFIUPD0     / dis_auto_ctrlupd:RW:31:1:=0x1 dfi_t_ctrlup_max:RW:16:10:=0x40 dfi_t_ctrlup_min:RW:0:10:=0x3
	__REG( 0x001501a4 ) = 0x00000000     ; //VALUE_DFIUPD1     / dfi_t_ctrlupd_interval_min_x1024:RW:16:8:=0x0 dfi_t_ctrlupd_interval_max_x1024:RW:0:8:=0x0
	__REG( 0x001501a8 ) = 0x80100010     ; //VALUE_DFIUPD2     / dfi_phyupd_en:RW:31:1:=0x1 dfi_phyupd_type1:RW:16:12:=0x10 dfi_phyupd_type0:RW:0:12:=0x10
	__REG( 0x001501b0 ) = 0x00000000     ; //VALUE_DFIMISC     / dfi_data_cs_polarity:RW:2:1:=0x0 phy_dbi_mode:RW:1:1:=0x0 dfi_init_complete_en:RW:0:1:=0x0
	__REG( 0x00150200 ) = 0x0000001f     ; //VALUE_ADDRMAP0    / addrmap_dch_bit0:RW:16:5:=0x0 addrmap_cs_bit1:RW:8:5:=0x0 addrmap_cs_bit0:RW:0:5:=0x1f

	if(flag == CHIP_DDR_IS_32M)
	{
		__REG( 0x00150204 ) = 0x001f0606	 ; //VALUE_ADDRMAP1    / addrmap_bank_b2:RW:16:4:=0x7 addrmap_bank_b1:RW:8:4:=0x7 addrmap_bank_b0:RW:0:4:=0x7
		__REG( 0x00150208 ) = 0x00000000     ; //VALUE_ADDRMAP2    / addrmap_col_b5:RW:24:4:=0x0 addrmap_col_b4:RW:16:4:=0x0 addrmap_col_b3:RW:8:4:=0x0 addrmap_col_b2:RW:0:4:=0x0
		__REG( 0x0015020c ) = 0x0f0f0000     ; //VALUE_ADDRMAP3    / addrmap_col_b9:RW:24:4:=0xf addrmap_col_b8:RW:16:4:=0x0 addrmap_col_b7:RW:8:4:=0x0 addrmap_col_b6:RW:0:4:=0x0
		__REG( 0x00150210 ) = 0x00000f0f     ; //VALUE_ADDRMAP4    / addrmap_col_b11:RW:8:4:=0xf addrmap_col_b10:RW:0:4:=0xf

	}
	else if(flag == CHIP_DDR_IS_64M)
	{		
		__REG( 0x00150204 ) = 0x001f0707	 ; //VALUE_ADDRMAP1    / addrmap_bank_b2:RW:16:4:=0x7 addrmap_bank_b1:RW:8:4:=0x7 addrmap_bank_b0:RW:0:4:=0x7
		__REG( 0x00150208 ) = 0x00000000     ; //VALUE_ADDRMAP2    / addrmap_col_b5:RW:24:4:=0x0 addrmap_col_b4:RW:16:4:=0x0 addrmap_col_b3:RW:8:4:=0x0 addrmap_col_b2:RW:0:4:=0x0
		__REG( 0x0015020c ) = 0x0f000000     ; //VALUE_ADDRMAP3    / addrmap_col_b9:RW:24:4:=0xf addrmap_col_b8:RW:16:4:=0x0 addrmap_col_b7:RW:8:4:=0x0 addrmap_col_b6:RW:0:4:=0x0
		__REG( 0x00150210 ) = 0x00000f0f     ; //VALUE_ADDRMAP4    / addrmap_col_b11:RW:8:4:=0xf addrmap_col_b10:RW:0:4:=0xf
		
	}
	else
	{		
		__REG( 0x00150204 ) = 0x00070707	 ; //VALUE_ADDRMAP1    / addrmap_bank_b2:RW:16:4:=0x7 addrmap_bank_b1:RW:8:4:=0x7 addrmap_bank_b0:RW:0:4:=0x7
		__REG( 0x00150208 ) = 0x00000000     ; //VALUE_ADDRMAP2    / addrmap_col_b5:RW:24:4:=0x0 addrmap_col_b4:RW:16:4:=0x0 addrmap_col_b3:RW:8:4:=0x0 addrmap_col_b2:RW:0:4:=0x0
		__REG( 0x0015020c ) = 0x0f000000     ; //VALUE_ADDRMAP3    / addrmap_col_b9:RW:24:4:=0xf addrmap_col_b8:RW:16:4:=0x0 addrmap_col_b7:RW:8:4:=0x0 addrmap_col_b6:RW:0:4:=0x0
		__REG( 0x00150210 ) = 0x00000f0f     ; //VALUE_ADDRMAP4    / addrmap_col_b11:RW:8:4:=0xf addrmap_col_b10:RW:0:4:=0xf
	
	}

	if(flag == CHIP_DDR_IS_32M)
	{
		__REG( 0x00150214 ) = 0x04040404	 ; //VALUE_ADDRMAP5    / addrmap_row_b11:RW:24:4:=0x6 addrmap_row_b2_10:RW:16:4:=0x6 addrmap_row_b1:RW:8:4:=0x6 addrmap_row_b0:RW:0:4:=0x6
		__REG( 0x00150218 ) = 0x0f0f0f04	 ; //VALUE_ADDRMAP6    / addrmap_row_b15:RW:24:4:=0xf addrmap_row_b14:RW:16:4:=0xf addrmap_row_b13:RW:8:4:=0xf addrmap_row_b12:RW:0:4:=0x6
	}
	else if(flag == CHIP_DDR_IS_64M)
	{	
		__REG( 0x00150214 ) = 0x05050505	 ; //VALUE_ADDRMAP5    / addrmap_row_b11:RW:24:4:=0x6 addrmap_row_b2_10:RW:16:4:=0x6 addrmap_row_b1:RW:8:4:=0x6 addrmap_row_b0:RW:0:4:=0x6
		__REG( 0x00150218 ) = 0x0f0f0f05	 ; //VALUE_ADDRMAP6    / addrmap_row_b15:RW:24:4:=0xf addrmap_row_b14:RW:16:4:=0xf addrmap_row_b13:RW:8:4:=0xf addrmap_row_b12:RW:0:4:=0x6
	}

	else if(flag == CHIP_DDR_IS_256M) 
	{	
		__REG( 0x00150214 ) = 0x06060606	 ; //VALUE_ADDRMAP5    / addrmap_row_b11:RW:24:4:=0x6 addrmap_row_b2_10:RW:16:4:=0x6 addrmap_row_b1:RW:8:4:=0x6 addrmap_row_b0:RW:0:4:=0x6
		__REG( 0x00150218 ) = 0x0f0f0606	 ; //VALUE_ADDRMAP6    / addrmap_row_b15:RW:24:4:=0xf addrmap_row_b14:RW:16:4:=0xf addrmap_row_b13:RW:8:4:=0x6 addrmap_row_b12:RW:0:4:=0x6
	}
	else
	{	
		__REG( 0x00150214 ) = 0x06060606	 ; //VALUE_ADDRMAP5    / addrmap_row_b11:RW:24:4:=0x6 addrmap_row_b2_10:RW:16:4:=0x6 addrmap_row_b1:RW:8:4:=0x6 addrmap_row_b0:RW:0:4:=0x6
		__REG( 0x00150218 ) = 0x0f0f0f06	 ; //VALUE_ADDRMAP6    / addrmap_row_b15:RW:24:4:=0xf addrmap_row_b14:RW:16:4:=0xf addrmap_row_b13:RW:8:4:=0xf addrmap_row_b12:RW:0:4:=0x6
	}
	__REG( 0x00150240 ) = 0x04000400     ; //VALUE_ODTCFG      / wr_odt_hold:RW:24:4:=0x4 wr_odt_delay:RW:16:4:=0x0 rd_odt_hold:RW:8:4:=0x4 rd_odt_delay:RW:2:4:=0x0
	__REG( 0x00150244 ) = 0x00000000     ; //VALUE_ODTMAP      / rank3_rd_odt:RW:28:4:=0x0 rank3_wr_odt:RW:24:4:=0x0 rank2_rd_odt:RW:20:4:=0x0 rank2_wr_odt:RW:16:4:=0x0 rank1_rd_odt:RW:12:4:=0x0 rank1_wr_odt:RW:8:4:=0x0 rank0_rd_odt:RW:4:4:=0x0 rank0_wr_odt:RW:0:4:=0x0
	__REG( 0x00150250 ) = 0x00001805     ; //VALUE_SCHED       / rdwr_idle_gap:RW:24:7:=0x0 go2critical_hysteresis:RW:16:8:=0x0 lpr_num_entries:RW:8:6:=0x18 pageclose:RW:2:1:=0x1 prefer_write:RW:1:1:=0x0 force_low_pri_n:RW:0:1:=0x1
	__REG( 0x00150254 ) = 0x00000000     ; //VALUE_SCHED1      / pageclose_timer:RW:0:8:=0x0

	__REG( 0x00150300 ) = 0x00000000     ; //VALUE_DBG0        / dis_collision_page_opt:RW:4:1:=0x0 dis_act_bypass:RW:2:1:=0x0 dis_rd_bypass:RW:1:1:=0x0 dis_wc:RW:0:1:=0x0
	__REG( 0x00150304 ) = 0x00000000     ; //VALUE_DBG1        / dis_dq:RW:1:1:=0x0 dis_hig:RW:0:1:=0x0
	__REG( 0x0015030c ) = 0x00000000     ; //VALUE_DBGCMD      / ctrlupd:RWSC:5:1:=0x0 zq_calib_short:RWSC:4:1:=0x0 rank3_refresh:RWSC:3:1:=0x0 rank2_refresh:RWSC:2:1:=0x0 rank1_refresh:RWSC:1:1:=0x0 rank0_refresh:RWSC:0:1:=0x0

	__REG( 0x00150400 ) = 0x00000000     ; //VALUE_PCCFG       / bl_exp_mode:RW:8:1:=0x0 pagematch_limit:RW:1:1:=0x0 go2critical_en:RW:0:1:=0x0

    return 0;

}

int ddr_prio_init(int flag)
{
	//port read static priority bit0-9, bit0-4 timeout, bit5-9 priority
	__REG( 0x00150404 ) = 0x000013ff     ; //VALUE_PCFGR_0     / rdwr_ordered_en:RW:16:1:=0x0 rd_port_pagematch_en:RW:14:1:=0x0 rd_port_urgent_en:RW:13:1:=0x0 rd_port_aging_en:RW:12:1:=0x1 read_reorder_bypass_en:RW:11:1:=0x0 rd_port_priority:RW:0:10:=0x3ff
	__REG( 0x001504b4 ) = 0x00001020     ; //VALUE_PCFGR_1     / rdwr_ordered_en:RW:16:1:=0x0 rd_port_pagematch_en:RW:14:1:=0x0 rd_port_urgent_en:RW:13:1:=0x0 rd_port_aging_en:RW:12:1:=0x1 read_reorder_bypass_en:RW:11:1:=0x0 rd_port_priority:RW:0:10:=0x20
	__REG( 0x00150564 ) = 0x00001000     ; //VALUE_PCFGR_2     / rdwr_ordered_en:RW:16:1:=0x0 rd_port_pagematch_en:RW:14:1:=0x0 rd_port_urgent_en:RW:13:1:=0x0 rd_port_aging_en:RW:12:1:=0x1 read_reorder_bypass_en:RW:11:1:=0x0 rd_port_priority:RW:0:10:=0x0
	__REG( 0x00150614 ) = 0x00001004     ; //VALUE_PCFGR_3     / rdwr_ordered_en:RW:16:1:=0x0 rd_port_pagematch_en:RW:14:1:=0x0 rd_port_urgent_en:RW:13:1:=0x0 rd_port_aging_en:RW:12:1:=0x1 read_reorder_bypass_en:RW:11:1:=0x0 rd_port_priority:RW:0:10:=0x4
	 //port write static priority bit0-9
	__REG( 0x00150408 ) = 0x000013ff     ; //VALUE_PCFGW_0     / wr_port_pagematch_en:RW:14:1:=0x0 wr_port_urgent_en:RW:13:1:=0x0 wr_port_aging_en:RW:12:1:=0x1 wr_port_priority:RW:0:10:=0x3ff
	__REG( 0x001504b8 ) = 0x000010ff     ; //VALUE_PCFGW_1     / wr_port_pagematch_en:RW:14:1:=0x0 wr_port_urgent_en:RW:13:1:=0x0 wr_port_aging_en:RW:12:1:=0x1 wr_port_priority:RW:0:10:=0xff
	__REG( 0x00150568 ) = 0x0000103f     ; //VALUE_PCFGW_2     / wr_port_pagematch_en:RW:14:1:=0x0 wr_port_urgent_en:RW:13:1:=0x0 wr_port_aging_en:RW:12:1:=0x1 wr_port_priority:RW:0:10:=0x3f
	__REG( 0x00150618 ) = 0x0000105f     ; //VALUE_PCFGW_3     / wr_port_pagematch_en:RW:14:1:=0x0 wr_port_urgent_en:RW:13:1:=0x0 wr_port_aging_en:RW:12:1:=0x1 wr_port_priority:RW:0:10:=0x5f
	//port read region set
	__REG( 0x00150494 ) = 0x0020000e     ; //VALUE_PCFGQOS0_0  / rqos_map_region2:RW:24:2:=0x0 rqos_map_region1:RW:20:2:=0x2 rqos_map_region0:RW:16:2:=0x0 rqos_map_level2:RW:8:4:=0x0 rqos_map_level1:RW:0:4:=0xe
	__REG( 0x00150544 ) = 0x0020000e     ; //VALUE_PCFGQOS0_1  / rqos_map_region2:RW:24:2:=0x0 rqos_map_region1:RW:20:2:=0x2 rqos_map_region0:RW:16:2:=0x0 rqos_map_level2:RW:8:4:=0x0 rqos_map_level1:RW:0:4:=0xe
	__REG( 0x001505f4 ) = 0x0020000e     ; //VALUE_PCFGQOS0_2  / rqos_map_region2:RW:24:2:=0x0 rqos_map_region1:RW:20:2:=0x2 rqos_map_region0:RW:16:2:=0x0 rqos_map_level2:RW:8:4:=0x0 rqos_map_level1:RW:0:4:=0xe
	__REG( 0x001506a4 ) = 0x0020000e     ; //VALUE_PCFGQOS0_3  / rqos_map_region2:RW:24:2:=0x0 rqos_map_region1:RW:20:2:=0x2 rqos_map_region0:RW:16:2:=0x0 rqos_map_level2:RW:8:4:=0x0 rqos_map_level1:RW:0:4:=0xe
	//port write region set
	__REG( 0x0015049c ) = 0x00000000     ; //VALUE_PCFGWQOS0_0 / wqos_map_region1:RW:20:2:=0x0 wqos_map_region0:RW:16:2:=0x0 wqos_map_level:RW:0:4:=0x0
	__REG( 0x0015054c ) = 0x00000000     ; //VALUE_PCFGWQOS0_1 / wqos_map_region1:RW:20:2:=0x0 wqos_map_region0:RW:16:2:=0x0 wqos_map_level:RW:0:4:=0x0
	__REG( 0x001505fc ) = 0x00000000     ; //VALUE_PCFGWQOS0_2 / wqos_map_region1:RW:20:2:=0x0 wqos_map_region0:RW:16:2:=0x0 wqos_map_level:RW:0:4:=0x0
	__REG( 0x001506ac ) = 0x00000000     ; //VALUE_PCFGWQOS0_3 / wqos_map_region1:RW:20:2:=0x0 wqos_map_region0:RW:16:2:=0x0 wqos_map_level:RW:0:4:=0x0
	//vpr timeout, region2 is red queue
	__REG( 0x00150498 ) = 0x00000000     ; //VALUE_PCFGQOS1_0  / rqos_map_timeoutr:RW:16:11:=0x0 rqos_map_timeoutb:RW:0:11:=0x0
	__REG( 0x00150548 ) = 0x00000000     ; //VALUE_PCFGQOS1_1  / rqos_map_timeoutr:RW:16:11:=0x0 rqos_map_timeoutb:RW:0:11:=0x0
	__REG( 0x001505f8 ) = 0x00000000     ; //VALUE_PCFGQOS1_2  / rqos_map_timeoutr:RW:16:11:=0x0 rqos_map_timeoutb:RW:0:11:=0x0
	__REG( 0x001506a8 ) = 0x00000000     ; //VALUE_PCFGQOS1_3  / rqos_map_timeoutr:RW:16:11:=0x0 rqos_map_timeoutb:RW:0:11:=0x0
	//vpw timeout
	__REG( 0x001504a0 ) = 0x00000000     ; //VALUE_PCFGWQOS1_0 / wqos_map_timeout:RW:0:11:=0x0
	__REG( 0x00150550 ) = 0x00000000     ; //VALUE_PCFGWQOS1_1 / wqos_map_timeout:RW:0:11:=0x0
	__REG( 0x00150600 ) = 0x00000000     ; //VALUE_PCFGWQOS1_2 / wqos_map_timeout:RW:0:11:=0x0
	__REG( 0x001506b0 ) = 0x00000000     ; //VALUE_PCFGWQOS1_3 / wqos_map_timeout:RW:0:11:=0x0
	//in CAM set
	__REG( 0x0015025c ) = 0x0f000001     ; //VALUE_PERFHPR1    / hpr_xact_run_length:RW:24:8:=0xf hpr_max_starve:RW:0:16:=0x1
	__REG( 0x00150264 ) = 0x0f00007f     ; //VALUE_PERFLPR1    / lpr_xact_run_length:RW:24:8:=0xf lpr_max_starve:RW:0:16:=0x7f
	__REG( 0x0015026c ) = 0x0f00007f     ; //VALUE_PERFWR1     / w_xact_run_length:RW:24:8:=0xf w_max_starve:RW:0:16:=0x7f
	__REG( 0x00150274 ) = 0x00000000     ; //VALUE_PERFVPR1    / vpr_timeout_range:RW:0:11:=0x0
	__REG( 0x00150278 ) = 0x00000000     ; //VALUE_PERFVPW1    / vpw_timeout_range:RW:0:11:=0x0
	//port extern static priority	
	//__REG( 0x0013d034 ) = 0xf0f00000 ; //port0,1 rqos=0(LPR); port2,3 rqos=F(HPR)       
	
    return 0;
	
}

int ddr_init(int flag)
{	
	UINT32 g_PhyJZ[6]={0};
	
	//__REG( 0x01306100 ) = 0xffffe000 ; //ddr all reset enable  bit6-12=0   
	__REG( 0x01306100 ) = 0x0affe000 ; //ddr all reset enable  bit6-12=0 
	nsdelay(200000);//0.01s 
	__REG( 0x01306100 ) = 0x0affe400 ; //release ddr apb(bit10)
	nsdelay(200000);//0.01s

	//ddr clk init
	ddr_clk_init(flag);
	
	//phy register init  
	ddr_phy_init(flag);

	//controller register init
	ddr_ctrl_init(flag);

	//ddr_priority_config
	ddr_prio_init(flag);
                                                                                           
	//wait all register configer done in hardware
	nsdelay(200000);//0.01s


	//***********************************************************
	//ctroller and inno phy registers configer done
	//***********************************************************
	__REG( 0x01306100 ) = 0x0affffc0 ; //release ddr ctl(bit11) and axi_sn reset(bit6-9)  and phy reset(bit12)  ; //ϵͳĴֵ
	nsdelay(200000);//0.01s


	//sw config done
	__REG( 0x00150320 ) = 0x00000000 ; //SWCTL      ; // sw_done:RW:0:1:=0x0
	//check phy auto init done, wait 0x00150324 bit0 =0
	nsdelay(200000);//0.01s


	//power on PHY PLL 
	__REG( 0x001543b4 ) = 0x00000018 ; //PHYREGED,PLLCLKOUTEN:RW:4:1:=0x1,Reserved:RW:2:2:=0x2, pll_pd_en:RW:1:1:=0x0, fbdiv[8]:RW:0:1:=0x0                                                                              
	//wait PHY PLL  lock,PHYREGF8[0]Pll lock indicate signal

	nsdelay(200000);//0.01s


	//PHY DLL init start, fall edge trigger
	if(flag == CHIP_DDR_IS_32M)	
	{
		#ifndef _DDR32M_DS_48om //60ohm
		__REG( 0x0015417c ) = 0x00000004 ; //PHYREG5F,  PHY init start:5:1:=0x1   
		#else //48ohm
		__REG( 0x0015417c ) = 0x00000005 ; //PHYREG5F,  PHY init start:5:1:=0x1   
		#endif
	}
	else	
	{
		#ifndef _DDR_DS_48om //60ohm
		__REG( 0x0015417c ) = 0x00000004 ; //PHYREG5F,  PHY init start:5:1:=0x1   
		#else //48ohm
		__REG( 0x0015417c ) = 0x00000005 ; //PHYREG5F,  PHY init start:5:1:=0x1   
		#endif
	}
	//wait dll lock, phy init done, PHYREGF8[1]Phy init complete signal
	nsdelay(200000);//0.01s


	//enable controller dfi_init_complete_en to start sdram init, then will send dram init cmd
	__REG( 0x001501b0 ) = 0x00000001 ; //DFIMISC    ; // phy_dbi_mode:RW:1:1:=0x0 dfi_init_complete_en:RW:0:1:=0x1	    Ƿȥ߶Ӧ޸                                                                                                     
	//check controller status is sdram init done,wait 0x00150004 bit0-2 !=0
	nsdelay(200000);//0.01s

	__REG( 0x001501b0 ) = 0x00000000 ; //dfimisc[0] phy_dbi_mode:RW:1:1:=0x0 dfi_init_complete_en:RW:0:1:=0x0

	if(flag == CHIP_DDR_IS_32M)
	{
		do
		{
			//phy DQS gate training start
			__REG( 0x00154008 ) = 0x00000001 ; //PHYREG02,bit0:DQS gating calibration control=1, bit1:DQS gating bypass mode select=0
			//wait training done
			nsdelay(200000);//0.01s

			//phy DQS gate training stop
			__REG( 0x00154008 ) = 0x00000000 ; //PHYREG02,bit0:DQS gating calibration control=0, bit1:DQS gating bypass mode select=0

			nsdelay(200000);//0.01s
			g_PhyJZ[0]=ABSa_b(__REG(0x001543ec),__REG(0x001543f0));

		}while((g_PhyJZ[0]>4)|(__REG(0x001543ec)&0x80));
	}
	else
	{
		do
		{
			//phy DQS gate training start
			__REG( 0x00154008 ) = 0x00000001 ; //PHYREG02,bit0:DQS gating calibration control=1, bit1:DQS gating bypass mode select=0
			//wait training done
			nsdelay(200000);//0.01s

			//phy DQS gate training stop
			__REG( 0x00154008 ) = 0x00000000 ; //PHYREG02,bit0:DQS gating calibration control=0, bit1:DQS gating bypass mode select=0

			nsdelay(200000);//0.01s
			g_PhyJZ[0]=ABSa_b(__REG(0x001543ec),__REG(0x001543f0));
			g_PhyJZ[1]=ABSa_b(__REG(0x001543ec),__REG(0x001543f4));
			g_PhyJZ[2]=ABSa_b(__REG(0x001543ec),__REG(0x001543f8));

			g_PhyJZ[3]=ABSa_b(__REG(0x001543f0),__REG(0x001543f4));
			g_PhyJZ[4]=ABSa_b(__REG(0x001543f0),__REG(0x001543f8));

			g_PhyJZ[5]=ABSa_b(__REG(0x001543f4),__REG(0x001543f8));
		}while((g_PhyJZ[0]>4)|(g_PhyJZ[1]>4)|(g_PhyJZ[2]>4)|(g_PhyJZ[3]>4)|(g_PhyJZ[4]>4)|(g_PhyJZ[5]>4)|(__REG(0x001543ec)&0x80));
	}

	//enable port_n
	__REG( 0x00150490 ) = 0x00000001     ; //VALUE_PCTRL_0     / port_en:RW:0:1:=0x1
	__REG( 0x00150540 ) = 0x00000001     ; //VALUE_PCTRL_1     / port_en:RW:0:1:=0x1
	__REG( 0x001505f0 ) = 0x00000001     ; //VALUE_PCTRL_2     / port_en:RW:0:1:=0x1
	__REG( 0x001506a0 ) = 0x00000001     ; //VALUE_PCTRL_3     / port_en:RW:0:1:=0x1

#ifdef DDR_FFC
	ddr_ffc_init();
#endif	
    return 0;
    
}


