/*
 * Copyright (C) 2016 ZXIC Inc.
 *
 */

#include <common.h>
#include <asm/io.h>
#include <asm/arch/gpio.h>
#include <load_mode.h>
#include <asm/arch/top_clock.h>
#include <asm/arch/cpu.h>
#include <board.h>
#include <jtag.h>

#if _ZLOADER_TRACE_DEBUG

uint32_t patch = 0; /* ûκãBSS */

void debug_config(void)
{
	unsigned int tmp = 0;
	int ret = 0;
	patch = patch;

/*űʱӳʼ*/
#ifdef CONFIG_BOARD_7520_UFI
	/*
	 * Jtag0
	 * 0:M0Jtag, 1:function, 2:gpio, 3:psJtag, 4:phyJtag, 5:dspJtag, 6:ufiJtag, 7:gpio
	 */
	
 #ifdef CONFIG_BOARD_7520_JTAG0_M0
#define JTAG0_CONNECT   0
 #endif
	
 #ifdef CONFIG_BOARD_7520_JTAG0_PS
#define JTAG0_CONNECT   3
 #endif
	tmp = __REG(0x00143030);
	tmp &= 0xff0000f0;
	tmp |= JTAG0_CONNECT|(JTAG0_CONNECT<<8)|(JTAG0_CONNECT<<12)|(JTAG0_CONNECT<<16)|(JTAG0_CONNECT<<20);
	__REG(0x00143030) = tmp;

	__REG(0x100000) = 0xeafffffe; /*ps release*/
	writel(CPU_UFI_SW_RSTEN, CPU_R7_SUBSYS_CFG);	
#endif	

	/*
	 * D0/Jtag1 
	 * 0:gpio, 1:sd0, 2:M0Jtag, 3:psJtag, 4:phyJtag, 5:dspJtag, 6:ufiJtag, 7:testpin
	 */
#ifdef CONFIG_BOARD_7520_EVB
#define JTAG1_CONNECT   3
	tmp=__REG(0x00143028);
	tmp=tmp&0xf0000ff0|0x03333003;
	__REG(0x00143028) = tmp;

	__REG(0x100000) = 0xeafffffe; /*ps release*/
	writel(CPU_UFI_SW_RSTEN, CPU_R7_SUBSYS_CFG);
#endif

#if 0
    /* ps */
    __REG(SYS_IRAM2_BASE) = 0xEAFFFFFE;                 /* while(1) */
    __REG(CPU_PS_SUBSYS_CFG) = CPU_PS_SW_RSTEN;

    /* phy */
    __REG(SYS_IRAM3_BASE) = 0xEAFFFFFE;                 /* while(1) */                /* while(1) */
    __REG(CPU_PHY_SUBSYS_CFG) = CPU_PHY_SW_RSTEN;
    
    /* A9 */
    __REG(SYS_IRAM6_BASE) = 0xEAFFFFFE;                 /* while(1) */
    __REG(CPU_UFI_SUBSYS_CFG) = CPU_UFI_SW_RSTEN;

	/* release core reset */
	__REG(0x0010c044) = 1; // phy
	__REG(0x0010c048) = 1; // ps
	__REG(0x0010c04c) = 1; // ufi
    __REG(0x0010c050) = 1; // zsp

    ret = nand_init();
    if( ret != 0 )
        while(1);
        
    ddr_init();
	
#ifdef CONFIG_BOARD_7520_EVB
    /*light gpio9*/
    tmp = __REG(0x10d440);  /*  */
    tmp |= (0x1 << 24);
    __REG(0x10d440) = tmp;

    
    tmp = __REG(0x10dC04);  /* config OUT */
    tmp &= (~(0x1<<9));
    __REG(0x10dC04) = tmp;

    tmp = __REG(0x10dC08);  
    tmp |= (0x1<<9);     /* OUT 1 */
    __REG(0x10dC08) = tmp;
#endif
#endif
	while(1);
}

#endif
