/*
 * (C) Copyright 2016 ZXIC Inc. 
 *
 */
#include <board.h>
#include "dma_cfg.h"

#ifndef __CONFIG_H__
#define __CONFIG_H__


#define CFG_USB          1
#define CFG_UART         0

#ifdef V3E_NOR_FLASH
#define CFG_PRINTF       1    
#else
//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC)
#define CFG_PRINTF       0
#else
#define CFG_PRINTF       1    
#endif
#endif

#define VERSION_RELEASE         0
#define CONFIG_ZX297520         1

#define CONFIG_SYS_SDRAM_TEMP_BASE	0x21400000

/* M0ʡ汾ʼ0x103000ʼһRAMռ䡣 */
//#define CFG_BOOT_MODE_SAVE_ADDR_FOR_UBOOT  0x103000       /* IRAM1 <--> U-BOOT */
#define     CFG_TLOAD_MODE  0x87654321                                 /* U-BOOT */
#define     CFG_ZLOAD_MODE  0x12345678                                 /* U-BOOT */

/* M0ʡ汾ʼ0x103000ʼһRAMռ䡣 */
//#define CFG_BOOT_MODE_START_MODE_FOR_UBOOT  0x103004       /* IRAM1 <--> U-BOOT */
#define		CFG_START_MODE_NAND         0x11111111              /* IRAM1 <--> U-BOOT */
#define     CFG_START_MODE_SPI_NAND     0x22222222              /* IRAM1 <--> U-BOOT */
#define 	CFG_START_MODE_NOR			0x55555555


#define     CFG_START_STAGE1_ADDR      0x102000  
#define     CFG_START_STAGE1_STATE     0x5aa55a5a 

#define 	CFG_AMT_MODE_SWITCH_ADDR	0x82002BC0



/**********************************************************************************
 * partition name
***/
//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC)
#define M0_PARTITION_NAME       "cpurpm"
#define UBOOT_IMAGE    	    	"uboot"
#define UBOOT2_IMAGE    	    "uboot2"
#define FLAGS_IMAGE         	"flags"
#else
#define M0_PARTITION_NAME       "cpurpm"
#define UBOOT_IMAGE    			"uboot"
#define UBOOT_MIRROR_IMAGE    	"uboot-mirr"
#endif



/**********************************************************************************
 * IRAM cofig
***/
#define CFG_TEMP_ADDR           0x82003000  //0x82001000      /* IRAM1  */
#define CFG_NAND_DMA_ADDR       0x102000      /* IRAM1 0FFSET 8k */  


/**********************************************************************************
 * NAND partition and cofig
***/
/*  
   0x0                                                        2M
    +----------------------------------------------------------+
    |  z-load(part table)  |        u-boot     |      m0       |                
    +----------------------------------------------------------+
       block0         block                       block 
*/

/**********************************************************************************
 * SDIO_SLAVE cofig
***/
#define CFG_SDIO_SLAVE_PACKAGE_LEN           0x10000     /* K  */
#define CFG_SDIO_SLAVE_ALIGN_LEN           0x10000     /* 512byte  */

#endif /* __CONFIG_H__ */

