/*  
 * (C) Copyright 2016, ZIXC Corporation.
 *
 *   partitions.h
 */
#ifndef _PARTITION_TABLE_H_
#define _PARTITION_TABLE_H_



/*
    +--------------+
    |     magic    |    uint32_t
    +--------------+                            +--------------+
    |    version   |    uint32_t         1      |    z-load    |
    +--------------+                            +--------------+
    |  entry nums  |    uint32_t         2      |    u-boot    |
    +--------------+                            +--------------+
    |     crc      |    uint32_t         3      |       m0     |
    +==============+                            +--------------+
    |    name[1]   |                     4      |     nv_r     |
    +--------------+                            +--------------+
    |    offset    |                     5      |     nv_w     |
    +--------------+                            +--------------+
    |     size     |                     6      |      ps      |
    +==============+                            +--------------+
    |              |                     7      |      phy     |
    +==============+                            +--------------+        
    |              |                     8      |      zsp     |
    +==============+                            +--------------+
                                         9      |     cdrom    | 
                                                +--------------+
                                        10      |       fs     |
                                                +--------------+  
                                                
*/

#define VIRTUAL_PART_NUM        2
#define ARM_PS_IMAGE            "cpups"
#define ARM_ZSP_IMAGE           "cpuphy"
#define ARM_PHY_IMAGE           "proc-phy"
#define ARM_ZSP_AMT_IMAGE       "cpuzspamt"    //[ZhouXin] Add for AMT.
#define ARM_APP_IMAGE           "cpuap"//"proc-app" FPGA
#define ARM_CAP_IMAGE           "cpucap"

#define ARM_RAMDISK_IMAGE       "ramdisk" 
#define ARM_USERDATA_IMAGE      "userdata"
#define ARM_RECOVERY_USERDATA_IMAGE      "recovery"
#define ARM_UBOOT_IMAGE         "uboot"
//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC)
#define ARM_ROOTFS_IMAGE      "rootfs"
#define ARM_ROOTFS2_IMAGE      "rootfs2"
#endif

#define ARM_FOTA_BACKUP_IMAGE   "fotabackup"
#define ARM_FOTA_FLAG_IMAGE     "fotaflag"
#define ARM_FOTA_UPDATE_IMAGE   "fotaupdate"
#define ARM_FOTA_RECOVERY_IMAGE "recovery-kernel"

#define ARM_NVRW_PARTITION      "nvrw"
#define ARM_AMT_FLAG_OFFSET     0x0

/*nvrwdrv_nvrw ʼַ Ӧperipheral(3K) ʼַ*/
#define DRV_NVRW_ADDRESS	(0x00012000) //v3 0x32400 ,v2 0x68400
#define ARM_DRV_PERIPHERAL_OFFSET (DRV_NVRW_ADDRESS+256+3*1024+3*1024+4*1024) /*drv_nvrwOFFSET 0x2900*/


#define ARM_FOTA_FLAG           "FOTA-UPDATE"
#define ARM_LOCAL_UPDATE_FLAG   "LOCALUPDATE"
#define ARM_RECOVERY_FLAG   	"FOTA-RECOVERY"
#define ARM_FOTA_COPY_PS_FLAG   "FOTA-PS"      /*ʾҪԭps汾*/
#define ARM_FOTA_FLAG_LEN       32

#define ARM_FOTA_UPDATE_SUCCESS_STRING "LOCAL-UP-SUCCESS"
#define ARM_FOTA_UPDATE_FAILED_STRING "LOCAL-UP-FAIL"

#define ARM_GMAC_INIT_FLAG      "GMAC"
#define ARM_GMAC_INIT_FLAG_LEN        5
#define ARM_GMAC_INIT_OVERTIME_LEN    4


#define ARM_RECOVERY_RESTART_OFFSET   0x40000
#define ARM_RECOVERY_RESTART_FLAG     "recovery reset" 
#define ARM_LOCALUP_RESULT_OFFSET     0x80000
#define SZ_128K				0x00020000
#define SZ_256K				0x00040000
#define SZ_512K				0x00080000
#define SZ_1M				0x00100000

#define PART_TYPE_NAND      "bin"
#define PART_TYPE_ZFTL      "nv"
#define PART_TYPE_DDR       "ddr"
#define PART_TYPE_RAW       "raw"
#define PART_TYPE_FS        "fs"

#define PART1_NAME          "zloader"
#define PART1_OFFSET        0x00000000
#define PART1_SIZE          SZ_128K
#define PART1_TYPE          PART_TYPE_NAND

#define PART2_NAME          "uboot"
#define PART2_OFFSET        (PART1_OFFSET + PART1_SIZE)
#define PART2_SIZE          (SZ_1M + SZ_512K)
#define PART2_TYPE          PART_TYPE_NAND

#define PART3_NAME          "proc-lp"
#define PART3_OFFSET        (PART2_OFFSET + PART2_SIZE)
#define PART3_SIZE          (SZ_128K + SZ_256K)
#define PART3_TYPE          PART_TYPE_NAND

#define PART4_NAME          "nvr"
#define PART4_OFFSET        (PART3_OFFSET + PART3_SIZE)
#define PART4_SIZE          (SZ_1M * 2)
#define PART4_TYPE          PART_TYPE_ZFTL

#define PART5_NAME          "nvrw"
#define PART5_OFFSET        (PART4_OFFSET + PART4_SIZE)
#define PART5_SIZE          (SZ_1M * 8)
#define PART5_TYPE          PART_TYPE_ZFTL

#define PART6_NAME          "proc-ps"
#define PART6_OFFSET        (PART5_OFFSET + PART5_SIZE)
#define PART6_SIZE          (SZ_1M * 19)
#define PART6_TYPE          PART_TYPE_NAND

#define PART7_NAME          "proc-phy"
#define PART7_OFFSET        (PART6_OFFSET + PART6_SIZE)
#define PART7_SIZE          (SZ_1M * 19)
#define PART7_TYPE          PART_TYPE_NAND

#define PART8_NAME          "proc-zsp"
#define PART8_OFFSET        (PART7_OFFSET + PART7_SIZE)
#define PART8_SIZE          (SZ_1M * 1)
#define PART8_TYPE          PART_TYPE_NAND

#define PART9_NAME          "proc-app"
#define PART9_OFFSET        (PART8_OFFSET + PART8_SIZE)
#define PART9_SIZE          (SZ_1M * 10)
#define PART9_TYPE          PART_TYPE_NAND

#define PART10_NAME          "ramdisk"
#define PART10_OFFSET        (PART9_OFFSET + PART9_SIZE)
#define PART10_SIZE          (SZ_1M * 8)
#define PART10_TYPE          PART_TYPE_NAND

#define PART11_NAME          "cdrom"
#define PART11_OFFSET        (PART10_OFFSET + PART10_SIZE)
#define PART11_SIZE          (SZ_1M * 80)
#define PART11_TYPE          PART_TYPE_NAND

#define PART12_NAME          "fs-ffx"
#define PART12_OFFSET        (PART11_OFFSET + PART11_SIZE)
#define PART12_SIZE          (SZ_1M * 8)
#define PART12_TYPE          PART_TYPE_FS

#define PART13_NAME          "userdata"
#define PART13_OFFSET        (PART12_OFFSET + PART12_SIZE)
#define PART13_SIZE          (SZ_1M * 40)
#define PART13_TYPE          PART_TYPE_FS

#define PART14_NAME          "ddr"
#define PART14_OFFSET        0x0
#define PART14_SIZE          0xffffffff
#define PART14_TYPE          PART_TYPE_DDR

#define PART15_NAME          "raw"
#define PART15_OFFSET        0x0
#define PART15_SIZE          (SZ_1M * 256)
#define PART15_TYPE          PART_TYPE_RAW

#define  PART_END    0,0,0
#define  PART1       PART1_NAME, PART1_TYPE, PART1_OFFSET, PART1_SIZE
#define  PART2       PART2_NAME, PART2_TYPE, PART2_OFFSET, PART2_SIZE
#define  PART3       PART3_NAME, PART3_TYPE, PART3_OFFSET, PART3_SIZE
#define  PART4       PART4_NAME, PART4_TYPE, PART4_OFFSET, PART4_SIZE
#define  PART5       PART5_NAME, PART5_TYPE, PART5_OFFSET, PART5_SIZE
#define  PART6       PART6_NAME, PART6_TYPE, PART6_OFFSET, PART6_SIZE
#define  PART7       PART7_NAME, PART7_TYPE, PART7_OFFSET, PART7_SIZE
#define  PART8       PART8_NAME, PART8_TYPE, PART8_OFFSET, PART8_SIZE  
#define  PART9       PART9_NAME, PART9_TYPE, PART9_OFFSET, PART9_SIZE 
#define  PART10      PART10_NAME, PART10_TYPE, PART10_OFFSET, PART10_SIZE
#define  PART11      PART11_NAME, PART11_TYPE, PART11_OFFSET, PART11_SIZE
#define  PART12      PART12_NAME, PART12_TYPE, PART12_OFFSET, PART12_SIZE
#define  PART13      PART13_NAME, PART13_TYPE, PART13_OFFSET, PART13_SIZE
#define  PART14      PART14_NAME, PART14_TYPE, PART14_OFFSET, PART14_SIZE
#define  PART15      PART15_NAME, PART15_TYPE, PART15_OFFSET, PART15_SIZE
#define  PART16      PART_END
#define  PART17      PART_END
#define  PART18      PART_END
#define  PART19      PART_END
#define  PART20      PART_END
#define  PART21      PART_END
#define  PART22      PART_END
#define  PART23      PART_END
#define  PART24      PART_END
#define  PART25      PART_END
#define  PART26      PART_END
#define  PART27      PART_END
#define  PART28      PART_END
#define  PART29      PART_END
#define  PART30      PART_END



#define MAX_ENTRYS                  30                     
#define PARTITION_ENTRYS            15                      /* ʵʹõķ */
#define PARTITION_MAGIC             0x31594876              /* ͬ Z-LOAD */
#define PARTITION_PLARTNANME        "WF7520"
#define PARTITION_VERSION           0x00201304              /*  */
#define PARTITION_CRC               0x12345678
#define PARTITION_SIZE              0X1000                  /* ĴС */


typedef struct partition_entry {
    unsigned char	part_name[16]; 
    unsigned char   part_type[16];
    unsigned int    part_offset; 
    unsigned int    part_size;            
}partition_entry_t;

typedef struct partition_table {
    unsigned int       magic;
    unsigned char      platform_name[16];
    unsigned int       version;             /* 汾 */
    unsigned int       entrys;              /* ܵķ */
    unsigned int       crc;
    partition_entry_t  table[MAX_ENTRYS];   
}partition_table_t;

typedef struct image_bin_header {
    unsigned char filename[64];       // ļ,total 128
    unsigned char partitonname[16];   // 
    unsigned char partitontype[16];   // 
    unsigned int filelength;        // ļ
    unsigned int partitonoffset;    // ڷеĵַ
    unsigned int fileaddr;          //ļںϳļеλ
    unsigned char btUse[20];   
}image_bin_header_t;
typedef struct master_header
{
    unsigned char btFileId[16];          // Binһļʶ,total 208bytes
    unsigned char btVersionIn[32];
    unsigned char btVersionOut[32];
    unsigned int dwFileNumber;
    unsigned int dwDeviceType;
    unsigned int dwNV;

    unsigned int dwFileLengthTotal;    // ļܳ
    unsigned int dwCheckSum;           // У
    unsigned int dwImageOffset;        // ڶBinһļƫ
    unsigned int dwTLoaderAdd;         // TLoaderڶBinһļеƫ
    unsigned int dwTLoaderLength;      // TLoader
    unsigned int dwTBootAdd;           // TBootڶBinһļеƫ
    unsigned int dwTBootLength;        // TBoot
    unsigned int dwPartitonAdd;        // PartitonڶBinһļеƫ
    unsigned int dwPartitionLength ;   // Partition
    unsigned char btUse[80];

	image_bin_header_t image[50]; 
} master_header_t;

//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC)
/*
flags partition

*/
/*˫ϵͳ*/
#define FLAGS_BOOT_FOTA_OFFSET      (0X0UL)
#define FLAGS_BOOT_FOTA_SIZE        (0X80000UL)
#define FLAGS_BOOT_ENV_OFFSET       (FLAGS_BOOT_FOTA_OFFSET + FLAGS_BOOT_FOTA_SIZE)
#define FLAGS_BOOT_ENV_SIZE         (0X80000UL)
#define FLAGS_BACKUP_OFFSET         (FLAGS_BOOT_ENV_OFFSET + FLAGS_BOOT_ENV_SIZE)

#define FLAGS_MAGIC                  (0X464C4147UL)

#define DUALSYSTEM_STATUS_BOOTABLE     (0XB0AB) /**/
#define DUALSYSTEM_STATUS_SUCCESSFUL   (0X5CCF) /*ܳɹ*/
#define DUALSYSTEM_STATUS_UNBOOTABLE   (0XBABE) /**/
#define FLAGS_PARTITION_ERROR          (0x1111) /*쳣*/



typedef struct
{
    int status;                /*bootable/successful/unbootable*/
	int try_cnt;
}T_DualSystem_Status;

typedef enum
{
    DUAL_SYSTEM  = 0X875A,  /*һϵͳ*/
	DUAL_SYSTEM2 = 0X986B,  /*ڶϵͳ*/
}T_BOOT_TARGET;

/*˫ϵͳ*/
typedef enum
{
    DUALSYSTEM_RECOVERY = 0X7575,    /*normal-recovery˫ϵͳ*/
	DUALSYSTEM_AA       = 0XAAAA,    /*AA˫ϵͳ*/
	DUALSYSTEM_AB       = 0XABAB     /*AB˫ϵͳ*/
}T_BOOT_DUALSYSTEM_TYPE;

typedef struct
{
    uint32_t             magic;       /*Чħ*/
	T_BOOT_TARGET        boot_to;     /*ǰϵͳ־*/
	uint32_t             fota_status; /*fota״̬*/
	T_DualSystem_Status  system;      /*һϵͳ״̬*/
	T_DualSystem_Status  system2;     /*ڶϵͳ״̬*/
}T_BOOT_FOTA_FLAG;

typedef struct
{
    unsigned int             magic;        /*Чħ*/
	T_BOOT_DUALSYSTEM_TYPE   dualsys_type; /*˫ϵͳ*/
	char system_boot_env[128];
	char system2_boot_env[128];
}T_BOOT_ENV;

typedef struct
{
    T_BOOT_FOTA_FLAG      boot_flag;
	T_BOOT_ENV            boot_env;
}T_FOTA_FLAG_INFO;
#endif

#ifdef CREAT_PARTITION_TABLE
partition_table_t g_partiton_table = 
    {
        PARTITION_MAGIC, \
        PARTITION_PLARTNANME,\
        PARTITION_VERSION,\
        PARTITION_ENTRYS, \
        PARTITION_CRC,\
        {   { PART1 },\
            { PART2 },\
            { PART3 },\
            { PART4 },\
            { PART5 },\
            { PART6 },\
            { PART7 },\
            { PART8 },\
            { PART9 },\
            { PART10 },\
            { PART11 },\
            { PART12 },\
            { PART13 },\
            { PART14 },\
            { PART15 },\
            { PART16 },\
            { PART17 },\
            { PART18 },\
            { PART19 },\
            { PART20 },\
            { PART21 },\
            { PART22 },\
            { PART23 },\
            { PART24 },\
            { PART25 },\
            { PART26 },\
            { PART27 },\
            { PART28 },\
            { PART29 },\
            { PART30 }}
    };
#endif

#ifndef CREAT_PARTITION_TABLE
int read_partition_and_check( void );
partition_entry_t *find_partition_para( uchar * name );
void add_partition_to_bootargs(void);
#endif

#endif /* _PARTITION_TABLE_H_ */
