#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <pthread.h>
#include <sys/prctl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <unistd.h>
#include <assert.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>

/**
 * 궨
 */
#define SHM_NAME_SIZE             (128)
#define SHM_TEXT_SIZE             (8192)
#define SHM_PAGE_SIZE             (4096)
#define SHM_ALLOC_ONE_PAGE_SIZE   (1024)
#define SHM_ALLOC_TWO_PAGE_SIZE   (8100)
#define SHM_ALLOC_FOUR_PAGE_SIZE  (16000)
#define SHM_NAME_CROSS_PREFIX     ("remote-")

/**
 * Ͷ
 */
typedef int bool;
enum
{
    FALSE,
    TRUE
};

typedef struct 
{    
    unsigned int shm_size;
    char name[SHM_NAME_SIZE];
}shm_node_t;

typedef struct 
{
    int  write;
    char data[SHM_TEXT_SIZE];
}shm_use_remote;

shm_node_t shm_node;

bool shm_is_remote(const char *shm_name)
{
    if (!shm_name)
        return FALSE;
    if (strncmp(shm_name, SHM_NAME_CROSS_PREFIX, strlen(SHM_NAME_CROSS_PREFIX)) == 0)
        return TRUE;
    else
        return FALSE;
}

int main (int argc, char *argv[])
{
    int          opt;
    int          shmfd      = 0;
    int          ret        = 0;
    unsigned int shm_size   = 0;
    char         *name      = NULL;
    char         *pshm      = NULL;
    char         *read_data = NULL;
    extern char  *optarg;

    shm_use_remote *shared;

    while ((opt = getopt(argc,argv,"n:d:s::")) != EOF)
    {
        switch (opt) 
        {
            case 'n':
                name = optarg;
                break;
            case 'd':
                read_data = optarg;
                break;
            case 's':
                shm_size = atoi(optarg);
                break;
            default:
                break;
        }
    }

    if (!name || !read_data)
    {
        printf("param error: you can input \"shm_posix_read -n \"remote-shm_test\" -d \"123456\" -s1024 \n");    
        printf("or \"shm_posix_read -n \"remote-shm_test\" -d \"123456\" \n");    
        printf("-n \"remote-shm_test\": create a shm using name remote-shm_test\n");
        printf("-d \"123456\": if we write 123456 to shm, then can read 123456 form shm, the test case is pass! \n");
        printf("-s1024: set the size of shm, then the default size is 1024 \n");
        return -1;
    }

    if (shm_size == 0)
        shm_size = SHM_ALLOC_ONE_PAGE_SIZE;

    printf("AP read test: name is %s, shm_size is %d\n", name, shm_size);

    shmfd = shm_open(name, O_CREAT | O_RDWR, 0666);
    if(shmfd < 0)
    {
        perror("shm_open fail\n");
        exit(1);
    }
    printf("shm_open return ok\n");

    if(ftruncate(shmfd, shm_size) ==  -1)
    {
        perror("ftruncate fail\n");
        exit(1);
    }

    pshm = (char *)mmap(NULL, shm_size, PROT_READ|PROT_WRITE, MAP_SHARED, shmfd, 0);
    if (pshm == MAP_FAILED)
    {
        perror("mmap fail\n");
        exit(1);
    }
    printf("mmap return ok\n");
    shm_node.shm_size = shm_size;
    strncpy(shm_node.name, name, SHM_NAME_SIZE-1);

    shared = (shm_use_remote *)pshm;
    shared->write  = 1;
    printf("read_data %s ok\n", read_data);

    while(1)
    {
        if(strncmp(shared->data, read_data, sizeof(read_data)) == 0)
        {
            printf("Success, AP read %s from shm\n", read_data);
            break;
        }
        else
            sleep(2);
    }
     
    ret = munmap(pshm, shm_size);
    if(ret < 0)
    {
        printf("munmap return errno %d: %s\n", errno, strerror(errno));
        exit(1);
    }

    if(shm_is_remote(name))
    {
        ret = shm_unlink(name);
        if(ret < 0)
        {
            printf("shm_unlink errno %d: %s\n", errno, strerror(errno));
            exit(1);
        }
    }
    close(shmfd);

    printf("shm posix read end\n");
    return 0;
}

