#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <pthread.h>
#include <sys/prctl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <unistd.h>
#include <assert.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>

/**
 * 궨
 */
#define SHM_TEST_ALLOC_THREAD     (0)
#define SHM_TEST_MEMGET_THREAD    (1)
#define SHM_TEST_UNLINK_THREAD    (2)
#define SHM_TEST_TRANS_THREAD     (3)
#define SHM_TEST_THREAD_NUM       (4)
#define SHM_TEST_STR_NUM          (20)
#define SHM_TEST_CAP_INIT_VALUE   (0x16)

#define SHM_TEST_MARK_0X1         (0x1)
#define SHM_TEST_MARK_0X3         (0x3)
#define SHM_TEST_MARK_0X5         (0x5)
#define SHM_TEST_MARK_0X7         (0x7)
#define SHM_TEST_MARK_NUM         (0xA)

#define SHM_PAGE_SIZE             (4096)
#define SHM_ALLOC_ONE_PAGE_SIZE   (1024)
#define SHM_ALLOC_TWO_PAGE_SIZE   (8100)
#define SHM_ALLOC_FOUR_PAGE_SIZE  (16000)

#define SHM_TEST_READ_FROM_SHM_PAGE0 (0x0A)
#define SHM_TEST_WRITE_TO_SHM_PAGE1  (0x1B)
#define SHM_TEST_READ_FROM_SHM_PAGE2 (0x2A)
#define SHM_TEST_WRITE_TO_SHM_PAGE3  (0x3B)

#define SHM_IPC_FILE_NAME     "remote-posix_test"
#define SHM_TRANS_FILE_NAME   "remote-posix_transfer"

/**
 * ȫֱ
 */
pthread_t shm_pcross_thread;
pthread_t shm_unlink_thread;

int   g_shmfd[SHM_TEST_THREAD_NUM] = {0};
char  *g_pshm[SHM_TEST_THREAD_NUM] = {NULL};
int   g_mark_path[SHM_TEST_MARK_NUM] = {0xFFFF};

void *ap_shm_fourpage_cross(void* args)
{
    int   i        = 0;
    int   ret      = 0;
    int   shmfd    = 0;
    char  test_num = 0;
    char  *pshm    = NULL;
    struct stat buf;

    prctl(PR_SET_NAME, "shm_posix_trans_task");

    shmfd = shm_open(SHM_TRANS_FILE_NAME, O_CREAT | O_RDWR, 0666);
    if(shmfd < 0)
    {
        printf("shm_open return error\n");
        assert(0);
    }

    if(ftruncate(shmfd, SHM_ALLOC_FOUR_PAGE_SIZE) ==  -1)
    {
        perror("ftruncate failed\n");
        exit(1);
    }

    if (fstat(shmfd, &buf) == -1)
    {
        printf("fstat error\n");
    }
    printf("size = %d, mode = %o\n",buf.st_size, buf.st_mode & 0777);

    pshm = (char *)mmap(NULL, SHM_ALLOC_FOUR_PAGE_SIZE, PROT_READ|PROT_WRITE, MAP_SHARED, shmfd, 0);
    if (pshm == NULL)
    {
        perror("mmap failed\n");
        exit(1);
    }
    g_shmfd[SHM_TEST_TRANS_THREAD] = shmfd;
    g_pshm[SHM_TEST_TRANS_THREAD]    = pshm;

    for(;;)
    {
        while(1)
        {
            test_num = *(char *)pshm;
            if(test_num == SHM_TEST_READ_FROM_SHM_PAGE0)
            {
                *(char *)(pshm + SHM_PAGE_SIZE) = SHM_TEST_WRITE_TO_SHM_PAGE1;
                g_mark_path[2] =  SHM_TEST_READ_FROM_SHM_PAGE0;
                printf("shmat test_num, AP write %x to shm\n",SHM_TEST_WRITE_TO_SHM_PAGE1);
                break;
            }
            sleep(2);
        }
        while(1)
        {
            test_num = *(char *)(pshm + 2 * SHM_PAGE_SIZE);
            if(test_num == SHM_TEST_READ_FROM_SHM_PAGE2)
            {
                *(char *)(pshm + 3 * SHM_PAGE_SIZE) = SHM_TEST_WRITE_TO_SHM_PAGE3;
                g_mark_path[4] =  SHM_TEST_READ_FROM_SHM_PAGE2;
                printf("shmat test_num, AP write %x to shm\n", SHM_TEST_WRITE_TO_SHM_PAGE3);
                break;
            }
            sleep(2);
        }
        if (i++ >= 10)
            break;
    }
    ret = munmap(pshm, SHM_ALLOC_FOUR_PAGE_SIZE);
    if(ret < 0)
    {
        printf("munmap errno %d: %s\n", errno, strerror(errno));
        exit(1);
    }
    printf("munmap return ok\n");

    ret = shm_unlink(SHM_TRANS_FILE_NAME);
    if(ret < 0)
    {
        printf("shm_unlink errno %d: %s\n", errno, strerror(errno));
        return -1;
    }

    printf("shm_unlink return ok\n");
    close(shmfd);
    while(1)
    {
        sleep(5);
    }
}

void *ap_write_and_unlink(void* args)
{
    int  shmfd = 0;
    int  ret   = 0;
    char *pshm = NULL;
    struct stat buf;
    int   test_num = 0;

    prctl(PR_SET_NAME, "shm_posix_task");
    
    shmfd = shm_open(SHM_IPC_FILE_NAME, O_CREAT | O_RDWR, 0666);
    if(shmfd < 0)
    {
        printf("shm_open return error\n");
        assert(0);
    }

    if(ftruncate(shmfd, SHM_ALLOC_TWO_PAGE_SIZE) ==  -1)
    {
        perror("ftruncate failed\n");
        exit(1);
    }

    if (fstat(shmfd, &buf) == -1)
    {
        printf("fstat error\n");
    }
    printf("size = %d, mode = %o\n",buf.st_size, buf.st_mode & 0777);
    
    pshm = (char *)mmap(NULL, SHM_ALLOC_TWO_PAGE_SIZE, PROT_READ|PROT_WRITE, MAP_SHARED, shmfd, 0);
    if (pshm == MAP_FAILED)
    {
        perror("mmap failed\n");
        exit(1);
    }

    g_shmfd[SHM_TEST_ALLOC_THREAD] = shmfd;
    g_pshm[SHM_TEST_ALLOC_THREAD]  = pshm;

    while(1)
    {
        test_num = *(int *)pshm;
        if(test_num == SHM_TEST_CAP_INIT_VALUE)
        {        
            *(int *)pshm = SHM_TEST_MARK_0X1 + 1;
            g_mark_path[1] = SHM_TEST_MARK_0X1;
            printf("shmat test_num 0x16, g_mark_path[1] = %x\n", g_mark_path[1]);
            break;
        }
        sleep(1);
    }

    while(1)
    {
        test_num = *(int *)pshm;
        if(test_num == SHM_TEST_MARK_0X3)
        {
            *(int *)pshm = SHM_TEST_MARK_0X3 + 1;
            g_mark_path[3] = SHM_TEST_MARK_0X3;
            printf("shmat test_num 3, g_mark_path[3] before= %x\n", g_mark_path[3]);
            break;
        }
        sleep(1);
    }

    while(1)
    {
        test_num = *(int *)pshm;
        if(test_num == SHM_TEST_MARK_0X5)
        {
            *(int *)pshm = SHM_TEST_MARK_0X5 + 1;
            g_mark_path[5] = SHM_TEST_MARK_0X5;
            printf("shmat test_num 5, g_mark_path5 before= %x\n", g_mark_path[5]);
            break;
        }
        sleep(1);
    }

    while(1)
    {
        test_num = *(int *)pshm;
        if(test_num == SHM_TEST_MARK_0X7)
        {
            *(int *)pshm = SHM_TEST_MARK_0X7 + 1;        
            g_mark_path[7] = SHM_TEST_MARK_0X7;
            printf("shmat test_num 7, g_mark_path7 before= %x\n", g_mark_path[7]);
            break;
        }
        sleep(1);
    }
    memcpy(pshm + 32, "123456", SHM_TEST_STR_NUM);    

    ret = munmap(pshm, SHM_ALLOC_TWO_PAGE_SIZE);
    if(ret < 0)
    {
        printf("munmap errno %d: %s\n", errno, strerror(errno));
        exit(1);
    }
    ret = shm_unlink(SHM_IPC_FILE_NAME);
    if(ret < 0)
    {
        printf("shm_unlink errno %d: %s\n", errno, strerror(errno));
        assert(0);
    }
    close(shmfd);

    while(1)
    {
        sleep(5);
    }
    return 0;
}


int main (int argc, char *argv[])
{
    int ret = 0;

    ret = pthread_create(&shm_pcross_thread, NULL, ap_shm_fourpage_cross, NULL);
    if(ret != 0) 
    {
        printf("pthread_create shm_pcross_thread error\n");
    }

    ret = pthread_create(&shm_unlink_thread, NULL, ap_write_and_unlink, NULL);
    if(ret != 0) 
    {
        printf("pthread_create shm_unlink_thread error\n");
    }

    if(shm_pcross_thread > 0) 
        pthread_join(shm_pcross_thread, NULL);
    
    if(shm_unlink_thread > 0) 
        pthread_join(shm_unlink_thread, NULL);

    return 0;
}

