#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <pthread.h>
#include <sys/prctl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <unistd.h>
#include <assert.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>

/**
 * 궨
 */
#define SHM_NAME_SIZE             (128)
#define SHM_TEXT_SIZE             (8192)
#define SHM_PAGE_SIZE             (4096)
#define SHM_ALLOC_ONE_PAGE_SIZE   (1024)
#define SHM_ALLOC_TWO_PAGE_SIZE   (8100)
#define SHM_ALLOC_FOUR_PAGE_SIZE  (16000)
#define SHM_MIN(x,y)              ((x)<(y)?(x):(y))

typedef struct 
{
    unsigned int shm_size;
    char name[SHM_NAME_SIZE];
}shm_node_t;

typedef struct 
{
    int  write;
    char data[SHM_TEXT_SIZE];
}shm_use_remote;

shm_node_t shm_node;

int main (int argc, char *argv[])
{
    int          opt;
    int          ret       = 0;
    int          copy_size = 0;
    unsigned int shm_size  = 0;
    int          shmfd     = 0;
    char         *name     = NULL;
    char         *pshm     = NULL;
    char         *write_data = NULL;
    extern char  *optarg;
    shm_use_remote *shared;

    while ((opt = getopt(argc,argv,"n:d:s::")) != EOF)
    {
        switch (opt) 
        {
            case 'n':
                name = optarg;
                break;
            case 'd':
                write_data = optarg;
                break;
            case 's':
                shm_size = atoi(optarg);
                break;
            default:
                break;
        }
    }

    if (!name || !write_data)
    {
        printf("param error: you can input \"shm_posix_write -n \"remote-shm_test\" -d \"123456\" -s1024 \n");   
        printf("or \"shm_posix_write -n \"remote-shm_test\" -d \"123456\" \n");   
        printf("-k -200: create a shm using name remote-shm_test\n");
        printf("-d \"123456\": the data write to shm: for example, if we write 123456 to shm, then can read 123456 form shm, the test case is pass! \n");
        printf("-s1024: set the size of shm, then the default size is 1024 \n");
        return -1;
    }
    if (shm_size == 0)
        shm_size = SHM_ALLOC_ONE_PAGE_SIZE;

    printf("AP write test: name is %s, shm_size is %d\n", name, shm_size);

    shmfd = shm_open(name, O_CREAT | O_RDWR, 0666);
    if(shmfd < 0)
    {
        printf("shm_open return error\n");
        assert(0);
    }
    printf("AP write test: shm_open shmfd %d\n",shmfd);

    if(ftruncate(shmfd, shm_size) ==  -1)
    {
        perror("ftruncate failed\n");
        exit(1);
    }

    pshm = (char *)mmap(NULL, shm_size, PROT_READ|PROT_WRITE, MAP_SHARED, shmfd, 0);
    if (pshm == MAP_FAILED)
    {
        perror("mmap failed\n");
        exit(1);
    }    
    shm_node.shm_size = shm_size;
    strncpy(shm_node.name, name, SHM_NAME_SIZE-1);

    printf("AP write test : mmap return ok\n");
    shared = (shm_use_remote *)pshm;
    copy_size = SHM_MIN(strlen(write_data), (SHM_TEXT_SIZE - 1));

    printf("AP write test : shared->write %d\n",shared->write);

    while(1)
    {        
        if(shared->write == 1)
        {
            strncpy(shared->data, write_data, copy_size);
            printf("AP write %s to shm\n", write_data);
            shared->write = 0;
            break;
        }
        else{
            sleep(2);
        }
    }
    ret = munmap(pshm, shm_size);
    if(ret < 0)
    {
        printf("munmap errno %d: %s\n", errno, strerror(errno));
        exit(1);
    }

    ret = shm_unlink(name);
    if(ret < 0)
    {
        printf("shm_unlink errno %d: %s\n", errno, strerror(errno));
    }
    close(shmfd);

    printf("shm posix write end\n");

    return 0;
}


