#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <pthread.h>
#include <sys/prctl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <unistd.h>

/**
 * 궨
 */
#define SHM_TEST_ALLOC_THREAD     (0)
#define SHM_TEST_MEMGET_THREAD    (1)
#define SHM_TEST_SHMCTL_THREAD    (2)
#define SHM_TEST_WRITE_THREAD     (3)
#define SHM_TEST_THREAD_NUM       (4)
#define SHM_TEST_STR_NUM          (20)
#define SHM_TEST_CAP_INIT_VALUE   (0x16)

#define SHM_TEST_MARK_0X1         (0x1)
#define SHM_TEST_MARK_0X3         (0x3)
#define SHM_TEST_MARK_0X5         (0x5)
#define SHM_TEST_MARK_0X7         (0x7)
#define SHM_TEST_MARK_NUM         (0xA)

#define SHM_PAGE_SIZE             (4096)
#define SHM_ALLOC_ONE_PAGE_SIZE   (1024)
#define SHM_ALLOC_TWO_PAGE_SIZE   (8100)
#define SHM_ALLOC_FOUR_PAGE_SIZE  (16000)

#define SHM_TEST_READ_FROM_SHM_PAGE0 (0x0A)
#define SHM_TEST_WRITE_TO_SHM_PAGE1  (0x1B)
#define SHM_TEST_READ_FROM_SHM_PAGE2 (0x2A)
#define SHM_TEST_WRITE_TO_SHM_PAGE3  (0x3B)

/**
 * ȫֱ
 */
pthread_t shm_mem_thread;
pthread_t shm_alloc_thread;
pthread_t shm_ppcross_thread;
pthread_t shm_shmdt_thread;

int  g_shmid[SHM_TEST_THREAD_NUM] = {0};
char *g_pshm[SHM_TEST_THREAD_NUM] = {NULL};
int   g_mark_path[SHM_TEST_MARK_NUM] = {0xFFFF};

void *ap_mem_shm_alloc(void* args)
{
	int  shmid = 0;
	char *pshm = NULL;
	key_t key = 0xFFFFF801;

	prctl(PR_SET_NAME, "shm_alloc_task");

	/*alloc two pages*/
	shmid = shmget(key, SHM_ALLOC_TWO_PAGE_SIZE, 0666|IPC_CREAT);
	if(shmid < 0)
	{
		printf("shmid return error\n");
		return -1;
	}

	pshm = (char *)shmat(shmid, 0, 0);
	if (pshm == NULL)
	{
		printf("shmat return error\n");
		return -1;
	}	

	g_shmid[SHM_TEST_ALLOC_THREAD] = shmid;
	g_pshm[SHM_TEST_ALLOC_THREAD]	= pshm;
	shmdt(pshm);
	if(shmctl(shmid, IPC_RMID,0) == -1)
	{
		printf("shmctl error\n");
        return -1;
	}

	while(1)
	{
		sleep(50);
	}
}

void *ap_mmap_shm(void* args)
{
	int  shmid = 0;
	char *pshm = NULL;
	key_t key = 0xFFFFF802;

	prctl(PR_SET_NAME, "shm_mem_task");

	/*alloc two pages*/
	shmid = shmget(key, SHM_ALLOC_TWO_PAGE_SIZE, 0666|IPC_CREAT);
	if(shmid < 0)
		printf("shmid return error\n");

	pshm = (char *)shmat(shmid, 0, 0);
	if (pshm == NULL)
		printf("shmat return error\n");
	
	g_shmid[SHM_TEST_MEMGET_THREAD] = shmid;
	g_pshm[SHM_TEST_MEMGET_THREAD]  = pshm;
	shmdt(pshm);
	if(shmctl(shmid, IPC_RMID,0) == -1)
		printf("shmctl error\n");

	while(1)
	{
		sleep(50);
	}
}

void *ap_write_and_shmdt(void* args)
{
	int   shmid    = 0;
	int   test_num = 0;
	int   *pshm    = NULL;
	key_t key      = 0xFFFFF803;

	prctl(PR_SET_NAME, "shm_task");
	
	shmid = shmget(key, SHM_ALLOC_ONE_PAGE_SIZE, 0666|IPC_CREAT);
	
	if(shmid < 0)
		printf("shmid return error\n");

	pshm = (int *)shmat(shmid, 0, 0);
	if (pshm == NULL)
		printf("shmat return error\n");
	
	g_shmid[SHM_TEST_WRITE_THREAD] = shmid;
	g_pshm[SHM_TEST_WRITE_THREAD]  = pshm;

	while(1)
	{
 		test_num = *(int *)pshm;
		if(test_num == SHM_TEST_CAP_INIT_VALUE)
		{		
			*(int *)pshm = SHM_TEST_MARK_0X1 + 1;
			g_mark_path[1] = SHM_TEST_MARK_0X1;
			printf("shmat test_num 0x16, g_mark_path[1] = %x\n", g_mark_path[1]);
			break;
		}
		sleep(1);
	}

	while(1)
	{
		test_num = *(int *)pshm;
		if(test_num == SHM_TEST_MARK_0X3)
		{
			*(int *)pshm = SHM_TEST_MARK_0X3 + 1;
			g_mark_path[3] = SHM_TEST_MARK_0X3;
			printf("shmat test_num 3, g_mark_path[3] before= %x\n", g_mark_path[3]);
			break;
		}
		sleep(1);
	}

	while(1)
	{
		test_num = *(int *)pshm;
		if(test_num == SHM_TEST_MARK_0X5)
		{
			*(int *)pshm = SHM_TEST_MARK_0X5 + 1;
			g_mark_path[5] = SHM_TEST_MARK_0X5;
			printf("shmat test_num 5, g_mark_path5 before= %x\n", g_mark_path[5]);
			break;
		}
		sleep(1);
	}

	while(1)
	{
		test_num = *(int *)pshm;
		if(test_num == SHM_TEST_MARK_0X7)
		{
			*(int *)pshm = SHM_TEST_MARK_0X7 + 1;		
			g_mark_path[7] = SHM_TEST_MARK_0X7;
			printf("shmat test_num 7, g_mark_path7 before= %x\n", g_mark_path[7]);
			break;
		}
		sleep(1);
	}
	memcpy(pshm + 32, "123456", SHM_TEST_STR_NUM);

	shmdt(pshm);

	while(1)
	{
		sleep(2);
	}
}

void *ap_fourpage_cross_shm(void* args)
{
    int i = 0;
	int   shmid    = 0;
	char  test_num = 0;
	char  *pshm    = NULL;
	key_t key      = 0xFFFFF804;

	prctl(PR_SET_NAME, "shm_cross_task");

	/*alloc four pages*/
	shmid = shmget(key, SHM_ALLOC_FOUR_PAGE_SIZE, 0666|IPC_CREAT);
	if(shmid < 0)
		printf("shmid return error\n");

	pshm = (char *)shmat(shmid, 0, 0);
	if (pshm == NULL)
		printf("shmat return error\n");

	g_shmid[SHM_TEST_SHMCTL_THREAD] = shmid;
	g_pshm[SHM_TEST_SHMCTL_THREAD]	= pshm;

	for(;;)
	{
		while(1)
		{
			test_num = *(char *)pshm;
			if(test_num == SHM_TEST_READ_FROM_SHM_PAGE0)
			{
				*(char *)(pshm + SHM_PAGE_SIZE) = SHM_TEST_WRITE_TO_SHM_PAGE1;
				g_mark_path[2] =  SHM_TEST_READ_FROM_SHM_PAGE0;
				printf("shmat test_num, AP write %x to shm\n",SHM_TEST_WRITE_TO_SHM_PAGE1);
				break;
			}
			sleep(5);
		}
		while(1)
		{
			test_num = *(char *)(pshm + 2 * SHM_PAGE_SIZE);
			if(test_num == SHM_TEST_READ_FROM_SHM_PAGE2)
			{
				*(char *)(pshm + 3 * SHM_PAGE_SIZE) = SHM_TEST_WRITE_TO_SHM_PAGE3;
				g_mark_path[4] =  SHM_TEST_READ_FROM_SHM_PAGE2;
				printf("shmat test_num, AP write %x to shm\n", SHM_TEST_WRITE_TO_SHM_PAGE3);
				break;
			}
			sleep(5);
		}
		if (i++ >= 10)
			break;
	}
	shmdt(pshm);
	if(shmctl(shmid, IPC_RMID,0) == -1)
		printf("shmctl error\n");

	printf("shmctl end\n");
	while(1)
	{
		sleep(5);
	}
}

int main (int argc, char *argv[])
{
	int ret = 0;
	
	ret = pthread_create(&shm_mem_thread, NULL, ap_mem_shm_alloc, NULL);
	if(ret != 0) 
	{
		printf("pthread_create shm_mem_thread error\n");
	}

	ret = pthread_create(&shm_alloc_thread, NULL, ap_mmap_shm, NULL);
	if(ret != 0) 
	{
		printf("pthread_create shm_alloc_thread error\n");
	}

	ret = pthread_create(&shm_ppcross_thread, NULL, ap_fourpage_cross_shm, NULL);
	if(ret != 0) 
	{
		printf("pthread_create shm_ppcross_thread error\n");
	}

	ret = pthread_create(&shm_shmdt_thread, NULL, ap_write_and_shmdt, NULL);
	if(ret != 0) 
	{
		printf("pthread_create shm_shmdt_thread error\n");
	}
	if(shm_mem_thread > 0) 
		pthread_join(shm_mem_thread, NULL);
	
	if(shm_alloc_thread > 0) 
		pthread_join(shm_alloc_thread, NULL);

	if(shm_ppcross_thread > 0) 
		pthread_join(shm_ppcross_thread, NULL);
	
	if(shm_shmdt_thread > 0) 
		pthread_join(shm_shmdt_thread, NULL);

	return 0;
}

