# /*****************************************************************************
#* Ȩ (C)2015, ͨѶɷ޹˾
#* 
#* ļ:     target_rules.mk
#* ļʶ:     target_rules.mk
#* ժҪ:     Ŀļ
#* ʹ÷:     include target_rules.mk
#* 
#* ޸        汾      ޸ı        ޸          ޸
#* -----------------------------------------------------------------------------
#* 2015/05/20      V1.0                              
#* 
# ******************************************************************************/

#===============================================================================
# ļ
#===============================================================================
_ALL_OBJECTS = $(addprefix $(_SUBSYS_OBJ_PATH)/,                            \
               $(subst .c,.o, $(notdir $(_ALL_SOURCE))))

ifeq ($(COMPILER),gcc_arm_tos.mk)
_ALL_OBJECTS += $(addprefix $(_SUBSYS_OBJ_PATH)/,                           \
               $(subst .S,.o,$(notdir $(_ALL_S_SOURCE)))) 
vpath %S $(_VPATH_S)               
endif

ifeq ($(COMPILER),gcc_arm_linux.mk)
_ALL_OBJECTS += $(addprefix $(_SUBSYS_OBJ_PATH)/,                           \
               $(subst .S,.o,$(notdir $(_ALL_S_SOURCE)))) 
vpath %S $(_VPATH_S)               
endif

ifeq ($(COMPILER),rvct.mk)           
_ALL_OBJECTS += $(addprefix $(_SUBSYS_OBJ_PATH)/,                           \
               $(subst .s,.o,$(notdir $(_ALL_s_SOURCE))))
vpath %s $(_VPATH_S)                 
endif

vpath %c $(_VPATH_C)
vpath %h $(_VPATH_H)

#===============================================================================
#PC-LINT rules
#===============================================================================
_ALL_LINT_FILES = 
ifeq ($(LINTCHK),yes) 
_ALL_LINT_FILES = $(addprefix $(_SUBSYS_OBJ_PATH)/lnt/,                     \
               $(subst .c,.lnt, $(notdir $(_ALL_SOURCE))))
endif

#_ALL_LINT_PATH = $(subst -I, -i, $(INCLUDE) $(STDINCLUDE) $(addprefix -i, $(_VPATH_H)))

#_ALL_LINT_PATH = $(subst /,\, $(addsuffix ", $(foreach item, $(INCLUDE) $(STDINCLUDE), $(subst -I,-i", $(item)))))

#===============================================================================
#ļ
#===============================================================================
.PHONY: lib clean

lib: libenv $(_SUBSYS_LIB_PATH)/$(_SUBSYS_NAME).a

$(_SUBSYS_LIB_PATH)/$(_SUBSYS_NAME).a:$(_ALL_OBJECTS) $(_ALL_LINT_FILES)
	@$(ECHO) ""
	@-$(MKDIR) $(_SUBSYS_LIB_PATH)
	$(VERB)$(LD) $(LDFLAGS) -o $@ $(_ALL_OBJECTS)
	@$(ECHO) "=================================================================="
	@$(ECHO) "--- make lib $@ done."
	@$(ECHO) "=================================================================="
	@$(ECHO) ""

clean:
	@-$(RM) $(_SUBSYS_OUTPUT_LIB)
	@$(ECHO) "--- clean lib file $(_SUBSYS_OUTPUT_LIB) done."
	@-$(RM) $(_SUBSYS_OBJ_PATH)/lnt/*
	@-$(RMDIR) $(_SUBSYS_OBJ_PATH)/lnt
	@-$(RM) $(_SUBSYS_OBJ_PATH)/*
	@-$(RMDIR) $(_SUBSYS_OBJ_PATH)
	@$(ECHO) "--- clean obj file $(_SUBSYS_OBJ_PATH)/* done."
	@$(ECHO) ""

#===============================================================================
# ļɹ
#===============================================================================
$(_SUBSYS_OBJ_PATH)/%.o:%.c
	@$(ECHO) Compile $<
	@-$(MKDIR) $(_SUBSYS_OBJ_PATH)
	$(VERB)$(CC) $(CCFLAGS) $(CPU_PUB_DEFINE) $(DEFINE) $(INCLUDE) $(STDINCLUDE) -c $< -o $@
	@$(ECHO) Done!

$(_SUBSYS_OBJ_PATH)/%.o:%.s
	@$(ECHO) Compile $<
	@-$(MKDIR) $(_SUBSYS_OBJ_PATH)
	@$(ASM) $(ASFLAGS)  -o $@ $(INCLUDE) $<
	@$(ECHO) Done!
	
$(_SUBSYS_OBJ_PATH)/%.o:%.S
	@$(ECHO) Compile $<
	@-$(MKDIR) $(_SUBSYS_OBJ_PATH)
	@$(CC) $(CCFLAGS) $(ASFLAGS)  -o $@ $(INCLUDE) $<
	@$(ECHO) Done!

#===============================================================================
# lntļɹ
#===============================================================================
$(_SUBSYS_OBJ_PATH)/lnt/%.lnt:%.c
	@$(ECHO) lint $<
	@-$(MKDIR) $(_SUBSYS_OBJ_PATH)/lnt
	@$(PCLINT) -u -b +fdi $(CPU_PUB_DEFINE) $(DEFINE) $(LINTOPTION) $(INCLUDE) $(STDINCLUDE) $< > $@
	@$(ECHO) Done!

