#ifndef CSERIAL_H_INCLUDED
#define CSERIAL_H_INCLUDED

#include "define.h"

#define BAUDRATE 		B115200
#define READLENGTH 		1024
#define CFLAGS_TO_SET 	(CREAD | HUPCL)
#define CFLAGS_TO_CLEAR (CSTOPB | PARENB | CLOCAL)
#define CFLAGS_HARDFLOW (CRTSCTS)

int Open(const char *portName);
int Close();
/* send AT cmd, and return */
int SendATString(const char *Dev_tty, const char *AtString, char *RebackString);
BOOL SendData(const BYTE *pbyWriteBuffer, size_t dwWriteCount, DWORD dwSleepAfterAction, DWORD dwTimeoutCount);
BOOL ReadData(BYTE *pbyWriteBuffer, size_t dwWriteCount, DWORD dwSleepAfterAction, DWORD dwTimeoutCount);
BYTE *ReadDataExtraFuncB(DWORD dwReadCount, DWORD dwSleepAfterAction,DWORD dwTimeoutCount);

#endif // CSERIAL_H_INCLUDED
