#include <stdio.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>

#include "LogInfo.h"
#include "define.h"

#define LOG_ENTRY_SIZE (BUFSIZ * 8)

static int s_log_flag = 0;
static char s_file_name[FILE_NAME_LENGTH_MAX] = {0};
// char g_log_path[FOLDER_PATH_LENGTH_MAX] = LOG_PATH;

/* 保存Log信息到文件 */
void DownLoad_LogInfo(const int line, const char *fn,
					  const char *func_name, const char *fmt, ...)
{

	char log_fn[FILE_PATH_LENGTH_MAX] = {0};
	struct timeval t;
	FILE *fp_log = NULL;

	gettimeofday(&t, NULL);
	struct tm *p = localtime(&t.tv_sec);

	if(s_log_flag == 0)
	{
		strftime(s_file_name, FILE_NAME_LENGTH_MAX, "%Y-%m-%d_%H%M%S", p);
		s_log_flag = 1;
	}	
	snprintf(log_fn, FILE_PATH_LENGTH_MAX, "%s/downloader_%s.log", g_log_path, s_file_name);	
	fp_log = fopen(log_fn, "a+");

	va_list arglist;
	static char buffer[LOG_ENTRY_SIZE] = ("");
	static char tmp[LOG_ENTRY_SIZE] = ("");

	va_start(arglist, fmt);
	vsnprintf(tmp, LOG_ENTRY_SIZE, fmt, arglist);
	va_end(arglist);
	sprintf(buffer, "[%d-%d-%d %d:%d:%d.%ld] <%s>: #%d @ %s\n \t %s\n",
			(1900 + p->tm_year), (1 + p->tm_mon), p->tm_mday,
			p->tm_hour, p->tm_min, p->tm_sec, t.tv_usec,
			func_name,
			line, fn, tmp);

	if (NULL != fp_log)
	{
		fprintf(fp_log, ("%s"), buffer);
		fclose(fp_log);
	}
}
