/*********************************************************************
 Copyright 2016 by	ZIXC Corporation.
*
* FileName::	zx297520.c
* File Mark:
* Description:
* Others:
* Version:	 v1.0
* Author:	zhouqi
* Date:	  2014-1-15

* History 1:
*	  Date:
*	  Version:
*	  Author:
*	  Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <nand.h>
#include <asm/arch/nand.h>
#include <asm/arch/hardware.h>
#include <asm/arch/uart.h>
#include <asm/arch/lsp_crpm.h>
#include <power.h>
#include <partition_table.h>

#include <mmc.h>
#include <dwmmc.h>
#include <boot_mode.h>
#include <load_image.h>
#include <zx234290.h>
#include <charge.h>
//#include <led.h>
#include <lcd.h>
#include <peripheral.h>
#include "board.h"
#include "pub_flags.h"

#include <drvs_gpio.h>

#include <asm/arch/gmac.h>
#include <command.h>
#include <version.h>
#include <secure_verify.h>
#include <asm/arch/efuse.h>

#include "cmd_downver.h"
#include <../drivers/dma/zx29_dma.h>

#include <watchdog.h>
#include <linux/mtd/partitions.h>

#include <linux/mtd/nor_spifc.h>

#define RET_BOOT_READY		1

DECLARE_GLOBAL_DATA_PTR;

#if	TIME_DEBUG
#define time_debug_reset(fmt)	fmt = get_timer(0)
#define time_debug_printf(fmt, val)	printf(fmt ,get_timer(val))
#else
#define time_debug_reset(fmt)
#define time_debug_printf(fmt, val)
#endif	/* TIME_DEBUG */

typedef struct {
	int 	(*Init)(void);
	char	func_name[20];
}sys_init_func_t;

#ifdef CONFIG_ZX297520V3E_VEHICLE_DC_REF
int imagefs_flag;
extern struct fsl_qspi spi_nor_flash;
extern int flash_dmabuf_disable_flag;
#endif
extern boot_reason_t g_boot_reason;
extern uint32_t g_gmac_init_flag;
extern uint32_t g_gmac_init_overtime;
extern unsigned char g_ddr_size_flag;

unsigned int g_uiDebugLevel = UBOOT_NOTICE;
unsigned int g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM32_A9_SIZE;


#ifndef CFG_TEMP_ADDR
#define CFG_TEMP_ADDR	0x22000000
#endif

#define reg32(addr)			(*(volatile unsigned long *)(addr))

#define UDELAY_PARAM_1SEC	(100000/3)

/* DebugLevel - Controlled at compile time
 * UBOOT_ERR	-> Noncritical error conditions.
 * UBOOT_WARN	-> Warning conditions that should be taken care of.
 * UBOOT_NOTICE -> Normal, but significant events.
 * UBOOT_DBG	-> Informational messages that require no action.
 * UBOOT_INFO	-> Debugging messages, output if the developer enabled debugging.
 */
//unsigned int g_uiDebugLevel = UBOOT_NOTICE;
extern int copy_ddr_allbin(void);

/*******************************************************************************
 * Function:	board_init
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int board_init(void)
{
	return 0;
}

/*******************************************************************************
 * Function:	dram_init_banksize
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void dram_init_banksize(void)
{
	gd->bd->bi_dram[0].start = PHYS_SDRAM_1;
	gd->bd->bi_dram[0].size = PHYS_SDRAM_1_SIZE;
}

/*******************************************************************************
 * Function:	dram_init
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int dram_init(void)
{
	gd->ram_size = get_ram_size((long *)CONFIG_SYS_SDRAM_BASE,
				PHYS_SDRAM_1_SIZE);

	return 0;
}

/*******************************************************************************
 * Function:	checkboard
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int checkboard(void)
{
#ifdef CONFIG_DISPLAY_BOARDINFO
	printf("Board: ZX297520V3\n");
#endif

	return 0;
}

void clear_iram(uint32_t addr, uint32_t len)
{
	uint32_t i = 0;
	for(i = addr; i < addr + len; i+=4)
	{
		writel(0x0, i);
	}
}

void clear_tmp_buf(void)
{
	clear_iram(CONFIG_SYS_SDRAM_TEMP_BASE, 0x800);
}

/*
 * EC: 616000510470
 */
static int mdl_poweron(void)
{
	pmu_pull_on_ps_hold();

	return 0;
}

static int gmac_download_init(void)
{
	int ret = 0;

	get_gmac_init_flag();
	BOOT_PRINTF(UBOOT_DBG, "get_gmac_init_flag = 0x%x, read_gmac_init_flag = 0x%x.\n", get_gmac_init_flag(), read_gmac_init_flag());
	if(1 == read_gmac_init_flag())
	{
		BOOT_PRINTF(UBOOT_NOTICE, "gmac init overtime[%ds].....$$$$$$$$$$$$$$\n", read_gmac_init_overtime());

		puts("Net:	");
		eth_initialize(gd->bd);

		if (run_command ("downver allbins", 0) >= 0)
		{
			ret = copy_ddr_allbin();
			if(ret != 0)
			{
				BOOT_PRINTF(UBOOT_ERR, "net load write from ddr to nand FAILED !!!\n");
			}
		}
		else
		{
			BOOT_PRINTF(UBOOT_ERR, "run_command downver allbins FAILED !!!\n");
		}
	}

	return 0;
}

static int test_env_entry(void)
{
	/* Ӳ */
#if CONFIG_HARDWARE_TEST
	hardware_test();
#endif

#if CONFIG_MUTUAL_DEBUG	//1֮ͿԽUBoot̨
	for (;;)
	{
		main_loop();
	}
#endif

	return 0;
}

static int boot_reason_init(void)
{
	int ret = 0;
	unsigned int amt_flag = 0;
	unsigned int key_times = 0;
	unsigned int *poweron_type = (unsigned int *)POWERON_TYPE_ADDR;	 //ʱʹ

	BOOT_PRINTF(UBOOT_DBG, "Normal mode.\n");

	amt_flag = readl(POWERON_TYPE_ADDR);
	BOOT_PRINTF(UBOOT_NOTICE, "VALUE = 0x%x!\n", amt_flag);
	if(amt_flag == AMT_MODE_FLAG)
	{
		BOOT_PRINTF(UBOOT_NOTICE, "AMT VALUE = AMT_MODE_FLAG!\n");
		g_boot_reason = RB_AMT;
	}
	else
	{
		ret = get_boot_reason();
		if(ret != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "get boot reason ERROR !!!\n");
			/* TBD: Error Return. */
		}
	}

	if(read_fota_update_flag() == FOTA_RECOVERY)
	{
		*poweron_type = POWER_ON_FOTA;
	}
	else if(read_fota_update_flag() == FOTA_LOCALUPDATE)
	{
		*poweron_type = POWER_ON_LOCALUPDATE;
	}
	else if(g_boot_reason == RB_AMT)
	{
		*poweron_type = POWER_ON_AMT;
	}
	else if(g_boot_reason == RB_PRODUCTION)
	{
		*poweron_type = POWER_ON_PRODUCTION;
	}
	else if((g_boot_reason & 0xF0) == ZX234290_WDT_RST_FLAG)
	{
		*poweron_type = g_boot_reason & 0x0F;
	}
	else if(g_boot_reason == RB_RESET_NOMAL)
	{
		*poweron_type = POWER_ON_NORMAL;
	}
	else if(g_boot_reason == RB_RTC)
	{
		*poweron_type = POWER_ON_RTC; //POWER_ON_NORMAL;
	}
	else if(g_boot_reason == RB_RESET_EXCEPT)
	{
		*poweron_type = POWER_ON_EXCEPTRESET;
	}
	else if(g_boot_reason == RB_POWER_BOOST_IN)
	{
		*poweron_type = POWER_ON_BOOST_IN;
	}
	else if(g_boot_reason == RB_RESET_ALARM)
	{
		*poweron_type = POWER_ON_NORMAL;
	}
	else
	{
		*poweron_type = POWER_ON_NORMAL;
	}
	BOOT_PRINTF(UBOOT_NOTICE, "poweron_type=0x%x.\n", *poweron_type);
	zx234290_write_flag(ZX234290_WDT_RST_FLAG | *poweron_type);

	return 0;
}

static int bat_detect(void)
{
	return 0;
}

void display_boot_animation(unsigned int poweron_type)
{
	switch (poweron_type) {
	case POWER_ON_LOCALUPDATE:
		Show_UpdateWait();
		break;

	case POWER_ON_NORMAL:
		Show_PowerOn_Normal();
		break;

	case POWER_ON_FOTA:
		Show_PowerOn_Fota();
		break;

	case POWER_ON_CHARGING:
		Show_Charging();
		break;

	default:
		break;
	}
}

static int boot_prepare(void)
{
	unsigned int poweron_type = reg32(POWERON_TYPE_ADDR);	 //ʱʹ

/*
	if (poweron_type == POWER_ON_CHARGING) {
		pmu_pull_off_ps_hold();
	} else {
		pmu_pull_on_ps_hold();
	}
*/
#if 1
	//zx234290_set_softon(1);
#else
	zx234290_set_softon(0);
	pmu_pull_off_ps_hold();
#endif

	display_boot_animation(poweron_type);

	return 0;
}

#ifdef CONFIG_ZX297520V3E_VEHICLE_DC_REF
static uint32_t page_align(uint32_t offset)
{
	struct flash_ops *flash = NULL;
	uint32_t page_size = 0;

	flash = get_flash_ops();
	page_size = flash->page_size;
	if( offset & (page_size - 1) )
	{
		offset &= (~(page_size - 1));
		offset += page_size;
	}
	return offset;
}

int rewrite_flags(void)
{
    uint32_t off = 0;
	uint32_t flags_size = 0;/*flags2M*/
	uint32_t blockNum = 0;
	uint32_t work_area_offset = 0;
	uint32_t backup_area_offset = 0;
	int ret = 0;
	int type = 0;
	uchar * flags_name = "flags";
	T_FLAGS_INFO fotaFlagInfo = {0};
	T_DualSystem_Status system_status;
	system_status.status = DUALSYSTEM_STATUS_UNBOOTABLE;
	u32 fota_size = sizeof(T_FLAGS_INFO);
	fota_size = page_align(fota_size);
	
	nand_info_t *nand = &nand_info[nand_curr_device];
	struct fsl_qspi *nor = &spi_nor_flash;
	uint32_t part_offset = 0;
	struct flash_ops *flash = NULL;
	flash_dmabuf_disable_flag = 1;
	nand_erase_options_t opts;

	flash = get_flash_ops();
	type = read_boot_flashtype();

	/* Ѱҷ */
	partition_entry_t * entry = find_partition_para(flags_name);
	if( entry == NULL )
	{
		BOOT_PRINTF(UBOOT_ERR, "[%s]: can't find the partition...\n", flags_name);
		return -1;
	}
	/* ÷׵ַʹС */
	part_offset = entry->part_offset;
	flags_size = entry->part_size;
	
	/*Ĭflags*/
	fotaFlagInfo.magic_start = FLAGS_MAGIC;
	fotaFlagInfo.boot_fota_flag.boot_to = DUAL_SYSTEM;
	fotaFlagInfo.boot_fota_flag.fota_status = 1;
	fotaFlagInfo.boot_fota_flag.system.status = DUALSYSTEM_STATUS_BOOTABLE;
	fotaFlagInfo.boot_fota_flag.system2.status = DUALSYSTEM_STATUS_BOOTABLE;
    fotaFlagInfo.boot_env.dualsys_type = DUALSYSTEM_AB;
	fotaFlagInfo.magic_end = FLAGS_MAGIC;
	
	/*дflags*/
	if(type == IF_TYPE_NAND || type == IF_TYPE_SPI_NAND)
	{
        
	   /*ȷͱƫƵַ*/
		for (off = part_offset; off < part_offset+flags_size; off += nand->erasesize)
		{
			if (!(nand_block_isbad(nand,off))) 
				blockNum += 1;
			
			if(blockNum == 1)
				work_area_offset = off;
			
			else if(blockNum == 2)
			{
				 backup_area_offset = off;
				 break;
			}		
		}
	
		if(blockNum < 2)
		{
			printf("flags partition have not enough space!\n");
				
			return -1;
		}
		
		/*flags*/
		memset(&opts, 0, sizeof(opts));
		opts.offset = work_area_offset;
		opts.length = fota_size;
		ret = flash->erase(nand,&opts);

		if( ret != 0 )
 		{
 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs work area error!\n", flags_name);
 			return 1;
 		}

		ret = flash->write(nand,(loff_t)(work_area_offset),
				  &fota_size,(u_char *)(&fotaFlagInfo),0);
		
 		if( ret != 0 )
 		{
 			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs work area error!\n", flags_name);
 			return 1;
 		}
	
		/*flags*/
		memset(&opts, 0, sizeof(opts));
		opts.offset = backup_area_offset;
		opts.length = fota_size;
		ret += flash->erase(nand,&opts);

		if( ret != 0 )
 		{
 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs backup area error!\n", flags_name);
 			return 1;
 		}
		
		ret += flash->write(nand,(loff_t)(backup_area_offset),
				  &fota_size,(u_char *)(&fotaFlagInfo),0);
 		if( ret != 0 )
 		{
 			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs backup area error!\n", flags_name);
 			return 1;
 		}
	}
	else if(type == IF_TYPE_NOR)
	{   
        /*flags*/
		work_area_offset = part_offset;
        backup_area_offset = part_offset + nor->nor[0].mtd.erasesize;
		ret = nand_erase(&(nor->nor[0].mtd), (loff_t)(work_area_offset), fota_size);
		ret += nand_erase(&(nor->nor[0].mtd), (loff_t)(backup_area_offset), fota_size);
		if( ret != 0 )
 		{
 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs error!\n", flags_name);
 			return 1;
 		}
		
		ret = nand_write(&(nor->nor[0].mtd), (loff_t)(work_area_offset), 
						&fota_size, (u_char *)(&fotaFlagInfo));
		ret += nand_write(&(nor->nor[0].mtd), (loff_t)(backup_area_offset), 
						&fota_size, (u_char *)(&fotaFlagInfo));
		if(ret != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs error!\n", flags_name);
			return 1;
		}
	}
	
	printf("flags partition data is error,already rewrite default parameters!\n");
	//system_reset();
	
	flash_dmabuf_disable_flag = 0; 
    flush_dcache_all();
    return 0;
}

int writeback_flags(void)
{
    uint32_t off = 0;
	uint32_t flags_size = 0;/*flags2M*/
	uint32_t blockNum = 0;
	uint32_t work_area_offset = 0;
	uint32_t backup_area_offset = 0;
	int ret = 0;
	int type = 0;
	uchar * flags_name = "flags";
	T_FLAGS_INFO fotaFlagInfo = {0};
	T_DualSystem_Status system_status;
	system_status.status = DUALSYSTEM_STATUS_UNBOOTABLE;
	u32 fota_size = sizeof(T_FLAGS_INFO);
	fota_size = page_align(fota_size);
	
	nand_info_t *nand = &nand_info[nand_curr_device];
	struct fsl_qspi *nor = &spi_nor_flash;
	uint32_t part_offset = 0;
	struct flash_ops *flash = NULL;
	flash_dmabuf_disable_flag = 1;
	nand_erase_options_t opts;

	flash = get_flash_ops();
	type = read_boot_flashtype();

	/* Ѱҷ */
	partition_entry_t * entry = find_partition_para(flags_name);
	if( entry == NULL )
	{
		BOOT_PRINTF(UBOOT_ERR, "[%s]: can't find the partition...\n", flags_name);
		return -1;
	}
	/* ÷׵ַʹС */
	part_offset = entry->part_offset;
	flags_size = entry->part_size;
	
	/*ȡflags*/
	ret = load_flags(&fotaFlagInfo);
	if(ret != 0)
	{
		printf("read flags partition err.\n");
		return -1;
	}

	/*дflags*/
    if(fotaFlagInfo.boot_fota_flag.boot_to == DUAL_SYSTEM)
    {
        fotaFlagInfo.boot_fota_flag.boot_to = DUAL_SYSTEM2;
		fotaFlagInfo.boot_fota_flag.system = system_status;

		if(type == IF_TYPE_NAND || type == IF_TYPE_SPI_NAND)
		{
            
		   /*ȷͱƫƵַ*/
			for (off = part_offset; off < part_offset+flags_size; off += nand->erasesize)
			{
				if (!(nand_block_isbad(nand,off))) 
					blockNum += 1;
				
				if(blockNum == 1)
					work_area_offset = off;
				
				else if(blockNum == 2)
				{
					 backup_area_offset = off;
					 break;
				}		
			}
		
			if(blockNum < 2)
			{
				printf("flags partition have not enough space!\n");
					
				return -1;
			}
			
			/*flags*/
			memset(&opts, 0, sizeof(opts));
			opts.offset = work_area_offset;
			opts.length = fota_size;
			ret = flash->erase(nand,&opts);

			if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs work area error!\n", flags_name);
	 			return 1;
	 		}

			ret = flash->write(nand,(loff_t)(work_area_offset),
					  &fota_size,(u_char *)(&fotaFlagInfo),0);
	 		if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs work area error!\n", flags_name);
	 			return 1;
	 		}
			
			/*flags*/
			memset(&opts, 0, sizeof(opts));
			opts.offset = backup_area_offset;
			opts.length = fota_size;
			ret += flash->erase(nand,&opts);

			if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs backup area error!\n", flags_name);
	 			return 1;
	 		}
			
			ret += flash->write(nand,(loff_t)(backup_area_offset),
					  &fota_size,(u_char *)(&fotaFlagInfo),0);
	 		if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs backup area error!\n", flags_name);
	 			return 1;
	 		}
		}
		else if(type == IF_TYPE_NOR)
		{   
            /*flags*/
			work_area_offset = part_offset;
	        backup_area_offset = part_offset + nor->nor[0].mtd.erasesize;
			ret = nand_erase(&(nor->nor[0].mtd), (loff_t)(work_area_offset), fota_size);
			ret += nand_erase(&(nor->nor[0].mtd), (loff_t)(backup_area_offset), fota_size);
			if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs error!\n", flags_name);
	 			return 1;
	 		}
			
			ret = nand_write(&(nor->nor[0].mtd), (loff_t)(work_area_offset), 
							&fota_size, (u_char *)(&fotaFlagInfo));
			ret += nand_write(&(nor->nor[0].mtd), (loff_t)(backup_area_offset), 
							&fota_size, (u_char *)(&fotaFlagInfo));
			if(ret != 0)
			{
				BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs error!\n", flags_name);
				return 1;
			}
		}
		printf("system boot status is changed to unbootable!\n");
		//system_reset();
	}
	else if(fotaFlagInfo.boot_fota_flag.boot_to == DUAL_SYSTEM2)
    {
        fotaFlagInfo.boot_fota_flag.boot_to = DUAL_SYSTEM;
		fotaFlagInfo.boot_fota_flag.system2 = system_status;

		if(type == IF_TYPE_NAND || type == IF_TYPE_SPI_NAND)
		{
            /*ȷͱƫƵַ*/
			for (off = part_offset; off < part_offset+flags_size; off += nand->erasesize)
			{
				if (!(nand_block_isbad(nand,off))) 
					blockNum += 1;
				
				if(blockNum == 1)
					work_area_offset = off;
				
				else if(blockNum == 2)
				{
					 backup_area_offset = off;
					 break;
				}		
			}
		
			if(blockNum < 2)
			{
				printf("flags partition have not enough space!\n");
					
				return -1;
			}
			
			/*flags*/
			memset(&opts, 0, sizeof(opts));
			opts.offset = work_area_offset;
			opts.length = fota_size;
			ret = flash->erase(nand,&opts);

			if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs work area error!\n", flags_name);
	 			return 1;
	 		}

			ret = flash->write(nand,(loff_t)(work_area_offset),
					  &fota_size,(u_char *)(&fotaFlagInfo),0);
	
	 		if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs work area error!\n", flags_name);
	 			return 1;
	 		}
		
			/*flags*/
			memset(&opts, 0, sizeof(opts));
			opts.offset = backup_area_offset;
			opts.length = fota_size;
			ret += flash->erase(nand,&opts);

			if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs backup area error!\n", flags_name);
	 			return 1;
	 		}
			
			ret += flash->write(nand,(loff_t)(backup_area_offset),
					  &fota_size,(u_char *)(&fotaFlagInfo),0);
	 		if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs backup area error!\n", flags_name);
	 			return 1;
	 		}
		}
		else if(type == IF_TYPE_NOR)
		{
            /*flags*/
			work_area_offset = part_offset;
	        backup_area_offset = part_offset + nor->nor[0].mtd.erasesize;
			ret = nand_erase(&(nor->nor[0].mtd), (loff_t)(work_area_offset), fota_size);
			ret += nand_erase(&(nor->nor[0].mtd), (loff_t)(backup_area_offset), fota_size);
			if( ret != 0 )
	 		{
	 			BOOT_PRINTF(UBOOT_ERR, "[%s]: erase the flags imagefs error!\n", flags_name);
	 			return 1;
	 		}
			
			ret = nand_write(&(nor->nor[0].mtd), (loff_t)(work_area_offset), 
							&fota_size, (u_char *)(&fotaFlagInfo));
			ret += nand_write(&(nor->nor[0].mtd), (loff_t)(backup_area_offset), 
							&fota_size, (u_char *)(&fotaFlagInfo));
			if(ret != 0)
			{
				BOOT_PRINTF(UBOOT_ERR, "[%s]: write the flags imagefs error!\n", flags_name);
				return -1;
			}
		}
		//flash.write(nand,(loff_t)part_offset,&flagsSize,(u_char *)(&fotaFlag),0);
		printf("system2 boot status is changed to unbootable!\n");
	}
	
	flash_dmabuf_disable_flag = 0; 
    flush_dcache_all();
    return 0;
}

int system_boot_status(void)
{
    int ret;
	u32 bootFlags = readl(BOOT_FLAG_ADDR);
	
	if(bootFlags == DUALSYSTEM_STATUS_UNBOOTABLE)
	{
        ret = writeback_flags();
		if(ret != 0)
			return -1;
		system_reset();
		return 0;
	}
	else if(bootFlags == DUALSYSTEM_STATUS_BOOTABLE)
	{
        return 0;
	}
	else if(bootFlags == FLAGS_PARTITION_ERROR)
	{
		ret = rewrite_flags();
		if(ret != 0)
			return -1;
		return 0;
	}
}

static int read_imagefs_flag(void)
{
    int ret = 0;
    /* ȡflags */
	T_FLAGS_INFO fotaFlagInfo;
	ret = load_flags(&fotaFlagInfo);
	if(ret != 0)
	{
		printf("read flags partition err.\n");
		return -1;
	}
	
    if(fotaFlagInfo.boot_fota_flag.boot_to == DUAL_SYSTEM)
    {
        imagefs_flag = 1;
		printf("imagefs entry......\n");
	}
	else if(fotaFlagInfo.boot_fota_flag.boot_to == DUAL_SYSTEM2)
    {
        imagefs_flag = 2;
		printf("imagefs2 entry......\n");
	}
	
	return 0;
}
#endif
static int boot_entry(void)
{
	int ret = 0;
	unsigned int poweron_type = reg32(POWERON_TYPE_ADDR);	 //ʱʹ

	//g_ddr_size_flag = CHIP_DDR_IS_32M;

	switch (poweron_type) {
	case POWER_ON_LOCALUPDATE:
		break;
	case POWER_ON_FOTA:
		BOOT_PRINTF(UBOOT_NOTICE, "Fota entry!\n");
		if(g_ddr_size_flag == CHIP_DDR_IS_32M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM32_RECOVERY_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_64M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM64_RECOVERY_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_128M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM128_RECOVERY_A9_SIZE;
		}		
		else
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM256_RECOVERY_A9_SIZE;
		}
		
		ret = fs_load_arm_image_linux(ARM_RECOVERY_USERDATA_IMAGE);	/*FOTA-UPDATE*/
		break;
	default:
		BOOT_PRINTF(UBOOT_NOTICE, "Normal entry!\n");
		g_sys_kernel_sdram_size = DDR_BASE_LEN_AP;
#if 0
		if(g_ddr_size_flag == CHIP_DDR_IS_32M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM32_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_64M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM64_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_128M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM128_A9_SIZE;
		}
		else
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM256_A9_SIZE;
		}
#endif
		ret = fs_load_m0_image();
		ret += fs_load_zsp_image();
		ret += fs_load_dtb_image();
		ret += fs_load_arm_image_linux(ARM_CAP_IMAGE);
		ret += fs_load_arm_image_linux(ARM_APP_IMAGE);
		break;
	}

#if VERSION_RELEASE
	if( ret != 0 )
	{
		BOOT_PRINTF(UBOOT_ERR, "load imagefs ERROR !!!\n");
#ifdef CONFIG_ZX297520V3E_VEHICLE_DC_REF
        writeback_flags();
		system_reset();
#endif
	}
#endif

	return 0;
}

static const sys_init_func_t uboot_init_func_tbl[] =
{
	{mdl_poweron,			"pull on pshold"},
	{wdt_get_reboot_reason,	"wdt_reboot"},
	{dma_init,				"dma"},
	{i2c_init,				"i2c"},
	{peripheral_init,		"peri"},
	{nand_init,				"nand"},
	{partition_init,		"partition"},	
	{gmac_download_init,	"gmac"},
	{test_env_entry,		"test"},
	{efuse_init,			"efuse"},
#ifdef CONFIG_ZX297520V3E_VEHICLE_DC_REF
    {system_boot_status,    "system_boot_status"},
	{read_imagefs_flag,     "read_imagefs_flag"},
#endif
	{nvrw_flag_init,		"nvrw_flag"},
	{boot_reason_init,		"boot_reason"},
	{wdt_init,				"wdt"},
	{bat_detect,			"bat_det"},
	{boot_prepare,			"boot_prepare"},
	{NULL,					{}}
};

static const sys_init_func_t tboot_init_func_tbl[] =
{
	{wdt_get_reboot_reason,	"wdt_reboot"},
	{dma_init,				"dma"},
	{i2c_init,				"i2c"},
	{peripheral_init,		"peri"},
	{nand_init,				"nand"},
	{NULL,					{}}
};

int uboot_init_func(void)
{
	unsigned int dev_index;
	int ret;

	BOOT_PRINTF(UBOOT_NOTICE, "go into uboot init func\n");

	for (dev_index = 0; (uboot_init_func_tbl[dev_index].Init != NULL); dev_index++)
	{
		ret = uboot_init_func_tbl[dev_index].Init();

		if (ret < 0) {
			BOOT_PRINTF(UBOOT_ERR, "uboot init %s fail, ret = %d\n",
				uboot_init_func_tbl[dev_index].func_name, ret);
			BUG();
			return ret;
		} else {
			BOOT_PRINTF(UBOOT_NOTICE, "uboot init %s success\n",
				uboot_init_func_tbl[dev_index].func_name);
		}
	}

	return SUCCESS;
}

int tboot_init_func(void)
{
	unsigned int dev_index;
	int ret;

	BOOT_PRINTF(UBOOT_NOTICE, "go into tboot init func\n");

	for (dev_index = 0; (tboot_init_func_tbl[dev_index].Init != NULL); dev_index++)
	{
		ret = tboot_init_func_tbl[dev_index].Init();
		if (ret < 0) {
			BOOT_PRINTF(UBOOT_ERR, "tboot init %s fail, ret = %d\n",
				tboot_init_func_tbl[dev_index].func_name, ret);
			BUG();
			return ret;
		} else {
			BOOT_PRINTF(UBOOT_NOTICE, "tboot init %s success\n",
				tboot_init_func_tbl[dev_index].func_name);
		}
	}

	return SUCCESS;
}

/*******************************************************************************
 * Function:	sys_entry
 * Description: ϵͳ
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void sys_entry(void)
{
	BOOT_PRINTF(UBOOT_NOTICE, "sys_entry ...\n");

	switch (get_load_mode()) {
	case TLOAD_MODE:
		tboot_init_func();
		run_command("downloader", 0);
		break;
	case ZLOAD_MODE:
		uboot_init_func();
		boot_entry();
		//clear_tmp_buf();
		break;
	default:
		break;
	}

	add_partition_to_bootargs();
	for (;;)
	{
		main_loop();
	}

	hang();
	/* NOTREACHED - no way out of command loop except booting */
}

