/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:	hal_led.c
 * File Mark:
 * Description:	 This file contains the hal layer routines for i2c driver.
 * Others:
 * Version:		  V1.0
 * Author:		  yx
 * Date:		  2014-07-03
 * History 1:
 *	   Date:
 *	   Version:
 *	   Author:
 *	   Modification:
 * History 2:
  ******************************************************************************/

/****************************************************************************
*								   Include files
****************************************************************************/

//#include "drvs_general.h"
//#include "drvs_i2c.h"
#include <linux/types.h>
#include <zx234290.h>
#include <led.h>
#include <drvs_gpio.h>
#include "common.h"
//#include <gpio.h>

/****************************************************************************
*											   Local Macros
****************************************************************************/
#define SD1_IO_1V8_EN	0x13c830
#define REG32(x)			    (*(volatile u32*)(x))
//xf.li@20230412 add for enable GNSS start
#define ZX_TOP_CRM_BASE	0x0013B000
//xf.li@20230412 add for enable GNSS end
/****************************************************************************
*											   Local Types
****************************************************************************/

/****************************************************************************
*											   Local Constants
****************************************************************************/


/****************************************************************************
 * Function:	peripheral_init
 * Description: init the peripheral include pmu\charger\led\lcd etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int peripheral_init(void)
{
	int ret = 0;
	ret = power_init();

/*led*/

/*lcd*/

	/* jtag调试 */
#if 0
	jtag_init();
#endif

//#if 0//ref need ldo8 2.85V
#if defined(CONFIG_ZX297520V3E_VEHICLE_DC) || defined(CONFIG_ZX297520V3E_VEHICLE_DC_REF)
/*set mmc io and vccQ*/	
	zx234290_set_ldo8_voltage(VLDOD_1_800);
	zx234290_set_ldo8_sleep_voltage(VLDOD_1_800);
	zx234290_ldo8_enable(1);
	
	REG32(SD1_IO_1V8_EN) |=(1<<1);
//xf.li@20230412 add for enable GNSS start
	REG32(ZX_TOP_CRM_BASE + 0x34) |= (0x1<<5);
	zDrvGpio_SetFunc(GPIO15,GPIO15_CLK_OUT0);
	/*关闭gps电源*/
	zDrvGpio_SetFunc(GPIO86, GPIO86_GPIO86);
	zDrvGpio_SetDirection(GPIO86, GPIO_OUT);
	zDrvGpio_SetOutputValue(GPIO86, GPIO_LOW);

	zDrvGpio_SetFunc(GPIO126,GPIO126_GPIO126);
	zDrvGpio_SetDirection(GPIO126,GPIO_OUT);
	zDrvGpio_SetOutputValue(GPIO126,GPIO_LOW);
//xf.li@20230412 add for enable GNSS end
#endif
	zx234502_charger_enable();

	return ret ;
}

/****************************************************************************
 * Function:	Show_UpdateWait
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateWait(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_UpdateSucc
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateSucc(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_UpdateFail
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_UpdateFail(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_LowPower
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_LowPower(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_No_Battery
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_No_Battery(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_PowerOn_Normal
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_PowerOn_Normal(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	Show_PowerOn_Normal
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/

int Show_PowerOn_Fota(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}


/****************************************************************************
 * Function:	Show_Charging
 * Description: show the logo when the local updataing through lcd/led etc.
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int Show_Charging(void)
{
	int ret = 0;
/*led*/

/*lcd*/
	;
	return ret;
}

/****************************************************************************
 * Function:	zx_get_vbat_voltage
 * Description: .
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
int zx_get_vbat_voltage(void)
{
   // int ret = 0;

	return zx234290_get_adc1_voltage();
}

/****************************************************************************
 * Function:	zx_get_battery_Status
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *	   int
 *
 *
 * Others:
 ***************************************************************************/
unsigned int zx_get_battery_Status(void)
{
	int ret = 0;
	int boost_flag = 1;

	zx234502_battery_status(&boost_flag);
	if(boost_flag){
		return 0;/*battery uninstall*/
	}
	else
		return 1;/*battery install*/
}




