/******************************************************************/

#include "dwc2_driver.h"
#include <asm/pgtable.h>
#include <mach/iomap.h>

#include "../poll_usb_desc.h"
#include "dwc2_pcd.h"



struct dwc2_dev g_dwc2_dev = {0};

extern void usbPoll_Delay_ms(int ms);
extern void usbPoll_Delay_us(int us);
extern int32_t dwc2_pcd_handle_intr(dwc2_pcd_t * pcd);


static void dwc2_pcd_init_ep(dwc2_pcd_t * pcd, dwc2_pcd_ep_t * pcd_ep,
                                uint32_t is_in, uint32_t ep_num)
{
    /* Init EP structure */
    pcd_ep->desc = 0;
    pcd_ep->pcd = pcd;
    pcd_ep->stopped = 1;
    pcd_ep->queue_sof = 0;

    /* Init DWC ep structure */
    pcd_ep->dwc2_ep.is_in = is_in;
    pcd_ep->dwc2_ep.num = ep_num;
    pcd_ep->dwc2_ep.active = 0;
    pcd_ep->dwc2_ep.tx_fifo_num = 0;
    /* Control until ep is actvated */
    pcd_ep->dwc2_ep.type = DWC_OTG_EP_TYPE_BULK;
    pcd_ep->dwc2_ep.maxpacket = 512;
    pcd_ep->dwc2_ep.maxxfer = 65536;

    pcd_ep->dwc2_ep.start_xfer_buff = 0;
    pcd_ep->dwc2_ep.xfer_buff = 0;
    pcd_ep->dwc2_ep.xfer_len = 0;
    pcd_ep->dwc2_ep.xfer_count = 0;
    pcd_ep->dwc2_ep.sent_zlp = 0;
    pcd_ep->dwc2_ep.total_len = 0;
}

/**
 * Initialize ep's
 */
static void dwc_otg_pcd_reinit(dwc2_pcd_t * pcd)
{
    int i;
    uint32_t hwcfg1;
    dwc2_pcd_ep_t *ep;
    int in_ep_cntr, out_ep_cntr;
    uint32_t num_in_eps = (GET_CORE_IF(pcd))->dev_if->num_in_eps;
    uint32_t num_out_eps = (GET_CORE_IF(pcd))->dev_if->num_out_eps;

    /**
     * Initialize the EP0 structure.
     */
    pcd->ep0.dwc2_ep.pPara = (void*)(&g_dwc2_dev.g_in_pPara[1]);

    ep = &pcd->ep0;
    dwc2_pcd_init_ep(pcd, ep, 0, 0);

    in_ep_cntr = 0;
    hwcfg1 = (GET_CORE_IF(pcd))->hwcfg1.d32 >> 3;
    for (i = 1; in_ep_cntr < num_in_eps; i++)
    {
        if ((hwcfg1 & 0x1) == 0)
        {
            pcd->in_ep[in_ep_cntr].dwc2_ep.pPara = (void*)(&g_dwc2_dev.g_in_pPara[in_ep_cntr]);
            ep = &pcd->in_ep[in_ep_cntr];
            in_ep_cntr++;
            /**
             * @todo NGS: Add direction to EP, based on contents
             * of HWCFG1.  Need a copy of HWCFG1 in pcd structure?
             * sprintf(";r
             */
            dwc2_pcd_init_ep(pcd, ep, 1 /* IN */ , i);
        }
        hwcfg1 >>= 2;
    }

    out_ep_cntr = 0;
    hwcfg1 = (GET_CORE_IF(pcd))->hwcfg1.d32 >> 2;
    for (i = 1; out_ep_cntr < num_out_eps; i++)
    {
        if ((hwcfg1 & 0x1) == 0)
        {
            pcd->out_ep[out_ep_cntr].dwc2_ep.pPara = (void*)(&g_dwc2_dev.g_out_pPara[out_ep_cntr]);
            ep = &pcd->out_ep[out_ep_cntr];
            out_ep_cntr++;
            /**
             * @todo NGS: Add direction to EP, based on contents
             * of HWCFG1.  Need a copy of HWCFG1 in pcd structure?
             * sprintf(";r
             */
            dwc2_pcd_init_ep(pcd, ep, 0 /* OUT */ , i);
        }
        hwcfg1 >>= 2;
    }

    pcd->ep0state = EP0_DISCONNECT;
    pcd->ep0.dwc2_ep.maxpacket = CONTROL_64;
    pcd->ep0.dwc2_ep.type = 0;
}

/**
 * This function initialized the PCD portion of the driver.
 *
 */
dwc2_pcd_t *dwc2_pcd_init(dwc2_core_if_t * core_if)
{
    dwc2_pcd_t *pcd = (dwc2_pcd_t *)&g_dwc2_dev.g_dwc2_pcd_t;
    int i;
    uint8_t* pt_dwc_otg_pcd_t = (uint8_t*)&g_dwc2_dev.g_dwc2_pcd_t;
    for(i = 0;i<sizeof(dwc2_pcd_t);i++)
    {
       pt_dwc_otg_pcd_t[i] = 0;
    }

    pcd->core_if = core_if;

    pcd->setup_pkt = g_dwc2_dev.g_u_setup_pkt;
    pcd->status_buf = &g_dwc2_dev.g_status_buf;
    dwc_otg_pcd_reinit(pcd);

    return pcd;


}


int dwc2_driver_probe(void)
{
	uint32_t *ptbase = (uint32_t *)ZX_USB_BASE;   //??ַַ
	
	xlog_usb("xsh %s, %p\n", __FUNCTION__, ptbase);
	
	g_dwc2_dev.dwc2_dev_t.core_if = dwc2_cil_init(ptbase);

	/*
	* Initialize the DWC_otg core.
	*/
	dwc2_core_init(g_dwc2_dev.dwc2_dev_t.core_if);

	/*
	* Initialize the PCD,pcd_initժ
	*/
	g_dwc2_dev.dwc2_dev_t.pcd = dwc2_pcd_init(g_dwc2_dev.dwc2_dev_t.core_if);
	g_dwc2_dev.dwc2_dev_t.pcd->otg_dev = (&g_dwc2_dev.dwc2_dev_t);

	DWC_MODIFY_REG32(&g_dwc2_dev.dwc2_dev_t.core_if->core_global_regs->gahbcfg, 0, 1);
	xlog_usb("xsh %s exit\n", __FUNCTION__);
	return 0;
}


void Out_callback(int dwPara, int dwCause, int dwDone, int dwLen)
{
	*((int *)dwPara) = dwDone;
	g_dwc2_dev.dwRxQuit	= 1;
}

void In_callback( int dwPara, int dwCause, int dwDone, int dwLen)
{
	*((int *)dwPara) = dwDone;
	g_dwc2_dev.dwTxQuit	= 1;
}

int USB_RecvOutData(int dwEPNo, char *pchBuf, int dwLen, F_USB_CB fnUsbCb, void *pPara)
{
	dwc2_pcd_ep_t *ep = NULL;
	ep = &(g_dwc2_dev.dwc2_dev_t.pcd->out_ep[dwEPNo-1]);
	ep->dwc2_ep.is_in = 0;
	ep->dwc2_ep.num = dwEPNo;
	ep->dwc2_ep.data_pid_start = 0;
	ep->dwc2_ep.tx_fifo_num = dwEPNo;
	ep->dwc2_ep.start_xfer_buff = pchBuf;
	ep->dwc2_ep.xfer_buff = pchBuf;
	ep->dwc2_ep.xfer_len = 0;
	ep->dwc2_ep.xfer_count = 0;
	ep->dwc2_ep.fnUsbCb = fnUsbCb;
	ep->dwc2_ep.pPara = pPara;
	ep->dwc2_ep.total_len = dwLen;
	dwc2_ep_start_transfer(g_dwc2_dev.dwc2_dev_t.core_if,&ep->dwc2_ep);
	return 0;
}

int USB_SendInData(int dwEPNo, char *pchBuf, int dwLen, F_USB_CB fnUsbCb, void *pPara)
{
	dwc2_pcd_ep_t *ep = NULL;
	ep = &(g_dwc2_dev.dwc2_dev_t.pcd->in_ep[dwEPNo-1]);
	ep->dwc2_ep.is_in = 1;
	ep->dwc2_ep.num = dwEPNo;
	ep->dwc2_ep.data_pid_start = 0;
	ep->dwc2_ep.tx_fifo_num = dwEPNo;
	ep->dwc2_ep.start_xfer_buff = pchBuf;
	ep->dwc2_ep.xfer_buff = pchBuf;
	ep->dwc2_ep.fnUsbCb = fnUsbCb;
	ep->dwc2_ep.pPara = pPara;
	ep->dwc2_ep.xfer_len = 0;
	ep->dwc2_ep.xfer_count = 0;
	ep->dwc2_ep.total_len = dwLen;
	if( ep->dwc2_ep.total_len %512 ==0&&ep->dwc2_ep.total_len!=0)
	{
		ep->dwc2_ep.sent_zlp = 1;
	}
	dwc2_ep_start_transfer(g_dwc2_dev.dwc2_dev_t.core_if,&ep->dwc2_ep);
	return 0;
}


void USB_POLL_Isr(void)
{
	dwc2_pcd_handle_intr(g_dwc2_dev.dwc2_dev_t.pcd);		
}

extern void usbPoll_reInit(void);
extern int32_t reset_suspend;
void usb_poll_suspend_check(void)
{
	xlog_usb("%s sus=%d\n", __func__, reset_suspend);
	//xsh~ if (1 == reset_suspend && 1 == g_dwc2_dev.dwc2_dev_t.pcd->request_config)
	if (reset_suspend == 1)
	{
		reset_suspend = 0;
		memset(&g_dwc2_dev, 0, sizeof (g_dwc2_dev));
		usbPoll_reInit();
	}
}
int USB_POLL_Read(char *pchBuf, int dwLen)
{
	int dwDone;

	usb_poll_suspend_check();

	g_dwc2_dev.dwRxQuit=0;	
	USB_RecvOutData( 1,(BYTE *)pchBuf,dwLen,Out_callback,(void *)&dwDone);
	xlog_usb("READ%d\n", dwLen);
	while(!g_dwc2_dev.dwRxQuit)
	{
		dwc2_pcd_handle_intr(g_dwc2_dev.dwc2_dev_t.pcd);	
		if (reset_suspend == 1){
			g_dwc2_dev.dwRxQuit = 1;
			return -1;
		}
	}

	return dwDone;
}

int USB_POLL_Write(char *pchBuf, int dwLen)
{
	int dwDone;

	if (reset_suspend == 1){
		return -1;
	}
	
	g_dwc2_dev.dwTxQuit=0;

	USB_SendInData(1,pchBuf, dwLen, In_callback,(void *)&dwDone);
	xlog_usb("WRITE%d\n", dwLen);

	while(!g_dwc2_dev.dwTxQuit)
	{
		dwc2_pcd_handle_intr(g_dwc2_dev.dwc2_dev_t.pcd);		
	}

	return dwDone;
}


int USB_POLL_Enum(void)
{
	g_dwc2_dev.g_Connet = 0;

	dwc2_driver_probe();
	while(1)
	{
 		dwc2_pcd_handle_intr(g_dwc2_dev.dwc2_dev_t.pcd);
		if (g_dwc2_dev.dwc2_dev_t.pcd->request_config == 1)
			break;
	}	
	return 1;
}


