/*******************************************************************************
 * Copyright (C) 2007, sanchips Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        weizhgiang
 * Date:          2010-5-18
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _USBPOLL_DRV_H
#define _USBPOLL_DRV_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
//#include "drvs_bits.h"
#include "oss_pub.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/

// dwSignalWr, dwSignalRd״̬ת
#define 	RW_CAN_NOT_START	(0x0)	//д
#define 	RW_CAN_START		(0x1)	//дδ
#define 	RW_START			(0x2)	//дڽ
#define	RW_FINISH			(0x3)	//д


// bmRequestType
#define HOST_TO_DEVICE				(0x0)
#define DEVICE_TO_HOST				(bit01 <<7)

#define COMMAND_MASK				(bit02 <<5)
#define COMMAND_STANDARD			(0x0   <<5)
#define COMMAND_CLASS				(0x1   <<5)
#define COMMAND_VENDOR			(0x2   <<5)
#define COMMAND_RESERVED			(0x3   <<5)

#define COMMAND_RECIPIENT_MASK		(bit05 <<0)
#define COMMAND_RECIPIENT_DEVICE		(0 <<0)
#define COMMAND_RECIPIENT_INTERFACE	(1 <<0)
#define COMMAND_RECIPIENT_ENDPOINT	(2 <<0)
#define COMMAND_RECIPIENT_OTHER		(3 <<0)


// T_STRING_DESCRIPTOR
#define MAX_STRING_LENGTH					(0x100)


// bEndpointAddress
#define	EP_ADDRESS_MASK				(bit04 <<0)


// GET_STATUS
#define STATUS_SELF_POWERED					(bit01 <<0)
#define STATUS_REMOTE_WAKEUP_ENABLED		(bit01 <<1)
#define STATUS_HALT								(bit01 <<0)

// CLEAR_FEATURE, SET_FEATURE
#define FEATURE_DEVICE_REMOTE_WAKEUP		(0x1)
#define FEATURE_ENDPOINT_HALT					(0x0)
#define FEATURE_TEST_MODE						(0x2)


// GET_DESCRIPTOR
#define	DESCRIPTOR_TYPE_MASK					(bit08 <<8)
#define	DESCRIPTOR_INDEX_MASK				(bit08 <<0)






/****************************************************************************
* 	                                        Types
****************************************************************************/

typedef struct
{
    UINT32 opFlag;        //ɱ־
    UINT32 length;        //ʵʶдĳ
}T_USB_RW_FLAG;


// USB豸
typedef struct
{
    UINT8 		bmRequestType;
    UINT8 		bRequest;
    UINT16 	wValue;
    UINT16 	wIndex;
    UINT16 	wLength;
}
T_COMMAND;


typedef struct
{
	UINT8	byUSB;
	UINT8	byTx;
	UINT8	byRx;

	UINT32	dwUSBState;
	UINT32 	dwChangeAddr;
	UINT32	dwEP0_State;

	UINT8		byCSR0L;
	T_COMMAND	tCmd;
}TIRQLog;


// ׼
typedef enum
{
    GET_STATUS          		=0x0,
    CLEAR_FEATURE       	=0x1,
    SET_FEATURE        		=0x3,
    SET_ADDRESS         	=0x5,
    GET_DESCRIPTOR      	=0x6,
    SET_DESCRIPTOR      	=0x7,
    GET_CONFIGURATION   =0x8,
    SET_CONFIGURATION   	=0x9,
    GET_INTERFACE       	=0xa,
    SET_INTERFACE       	=0xb,
    SYNCH_FRAME         	=0xc
}T_STANDARD_REQUST;



// USBֵ֧
typedef enum
{
    DEVICE_REMOTE_WAKEUP	=1,		// Device
    ENDPOINT_HALT 			=0, 		// Endpoint
    TEST_MODE 				=2		//Device
}T_FEATURE;




// 豸
#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8    	bLength;
    UINT8    	bDescriptorType;
    UINT16	bcdUSB;
    UINT8    	bDeviceClass;
    UINT8    	bDeviceSubClass;
    UINT8   	bDeviceProtocol;
    UINT8    	bMaxPacketSize0;
    UINT16 	idVendor;
    UINT16 	idProduct;
    UINT16 	bcdDevice;
    UINT8 		iManufacturer;
    UINT8    	iProduct;
    UINT8    	iSerialNumber;
    UINT8    	bNumConfigurations;
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_DEVICE_DESCRIPTOR;

// ׼
#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8 	bLength;
    UINT8 	bDescriptorType;
    UINT16 wTotalLength;
    UINT8 	bNumInterfaces;
    UINT8 	bConfigurationValue;
    UINT8 	iConfiguration;
    UINT8 	bmAttributes;
    UINT8 	bMaxPower;
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_CONFIG_DESCRIPTOR;

#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8 	bLength;
    UINT8 	bDescriptorType;
    char    Prod_Desc[98];
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_PRODUCT_DESCRIPTOR;


// ׼ӿ
#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8 	bLength;
    UINT8 	bDescriptorType;
    UINT8 	bInterfaceNumber;
    UINT8 	bAlternateSetting;
    UINT8 	bNumEndpoints;
    UINT8 	bInterfaceClass;
    UINT8 	bInterfaceSubClass;
    UINT8 	bInterfaceProtocol;
    UINT8 	iInterface;
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_INTERFACE_DESCRIPTOR;


// ׼˵
#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8 		bLength;
    UINT8 		bDescriptorType;
    UINT8 		bEndpointAddress;
    UINT8 		bmAttributes;
    UINT16	wMaxPacketSize;
    UINT8 		bInterval;
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_EP_DESCRIPTOR;


// ַ
#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8		bLength;
    UINT8 		bDescriptorType;
    UINT16	wLANGID0;
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_LANGID_DESCRIPTOR;

#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
    UINT8	bLength;
    UINT8 	bDescriptorType;
    UINT8	bString[MAX_STRING_LENGTH];

}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
T_STRING_DESCRIPTOR;

#ifdef __ARMCC_VERSION /*rvct*/
__packed
#endif 
  typedef struct
{
  T_CONFIG_DESCRIPTOR		       tConfig;
  T_INTERFACE_DESCRIPTOR	       tInterface;
  T_EP_DESCRIPTOR				atTxEP[1];	//Ͷ˵(ep0)
  T_EP_DESCRIPTOR				atRxEP[1];	//ն˵(ep0)
  T_INTERFACE_DESCRIPTOR	    	tInterface1;
  T_EP_DESCRIPTOR				atTxEP1[1];	//Ͷ˵(ep0)
  T_EP_DESCRIPTOR				atRxEP1[1];	//ն˵(ep0)
}
#ifdef __GNUC__ /* gcc */
__attribute__ ((packed))
#endif
TCONFIG_ALL;




/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
VOID hal_usb_isr( VOID);
static VOID ep_rd_callback( UINT32 flagAddr, UINT32 cause,UINT32 actualLength, UINT32 length);
static VOID ep_wr_callback( UINT32 flagAddr, UINT32 cause,UINT32 actualLength, UINT32 length);
SINT32 usb_init(VOID);
BOOL usb_enum(VOID);
SINT32 usb_read(UINT32 *length, UINT8 *pBuffer);
SINT32 usb_write(UINT32 length, UINT8 *pBuffer);
SINT32 hal_usb_init( VOID);
VOID hal_usb_ep_init( VOID);
SINT32 hal_usb_tx_ep_config( UINT32 dwEPNo, UINT32 dwMaxP, UINT32 dwDMAmode,BOOL blAutoSet, BOOL blISO);
SINT32 hal_usb_rx_ep_config( UINT32 dwEPNo, UINT32 dwMaxP, UINT32 dwDMAmode,BOOL dwAutoClear,BOOL blISO);
VOID hal_usb_isr(VOID);
SINT32 hal_usb_isr_ep0(VOID);
SINT32 hal_usb_isr_tx(UINT32 dwEPNo);
SINT32 hal_usb_isr_rx(UINT32 dwEPNo);
SINT32 hal_usb_isr_dma_tx(UINT32 dwChnl, UINT32 dwEPNo);
SINT32 hal_usb_isr_dma_rx(UINT32 dwChnl, UINT32 dwEPNo);
SINT32 hal_usb_end_transfer(UINT32 dwCause, UINT32 dwAll);
SINT32 hal_usb_ep_end(UINT32 dwEPNo, UINT32 dwTx, UINT32 dwCause);
SINT32 hal_usb_ep0_request(VOID);
SINT32 hal_usb_ep0_flag(UINT8 byFlag);
SINT32 hal_usb_ep_flush(UINT32 dwEPNo, UINT32 dwTx);
SINT32 hal_usb_ep_write(UINT32 dwEPNo, UINT8 *pchBuf, UINT32 dwLen, Callback fnCallback, VOID *pPara);
SINT32 hal_usb_ep_fifo_wr(UINT32 dwEPNo);
SINT32 hal_usb_ep_read(UINT32 dwEPNo, UINT8 *pchBuf, UINT32 dwLen, Callback fnCallback, VOID *pPara);
SINT32 hal_usb_ep_fifo_rd(UINT32 dwEPNo);
SINT32 hal_usb_ep_dma0_rd(UINT32 dwEPNo);
SINT32 hal_usb_ep_dma0_wr(UINT32 dwEPNo);
UINT32 hal_usb_ep_stall( UINT32 dwEPNo, UINT32 dwTx);
SINT32 hal_usb_ep_halt(UINT32 dwEPNo, UINT8 chType);
SINT32 hal_usb_dma_config(UINT32 dwChnl, UINT32 dwAddr, UINT32 dwLen, UINT32 dwCtrl);
VOID hal_usb_soft_connect(VOID);
VOID hal_usb_soft_disconnect(VOID);
VOID usbPoll_Delay_ms(UINT32 ms);
VOID usbPoll_Delay_us(UINT32 us);
#endif/*_USBPOLL_DRV_H*/

