
/*
|| sanchips add: xjy@20150312 for usbconfig-hotplug
*/

#include <linux/device.h>
#include <linux/module.h>
#include <linux/kernel.h>

#include <linux/init.h>

#include <linux/string.h>

#include <linux/sysfs.h>

#include <linux/stat.h>
#include <linux/slab.h>
#include <linux/kobject.h>
#include <linux/android_notify.h>
#include <mach/highspeed_debug.h>
#include <mach/iomap.h>
#include "pub_debug_info.h"


#ifndef CONFIG_SYSTEM_RECOVERY
int zDrvNand_WriteBootflag( int flag );
#endif
extern int detected_charger(void);
int get_usb_enum_mode(void);
#ifdef _USE_VEHICLE_DC
extern int usb_server_init(void);

extern int adb_enable_rpmsg_agent(int flag);
extern int adb_rpmsg_agent_state(void);
int switch_mode = 0;

int simulate_plug = 0;
	struct work_struct switch_usbmode;
	
	struct work_struct force_plug_work;
	
extern int usb_plug_notify_ap(e_usb_rpmsg_cmd_type plug_type);
	struct delayed_work plug_notify_dwork;
	int usb_rpmsg_ser_inited = 0;
	int usb_plugin_msg_sent = 0;
extern void usb_detect_set(int set_cmd);

#endif

static unsigned int charger_plug = 0;
static unsigned int usb_plug = 0;
//static unsigned int sys_id = 1;//0 is windows, other value not windows(mac or linux)
static unsigned int en_mods = 0;//enable mods
//static unsigned int auto_eject_ms = 0;
unsigned int hotplug_flag = 1;
unsigned int usb_printk_en = 1;
EXPORT_SYMBOL_GPL(usb_printk_en);
unsigned int mmc_printk_en = 1;
unsigned int gmac_printk_en = 1;
unsigned int adb_agent_state = 0;

unsigned int force_net = 0;
unsigned int set_panic = 0;
//for auto test,mdl dev with gpio detect usb plug in/out
#ifndef _USE_VEHICLE_DC
unsigned int usb_gpio_detect_enable = 0;
#else
unsigned int usb_gpio_detect_enable = 1;
#endif
//add by gsn, to avoid usb in vincPkt_list backlogged many Skb, set a limit
unsigned int rndis_vplist_max = 800;

static unsigned int ramdump_flag = 0;
#define RNDIS_NUM    4
unsigned int usblan[RNDIS_NUM] = {0,0,0,0};

#define CHARGER_PLUG_NAME	"chargerPlug"
#define USB_PLUG_NAME		"usbPlug"
#define SYS_ID_NAME			"sysId"
#define ENABLE_MODS		"enMods"
#define NET_NAME           "netname"
#define NET0_STATE           "usblan0"
#define NET1_STATE           "usblan1"
#define NET2_STATE           "usblan2"
#define NET3_STATE           "usblan3"
#define HOT_PLUG           "hotplug"
#define USB_PRINTK_EN           "usb"
#define MMC_PRINTK_EN           "mmc"
#define GMAC_PRINTK_EN           "gmac"

#define FORCE_NET          "forcenet"
#define SET_PANIC			"set_panic"
#define RAMDUMP_FLAG		"ramdumpFlag"
#define RNDIS_VPLST_MAX     "lstmax"
#define USB_GPIO_DETECT_ENABLE "gpio_detect"
#define USB_ADB_AGENT "adb_agent"

#define USB_LOG_MEM_SIZE	(15*1000)
#define USB_LOG_MAX_SIZE	512

static char	s_usbMemLog[USB_LOG_MEM_SIZE]= {0};
static char	*s_localStringBuf = NULL;
static int		s_usbMemLogIndex=0;
#define SET_ERARLY_SUSPEND_PANIC	     0x00000001
#define SET_BNA_ERR_PANIC			     0x00000002
#define SET_TX_REQ_USEUP_PANIC		     0x00000004
#define SET_RNDIS_RESET_MSG_PANIC		 0x00000008


static struct attribute charger_plug_attr =
{
        .name = "chargerPlug",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute usb_plug_attr =
{
        .name = "usbPlug",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute sys_id_attr =
{
        .name = "sysId",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute en_mods_attr =
{
        .name = "enMods",
        .mode = S_IRUGO|S_IWUSR,
};
static struct attribute ramdump_flag_attr =
{
        .name = "ramdumpFlag",
        .mode = S_IRUGO|S_IWUSR,
};
static struct attribute net_name_attr =
{
        .name = "netname",
        .mode = S_IRUGO|S_IWUSR,
};
static struct attribute net0_state_attr =
{
        .name = "usblan0",
        .mode = S_IRUGO|S_IWUSR,
};
static struct attribute net1_state_attr =
{
        .name = "usblan1",
        .mode = S_IRUGO|S_IWUSR,
};
static struct attribute net2_state_attr =
{
        .name = "usblan2",
        .mode = S_IRUGO|S_IWUSR,
};
static struct attribute net3_state_attr =
{
        .name = "usblan3",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute hotplug_state_attr =
{
        .name = "hotplug",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute force_net_attr =
{
        .name = "forcenet",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute set_panic_attr =
{
        .name = "set_panic",
        .mode = S_IRUGO|S_IWUSR,
};


static struct attribute list_max_attr =
{
		.name = "lstmax",
		.mode = S_IRUGO|S_IWUSR,
};


static struct attribute usb_gpio_detect_enable_attr =
{
		.name = "gpio_detect",
		.mode = S_IRUGO|S_IWUSR,
};


static struct attribute usb_adb_agent_attr =
{
		.name = "adb_agent",
		.mode = S_IRUGO|S_IWUSR,
};
static struct attribute *usb_status_attrs[] =
{
	&charger_plug_attr,
	&usb_plug_attr,
	&sys_id_attr,
	&en_mods_attr,
	&ramdump_flag_attr,
	&net_name_attr,
	&net0_state_attr,
	&net1_state_attr,
	&net2_state_attr,
	&net3_state_attr,
	&hotplug_state_attr,
	&force_net_attr,
	&set_panic_attr,
	&list_max_attr,
	&usb_gpio_detect_enable_attr,
	&usb_adb_agent_attr,
       NULL,
};


static struct attribute usbprintk_state_attr =
{
        .name = "usb",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute mmcprintk_state_attr =
{
        .name = "mmc",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute gmacprintk_state_attr =
{
        .name = "gmac",
        .mode = S_IRUGO|S_IWUSR,
};

static struct attribute *print_status_attrs[] =
{
	&usbprintk_state_attr,
	&mmcprintk_state_attr,
	&gmacprintk_state_attr,
       NULL,
};


/***********************************************

				USB MODS 
				
************************************************/

struct usb_mods{

	/* ̱־ */
	int only_cdrom;

	/* ֶ ־*/
	int is_eject_cdrom; 

	/* Զ ־*/
	int auto_eject_cdrom;
	int start_timer_flag;
	struct timer_list	timer;
	struct work_struct work;

	/* ϵͳʶ־ */
	int sys_id;	//0 is windows, other value not windows(mac or linux)
};

static struct usb_mods mods;
void usb_mods_activate(void);

/* MODSʱһ㷶ΧΪ3~5룬Ϊ3 */
#define USB_MODS_TIMER_EXPIRES 	3000 

void usb_record_dbginfo(usb_dbginfo_type inf_type, int status, int info_value)
{
	char *str_info = NULL;
	switch(inf_type){
		case USB_DEV_PLUGIN:
			str_info = "plugin";
			break;
		case USB_DEV_PLUGOUT:
			str_info = "plugout";
			break;
		case USB_SWITCH_TO_USER:
			str_info = "to user mode";
			break;
		case USB_SWITCH_TO_DEBUG:
			str_info = "to dbg mode";
			break;
		case USB_SWITCH_TO_FACTORY:
			str_info = "to factory mode";
			break;
		case USB_SWITCH_TO_AMT:
			str_info = "to amt mode";
			break;
		case USB_DEV_EXCEPT_RESET:
			str_info = "except reset";
			break;
		case USB_DEV_SUSPEND:
			str_info = "suspend";
			break;
		case USB_DEV_RESUME:
			str_info = "resume";
			break;
		case USB_USB_SUSPEND:
			str_info = " usb suspend";
			break;
		case USB_USB_RESUME:
			str_info = " usb resume";
			break;
		case USB_USB_REMOTE_WAKEUP:
			str_info = " usb rmt wakeup";
			break;
		case USB_USB_RESET:
			str_info = " usb reset";
			break;
		case USB_USB_ENUM_DONE:
			str_info = "usb enum done";
			break;
		case USB_DEV_ENABLE:
			str_info = "enable";
			break;
		case USB_DEV_DISABLE:
			str_info = "disable";
			break;
		case USB_DEV_OPEN:
			str_info = "open";
			break;
		case USB_DEV_CLOSE:
			str_info = "close";
			break;
		case USB_DEV_ONLINE:
			str_info = "online";
			break;
		case USB_DEV_OFFLINE:
			str_info = "offline";
			break;
		case USB_OPEN_DL:
			str_info = "dl open";
			break;
		case USB_CLOSE_DL:
			str_info = "dl close";
			break;
		case USB_SIMULATE_PLUG:
			str_info = "simulate plug";
			break;
			
		default :
			break;
	}
	if(status && info_value){
		sc_debug_info_record(MODULE_ID_AP_USB, "%s,st:%d,v:%d\n", str_info, status, info_value);
		return;
	}
	
	if(status){
		sc_debug_info_record(MODULE_ID_AP_USB, "%s,st:%d\n", str_info, status);
		return;
	}
	
	if(info_value){
		sc_debug_info_record(MODULE_ID_AP_USB, "%s,v:%d\n", str_info, info_value);
		return;
	}
	
	sc_debug_info_record(MODULE_ID_AP_USB, "%s\n", str_info);

}
EXPORT_SYMBOL_GPL(usb_record_dbginfo);


void usb_set_switch_mode(int cur_mode)
{

#ifdef _USE_VEHICLE_DC
	switch (cur_mode){
		case 0:
			switch_mode = USB_SWITCH_DEBUG;
			break;
		case 1:
			switch_mode = USB_SWITCH_USER;
			break;
		case 2:
			switch_mode = USB_SWITCH_FACTORY;
			break;
		case 3:
			switch_mode = USB_SWITCH_AMT;
			break;
		case 4:
			switch_mode = USB_SWITCH_EYE_DIAGRAM;
			break;
		default:
			printk("usb_set_switch_mode, invalid mode type:%d, do nothing\n", cur_mode);
	}
#endif	
}
EXPORT_SYMBOL_GPL(usb_set_switch_mode);

#ifdef _USE_VEHICLE_DC

int usb_cap_force_plug_work(struct work_struct *data)
{
	if(detected_charger()){
		usb_notify_up(USB_DEVICE_PLUGIN, NULL);
		goto  work_end;
	}		
	
	usb_notify_up(USB_DEVICE_PLUGOUT, NULL);
work_end:
	return 0;
}
int usb_switch_mode_work(struct work_struct *data)
{
	if(simulate_plug){
		//we have no simulate signal, using except reset 
		simulate_plug = 0;
		usb_notify_up(USB_DEVICE_EXCEPT_RESET, NULL);
		return;
	}
	if(switch_mode < USB_SWITCH_USER ||  switch_mode > USB_SWITCH_EYE_DIAGRAM){
		printk("usb_switch_mode_work, invalid type:%d\n", switch_mode);
		return -1;
	}
	
	usb_notify_up(switch_mode, NULL);
}
int usb_plug_notify_cap_work(struct work_struct *data)
{	
	int ret = 0;
	printk("----usb_plug_notify_cap_work start\n");
	ret = usb_plug_notify_ap(((usb_plug == 1) ? USB_RPMSG_USB_PLUG_IN : USB_RPMSG_USB_PLUG_OUT));
	if(ret){
		printk("usb_plug_notify_cap_work, notify plug:%d, fail, ret:%d\n", usb_plug, ret);
	}
}
void usb_check_plugin_msg_sent(void)
{
	if(usb_gpio_detect_enable == 0){
		printk("usb_check_plugin_msg_sent, only for usb plug,\n");
		return;
	}
	if(usb_plugin_msg_sent){
		printk("usb_check_plugin_msg_sent, already sent do nothing\n");
		return;
	}
	usb_plugin_msg_sent = 1;
	printk("usb_check_plugin_msg_sent, do send\n");
	schedule_delayed_work(&plug_notify_dwork, 0);	

}
EXPORT_SYMBOL_GPL(usb_check_plugin_msg_sent);
#endif
int usb_do_reject_cdrom(void)
{
	if(mods.only_cdrom){
		USBSTACK_DBG("usb_do_reject_cdrom!!!! ");
		mods.is_eject_cdrom = 1;
	}
    return 1;
}

int usb_is_reject_cdrom(void)
{
	if(mods.is_eject_cdrom){
		USBSTACK_DBG("usb_is_reject_cdrom!!!! ");
		usb_notify_up(USB_CDROM_OBJECT, NULL);
		return 1;
	}

	usb_mods_activate();
	return 0;
}
void usb_set_sys_id(int sysId)
{
	if(sysId){
		if(mods.sys_id != sysId)
			USBSTACK_DBG("sys is mac or linux");
	}else{
		if(mods.sys_id != sysId)
			USBSTACK_DBG("sys is windows");
	}
	mods.sys_id = sysId;
}

void usb_set_ms_auto_reject(int flag)
{
	if(mods.auto_eject_cdrom == flag)
	{
		//USBSTACK_DBG("already set, set mods-eject-cdrom flag: %d", flag);
		return;
	}

	if(en_mods){
		USBSTACK_DBG("mods enable, set mods-eject-cdrom flag: %d", flag);
		mods.auto_eject_cdrom = flag;
	}else{
		USBSTACK_DBG("mods disable, set mods-eject-cdrom flag: 0");
		mods.auto_eject_cdrom = 0;
	}
}
//EXPORT_SYMBOL_GPL(usb_set_ms_auto_eject);


int usb_get_ms_auto_reject(void)
{
	if(en_mods)
		return mods.auto_eject_cdrom;
	else
		return 0;
}
//EXPORT_SYMBOL_GPL(usb_get_ms_auto_reject);


void usb_mods_activate(void)
{
	unsigned long expire;
	
	if(mods.auto_eject_cdrom){
		//mods.beginTime = jiffies;
		if(mods.start_timer_flag == 0){
			expire = msecs_to_jiffies(USB_MODS_TIMER_EXPIRES) + jiffies;
			mods.start_timer_flag = 1;
			mod_timer(&mods.timer, expire);
			USBSTACK_DBG("mods timer start");
		}
	}
}

void usb_mods_deactive(void)
{	
	mods.start_timer_flag = 0;
	del_timer_sync(&mods.timer);
}
		
void usb_mods_timer_callback(unsigned long data)
{
	USBSTACK_DBG("usb mods timer");
	schedule_work(&mods.work);
		}	
static void usb_mods_work(struct work_struct *data)
{
	USBSTACK_DBG("usb mods work");
	if(usb_plug)
		usb_notify_up(USB_CDROM_OBJECT, NULL);
	}

void usb_mods_init(void)
{
	USBSTACK_DBG("usb_mods_init");
	mods.only_cdrom = 1;
	mods.auto_eject_cdrom =en_mods;
	mods.sys_id = 1;
	mods.start_timer_flag = 0;
	setup_timer(&mods.timer, usb_mods_timer_callback, (unsigned long)(&mods));
	INIT_WORK(&mods.work, usb_mods_work);
}


void usb_mods_exit(void)
{
	USBSTACK_DBG("usb_mods_exit");
	usb_mods_deactive();
	//flush_work_sync(&mods.work);
	mods.only_cdrom =0;
	mods.auto_eject_cdrom =0;
	mods.is_eject_cdrom = 0;
}

/************usb  mods end ****************************/
unsigned int get_panic_flag(void)
{
	return set_panic;
}

EXPORT_SYMBOL_GPL(get_panic_flag);

unsigned int get_usb_gpio_detect_flag(void)
{
	return usb_gpio_detect_enable;
}

EXPORT_SYMBOL_GPL(get_usb_gpio_detect_flag);


int usb_get_rndis_list_max_flag(void)
{
	return rndis_vplist_max;
}
EXPORT_SYMBOL_GPL(usb_get_rndis_list_max_flag);


static void usb_ramdump_config(void)
{
	usb_notify_up(USB_RAMDUMP_TRIGGER, NULL);	
}

ssize_t kobj_usb_show(struct kobject *kobject,struct attribute *attr,char *buf)
{
	int dc=0;

	  if(!strcmp(attr->name, CHARGER_PLUG_NAME)){
	  		sprintf(buf, "%d\n",charger_plug );
	  }else if(!strcmp(attr->name, USB_PLUG_NAME)){
	  		dc = detected_charger();
	  	  	USBSTACK_DBG("detected charger=%d",dc);
			if(dc == 1)
	              	usb_plug = 1;
	  		sprintf(buf, "%d\n",usb_plug );
	  }else if(!strcmp(attr->name, SYS_ID_NAME)){
	  		sprintf(buf, "%d\n",mods.sys_id );
	  }else if(!strcmp(attr->name, ENABLE_MODS)){
	  		sprintf(buf, "%d\n",en_mods );
	  }else if(!strcmp(attr->name, RAMDUMP_FLAG)){
	  		sprintf(buf, "%d\n",ramdump_flag);
	  }else if(!strcmp(attr->name, NET_NAME)){
	  		sprintf(buf,"%s%s%s%s",usblan[0]?"usblan0;":"",usblan[1]?"usblan1;":"",usblan[2]?"usblan2;":"",usblan[3]?"usblan3;":"");
	  }else if(!strcmp(attr->name, NET0_STATE)){
	  		sprintf(buf, "%d",usblan[0]);
	  }else if(!strcmp(attr->name, NET1_STATE)){
	  		sprintf(buf, "%d",usblan[1]);
	  }else if(!strcmp(attr->name, NET2_STATE)){
	  		sprintf(buf, "%d",usblan[2]);
	  }else if(!strcmp(attr->name, NET3_STATE)){
	  		sprintf(buf, "%d",usblan[3]);
	  }else if(!strcmp(attr->name, HOT_PLUG)){
	  		sprintf(buf, "%d",hotplug_flag);
	  }else if(!strcmp(attr->name, USB_PRINTK_EN)){
	  		sprintf(buf, "%d",usb_printk_en);
	  }else if(!strcmp(attr->name, FORCE_NET)){
	  		sprintf(buf, "%d",force_net);
	  }else if(!strcmp(attr->name, SET_PANIC)){
	  		sprintf(buf, "%u",set_panic);
	  }else if(!strcmp(attr->name, RNDIS_VPLST_MAX)){
	  		 sprintf(buf, "%u",rndis_vplist_max);
	  } else if(!strcmp(attr->name, USB_GPIO_DETECT_ENABLE)){
	  		 sprintf(buf, "%u",usb_gpio_detect_enable);
	  }else if(!strcmp(attr->name, USB_ADB_AGENT)){
#ifdef _USE_VEHICLE_DC
			  adb_agent_state = adb_rpmsg_agent_state();
	  		 sprintf(buf, "%u, %s\n",adb_agent_state,( (adb_agent_state == 0) ? "AP" : "CAP"));
#endif			 
	  } 	  

      return strlen(buf);
}

//void usbPoll_test(void);
ssize_t kobj_usb_store(struct kobject *kobject,struct attribute *attr, const char *buf,size_t size)
{
	unsigned int value = 0;
	int cur_usbmode = 0;
	
	value = simple_strtoul(buf, NULL, 10);
	if(!strcmp(attr->name,CHARGER_PLUG_NAME)){
		charger_plug = value;
	}else if(!strcmp(attr->name,USB_PLUG_NAME)){
		//usbPoll_test();
		usb_plug = value;
	}else if(!strcmp(attr->name,SYS_ID_NAME)){
		usb_set_sys_id(value);
	}else if(!strcmp(attr->name,ENABLE_MODS)){
		en_mods =value;
	}else if(!strcmp(attr->name,RAMDUMP_FLAG)){
		ramdump_flag =value;
		if(ramdump_flag)
			usb_ramdump_config();
	}else if(!strcmp(attr->name,NET0_STATE)){
		usblan[0] =value;
	}
	else if(!strcmp(attr->name,NET1_STATE)){
		usblan[1] =value;
	}else if(!strcmp(attr->name,NET2_STATE)){
		usblan[2] =value;
	}else if(!strcmp(attr->name,NET3_STATE)){
		usblan[3] =value;
	}else if(!strcmp(attr->name,HOT_PLUG)){
		hotplug_flag =value;
	}else if(!strcmp(attr->name,USB_PRINTK_EN)){
		usb_printk_en =value;
	}else if(!strcmp(attr->name,FORCE_NET)){
		force_net =value;	
	}else if(!strcmp(attr->name,SET_PANIC)){
		set_panic =value;
	}else if(!strcmp(attr->name,RNDIS_VPLST_MAX)){
		rndis_vplist_max =value;
	}else if(!strcmp(attr->name,USB_GPIO_DETECT_ENABLE)){
		usb_gpio_detect_enable =value;
	}else if(!strcmp(attr->name,USB_ADB_AGENT)){
#ifdef _USE_VEHICLE_DC
		cur_usbmode = get_usb_enum_mode();
		adb_agent_state =value;
		//if(cur_usbmode == 0){
			adb_enable_rpmsg_agent(adb_agent_state);
			
		//}else{
			//printk("---none adb, switch is forbidern\n");
			printk("---cur_usbmode:%d, adb_agent_state:%d\n",  cur_usbmode, adb_agent_state);
		//}
#endif
	  }	
	
	return size;
}

static struct sysfs_ops obj_usb_sysops =
{
        .show = kobj_usb_show,
        .store = kobj_usb_store,        
};

void obj_usb_release(struct kobject *kobject)
{
	usb_printk("[kobj_test: release!]\n");
}
static struct kobj_type ktype =

{       .release = obj_usb_release,
        .sysfs_ops = &obj_usb_sysops,
        .default_attrs = usb_status_attrs,
};

ssize_t kobj_print_show(struct kobject *kobject,struct attribute *attr,char *buf)
{
	  if(!strcmp(attr->name, USB_PRINTK_EN)){
	  		sprintf(buf, "%d",usb_printk_en);
	  }else if(!strcmp(attr->name, MMC_PRINTK_EN)){
	  		sprintf(buf, "%d",mmc_printk_en);
	  }else if(!strcmp(attr->name, GMAC_PRINTK_EN)){
	  		sprintf(buf, "%d",gmac_printk_en);
	  }

      return strlen(buf);
}

//void usbPoll_test(void);
ssize_t kobj_print_store(struct kobject *kobject,struct attribute *attr, const char *buf,size_t size)
{
	unsigned int value = 0;
	
	value = simple_strtoul(buf, NULL, 4);
	if(!strcmp(attr->name,USB_PRINTK_EN)){
		usb_printk_en =value;
	}else if(!strcmp(attr->name,MMC_PRINTK_EN)){
		mmc_printk_en =value;
	}else if(!strcmp(attr->name,GMAC_PRINTK_EN)){
		gmac_printk_en =value;
	}
	
	return size;
}

static struct sysfs_ops obj_print_sysops =
{
        .show = kobj_print_show,
        .store = kobj_print_store,        
};
static struct kobj_type kprinttype =

{       .release = obj_usb_release,
        .sysfs_ops = &obj_print_sysops,
        .default_attrs = print_status_attrs,
};

static int kset_filter(struct kset *kset,struct kobject *kobj)
{
//    int ret=0;
//    struct kobj_type *ktype = get_ktype(kobj); /* õ */
//    ret = (ktype == &ktype_part);
   usb_printk("Filter: kobj %s.\n",kobj->name);
     return 1;
}

static const char *kset_name(struct kset *kset,struct kobject *kobj)
{    
    static char buf[20];

/*    struct device *dev = to_dev(kobj);
   if(dev->bus)
        return dev->bus->name;
    else if(dev->class)
        return dev->class->name;
    else
*/    {
       usb_printk("Name kobj %s.\n",kobj->name);
       sprintf(buf,"%s","dwc_usb");
   }
       return buf;
}

static int kset_uevent(struct kset *kset,struct kobject *kobj, struct kobj_uevent_env *env)
{
   int i = 0;
    usb_printk("uevent: kobj %s.\n",kobj->name);

   while(i < env->envp_idx)
    {
        usb_printk("%s.\n",env->envp[i]);
       i ++;
    }

    return 0;
}

static struct kset_uevent_ops uevent_ops =
{
    .filter = kset_filter,
    .name = kset_name,
    .uevent = kset_uevent,
};

struct kset *kset_p;
struct kset *kset_usb;
//struct kset kset_c;
struct kobject *usbkobj = NULL;
struct kobject *printkobj = NULL;
static int __init kset_usb_init(void)
{
  int ret = 0;

   usb_printk("kset test init!\n");
   
   /* ע kset_p */
   kset_usb = kset_create_and_add("dwc_usb", &uevent_ops, NULL);    
    
  // kobject_set_name(&kset_c.kobj,"kset_c");
 //  kset_c.kobj.kset = kset_p;    /*  kset_c  kset_p */

    /* ڽ°汾ںˣע kset ֮ǰҪ 
        *  kset.kobj  ktype Աע᲻ɹ */
  // kset_c.kobj.ktype = &ktype;
   //ret = kset_register(&kset_c);

  // if(ret)
   //     kset_unregister(kset_p);
   usbkobj = kzalloc(sizeof(*usbkobj),GFP_KERNEL);
   if(!usbkobj){
   		usb_printk(KERN_WARNING "mallock usbkobj failed \n");
		return 0;
   }
   kobject_init(usbkobj, &ktype);
   kobject_add(usbkobj,&kset_usb->kobj,"%s","usbconfig");
   usbkobj->kset = kset_usb;

    kset_p = kset_create_and_add("highspeed_print_en", &uevent_ops, NULL);    
	
     printkobj = kzalloc(sizeof(*printkobj),GFP_KERNEL);
   if(!printkobj){
   		usb_printk(KERN_WARNING "mallock printkobj failed \n");
		return 0;
   }
   kobject_init(printkobj, &kprinttype);
   kobject_add(printkobj,&kset_p->kobj,"%s","printconfig");
   printkobj->kset = kset_p;

  // usbkobj = kobject_create_and_add("usbconfig", &kset_p->kobj);
  // usbkobj->kset = kset_p;
   //usbkobj->ktype = &ktype;
#ifdef _USE_VEHICLE_DC   
    usb_server_init();
	
   INIT_WORK(&switch_usbmode, usb_switch_mode_work);  
		
   INIT_WORK(&force_plug_work, usb_cap_force_plug_work); 
	INIT_DELAYED_WORK(&plug_notify_dwork, usb_plug_notify_cap_work);
	usb_rpmsg_ser_inited = 1;		
#endif
   return ret;
}


static void __exit kset_usb_exit(void)
{
   usb_printk("kset test exit!\n");
   
  // kset_unregister(&kset_c);
   kset_unregister(kset_usb);
   kset_unregister(kset_p);
}


void usb_notify_up(usb_notify_event notify_type, void* puf)
{
	unsigned char buf[100];
	int rtv = -1;
	enum kobject_action action =KOBJ_MAX;
	char*envp_ext[] = {NULL,NULL};
	strcpy(buf, "cdrom-object");
	switch(notify_type){
		case USB_CDROM_OBJECT:
			usb_printk("usb cdrom object \n");
			USBSTACK_DBG("@CDROM REJECT");
			strcpy(buf,"USBEVENT=usb_switch");
			action = KOBJ_CHANGE;
			break;

		case USB_DEVICE_PLUGIN:
			usb_printk("usb device plugin \n");
			USBSTACK_DBG("@USB DEV PLUG IN");
			strcpy(buf,"USBEVENT=usb_device_in");
			action = KOBJ_ADD;
			usb_plug = 1;
#ifdef _USE_VEHICLE_DC
			if(usb_rpmsg_ser_inited){
				if(usb_plug_notify_ap(USB_RPMSG_USB_PLUG_IN)){
					//delay 1 second
					//schedule_delayed_work(&plug_notify_dwork, 200);	
					printk("plugin msg send fail\n");
				}
				
			}
#endif
			usb_record_dbginfo(USB_DEV_PLUGIN, 0, 0);
			break;

		case USB_DEVICE_PLUGOUT:
			usb_printk("usb device plugout \n");
			USBSTACK_DBG("@USB DEV PLUG OUT");
			strcpy(buf,"USBEVENT=usb_device_out");
			action = KOBJ_REMOVE;
			usb_plug = 0;
#ifdef _USE_VEHICLE_DC
			if(usb_plug_notify_ap(USB_RPMSG_USB_PLUG_OUT)){
				//delay 1 second
				//schedule_delayed_work(&plug_notify_dwork, 200);
			}
#endif
			usb_record_dbginfo(USB_DEV_PLUGOUT, 0, 0);
			break;
		case USB_CHARGER_PLUGIN:
			usb_printk("usb charger plugin \n");
			USBSTACK_DBG("@USB CHARGER PLUG IN");
			strcpy(buf,"USBEVENT=usb_charger_in");
			action = KOBJ_ADD;
			charger_plug = 1;
			break;

		case USB_CHARGER_PLUGOUT:
			usb_printk("usb charge plugout \n");
			USBSTACK_DBG("@USB CHARGER PLUG OUT");
			strcpy(buf,"USBEVENT=usb_charger_out");
			action = KOBJ_REMOVE;
			charger_plug = 0;
			break;
		case USB_RAMDUMP_TRIGGER:
			usb_printk("usb ramdump trigger \n");
			USBSTACK_DBG("@USB RAMDUMP TRIGGERT");
			 strcpy(buf,"USBEVENT=usb_ramdump");
			 action = KOBJ_CHANGE;
             break;
		case USB_SWITCH_USER:
			usb_printk("usb switch to user mode \n");
			USBSTACK_DBG("@USB SWITCH USER");
			strcpy(buf,"USBEVENT=usb_user");
			action = KOBJ_CHANGE;
			break;

		case USB_SWITCH_DEBUG:
			usb_printk("usb switch to debug mode \n");
			USBSTACK_DBG("@USB SWITCH DEBUG");
			strcpy(buf,"USBEVENT=usb_debug");
			action = KOBJ_CHANGE;
			break;

		case USB_SWITCH_FACTORY:
			usb_printk("usb switch to factory mode \n");
			USBSTACK_DBG("@USB SWITCH FACTORY");
			strcpy(buf,"USBEVENT=usb_factory");
			action = KOBJ_CHANGE;
			break;

		case USB_SWITCH_AMT:
			usb_printk("usb switch to amt mode \n");
			USBSTACK_DBG("@USB SWITCH AMT");
			strcpy(buf,"USBEVENT=usb_amt");
			action = KOBJ_CHANGE;
			break;

		case USB_SWITCH_EYE_DIAGRAM:
			usb_printk("usb switch to EYE_DIAGRAM mode \n");
			USBSTACK_DBG("@USB SWITCH EYE_DIAGRAM");
			strcpy(buf,"USBEVENT=usb_eye_diagram");
			action = KOBJ_CHANGE;
			break;

		case USB_DEVICE_EXCEPT_RESET:
			usb_printk("usb catch except reset \n");
			USBSTACK_DBG("@USB EXCEPT RESET");
			strcpy(buf,"USBEVENT=usb_except_reset");
			action = KOBJ_CHANGE;
			break;
			 
		default:
			usb_printk(KERN_WARNING "UNKWON USB EVENT \n");
			break;
	}
    envp_ext[0] = buf;
	if(usbkobj && hotplug_flag){
		rtv = kobject_uevent_env(usbkobj, action,envp_ext);
	}
	usb_printk(KERN_WARNING "rtv:%d \n",rtv);
}
EXPORT_SYMBOL_GPL(usb_notify_up);



void usb_dbg_printf(const char *fmt,...)
{
    va_list args;
    int stringCnt = 0;

    if ((USB_LOG_MAX_SIZE +s_usbMemLogIndex)>=USB_LOG_MEM_SIZE)
    {
        s_usbMemLogIndex=0;
    }
	
    s_localStringBuf = &s_usbMemLog[s_usbMemLogIndex];


    va_start(args, fmt);
    stringCnt+=vsprintf((char *)s_localStringBuf, fmt, args);
    va_end(args);
	
    s_usbMemLogIndex+=stringCnt;
}
EXPORT_SYMBOL_GPL(usb_dbg_printf);

void usb_dbg_showLog(void)
{
	int SingleStrLen=0;
	char logBuf[USB_LOG_MAX_SIZE+1]={0};
	char *pStart=s_usbMemLog;
	char *pEnd=NULL;

	logBuf[USB_LOG_MAX_SIZE] = '\n';

	pEnd = (char *)strchr((const char *)pStart, '\n');
	while((pEnd < (&s_usbMemLog[USB_LOG_MEM_SIZE]))&&(pEnd >=pStart))
	{
		SingleStrLen= pEnd-pStart;	
		memcpy(logBuf,pStart,SingleStrLen);
		printk("%s\n", logBuf);	
		
		do{
			pStart=pEnd?(pEnd+1):(pStart+1);
			memset(logBuf,0,USB_LOG_MAX_SIZE);
			pEnd = (char *)strchr((const char *)pStart, '\n');
		}while(!pEnd);
	}

}
EXPORT_SYMBOL_GPL(usb_dbg_showLog);

#ifdef _USE_VEHICLE_DC
int usb_get_adb_agent(void)
{
	return adb_agent_state;
}
EXPORT_SYMBOL_GPL(usb_get_adb_agent);


void usb_set_rpmsg_resp(int type, char*resp)
{

	usb_rpmsg_cmd *t_resp = (usb_rpmsg_cmd *)resp;
	
	switch(type){
		case USB_RPMSG_GET_USB_STATE:
			t_resp->cmd = USB_RPMSG_GET_USB_STATE;
			//sprintf(t_resp->param, "%s", );
			
			break;
		case USB_RPMSG_GET_USB_LINK_STATE:
			t_resp->cmd = USB_RPMSG_GET_USB_LINK_STATE;
			//sprintf(t_resp->param, "%s", );
			
			break;
		//case:
		//	break;
		//case:
		//	break;
		default:
			break;
	}
}
EXPORT_SYMBOL_GPL(usb_set_rpmsg_resp);

void usb_parse_cap_notify(int type, int param)
{	
	int cur_usbmode = 0;
	
	if(type >= USB_RPMSG_NOTIFY_MAX){
		printk("usb_parse_cap_notify fail, invalid type:%d\n", type);
		return ;
	}
	
	switch(type){
		case USB_RPMSG_NOTIFY_ADB_TO_AP:			
			adb_agent_state = 0;
			wmb();
			adb_enable_rpmsg_agent(adb_agent_state);
			break;
		case USB_RPMSG_NOTIFY_ADB_TO_CAP:			
			adb_agent_state = 1;
			wmb();
			adb_enable_rpmsg_agent(adb_agent_state);	
			break;
		case USB_RPMSG_SWITCH_DEBUG_MODE:
			if(switch_mode == USB_SWITCH_DEBUG){
				printk("usb_parse_cap_notify, already debug mode, don't change again\n");
				break;
			}
			switch_mode = USB_SWITCH_DEBUG;
			usb_record_dbginfo(USB_SWITCH_TO_DEBUG, 0, 0);
			schedule_work(&switch_usbmode);
			//if boot from user mode, this flag doesn't set
			if(adb_agent_state == 0){
				printk("usb_parse_cap_notify,set debug mode, set adb_agent_state \n");
				adb_agent_state =1;				
			}
			break;
		case USB_RPMSG_SWITCH_USER_MODE:
			if(switch_mode == USB_SWITCH_USER){
				printk("usb_parse_cap_notify, already user mode, don't change again\n");
				break;
			}
			switch_mode = USB_SWITCH_USER;
			usb_record_dbginfo(USB_SWITCH_TO_USER, 0, 0);
			schedule_work(&switch_usbmode);
			
			break;
		case USB_RPMSG_SWITCH_FACTORY_MODE:
			if(switch_mode == USB_SWITCH_FACTORY){
				printk("usb_parse_cap_notify, already factory mode, don't change again\n");
				break;
			}
			switch_mode = USB_SWITCH_FACTORY;
			usb_record_dbginfo(USB_SWITCH_TO_FACTORY, 0, 0);
			schedule_work(&switch_usbmode);
			
			break;
		case USB_RPMSG_SWITCH_AMT_MODE:
			if(switch_mode == USB_SWITCH_AMT){
				printk("usb_parse_cap_notify, already amt mode, don't change again\n");
				break;
			}
			switch_mode = USB_SWITCH_AMT;
			usb_record_dbginfo(USB_SWITCH_TO_AMT, 0, 0);
			schedule_work(&switch_usbmode);
			
			break;
		case USB_RPMSG_SWITCH_EYE_MODE:
			if(switch_mode == USB_SWITCH_EYE_DIAGRAM){
				printk("usb_parse_cap_notify, already eye mode, don't change again\n");
				break;
			}
			switch_mode = USB_SWITCH_EYE_DIAGRAM;
			usb_record_dbginfo(USB_SWITCH_TO_EYE_DIAGRAM, 0, 0);
			schedule_work(&switch_usbmode);
			
			break;

		case USB_RPMSG_FORCE_RNDIS:
		case USB_RPMSG_FORCE_ECM:
			cur_usbmode = get_usb_enum_mode();	
			if(cur_usbmode != 0 && 
				cur_usbmode != 1){
				printk("usb_parse_cap_notify, none net mode, do nothing\n");
				break;
			}
			printk("cur_usbmode: %s\n", ( (cur_usbmode == 0) ?  "debug": "user"));
			if(cur_usbmode == 0){
				switch_mode = USB_SWITCH_DEBUG;
				
			}else if( cur_usbmode == 1){
				switch_mode = USB_SWITCH_USER;
				
			}
			schedule_work(&switch_usbmode);
			break;		
		case USB_RPMSG_OPEN_DL:
			usb_record_dbginfo(USB_OPEN_DL, 0, 0);
#ifndef CONFIG_SYSTEM_RECOVERY
				zDrvNand_WriteBootflag(0);
#endif			
			break;
		case USB_RPMSG_CLOSE_DL:
			usb_record_dbginfo(USB_CLOSE_DL, 0, 0);
#ifndef CONFIG_SYSTEM_RECOVERY
				zDrvNand_WriteBootflag(1);
#endif			
			break;
		case USB_RPMSG_SIMULATE_PLUG:
			if(param != 0){
				/*this is for vehicle   
				 *on usermode,open/close net/adb need to take effect immediately,
				 *so while param not 0, means we need to do this action.
				 * and send netlink change sg to user thread   to reread the nv config
				 * and reenum again
				 */
				cur_usbmode = get_usb_enum_mode();	
				printk("USB_RPMSG_SIMULATE_PLUG, cur_mode:%d\n", cur_usbmode);
				if(cur_usbmode == 1){	
					//only user mode need to do so
					switch_mode = USB_SWITCH_USER;
					schedule_work(&switch_usbmode);
					
				}
				break;
			}else{
				//here just send except to do simulate plug
				simulate_plug = 1;
			}
			usb_record_dbginfo(USB_SIMULATE_PLUG, 0, param);
			schedule_work(&switch_usbmode);
			
			break;
		case USB_RPMSG_FORCE_SLEEP:
			usb_detect_set(0);
			schedule_work(&force_plug_work);
			
			break;
		case USB_RPMSG_FORCE_WAKEUP:
			usb_detect_set(1);
			schedule_work(&force_plug_work);
			break;

		//case :
		//	break;
		default:
			break;
	}
}
EXPORT_SYMBOL_GPL(usb_parse_cap_notify);

#endif


void usb_dbg_ep0reg(void)
{
#if 0
    USBREG_DBG("\n GINTSTS:  0x%08x, GINTMASK: 0x%08x, DCFG:     0x%08x, DCTL:     0x%08x,\n DSTS:     0x%08x, DIEPMSK:  0x%08x, DOEPMSK:  0x%08x, DAINT:     0x%08x,\n DAINTMSK: 0x%08x, DIEPCTL0: 0x%08x, DIEPINT0: 0x%08x, DIEPTSIZE0:0x%08x,\n DIEPDMA0: 0x%08x, DIEPDMB0: 0x%08x, DOEPCTL0: 0x%08x, DOEPINT0: 0x%08x,\n DOEPSIZ0: 0x%08x, DOEPDMA0: 0x%08x, unused:   0x%08x, DOEPDMAB0:0x%08x,", 
    	*(volatile unsigned int *)(ZX_USB_BASE+0x14), //GINTSTS
    	*(volatile unsigned int *)(ZX_USB_BASE+0x18), //GINTMAK
    	*(volatile unsigned int *)(ZX_USB_BASE+0x800), //DCFG
    	*(volatile unsigned int *)(ZX_USB_BASE+0x804), //DCTL  line1 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0x808), //DSTS
    	*(volatile unsigned int *)(ZX_USB_BASE+0x810), //DIEPMSK 
    	*(volatile unsigned int *)(ZX_USB_BASE+0x814), //DOEPMSK
    	*(volatile unsigned int *)(ZX_USB_BASE+0x818), //DAINT   line2 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0x81c), //DAINTMSK
    	*(volatile unsigned int *)(ZX_USB_BASE+0x900), //DIEPCTL0
    	*(volatile unsigned int *)(ZX_USB_BASE+0x908), //DIEPINT0
    	*(volatile unsigned int *)(ZX_USB_BASE+0x910), //DIEPTSIZE0  line3 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0x914), //DIEPDMA0
        *(volatile unsigned int *)(ZX_USB_BASE+0x91C), //DIEPDMB0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB00), //DOEPCTL0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB08), //DOEPINT0   line4 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB10), //DOEPSIZ0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB14), //DOEPDMA0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB18), //unused
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB1C) //DOEPDMAB0  line5 end
    	);
#endif
}
EXPORT_SYMBOL_GPL(usb_dbg_ep0reg);

void usb_print_ep0reg(void)
{
    USBHAL_DBG("\n GINTSTS:  0x%08x, GINTMASK: 0x%08x, DCFG:     0x%08x, DCTL:     0x%08x,\n DSTS:     0x%08x, DIEPMSK:  0x%08x, DOEPMSK:  0x%08x, DAINT:     0x%08x,\n DAINTMSK: 0x%08x, DIEPCTL0: 0x%08x, DIEPINT0: 0x%08x, DIEPTSIZE0:0x%08x,\n DIEPDMA0: 0x%08x, DIEPDMB0: 0x%08x, DOEPCTL0: 0x%08x, DOEPINT0: 0x%08x,\n DOEPSIZ0: 0x%08x, DOEPDMA0: 0x%08x, unused:   0x%08x, DOEPDMAB0:0x%08x,", 
    	*(volatile unsigned int *)(ZX_USB_BASE+0x14), //GINTSTS
    	*(volatile unsigned int *)(ZX_USB_BASE+0x18), //GINTMAK
    	*(volatile unsigned int *)(ZX_USB_BASE+0x800), //DCFG
    	*(volatile unsigned int *)(ZX_USB_BASE+0x804), //DCTL  line1 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0x808), //DSTS
    	*(volatile unsigned int *)(ZX_USB_BASE+0x810), //DIEPMSK 
    	*(volatile unsigned int *)(ZX_USB_BASE+0x814), //DOEPMSK
    	*(volatile unsigned int *)(ZX_USB_BASE+0x818), //DAINT   line2 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0x81c), //DAINTMSK
    	*(volatile unsigned int *)(ZX_USB_BASE+0x900), //DIEPCTL0
    	*(volatile unsigned int *)(ZX_USB_BASE+0x908), //DIEPINT0
    	*(volatile unsigned int *)(ZX_USB_BASE+0x910), //DIEPTSIZE0  line3 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0x914), //DIEPDMA0
        *(volatile unsigned int *)(ZX_USB_BASE+0x91C), //DIEPDMB0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB00), //DOEPCTL0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB08), //DOEPINT0   line4 end
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB10), //DOEPSIZ0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB14), //DOEPDMA0
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB18), //unused
    	*(volatile unsigned int *)(ZX_USB_BASE+0xB1C) //DOEPDMAB0  line5 end
    	);
}
EXPORT_SYMBOL_GPL(usb_print_ep0reg);
module_init(kset_usb_init);

module_exit(kset_usb_exit);


