/******************************************************************/
#include "global.h"
#include "dwc_otg_driver.h"
#include "config.h"


void USB_isr(WORD32 dwIntNo,WORD32 dwPara)
{
    dwc_otg_pcd_handle_intr(global.g_dwc_otg_dev_t.pcd);

}
void USB_TstDev_InitEnv(void)
{
#if USE_ASIC
    WORD32 i;
    if(0 == global.g_USB_MODE)
    {

    //ͷUSB8bit for usb ctrl
    	REG32(POWER_DOMAIN_ISO) |= (1<<8);
		usdelay(10);

		REG32(POWER_DOMAIN_RST) |= (1<<8);
		usdelay(10);

		REG32(POWER_DOMAIN_POWERON) &= ~(1<<8);
		usdelay(10);
		
		REG32(POWER_DOMAIN_POWERON) |= (1<<8);
		usdelay(10);
		
		REG32(POWER_DOMAIN_RST) &= ~(1<<8);
		usdelay(10);
		
		REG32(POWER_DOMAIN_ISO) &= ~(1<<8);
		usdelay(10);

          //usb  ahb clock enable
        REG32(SOC_MOD_CLKEN0)&=~(1<<4);
        usdelay(20);
        REG32(SOC_MOD_CLKEN0)|=(1<<4);
        //usb  phy clock enable
        REG32(SOC_MOD_CLKEN1)&=~(1<<3);
        usdelay(20);
        REG32(SOC_MOD_CLKEN1)|=(1<<3);

        // usb  ahb reset  ߺ
        REG32(SOC_MOD_RSTEN)&=~(1<<5);
        usdelay(100);
        REG32(SOC_MOD_RSTEN)|=(1<<5);
        usdelay(100);

        // usb  work reset
        REG32(SOC_MOD_RSTEN)&=~(1<<4);
        usdelay(100);
        REG32(SOC_MOD_RSTEN)|=(1<<4);
		usdelay(100);

        //release usb  phy reset 
        REG32(SOC_MOD_RSTEN)&=~(1<<3);
        usdelay(100);
        REG32(SOC_MOD_RSTEN) |= 1<<3;
        usdelay(100);
		
        i = 0;
        while((REG32(SOC_MOD_USBSTATECTRL)&0x2) == 0)
        {
             i++;
             usdelay(20);
             if(i>50000) break;
        }
     }
    else
    {
        //ͷUSB_HSIC9bit for hsic
    	REG32(POWER_DOMAIN_ISO) |= (1<<9);
		usdelay(10);

		REG32(POWER_DOMAIN_RST) |= (1<<9);
		usdelay(10);

		REG32(POWER_DOMAIN_POWERON) &= ~(1<<9);
		usdelay(10);
		
		REG32(POWER_DOMAIN_POWERON) |= (1<<9);
		usdelay(10);
		
		REG32(POWER_DOMAIN_RST) &= ~(1<<9);
		usdelay(10);
		
		REG32(POWER_DOMAIN_ISO) &= ~(1<<9);
		usdelay(10);

        //usb hsic ahb clock enable
        REG32(SOC_MOD_CLKEN0)&=~(1<<2);
        usdelay(20);
        REG32(SOC_MOD_CLKEN0)|=(1<<2);
        //usb hsic phy clock enable
        REG32(SOC_MOD_CLKEN0)&=~(1<<1);
        usdelay(20);
        REG32(SOC_MOD_CLKEN0)|=(1<<1);

        //usb hsic 480M clock enable
        REG32(SOC_MOD_CLKEN0)&=~(1<<0);
        usdelay(20);
        REG32(SOC_MOD_CLKEN0)|=(1<<0);

        // usb hsic ahb reset
        REG32(SOC_MOD_RSTEN)&=~(1<<2);
        usdelay(20);
        REG32(SOC_MOD_RSTEN)|=(1<<2);
        usdelay(10);

        // usb hsic work reset
        REG32(SOC_MOD_RSTEN)&=~(1<<1);
        usdelay(20);
        REG32(SOC_MOD_RSTEN)|=(1<<1);
        //release usb hsic phy reset 
        REG32(SOC_MOD_RSTEN)&=~(1<<0);
        usdelay(20);
        REG32(SOC_MOD_RSTEN)|=(1<<0);

        usdelay(100);
        i = 0;
        while((REG32(SOC_MOD_USBSTATECTRL)&0x1) == 0)
        {
            i++;
            usdelay(20);
            if(i>50000) break;  
        }

#if SYNC_USB_HSIC
        usdelay(20);
		REG32(REG_GPIO_OUT)=1;
        while(REG32(REG_GPIO_IN)!=0xFF);
		usdelay(1);
		REG32(REG_GPIO_OUT)=0;		
#endif
    }
#endif  
#if !USE_ASIC
//usb power on
    REG32(POWER_DOMAIN_POWERON) |= 0x22000;
    usdelay(10);
//usb disable reset 
    REG32(POWER_DOMAIN_RST) &= 0xfffddfff;
    usdelay(10);
//usb disable iso 
    REG32(POWER_DOMAIN_ISO) &= 0xfffddfff;
    usdelay(10);

//open usb0 and usb1
    //usb ahb clock enable
    REG32(SOC_MOD_CLKEN0)&=0xeffffffb;
    usdelay(20);
    REG32(SOC_MOD_CLKEN0)|=0x10000004;
    //usb phy clock enable
    REG32(SOC_MOD_CLKEN1)&=~(3<<16);
    usdelay(20);
    REG32(SOC_MOD_CLKEN1)|=(3<<16);


    // usb ctr reset
    REG32(SOC_MOD_RSTEN)&=0xeffffff7;
    usdelay(20);
    REG32(SOC_MOD_RSTEN)|=0x10000008;

    // usb ahb reset
    REG32(SOC_MOD_RSTEN)&=0xf7fffffb;
    usdelay(20);
    REG32(SOC_MOD_RSTEN)|=0x8000004;
/*    
  usb ctr and ahb reset release ,delay 60us, check usb reset state,
  if the reset state is 0, reset ,if 1,reset release.
*/
#endif
}

void USB_TstDev_Isr(void)
{
        USB_isr(0,0);    //жϷ
}
T_USB_ENUM USB_Need_Enum(WORD32 USB_ADDR)
{
	WORD32 temp = 0;
	temp = DWC_READ_REG32(USB_ADDR+0x14);
	if(((temp>>13)|1)==1)
	{
		return DONOT_NEED_ENUM;
	}
	return NEED_ENUM;
}
unsigned int g_testVal = 0;

WORD32 USB_CDC_Enum(WORD32 USB_ADDR)
{
	WORD32 dwCount=0;
	WORD32 dwCount1=0;
	if(NEED_ENUM == global.g_enum)
	{
		global.g_Connet = 0;
	}
	else
	{
        	global.g_Connet = 1;
	}

	global.g_USB_TIMEOUT	= 10;

	g_testVal = 20/5;
	dwc_otg_driver_probe(USB_ADDR);
	if(global.g_enum == NEED_ENUM)
	{
	while (1)
	{
	//poll mode or interrupt mode
		USB_TstDev_Isr();
#if SYNC_SETADDRESS
	    if (global.g_dwc_otg_dev_t.pcd->request_config == 2)
	    break;
#else
	    //ȴ̬
		if (global.g_dwc_otg_dev_t.pcd->request_config == 1)
			break;
#endif
/* usb_mode =1ʱHSIC,usb_mode =0ʱUSB */
	    if(global.g_USB_MODE == 0)
        {
		    if(0==global.g_Connet)
	        {
			   dwCount++;
#if SIM_EN
			   //usdelay(5000);
#else
               usdelay(1);
#endif
			   if(dwCount>(400*global.g_USB_TIMEOUT))
			   {
				   //return 1;
			   }
		    }
#if SYNC_SETADDRESS            
	        else if(global.g_dwc_otg_dev_t.pcd->request_config == 2)
#else
            else if(global.g_dwc_otg_dev_t.pcd->request_config == 1)
#endif
	        {
	        	break;
	        }
		    else
		    {
			    dwCount1++;
#if SIM_EN
			    //usdelay(5000);
#else
                usdelay(1);
#endif
			    if(dwCount1>(200*global.g_USB_TIMEOUT))
			    {
				    //return 1;  huhuahong
			    }
	        }
        }
     }
		}
     return 0;
}

void Out_callback( WORD32 dwPara, WORD32 dwCause, WORD32 dwDone, WORD32 dwLen)
{
         printf("Out_callback\n");
	*((WORD32 *)dwPara) = dwDone;
	global.dwRxQuit	= 1;
#if SYNC_USB_CTRL
    REG32(ARM_PORTA)=0x77;
#endif

}

void In_callback( WORD32 dwPara, WORD32 dwCause, WORD32 dwDone, WORD32 dwLen)
{
	*((WORD32 *)dwPara) = dwDone;
	global.dwTxQuit	= 1;
#if SYNC_USB_CTRL
        REG32(ARM_PORTA)=0x88;
#endif
}

WORD32 USB_RecvOutData(WORD32 dwEPNo, BYTE *pchBuf, WORD32 dwLen, F_USB_CB fnUsbCb, void *pPara)
{
    dwc_otg_pcd_ep_t *ep = NULL;
    ep = &(global.g_dwc_otg_dev_t.pcd->out_ep[dwEPNo-1]);
    ep->dwc_ep.is_in = 0;
    ep->dwc_ep.num = dwEPNo;
    ep->dwc_ep.data_pid_start = 0;
    ep->dwc_ep.tx_fifo_num = dwEPNo;
    ep->dwc_ep.start_xfer_buff = pchBuf;
    ep->dwc_ep.xfer_buff = pchBuf;
    ep->dwc_ep.xfer_len = 0;
    ep->dwc_ep.xfer_count = 0;
    ep->dwc_ep.fnUsbCb = fnUsbCb;
    ep->dwc_ep.pPara = pPara;
    ep->dwc_ep.total_len = dwLen;
    dwc_otg_ep_start_transfer(global.g_dwc_otg_dev_t.core_if,&ep->dwc_ep);
    return 0;
}

WORD32 USB_SendInData(WORD32 dwEPNo, BYTE *pchBuf, WORD32 dwLen, F_USB_CB fnUsbCb, void *pPara)
{
    dwc_otg_pcd_ep_t *ep = NULL;
    ep = &(global.g_dwc_otg_dev_t.pcd->in_ep[dwEPNo-1]);
    ep->dwc_ep.is_in = 1;
    ep->dwc_ep.num = dwEPNo;
    ep->dwc_ep.data_pid_start = 0;
    ep->dwc_ep.tx_fifo_num = dwEPNo;
    ep->dwc_ep.start_xfer_buff = pchBuf;
    ep->dwc_ep.xfer_buff = pchBuf;
    ep->dwc_ep.fnUsbCb = fnUsbCb;
    ep->dwc_ep.pPara = pPara;
    ep->dwc_ep.xfer_len = 0;
    ep->dwc_ep.xfer_count = 0;
    ep->dwc_ep.total_len = dwLen;
    dwc_otg_ep_start_transfer(global.g_dwc_otg_dev_t.core_if,&ep->dwc_ep);
    return 0;
}

WORD32 usb_read(BYTE *pchBuf,WORD32 dwLen)
{
	WORD32 dwDone;

	global.dwRxQuit=0;

	USB_RecvOutData( 1,(BYTE *)pchBuf,dwLen,Out_callback,(void *)&dwDone);

	while(!global.dwRxQuit)
	{
        USB_TstDev_Isr();
	}

	return dwDone;
}

WORD32 USB_Check_Sync(BYTE *pchBuf, WORD32 dwLen)
{
	WORD32 dwDone;
	WORD32 dwCount = 0;

	global.dwRxQuit=0;
	USB_RecvOutData( 1,(BYTE *)pchBuf,dwLen,Out_callback,(void *)&dwDone);
	dwCount=0;
	while(1)
	{
        USB_TstDev_Isr();
		if(0==global.dwRxQuit)
		{
			dwCount++;
			if(dwCount>(200*global.g_USB_TIMEOUT))
			{
				//return 0;
			}
#if SIM_EN
        	//usdelay(5000);
#else
            usdelay(1);
#endif
		}
		else
		{
			break;
		}
	}

	if(0x5A!=*pchBuf)
	{
		return 0;
	}

	return dwDone;
}
WORD32 usb_write(BYTE *pchBuf,WORD32 dwLen)
{
	WORD32 dwDone;

	global.dwTxQuit=0;

	USB_SendInData(1,pchBuf, dwLen, In_callback,(void *)&dwDone);

	while(!global.dwTxQuit)
	{
    		USB_TstDev_Isr();
	}

	return dwDone;
}

int dwc_otg_driver_probe(WORD32 USB_ADDR)
{
    uint32_t udj = 0;
    uint32_t *ptbase = (uint32_t *)USB_ADDR;
    uint8_t* ptg_dwc_otg_dev_t = (uint8_t* )(&global.g_dwc_otg_dev_t);
    for(udj= 0;udj<sizeof(global.g_dwc_otg_dev_t);udj++)
    {
       ptg_dwc_otg_dev_t[udj] = 0;
    }

    global.g_dwc_otg_dev_t.core_if = dwc_otg_cil_init(ptbase);

    /*
    * Initialize the DWC_otg core.
    */
	dwc_otg_core_init(global.g_dwc_otg_dev_t.core_if);
 
#if SYNC_USB_CTRL
    REG32(ARM_PORTA)=0x11;
#endif
    /*
     * Initialize the PCD,pcd_initժ
     */
    global.g_dwc_otg_dev_t.pcd = dwc_otg_pcd_init(global.g_dwc_otg_dev_t.core_if);

#if SYNC_USB_CTRL
    REG32(ARM_PORTA)=0x22; 
#endif
#if SYNC_USB_HSIC
	//for hsic
	REG32(REG_GPIO_OUT)=2;
	while(REG32(REG_GPIO_IN)!=0xFF);
	usdelay(1);
	REG32(REG_GPIO_OUT)=0;
#endif
	global.g_dwc_otg_dev_t.pcd->otg_dev = (&global.g_dwc_otg_dev_t);
	if(global.g_enum == NEED_ENUM)
	{
		DWC_MODIFY_REG32(&global.g_dwc_otg_dev_t.core_if->core_global_regs->gahbcfg, 0, 1);
	}
	return 0;
}
static inline void delay(unsigned long loops)
{
    /*
	__asm__ volatile ("1:\n" "subs %0, %1, #1\n"
			  "bne 1b":"=r" (loops):"0"(loops));
	*/
}
static inline void udelay(unsigned long us)
{
	delay(us * 200); /* approximate */
}

#if 0
void usdelay(unsigned us)
{
	udelay(us);
}
#endif
extern  void ep0_out_start(dwc_otg_core_if_t * core_if,dwc_otg_pcd_t * pcd);
extern void dwc_otg_ep_activate(dwc_otg_core_if_t * core_if, dwc_ep_t * ep);
extern void active_allep(dwc_otg_pcd_t * pcd);
typedef struct usb_record
{
	WORD32 address;
	WORD32 value;

}T_usb_record;
T_usb_record usb_record[1000];
WORD32 index = 0;

void usb_printf (WORD32 *address)
{
		usb_record[index].address = (WORD32)address;
		usb_record[index].value = *address;
		index = (index+1)%1000;
		
}

static inline BYTE get_boot_mode(void)
{
	return (*(WORD32*)SYS_BOOTSEL_BASE &0x3);
}

int tsp_usb_init(void)
{
	WORD32 retVal = 0;
	WORD32 usb_addr = 0;
	BYTE boot_mode = get_boot_mode();
	data_init();
	/*add by sunyunchen*/
	if(2 == boot_mode)
	{
		printf("hsic\n");
		global.g_USB_MODE = 1;
	    usb_addr = SYS_USB_HSIC_BASE;
	}
	else 
	{
		printf("usb\n");
		global.g_USB_MODE = 0;
        usb_addr = SYS_USB_BASE;
	}
	if((REG32(usb_addr+DWC_DEV_GLOBAL_REG_OFFSET)&0x7f0)!=0)//dcfg register
	{
		global.g_enum =DONOT_NEED_ENUM; 
	}
	if(NEED_ENUM == global.g_enum)
	{
	         USB_TstDev_InitEnv();
	}
	else
	{
		global.g_dwc_otg_pcd_tp.ep0state = EP0_IDLE;
		global.dwRxQuit = 1;
		global.dwTxQuit = 1;
		global.g_dwc_otg_pcd_tp.request_config = 1;		
	}

	retVal = USB_CDC_Enum(usb_addr);
	
	return retVal;
}


